/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Legend;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.Vec3f;
import java.awt.Color;
import java.awt.Rectangle;

abstract class DiscreteLegend
extends Legend {
    protected static final int LABEL_BEGIN_ALIGN = 0;
    protected static final int LABEL_MIDDLE_ALIGN = 1;
    protected static final int LABEL_END_ALIGN = 2;
    private static final Vec3f incrementVectorDefault = new Vec3f(Vec3f.xAxis);
    private static final Vec3f endVectorDefault = new Vec3f(Vec3f.zAxis);
    protected Vec3f incrementVector;
    protected Vec3f endVector;
    protected String label;
    protected String primaryLabel;
    protected TextStyle labelStyle;
    protected int labelPosition;
    protected float labelHeight;
    protected Color backgroundColor = Color.lightGray;
    protected Vec3f visBodySize;
    protected Vec3f legendPosition;
    protected Vec3f legendBodySize;
    protected int relativePosition = 3;
    protected int numRows = 1;
    protected int maxNumColumns = 1;
    protected int maxNumRows = 1;
    protected int numLabelChars;
    protected int start;
    protected int end;
    protected int numColumns;
    protected float thumb = 0.0f;
    protected double labelLength;
    protected Vec3f stepVector;
    protected boolean floor = false;
    protected boolean defaultSize = true;
    static final float FLOAT2INT_D = 1.0E-4f;

    public DiscreteLegend(Mapper aMapper) {
        super(aMapper);
        this.incrementVector = incrementVectorDefault;
        this.endVector = endVectorDefault;
        this.labelStyle = new TextStyle();
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
        this.primaryLabel = null;
    }

    public void setLabel(String aLabel, String aPrimaryLabel) {
        this.label = aLabel;
        this.primaryLabel = aPrimaryLabel;
    }

    public void setIntervals(int count) {
        this.intervals = count;
    }

    public void setStyles(TextStyle aValueStyle, TextStyle aLabelStyle) {
        this.valueStyle = aValueStyle;
        this.labelStyle = aLabelStyle;
    }

    public void setLabelStyles(TextStyle aLabelStyle) {
        this.labelStyle = aLabelStyle;
    }

    public TextStyle getLabelStyles() {
        return this.labelStyle;
    }

    public void scaleIncrementVector(float factor) {
        this.incrementVector.normalize();
        this.incrementVector.scale(factor);
    }

    public void setPosition(int aPosition, Vec3f aSize, Vec3f aOffset) {
        this.relativePosition = aPosition;
        this.visBodySize = aSize;
        this.legendPosition = aOffset;
    }

    public void setSize(Vec3f aSize) {
        this.legendBodySize = aSize;
    }

    public void setColors(Color aValuesColor, Color aLabelColor) {
        this.valueStyle.setColor(aValuesColor);
        this.labelStyle.setColor(aLabelColor);
    }

    @Override
    public void addLegend(Channel ch, boolean visible) {
        if (!visible) {
            return;
        }
        this.vLegendOffset = 0.0f;
        this.hLegendOffset = 0.0f;
        ch.glSelect2DFont(this.labelStyle.createFont());
        this.labelHeight = (float)ch.glGetTextHeight();
        ch.glSelect2DFont(this.valueStyle.createFont());
        this.valueHeight = (float)ch.glGetTextHeight();
        this.tickSize = this.valueHeight / 2.0f;
        switch (this.relativePosition) {
            default: {
                this.endVector = new Vec3f(Vec3f.yAxis);
                this.endVector.scale(this.labelHeight);
                this.incrementVector = new Vec3f(Vec3f.xAxis);
                break;
            }
            case 0: {
                this.incrementVector = new Vec3f(Vec3f.yAxis);
                this.endVector = new Vec3f(Vec3f.xAxis);
                this.endVector.scale(this.labelHeight);
            }
        }
        ch.glPushMatrix();
        this.orientLegend(ch);
        Vec3f point = new Vec3f(this.origin);
        point.add(this.endVector);
        this.addValues(ch, point, this.valueStyle.getMajorJustify(), this.valueStyle.getMinorJustify());
        this.addGeometry(ch);
        this.drawBBox(ch);
        ch.glPopMatrix();
    }

    public Rectangle getBoundingBox(Channel ch, boolean visible) {
        if (!visible) {
            return null;
        }
        double[] upperLeft = new double[3];
        double[] lowerRight = new double[3];
        upperLeft[2] = this.legendPosition.z;
        lowerRight[2] = this.legendPosition.z;
        switch (this.relativePosition) {
            default: {
                upperLeft[0] = this.legendPosition.x - (this.legendBodySize.x - this.hLegendOffset) / 2.0f;
                upperLeft[1] = this.legendPosition.y - this.labelHeight;
                break;
            }
            case 0: {
                upperLeft[0] = this.legendPosition.x;
                upperLeft[1] = this.legendPosition.y + (this.legendBodySize.y - this.vLegendOffset) / 2.0f - this.labelHeight;
            }
        }
        lowerRight[0] = upperLeft[0] + (double)this.legendBodySize.x;
        lowerRight[1] = upperLeft[1] - (double)this.legendBodySize.y + (double)this.labelHeight;
        upperLeft[2] = this.legendPosition.z;
        lowerRight[2] = this.legendPosition.z;
        if (this.floor) {
            ch.glRotate(-90.0, 1.0, 0.0, 0.0);
        }
        ch.gluProject(upperLeft, upperLeft);
        ch.gluProject(lowerRight, lowerRight);
        if (this.floor) {
            ch.glRotate(90.0, 1.0, 0.0, 0.0);
        }
        int xo = (int)upperLeft[0] + 2;
        int yo = (int)upperLeft[1] + 2;
        int dx = (int)lowerRight[0] - (int)upperLeft[0] - 2;
        int dy = (int)lowerRight[1] - (int)upperLeft[1] - 2;
        Rectangle box = new Rectangle(xo, yo, dx, dy);
        return box;
    }

    public void moveThumb(Channel ch, float dx, float dy) {
        Vec3f point = new Vec3f(this.origin);
        point.add(this.endVector);
        float incr = (float)this.maxNumRows * dy / (float)(this.numRows - this.maxNumRows);
        this.thumb -= incr;
        this.thumb = Math.min(1.0f, Math.max(0.0f, this.thumb));
        float act_start = this.thumb * (float)(this.numRows - this.maxNumRows);
        this.start = (int)Math.floor(act_start);
        ch.glPushMatrix();
        this.setOrientation(ch);
        ch.glPushMatrix();
        ch.glTranslate(0.0, -((float)this.start - act_start) * this.stepVector.y, 0.0);
        this.start *= this.maxNumColumns;
        this.end = Math.min(this.values.length, this.start + (this.maxNumRows + 1) * this.maxNumColumns);
        this.addValues(ch, point, this.valueStyle.majorJustify, this.valueStyle.minorJustify);
        this.addGeometry(ch);
        ch.glPopMatrix();
        this.drawBBox(ch);
        ch.glPopMatrix();
    }

    protected void orientLegend(Channel ch) {
        if (this.floor) {
            ch.glRotate(-90.0, 1.0, 0.0, 0.0);
            ch.glSelect2DFont(this.valueStyle.createFont());
            this.valueHeight = (float)ch.glGetTextHeight();
            ch.glSelect2DFont(this.labelStyle.createFont());
            this.labelHeight = (float)ch.glGetTextHeight();
        }
        this.hLegendOffset = this.legendBodySize.x;
        this.vLegendOffset = this.legendBodySize.y;
        Vec3f vec = new Vec3f(this.legendPosition);
        this.incrementVector = new Vec3f(Vec3f.xAxis);
        this.stepVector = new Vec3f(Vec3f.yAxis);
        float len = this.findMaxValueLength(ch, true);
        len += 2.0f * this.valueHeight;
        ch.glSelect2DFont(this.labelStyle.createFont());
        String str = null;
        if (this.label != null) {
            str = this.label.trim();
            this.labelLength = ch.glGetTextWidth("  " + str.substring(0, Math.min(str.length(), this.labelStyle.minChars)));
        } else {
            this.labelLength = 0.0;
        }
        boolean maxsize = this.hLegendOffset >= len * (float)this.intervals;
        float tsize = this.hLegendOffset > len ? Math.min(this.hLegendOffset, len * (float)this.intervals) : len;
        float tempSize = this.defaultSize ? (float)Math.max(this.labelLength + (double)this.valueHeight, (double)tsize) : this.hLegendOffset;
        if (str != null) {
            ch.glSelect2DFont(this.labelStyle.createFont());
            this.labelLength = ch.glGetTextWidth("  ");
            float size = (float)((double)(tempSize - this.valueHeight / 2.0f) - this.labelLength);
            int i = str.length();
            while (ch.glGetTextWidth(str.substring(0, i)) > (double)size && (i = DiscreteLegend.ClippingIndex(str, i - 1)) != 0) {
            }
            if (i == 0) {
                for (i = str.length(); i >= 0 && !(ch.glGetTextWidth(str.substring(0, i)) < (double)size); --i) {
                }
            }
            this.numLabelChars = i;
            this.labelLength += ch.glGetTextWidth(str.substring(0, this.numLabelChars));
        }
        if (this.defaultSize) {
            this.legendBodySize.x = (float)Math.max(this.labelLength + (double)this.valueHeight, (double)tsize);
        }
        this.hLegendOffset = Math.max(this.hLegendOffset, this.legendBodySize.x);
        this.stepVector.scale(1.5f * this.valueHeight);
        switch (this.relativePosition) {
            default: {
                if (maxsize) {
                    this.maxNumColumns = this.intervals;
                    this.numRows = 1;
                    this.maxNumRows = 1;
                } else {
                    this.maxNumColumns = Math.max(1, (int)(this.legendBodySize.x / len + 1.0E-4f));
                    this.maxNumColumns = Math.min(this.maxNumColumns, this.intervals);
                    this.maxNumRows = (int)Math.floor(((double)this.legendBodySize.y - 1.2 * (double)this.labelHeight) / (double)this.stepVector.y + 0.2);
                    this.numRows = (int)Math.ceil((double)this.intervals / (double)this.maxNumColumns);
                    this.maxNumRows = Math.max(this.maxNumRows, 1);
                    if (this.maxNumRows > this.numRows) {
                        this.maxNumRows = this.numRows;
                    }
                    while (this.numRows * (this.maxNumColumns - 1) >= this.intervals) {
                        --this.maxNumColumns;
                    }
                }
                this.incrementVector.scale(this.legendBodySize.x / (float)this.maxNumColumns);
                if (this.defaultSize) {
                    this.legendBodySize.x = (float)Math.max(this.labelLength + (double)this.valueHeight, (double)((float)this.maxNumColumns * this.incrementVector.x));
                    this.legendBodySize.y = (float)((double)((float)this.maxNumRows * this.stepVector.y) + 1.2 * (double)this.labelHeight);
                }
                ch.glTranslate(vec.x + this.valueHeight / 2.0f - (this.legendBodySize.x - this.hLegendOffset) / 2.0f, (double)vec.y - 1.2 * (double)this.labelHeight - 1.2 * (double)this.valueHeight, vec.z);
                break;
            }
            case 0: {
                this.maxNumRows = (int)Math.floor(((double)this.legendBodySize.y - 1.2 * (double)this.labelHeight) / (double)this.stepVector.y + 0.2);
                this.maxNumColumns = 1;
                this.numRows = (int)Math.ceil((double)this.intervals / (double)this.maxNumColumns);
                if (this.maxNumRows > this.numRows) {
                    this.maxNumRows = this.numRows;
                }
                this.incrementVector.scale(this.legendBodySize.x / (float)this.maxNumColumns);
                if (this.defaultSize) {
                    this.legendBodySize.x = (float)this.maxNumColumns * this.incrementVector.x;
                    this.legendBodySize.y = (float)((double)((float)this.maxNumRows * this.stepVector.y) + 1.2 * (double)this.labelHeight);
                }
                ch.glTranslate(vec.x + this.valueHeight / 2.0f, (double)vec.y - 1.2 * (double)this.labelHeight - 1.2 * (double)this.valueHeight + (double)((this.legendBodySize.y - this.vLegendOffset) / 2.0f), vec.z);
            }
        }
        this.start = 0;
        this.end = Math.min(this.values.length, this.maxNumColumns * this.maxNumRows);
        this.thumb = 0.0f;
    }

    @Override
    protected void addValues(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify) {
        ch.glColor(this.valueStyle.color);
        ch.glSelect2DFont(this.valueStyle.createFont());
        double valueLen = this.incrementVector.x - 2.0f * this.valueHeight;
        valueLen -= ch.glGetTextWidth(" ");
        ch.glTextAlign(0, 1);
        for (int i = 0; i < this.values.length; ++i) {
            float mappedValue = this.mapper.getMappedValue(this.values[i]);
            if (mappedValue < (float)this.start || mappedValue >= (float)this.end) continue;
            Vec3f increment = new Vec3f(this.incrementVector);
            Vec3f current = new Vec3f(increment);
            Vec3f step = new Vec3f(this.stepVector.x, -this.stepVector.y, this.stepVector.z);
            current.scale((int)(mappedValue - (float)this.start) % this.maxNumColumns);
            step.scale((int)(mappedValue - (float)this.start) / this.maxNumColumns);
            current.add(step);
            String str = this.formattedValues[i].trim();
            int maxChars = str.length() - 1;
            while (ch.glGetTextWidth(str) > valueLen && (maxChars = DiscreteLegend.ClippingIndex(str, maxChars)) != 0) {
                str = str.substring(0, maxChars);
                --maxChars;
            }
            if (maxChars == 0) {
                maxChars = str.length();
                while (ch.glGetTextWidth(str) > valueLen && maxChars >= 2) {
                    str = str.substring(0, --maxChars);
                }
            }
            ch.gl2DText(str, (double)current.x + 1.4 * (double)this.valueHeight, current.y + this.valueHeight / 2.0f, current.z);
        }
    }

    protected void addLabel(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify, boolean flipEndDirection) {
    }

    protected void addLabelsBox(Channel ch) {
        ch.glPushMatrix();
        this.setOrientation(ch);
        this.addLabel(ch);
        this.drawBBox(ch);
        ch.glPopMatrix();
    }

    protected void addLabel(Channel ch) {
        if (this.label != null) {
            double yo = 1.2 * (double)this.valueHeight + 0.7 * (double)this.labelHeight;
            ch.glColor(this.labelStyle.color);
            ch.glSelect2DFont(this.labelStyle.createFont());
            ch.glTextAlign(1, 1);
            ch.gl2DText(this.label.trim().substring(0, this.numLabelChars), this.labelLength / 2.0, yo, 0.0);
        }
    }

    @Override
    protected abstract void addGeometry(Channel var1);

    protected void drawBBox(Channel ch) {
        double y1;
        double yo;
        double xo = -this.valueHeight / 2.0f;
        double x1 = (double)this.legendBodySize.x + xo;
        if (this.label != null) {
            yo = (double)this.labelHeight * 0.7 + 1.2 * (double)this.valueHeight;
            y1 = yo - (double)this.legendBodySize.y + (double)(this.labelHeight / 2.0f);
        } else {
            yo = (double)this.labelHeight * 0.2 + 1.2 * (double)this.valueHeight;
            y1 = yo - (double)this.legendBodySize.y + 0.9 * (double)this.labelHeight;
        }
        ch.glColor(this.geomColor);
        ch.glBegin(1);
        ch.glVertex(0.0, yo, 0.0);
        ch.glVertex(xo, yo, 0.0);
        ch.glVertex(xo, y1, 0.0);
        ch.glVertex(x1, y1, 0.0);
        ch.glVertex(x1, yo, 0.0);
        if (x1 > this.labelLength) {
            ch.glVertex(this.labelLength, yo, 0.0);
        }
        ch.glEnd();
    }

    private void setOrientation(Channel ch) {
        if (this.floor) {
            ch.glRotate(-90.0, 1.0, 0.0, 0.0);
        }
        switch (this.relativePosition) {
            default: {
                ch.glTranslate(this.legendPosition.x + this.valueHeight / 2.0f - (this.legendBodySize.x - this.hLegendOffset) / 2.0f, (double)this.legendPosition.y - 1.2 * (double)this.labelHeight - 1.2 * (double)this.valueHeight, this.legendPosition.z);
                break;
            }
            case 0: {
                ch.glTranslate(this.legendPosition.x + this.valueHeight / 2.0f, (double)this.legendPosition.y - 1.2 * (double)this.labelHeight - 1.2 * (double)this.valueHeight + (double)((this.legendBodySize.y - this.vLegendOffset) / 2.0f), this.legendPosition.z);
            }
        }
    }

    public boolean isScrollable() {
        return this.numRows > this.maxNumRows;
    }
}

