/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.ColorMapper;
import com.sas.graphics.util.visualize.DiscreteColorLegend;
import com.sas.graphics.util.visualize.DiscreteColorMapper;
import com.sas.graphics.util.visualize.DiscreteColorMapper2;
import com.sas.graphics.util.visualize.DiscreteColorMarkerMapper;
import com.sas.graphics.util.visualize.DiscreteColorMarkerMapper2;
import com.sas.graphics.util.visualize.ExtendedShapes;
import com.sas.graphics.util.visualize.Shapes;
import com.sas.graphics.util.visualize.Vec3f;
import java.awt.Color;

class DiscreteColorLegend2
extends DiscreteColorLegend {
    boolean color = true;
    boolean shape = true;
    Color edgeColor = null;
    Color markerColor = null;
    boolean[] joins = null;
    boolean[] marks = null;
    int segIndex = -1;
    int legendMarker = 0;

    public DiscreteColorLegend2(DiscreteColorMapper aMapper, boolean s, boolean c) {
        super(aMapper);
        this.shape = s;
        if (s) {
            this.color = c;
        }
    }

    public DiscreteColorLegend2(DiscreteColorMapper aMapper) {
        super(aMapper);
    }

    protected void setColor(boolean c) {
        this.color = c;
        if (!c) {
            this.shape = true;
        }
    }

    protected void setShape(boolean s) {
        this.shape = s;
        if (!s) {
            this.color = true;
        }
    }

    protected void setEdgeColor(Color edge) {
        this.edgeColor = edge;
    }

    protected void setJoins(boolean[] s) {
        this.joins = s;
    }

    protected void setMarks(boolean[] s) {
        this.marks = s;
    }

    protected void setLegendMarker(int aMarker) {
        this.legendMarker = aMarker;
    }

    @Override
    protected void addGeometry(Channel ch) {
        if (!this.shape) {
            super.addGeometry(ch);
            return;
        }
        double vsz = 0.5 * (double)this.valueHeight;
        double hsz = 0.5 * this.boxwidth;
        DiscreteColorMapper cMapper = null;
        if (this.color) {
            cMapper = (DiscreteColorMapper)this.mapper;
        } else {
            ch.glColor(this.geomColor);
        }
        int polygonMode = ch.getPolygonMode();
        if (this.edgeColor != null) {
            ch.glEdgeColor(this.edgeColor);
            ch.glPolygonMode(4);
        }
        block19: for (int i = 0; i < this.intervals; ++i) {
            Vec3f[] points;
            int mappedValue = (int)this.mapper.getMappedValue(this.values[i]);
            if (mappedValue < this.start || mappedValue >= this.end) continue;
            Vec3f current = new Vec3f(this.incrementVector);
            Vec3f step = new Vec3f(this.stepVector.x, -this.stepVector.y, this.stepVector.z);
            current.scale((mappedValue - this.start) % this.maxNumColumns);
            step.scale((mappedValue - this.start) / this.maxNumColumns);
            current.add(step);
            double xo = (double)current.x + hsz / 2.0;
            double yo = (double)current.y + vsz;
            double zo = (double)current.z + hsz / 2.0;
            if (mappedValue == this.segIndex) {
                int offset;
                ch.glColor(Color.lightGray);
                ch.glBegin(2);
                ch.glNormal(0.0, 1.0, 0.0);
                ch.glVertex(xo - hsz, current.y, (double)current.z - hsz);
                ch.glVertex(xo - hsz, current.y, (double)current.z + hsz);
                ch.glVertex(xo + hsz, current.y, (double)current.z + hsz);
                ch.glVertex(xo + hsz, current.y, (double)current.z - hsz);
                ch.glEnd();
                int n = offset = cMapper instanceof DiscreteColorMapper2 ? ((DiscreteColorMapper2)cMapper).colorOffset : 0;
                if (offset == 0) {
                    ch.glColor(((ColorMapper)cMapper).getMappedRGBColor(this.values[i]));
                    ExtendedShapes.addBox(ch, xo, yo, zo, hsz, 2.0 * vsz, hsz);
                    continue;
                }
                DiscreteColorMapper2 cMapper2 = (DiscreteColorMapper2)cMapper;
                ch.glColor(cMapper2.getMappedRGBColor(-offset));
                ExtendedShapes.addBox(ch, xo, yo - vsz / 2.0, zo, hsz, vsz, hsz);
                ch.glColor(cMapper2.getMappedRGBColor(-offset + 1));
                ExtendedShapes.addBox(ch, xo, yo + vsz / 2.0, zo, hsz, vsz, hsz);
                continue;
            }
            if (this.color) {
                ch.glColor(((ColorMapper)cMapper).getMappedRGBColor(this.values[i]));
            }
            int type = mappedValue % 10;
            if (cMapper instanceof DiscreteColorMarkerMapper2) {
                type = ((DiscreteColorMarkerMapper2)cMapper).getMappedShape(this.values[i]);
            }
            if (cMapper instanceof DiscreteColorMarkerMapper && !(cMapper instanceof DiscreteColorMarkerMapper2)) {
                DiscreteColorMarkerMapper cmMapper = (DiscreteColorMarkerMapper)cMapper;
                type = this.legendMarker;
                if (type == 6) {
                    type = cmMapper.getMappedShapes() == null ? mappedValue % 8 + 1 : cmMapper.getMappedShape(this.values[i]);
                }
                if (type != 0 && this.joins != null && this.joins[mappedValue % this.joins.length]) {
                    points = new Vec3f[3];
                    points[0] = new Vec3f(current.x - (float)hsz, (float)yo, (float)zo);
                    points[1] = new Vec3f(current.x + (float)hsz * 2.0f, (float)yo, (float)zo);
                    Shapes.addThickLine(ch, points, vsz / 4.0, false);
                }
                switch (type) {
                    default: {
                        break;
                    }
                    case 1: {
                        ExtendedShapes.addBox(ch, xo, yo, zo, hsz, vsz, hsz);
                        break;
                    }
                    case 2: {
                        ExtendedShapes.addCircle(ch, xo, yo, zo, Math.min(hsz, vsz) / 2.0, 45.0);
                        break;
                    }
                    case 3: {
                        ExtendedShapes.addCross(ch, xo, yo, zo, hsz, vsz);
                        break;
                    }
                    case 4: {
                        ch.glPolygonMode(3);
                        Shapes.setPrecision(16);
                        ExtendedShapes.addSphere(ch, xo, yo, zo, Math.min(hsz, vsz) / 1.5);
                        ch.glPolygonMode(polygonMode);
                        break;
                    }
                    case 5: {
                        ExtendedShapes.addPyramid(ch, xo, yo + vsz / 4.0, zo, hsz, vsz);
                        break;
                    }
                }
                continue;
            }
            if (this.joins != null && this.joins[mappedValue % this.joins.length]) {
                points = new Vec3f[3];
                points[0] = new Vec3f(current.x - (float)hsz, (float)yo, (float)zo);
                points[1] = new Vec3f(current.x + (float)hsz * 2.0f, (float)yo, (float)zo);
                Shapes.addThickLine(ch, points, vsz / 4.0, false);
            }
            if (this.marks != null && !this.marks[mappedValue % this.marks.length]) continue;
            switch (type) {
                default: {
                    continue block19;
                }
                case 1: {
                    ExtendedShapes.addBox(ch, xo, yo, zo, hsz, vsz, hsz);
                    continue block19;
                }
                case 8: {
                    ExtendedShapes.addCircle(ch, xo, yo, zo, Math.min(hsz, vsz) / 2.0, 45.0);
                    continue block19;
                }
                case 2: {
                    ExtendedShapes.addCross(ch, xo, yo, zo, hsz, vsz);
                    continue block19;
                }
                case 9: {
                    ExtendedShapes.addTriangle(ch, true, xo, yo, zo, hsz, vsz);
                    continue block19;
                }
                case 0: {
                    ch.glPolygonMode(3);
                    Shapes.setPrecision(16);
                    ExtendedShapes.addSphere(ch, xo, yo, zo, Math.min(hsz, vsz) / 1.5);
                    ch.glPolygonMode(polygonMode);
                    continue block19;
                }
                case 5: {
                    Shapes.setPrecision(16);
                    ch.glPolygonMode(3);
                    ExtendedShapes.addVCone(ch, xo, yo + vsz / 4.0, zo, hsz / 1.5, vsz * 1.25);
                    ch.glPolygonMode(polygonMode);
                    continue block19;
                }
                case 6: {
                    Shapes.setPrecision(16);
                    ch.glPolygonMode(3);
                    ExtendedShapes.addVCylinder(ch, xo, yo, zo, hsz / 2.0, vsz);
                    ch.glPolygonMode(polygonMode);
                    continue block19;
                }
                case 7: {
                    ExtendedShapes.addDiamond(ch, xo, yo, zo, hsz, vsz * 1.25);
                    continue block19;
                }
                case 3: {
                    ExtendedShapes.addPyramid(ch, xo, yo + vsz / 4.0, zo, hsz, vsz);
                    continue block19;
                }
                case 4: {
                    ExtendedShapes.addStar(ch, xo, yo, zo, hsz / 1.5, vsz / 4.0);
                }
            }
        }
    }
}

