/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.MissingValues;
import com.sas.graphics.util.visualize.DataCell;
import com.sas.graphics.util.visualize.DataModel;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.SimpleDataTable;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.table.StaticColumnInfoInterface;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;

public class DataModelProcessor {
    private DataModel dmIn;
    private StaticRowTemplateTableInterface rdIn;
    private DataModel dmOut;
    private SimpleDataTable sdtOut;
    private int classCount;
    private int[] classVars;
    private Hashtable[] classHash;
    private Object[][] classValues;
    private int respCount;
    private int[] respVars;
    private int[] respStatistics;
    private DataCell[][] respTotals;
    private DataCell[][][][] cumTotals;
    private DataCell[][][][][] cells;
    private boolean processingNeeded;
    protected boolean ignoreEntireRow;
    protected boolean showStatistic;
    protected boolean noSummarization;
    protected boolean missingRetained;
    protected String missingSymbol;
    protected boolean g100;
    protected Variable gVariable;
    protected int gIndex;

    protected DataModelProcessor(DataModel dmInput) {
        this.dmOut = this.dmIn = dmInput;
        this.rdIn = (StaticRowTemplateTableInterface)this.dmIn.getRectangularData();
        this.respCount = 0;
        this.classCount = 0;
        this.processingNeeded = false;
        this.ignoreEntireRow = true;
        this.showStatistic = true;
        this.noSummarization = false;
        this.missingRetained = true;
        this.missingSymbol = "Missing";
        this.g100 = true;
        this.gVariable = null;
        this.gIndex = -1;
    }

    public DataModel process(IndependentVariable[] indVarsIn, DependentVariable[] depVarsIn) {
        int i;
        int[] dim = new int[4];
        boolean statisticsNeeded = false;
        for (int ii = 0; ii < indVarsIn.length; ++ii) {
            if (indVarsIn[ii] == null || indVarsIn[ii].aux == null) continue;
            return this.dmIn;
        }
        if (this.noSummarization && !this.missingRetained) {
            return this.dmIn;
        }
        for (i = 0; i < indVarsIn.length; ++i) {
            if (indVarsIn[i] == null || indVarsIn[i].index == -1) continue;
            IndependentVariable dummy = new IndependentVariable(indVarsIn[i]);
            dummy.index = indVarsIn[i].indexIn;
            if (!this.dmIn.isOccurancesUnique(dummy)) {
                statisticsNeeded = true;
            }
            ++this.classCount;
        }
        if (this.classCount == 0) {
            return this.dmIn;
        }
        for (i = 0; i < depVarsIn.length; ++i) {
            if (depVarsIn[i] == null || depVarsIn[i].index == -1) continue;
            ++this.respCount;
            if (depVarsIn[i].statistic != 0) {
                this.processingNeeded = true;
            }
            if (depVarsIn[i].statistic != 3 && depVarsIn[i].statistic != 4 && depVarsIn[i].statistic != 8 && depVarsIn[i].statistic != 5 && depVarsIn[i].statistic != 10 && depVarsIn[i].statistic != 9 && depVarsIn[i].statistic != 6) continue;
            statisticsNeeded = true;
        }
        if (!(this.missingRetained || this.processingNeeded && statisticsNeeded)) {
            return this.dmIn;
        }
        this.classVars = new int[this.classCount];
        this.classCount = 0;
        for (i = 0; i < indVarsIn.length; ++i) {
            if (indVarsIn[i] == null || indVarsIn[i].index == -1) continue;
            if (indVarsIn[i] == this.gVariable) {
                this.gIndex = this.classCount;
            }
            this.classVars[this.classCount] = indVarsIn[i].indexIn;
            ++this.classCount;
            indVarsIn[i].index = indVarsIn[i].index;
        }
        for (i = 0; i < depVarsIn.length; ++i) {
            if (depVarsIn[i] == null || depVarsIn[i].statistic != 0) continue;
            depVarsIn[i].statistic = 1;
        }
        this.respVars = new int[this.respCount];
        int[] respIndiciesIn = new int[this.respCount];
        this.respStatistics = new int[this.respCount];
        this.respCount = 0;
        for (i = 0; i < depVarsIn.length; ++i) {
            if (depVarsIn[i] == null || depVarsIn[i].statistic == 0 || depVarsIn[i].index == -1) continue;
            this.respVars[this.respCount] = depVarsIn[i].indexIn;
            this.respStatistics[this.respCount] = depVarsIn[i].statistic == 1 ? 7 : depVarsIn[i].statistic;
            respIndiciesIn[this.respCount] = i;
            ++this.respCount;
        }
        if (this.respCount == 0) {
            boolean responseFound = false;
            for (i = 0; i < depVarsIn.length && !responseFound; ++i) {
                if (depVarsIn[i] == null || depVarsIn[i].statistic != 1 || depVarsIn[i].index != -1) continue;
                responseFound = true;
                this.respVars[this.respCount] = -1;
                this.respStatistics[this.respCount] = 3;
                respIndiciesIn[this.respCount] = i;
                ++this.respCount;
            }
        }
        for (i = 0; i < this.respCount; ++i) {
            depVarsIn[respIndiciesIn[i]].index = this.classCount + i;
        }
        this.hashClassifiers();
        for (i = 0; i < 4; ++i) {
            dim[i] = i < this.classCount ? this.classHash[i].size() : 1;
        }
        int cellsFilled = this.makeCells(dim);
        this.getClassifierValues();
        this.dmOut = new DataModel();
        this.sdtOut = new SimpleDataTable(cellsFilled, this.classCount + this.respCount);
        this.dmOut.setMaxObservations(cellsFilled);
        this.dmOut.setRectangularData((StaticTableInterface)this.sdtOut);
        boolean savedFlag = this.showStatistic;
        if (cellsFilled == this.dmIn.getRowCount()) {
            this.showStatistic = false;
        }
        this.makeNamesAndTypes();
        this.showStatistic = savedFlag;
        int outputObs = 0;
        for (i = 0; i < dim[0]; ++i) {
            for (int j = 0; j < dim[1]; ++j) {
                for (int k = 0; k < dim[2]; ++k) {
                    for (int l = 0; l < dim[3]; ++l) {
                        if (this.cells[i][j][k][l][0] == null) continue;
                        this.createObservation(outputObs, i, j, k, l);
                        ++outputObs;
                    }
                }
            }
        }
        return this.dmOut;
    }

    private void hashClassifiers() {
        int cIndex;
        int[] classifierCounters = new int[this.classCount];
        this.classHash = new Hashtable[this.classCount];
        for (cIndex = 0; cIndex < this.classCount; ++cIndex) {
            this.classHash[cIndex] = new Hashtable();
        }
        try {
            for (int i = 0; i < Math.min(this.dmIn.getRowCount(), this.dmIn.getMaxObservations()); ++i) {
                for (cIndex = 0; cIndex < this.classCount; ++cIndex) {
                    Object classifierObj = this.rdIn.getCell(i + 1, this.classVars[cIndex] + 1);
                    if (classifierObj == null || classifierObj instanceof MissingValues) {
                        if (!this.missingRetained) continue;
                        classifierObj = this.missingSymbol;
                    }
                    if (this.classHash[cIndex].containsKey(classifierObj)) continue;
                    int n = cIndex;
                    int n2 = classifierCounters[n];
                    classifierCounters[n] = n2 + 1;
                    this.classHash[cIndex].put(classifierObj, new Integer(n2));
                }
            }
        }
        catch (TableException e) {
            return;
        }
    }

    private void getClassifierValues() {
        this.classValues = new Object[this.classCount][];
        for (int classifier = 0; classifier < this.classCount; ++classifier) {
            this.classValues[classifier] = new Object[this.classHash[classifier].size()];
            Enumeration keys = this.classHash[classifier].keys();
            while (keys.hasMoreElements()) {
                Object value = keys.nextElement();
                this.classValues[classifier][((Integer)this.classHash[classifier].get(value)).intValue()] = value;
            }
        }
    }

    private void makeNamesAndTypes() {
        String sourceVarLabel;
        String sourceVarName;
        String[] columnInfoNames;
        StaticColumnInfoInterface info;
        int i;
        try {
            for (i = 0; i < this.classCount; ++i) {
                if (this.rdIn instanceof StaticColumnInfoInterface) {
                    info = (StaticColumnInfoInterface)this.rdIn;
                    columnInfoNames = info.getColumnInfoNames();
                    sourceVarName = (String)info.getColumnInfo(this.classVars[i] + 1, columnInfoNames[0]);
                } else {
                    sourceVarName = (String)((StaticColumnLabelInterface)this.rdIn).getColumnLabel(this.classVars[i] + 1);
                }
                sourceVarLabel = this.dmIn.getName(this.classVars[i]);
                this.sdtOut.setColumnName(i + 1, sourceVarName);
                this.sdtOut.setColumnLabel(i + 1, sourceVarLabel);
                this.sdtOut.setColumnClass(i + 1, this.rdIn.getColumnClass(this.classVars[i] + 1));
            }
        }
        catch (TableException e) {
            return;
        }
        i = this.classCount + 1;
        int respIndex = 0;
        while (respIndex < this.respCount) {
            try {
                if (this.respVars[respIndex] >= 0) {
                    if (this.rdIn instanceof StaticColumnInfoInterface) {
                        info = (StaticColumnInfoInterface)this.rdIn;
                        columnInfoNames = info.getColumnInfoNames();
                        sourceVarName = (String)info.getColumnInfo(this.respVars[respIndex] + 1, columnInfoNames[0]);
                    } else {
                        sourceVarName = (String)((StaticColumnLabelInterface)this.rdIn).getColumnLabel(this.respVars[respIndex] + 1);
                    }
                    sourceVarLabel = this.dmIn.getName(this.respVars[respIndex]);
                } else {
                    sourceVarName = "";
                    sourceVarLabel = "";
                }
                this.sdtOut.setColumnName(i, sourceVarName);
                switch (this.respStatistics[respIndex]) {
                    default: {
                        this.sdtOut.setColumnLabel(i, sourceVarLabel);
                        this.sdtOut.setColumnClass(i, this.rdIn.getColumnClass(this.respVars[respIndex] + 1));
                        break;
                    }
                    case 3: {
                        try {
                            this.sdtOut.setColumnLabel(i, RB.getStringResource("Statistic.FREQ.txt"));
                        }
                        catch (MissingResourceException e) {
                            this.sdtOut.setColumnLabel(i, "Frequency");
                        }
                        this.sdtOut.setColumnClass(i, Integer.class);
                        break;
                    }
                    case 4: {
                        try {
                            this.sdtOut.setColumnLabel(i, RB.getStringResource("Statistic.PERCENTAGE_FREQ.txt"));
                        }
                        catch (MissingResourceException e) {
                            this.sdtOut.setColumnLabel(i, "Percentage Frequency");
                        }
                        this.sdtOut.setColumnClass(i, Double.class);
                        break;
                    }
                    case 5: {
                        try {
                            this.sdtOut.setColumnLabel(i, RB.getStringResource("Statistic.CUMULATIVE_FREQ.txt"));
                        }
                        catch (MissingResourceException e) {
                            this.sdtOut.setColumnLabel(i, "Cumulative Frequency");
                        }
                        this.sdtOut.setColumnClass(i, Integer.class);
                        break;
                    }
                    case 6: {
                        try {
                            this.sdtOut.setColumnLabel(i, RB.getStringResource("Statistic.CUMULATIVE_PERCENTAGE_FREQ.txt"));
                        }
                        catch (MissingResourceException e) {
                            this.sdtOut.setColumnLabel(i, "Cumulative Percentage Frequency");
                        }
                        this.sdtOut.setColumnClass(i, Double.class);
                        break;
                    }
                    case 8: {
                        if (this.showStatistic) {
                            try {
                                this.sdtOut.setColumnLabel(i, sourceVarLabel + "(" + RB.getStringResource("Statistic.PERCENTAGE_SUM.txt") + ")");
                            }
                            catch (MissingResourceException e) {
                                this.sdtOut.setColumnLabel(i, sourceVarLabel + "(Percentage Sum)");
                            }
                        } else {
                            this.sdtOut.setColumnLabel(i, sourceVarLabel);
                        }
                        this.sdtOut.setColumnClass(i, Double.class);
                        break;
                    }
                    case 9: {
                        if (this.showStatistic) {
                            try {
                                this.sdtOut.setColumnLabel(i, sourceVarLabel + "(" + RB.getStringResource("Statistic.CUMULATIVE_SUM.txt") + ")");
                            }
                            catch (MissingResourceException e) {
                                this.sdtOut.setColumnLabel(i, sourceVarLabel + "(Cumulative Sum)");
                            }
                        } else {
                            this.sdtOut.setColumnLabel(i, sourceVarLabel);
                        }
                        this.sdtOut.setColumnClass(i, Double.class);
                        break;
                    }
                    case 10: {
                        if (this.showStatistic) {
                            try {
                                this.sdtOut.setColumnLabel(i, sourceVarLabel + "(" + RB.getStringResource("Statistic.CUMULATIVE_PERCENTAGE_SUM.txt") + ")");
                            }
                            catch (MissingResourceException e) {
                                this.sdtOut.setColumnLabel(i, sourceVarLabel + "(Cumulative % Sum)");
                            }
                        } else {
                            this.sdtOut.setColumnLabel(i, sourceVarLabel);
                        }
                        this.sdtOut.setColumnClass(i, Double.class);
                        break;
                    }
                    case 7: {
                        if (this.showStatistic) {
                            try {
                                this.sdtOut.setColumnLabel(i, sourceVarLabel + "(" + RB.getStringResource("Statistic.SUM.txt") + ")");
                            }
                            catch (MissingResourceException e) {
                                this.sdtOut.setColumnLabel(i, sourceVarLabel + "(Sum)");
                            }
                        } else {
                            this.sdtOut.setColumnLabel(i, sourceVarLabel);
                        }
                        this.sdtOut.setColumnClass(i, Double.class);
                        break;
                    }
                    case 2: {
                        if (this.showStatistic) {
                            try {
                                this.sdtOut.setColumnLabel(i, sourceVarLabel + "(" + RB.getStringResource("Statistic.MEAN.txt") + ")");
                            }
                            catch (MissingResourceException e) {
                                this.sdtOut.setColumnLabel(i, sourceVarLabel + "(Mean)");
                            }
                        } else {
                            this.sdtOut.setColumnLabel(i, sourceVarLabel);
                        }
                        this.sdtOut.setColumnClass(i, Double.class);
                        break;
                    }
                }
            }
            catch (TableException e) {
                return;
            }
            ++respIndex;
            ++i;
        }
    }

    private int makeCells(int[] dim) {
        int j;
        int i;
        int[] c = new int[4];
        int cellsFilled = 0;
        this.cells = new DataCell[dim[0]][dim[1]][dim[2]][dim[3]][this.respCount];
        this.cumTotals = new DataCell[dim[1]][dim[2]][dim[3]][this.respCount];
        for (i = 0; i < dim[1]; ++i) {
            for (j = 0; j < dim[2]; ++j) {
                for (int k = 0; k < dim[3]; ++k) {
                    for (int l = 0; l < this.respCount; ++l) {
                        this.cumTotals[i][j][k][l] = new DataCell();
                    }
                }
            }
        }
        if (!this.g100 || this.gIndex < 0) {
            this.respTotals = new DataCell[1][this.respCount];
            for (i = 0; i < this.respCount; ++i) {
                this.respTotals[0][i] = new DataCell();
            }
        } else {
            this.respTotals = new DataCell[dim[this.gIndex]][this.respCount];
            for (i = 0; i < dim[this.gIndex]; ++i) {
                for (j = 0; j < this.respCount; ++j) {
                    this.respTotals[i][j] = new DataCell();
                }
            }
        }
        try {
            for (int row = 0; row < Math.min(this.dmIn.getRowCount(), this.dmIn.getMaxObservations()); ++row) {
                boolean newcell;
                int resp;
                this.dmIn.setRow(row);
                boolean missingValue = false;
                for (i = 0; i < 4; ++i) {
                    if (i >= this.classCount || !this.dmIn.isValueMissing(this.classVars[i])) continue;
                    missingValue = true;
                    break;
                }
                if (missingValue && !this.missingRetained) continue;
                if (this.ignoreEntireRow) {
                    for (resp = 0; resp < this.respCount; ++resp) {
                        if (!this.dmIn.isValueMissing(this.respVars[resp])) continue;
                        missingValue = true;
                        break;
                    }
                    if (missingValue && !this.missingRetained) continue;
                }
                for (i = 0; i < 4; ++i) {
                    if (i >= this.classCount) continue;
                    Object obj = this.rdIn.getCell(row + 1, this.classVars[i] + 1);
                    if (obj == null || obj instanceof MissingValues) {
                        if (!this.missingRetained) continue;
                        c[i] = (Integer)this.classHash[i].get(this.missingSymbol);
                        continue;
                    }
                    c[i] = (Integer)this.classHash[i].get(obj);
                }
                if (this.cells[c[0]][c[1]][c[2]][c[3]][0] == null) {
                    ++cellsFilled;
                    newcell = true;
                } else {
                    newcell = false;
                }
                for (resp = 0; resp < this.respCount; ++resp) {
                    double respValue;
                    if (this.respVars[resp] == -1) {
                        respValue = 1.0;
                    } else {
                        Class type = this.rdIn.getColumnClass(this.respVars[resp] + 1);
                        if (type == String.class) {
                            respValue = ((String)this.rdIn.getCell(row + 1, this.respVars[resp] + 1)).hashCode();
                        } else if (type == Double.class) {
                            respValue = this.rdIn.getCell(row + 1, this.respVars[resp] + 1) instanceof MissingValues || this.rdIn.getCell(row + 1, this.respVars[resp] + 1) == null ? Double.NaN : (Double)this.rdIn.getCell(row + 1, this.respVars[resp] + 1);
                        } else if (type == Integer.class) {
                            respValue = this.rdIn.getCell(row + 1, this.respVars[resp] + 1) instanceof MissingValues || this.rdIn.getCell(row + 1, this.respVars[resp] + 1) == null ? Double.NaN : ((Integer)this.rdIn.getCell(row + 1, this.respVars[resp] + 1)).doubleValue();
                        } else if (type == BigDecimal.class) {
                            respValue = this.rdIn.getCell(row + 1, this.respVars[resp] + 1) instanceof MissingValues || this.rdIn.getCell(row + 1, this.respVars[resp] + 1) == null ? Double.NaN : ((BigDecimal)this.rdIn.getCell(row + 1, this.respVars[resp] + 1)).doubleValue();
                        } else if (type == BigInteger.class) {
                            respValue = this.rdIn.getCell(row + 1, this.respVars[resp] + 1) instanceof MissingValues || this.rdIn.getCell(row + 1, this.respVars[resp] + 1) == null ? Double.NaN : ((BigInteger)this.rdIn.getCell(row + 1, this.respVars[resp] + 1)).doubleValue();
                        } else {
                            String estr;
                            MessageFormat formatter = new MessageFormat("");
                            try {
                                estr = RB.getStringResource("DataModel.dataType.ex.2.txt");
                                formatter.applyPattern(RB.getStringResource(estr));
                                Object[] arg = new Object[]{type.toString(), new Integer(this.respVars[resp] + 1)};
                                estr = formatter.format(arg);
                            }
                            catch (MissingResourceException e) {
                                int cIndex = this.respVars[resp] + 1;
                                estr = "Unsupported data type " + type.toString() + " in variable mapped to column " + cIndex + ".";
                            }
                            throw new VisualizationException(estr);
                        }
                    }
                    if (!Double.isNaN(respValue)) {
                        if (!this.g100 || this.gIndex < 0) {
                            this.respTotals[0][resp].accumulate(respValue);
                        } else {
                            this.respTotals[c[this.gIndex]][resp].accumulate(respValue);
                        }
                        if (newcell) {
                            this.cells[c[0]][c[1]][c[2]][c[3]][resp] = new DataCell(respValue);
                            continue;
                        }
                        this.cells[c[0]][c[1]][c[2]][c[3]][resp].accumulate(respValue);
                        continue;
                    }
                    if (!newcell) continue;
                    this.cells[c[0]][c[1]][c[2]][c[3]][resp] = new DataCell();
                }
            }
        }
        catch (TableException e) {
            return 0;
        }
        return cellsFilled;
    }

    private void createObservation(int obs, int c0Index, int c1Index, int c2Index, int c3Index) {
        int column = 1;
        int row1based = obs + 1;
        if (this.classCount > 0) {
            this.sdtOut.setCell(row1based, column++, this.classValues[0][c0Index]);
        }
        if (this.classCount > 1) {
            this.sdtOut.setCell(row1based, column++, this.classValues[1][c1Index]);
        }
        if (this.classCount > 2) {
            this.sdtOut.setCell(row1based, column++, this.classValues[2][c2Index]);
        }
        if (this.classCount > 3) {
            this.sdtOut.setCell(row1based, column++, this.classValues[3][c3Index]);
        }
        for (int respIndex = 0; respIndex < this.respCount; ++respIndex) {
            this.sdtOut.setCell(row1based, column + respIndex, this.createResponseValue(c0Index, c1Index, c2Index, c3Index, respIndex));
        }
    }

    private Object createResponseValue(int c0Index, int c1Index, int c2Index, int c3Index, int respIndex) {
        DataCell cum;
        DataCell aCell = this.cells[c0Index][c1Index][c2Index][c3Index][respIndex];
        if (!this.g100 || this.gIndex < 0) {
            this.cumTotals[c1Index][c2Index][c3Index][respIndex].accumulate(aCell);
            cum = this.cumTotals[c1Index][c2Index][c3Index][respIndex];
        } else {
            this.cumTotals[c1Index][c2Index][c3Index][respIndex].accumulate(aCell);
            cum = this.cumTotals[c1Index][c2Index][c3Index][respIndex];
        }
        DataCell totals = !this.g100 || this.gIndex < 0 ? this.respTotals[0][respIndex] : (this.gIndex == 1 ? this.respTotals[c1Index][respIndex] : (this.gIndex == 2 ? this.respTotals[c2Index][respIndex] : this.respTotals[c3Index][respIndex]));
        switch (this.respStatistics[respIndex]) {
            default: {
                return "0";
            }
            case 3: {
                return new Integer(aCell.count);
            }
            case 5: {
                return new Integer(cum.count);
            }
            case 8: {
                double result = aCell.sum * 100.0 / totals.sum;
                return new Double(result);
            }
            case 4: {
                double result = (double)aCell.count * 100.0 / (double)totals.count;
                return new Double(result);
            }
            case 6: {
                double result = (double)cum.count * 100.0 / (double)totals.count;
                return new Double(result);
            }
            case 10: {
                double result = cum.sum * 100.0 / totals.sum;
                return new Double(result);
            }
            case 9: {
                return new Double(cum.sum);
            }
            case 7: {
                if (aCell.count > 0) {
                    return new Double(aCell.sum);
                }
                return null;
            }
            case 2: 
        }
        if (aCell.count > 0) {
            return new Double(aCell.sum / (double)aCell.count);
        }
        return null;
    }
}

