/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.Cityscape;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.ContinuousColorLegend;
import com.sas.graphics.util.visualize.ContinuousColorLegendStyle;
import com.sas.graphics.util.visualize.ContinuousColorMapper;
import com.sas.graphics.util.visualize.DataModelProcessor;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.DiscreteColorLegend2;
import com.sas.graphics.util.visualize.DiscreteColorLegendStyle;
import com.sas.graphics.util.visualize.DiscreteColorMapper;
import com.sas.graphics.util.visualize.DiscreteColorMarkerMapper;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.Scatter;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.TidyContinuousMapper;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.Visualization;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Vector;

public abstract class ColorCityscape
extends Cityscape
implements Serializable {
    static final long serialVersionUID = 3959411011767420703L;
    public static final String RB_KEY = "Chart.";
    protected DependentVariable colorVariable = new DependentVariable();
    protected ContinuousColorLegendStyle colorLegendStyle = new ContinuousColorLegendStyle();
    protected IndependentVariable groupVariable = new IndependentVariable();
    protected DiscreteColorLegendStyle groupLegendStyle;
    protected transient ContinuousColorMapper colorMapper;
    protected transient DiscreteColorMarkerMapper groupMapper;
    protected transient DiscreteColorLegend2 groupLegend;
    protected transient boolean groupLegendScroll;
    protected transient Rectangle groupLegendBox;
    protected transient int clickedObs;
    protected transient String clickedRow;
    protected transient String clickedColumn;
    protected transient String clickedHeight;
    protected transient String clickedColor;
    protected transient String clickedGroup;
    private transient String colorLabel;
    private transient String heightLabel;
    private transient String rowLabel;
    private transient String columnLabel;
    private transient String groupLabel;
    private transient int colorLegendSizePixels;
    protected transient ContinuousColorLegend colorLegend;
    protected int[] mapShapes;
    protected int[] mapJoins;

    public ColorCityscape() {
        this((String)null);
    }

    public ColorCityscape(String title) {
        super(title);
        this.groupVariable.setIndex(-1);
        this.groupLegendStyle = new DiscreteColorLegendStyle();
        this.groupLegendStyle.position = 3;
        this.groupLegendStyle.visible = true;
        this.mapColors = DiscreteColorMapper.getMappedColors(this.groupLegendStyle.getColorScheme());
        this.mapShapes = null;
        this.mapJoins = null;
    }

    @Override
    public IndependentVariable getRowVariable() {
        if (this.rowVariable == null) {
            this.rowVariable = new IndependentVariable();
            this.rowVariable.setIndex(-1);
        } else if (this.rowVariable.equals(this.groupVariable)) {
            this.rowVariable = new IndependentVariable(this.groupVariable);
        }
        return this.rowVariable;
    }

    public IndependentVariable getGroupVariable() {
        if (this.groupVariable == null) {
            this.groupVariable = new IndependentVariable();
            this.groupVariable.setIndex(-1);
        } else if (this.groupVariable.equals(this.rowVariable)) {
            this.groupVariable = new IndependentVariable(this.rowVariable);
        }
        return this.groupVariable;
    }

    public void setGroupVariable(IndependentVariable v) {
        if (v == null) {
            this.groupVariable = new IndependentVariable();
            this.groupVariable.setIndex(-1);
        } else {
            this.groupVariable = v;
        }
    }

    public DiscreteColorLegendStyle getGroupLegendStyle() {
        return this.groupLegendStyle;
    }

    public void setGroupLegendStyle(DiscreteColorLegendStyle aLegendStyle) {
        this.groupLegendStyle = aLegendStyle;
        if (this.defaultColors) {
            this.mapColors = DiscreteColorMapper.getMappedColors(aLegendStyle.getColorScheme());
        }
    }

    public DependentVariable getColorVariable() {
        return this.colorVariable;
    }

    public void setColorVariable(DependentVariable v) {
        if (v == null) {
            this.colorVariable = new DependentVariable();
            this.colorVariable.setIndex(-1);
        } else {
            this.colorVariable = v;
        }
    }

    public ContinuousColorLegendStyle getColorLegendStyle() {
        return this.colorLegendStyle;
    }

    public void setColorLegendStyle(ContinuousColorLegendStyle aLegendStyle) {
        this.colorLegendStyle = aLegendStyle;
    }

    @Override
    public boolean validVariables(boolean checkOnly) {
        if (!super.validVariables(checkOnly)) {
            return false;
        }
        if (!this.dataUser.findIndex(this.colorVariable, checkOnly)) {
            return false;
        }
        return this.dataUser.findIndex(this.groupVariable, checkOnly) || this.is3DScatterPlot();
    }

    @Override
    public void resetVariables(boolean indexOnly) {
        super.resetVariables(indexOnly);
        if (this.colorVariable == null) {
            this.colorVariable = new DependentVariable();
        } else if (indexOnly) {
            this.colorVariable.reset();
        } else {
            this.colorVariable.setAutomatic(true);
        }
        if (this.groupVariable == null) {
            this.groupVariable = new IndependentVariable();
        } else if (indexOnly) {
            this.groupVariable.reset();
        } else {
            this.groupVariable.setAutomatic(true);
        }
    }

    @Override
    protected void validateVariables() {
        this.data.resetReferences();
        if (!this.columnVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.columnVariable, 3);
        }
        if (!this.heightVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.heightVariable, 1);
        }
        if (!this.colorVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.colorVariable, 1);
        } else {
            this.colorVariable.index = -1;
            this.colorVariable.indexIn = -1;
        }
        if (!this.isNoneVariable(this.colorVariable)) {
            if (this.groupVariable == null) {
                this.groupVariable = new IndependentVariable();
            }
            this.groupVariable.index = -1;
            this.groupVariable.indexIn = -1;
        } else if (!this.isNoneVariable(this.groupVariable)) {
            if (this.groupVariable.isAutomatic()) {
                this.groupVariable.index = -1;
                this.groupVariable.indexIn = -1;
            } else {
                this.data.chooseVariable((Variable)this.groupVariable, 3);
                if (this.groupLegendStyle == null) {
                    this.groupLegendStyle = new DiscreteColorLegendStyle();
                    this.groupLegendStyle.position = 3;
                    this.groupLegendStyle.visible = true;
                    this.mapColors = DiscreteColorMapper.getMappedColors(this.groupLegendStyle.getColorScheme());
                }
            }
        }
        if (this.is3DScatterPlot()) {
            this.data.chooseVariable((Variable)this.rowVariable, 3);
            if (this.groupVariable.getIndex() != this.rowVariable.getIndex()) {
                this.groupVariable.index = -1;
                this.groupVariable.indexIn = -1;
            }
        } else {
            if (this.rowVariable == null) {
                this.rowVariable = new IndependentVariable();
            }
            this.rowVariable.index = -1;
            this.rowVariable.indexIn = -1;
            if (this.groupVariable.isAutomatic()) {
                if (this.data.isDerivedFromMDDB()) {
                    this.data.chooseVariable((Variable)this.groupVariable, 2);
                } else {
                    this.groupVariable.index = -1;
                    this.groupVariable.indexIn = -1;
                }
            } else {
                this.data.chooseVariable((Variable)this.groupVariable, 3);
            }
        }
        if (this.heightVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.heightVariable, 1);
            if (this.isNoneVariable(this.heightVariable) && !this.isNoneVariable(this.colorVariable)) {
                this.heightVariable.indexIn = this.colorVariable.indexIn;
                this.heightVariable.index = this.colorVariable.index;
            }
            if (this.isNoneVariable(this.heightVariable)) {
                this.data.chooseVariable(this.heightVariable, 1, true);
            }
        }
        if (this.columnVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.columnVariable, 3);
        }
        if (this.isNoneVariable(this.columnVariable)) {
            this.data.chooseVariable(this.columnVariable, 3, true);
        }
    }

    @Override
    protected void processDataModel() {
        DataModelProcessor dmp = new DataModelProcessor(this.dataUser);
        IndependentVariable[] classifiers = new IndependentVariable[2];
        if (!this.is3DScatterPlot()) {
            classifiers[0] = this.columnVariable;
            classifiers[1] = this.groupVariable;
            if (this.dataUser.isContinuous(this.columnVariable)) {
                dmp.noSummarization = true;
            } else if (this.isNoneVariable(this.groupVariable) && (this.isNoneVariable(this.heightVariable) || this.heightVariable.statistic == 1) && (this.isNoneVariable(this.colorVariable) || this.colorVariable.statistic == 1)) {
                dmp.noSummarization = true;
            }
        } else {
            classifiers[0] = this.rowVariable;
            classifiers[1] = this.columnVariable;
            if (this.groupVariable != this.rowVariable) {
                if (this.dataUser.isContinuous(this.columnVariable) || this.dataUser.isContinuous(this.rowVariable)) {
                    dmp.noSummarization = true;
                } else if ((this.isNoneVariable(this.heightVariable) || this.heightVariable.statistic == 1) && (this.isNoneVariable(this.colorVariable) || this.colorVariable.statistic == 1)) {
                    dmp.noSummarization = true;
                }
            }
        }
        DependentVariable[] responses = new DependentVariable[]{this.heightVariable, this.colorVariable};
        dmp.showStatistic = this.showStatistic;
        dmp.missingRetained = dmp.noSummarization ? false : this.missingRetained;
        dmp.missingSymbol = this.missingSymbol;
        this.data = dmp.process(classifiers, responses);
        this.resetResponseVariable(this.heightVariable);
        this.rowLabel = this.data.getLabel(this.rowVariable);
        if (this.rowLabel == null || this.rowLabel == "") {
            this.rowLabel = RB.getStringResource(RB_KEY, "rowLabel.txt");
        }
        this.columnLabel = this.data.getLabel(this.columnVariable);
        if (this.columnLabel == null || this.columnLabel == "") {
            this.columnLabel = RB.getStringResource(RB_KEY, "columnLabel.txt");
        }
        this.heightLabel = this.data.getLabel(this.heightVariable);
        if (this.heightLabel == null || this.heightLabel == "") {
            this.heightLabel = RB.getStringResource(RB_KEY, "heightLabel.txt");
        }
        if (this.isNoneVariable(this.groupVariable)) {
            this.groupLabel = null;
            this.colorLabel = this.data.getLabel(this.colorVariable);
            if (this.colorLabel == null || this.colorLabel == "") {
                this.colorLabel = RB.getStringResource(RB_KEY, "colorLabel.txt");
            }
            if (this.colorLabel.equals(this.heightLabel)) {
                this.colorLabel = null;
            }
        } else {
            this.colorLabel = null;
            this.groupLabel = this.data.getLabel(this.groupVariable);
            if (this.groupLabel == null || this.groupLabel == "") {
                this.groupLabel = RB.getStringResource(RB_KEY, "groupLabel.txt");
            }
            if (this.groupLabel.equals(this.columnLabel) || this.groupLabel.equals(this.rowLabel)) {
                this.groupLabel = null;
            }
            if (this.groupVariable.indexIn == this.rowVariable.indexIn) {
                this.groupVariable.index = this.rowVariable.index;
            }
        }
    }

    @Override
    public Variable[] getAnalysisVariables() {
        return new Variable[]{this.heightVariable, this.colorVariable};
    }

    @Override
    public Variable[] getClassifierVariables() {
        return new Variable[]{this.rowVariable, this.groupVariable, this.columnVariable};
    }

    @Override
    protected void createMappers() {
        super.createMappers();
        this.assignColorMapper();
        this.assignGroupMapper();
    }

    @Override
    protected void assignHeightMapper() {
        int nCols = this.data.getUniqueObservations(this.columnVariable, this.heightVariable);
        nCols = Math.min(nCols, this.data.getUniqueObservations(this.columnVariable, this.colorVariable));
        float Hmax = !this.data.isContinuous(this.columnVariable) ? (float)nCols * this.aspect : (float)this.columnLegendStyle.getIntervals() * this.aspect;
        this.heightMapper = this.heightVariable == null || this.heightVariable.index == -1 ? new ConstantMapper(1, Hmax) : new TidyContinuousMapper(this.heightLegendStyle.getIntervals(), 0.0f, Hmax);
    }

    protected void assignColorMapper() {
        if (!this.isNoneVariable(this.groupVariable)) {
            return;
        }
        if (this.colorMapping == 1) {
            Color startColor = this.colorLegendStyle.getStartColor();
            Color endColor = this.colorLegendStyle.getEndColor();
            if (this.isNoneVariable(this.colorVariable)) {
                this.colorMapper = new ContinuousColorMapper(1, 0.0f, 0.0f, startColor, startColor);
                return;
            }
            if (this.mapValues == null) {
                this.colorMapper = new ContinuousColorMapper(1, startColor, endColor);
            } else if (this.mapValues.length < 2) {
                this.colorMapper = new ContinuousColorMapper(1, startColor, endColor);
                if (this.mapValues.length == 1) {
                    this.colorMapper.addValue(FloatData.toString((float)this.mapValues[0]));
                }
            } else {
                this.colorMapper = new ContinuousColorMapper(1, this.mapValues[0], this.mapValues[1], startColor, endColor);
            }
        } else {
            this.colorMapper = null;
        }
    }

    protected void assignGroupMapper() {
        if (this.isNoneVariable(this.groupVariable)) {
            return;
        }
        if (this.defaultColors) {
            this.groupMapper = new DiscreteColorMarkerMapper(this.mapShapes, this.mapJoins);
            this.mapColors = this.groupMapper.getMappedColors();
            this.groupMapper.setColorScheme(this.groupLegendStyle.getColorScheme());
        } else {
            this.groupMapper = new DiscreteColorMarkerMapper(this.mapColors, this.mapShapes, this.mapJoins);
        }
    }

    @Override
    protected void initializeMappers() {
        int rowCount = this.data.getRowCount();
        if (this.isNoneVariable(this.groupVariable)) {
            for (int i = 0; i < rowCount; ++i) {
                this.data.setRow(i);
                if (this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.colorVariable) || this.data.isValueMissing(this.heightVariable)) continue;
                this.rowMapper.addValue(this.data.getString(this.rowVariable));
                this.columnMapper.addValue(this.data.getString(this.columnVariable));
                if (!this.heightLegendStyle.isFixedDataRange()) {
                    this.heightMapper.addValue(this.data.getString(this.heightVariable));
                }
                if (this.colorLegendStyle.isFixedDataRange()) continue;
                this.colorMapper.addValue(this.data.getString(this.colorVariable));
            }
            if (this.heightLegendStyle.isFixedDataRange()) {
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMinValue()));
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMaxValue()));
            }
            if (this.colorLegendStyle.isFixedDataRange()) {
                this.colorMapper.addValue(DoubleData.toString((double)this.colorLegendStyle.getDataMinValue()));
                this.colorMapper.addValue(DoubleData.toString((double)this.colorLegendStyle.getDataMaxValue()));
            }
        } else {
            for (int i = 0; i < rowCount; ++i) {
                this.data.setRow(i);
                if (this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.groupVariable) || this.data.isValueMissing(this.heightVariable)) continue;
                this.rowMapper.addValue(this.data.getString(this.rowVariable));
                this.columnMapper.addValue(this.data.getString(this.columnVariable));
                if (!this.heightLegendStyle.isFixedDataRange()) {
                    this.heightMapper.addValue(this.data.getString(this.heightVariable));
                }
                this.groupMapper.addValue(this.data.getString(this.groupVariable));
            }
            this.numGroups = this.groupMapper.getIntervalCount();
            if (this.heightLegendStyle.isFixedDataRange()) {
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMinValue()));
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMaxValue()));
            }
        }
        if (this.rowMapper.getIntervalCount() == 0 || this.columnMapper.getIntervalCount() == 0) {
            throw new VisualizationException(RB.getStringResource("Visualization.missingColumn.ex.txt"));
        }
    }

    @Override
    protected void addColorLegendLabels(Channel ch) {
        if (this.groupLegend != null) {
            this.groupLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
            this.groupLegend.setLabelHotspotID(6);
            this.groupLegend.addLabelsBox(ch);
            Blob[] b = this.groupLegend.getLabelHotspots();
            this.subgroupVariableHotspot = b == null ? null : b[0];
        }
    }

    @Override
    protected void addColorLegends(Channel ch) {
        if (this.isNoneVariable(this.groupVariable)) {
            this.groupLegend = null;
            this.addContinuousColorLegend(ch);
        } else {
            this.addDiscreteColorLegend(ch);
        }
    }

    private void addContinuousColorLegend(Channel ch) {
        ContinuousColorLegend legend;
        boolean newLegend;
        if (!this.isNoneVariable(this.groupVariable) || !this.colorLegendStyle.visible || this.isNoneVariable(this.colorVariable)) {
            return;
        }
        boolean bl = newLegend = this.colorLegend == null;
        if (newLegend) {
            legend = new ContinuousColorLegend(this.colorMapper);
            if (this.colorLegendStyle.getBorderColor() != null) {
                legend.geomColor = this.colorLegendStyle.getBorderColor();
            }
            legend.setLabel(this.data.getDisplayLabel(this.colorVariable));
            legend.setIntervals(this.colorMapper.getIntervalCount());
            legend.setNumPolygons(Math.min(20, Math.max(this.columnMapper.getIntervalCount(), 5)));
            String[] values = this.colorMapper.getValueLabels();
            String[] formattedValues = this.dataUser.format((Variable)this.colorVariable, values);
            legend.values = values;
            legend.formattedValues = formattedValues == null ? values : formattedValues;
            legend.valueStyle = this.colorLegendStyle.valueStyle;
            legend.labelStyle = this.colorLegendStyle.labelStyle;
            this.colorLegend = legend;
        } else {
            legend = this.colorLegend;
        }
        TextStyle ts = this.colorLegendStyle.labelStyle;
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int labelFontPixels = fm.getHeight();
        ts = this.colorLegendStyle.valueStyle;
        fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueFontPixels = fm.getHeight();
        float legWidth = this.xSizePixels;
        float legHeight = this.data.getDisplayLabel(this.colorVariable) != null ? (float)(2 * labelFontPixels + 3 * valueFontPixels / 4) : (float)(labelFontPixels + 3 * valueFontPixels / 4);
        legend.setPosition(this.colorLegendStyle.position, new Vec3f(legWidth, legHeight, legWidth), new Vec3f((float)(this.width - this.leftMargin - this.rightMargin) / 2.0f, this.yColorLegendSize + 0.03f * (float)this.height + legHeight, 0.0f));
        legend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
        legend.setLabelHotspotID(6);
        legend.addLegend(ch, this.colorLegendStyle.visible);
        this.yColorLegendSize += legend.vLegendOffset + (float)this.blankSpacePixels;
        Blob[] b = legend.getLabelHotspots();
        this.subgroupVariableHotspot = b == null ? null : b[0];
    }

    @Override
    protected void removeLegends() {
        super.removeLegends();
        this.groupLegend = null;
        this.groupLegendBox = null;
        this.groupLegendScroll = false;
        this.colorLegend = null;
    }

    protected void addDiscreteColorLegend(Channel ch) {
        if (this.isNoneVariable(this.groupVariable) || !this.groupLegendStyle.visible) {
            return;
        }
        boolean noScroll = this.groupLegendStyle.getNoScroll();
        float legWidth = 0.0f;
        float legHeight = 0.0f;
        if (this.groupLegend == null) {
            this.groupLegend = new DiscreteColorLegend2(this.groupMapper);
            if (this.groupLegendStyle.getBorderColor() != null) {
                this.groupLegend.geomColor = this.groupLegendStyle.getBorderColor();
            }
            String[] valueLabels = this.groupMapper.getValueLabels();
            this.groupLegend.setLabel(this.data.getDisplayLabel(this.groupVariable));
            this.groupLegend.setValues(valueLabels);
            String[] formattedValues = this.dataUser.format((Variable)this.groupVariable, valueLabels);
            if (formattedValues == null) {
                this.groupLegend.formattedValues = valueLabels;
            } else {
                valueLabels = formattedValues;
                this.groupLegend.formattedValues = formattedValues;
            }
            this.groupLegend.setIntervals(this.groupMapper.getIntervalCount());
            this.groupLegend.valueStyle = this.groupLegendStyle.valueStyle;
            this.groupLegend.valueStyle.majorJustify = "LEFT";
            this.groupLegend.valueStyle.minorJustify = "CENTER";
            this.groupLegend.labelStyle = this.groupLegendStyle.labelStyle;
            this.groupLegend.defaultSize = this.groupLegendStyle.defaultSize;
            if (this.mapJoins != null && ((Scatter)this).getJoinType() == 7) {
                boolean[] j = new boolean[this.mapJoins.length];
                for (int i = 0; i < this.mapJoins.length; ++i) {
                    j[i] = this.mapJoins[i] == 1 || this.mapJoins[i] == 2 || this.mapJoins[i] == 4 || this.mapJoins[i] == 5 || this.mapJoins[i] == 6;
                }
                this.groupLegend.setJoins(j);
            }
            this.groupLegend.setLegendMarker(((Scatter)this).getMarkerType());
            if (this.groupLegendStyle.defaultSize) {
                legWidth = noScroll ? (float)((double)(this.width - this.leftMargin - this.rightMargin - 4) * this.groupLegendStyle.width) : (float)this.xSizePixels;
                TextStyle ts = this.groupLegendStyle.labelStyle;
                FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int labelFontPixels = fm.getHeight();
                ts = this.groupLegendStyle.valueStyle;
                fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int valueFontPixels = fm.getHeight();
                int len = Math.min(6, valueLabels.length);
                int valueLen = 0;
                for (int i = 0; i < len; ++i) {
                    valueLen = Math.max(valueLen, fm.stringWidth(valueLabels[i].substring(0, Math.min(valueLabels[i].length(), ts.maxChars))));
                }
                int numrows = this.xSizePixels / ((valueLen += (int)(1.5 * (double)valueFontPixels)) * valueLabels.length);
                int oldsize = (int)Math.max(0.1 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
                if (noScroll) {
                    numrows = (int)Math.ceil((float)valueLabels.length / (legWidth / (float)valueLen));
                    if (numrows > 10) {
                        numrows = 10;
                    }
                    legHeight = (float)((double)this.height * 0.5);
                    this.groupLegend.setSize(new Vec3f(legWidth, legHeight, 1.0f));
                    legHeight = this.groupLegend.calculateHeight(ch);
                } else {
                    legHeight = numrows != 2 ? (float)((int)Math.max(0.2 * (double)this.ySizePixels, (double)(labelFontPixels + 2 * valueFontPixels))) : (float)labelFontPixels + 3.2f * (float)valueFontPixels;
                }
                this.ySizePixels = (int)((float)this.ySizePixels + ((float)oldsize - legHeight));
            } else {
                legWidth = (float)((double)this.width * this.groupLegendStyle.width);
                legHeight = (float)((double)this.height * this.groupLegendStyle.height);
            }
            this.groupLegend.setSize(new Vec3f(legWidth, legHeight, 1.0f));
            this.groupLegend.setPosition(this.groupLegendStyle.position, new Vec3f(legWidth, legHeight, legWidth), new Vec3f(((float)(this.width - this.leftMargin - this.rightMargin) - legWidth) / 2.0f, this.yColorLegendSize + 0.03f * (float)this.height + legHeight, 0.0f));
        }
        this.groupLegend.addLegend(ch, this.groupLegendStyle.visible);
        if (noScroll) {
            float oldsize = legHeight;
            legHeight = this.groupLegend.getHeight();
            this.ySizePixels = (int)((float)this.ySizePixels + (oldsize - legHeight));
        }
        this.groupLegendScroll = this.groupLegend.isScrollable();
        this.yColorLegendSize += this.groupLegend.vLegendOffset + (float)this.blankSpacePixels;
    }

    @Override
    protected void scaleText(Channel ch) {
        super.scaleText(ch);
        if (this.isNoneVariable(this.groupVariable)) {
            TextStyle ts = this.colorLegendStyle.getLabelStyle();
            ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
            ts = this.colorLegendStyle.getValueStyle();
            ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        } else {
            TextStyle ts = this.groupLegendStyle.getLabelStyle();
            ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
            ts = this.groupLegendStyle.getValueStyle();
            ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        }
    }

    @Override
    protected void estimateLegendPixelSize(Channel ch) {
        this.colorLegendSizePixels = 0;
        if (this.isNoneVariable(this.groupVariable) && !this.isNoneVariable(this.colorVariable) && this.colorLegendStyle.visible) {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.colorLegendStyle.labelStyle.createFont());
            int labelFontPixels = fm.getHeight();
            fm = Toolkit.getDefaultToolkit().getFontMetrics(this.colorLegendStyle.valueStyle.createFont());
            int valueFontPixels = fm.getHeight();
            if (this.data.getDisplayLabel(this.colorVariable) != null) {
                this.colorLegendSizePixels = 2 * labelFontPixels + 3 * valueFontPixels / 4 + this.blankSpacePixels;
                this.bottomLegendPixels += this.colorLegendSizePixels + this.blankSpacePixels;
            } else {
                this.colorLegendSizePixels = labelFontPixels + 3 * valueFontPixels / 4 + this.blankSpacePixels;
                this.bottomLegendPixels += this.colorLegendSizePixels + this.blankSpacePixels;
            }
        } else if (!this.isNoneVariable(this.groupVariable) && this.groupLegendStyle.visible) {
            TextStyle ts = this.groupLegendStyle.labelStyle;
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
            int labelFontPixels = fm.getHeight();
            ts = this.groupLegendStyle.valueStyle;
            fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
            int valueFontPixels = fm.getHeight();
            int legHeight = (int)Math.max(0.1 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
            this.bottomLegendPixels = this.groupLegendStyle.defaultSize ? (this.bottomLegendPixels += (int)((float)legHeight + this.blankSpaceSize)) : (this.bottomLegendPixels += (int)(this.groupLegendStyle.height * (double)this.height * 0.75 + (double)this.blankSpaceSize));
        }
    }

    @Override
    protected abstract void setProjection(Channel var1);

    @Override
    protected void parseProbeInfo(String[] lastPicked, String[] descriptors, String[] values) {
        this.resetClickedItems();
        int n = this.clickedObs = lastPicked == null || lastPicked[4] == null ? -1 : Integer.parseInt(lastPicked[4]);
        if (this.clickedObs >= 0) {
            String rowValue = this.data.getString(this.rowVariable, this.clickedObs);
            String columnValue = this.data.getString(this.columnVariable, this.clickedObs);
            String heightValue = this.data.getString(this.heightVariable, this.clickedObs);
            String colorValue = this.data.getString(this.colorVariable, this.clickedObs);
            String groupValue = this.data.getString(this.groupVariable, this.clickedObs);
            int ii = 0;
            if (this.rowLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.rowLabel;
                values[ii++] = this.dataUser.format((Variable)this.rowVariable, rowValue);
            }
            if (this.columnLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.columnLabel;
                values[ii++] = this.dataUser.format((Variable)this.columnVariable, columnValue);
            }
            if (this.heightLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.heightLabel;
                values[ii++] = this.dataUser.format((Variable)this.heightVariable, heightValue);
            }
            if (this.colorLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.colorLabel;
                values[ii++] = this.dataUser.format((Variable)this.colorVariable, colorValue);
            } else if (this.groupLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.groupLabel;
                values[ii++] = this.dataUser.format((Variable)this.groupVariable, groupValue);
            }
        }
    }

    @Override
    protected void resetClickedItems() {
        this.clickedObs = -1;
        this.clickedRow = null;
        this.clickedColumn = null;
        this.clickedHeight = null;
        this.clickedColor = null;
        this.clickedGroup = null;
    }

    public String getClickedRow(boolean formatted) {
        return ColorCityscape._getClickedValue(this.data, this.clickedObs, this.rowVariable, formatted ? this.dataUser : null);
    }

    public String getClickedColumn(boolean formatted) {
        return ColorCityscape._getClickedValue(this.data, this.clickedObs, this.columnVariable, formatted ? this.dataUser : null);
    }

    public String getClickedHeight(boolean formatted) {
        return ColorCityscape._getClickedValue(this.data, this.clickedObs, this.heightVariable, formatted ? this.dataUser : null);
    }

    public String getClickedColor(boolean formatted) {
        return ColorCityscape._getClickedValue(this.data, this.clickedObs, this.colorVariable, formatted ? this.dataUser : null);
    }

    public String getClickedGroup(boolean formatted) {
        return ColorCityscape._getClickedValue(this.data, this.clickedObs, this.groupVariable, formatted ? this.dataUser : null);
    }

    public Object getClickedRowValue() {
        return Visualization.getRawObject(this.data.getType(this.rowVariable), this.getClickedRow(false));
    }

    public Object getClickedColumnValue() {
        return Visualization.getRawObject(this.data.getType(this.columnVariable), this.getClickedColumn(false));
    }

    public Object getClickedHeightValue() {
        return Visualization.getRawObject(this.data.getType(this.heightVariable), this.getClickedHeight(false));
    }

    public Object getClickedColorValue() {
        return Visualization.getRawObject(this.data.getType(this.colorVariable), this.getClickedColor(false));
    }

    public Object getClickedGroupValue() {
        return Visualization.getRawObject(this.data.getType(this.groupVariable), this.getClickedGroup(false));
    }

    private void resetLegendColors() {
        int ncolors = this.mapColors.size();
        if (ncolors > 0) {
            this.colorLegendStyle.setStartColor((Color)this.mapColors.elementAt(0));
        }
        if (ncolors > 1) {
            this.colorLegendStyle.setEndColor((Color)this.mapColors.elementAt(1));
        }
    }

    private void resetMapColors() {
        int ncolors = 0;
        if (this.mapColors != null) {
            ncolors = this.mapColors.size();
        } else {
            this.mapColors = new Vector();
        }
        if (ncolors > 0) {
            this.mapColors.setElementAt(this.colorLegendStyle.getStartColor(), 0);
        } else {
            this.mapColors.addElement(this.colorLegendStyle.getStartColor());
        }
        if (ncolors > 1) {
            this.mapColors.setElementAt(this.colorLegendStyle.getEndColor(), 1);
        } else {
            this.mapColors.addElement(this.colorLegendStyle.getEndColor());
        }
    }

    @Override
    public void setColorMapping(int type, Color[] colors, float[] values) {
        super.setColorMapping(type, colors, values);
        this.resetLegendColors();
    }

    @Override
    public void setMapColors(Color[] colors) {
        super.setMapColors(colors);
        this.resetLegendColors();
    }

    @Override
    public void setMapColors(Vector mapColorsIn) {
        super.setMapColors(mapColorsIn);
        this.resetLegendColors();
    }

    @Override
    public Vector getMapColors() {
        if (!this.isNoneVariable(this.colorVariable)) {
            this.resetMapColors();
        }
        return this.mapColors;
    }

    @Override
    protected boolean isRegionPicked(int x, int y) {
        if (this.groupLegendStyle.getVisible()) {
            return this.groupLegendScroll && this.groupLegendBox.contains(x, y);
        }
        return false;
    }

    @Override
    protected float getScrollableThumb() {
        return this.groupLegend.thumb;
    }

    @Override
    protected void setLegendBoundingBoxes(Channel ch) {
        if (this.groupLegendStyle.getVisible() && this.groupLegend != null) {
            boolean resetView;
            boolean bl = resetView = this.depth == 2;
            if (resetView) {
                this.setStraightViewpoint(ch);
            }
            this.groupLegendBox = this.groupLegend.getBoundingBox(ch, true);
            if (resetView) {
                this.setInitialViewpoint(ch);
            }
        }
    }

    @Override
    protected void scrollRegion(Channel ch, int x, int y, int prevx, int prevy) {
        float dx = (float)(x - prevx) / (float)this.groupLegendBox.width;
        float dy = (float)(y - prevy) / (float)this.groupLegendBox.height;
        this.setStandardView(ch);
        ch.glNewList(6L, true);
        this.groupLegend.moveThumb(ch, dx, dy);
        ch.glEndList();
        ch.glNewList(5L, true);
        this.groupLegend.addLabelsBox(ch);
        ch.glEndList();
        if (this.transparent) {
            ch.copyBuffer(this.groupLegendBox, 2);
        } else {
            ch.clearBuffer(this.groupLegendBox);
        }
        ch.setClip(this.groupLegendBox);
        ch.glCallList(6L, true);
        ch.resetClip();
        ch.glCallList(5L, true);
        ch.glRefresh(this.groupLegendBox);
        this.setFinalView(ch);
    }

    public Object[] getPickedRowValues(boolean formatted) {
        return ColorCityscape.getPickedValues(formatted, this.pickList, 0, this.dataUser, this.rowVariable);
    }

    public Object[] getPickedColumnValues(boolean formatted) {
        return ColorCityscape.getPickedValues(formatted, this.pickList, 1, this.dataUser, this.columnVariable);
    }

    public Object[] getPickedHeightValues(boolean formatted) {
        return ColorCityscape.getPickedValues(formatted, this.pickList, 3, this.dataUser, this.heightVariable);
    }

    public Object[] getPickedColorValues(boolean formatted) {
        if (this.isNoneVariable(this.colorVariable)) {
            return null;
        }
        return ColorCityscape.getPickedValues(formatted, this.pickList, 2, this.dataUser, this.colorVariable);
    }

    public Object[] getPickedGroupValues(boolean formatted) {
        if (this.isNoneVariable(this.groupVariable)) {
            return null;
        }
        return ColorCityscape.getPickedValues(formatted, this.pickList, 2, this.dataUser, this.groupVariable);
    }

    public int[] getMapShapes() {
        return this.mapShapes;
    }

    public void setMapShapes(int[] shapes) {
        if (shapes != null) {
            this.mapShapes = shapes;
        }
    }

    public int[] getMapJoins() {
        return this.mapJoins;
    }

    public void setMapJoins(int[] joins) {
        if (joins != null) {
            this.mapJoins = joins;
        }
    }
}

