/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Axis;
import com.sas.graphics.util.visualize.AxisLegend;
import com.sas.graphics.util.visualize.AxisStyle;
import com.sas.graphics.util.visualize.Bar;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.DataModelProcessor;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.DiscreteMapper;
import com.sas.graphics.util.visualize.ExtWireLegend;
import com.sas.graphics.util.visualize.HorizontalBar;
import com.sas.graphics.util.visualize.HorizontalSegmentedBar;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.ReferenceLine;
import com.sas.graphics.util.visualize.ReverseDataDiscreteMapper;
import com.sas.graphics.util.visualize.ReverseSortedDiscreteMapper;
import com.sas.graphics.util.visualize.Scatter;
import com.sas.graphics.util.visualize.Shapes;
import com.sas.graphics.util.visualize.SortedDiscreteMapper;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.TidyContinuousMapper;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.VerticalBar;
import com.sas.graphics.util.visualize.VerticalSegmentedBar;
import com.sas.graphics.util.visualize.View;
import com.sas.graphics.util.visualize.Visualization;
import com.sas.graphics.util.visualize.WireLegend;
import com.sas.lang.DoubleData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Stack;

public abstract class Cityscape
extends Visualization
implements Serializable {
    static final long serialVersionUID = 2738453733015805485L;
    protected IndependentVariable rowVariable;
    protected AxisStyle rowLegendStyle;
    protected IndependentVariable columnVariable;
    protected AxisStyle columnLegendStyleUser;
    protected AxisStyle columnLegendStyle;
    protected DependentVariable heightVariable;
    protected AxisStyle heightLegendStyle;
    protected int labelVariableUser;
    protected int labelVariable;
    protected boolean backplaneVisible;
    private static final Color DEFAULT_BACKPLANE_COLOR = Color.lightGray;
    protected Color backplaneColor;
    protected Color backplaneEdgeColor;
    protected transient Mapper rowMapper;
    protected transient Mapper columnMapper;
    protected transient Mapper heightMapper;
    protected transient float numRows = 0.0f;
    protected transient float numColumns = 0.0f;
    protected transient double distortX = 0.0;
    protected transient double distortY = 0.0;
    protected transient float xPadding = 0.0f;
    protected transient float yPadding = 0.0f;
    protected transient float zPadding = 0.0f;
    protected transient AxisLegend rowLegend;
    protected transient AxisLegend columnLegend;
    protected transient AxisLegend heightLegend;
    protected transient boolean dataFlag = false;
    protected transient boolean vertical;
    protected transient int dataModeState;
    protected ReferenceLine horizontalRefline;
    protected ReferenceLine verticalRefline;
    protected boolean showHorizontalRefline;
    protected boolean showVerticalRefline;
    protected boolean clipReferenceLine;
    protected boolean showReferenceLineLabel;
    protected transient int numGroups = 1;
    protected float savedRows;
    protected float savedCols;
    protected boolean columnValueHotspotsEnabled;
    protected transient Blob[] columnValueHotspots;
    protected boolean rowValueHotspotsEnabled;
    protected transient Blob[] rowValueHotspots;
    protected boolean groupValueHotspotsEnabled;
    protected transient Blob[] groupValueHotspots;
    protected boolean variableHotspotsEnabled;
    protected Blob columnVariableHotspot;
    protected Blob rowVariableHotspot;
    protected Blob subgroupVariableHotspot;
    protected Blob heightVariableHotspot;
    protected transient float offset;

    public Cityscape() {
        this((String)null);
    }

    public Cityscape(String title) {
        super(title);
        this.rowVariable = new IndependentVariable();
        this.rowVariable.setIndex(-1);
        this.rowLegendStyle = new AxisStyle();
        this.rowLegendStyle.grid.setVisible(true);
        this.rowLegendStyle.setAxisType(1);
        this.columnVariable = new IndependentVariable();
        this.columnLegendStyle = new AxisStyle();
        this.heightVariable = new DependentVariable();
        this.heightLegendStyle = new AxisStyle();
        this.labelVariable = 0;
        this.labelVariableUser = 0;
        this.backplaneVisible = true;
        this.backplaneColor = DEFAULT_BACKPLANE_COLOR;
        this.backplaneEdgeColor = new Color(255 - this.backplaneColor.getRed(), 255 - this.backplaneColor.getGreen(), 255 - this.backplaneColor.getBlue());
        this.horizontalRefline = new ReferenceLine();
        this.horizontalRefline.lineDirection = 1;
        this.showHorizontalRefline = false;
        this.verticalRefline = new ReferenceLine();
        this.verticalRefline.lineDirection = 2;
        this.showVerticalRefline = false;
        this.clipReferenceLine = false;
        this.showReferenceLineLabel = true;
        this.savedRows = 0.0f;
        this.savedCols = 0.0f;
        this.columnValueHotspotsEnabled = false;
        this.rowValueHotspotsEnabled = false;
        this.groupValueHotspotsEnabled = false;
        this.variableHotspotsEnabled = false;
    }

    public Cityscape(Cityscape aCityscape) {
        super(aCityscape);
        this.rowVariable = aCityscape.rowVariable;
        this.rowLegendStyle = aCityscape.rowLegendStyle;
        this.columnVariable = aCityscape.columnVariable;
        this.columnLegendStyle = aCityscape.columnLegendStyle;
        this.heightVariable = aCityscape.heightVariable;
        this.heightLegendStyle = aCityscape.heightLegendStyle;
        this.labelVariableUser = aCityscape.labelVariableUser;
        this.labelVariable = aCityscape.labelVariable;
        this.backplaneVisible = aCityscape.backplaneVisible;
        this.backplaneColor = aCityscape.backplaneColor;
        this.backplaneEdgeColor = aCityscape.backplaneEdgeColor;
        this.horizontalRefline = aCityscape.horizontalRefline;
        this.verticalRefline = aCityscape.verticalRefline;
        this.showHorizontalRefline = aCityscape.showHorizontalRefline;
        this.showVerticalRefline = aCityscape.showVerticalRefline;
        this.clipReferenceLine = aCityscape.clipReferenceLine;
        this.showReferenceLineLabel = aCityscape.showReferenceLineLabel;
        this.savedRows = aCityscape.savedRows;
        this.savedCols = aCityscape.savedCols;
        this.columnValueHotspotsEnabled = aCityscape.columnValueHotspotsEnabled;
        this.rowValueHotspotsEnabled = aCityscape.rowValueHotspotsEnabled;
        this.groupValueHotspotsEnabled = aCityscape.groupValueHotspotsEnabled;
        this.variableHotspotsEnabled = aCityscape.variableHotspotsEnabled;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.serialVersion == 0) {
            if (this instanceof HorizontalBar || this instanceof HorizontalSegmentedBar) {
                this.columnLegendStyle.grid.setVisible(true);
                this.columnLegendStyle.setAxisType(1);
                IndependentVariable tmpVar = this.columnVariable;
                this.columnVariable = this.rowVariable != null ? new IndependentVariable(this.rowVariable) : new IndependentVariable();
                this.rowVariable = tmpVar;
                AxisStyle tmpStyle = this.columnLegendStyle;
                this.columnLegendStyle = new AxisStyle(this.rowLegendStyle);
                this.rowLegendStyle = tmpStyle;
            } else {
                this.rowLegendStyle.grid.setVisible(true);
                this.rowLegendStyle.setAxisType(1);
            }
            this.serialVersion = 1;
        }
    }

    public IndependentVariable getRowVariable() {
        return this.rowVariable;
    }

    public void setRowVariable(IndependentVariable v) {
        if (v == null) {
            this.rowVariable = new IndependentVariable();
            this.rowVariable.setIndex(-1);
        } else {
            this.rowVariable = v;
        }
        this.zSizeMax = 0.0f;
        this.zSizeMin = 0.0f;
    }

    public AxisStyle getRowLegendStyle() {
        return this.rowLegendStyle;
    }

    public void setRowLegendStyle(AxisStyle aLegendStyle) {
        this.rowLegendStyle = aLegendStyle;
    }

    public IndependentVariable getColumnVariable() {
        return this.columnVariable;
    }

    public void setColumnVariable(IndependentVariable v) {
        if (v == null) {
            this.columnVariable = new IndependentVariable();
            this.columnVariable.setIndex(-1);
        } else {
            this.columnVariable = v;
        }
        this.xSizeMax = 0.0f;
        this.xSizeMin = 0.0f;
        this.ySizeMax = 0.0f;
        this.ySizeMin = 0.0f;
    }

    public AxisStyle getColumnLegendStyle() {
        return this.columnLegendStyle;
    }

    public void setColumnLegendStyle(AxisStyle aLegendStyle) {
        this.columnLegendStyle = aLegendStyle;
    }

    public DependentVariable getHeightVariable() {
        return this.heightVariable;
    }

    public void setHeightVariable(DependentVariable v) {
        if (v == null) {
            this.heightVariable = new DependentVariable();
            this.heightVariable.setIndex(-1);
        } else {
            this.heightVariable = v;
        }
    }

    public AxisStyle getHeightLegendStyle() {
        return this.heightLegendStyle;
    }

    public void setHeightLegendStyle(AxisStyle aLegendStyle) {
        this.heightLegendStyle = aLegendStyle;
    }

    public int getLabelVariable() {
        return this.labelVariableUser;
    }

    public void setLabelVariable(int v) {
        this.labelVariableUser = v;
    }

    public boolean isBackplaneVisible() {
        return this.backplaneVisible;
    }

    public void setBackplaneVisible(boolean aBoolean) {
        this.backplaneVisible = aBoolean;
    }

    public Color getBackplaneColor() {
        return this.backplaneColor;
    }

    public void setBackplaneColor(Color backplaneColorIn) {
        this.backplaneColor = backplaneColorIn;
        this.backplaneEdgeColor = new Color(255 - this.backplaneColor.getRed(), 255 - this.backplaneColor.getGreen(), 255 - this.backplaneColor.getBlue());
    }

    public void setHorizontalReferenceLines(float[] values) {
        this.horizontalRefline.setValues(values);
        this.showHorizontalRefline = true;
    }

    public void setHorizontalReferenceLines(String[] values) {
        this.horizontalRefline.setValues(values);
        this.showHorizontalRefline = true;
    }

    public void setVerticalReferenceLines(float[] values) {
        this.verticalRefline.setValues(values);
        this.showVerticalRefline = true;
    }

    public void setVerticalReferenceLines(String[] values) {
        this.verticalRefline.setValues(values);
        this.showVerticalRefline = true;
    }

    public void setHorizontalReferenceLineLabels(String[] labels) {
        this.horizontalRefline.setLabels(labels);
    }

    public void setVerticalReferenceLineLabels(String[] labels) {
        this.verticalRefline.setLabels(labels);
    }

    public void setHorizontalReferenceLineColor(Color c) {
        this.horizontalRefline.setLineColor(c);
    }

    public Color getHorizontalReferenceLineColor() {
        return this.horizontalRefline.getLineColor();
    }

    public void setVerticalReferenceLineColor(Color c) {
        this.verticalRefline.setLineColor(c);
    }

    public Color getVerticalReferenceLineColor() {
        return this.verticalRefline.getLineColor();
    }

    public void setHorizontalReferenceLineLabelStyle(TextStyle aStyle) {
        this.horizontalRefline.setLabelStyle(aStyle);
    }

    public TextStyle getHorizontalReferenceLineLabelStyle() {
        return this.horizontalRefline.getLabelStyle();
    }

    public void setVerticalReferenceLineLabelStyle(TextStyle aStyle) {
        this.verticalRefline.setLabelStyle(aStyle);
    }

    public TextStyle getVerticalReferenceLineLabelStyle() {
        return this.verticalRefline.getLabelStyle();
    }

    public void setClipReferenceLine(boolean flag) {
        this.clipReferenceLine = flag;
    }

    public boolean isClipReferenceLine() {
        return this.clipReferenceLine;
    }

    public void setShowReferenceLineLabel(boolean flag) {
        this.showReferenceLineLabel = flag;
    }

    public boolean isShowReferenceLineLabel() {
        return this.showReferenceLineLabel;
    }

    public void setColumnValueHotspotsEnabled(boolean flag) {
        this.columnValueHotspotsEnabled = flag;
    }

    public boolean isColumnValueHotspotsEnabled() {
        return this.columnValueHotspotsEnabled;
    }

    public Blob[] getColumnValueHotspots() {
        return this.columnValueHotspots;
    }

    public void setRowValueHotspotsEnabled(boolean flag) {
        this.rowValueHotspotsEnabled = flag;
    }

    public boolean isRowValueHotspotsEnabled() {
        return this.rowValueHotspotsEnabled;
    }

    public Blob[] getRowValueHotspots() {
        return this.rowValueHotspots;
    }

    public void setGroupValueHotspotsEnabled(boolean flag) {
        this.groupValueHotspotsEnabled = flag;
    }

    public boolean isGroupValueHotspotsEnabled() {
        return this.groupValueHotspotsEnabled;
    }

    public Blob[] getGroupValueHotspots() {
        return this.groupValueHotspots;
    }

    public void setVariableHotspotsEnabled(boolean flag) {
        this.variableHotspotsEnabled = flag;
    }

    public boolean isVariableHotspotsEnabled() {
        return this.variableHotspotsEnabled;
    }

    public Blob[] getVariableHotspots() {
        int count = this.columnVariableHotspot == null ? 0 : 1;
        count += this.rowVariableHotspot == null ? 0 : 1;
        count += this.subgroupVariableHotspot == null ? 0 : 1;
        if ((count += this.heightVariableHotspot == null ? 0 : 1) < 1) {
            return null;
        }
        Blob[] variableHotspots = new Blob[count];
        count = 0;
        if (this.columnVariableHotspot != null) {
            variableHotspots[count++] = this.columnVariableHotspot;
        }
        if (this.rowVariableHotspot != null) {
            variableHotspots[count++] = this.rowVariableHotspot;
        }
        if (this.subgroupVariableHotspot != null) {
            variableHotspots[count++] = this.subgroupVariableHotspot;
        }
        if (this.heightVariableHotspot != null) {
            variableHotspots[count++] = this.heightVariableHotspot;
        }
        return variableHotspots;
    }

    @Override
    protected boolean isLegendHotspotsActive() {
        return this.isColumnValueHotspotsEnabled() || this.isRowValueHotspotsEnabled() || this.isGroupValueHotspotsEnabled() || this.isVariableHotspotsEnabled() || super.isLegendHotspotsActive();
    }

    @Override
    public boolean validVariables(boolean checkOnly) {
        return this.dataUser.findIndex(this.rowVariable, checkOnly) && this.dataUser.findIndex(this.columnVariable, checkOnly) && this.dataUser.findIndex(this.heightVariable, checkOnly);
    }

    @Override
    public void resetVariables(boolean indexOnly) {
        if (this.rowVariable == null) {
            this.rowVariable = new IndependentVariable();
        } else if (indexOnly) {
            this.rowVariable.reset();
        } else {
            this.rowVariable.setAutomatic(true);
        }
        if (this.columnVariable == null) {
            this.columnVariable = new IndependentVariable();
        } else if (indexOnly) {
            this.columnVariable.reset();
        } else {
            this.columnVariable.setAutomatic(true);
        }
        if (this.heightVariable == null) {
            this.heightVariable = new DependentVariable();
        } else if (indexOnly) {
            this.heightVariable.reset();
        } else {
            this.heightVariable.setAutomatic(true);
        }
        this.xSizeMax = 0.0f;
        this.xSizeMin = 0.0f;
        this.ySizeMax = 0.0f;
        this.ySizeMin = 0.0f;
        this.zSizeMax = 0.0f;
        this.zSizeMin = 0.0f;
    }

    @Override
    protected void validateVariables() {
        boolean continuousOnly = true;
        this.data.resetReferences();
        this.data.chooseVariable((Variable)this.heightVariable, continuousOnly);
        this.data.chooseVariable((Variable)this.columnVariable, !continuousOnly);
        this.data.chooseVariable((Variable)this.rowVariable, !continuousOnly);
        if (!this.isNoneVariable(this.rowVariable) && this.pickMode == 1) {
            this.pickMode = 2;
        }
    }

    @Override
    protected void processDataModel() {
        DataModelProcessor dmp = new DataModelProcessor(this.dataUser);
        IndependentVariable[] classifiers = new IndependentVariable[]{this.rowVariable, this.columnVariable};
        DependentVariable[] responses = new DependentVariable[]{this.heightVariable};
        dmp.showStatistic = this.showStatistic;
        this.data = dmp.process(classifiers, responses);
        this.resetResponseVariable(this.heightVariable);
    }

    @Override
    protected void createMappers() {
        boolean anyType = false;
        this.assignRowMapper(anyType);
        this.assignColumnMapper(anyType);
        this.assignHeightMapper();
    }

    protected void assignRowMapper(boolean forceDiscrete) {
        if (this.isNoneVariable(this.rowVariable)) {
            this.rowMapper = new ConstantMapper(1, 0.5f);
        } else if (!forceDiscrete && this.data.isContinuous(this.rowVariable)) {
            switch (this.rowVariable.sort) {
                case 0: 
                case 1: 
                case 3: {
                    this.rowMapper = new TidyContinuousMapper(this.rowLegendStyle.getIntervals(), 0.0f, this.rowLegendStyle.getIntervals());
                    break;
                }
                case 2: {
                    this.rowMapper = new TidyContinuousMapper(this.rowLegendStyle.getIntervals(), this.rowLegendStyle.getIntervals(), 0.0f);
                    break;
                }
            }
        } else {
            switch (this.rowVariable.sort) {
                case 0: {
                    this.rowMapper = new DiscreteMapper(0.5f);
                    break;
                }
                case 1: {
                    this.rowMapper = new SortedDiscreteMapper(0.5f);
                    break;
                }
                case 2: {
                    this.rowMapper = new ReverseSortedDiscreteMapper(0.5f);
                    break;
                }
                case 3: {
                    this.rowMapper = new ReverseDataDiscreteMapper(0.5f);
                    break;
                }
            }
        }
    }

    protected void assignColumnMapper(boolean forceDiscrete) {
        if (this.isNoneVariable(this.columnVariable)) {
            this.columnMapper = new ConstantMapper(1, 0.5f);
        } else if (!forceDiscrete && this.data.isContinuous(this.columnVariable)) {
            switch (this.columnVariable.sort) {
                case 0: 
                case 1: 
                case 3: {
                    this.columnMapper = new TidyContinuousMapper(this.columnLegendStyle.getIntervals(), 0.0f, this.columnLegendStyle.getIntervals());
                    break;
                }
                case 2: {
                    this.columnMapper = new TidyContinuousMapper(this.columnLegendStyle.getIntervals(), this.columnLegendStyle.getIntervals(), 0.0f);
                    break;
                }
            }
        } else {
            switch (this.columnVariable.sort) {
                case 0: {
                    this.columnMapper = new DiscreteMapper(0.5f);
                    break;
                }
                case 1: {
                    this.columnMapper = new SortedDiscreteMapper(0.5f);
                    break;
                }
                case 2: {
                    this.columnMapper = new ReverseSortedDiscreteMapper(0.5f);
                    break;
                }
                case 3: {
                    this.columnMapper = new ReverseDataDiscreteMapper(0.5f);
                    break;
                }
            }
        }
    }

    protected void assignHeightMapper() {
        float Hmax = !this.data.isContinuous(this.columnVariable) ? (float)this.data.getUniqueObservations(this.columnVariable, this.heightVariable) * this.aspect : (float)this.columnLegendStyle.getIntervals() * this.aspect;
        this.heightMapper = this.isNoneVariable(this.heightVariable) ? new ConstantMapper(1, Hmax) : new TidyContinuousMapper(this.heightLegendStyle.getIntervals(), 0.0f, Hmax);
    }

    @Override
    protected void initializeMappers() {
        int rowCount = this.data.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.data.setRow(i);
            if (this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.heightVariable)) continue;
            this.rowMapper.addValue(this.data.getString(this.rowVariable), this.data.getPrimaryString(this.rowVariable));
            this.heightMapper.addValue(this.data.getString(this.heightVariable));
            this.columnMapper.addValue(this.data.getString(this.columnVariable), this.data.getPrimaryString(this.columnVariable));
        }
    }

    @Override
    protected void removeLegends() {
        this.columnLegend = null;
        this.rowLegend = null;
        this.heightLegend = null;
        this.dataModeState = 9;
        this.offset = 0.5f;
    }

    @Override
    protected void addLegends(Channel ch) {
        ch.glSelect2DFont(this.heightLegendStyle.valueStyle.createFont());
        this.verticalSpaceSize = (float)ch.glGetTextHeight() / 2.0f;
        this.blankSpaceSize = (float)ch.glGetTextWidth(" ");
        if (this.depth != 0) {
            ch.glEnable(3);
        }
        this.addBackPlanes(ch);
        ch.glDisable(3);
        if (!this.isNoneVariable(this.heightVariable)) {
            this.addHeightLegends(ch);
        }
        this.addColumnLegends(ch);
        if (this.depth != 0 && (this.isRiserChart() || this.is3DScatterPlot())) {
            this.addRowLegends(ch);
        }
        ch.glEnable(3);
    }

    protected void addRowLegends(Channel ch) {
        boolean newLegend = this.rowLegend == null;
        boolean oneRow = this.rowLegendStyle.numRows == 1;
        boolean continuous = this.data.isContinuous(this.rowVariable);
        String[] values = this.rowMapper.getValueLabels();
        String[] primaryValues = this.rowMapper.getPrimaryValueLabels();
        String[] formattedValues = this.dataUser.format((Variable)this.rowVariable, values);
        formattedValues = this.dataUser.format((Variable)this.rowVariable, values);
        if (formattedValues == null) {
            formattedValues = values;
        }
        if (this.depth == 2) {
            ExtWireLegend legend;
            if (newLegend) {
                legend = new ExtWireLegend(this.rowMapper);
                this.rowLegend = legend;
                legend.labelStyle = this.rowLegendStyle.labelStyle;
                legend.valuesVisible = this.rowLegendStyle.valuesVisible;
                if (this.rowLegendStyle.numRows == 0) {
                    legend.valueStyle = this.rowLegendStyle.valueStyle;
                } else {
                    TextStyle ts = new TextStyle(this.rowLegendStyle.valueStyle);
                    FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                    int charWidth = fm.stringWidth("Z");
                    int blankSpaces = fm.stringWidth("  ") * this.rowLegend.intervals;
                    if (this.rowLegendStyle.numRows == 1) {
                        ts.maxChars = (this.xSizePixels - blankSpaces) / (charWidth * this.rowLegend.intervals);
                        if (ts.maxChars < ts.minChars) {
                            ts.maxChars = ts.minChars;
                        }
                        this.rowLegend.oneRow = true;
                    } else {
                        ts.maxChars = Math.max(ts.minChars, (2 * this.xSizePixels - blankSpaces) / (charWidth * this.rowLegend.intervals));
                    }
                    legend.valueStyle = ts;
                }
                legend.allFormattedValues = formattedValues;
            } else {
                legend = (ExtWireLegend)this.rowLegend;
            }
            legend.viewMode = this.viewFlag;
            legend.oneRow = false;
            boolean zeroTilt = this.view.tilt + this.view.dTilt == 0.0;
            boolean upside = true;
            if (this.view.tilt + this.view.dTilt < 0.0) {
                this.setNegTiltRowLegend(legend, oneRow);
            } else {
                this.setPosTiltLegend(legend, false, oneRow);
                if (zeroTilt) {
                    legend.oneRow = true;
                    legend.valueStyle.setJustify("CENTER", "TOP");
                }
            }
        } else if (newLegend) {
            this.rowLegend = new WireLegend(this.rowMapper);
            this.rowLegend.labelStyle = this.rowLegendStyle.labelStyle;
            this.rowLegend.valueStyle = this.rowLegendStyle.valueStyle;
            this.rowLegend.origin = new Vec3f(this.xSizeMin, this.ySizeMin, -this.zSizeMin - this.zPadding);
            this.rowLegend.endVector = new Vec3f(this.xSize + 2.0f * this.xPadding, 0.0f, 0.0f);
            this.rowLegend.labelPosition = 0;
            this.rowLegend.valueStyle.setJustify("LEFT", "CENTER");
            this.rowLegend.labelStyle.setJustify("LEFT", "CENTER");
            this.rowLegend.valuesVisible = this.rowLegendStyle.valuesVisible;
        } else {
            this.rowLegend.origin.x = this.xSizeMin;
            this.rowLegend.origin.y = this.ySizeMin;
            this.rowLegend.origin.z = -this.zSizeMin - this.zPadding;
            this.rowLegend.endVector.x = this.xSize + 2.0f * this.xPadding;
            this.rowLegend.valueStyle.setJustify("LEFT", "CENTER");
            this.rowLegend.labelStyle.setJustify("LEFT", "CENTER");
        }
        if (newLegend) {
            this.rowLegend.geomColor = this.rowLegendStyle.grid.color;
            this.rowLegend.continuous = this.is3DScatterPlot() ? this.data.isContinuous(this.rowVariable) : false;
        }
        if (this.rowLegendStyle.isHideLabel()) {
            this.rowLegend.setLabel(null);
        } else {
            this.rowLegend.setLabel(this.data.getDisplayLabel(this.rowVariable), this.data.getPrimaryLabel(this.rowVariable));
        }
        this.rowLegend.threeDAxis = true;
        this.rowLegend.xSize = this.xSize + 2.0f * this.xPadding;
        this.rowLegend.ySize = this.ySize + 2.0f * this.yPadding;
        this.rowLegend.zSize = this.zSize + 2.0f * this.zPadding;
        this.rowLegend.incrementVector = continuous ? new Vec3f(0.0f, 0.0f, -(this.numRows / (float)this.rowMapper.getIntervalCount())) : new Vec3f(0.0f, 0.0f, -1.0f);
        if (this.zSize == (float)this.rowMapper.getIntervalCount()) {
            this.rowLegend.intervals = (int)this.zSize;
            this.rowLegend.values = values;
            this.rowLegend.primaryValues = primaryValues;
            this.rowLegend.formattedValues = formattedValues;
        } else {
            this.rowLegend.intervals = (int)this.zSize;
            String[] rowValues = new String[(int)this.zSize];
            String[] primaryRowValues = new String[(int)this.zSize];
            String[] formRowValues = new String[(int)this.zSize];
            int ms = values.length;
            int pos = 0;
            for (int i = 0; i < ms; ++i) {
                float val = this.rowMapper.getMappedValue(values[i]);
                if (val < this.zSizeMin || val >= this.zSizeMax) continue;
                rowValues[pos] = values[i];
                primaryRowValues[pos] = primaryValues[i];
                formRowValues[pos] = formattedValues[i];
                ++pos;
            }
            this.rowLegend.values = rowValues;
            this.rowLegend.primaryValues = primaryRowValues;
            this.rowLegend.formattedValues = formRowValues;
        }
        this.rowLegend.setValueHotspotsEnabled(this.isColumnValueHotspotsEnabled());
        this.rowLegend.setValueHotspotID(4);
        this.rowLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
        this.rowLegend.setLabelHotspotID(4);
        this.rowLegend.startingOffset = this.zSizeMin;
        if (this.depth == 2) {
            ((ExtWireLegend)this.rowLegend).firstGridLineVisible = true;
        } else {
            ((WireLegend)this.rowLegend).firstGridLineVisible = true;
        }
        if (this.simpleGeometry && !this.data.isContinuous(this.rowVariable)) {
            this.rowLegend.addLegend(ch, false);
        } else {
            this.rowLegend.addLegend(ch, this.rowLegendStyle.grid.visible);
        }
        this.rowValueHotspots = this.rowLegend.getValueHotspots();
        Blob[] b = this.rowLegend.getLabelHotspots();
        Blob blob = this.rowVariableHotspot = b == null ? null : b[0];
        if (this.rowLegend.hLegendOffset > 0.0f) {
            this.xMaxLegendSize += this.rowLegend.hLegendOffset;
        } else {
            this.yMinLegendSize += this.rowLegend.vLegendOffset;
        }
    }

    protected void addColumnLegends(Channel ch) {
        boolean oneRow;
        if (this.xSizeMin == this.xSizeMax) {
            return;
        }
        String[] values = this.columnMapper.getValueLabels();
        String[] primaryValues = this.columnMapper.getPrimaryValueLabels();
        String[] formattedValues = this.dataUser.format((Variable)this.columnVariable, values);
        if (formattedValues == null) {
            formattedValues = values;
        }
        float height = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
        boolean newLegend = this.columnLegend == null;
        boolean bl = oneRow = this.columnLegendStyle.numRows == 1;
        if (this.depth == 2) {
            ExtWireLegend legend;
            if (newLegend) {
                legend = new ExtWireLegend(this.columnMapper);
                this.columnLegend = legend;
                legend.labelStyle = this.columnLegendStyle.labelStyle;
                legend.labelPosition = 1;
                legend.valuesVisible = this.columnLegendStyle.valuesVisible;
                if (this.columnLegendStyle.numRows == 0) {
                    this.columnLegend.valueStyle = this.columnLegendStyle.valueStyle;
                } else {
                    TextStyle ts = new TextStyle(this.columnLegendStyle.valueStyle);
                    FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                    int charWidth = fm.stringWidth("Z");
                    int blankSpaces = fm.stringWidth("  ") * this.columnLegend.intervals;
                    if (this.columnLegendStyle.numRows == 1) {
                        ts.maxChars = (this.xSizePixels - blankSpaces) / (charWidth * this.columnLegend.intervals);
                        if (ts.maxChars < ts.minChars) {
                            ts.maxChars = ts.minChars;
                        }
                        this.columnLegend.oneRow = true;
                    } else {
                        ts.maxChars = Math.max(ts.minChars, (2 * this.xSizePixels - blankSpaces) / (charWidth * this.columnLegend.intervals));
                    }
                    this.columnLegend.valueStyle = ts;
                }
                legend.allFormattedValues = formattedValues;
            } else {
                legend = (ExtWireLegend)this.columnLegend;
            }
            float z1 = this.zSize + 2.0f * this.zPadding;
            boolean column = true;
            if (this.view.tilt + this.view.dTilt <= 0.0) {
                this.setNegTiltLegend(legend, oneRow);
            } else {
                this.setPosTiltLegend(legend, column, oneRow);
            }
        } else if (newLegend) {
            this.columnLegend = new WireLegend(this.columnMapper);
            this.columnLegend.labelStyle = this.columnLegendStyle.labelStyle;
            this.columnLegend.origin = new Vec3f(this.xPadding + this.xSizeMin, this.ySizeMin, -this.zSizeMin);
            this.columnLegend.endVector = new Vec3f(0.0f, this.ySize + 2.0f * this.yPadding, 0.0f);
            this.columnLegend.labelStyle = this.columnLegendStyle.labelStyle;
            this.columnLegend.labelPosition = 1;
            this.columnLegend.valuesVisible = this.columnLegendStyle.valuesVisible;
            if (this.columnLegendStyle.numRows == 0) {
                this.columnLegend.valueStyle = this.columnLegendStyle.valueStyle;
            } else {
                TextStyle ts = new TextStyle(this.columnLegendStyle.valueStyle);
                FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int charWidth = fm.stringWidth("Z");
                int blankSpaces = fm.stringWidth("  ") * this.columnLegend.intervals;
                if (this.columnLegendStyle.numRows == 1) {
                    ts.maxChars = (this.xSizePixels - blankSpaces) / (charWidth * this.columnLegend.intervals);
                    if (ts.maxChars < ts.minChars) {
                        ts.maxChars = ts.minChars;
                    }
                    this.columnLegend.oneRow = true;
                } else {
                    ts.maxChars = Math.max(ts.minChars, (2 * this.xSizePixels - blankSpaces) / (charWidth * this.columnLegend.intervals));
                }
                this.columnLegend.valueStyle = ts;
            }
            this.columnLegend.valueStyle.setJustify("CENTER", "TOP");
            this.columnLegend.labelStyle.setJustify("CENTER", "TOP");
        } else {
            this.columnLegend.endVector.y = this.ySize + 2.0f * this.yPadding;
            this.columnLegend.origin.x = this.xSizeMin + this.xPadding;
            this.columnLegend.origin.y = this.ySizeMin;
            this.columnLegend.origin.z = -this.zSizeMin;
        }
        if (newLegend) {
            Color geomColor;
            this.columnLegend.geomColor = geomColor = this.columnLegendStyle.grid.color;
            this.columnLegend.valuesVisible = this.columnLegendStyle.isValuesVisible();
            if (this.columnLegendStyle.isHideLabel()) {
                this.columnLegend.setLabel(null);
            } else {
                this.columnLegend.setLabel(this.data.getDisplayLabel(this.columnVariable), this.data.getPrimaryLabel(this.columnVariable));
            }
            this.columnLegend.continuous = this.data.isContinuous(this.columnVariable);
        }
        Vec3f incrementVector = !this.data.isContinuous(this.columnVariable) ? new Vec3f(1.0f, 0.0f, 0.0f) : new Vec3f(this.xSize / (float)this.columnMapper.getIntervalCount(), 0.0f, 0.0f);
        this.columnLegend.incrementVector = incrementVector;
        if (this.xSize != this.numColumns) {
            this.columnLegend.intervals = (int)this.xSize;
            String[] columnValues = new String[(int)this.xSize];
            String[] primaryColumnValues = new String[(int)this.xSize];
            String[] formColValues = new String[(int)this.xSize];
            int ms = values.length;
            int pos = 0;
            for (int j = 0; j < ms; ++j) {
                float val = this.columnMapper.getMappedValue(values[j]);
                if (val < this.xSizeMin || val >= this.xSizeMax) continue;
                columnValues[pos] = values[j];
                primaryColumnValues[pos] = primaryValues[j];
                formColValues[pos] = formattedValues[j];
                ++pos;
            }
            this.columnLegend.values = columnValues;
            this.columnLegend.primaryValues = primaryColumnValues;
            this.columnLegend.formattedValues = formColValues;
        } else {
            this.columnLegend.values = values;
            this.columnLegend.primaryValues = primaryValues;
            this.columnLegend.formattedValues = formattedValues;
            this.columnLegend.intervals = this.columnMapper.getIntervalCount();
        }
        this.columnLegend.startingOffset = this.xSizeMin;
        this.columnLegend.origin.x = this.xPadding + this.xSizeMin;
        if (this.depth != 0) {
            this.columnLegend.threeDAxis = true;
            this.columnLegend.xSize = this.xSize + 2.0f * this.xPadding;
            this.columnLegend.ySize = this.ySize + 2.0f * this.yPadding;
            this.columnLegend.zSize = this.zSize + 2.0f * this.zPadding;
        }
        this.columnLegend.setValueHotspotsEnabled(this.isColumnValueHotspotsEnabled());
        this.columnLegend.setValueHotspotID(1);
        this.columnLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
        this.columnLegend.setLabelHotspotID(1);
        if (this.simpleGeometry && !this.data.isContinuous(this.columnVariable)) {
            this.columnLegend.addLegend(ch, false);
        } else {
            this.columnLegend.addLegend(ch, this.columnLegendStyle.grid.visible);
        }
        this.columnValueHotspots = this.columnLegend.getValueHotspots();
        Blob[] b = this.columnLegend.getLabelHotspots();
        Blob blob = this.columnVariableHotspot = b == null ? null : b[0];
        if (this.columnLegend.vLegendOffset > 0.0f) {
            this.yMinLegendSize += this.columnLegend.vLegendOffset;
        } else {
            this.xMinLegendSize += this.columnLegend.hLegendOffset;
        }
    }

    protected void addHeightLegends(Channel ch) {
        Vec3f incrementVector;
        boolean newLegend;
        float height = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
        boolean bl = newLegend = this.heightLegend == null;
        if (this.depth == 2) {
            int region;
            ExtWireLegend legend;
            if (newLegend) {
                legend = new ExtWireLegend(this.heightMapper);
                this.heightLegend = legend;
                legend.valueStyle = this.heightLegendStyle.valueStyle;
                legend.labelStyle = this.heightLegendStyle.labelStyle;
                legend.valueAlongX = false;
                String[] values = this.heightMapper.getValueLabels();
                String[] formattedValues = this.dataUser.format((Variable)this.heightVariable, values);
                formattedValues = this.dataUser.format((Variable)this.heightVariable, values);
                legend.valuesVisible = this.heightLegendStyle.valuesVisible;
                legend.allFormattedValues = formattedValues == null ? values : formattedValues;
            } else {
                legend = (ExtWireLegend)this.heightLegend;
            }
            legend.viewMode = this.viewFlag;
            legend.labelPosition = 2;
            double remainder = (this.view.rotation + this.view.dRot) % 360.0;
            if (remainder < 0.0) {
                remainder += 360.0;
            }
            if ((region = (int)Math.floor(remainder / 90.0)) < 2) {
                legend.labelStyle.setJustify("LEFT", "BOTTOM");
            } else {
                legend.labelStyle.setJustify("RIGHT", "BOTTOM");
            }
            float x1 = this.xSize + 2.0f * this.xPadding;
            float z1 = this.zSize + 2.0f * this.zPadding;
            switch (region) {
                default: {
                    legend.origin = new Vec3f(this.xSizeMin, this.yPadding, -this.zSizeMin);
                    legend.midVector = new Vec3f(0.0f, 0.0f, -z1);
                    legend.endVector = new Vec3f(x1, 0.0f, 0.0f);
                    legend.tickDir = 2;
                    legend.valueStyle.setJustify("RIGHT", "CENTER");
                    break;
                }
                case 1: {
                    legend.origin = new Vec3f(x1 + this.xSizeMin, this.yPadding, -this.zSizeMin);
                    legend.midVector = new Vec3f(-x1, 0.0f, 0.0f);
                    legend.endVector = new Vec3f(0.0f, 0.0f, -z1);
                    legend.tickDir = 2;
                    legend.valueStyle.setJustify("RIGHT", "CENTER");
                    break;
                }
                case 2: {
                    legend.origin = new Vec3f(this.xSizeMin, this.yPadding, -this.zSizeMin);
                    legend.midVector = new Vec3f(x1, 0.0f, 0.0f);
                    legend.endVector = new Vec3f(0.0f, 0.0f, -z1);
                    legend.tickDir = 3;
                    legend.valueStyle.setJustify("LEFT", "CENTER");
                    break;
                }
                case 3: {
                    legend.origin = new Vec3f(x1 + this.xSizeMin, this.yPadding, -this.zSizeMin);
                    legend.midVector = new Vec3f(0.0f, 0.0f, -z1);
                    legend.endVector = new Vec3f(-x1, 0.0f, 0.0f);
                    legend.tickDir = 3;
                    legend.valueStyle.setJustify("LEFT", "CENTER");
                    break;
                }
            }
        } else if (newLegend) {
            this.heightLegend = new WireLegend(this.heightMapper);
            this.heightLegend.valueStyle = this.heightLegendStyle.valueStyle;
            this.heightLegend.labelStyle = this.heightLegendStyle.labelStyle;
            this.heightLegend.valueStyle.setJustify("RIGHT", "CENTER");
            this.heightLegend.labelStyle.setJustify("RIGHT", "BOTTOM");
            this.heightLegend.labelPosition = 2;
            this.heightLegend.valuesVisible = this.heightLegendStyle.valuesVisible;
            this.heightLegend.origin = new Vec3f(this.xSizeMin, this.ySizeMin + this.yPadding, (float)this.rowLegendStyle.getOrigin() - this.zSizeMin);
            this.heightLegend.endVector = new Vec3f(this.xSize + 2.0f * this.xPadding, 0.0f, 0.0f);
        } else {
            this.heightLegend.origin.x = this.xSizeMin;
            this.heightLegend.origin.y = this.ySizeMin + this.yPadding;
            this.heightLegend.origin.z = -this.zSizeMin;
            this.heightLegend.endVector.x = this.xSize + 2.0f * this.xPadding;
        }
        if (newLegend) {
            Color geomColor;
            this.heightLegend.geomColor = geomColor = this.heightLegendStyle.grid.color;
            this.heightLegend.valuesVisible = this.heightLegendStyle.isValuesVisible();
            if (this.heightLegendStyle.isHideLabel()) {
                this.heightLegend.setLabel(null);
            } else {
                this.heightLegend.setLabel(this.data.getDisplayLabel(this.heightVariable));
            }
            this.heightLegend.continuous = true;
        }
        this.heightLegend.intervals = this.heightMapper.getIntervalCount();
        this.heightLegend.incrementVector = incrementVector = new Vec3f(0.0f, this.ySize / (float)this.heightMapper.getIntervalCount(), 0.0f);
        this.heightLegend.distortX = this.distortX;
        String[] values = this.heightMapper.getValueLabels();
        String[] formattedValues = this.dataUser.format((Variable)this.heightVariable, values);
        formattedValues = this.dataUser.format((Variable)this.heightVariable, values);
        this.heightLegend.values = values;
        this.heightLegend.formattedValues = formattedValues == null ? values : formattedValues;
        if (this.depth != 0) {
            this.heightLegend.threeDAxis = true;
            this.heightLegend.xSize = this.xSize + 2.0f * this.xPadding;
            this.heightLegend.ySize = this.ySize + 2.0f * this.yPadding;
            this.heightLegend.zSize = this.zSize + 2.0f * this.zPadding;
        } else {
            this.heightLegend.zSize = 0.0;
        }
        this.heightLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
        this.heightLegend.setLabelHotspotID(5);
        this.heightLegend.vLabelOffset = this.yMaxLegendSize;
        this.heightLegend.addLegend(ch, this.heightLegendStyle.grid.visible);
        this.yMaxLegendSize += this.heightLegend.vLegendOffset + this.verticalSpaceSize;
        this.xMinLegendSize += this.heightLegend.hLegendOffset;
        Blob[] b = this.heightLegend.getLabelHotspots();
        this.heightVariableHotspot = b == null ? null : b[0];
    }

    @Override
    protected void addAxes(Channel ch) {
        float zo;
        float yo;
        float xo;
        boolean d3 = this.depth == 2;
        int region = (int)((this.view.rotation + this.view.dRot) / 90.0);
        float height = 0.0f;
        if (this.rowLegendStyle.axisType == 1) {
            Axis rowAxis = new Axis();
            xo = this.view.tilt + this.view.dTilt < 0.0 ? (!d3 || region < 2 ? this.xSize + 2.0f * this.xPadding : (float)this.rowLegendStyle.getOrigin()) : (!d3 || region < 2 ? (float)this.rowLegendStyle.getOrigin() : this.xSize + 2.0f * this.xPadding);
            yo = height;
            rowAxis.origin = new Vec3f(xo, yo, -this.zSizeMin);
            rowAxis.endVector = new Vec3f(0.0f, 0.0f, -this.zSize - 2.0f * this.zPadding);
            rowAxis.color = this.rowLegendStyle.axisColor;
            rowAxis.addGeometry(ch);
        }
        if (this.columnLegendStyle.axisType == 1) {
            Axis columnAxis = new Axis();
            xo = (float)this.columnLegendStyle.getOrigin() + this.xSizeMin;
            yo = this.heightMapper instanceof ConstantMapper ? 0.0f : height;
            zo = !d3 || this.view.tilt + this.view.dTilt < 0.0 ? (d3 && (region == 1 || region == 2) ? -this.zSize - 2.0f * this.zPadding - this.zSizeMin : (float)this.rowLegendStyle.getOrigin() - this.zSizeMin) : (region == 1 || region == 2 ? (float)this.rowLegendStyle.getOrigin() - this.zSizeMin : -this.zSize - 2.0f * this.zPadding - this.zSizeMin);
            columnAxis.origin = new Vec3f(xo, yo, zo);
            columnAxis.endVector = new Vec3f(this.xSize + 2.0f * this.xPadding, 0.0f, 0.0f);
            columnAxis.color = this.columnLegendStyle.axisColor;
            columnAxis.addGeometry(ch);
        }
        if (this.heightLegendStyle.axisType == 1) {
            Axis heightAxis = new Axis();
            xo = !d3 || this.view.tilt + this.view.dTilt < 0.0 ? (region < 2 ? (float)this.columnLegendStyle.getOrigin() + this.xSizeMin : this.xSizeMin + this.xSize + 2.0f * this.xPadding) : (region < 2 ? (float)this.columnLegendStyle.getOrigin() + this.xSizeMin : this.xSize + 2.0f * this.xPadding + this.xSizeMin);
            yo = 0.0f;
            zo = !d3 || this.view.tilt + this.view.dTilt < 0.0 ? (d3 && (region == 1 || region == 2) ? -this.zSize - 2.0f * this.zPadding - this.zSizeMin : (float)this.rowLegendStyle.getOrigin() - this.zSizeMin) : (d3 && (region == 1 || region == 2) ? (float)this.rowLegendStyle.getOrigin() - this.zSizeMin : -this.zSize - 2.0f * this.zPadding - this.zSizeMin);
            heightAxis.origin = new Vec3f(xo, yo, zo);
            heightAxis.endVector = new Vec3f(0.0f, this.ySize + 2.0f * this.yPadding, 0.0f);
            heightAxis.color = this.heightLegendStyle.axisColor;
            heightAxis.addGeometry(ch);
        }
    }

    @Override
    protected void scaleText(Channel ch) {
        super.scaleText(ch);
        TextStyle ts = this.rowLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.rowLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.columnLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.columnLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.heightLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.heightLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        if (this.horizontalRefline != null) {
            ts = this.horizontalRefline.getLabelStyle();
            ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        }
        if (this.verticalRefline != null) {
            ts = this.verticalRefline.getLabelStyle();
            ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        }
    }

    protected void addBackPlanes(Channel ch) {
        double x0 = this.columnLegendStyle.getOrigin() + (double)this.xSizeMin;
        double y0 = this.heightLegendStyle.getOrigin() + (double)this.ySizeMin;
        double z0 = this.rowLegendStyle.getOrigin() + (double)this.zSizeMin;
        double xxSize = this.xSize + 2.0f * this.xPadding;
        double yySize = this.ySize + 2.0f * this.yPadding;
        double zzSize = this.zSize + 2.0f * this.zPadding;
        boolean d3 = this.depth == 2;
        int polygonMode = ch.getPolygonMode();
        ch.glColor(this.backplaneColor);
        if (this.backplaneVisible) {
            if (this.edgeColor != null) {
                ch.glPolygonMode(4);
                ch.glEdgeColor(this.edgeColor);
            } else {
                ch.glPolygonMode(3);
            }
        } else {
            ch.glPolygonMode(2);
        }
        int region = (int)((this.view.rotation + this.view.dRot) / 90.0);
        if (!d3 || this.viewFlag || region == 0 || region == 3) {
            ch.glBegin(2);
            ch.glNormal(0.0, 0.0, 1.0);
            ch.glVertex(x0, y0, -z0 - zzSize);
            ch.glVertex(x0 + xxSize, y0, -z0 - zzSize);
            ch.glVertex(x0 + xxSize, y0 + yySize, -z0 - zzSize);
            ch.glVertex(x0, y0 + yySize, -z0 - zzSize);
            ch.glEnd();
        }
        if (d3 && (this.viewFlag || region == 1 || region == 2)) {
            ch.glBegin(2);
            ch.glNormal(0.0, 0.0, -1.0);
            ch.glVertex(x0 + xxSize, y0, -z0);
            ch.glVertex(x0, y0, -z0);
            ch.glVertex(x0, y0 + yySize, -z0);
            ch.glVertex(x0 + xxSize, y0 + yySize, -z0);
            ch.glEnd();
        }
        if (!d3 || this.viewFlag || region < 2) {
            ch.glBegin(2);
            ch.glNormal(1.0, 0.0, 0.0);
            ch.glVertex(x0, y0, -z0);
            ch.glVertex(x0, y0, -z0 - zzSize);
            ch.glVertex(x0, y0 + yySize, -z0 - zzSize);
            ch.glVertex(x0, y0 + yySize, -z0);
            ch.glEnd();
        }
        if (d3 && (this.viewFlag || region >= 2)) {
            ch.glBegin(2);
            ch.glNormal(-1.0, 0.0, 0.0);
            ch.glVertex(x0 + xxSize, y0, -z0);
            ch.glVertex(x0 + xxSize, y0 + yySize, -z0);
            ch.glVertex(x0 + xxSize, y0 + yySize, -z0 - zzSize);
            ch.glVertex(x0 + xxSize, y0, -z0 - zzSize);
            ch.glEnd();
        }
        if (!d3 || this.view.tilt + this.view.dTilt < 0.0) {
            ch.glBegin(2);
            ch.glVertex(x0, y0, -z0);
            ch.glVertex(x0 + xxSize, y0, -z0);
            ch.glVertex(x0 + xxSize, y0, -z0 - zzSize);
            ch.glVertex(x0, y0, -z0 - zzSize);
            ch.glEnd();
        }
        ch.glPolygonMode(polygonMode);
        if (this.edgeColor != null) {
            ch.glEdgeColor(this.edgeColor);
        }
        if (this.depth == 1) {
            double[] front = new double[]{this.xSizeMin, this.ySizeMin, -z0};
            double[] back = new double[]{this.xSizeMin, this.ySizeMin, -z0 - zzSize};
            ch.gluProject(front, front);
            ch.gluProject(back, back);
            double[] origin = new double[]{0.0, 0.0, 0.0};
            ch.gluUnProject(origin, origin);
            double[] width_off = new double[]{back[0] - front[0], 0.0, 0.0};
            ch.gluUnProject(width_off, width_off);
            this.distortX = width_off[0] - origin[0];
            double[] height_off = new double[]{0.0, front[1] - back[1], 0.0};
            ch.gluUnProject(height_off, height_off);
            this.distortY = origin[1] - height_off[1];
        } else {
            this.distortX = 0.0;
            this.distortY = 0.0;
        }
    }

    @Override
    protected abstract void setProjection(Channel var1);

    @Override
    protected void setInitialViewpoint(Channel ch) {
        switch (this.depth) {
            case 2: {
                double twist = this.view.twist + this.view.dTwist;
                double rotation = this.view.dRot + this.view.rotation;
                double tilt = this.view.tilt + this.view.dTilt;
                ch.gluLookAt(this.view.xCenter + this.view.dXCent + (double)this.xSizeMin, this.view.yCenter + this.view.dYCent + (double)this.ySizeMin, this.view.zCenter + this.view.dZCent - (double)this.zSizeMin, this.view.distance + this.view.dDist, rotation, tilt, twist);
                break;
            }
            default: {
                ch.gluLookAt(this.xSizeMin, this.ySizeMin, -this.zSizeMin, 0.1, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isRiserChart() {
        return this instanceof Bar && this.rowVariable != null && this.rowVariable.name != null && !this.rowVariable.name.trim().equals("");
    }

    @Override
    public boolean is3DScatterPlot() {
        return this instanceof Scatter && this.rowVariable != null && this.rowVariable.name != null && !this.rowVariable.name.trim().equals("");
    }

    protected void setNegTiltLegend(ExtWireLegend legend, boolean oneRow) {
        String vminor;
        String major;
        legend.viewMode = this.viewFlag;
        legend.oneRow = false;
        float xo = this.xSizeMin;
        float x1 = this.xSizeMin;
        float yo = this.ySizeMin;
        float y1 = this.ySize + 2.0f * this.yPadding;
        float zo = -this.zSizeMin;
        float z1 = -this.zSize - 2.0f * this.zPadding;
        double remainder = (this.view.rotation + this.view.dRot) % 360.0;
        if (remainder < 0.0) {
            remainder += 360.0;
        }
        int region = (int)Math.floor(remainder / 90.0);
        String minor = "TOP";
        TextStyle ts = new TextStyle(legend.valueStyle);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueHeightPixels = fm.getHeight();
        double valueHeight = (double)valueHeightPixels * (double)this.ySize / (double)this.ySizePixels;
        legend.valueAlongX = 0.2 * valueHeight > Math.abs(Math.sin(this.view.tilt + this.view.dTilt) * Math.cos(remainder));
        legend.oneRow = oneRow && !legend.valueAlongX;
        int subregion = (int)(remainder % 90.0) / 30;
        if (this.zSize < 3.0f) {
            legend.labelPosition = 1;
            major = "CENTER";
            vminor = minor;
        } else if (region == 0 && subregion != 0) {
            major = "RIGHT";
            vminor = subregion == 1 ? minor : "CENTER";
            legend.labelPosition = 2;
        } else if (region == 1 && subregion != 2) {
            major = "LEFT";
            vminor = subregion == 1 ? minor : "CENTER";
            minor = "BOTTOM";
            legend.labelPosition = 0;
        } else if (region == 2 && subregion != 0) {
            major = "RIGHT";
            vminor = subregion == 1 ? minor : "CENTER";
            minor = "BOTTOM";
            legend.labelPosition = 2;
        } else if (region == 3 && subregion != 2) {
            major = "LEFT";
            vminor = subregion == 1 ? minor : "CENTER";
            legend.labelPosition = 0;
        } else {
            legend.labelPosition = 1;
            major = "CENTER";
            vminor = minor;
            legend.oneRow = oneRow;
        }
        legend.valueStyle.setJustify(major, vminor);
        legend.labelStyle.setJustify(major, minor);
        switch (region) {
            default: {
                legend.origin = new Vec3f(xo, yo, zo);
                legend.midVector = new Vec3f(0.0f, 0.0f, z1);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
                if (this.zSize < 3.0f || subregion == 0) {
                    legend.tickDir = 0;
                    break;
                }
                legend.tickDir = 2;
                break;
            }
            case 1: {
                legend.origin = new Vec3f(xo, yo, zo + z1);
                legend.midVector = new Vec3f(0.0f, 0.0f, -z1);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
                if (this.zSize < 3.0f || subregion == 2) {
                    legend.tickDir = 0;
                    break;
                }
                legend.tickDir = 3;
                break;
            }
            case 2: {
                legend.origin = new Vec3f(xo, yo, zo + z1);
                legend.midVector = new Vec3f(0.0f, 0.0f, -z1);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
                if (this.zSize < 3.0f || subregion == 0) {
                    legend.tickDir = 0;
                    break;
                }
                legend.tickDir = 2;
                break;
            }
            case 3: {
                legend.origin = new Vec3f(xo, yo, zo);
                legend.midVector = new Vec3f(0.0f, 0.0f, z1);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
                legend.tickDir = this.zSize < 3.0f || subregion != 0 ? 0 : 3;
            }
        }
    }

    protected void setNegTiltRowLegend(ExtWireLegend legend, boolean oneRow) {
        double remainder = (this.view.rotation + this.view.dRot) % 360.0;
        float xo = this.xSizeMin;
        float x1 = this.xSize + 2.0f * this.xPadding;
        float yo = this.ySizeMin;
        float y1 = this.ySize + 2.0f * this.yPadding;
        float zo = -this.zSizeMin;
        float z1 = -this.zPadding;
        if (remainder < 0.0) {
            remainder += 360.0;
        }
        int region = (int)Math.floor(remainder / 90.0);
        int sixlet = (int)(remainder / 60.0);
        int subregion = sixlet % 3;
        TextStyle ts = new TextStyle(legend.valueStyle);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueHeightPixels = fm.getHeight();
        double valueHeight = (double)valueHeightPixels * (double)this.ySize / (double)this.ySizePixels;
        legend.valueAlongX = 0.2 * valueHeight > Math.abs(Math.sin(this.view.tilt + this.view.dTilt) * Math.cos(remainder + 90.0));
        boolean bl = legend.oneRow = oneRow && !legend.valueAlongX;
        if (subregion == 1 || this.zSize < 3.0f) {
            legend.valueStyle.setJustify("CENTER", "TOP");
            legend.labelStyle.setJustify("CENTER", "TOP");
            legend.labelPosition = 1;
        } else {
            legend.labelPosition = 2;
            if (subregion == 0) {
                if (remainder % 60.0 / 30.0 > 1.0) {
                    legend.valueStyle.setJustify("LEFT", "TOP");
                } else {
                    legend.valueStyle.setJustify("LEFT", "CENTER");
                }
                if (region == 0) {
                    legend.labelStyle.setJustify("LEFT", "BOTTOM");
                } else {
                    legend.labelStyle.setJustify("LEFT", "TOP");
                }
            } else {
                if (remainder % 60.0 / 30.0 > 1.0) {
                    legend.valueStyle.setJustify("RIGHT", "CENTER");
                } else {
                    legend.valueStyle.setJustify("RIGHT", "TOP");
                }
                if (region == 3) {
                    legend.labelStyle.setJustify("RIGHT", "BOTTOM");
                } else {
                    legend.labelStyle.setJustify("RIGHT", "TOP");
                }
            }
        }
        switch (region) {
            default: {
                legend.origin = new Vec3f(xo + x1, yo, zo);
                legend.midVector = new Vec3f(-x1, 0.0f, 0.0f);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
                if (this.zSize < 3.0f || subregion != 0) {
                    legend.tickDir = 0;
                    break;
                }
                legend.tickDir = 5;
                break;
            }
            case 1: {
                legend.origin = new Vec3f(xo + x1, yo, zo);
                legend.midVector = new Vec3f(-x1, 0.0f, 0.0f);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
                if (this.zSize < 3.0f || subregion != 2) {
                    legend.tickDir = 0;
                    break;
                }
                legend.tickDir = 2;
                break;
            }
            case 2: {
                legend.origin = new Vec3f(xo, yo, zo);
                legend.midVector = new Vec3f(x1, 0.0f, 0.0f);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
                if (this.zSize < 3.0f || subregion == 1) {
                    legend.tickDir = 0;
                    break;
                }
                legend.tickDir = 5;
                break;
            }
            case 3: {
                legend.origin = new Vec3f(xo, yo, zo);
                legend.midVector = new Vec3f(x1, 0.0f, 0.0f);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
                legend.tickDir = this.zSize < 3.0f || subregion != 2 ? 0 : 2;
            }
        }
    }

    protected void setPosTiltLegend(ExtWireLegend legend, boolean column, boolean oneRow) {
        legend.viewMode = this.viewFlag;
        float xo = this.xSizeMin;
        float x1 = this.xSizeMin + this.xSize + 2.0f * this.xPadding;
        float yo = this.ySizeMin;
        float y1 = this.ySize + 2.0f * this.yPadding;
        float zo = -this.zSizeMin;
        float z1 = column ? -this.zSizeMin - this.zSize - 2.0f * this.zPadding : -this.zSizeMin;
        double remainder = (this.view.rotation + this.view.dRot) % 360.0;
        if (remainder < 0.0) {
            remainder += 360.0;
        }
        if (!column) {
            remainder = (remainder + 90.0) % 360.0;
        }
        TextStyle ts = new TextStyle(legend.valueStyle);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueHeightPixels = fm.getHeight();
        double valueHeight = (double)valueHeightPixels * (double)this.ySize / (double)this.ySizePixels;
        legend.valueAlongX = 0.2 * valueHeight > Math.abs(Math.sin(this.view.tilt + this.view.dTilt) * Math.cos(remainder));
        int region = (int)Math.floor(remainder / 90.0);
        int subregion = (int)(remainder % 90.0) / 30;
        if (!column) {
            if (region == 0) {
                xo = x1;
            }
        } else if (!this.vertical && region == 3) {
            x1 = xo;
        }
        if (this.zSize < 3.0f) {
            legend.valueStyle.setJustify("CENTER", "TOP");
            legend.labelStyle.setJustify("CENTER", "TOP");
            legend.labelPosition = 1;
            legend.tickDir = 0;
        } else if (region % 2 == 0 && subregion != 0) {
            legend.valueStyle.setJustify("LEFT", "TOP");
            legend.labelStyle.setJustify("LEFT", "TOP");
            legend.labelPosition = 2;
            legend.tickDir = subregion == 2 ? 3 : 0;
        } else if (region % 2 == 1 && subregion != 2) {
            legend.valueStyle.setJustify("RIGHT", "TOP");
            legend.labelStyle.setJustify("RIGHT", "TOP");
            legend.labelPosition = 0;
            legend.oneRow = oneRow;
            legend.tickDir = subregion == 0 ? 2 : 0;
        } else {
            legend.valueStyle.setJustify("CENTER", "TOP");
            legend.labelStyle.setJustify("CENTER", "TOP");
            legend.labelPosition = 1;
            legend.tickDir = 0;
        }
        switch (region) {
            default: {
                legend.origin = new Vec3f(xo, yo, z1);
                legend.midVector = new Vec3f(0.0f, 0.0f, 0.0f);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
                break;
            }
            case 1: {
                legend.origin = new Vec3f(xo, yo, zo);
                legend.midVector = new Vec3f(0.0f, 0.0f, 0.0f);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
                break;
            }
            case 2: {
                legend.origin = new Vec3f(xo, yo, zo);
                legend.midVector = new Vec3f(0.0f, 0.0f, 0.0f);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
                break;
            }
            case 3: {
                legend.origin = new Vec3f(x1, yo, z1);
                legend.midVector = new Vec3f(0.0f, 0.0f, 0.0f);
                legend.endVector = new Vec3f(0.0f, y1, 0.0f);
            }
        }
    }

    @Override
    protected void computeView(Channel ch) {
        double dist;
        if (this.buildDone) {
            return;
        }
        this.view.resetView();
        double yfac = this.ySize / (float)this.ySizePixels;
        double mfac = 0.5;
        this.view.tilt = -30.0;
        this.view.rotation = 30.0;
        double cosx = mfac * Math.cos(this.view.rotation * Math.PI / 180.0) * (double)this.zSize;
        double siny = mfac * Math.sin(this.view.tilt * Math.PI / 180.0) * (double)this.zSize / (double)this.aspect;
        siny = Math.abs(siny);
        cosx = Math.abs(cosx);
        double xMin = (double)(-this.xMinLegendSize) - cosx;
        double xMax = (double)(this.xSize + this.xMaxLegendSize + 2.0f * this.xPadding) + cosx;
        double xMax2 = (double)(this.numColumns + this.xMaxLegendSize + 2.0f * this.xPadding) + cosx;
        double yMin = (double)(-this.yMinLegendSize) - (double)this.yColorLegendSize * yfac - siny;
        double yMax = (double)(this.ySize + this.yMaxLegendSize + 2.0f * this.yPadding) + (double)this.yTitleSize * yfac + siny;
        double dx = (xMax - xMin) * 1.06;
        double dx2 = (xMax2 - xMin) * 1.06;
        double dy = (yMax - yMin) * 1.06;
        this.view.xCenter = (xMax + xMin) * 0.5;
        this.view.yCenter = (yMax + yMin) * 0.4;
        this.view.zCenter = (double)(-this.zSize) * 0.5;
        if (this.vertical) {
            double fac = this.xSize / this.numColumns;
            dist = Math.max(dx2, dy);
            this.view.aspect = Math.max(fac, dx / dist);
            this.view.fov = View.DEFAULT_FOV;
        } else {
            double fac = this.ySize / this.numColumns;
            this.view.aspect = 1.0 / fac;
            dist = 0.9 * Math.max(dx * fac, dy * (double)this.aspect);
            this.view.fov = View.DEFAULT_FOV * fac;
        }
        this.view.distance = dist / Math.tan(Math.PI * this.view.fov / 180.0);
    }

    @Override
    public void doDataScrolling(Channel ch, int x, int y, int prevx, int prevy) {
        if (this.dataModeState == 9) {
            return;
        }
        boolean rebuild = false;
        double deltaX = 0.5 * (double)this.numColumns * (double)(x - prevx) / (double)this.xSizePixels;
        double deltaY = 0.5 * (double)this.numColumns * (double)(prevy - y) / (double)this.ySizePixels;
        double deltaZ = 0.5 * (double)(this.numColumns + this.numRows) * (double)(x - prevx + prevy - y) / (double)(this.xSizePixels + this.ySizePixels);
        switch (this.dataModeState) {
            case 0: {
                this.offset = (float)((double)this.offset + deltaX);
                if (this.offset < 0.0f) {
                    while (this.offset < 0.0f) {
                        if (this.xSizeMin > 0.0f) {
                            this.xSizeMin -= 1.0f;
                            this.xSize += 1.0f;
                            rebuild = true;
                        }
                        this.offset += 0.5f;
                    }
                } else {
                    if (!(this.offset > 1.0f)) break;
                    while (this.offset > 1.0f) {
                        if (this.xSizeMin + 1.0f < this.xSizeMax) {
                            this.xSizeMin += 1.0f;
                            this.xSize -= 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                break;
            }
            default: {
                this.offset = (float)((double)this.offset + deltaX);
                if (this.offset < 0.0f) {
                    while (this.offset < 0.0f) {
                        if (this.xSizeMin > 0.0f) {
                            this.xSizeMin -= 1.0f;
                            this.xSizeMax -= 1.0f;
                            rebuild = true;
                        }
                        this.offset += 0.5f;
                    }
                } else {
                    if (!(this.offset > 1.0f)) break;
                    while (this.offset > 1.0f) {
                        if (this.xSizeMax < this.numColumns) {
                            this.xSizeMin += 1.0f;
                            this.xSizeMax += 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                break;
            }
            case 1: {
                this.offset = (float)((double)this.offset + deltaX);
                if (this.offset > 1.0f) {
                    while (this.offset > 1.0f) {
                        if (this.xSizeMax < this.numColumns) {
                            this.xSize += 1.0f;
                            this.xSizeMax += 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                if (!(this.offset < 0.0f)) break;
                while (this.offset < 0.0f) {
                    if (this.xSizeMax > this.xSizeMin + 1.0f) {
                        this.xSize -= 1.0f;
                        this.xSizeMax -= 1.0f;
                        rebuild = true;
                    }
                    this.offset += 0.5f;
                }
                break;
            }
            case 4: {
                this.offset = (float)((double)this.offset + deltaY);
                if (this.offset < 0.0f) {
                    while (this.offset < 0.0f) {
                        if (this.ySizeMin > 0.0f) {
                            this.ySizeMin -= 1.0f;
                            this.ySize += 1.0f;
                            rebuild = true;
                        }
                        this.offset += 0.5f;
                    }
                } else {
                    if (!(this.offset > 1.0f)) break;
                    while (this.offset > 1.0f) {
                        if (this.ySizeMin + 1.0f < this.ySizeMax) {
                            this.ySizeMin += 1.0f;
                            this.ySize -= 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                break;
            }
            case 5: {
                this.offset = (float)((double)this.offset + deltaY);
                if (this.offset < 0.0f) {
                    while (this.offset < 0.0f) {
                        if (this.ySizeMin > 0.0f) {
                            this.ySizeMin -= 1.0f;
                            this.ySizeMax -= 1.0f;
                            rebuild = true;
                        }
                        this.offset += 0.5f;
                    }
                } else {
                    if (!(this.offset > 1.0f)) break;
                    while (this.offset > 1.0f) {
                        if (this.ySizeMax < this.numColumns) {
                            this.ySizeMin += 1.0f;
                            this.ySizeMax += 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                break;
            }
            case 3: {
                this.offset = (float)((double)this.offset + deltaY);
                if (this.offset > 1.0f) {
                    while (this.offset > 1.0f) {
                        if (this.ySizeMax < this.numColumns) {
                            this.ySize += 1.0f;
                            this.ySizeMax += 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                if (!(this.offset < 0.0f)) break;
                while (this.offset < 0.0f) {
                    if (this.ySizeMax > this.ySizeMin + 1.0f) {
                        this.ySize -= 1.0f;
                        this.ySizeMax -= 1.0f;
                        rebuild = true;
                    }
                    this.offset += 0.5f;
                }
                break;
            }
            case 6: {
                this.offset = (float)((double)this.offset + deltaZ);
                if (this.offset < 0.0f) {
                    while (this.offset < 0.0f) {
                        if (this.zSizeMin > 0.0f) {
                            this.zSizeMin -= 1.0f;
                            this.zSize += 1.0f;
                            rebuild = true;
                        }
                        this.offset += 0.5f;
                    }
                } else {
                    if (!(this.offset > 1.0f)) break;
                    while (this.offset > 1.0f) {
                        if (this.zSizeMin + 1.0f < this.zSizeMax) {
                            this.zSizeMin += 1.0f;
                            this.zSize -= 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                break;
            }
            case 8: {
                this.offset = (float)((double)this.offset + deltaZ);
                if (this.offset < 0.0f) {
                    while (this.offset < 0.0f) {
                        if (this.zSizeMin > 0.0f) {
                            this.zSizeMin -= 1.0f;
                            this.zSizeMax -= 1.0f;
                            rebuild = true;
                        }
                        this.offset += 0.5f;
                    }
                } else {
                    if (!(this.offset > 1.0f)) break;
                    while (this.offset > 1.0f) {
                        if (this.zSizeMax < this.numRows) {
                            this.zSizeMin += 1.0f;
                            this.zSizeMax += 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                break;
            }
            case 7: {
                this.offset = (float)((double)this.offset + deltaZ);
                if (this.offset > 1.0f) {
                    while (this.offset > 1.0f) {
                        if (this.zSizeMax < this.numRows) {
                            this.zSize += 1.0f;
                            this.zSizeMax += 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                if (!(this.offset < 0.0f)) break;
                while (this.offset < 0.0f) {
                    if (this.zSizeMax > this.zSizeMin + 1.0f) {
                        this.zSize -= 1.0f;
                        this.zSizeMax -= 1.0f;
                        rebuild = true;
                    }
                    this.offset += 0.5f;
                }
                break block0;
            }
        }
        if (rebuild) {
            this.buildDone = false;
            this.rebuildChart(ch);
            this.buildDone = true;
            this.showChart(ch, null);
        }
    }

    @Override
    public synchronized int isDataLocation(Channel ch, int x, int y) {
        this.dataModeState = 9;
        if (ch == null || !this.validVisualization || this.dirty) {
            return this.dataModeState;
        }
        Stack hitStack = new Stack();
        ch.gluPickMatrix(x, y, 1, 1);
        ch.glRenderMode(1);
        ch.glSelectBuffer(hitStack);
        ch.glCallList(9L, false);
        boolean hit = ch.glRenderMode(0);
        if (!hit || hitStack.isEmpty()) {
            return this.dataModeState;
        }
        String strs = (String)hitStack.pop();
        if (strs.equals("ZPan")) {
            this.dataModeState = 8;
        } else if (strs.equals("Front")) {
            this.dataModeState = 6;
        } else if (strs.equals("Back")) {
            this.dataModeState = 7;
        } else if (this.vertical) {
            if (strs.equals("Left")) {
                this.dataModeState = 0;
            } else if (strs.equals("Right")) {
                this.dataModeState = 1;
            } else if (strs.equals("XPan")) {
                this.dataModeState = 2;
            }
        } else if (strs.equals("Up")) {
            this.dataModeState = 3;
        } else if (strs.equals("Down")) {
            this.dataModeState = 4;
        } else if (strs.equals("YPan")) {
            this.dataModeState = 5;
        }
        this.offset = 0.5f;
        return this.dataModeState;
    }

    @Override
    public void stopDataScrolling(Channel ch) {
        this.dataModeState = 9;
        this.offset = 0.5f;
    }

    @Override
    protected void addDataScrollbar(Channel ch) {
        if (!this.dataMode) {
            return;
        }
        ch.glSelect2DFont(this.heightLegendStyle.valueStyle.createFont());
        this.verticalSpaceSize = (float)ch.glGetTextHeight() / 2.0f;
        this.blankSpaceSize = (float)ch.glGetTextWidth(" ");
        this.addXDataScrollbar(ch);
        this.addYDataScrollbar(ch);
        this.addZDataScrollbar(ch);
    }

    protected void addXDataScrollbar(Channel ch) {
        if (!this.vertical) {
            return;
        }
        Color mgray = Color.gray.brighter();
        int pmode = ch.getPolygonMode();
        ch.glPolygonMode(4);
        double remainder = (this.view.rotation + this.view.dRot) % 360.0;
        int region = this.depth == 2 ? (int)(remainder / 90.0) : 0;
        boolean negtilt = this.view.tilt + this.view.dTilt < 0.0;
        double xo = this.xSizeMin + this.xSizeMin / this.numColumns * this.xSize;
        double x1 = this.xSizeMin + this.xSizeMax / this.numColumns * this.xSize + 2.0f * this.xPadding - 5.0f * this.blankSpaceSize;
        double zo = -this.zSizeMax;
        if (this.depth == 2 && (region == 1 || region == 2)) {
            ch.glFrontFace(1);
            zo = -this.zSizeMin;
        }
        if (x1 + (double)(5.0f * this.blankSpaceSize) > (double)(this.xSizeMax + 2.0f * this.xPadding)) {
            x1 = this.xSizeMax + 2.0f * this.xPadding - 5.0f * this.blankSpaceSize;
            if (xo + (double)(5.0f * this.blankSpaceSize) > x1) {
                xo = Math.max((double)this.xSizeMin, x1 - (double)(5.0f * this.blankSpaceSize));
            }
        } else if (xo + (double)(5.0f * this.blankSpaceSize) > x1) {
            double delta = Math.max(0.0, x1 - xo);
            xo = Math.max((double)this.xSizeMin, xo - ((double)(5.0f * this.blankSpaceSize) - delta) / 2.0);
            x1 = Math.min(xo + (double)(5.0f * this.blankSpaceSize), (double)(this.xSizeMax + 2.0f * this.xPadding - 5.0f * this.blankSpaceSize));
        }
        ch.glColor(Color.gray);
        ch.glEdgeColor(Color.black);
        double yo = (double)(2.0f * this.yPadding + this.ySize) + 1.5 * (double)this.verticalSpaceSize;
        Shapes.addRectangle(ch, ((double)this.xSizeMin + xo) / 2.0, yo += (double)this.yMaxLegendSize, zo, xo - (double)this.xSizeMin, 2.0f * this.verticalSpaceSize);
        Shapes.addRectangle(ch, ((double)this.xSizeMax + x1) / 2.0, yo, zo, (double)this.xSizeMax - x1, 2.0f * this.verticalSpaceSize);
        ch.glColor(Color.lightGray);
        ch.glEdgeColor(mgray);
        ch.glPushName("XPan");
        Shapes.addRectangle(ch, (xo + x1) / 2.0 + 2.5 * (double)this.blankSpaceSize, yo, zo, x1 - xo - 2.5 * (double)this.blankSpaceSize, 2.0f * this.verticalSpaceSize);
        ch.glEdgeColor(Color.gray);
        ch.glColor(mgray);
        ch.glLoadName("Left");
        Shapes.addRectangle(ch, xo + 2.5 * (double)this.blankSpaceSize, yo, zo, 5.0f * this.blankSpaceSize, 2.0f * this.verticalSpaceSize);
        ch.glColor(Color.white);
        ch.glBegin(1);
        ch.glVertex(xo + (double)(5.0f * this.blankSpaceSize), yo + (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glColor(Color.black);
        ch.glBegin(1);
        ch.glVertex(xo + (double)(2.0f * this.blankSpaceSize), yo + 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + (double)(2.0f * this.blankSpaceSize), yo - 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo + (double)(2.0f * this.blankSpaceSize), yo, zo);
        ch.glVertex(xo + 0.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo + 1.5 * (double)this.blankSpaceSize, yo + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + 0.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glVertex(xo + 1.5 * (double)this.blankSpaceSize, yo - 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo + (double)(3.0f * this.blankSpaceSize), yo + 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + (double)(3.0f * this.blankSpaceSize), yo - 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo + (double)(3.0f * this.blankSpaceSize), yo, zo);
        ch.glVertex(xo + 4.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo + 3.5 * (double)this.blankSpaceSize, yo + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + 4.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glVertex(xo + 3.5 * (double)this.blankSpaceSize, yo - 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glEdgeColor(Color.gray);
        ch.glColor(mgray);
        ch.glLoadName("Right");
        Shapes.addRectangle(ch, x1 + 2.5 * (double)this.blankSpaceSize, yo, zo, 5.0f * this.blankSpaceSize, 2.0f * this.verticalSpaceSize);
        ch.glColor(Color.white);
        ch.glBegin(1);
        ch.glVertex(x1, yo + (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + (double)(5.0f * this.blankSpaceSize), yo + (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + (double)(5.0f * this.blankSpaceSize), yo - (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glColor(Color.black);
        ch.glBegin(1);
        ch.glVertex(x1 + (double)(2.0f * this.blankSpaceSize), yo + 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + (double)(2.0f * this.blankSpaceSize), yo - 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x1 + (double)(2.0f * this.blankSpaceSize), yo, zo);
        ch.glVertex(x1 + 0.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x1 + 1.5 * (double)this.blankSpaceSize, yo + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + 0.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glVertex(x1 + 1.5 * (double)this.blankSpaceSize, yo - 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x1 + (double)(3.0f * this.blankSpaceSize), yo + 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + (double)(3.0f * this.blankSpaceSize), yo - 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x1 + (double)(3.0f * this.blankSpaceSize), yo, zo);
        ch.glVertex(x1 + 4.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x1 + 3.5 * (double)this.blankSpaceSize, yo + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + 4.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glVertex(x1 + 3.5 * (double)this.blankSpaceSize, yo - 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glPopName();
        if (this.edgeColor != null) {
            ch.glEdgeColor(this.edgeColor);
        }
        ch.glPolygonMode(pmode);
        ch.glFrontFace(0);
        this.yMaxLegendSize += 3.0f * this.verticalSpaceSize;
    }

    protected void addYDataScrollbar(Channel ch) {
        if (this.vertical) {
            return;
        }
        Color mgray = Color.gray.brighter();
        int pmode = ch.getPolygonMode();
        double remainder = (this.view.rotation + this.view.dRot) % 360.0;
        int region = this.depth == 2 ? (int)(remainder / 90.0) : 0;
        double xo = this.xSize + 4.0f * this.blankSpaceSize;
        double yo = this.ySizeMin + this.ySizeMin / this.numColumns * this.ySize;
        double y1 = this.ySizeMin + this.ySizeMax / this.numColumns * this.ySize + 2.0f * this.yPadding - 2.0f * this.verticalSpaceSize;
        double zo = region == 3 || region == 1 ? 0.0 : (double)(-this.zSize - 2.0f * this.xPadding);
        xo += (double)this.xMaxLegendSize;
        if (y1 + (double)(2.0f * this.verticalSpaceSize) > (double)(this.ySizeMax + 2.0f * this.yPadding)) {
            y1 = Math.max(this.ySizeMin + 2.0f * this.verticalSpaceSize, this.ySizeMax + 2.0f * this.yPadding - 2.0f * this.verticalSpaceSize);
            if (yo + (double)(2.0f * this.verticalSpaceSize) > y1) {
                yo = Math.max((double)this.ySizeMin, y1 - (double)(2.0f * this.verticalSpaceSize));
            }
        } else if (yo + (double)(2.0f * this.verticalSpaceSize) > y1) {
            double delta = Math.max(0.0, y1 - yo);
            yo = Math.max((double)this.ySizeMin, yo - ((double)(2.0f * this.verticalSpaceSize) - delta) / 2.0);
            y1 = yo + (double)(2.0f * this.verticalSpaceSize);
        }
        if (region == 1 || region == 2) {
            ch.glFrontFace(1);
        }
        ch.glPolygonMode(4);
        ch.glColor(Color.gray);
        ch.glEdgeColor(Color.black);
        Shapes.addRectangle(ch, xo, ((double)this.ySizeMin + yo) / 2.0, zo, 4.0f * this.blankSpaceSize, yo - (double)this.ySizeMin);
        Shapes.addRectangle(ch, xo, ((double)this.ySizeMax + y1) / 2.0, zo, 4.0f * this.blankSpaceSize, (double)this.ySizeMax - y1);
        ch.glColor(Color.lightGray);
        ch.glEdgeColor(mgray);
        ch.glPushName("YPan");
        Shapes.addRectangle(ch, xo, (yo + y1) / 2.0 + (double)this.verticalSpaceSize, zo, 4.0f * this.blankSpaceSize, y1 - yo);
        ch.glColor(mgray);
        ch.glEdgeColor(Color.lightGray);
        ch.glLoadName("Down");
        Shapes.addRectangle(ch, xo, yo + (double)this.verticalSpaceSize, zo, 4.0f * this.blankSpaceSize, 2.0f * this.verticalSpaceSize);
        ch.glColor(Color.white);
        ch.glBegin(1);
        ch.glVertex(xo - (double)(2.0f * this.blankSpaceSize), yo + (double)(2.0f * this.verticalSpaceSize), zo);
        ch.glVertex(xo + (double)(2.0f * this.blankSpaceSize), yo + (double)(2.0f * this.verticalSpaceSize), zo);
        ch.glVertex(xo + (double)(2.0f * this.blankSpaceSize), yo, zo);
        ch.glEnd();
        ch.glColor(Color.black);
        ch.glBegin(1);
        ch.glVertex(xo - 1.5 * (double)this.blankSpaceSize, yo + 1.2 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + 1.5 * (double)this.blankSpaceSize, yo + 1.2 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo + 1.2 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, yo + 1.75 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo - (double)this.blankSpaceSize, yo + 1.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, yo + 1.75 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + (double)this.blankSpaceSize, yo + 1.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo - 1.5 * (double)this.blankSpaceSize, yo + 0.8 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + 1.5 * (double)this.blankSpaceSize, yo + 0.8 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo + 0.8 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, yo + 0.25 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo - (double)this.blankSpaceSize, yo + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, yo + 0.25 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + (double)this.blankSpaceSize, yo + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glColor(mgray);
        ch.glEdgeColor(Color.lightGray);
        ch.glLoadName("Up");
        Shapes.addRectangle(ch, xo, y1 + (double)this.verticalSpaceSize, zo, 4.0f * this.blankSpaceSize, 2.0f * this.verticalSpaceSize);
        ch.glColor(Color.white);
        ch.glBegin(1);
        ch.glVertex(xo - (double)(2.0f * this.blankSpaceSize), y1 + (double)(2.0f * this.verticalSpaceSize), zo);
        ch.glVertex(xo + (double)(2.0f * this.blankSpaceSize), y1 + (double)(2.0f * this.verticalSpaceSize), zo);
        ch.glVertex(xo + (double)(2.0f * this.blankSpaceSize), y1, zo);
        ch.glEnd();
        ch.glColor(Color.black);
        ch.glBegin(1);
        ch.glVertex(xo - 1.5 * (double)this.blankSpaceSize, y1 + 1.2 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + 1.5 * (double)this.blankSpaceSize, y1 + 1.2 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, y1 + 1.2 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, y1 + 1.75 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo - (double)this.blankSpaceSize, y1 + 1.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, y1 + 1.75 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + (double)this.blankSpaceSize, y1 + 1.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo - 1.5 * (double)this.blankSpaceSize, y1 + 0.8 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + 1.5 * (double)this.blankSpaceSize, y1 + 0.8 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, y1 + 0.8 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, y1 + 0.25 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo - (double)this.blankSpaceSize, y1 + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, y1 + 0.25 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + (double)this.blankSpaceSize, y1 + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glPopName();
        ch.glFrontFace(0);
        if (this.edgeColor != null) {
            ch.glEdgeColor(this.edgeColor);
        }
        ch.glPolygonMode(pmode);
        this.xMaxLegendSize += 7.0f * this.blankSpaceSize;
    }

    protected void addZDataScrollbar(Channel ch) {
        boolean negtilt;
        if (this.isNoneVariable(this.rowVariable) || this.depth == 0) {
            return;
        }
        Color mgray = Color.gray.brighter();
        int pmode = ch.getPolygonMode();
        ch.glPolygonMode(4);
        double remainder = (this.view.rotation + this.view.dRot) % 360.0;
        int region = this.depth == 2 ? (int)(remainder / 90.0) : 0;
        double xo = this.xSizeMin;
        if (this.depth == 2 && (region == 2 || region == 3)) {
            ch.glFrontFace(1);
            xo = this.xSizeMax + 2.0f * this.xPadding;
        }
        double zo = this.zSizeMin + this.zSizeMin / this.numRows * this.zSize;
        double z1 = this.zSizeMin + this.zSizeMax / this.numRows * this.zSize + 2.0f * this.zPadding - 5.0f * this.blankSpaceSize;
        boolean bl = negtilt = this.view.tilt + this.view.dTilt < 0.0;
        if (zo + (double)(5.0f * this.blankSpaceSize) > z1) {
            double delta = Math.max(0.0, z1 - zo);
            zo = Math.max((double)this.zSizeMin, zo + ((double)(5.0f * this.blankSpaceSize) - delta) / 2.0);
            z1 = zo + (double)(5.0f * this.blankSpaceSize);
        }
        double yo = (double)(2.0f * this.yPadding + this.ySizeMax) + 1.5 * (double)this.verticalSpaceSize;
        ch.glColor(Color.gray);
        ch.glEdgeColor(Color.black);
        ch.glBegin(2);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -this.zSizeMin);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -this.zSizeMin);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -zo);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -zo);
        ch.glEnd();
        ch.glBegin(2);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -z1);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -z1);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -this.zSizeMax);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -this.zSizeMax);
        ch.glEnd();
        ch.glColor(Color.lightGray);
        ch.glEdgeColor(mgray);
        ch.glPushName("ZPan");
        ch.glBegin(2);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -zo);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -zo);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -z1);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -z1);
        ch.glEnd();
        ch.glEdgeColor(Color.gray);
        ch.glColor(mgray);
        ch.glLoadName("Front");
        ch.glBegin(2);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -zo);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -zo);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -zo - (double)(5.0f * this.blankSpaceSize));
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -zo - (double)(5.0f * this.blankSpaceSize));
        ch.glEnd();
        ch.glColor(Color.white);
        ch.glBegin(1);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -zo);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -zo);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -zo - (double)(5.0f * this.blankSpaceSize));
        ch.glEnd();
        ch.glColor(Color.black);
        ch.glBegin(1);
        ch.glVertex(xo, yo + 0.75 * (double)this.verticalSpaceSize, -zo - (double)(2.0f * this.blankSpaceSize));
        ch.glVertex(xo, yo - 0.75 * (double)this.verticalSpaceSize, -zo - (double)(2.0f * this.blankSpaceSize));
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo, -zo - (double)(2.0f * this.blankSpaceSize));
        ch.glVertex(xo, yo, -zo - 0.5 * (double)this.blankSpaceSize);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo + 0.5 * (double)this.verticalSpaceSize, -zo - 1.5 * (double)this.blankSpaceSize);
        ch.glVertex(xo, yo, -zo - 0.5 * (double)this.blankSpaceSize);
        ch.glVertex(xo, yo - 0.5 * (double)this.verticalSpaceSize, -zo - 1.5 * (double)this.blankSpaceSize);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo + 0.75 * (double)this.verticalSpaceSize, -zo - (double)(3.0f * this.blankSpaceSize));
        ch.glVertex(xo, yo - 0.75 * (double)this.verticalSpaceSize, -zo - (double)(3.0f * this.blankSpaceSize));
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo, -zo - (double)(3.0f * this.blankSpaceSize));
        ch.glVertex(xo, yo, -zo - 4.5 * (double)this.blankSpaceSize);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo + 0.5 * (double)this.verticalSpaceSize, -zo - 3.5 * (double)this.blankSpaceSize);
        ch.glVertex(xo, yo, -zo - 4.5 * (double)this.blankSpaceSize);
        ch.glVertex(xo, yo - 0.5 * (double)this.verticalSpaceSize, -zo - 3.5 * (double)this.blankSpaceSize);
        ch.glEnd();
        ch.glEdgeColor(Color.gray);
        ch.glColor(mgray);
        ch.glLoadName("Back");
        ch.glBegin(2);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -z1);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -z1);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -z1 - (double)(5.0f * this.blankSpaceSize));
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -z1 - (double)(5.0f * this.blankSpaceSize));
        ch.glEnd();
        ch.glColor(Color.white);
        ch.glBegin(1);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -z1);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, -z1 - (double)(5.0f * this.blankSpaceSize));
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, -z1 - (double)(5.0f * this.blankSpaceSize));
        ch.glEnd();
        ch.glColor(Color.black);
        ch.glBegin(1);
        ch.glVertex(xo, yo + 0.75 * (double)this.verticalSpaceSize, -z1 - (double)(2.0f * this.blankSpaceSize));
        ch.glVertex(xo, yo - 0.75 * (double)this.verticalSpaceSize, -z1 - (double)(2.0f * this.blankSpaceSize));
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo, -z1 - (double)(2.0f * this.blankSpaceSize));
        ch.glVertex(xo, yo, -z1 - 0.5 * (double)this.blankSpaceSize);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo + 0.5 * (double)this.verticalSpaceSize, -z1 - 1.5 * (double)this.blankSpaceSize);
        ch.glVertex(xo, yo, -z1 - 0.5 * (double)this.blankSpaceSize);
        ch.glVertex(xo, yo - 0.5 * (double)this.verticalSpaceSize, -z1 - 1.5 * (double)this.blankSpaceSize);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo + 0.75 * (double)this.verticalSpaceSize, -z1 - (double)(3.0f * this.blankSpaceSize));
        ch.glVertex(xo, yo - 0.75 * (double)this.verticalSpaceSize, -z1 - (double)(3.0f * this.blankSpaceSize));
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo, -z1 - (double)(3.0f * this.blankSpaceSize));
        ch.glVertex(xo, yo, -z1 - 4.5 * (double)this.blankSpaceSize);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo, yo + 0.5 * (double)this.verticalSpaceSize, -z1 - 3.5 * (double)this.blankSpaceSize);
        ch.glVertex(xo, yo, -z1 - 4.5 * (double)this.blankSpaceSize);
        ch.glVertex(xo, yo - 0.5 * (double)this.verticalSpaceSize, -z1 - 3.5 * (double)this.blankSpaceSize);
        ch.glEnd();
        ch.glPopName();
        if (this.edgeColor != null) {
            ch.glEdgeColor(this.edgeColor);
        }
        ch.glPolygonMode(pmode);
        ch.glFrontFace(0);
        if (!this.vertical) {
            this.yMaxLegendSize += 3.0f * this.verticalSpaceSize;
        }
    }

    @Override
    protected void estimateLegendPixelSize(Channel ch) {
        if (this.dataMode) {
            this.vertical = this.isVertical();
            if (!this.vertical) {
                this.rightLegendPixels += 6 * this.blankSpacePixels;
            }
            if (this.vertical || this.depth != 0 && (this.isRiserChart() || this.is3DScatterPlot())) {
                this.topLegendPixels += 4 * this.blankSpacePixels;
            }
        }
        if (!this.isRiserChart() && !this.is3DScatterPlot()) {
            if (this.showHorizontalRefline && this.showReferenceLineLabel) {
                this.topLegendPixels += this.horizontalRefline.getMaxLabelPixelHeight(ch);
            }
            if (this.showVerticalRefline && this.showReferenceLineLabel) {
                this.rightLegendPixels += this.verticalRefline.getMaxLabelPixelWidth(ch);
            }
        }
    }

    protected boolean isVertical() {
        return this instanceof VerticalBar || this instanceof VerticalSegmentedBar || this instanceof Scatter;
    }

    @Override
    protected boolean isDataSubsetted() {
        boolean subData = this.vertical ? this.xSize < this.numColumns : this.ySize < this.numColumns;
        return subData;
    }

    @Override
    protected void addReferenceLines(Channel ch) {
        if (this.isRiserChart() || this.is3DScatterPlot()) {
            return;
        }
        float xo = (float)this.columnLegendStyle.getOrigin() + this.xSizeMin;
        float yo = (float)this.heightLegendStyle.getOrigin() + this.ySizeMin;
        float zo = (float)this.rowLegendStyle.getOrigin();
        if (this.showHorizontalRefline) {
            this.horizontalRefline.clipRef = this.clipReferenceLine;
            this.horizontalRefline.numGroups = this.numGroups;
            this.horizontalRefline.attachMapper(this.columnMapper);
            this.horizontalRefline.origin = new Vec3f(xo, yo, zo);
            this.horizontalRefline.endVector = new Vec3f(0.0f, this.ySize + 2.0f * this.yPadding, -this.zSize);
            this.horizontalRefline.paddingVector = new Vec3f(this.xPadding, 0.0f, 0.0f);
            this.horizontalRefline.scrollData = true;
            this.horizontalRefline.xSizeMin = this.xSizeMin;
            this.horizontalRefline.xSizeMax = this.xSizeMax;
            this.horizontalRefline.ySizeMin = this.ySizeMin;
            this.horizontalRefline.ySizeMax = this.ySizeMax;
            this.horizontalRefline.addGeometry(ch);
            if (this.showReferenceLineLabel) {
                this.horizontalRefline.addLabels(ch);
                this.yMaxLegendSize += this.horizontalRefline.getMaxLabelHeight(ch);
            }
        }
        if (this.showVerticalRefline) {
            this.verticalRefline.clipRef = this.clipReferenceLine;
            this.verticalRefline.numGroups = 1;
            this.verticalRefline.attachMapper(this.heightMapper);
            this.verticalRefline.origin = new Vec3f(xo, yo, zo);
            this.verticalRefline.endVector = new Vec3f(this.xSize + 2.0f * this.xPadding, 0.0f, -this.zSize);
            this.verticalRefline.paddingVector = new Vec3f(0.0f, this.yPadding, 0.0f);
            this.verticalRefline.scrollData = true;
            this.verticalRefline.xSizeMin = this.xSizeMin;
            this.verticalRefline.xSizeMax = this.xSizeMax;
            this.verticalRefline.ySizeMin = this.ySizeMin;
            this.verticalRefline.ySizeMax = this.ySizeMax;
            this.verticalRefline.addGeometry(ch);
            if (this.showReferenceLineLabel) {
                this.verticalRefline.addLabels(ch);
                this.xMaxLegendSize += this.verticalRefline.getMaxLabelWidth(ch);
            }
        }
    }
}

