/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Vec3f;

public class Blob {
    public static final int RECT_AREA_TYPE = 1;
    public static final int POLY_AREA_TYPE = 2;
    private Object attachment;
    private int[] valueIDs;
    private String[] values;
    private String[] formattedValues;
    private int areaType;
    private int valueCount;
    private int areaCount;
    double[] x;
    double[] y;
    public static final int UNKNOWN = -1;
    public static final int CATEGORY = 1;
    public static final int GROUP = 2;
    public static final int SUBGROUP = 3;
    public static final int SERIES = 4;
    public static final int RESPONSE = 5;
    public static final int COLOR = 6;
    public static final int WEIGHT = 7;

    public Blob(String[] _values, String[] _formattedValues, int[] _valueIDs, int _areaType, double[] _x, double[] _y) {
        this.values = _values;
        this.valueIDs = _valueIDs;
        this.formattedValues = _formattedValues == null ? this.values : _formattedValues;
        this.areaType = _areaType;
        this.x = _x;
        this.y = _y;
        this.valueCount = Math.min(this.values == null ? 0 : this.values.length, this.valueIDs == null ? 0 : this.valueIDs.length);
        this.areaCount = Math.min(this.x == null ? 0 : this.x.length, this.y == null ? 0 : this.y.length);
    }

    public Blob(String[] _values, String[] _formattedValues, int[] _valueIDs, int _areaType, double[] _x, double[] _y, Object _attachment) {
        this(_values, _formattedValues, _valueIDs, _areaType, _x, _y);
        this.attachment = _attachment;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public String getValueAt(int i) {
        return i >= 0 && i < this.valueCount ? this.values[i] : null;
    }

    public int getValueIDAt(int i) {
        return i >= 0 && i < this.valueCount ? this.valueIDs[i] : -1;
    }

    public String getFormattedValueAt(int i) {
        int formattedValueCount = this.formattedValues == null ? 0 : Math.min(this.valueCount, this.formattedValues.length);
        return i >= 0 && i < formattedValueCount ? this.formattedValues[i] : this.getValueAt(i);
    }

    public int getAreaType() {
        return this.areaType;
    }

    public int getAreaCount() {
        return this.areaCount;
    }

    public double getXAt(int i) {
        return i >= 0 && i < this.areaCount ? this.x[i] : Double.NaN;
    }

    public double getYAt(int i) {
        return i >= 0 && i < this.areaCount ? this.y[i] : Double.NaN;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    static Blob newBlob(Channel ch, String[] values, String[] formattedValues, int[] valueIDs, Bbox bbox) {
        Vec3f[] area = new Vec3f[]{new Vec3f((float)bbox.xmin, (float)bbox.ymin, (float)bbox.zmin), new Vec3f((float)bbox.xmin, (float)bbox.ymax, (float)bbox.zmin), new Vec3f((float)bbox.xmax, (float)bbox.ymax, (float)bbox.zmin), new Vec3f((float)bbox.xmax, (float)bbox.ymin, (float)bbox.zmin), new Vec3f((float)bbox.xmin, (float)bbox.ymin, (float)bbox.zmin)};
        return Blob.newBlob(ch, values, formattedValues, valueIDs, area);
    }

    static Blob newBlob(Channel ch, String[] values, String[] formattedValues, int[] valueIDs, Vec3f[] area) {
        double[] x = new double[area.length];
        double[] y = new double[area.length];
        for (int ii = 0; ii < area.length; ++ii) {
            double[] pt = new double[]{area[ii].x, area[ii].y, area[ii].z};
            ch.gluProject(pt, pt);
            x[ii] = pt[0];
            y[ii] = pt[1];
        }
        return new Blob(values, formattedValues, valueIDs, 2, x, y);
    }
}

