/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.visualize.GridStyle;
import com.sas.graphics.util.visualize.TextStyle;
import java.awt.Color;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class AxisStyle
implements Serializable {
    static final long serialVersionUID = 6137513091779306395L;
    public static final int NO_AXIS = 0;
    public static final int LINE_AXIS = 1;
    public static final int NUM_ROWS_AUTOMATIC = 0;
    public static final int NUM_ROWS_ONE = 1;
    public static final int NUM_ROWS_TWO = 2;
    private static final Color colorDefault = SystemColor.windowText;
    protected TextStyle labelStyle;
    protected TextStyle valueStyle;
    protected double origin;
    protected int intervals;
    protected int axisType;
    protected Color axisColor;
    protected int numRows;
    protected GridStyle grid;
    protected boolean fixedDataRange;
    protected double dataMinValue;
    protected double dataMaxValue;
    protected boolean fixedIntervals;
    protected boolean hideLabel;
    protected int serialVersion;
    protected boolean valuesVisible;

    public AxisStyle() {
        this.valueStyle = new TextStyle(9, 32);
        this.labelStyle = new TextStyle(12, 48);
        this.labelStyle.setBold(true);
        this.grid = new GridStyle();
        this.axisType = 1;
        this.axisColor = colorDefault;
        this.origin = 0.0;
        this.intervals = 10;
        this.numRows = 0;
        this.fixedDataRange = false;
        this.dataMinValue = 0.0;
        this.dataMaxValue = 0.0;
        this.fixedIntervals = false;
        this.valuesVisible = true;
        this.serialVersion = 2;
    }

    public AxisStyle(AxisStyle styleIn) {
        this.labelStyle = new TextStyle(styleIn.labelStyle);
        this.valueStyle = new TextStyle(styleIn.valueStyle);
        this.grid = new GridStyle(styleIn.grid);
        this.axisType = styleIn.axisType;
        this.axisColor = styleIn.axisColor;
        this.origin = styleIn.origin;
        this.intervals = styleIn.intervals;
        this.numRows = styleIn.numRows;
        this.fixedDataRange = styleIn.fixedDataRange;
        this.dataMinValue = styleIn.dataMinValue;
        this.dataMaxValue = styleIn.dataMaxValue;
        this.fixedIntervals = styleIn.fixedIntervals;
        this.valuesVisible = styleIn.valuesVisible;
        this.serialVersion = styleIn.serialVersion;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.serialVersion < 2) {
            this.valuesVisible = true;
            this.serialVersion = 2;
        }
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle ts) {
        this.labelStyle = ts;
    }

    public TextStyle getValueStyle() {
        return this.valueStyle;
    }

    public void setValueStyle(TextStyle ts) {
        this.valueStyle = ts;
    }

    public GridStyle getGrid() {
        return this.grid;
    }

    public void setGrid(GridStyle gs) {
        this.grid = gs;
    }

    public int getAxisType() {
        return this.axisType;
    }

    public void setAxisType(int type) {
        this.axisType = type;
    }

    public boolean isVisible() {
        return this.axisType != 0;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumRows(int rows) {
        this.numRows = rows;
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color color) {
        this.axisColor = color;
    }

    public double getOrigin() {
        return this.origin;
    }

    public void setOrigin(double anOrigin) {
        this.origin = anOrigin;
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void setIntervals(int count) {
        this.intervals = count;
    }

    public boolean isFixedIntervals() {
        return this.fixedIntervals;
    }

    public void setFixedIntervals(boolean fixed) {
        this.fixedIntervals = fixed;
    }

    public boolean isFixedDataRange() {
        return this.fixedDataRange;
    }

    public void setFixedDataRange(boolean fixed) {
        this.fixedDataRange = fixed;
    }

    public double getDataMinValue() {
        return this.dataMinValue;
    }

    public void setDataMinValue(double min) {
        this.dataMinValue = min;
    }

    public double getDataMaxValue() {
        return this.dataMaxValue;
    }

    public void setDataMaxValue(double max) {
        this.dataMaxValue = max;
    }

    public boolean isHideLabel() {
        return this.hideLabel;
    }

    public void setHideLabel(boolean hide) {
        this.hideLabel = hide;
    }

    public boolean isValuesVisible() {
        return this.valuesVisible;
    }

    public void setValuesVisible(boolean show) {
        this.valuesVisible = show;
    }
}

