/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.J3Polygon;
import com.sas.graphics.util.jxd.Shape;
import com.sas.graphics.util.jxd.State;
import com.sas.graphics.util.jxd.VertexSet;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

class Solid
extends VertexSet {
    J3Polygon last;
    Vector polygons = new Vector();
    Vector polygons2;
    int[] sortlist;

    Solid() {
    }

    void addPolygon(J3Polygon p) {
        this.polygons.addElement(p);
        this.last = p;
    }

    void addPolygon2(J3Polygon p) {
        if (this.polygons2 == null) {
            this.polygons2 = new Vector();
        }
        this.polygons2.addElement(p);
        this.last = p;
    }

    private void allocSortList(State state) {
        if (this.sortlist == null) {
            int polygonCount = this.polygons.size();
            this.sortlist = new int[polygonCount];
            int length = state.intarray.length;
            if (polygonCount > length) {
                int[] oldarray = state.intarray;
                int newsize = polygonCount + 64;
                state.intarray = new int[newsize];
                System.arraycopy(oldarray, 0, state.intarray, 0, length);
                for (int i = length; i < newsize; ++i) {
                    state.intarray[i] = i;
                }
            }
            System.arraycopy(state.intarray, 0, this.sortlist, 0, polygonCount);
        }
    }

    private void computeScreen(Channel ch, Vector list) {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            J3Polygon p = (J3Polygon)list.elementAt(i);
            p.computeScreen(ch);
            this.clip &= p.isClipped();
            if (p.isClipped()) continue;
            this.zmin = Math.min(this.zmin, p.getZmin());
            this.zmax = Math.max(this.zmax, p.getZmax());
        }
    }

    @Override
    public void computeScreen(Channel ch) {
        State state = ch.getState();
        this.allocSortList(state);
        this.zmin = Double.MAX_VALUE;
        this.zmax = -1.7976931348623157E308;
        this.clip = true;
        this.name = state.currentName;
        this.computeScreen(ch, this.polygons);
        if (state.capabilities[4]) {
            this.depthSort(state.fillmode, state);
        }
        this.computeScreen(ch, this.polygons2);
    }

    public boolean pick(State state, Graphics gc, Rectangle aperture, Vector list) {
        if (list == null) {
            return false;
        }
        int n = list.size();
        for (int k = 0; k < n; ++k) {
            J3Polygon p = (J3Polygon)list.elementAt(k);
            if (!p.pick(state, gc, aperture)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.pick(state, gc, aperture, this.polygons)) {
            return true;
        }
        return this.pick(state, gc, aperture, this.polygons2);
    }

    public void render(State state, Graphics bgc, Vector list, boolean doSort) {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            J3Polygon p = doSort && state.capabilities[4] ? (J3Polygon)list.elementAt(this.sortlist[i]) : (J3Polygon)list.elementAt(i);
            p.render(state, bgc);
        }
    }

    @Override
    public void render(State state, Graphics bgc) {
        if (state.capabilities[4] && this.sortlist == null) {
            this.allocSortList(state);
            this.depthSort(state.fillmode, state);
        }
        this.render(state, bgc, this.polygons, true);
        this.render(state, bgc, this.polygons2, false);
    }

    @Override
    public int test(Shape s, State state) {
        if (s.getZmin() >= this.zmax) {
            return 1;
        }
        if (this.zmin >= s.getZmax()) {
            return 0;
        }
        Vector spolygons = s.getPolygonList();
        if (spolygons == null) {
            spolygons = state.tempVector;
            spolygons.removeAllElements();
            spolygons.addElement(s);
        }
        int s1 = this.polygons.size();
        int s2 = spolygons.size();
        for (int i = 0; i < s1; ++i) {
            Shape p = (Shape)this.polygons.elementAt(i);
            if (p.clip) continue;
            for (int j = 0; j < s2; ++j) {
                int result;
                Shape q = (Shape)spolygons.elementAt(j);
                if (q.clip || (result = p.test(q, state)) == 2 || result == 2) continue;
                return result;
            }
        }
        return 2;
    }

    final void depthSort(int mode, State state) {
        int n = this.polygons.size();
        State.indexSortZmin(this.polygons, this.sortlist, n);
        for (int i = 0; i < n; ++i) {
            J3Polygon p = (J3Polygon)this.polygons.elementAt(this.sortlist[i]);
            for (int j = i + 1; j < n; ++j) {
                p = (J3Polygon)this.polygons.elementAt(this.sortlist[i]);
                J3Polygon q = (J3Polygon)this.polygons.elementAt(this.sortlist[j]);
                if (q.zmin >= p.zmax || !p.bbox.intersects(q.bbox) || p.test(q, state) != 0) continue;
                int swap = this.sortlist[j];
                for (int k = j; k > i; --k) {
                    this.sortlist[k] = this.sortlist[k - 1];
                }
                this.sortlist[i] = swap;
            }
        }
    }

    @Override
    public Vector getPolygonList() {
        return this.polygons;
    }
}

