/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.J3Polygon;
import com.sas.graphics.util.jxd.NameTree;
import com.sas.graphics.util.jxd.Point4;
import com.sas.graphics.util.jxd.Primitive;
import com.sas.graphics.util.jxd.Ray;
import com.sas.graphics.util.jxd.Solid;
import com.sas.graphics.util.jxd.State;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

abstract class Shape
extends Primitive {
    public static final int SORT_FRONT = 0;
    public static final int SORT_BEHIND = 1;
    public static final int SORT_DONT_CARE = 2;
    protected static final double FZERO = 1.0E-10;
    protected NameTree name;
    protected Color color;
    protected float alpha;
    protected boolean clip;
    protected Rectangle clipRect = null;
    protected double zmin;
    protected double zmax;
    protected Point4[] dscr;
    protected Rectangle bbox = new Rectangle();
    protected Point4 normal;
    protected boolean shadowEnabled;
    protected int shadowOffsetX;
    protected int shadowOffsetY;
    protected float shadowTransparency;
    protected float shadowSoftness;
    protected Color shadowColor;

    Shape() {
    }

    public double getZmin() {
        return this.zmin;
    }

    public double getZmax() {
        return this.zmax;
    }

    @Override
    public boolean isClipped() {
        return this.clip;
    }

    public Vector getPolygonList() {
        return null;
    }

    @Override
    public void insertToSortlist(State state) {
        if (!this.clip) {
            state.sortList.addElement(this);
        }
    }

    void copyInit(Shape s) {
        this.bbox = new Rectangle();
    }

    public abstract int getVertexCount(State var1);

    public Point4 getScreenCenter() {
        return null;
    }

    @Override
    public abstract void render(State var1, Graphics var2);

    public boolean doPick(State state, Graphics bgc) {
        if (state.render_mode != 1) {
            return false;
        }
        Rectangle a = this.intersectPickAperture(state.aperture, state);
        if (a != null && this.pick(state, bgc, a)) {
            state.selectPrimitive(this);
        }
        return true;
    }

    public boolean doFeedback(State state, Graphics bgc) {
        if (state.render_mode != 2) {
            return false;
        }
        Vector feedbackBuffer = state.feedbackBuffer;
        int feedbackType = state.feedbackType;
        if ((feedbackType & 3) != 0 && !state.isDepthSortingOn()) {
            feedbackBuffer.addElement(state.copyNameStack());
        }
        if ((feedbackType & 1) != 0) {
            Point4[] coords = this.getScreenCoords(state);
            Polygon polygon = new Polygon();
            int n = this.getVertexCount(state);
            for (int i = 0; i < n; ++i) {
                polygon.addPoint((int)coords[i].x, (int)coords[i].y);
            }
            feedbackBuffer.addElement(polygon);
        }
        return true;
    }

    @Override
    public void computeScreen(Channel ch) {
        this.clipRect = ch.state.clipRect;
        this.color = ch.state.color;
        this.alpha = ch.state.alpha;
        this.shadowEnabled = ch.state.capabilities[11];
        this.shadowOffsetX = ch.state.shadowOffsetX;
        this.shadowOffsetY = ch.state.shadowOffsetY;
        this.shadowTransparency = ch.state.shadowTransparency;
        this.shadowSoftness = ch.state.shadowSoftness;
        this.shadowColor = ch.state.shadowColor;
    }

    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        return false;
    }

    public NameTree getName() {
        return this.name;
    }

    public Rectangle intersectPickAperture(Rectangle aperture, State state) {
        Rectangle result = state.rt1;
        result = state.ApplyClip(this.clipRect, aperture);
        return result;
    }

    boolean inside(int x, int y, State state) {
        return false;
    }

    public int test(Shape q, State state) {
        if (q instanceof Solid) {
            int result = ((Solid)q).test(this, state);
            return this.invertResult(result);
        }
        if (!this.bbox.intersects(q.bbox)) {
            return 2;
        }
        if (q.getZmin() > this.getZmax()) {
            return 1;
        }
        if (q.getZmax() < this.getZmin()) {
            return 0;
        }
        int np = this.getVertexCount(state);
        int nq = q.getVertexCount(state);
        switch (np) {
            case 0: {
                return 2;
            }
            case 1: {
                switch (nq) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return q.zmin > this.zmin ? 1 : 0;
                    }
                }
                return this.testPointToPolygon(this, q, state);
            }
            case 2: {
                switch (nq) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return q.zmin > this.zmin ? 1 : 0;
                    }
                    case 2: {
                        return this.testEdges(this, q, state);
                    }
                }
                return this.testLineToPolygon(this, q, state);
            }
        }
        switch (nq) {
            case 0: {
                return 2;
            }
            case 1: {
                int result = this.testPointToPolygon(q, this, state);
                return this.invertResult(result);
            }
            case 2: {
                int result = this.testLineToPolygon(q, this, state);
                return this.invertResult(result);
            }
        }
        return this.testPolygonToPolygon(this, q, state);
    }

    private final int testEdges(Shape p, Shape q, State state) {
        double[] slope = state.scratchDouble2;
        Point4[] pscreen = p.getScreenCoords(state);
        Point4[] qscreen = q.getScreenCoords(state);
        int np = pscreen.length;
        int nq = qscreen.length;
        Point4 pi = pscreen[np - 1];
        for (int i = 0; i < np; ++i) {
            Point4 po = pi;
            pi = pscreen[i];
            Point4 qj = qscreen[nq - 1];
            for (int j = 0; j < nq; ++j) {
                double z2;
                double z1;
                double d;
                Point4 qo = qj;
                qj = qscreen[j];
                if (!Shape.edgesIntersect(po.x, po.y, pi.x, pi.y, qo.x, qo.y, qj.x, qj.y, slope) || (d = (z1 = po.z + slope[0] * (pi.z - po.z)) - (z2 = qo.z + slope[1] * (qj.z - qo.z))) < 1.0E-10 && d > -1.0E-10) continue;
                if (z1 > z2) {
                    return 0;
                }
                return 1;
            }
        }
        return 2;
    }

    protected static boolean edgesIntersect(double poX, double poY, double piX, double piY, double qoX, double qoY, double qjX, double qjY, double[] slopes) {
        double s = 0.0;
        double t = 0.0;
        double a = (qoX - qjX) * (poY - piY) - (poX - piX) * (qoY - qjY);
        if (a < 1.0E-10 && a > -1.0E-10) {
            return false;
        }
        s = ((qoX - qjX) * (poY - qoY) - (poX - qoX) * (qoY - qjY)) / a;
        if (s < 0.0 || s > 1.0) {
            return false;
        }
        t = ((poX - piX) * (poY - qoY) - (poX - qoX) * (poY - piY)) / a;
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        slopes[0] = s;
        slopes[1] = t;
        return true;
    }

    private final int testPointToPolygon(Shape p, Shape q, State state) {
        int result = 2;
        Point4 pCenter = p.getScreenCenter();
        if (q.inside((int)pCenter.x, (int)pCenter.y, state)) {
            Point4 u = state.pt1;
            Ray ray = state.tempRay;
            ray.setDirection(0.0, 0.0, -1.0);
            ray.setOrigin(pCenter);
            ray.intersectPoint((J3Polygon)q, u, state.pt2);
            double distance = u.z - pCenter.z;
            if (distance > 1.0E-10 || distance < -1.0E-10) {
                result = u.z > pCenter.z ? 1 : 0;
            }
        }
        return result;
    }

    private final int testLineToPolygon(Shape p, Shape q, State state) {
        int result = this.testPointToPolygon(p, q, state);
        if (result == 2) {
            result = this.testEdges(p, q, state);
        }
        return result;
    }

    private final int testPolygonToPolygon(Shape p, Shape q, State state) {
        int result = this.testPointToPolygon(p, q, state);
        if (result == 2) {
            result = this.testPointToPolygon(q, p, state);
            if ((result = this.invertResult(result)) == 2) {
                result = this.testEdges(p, q, state);
            }
        }
        return result;
    }

    private int invertResult(int result) {
        switch (result) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        throw new RuntimeException("Invalid sort result");
    }

    protected Point4[] getScreenCoords(State state) {
        return this.dscr;
    }
}

