/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.Point4;
import com.sas.graphics.util.jxd.RasterText;
import com.sas.graphics.util.jxd.State;
import com.sas.graphics.util.jxd.TransInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.Vector;

class RasterTextJava2
extends RasterText {
    private static final String dummy = "d";
    private static AffineTransform identity = new AffineTransform();
    private double angle;
    private boolean needsTextLayout = true;
    private Map fontAttributes = null;
    private static Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
    private static final int X = 0;
    private static final int Y = 1;
    static final int[] vToH90 = new int[]{2, 1, 0, 0};
    static final int[] hToV90 = new int[]{0, 1, 3};
    static final int[] vToH270 = new int[]{0, 1, 2, 2};
    static final int[] hToV270 = new int[]{3, 1, 0};

    RasterTextJava2() {
    }

    @Override
    public void init(State state) {
        state.affineTransform = new AffineTransform();
        this.fontAttributes = this.font != null ? this.font.getAttributes() : state.font.getAttributes();
    }

    @Override
    public void setAngle(int angle) {
        this.angle = (double)angle * Math.PI / 180.0;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontAttributes = font.getAttributes();
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        Point4[] r = state.ptArray;
        double[] info = this.computeAlignmentInfo(state, state.ch.getBackbufferGC(), (int)this.screen.x, (int)this.screen.y);
        double right = info[28];
        double top = info[29];
        double width = info[2];
        double height = info[3];
        r[0].set(right, top, this.screen.z, 1.0);
        r[1].set(right, top + height, this.screen.z, 1.0);
        r[2].set(right + width, top + height, this.screen.z, 1.0);
        r[3].set(right + width, top, this.screen.z, 1.0);
        return r;
    }

    @Override
    public boolean pick(State state, Graphics bgc, Rectangle aperture) {
        double[] info = this.computeAlignmentInfo(state, bgc, (int)this.screen.x, (int)this.screen.y);
        Rectangle bounds = state.rt1;
        bounds.setBounds((int)(info[28] + 0.5), (int)(info[29] + 0.5), (int)(info[2] + 0.5), (int)(info[3] + 0.5));
        Rectangle clippedBounds = state.ApplyClip(this.clipRect, bounds);
        return aperture.intersects(clippedBounds);
    }

    @Override
    void getBBox(String string, double x, double y, double z, int angle, Bbox bbox, State state, Graphics gc) {
        Point4 p1 = state.pt1;
        Point4 p2 = state.pt2;
        Point4 p3 = state.pt3;
        p1.set(x, y, z, 1.0);
        TransInfo trans = state.ch.trans;
        trans.Object2Window2(p1);
        this.stringVector = RasterTextJava2.makeMultiLine(string, this.stringVector);
        double[] info = this.computeAlignmentInfo(state, gc, this.stringVector, state.font, state.halign, state.valign, (double)angle * Math.PI / 180.0, p1.x, p1.y);
        Point4 p4 = state.pt4;
        Point4 p5 = state.pt5;
        p2.set(info[28], info[29], p1.z, 1.0);
        p3.set(info[28] + info[2], info[29], p1.z, 1.0);
        p4.set(info[28] + info[2], info[29] + info[3], p1.z, 1.0);
        p5.set(info[28], info[29] + info[3], p1.z, 1.0);
        trans.Window2Object(p2);
        trans.Window2Object(p3);
        trans.Window2Object(p4);
        trans.Window2Object(p5);
        bbox.makeEmpty();
        bbox.union(p2);
        bbox.union(p3);
        bbox.union(p4);
        bbox.union(p5);
    }

    private static void getWorldPixelCorners(TransInfo trans, Point4 ll, Point4 ur, int direction) {
        ll.set(0.0, 0.0, 0.0, 1.0);
        trans.Object2Window2(ll);
        if (direction == 0) {
            ur.set(ll.x + 1.0, ll.y, ll.z, 1.0);
        } else {
            ur.set(ll.x, ll.y - 1.0, ll.z, 1.0);
        }
        trans.Window2Object(ll);
        trans.Window2Object(ur);
    }

    static double getWorldPixelWidth(State state) {
        Point4 ll = state.pt1;
        Point4 ur = state.pt2;
        RasterTextJava2.getWorldPixelCorners(state.ch.trans, ll, ur, 0);
        ur.sub(ll);
        return ur.length();
    }

    static double getWorldPixelHeight(State state) {
        Point4 ll = state.pt1;
        Point4 ur = state.pt2;
        RasterTextJava2.getWorldPixelCorners(state.ch.trans, ll, ur, 1);
        ur.sub(ll);
        return ur.length();
    }

    static FontRenderContext getFontRenderContext(State state, Graphics2D gc) {
        Object antialiasValue = state.capabilities[14] ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        if (gc != null) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialiasValue);
            return gc.getFontRenderContext();
        }
        return new FontRenderContext(identity, antialiasValue == RenderingHints.VALUE_TEXT_ANTIALIAS_ON, false);
    }

    @Override
    double getWidth(State state, Graphics gc, Font font, String string) {
        double w = 0.0;
        FontRenderContext frc = RasterTextJava2.getFontRenderContext(state, (Graphics2D)gc);
        Vector list = RasterTextJava2.makeMultiLine(string, this.stringVector);
        w = this.computeWidths(list, null, font, frc);
        return w * RasterTextJava2.getWorldPixelWidth(state);
    }

    @Override
    double getAscent(State state, Graphics gc, Font font) {
        double ascent;
        double pixel = RasterTextJava2.getWorldPixelHeight(state);
        if (this.needsTextLayout) {
            FontRenderContext frc = RasterTextJava2.getFontRenderContext(state, (Graphics2D)gc);
            ascent = new TextLayout(dummy, font.getAttributes(), frc).getAscent();
        } else {
            FontMetrics fm = defaultToolkit.getFontMetrics(font);
            ascent = fm.getAscent();
        }
        return ascent * pixel;
    }

    @Override
    double getDescent(State state, Graphics gc, Font font) {
        double descent;
        double pixel = RasterTextJava2.getWorldPixelHeight(state);
        if (this.needsTextLayout) {
            FontRenderContext frc = RasterTextJava2.getFontRenderContext(state, (Graphics2D)gc);
            descent = new TextLayout(dummy, font.getAttributes(), frc).getDescent();
        } else {
            FontMetrics fm = defaultToolkit.getFontMetrics(font);
            descent = fm.getDescent();
        }
        return descent * pixel;
    }

    @Override
    double getHeight(State state, Graphics gc, Font font) {
        double h;
        if (this.needsTextLayout) {
            FontRenderContext frc = RasterTextJava2.getFontRenderContext(state, (Graphics2D)gc);
            TextLayout tl = new TextLayout(dummy, font.getAttributes(), frc);
            h = tl.getDescent() + tl.getAscent() + tl.getLeading();
        } else {
            FontMetrics fm = defaultToolkit.getFontMetrics(font);
            h = fm.getHeight();
        }
        double pixel = RasterTextJava2.getWorldPixelHeight(state);
        return h * pixel;
    }

    @Override
    double getHeight(State state, Graphics gc, Font font, String string) {
        double h;
        if (this.needsTextLayout) {
            FontRenderContext frc = RasterTextJava2.getFontRenderContext(state, (Graphics2D)gc);
            TextLayout tl = new TextLayout(dummy, font.getAttributes(), frc);
            h = tl.getDescent() + tl.getAscent() + tl.getLeading();
        } else {
            FontMetrics fm = defaultToolkit.getFontMetrics(font);
            h = fm.getHeight();
        }
        double pixel = RasterTextJava2.getWorldPixelHeight(state);
        h *= pixel;
        if (string != null) {
            Vector list = RasterTextJava2.makeMultiLine(string, this.stringVector);
            h *= (double)list.size();
        }
        return h;
    }

    protected double computeWidths(Vector string, double[] widths, Font font, FontRenderContext frc) {
        double tmpWidth = 0.0;
        double max = Double.MIN_VALUE;
        int lineCount = string.size();
        for (int i = 0; i < lineCount; ++i) {
            String s = (String)string.elementAt(i);
            if (s.length() == 0) {
                tmpWidth = 0.0;
            } else if (this.needsTextLayout) {
                TextLayout tl = new TextLayout(s, font, frc);
                Rectangle2D bounds = new TextLayout(s, font, frc).getBounds();
                tmpWidth = (double)((float)bounds.getWidth()) + bounds.getMinX();
                int trailingBlankCount = 0;
                for (int j = s.length() - 1; j >= 0 && s.charAt(j) == ' '; --j) {
                    ++trailingBlankCount;
                }
                if (trailingBlankCount > 0) {
                    Rectangle2D bounds1 = new TextLayout("||", font, frc).getBounds();
                    Rectangle2D bounds2 = new TextLayout("| |", font, frc).getBounds();
                    double blankWidth = bounds2.getWidth() - bounds1.getWidth();
                    tmpWidth += (double)((float)(blankWidth * (double)trailingBlankCount));
                }
            } else {
                FontMetrics fm = defaultToolkit.getFontMetrics(font);
                tmpWidth = fm.stringWidth(s);
            }
            if (widths != null) {
                widths[i] = tmpWidth;
            }
            max = Math.max(max, tmpWidth);
        }
        return max;
    }

    @Override
    protected double[] computeAlignmentInfo(State state, Graphics gc, double x, double y) {
        FontRenderContext frc = RasterTextJava2.getFontRenderContext(state, (Graphics2D)gc);
        if (this.textWidth == null) {
            this.textWidth = new double[this.textLines];
            this.maxTextWidth = this.computeWidths(this.stringVector, this.textWidth, this.font, frc);
        }
        double[] alignInfo = this.getInfoBuffer(state, this.textLines);
        this.computeAlignmentInfo(state, gc, alignInfo, this.textWidth, this.maxTextWidth, this.stringVector.size(), frc, this.font, this.halign, this.valign, this.angle, x, y);
        return alignInfo;
    }

    @Override
    protected double[] computeAlignmentInfo(State state, Graphics gc, Vector string, Font font, int halign, int valign, double angle, double x, double y) {
        int lineCount = string.size();
        double[] textWidth = state.tempTextWidth;
        if (textWidth == null || textWidth.length < lineCount) {
            textWidth = state.tempTextWidth = new double[lineCount];
        }
        FontRenderContext frc = RasterTextJava2.getFontRenderContext(state, (Graphics2D)gc);
        double maxTextWidth = this.computeWidths(string, textWidth, font, frc);
        double[] info = this.getInfoBuffer(state, lineCount);
        this.computeAlignmentInfo(state, gc, info, textWidth, maxTextWidth, string.size(), frc, font, halign, valign, angle, x, y);
        return info;
    }

    protected void computeAlignmentInfo(State state, Graphics gc, double[] info, double[] widths, double w, int lineCount, FontRenderContext frc, Font font, int halign, int valign, double angle, double x, double y) {
        float lineHeight;
        double ascent;
        double descent;
        info[0] = 0.0;
        info[1] = 0.0;
        if (this.needsTextLayout) {
            TextLayout tl = new TextLayout(dummy, font.getAttributes(), frc);
            info[6] = descent = (double)tl.getDescent();
            info[7] = tl.getLeading();
            ascent = tl.getAscent();
            lineHeight = tl.getDescent() + (float)ascent + tl.getLeading();
        } else {
            FontMetrics fm = defaultToolkit.getFontMetrics(font);
            info[6] = descent = (double)fm.getDescent();
            info[7] = fm.getLeading();
            ascent = fm.getAscent();
            lineHeight = (float)fm.getDescent() + (float)ascent + (float)fm.getLeading();
        }
        float h = lineHeight * (float)lineCount;
        if (angle == 1.5707963267948966) {
            int vSave = valign;
            valign = hToV90[halign];
            halign = vToH90[vSave];
        } else if (angle == -1.5707963267948966 || angle == 4.71238898038469) {
            int vSave = valign;
            valign = hToV270[halign];
            halign = vToH270[vSave];
        }
        switch (valign) {
            case 0: {
                info[1] = ascent;
                break;
            }
            case 1: {
                info[1] = ascent - (double)(h / 2.0f);
                break;
            }
            default: {
                info[1] = 0.0;
                break;
            }
            case 3: {
                info[1] = -descent - (double)(lineHeight * (float)(lineCount - 1));
            }
        }
        switch (halign) {
            default: {
                info[0] = 0.0;
                break;
            }
            case 1: {
                info[0] = -w / 2.0;
                break;
            }
            case 2: {
                info[0] = -w;
            }
        }
        info[8] = 0.0;
        info[9] = -ascent;
        info[10] = w;
        info[11] = -ascent;
        info[12] = w;
        info[13] = -ascent + (double)h;
        info[14] = 0.0;
        info[15] = -ascent + (double)h;
        AffineTransform xform = (AffineTransform)state.affineTransform;
        xform.setToIdentity();
        xform.translate(x, y);
        xform.rotate(-angle);
        xform.translate(info[0], info[1]);
        xform.transform(info, 8, info, 18, 4);
        double maxx = Math.max(Math.max(info[18], info[20]), Math.max(info[22], info[24]));
        double maxy = Math.max(Math.max(info[19], info[21]), Math.max(info[23], info[25]));
        double minx = Math.min(Math.min(info[18], info[20]), Math.min(info[22], info[24]));
        double miny = Math.min(Math.min(info[19], info[21]), Math.min(info[23], info[25]));
        double width = maxx - minx;
        double height = maxy - miny;
        info[2] = width;
        info[3] = height;
        info[28] = minx;
        info[29] = miny;
        info[30] = w;
        info[31] = h;
        for (int i = 0; i < lineCount; ++i) {
            info[32 + i] = (int)((w - widths[i]) / 2.0);
        }
        info[5] = (int)lineHeight;
    }

    @Override
    protected void softwareRender(State state, Graphics bgc, Color textColor, double[] alignment) {
        Channel ch = state.ch;
        int w = (int)alignment[2];
        int h = (int)alignment[3];
        ++w;
        ++h;
        if (this.shadowEnabled) {
            w += this.getShadowAdditionalWidth();
            h += this.getShadowAdditionalHeight();
        }
        state.reallocScratchInt(w * h);
        int[] pixels = state.scratchInt;
        int[] destPixels = state.scratchInt2;
        Image textBuffer = state.textBuffer;
        int imageSize = 0;
        if (textBuffer != null) {
            imageSize = textBuffer.getWidth(null);
        }
        if (w > imageSize || h > imageSize) {
            imageSize = Math.max(w, imageSize);
            imageSize = Math.max(h, imageSize);
            textBuffer = state.textBuffer = ch.component.createImage(imageSize, imageSize);
            this.width = w;
            this.height = h;
        }
        if (textBuffer == null) {
            return;
        }
        int left = (int)alignment[28];
        int top = (int)alignment[29];
        Graphics2D gt = (Graphics2D)textBuffer.getGraphics();
        this.setRenderingHints(state, gt);
        gt.setFont(this.font);
        int vLeft = 0;
        int vTop = 0;
        if (left < 0) {
            vLeft = -left;
        }
        if (top < 0) {
            vTop = -top;
        }
        state.ch.updateMemoryImage(left + vLeft, top + vTop, w, h);
        gt.drawImage(state.ch.backbuffer[state.ch.currentBuffer], 0 + vLeft, 0 + vTop, w, h, left + vLeft, top + vTop, left + w, top + h, null);
        Point4 screenSaver = state.pt1;
        screenSaver.set(this.screen);
        this.screen.x -= alignment[28];
        this.screen.y -= alignment[29];
        this.render(state, gt, textColor, alignment);
        this.screen.set(screenSaver);
        this.grabPixels(textBuffer, w, h, pixels);
        this.plantPixels(state, pixels, left, top, this.screen.z, w, h, this.alpha);
    }

    private void setRenderingHints(State state, Graphics g) {
        Graphics2D bgc = (Graphics2D)g;
        if (state.capabilities[14]) {
            bgc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            bgc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    @Override
    public void render(State state, Graphics g) {
        this.setRenderingHints(state, g);
        super.render(state, g);
    }

    @Override
    public void render(State state, Graphics graphics, Color color, double[] info) {
        Graphics2D bgc = (Graphics2D)graphics;
        AffineTransform originalTx = bgc.getTransform();
        AffineTransform xform = (AffineTransform)state.affineTransform;
        xform.setTransform(originalTx);
        xform.translate(this.screen.x, this.screen.y);
        xform.rotate(-this.angle);
        xform.translate(info[0], info[1]);
        if (this.backgroundColor != null || this.backgroundEdgeColor != null) {
            bgc.setTransform(xform);
            int x = 0;
            int y = (int)(-info[5] + info[6] + 0.5);
            int w = (int)(info[30] + 0.5);
            int h = (int)(info[31] + 0.5);
            if (this.backgroundColor != null) {
                bgc.setColor(this.backgroundColor);
                bgc.fillRect(x, y, w, h);
            }
            if (this.backgroundEdgeColor != null) {
                bgc.setColor(this.backgroundEdgeColor);
                bgc.drawRect(x, y, w, h - 1);
            }
        }
        if (this.shadowEnabled) {
            float r = (float)this.shadowColor.getRed() / 255.0f;
            float g = (float)this.shadowColor.getGreen() / 255.0f;
            float b = (float)this.shadowColor.getBlue() / 255.0f;
            for (int i = 0; i < 9; ++i) {
                this.screen.set(this.shadowOffsetX, this.shadowOffsetY, 0.0, 1.0);
                this.screen.x += (double)this.shadowJitterX[i];
                this.screen.y += (double)this.shadowJitterY[i];
                float shade = (float)this.shadowShade[i];
                float clampR = r * shade;
                float clampG = g * shade;
                float clampB = b * shade;
                float clampA = 0.05f * shade;
                if (clampA > 1.0f) {
                    clampA = 1.0f;
                }
                if (clampR > 1.0f) {
                    clampR = 1.0f;
                }
                if (clampG > 1.0f) {
                    clampG = 1.0f;
                }
                if (clampB > 1.0f) {
                    clampB = 1.0f;
                }
                Color c = new Color(clampR, clampG, clampB, clampA);
                bgc.setColor(c);
                this.drawMultiLineText(bgc, xform, info, (int)this.screen.x, (int)this.screen.y);
            }
        }
        bgc.setColor(color);
        this.drawMultiLineText(bgc, xform, info, 0, 0);
        bgc.setTransform(originalTx);
    }

    private void drawMultiLineText(Graphics2D bgc, AffineTransform xform, double[] info, int xOffset, int yOffset) {
        float lineOffset = 0.0f;
        for (int i = this.textLines - 1; i >= 0; --i) {
            bgc.setTransform(xform);
            bgc.translate((int)(info[32 + i] + 0.5), 0);
            String thisLine = (String)this.stringVector.elementAt(i);
            if (thisLine.length() <= 0) continue;
            lineOffset = (float)(info[5] * (double)i + 0.5);
            if (this.needsTextLayout) {
                TextLayout tl = new TextLayout(thisLine, this.fontAttributes, bgc.getFontRenderContext());
                tl.draw(bgc, xOffset, lineOffset + (float)yOffset);
                continue;
            }
            bgc.drawString(thisLine, (float)xOffset, lineOffset + (float)yOffset);
        }
    }
}

