/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.RasterText;
import com.sas.graphics.util.jxd.State;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Vector;

class RasterTextJava1
extends RasterText {
    private int angle;

    RasterTextJava1() {
    }

    @Override
    public void setAngle(int angle) {
        switch (angle) {
            case 0: 
            case 90: 
            case 180: 
            case 270: {
                break;
            }
            default: {
                angle = 0;
            }
        }
        this.angle = angle;
    }

    @Override
    double getWidth(State state, Graphics gc, Font font, String string) {
        int w = 0;
        FontMetrics fm = state.getFontMetrics(gc, font);
        Vector list = new Vector();
        RasterTextJava1.makeMultiLine(string, list);
        for (int i = 0; i < list.size(); ++i) {
            w = Math.max(w, fm.stringWidth((String)list.elementAt(i)));
        }
        return (double)w * RasterTextJava1.getWorldPixelWidth(state);
    }

    @Override
    double getAscent(State state, Graphics gc, Font font) {
        FontMetrics fm = state.getFontMetrics(gc, font);
        double ascent = fm.getAscent();
        double pixel = RasterTextJava1.getWorldPixelHeight(state);
        return ascent * pixel;
    }

    @Override
    double getDescent(State state, Graphics gc, Font font) {
        FontMetrics fm = state.getFontMetrics(gc, font);
        double descent = fm.getDescent();
        double pixel = RasterTextJava1.getWorldPixelHeight(state);
        return descent * pixel;
    }

    @Override
    double getHeight(State state, Graphics gc, Font font) {
        FontMetrics fm = state.getFontMetrics(gc, font);
        double h = fm.getHeight();
        double pixel = RasterTextJava1.getWorldPixelHeight(state);
        return h * pixel;
    }

    @Override
    double getHeight(State state, Graphics gc, Font font, String string) {
        FontMetrics fm = state.getFontMetrics(gc, font);
        Vector list = new Vector();
        RasterTextJava1.makeMultiLine(string, list);
        int h = fm.getHeight() * list.size();
        return (double)h * RasterTextJava1.getWorldPixelHeight(state);
    }

    protected double computeWidths(Vector string, double[] widths, FontMetrics fm) {
        double max = Double.MIN_VALUE;
        int lineCount = string.size();
        for (int i = 0; i < lineCount; ++i) {
            widths[i] = fm.stringWidth((String)string.elementAt(i));
            max = Math.max(max, widths[i]);
        }
        return max;
    }

    @Override
    protected double[] computeAlignmentInfo(State state, Graphics gc, double x, double y) {
        FontMetrics fm = state.getFontMetrics(gc, this.font);
        if (this.textWidth == null) {
            this.textWidth = new double[this.textLines];
            this.maxTextWidth = this.computeWidths(this.stringVector, this.textWidth, fm);
        }
        double[] alignInfo = this.getInfoBuffer(state, this.textLines);
        this.computeAlignmentInfo(state, gc, alignInfo, this.textWidth, this.maxTextWidth, this.stringVector.size(), fm, this.halign, this.valign, this.angle, x, y);
        return alignInfo;
    }

    @Override
    protected double[] computeAlignmentInfo(State state, Graphics gc, Vector string, Font font, int halign, int valign, double angle, double x, double y) {
        int lineCount = string.size();
        double[] textWidth = state.tempTextWidth;
        if (textWidth == null || textWidth.length < lineCount) {
            textWidth = state.tempTextWidth = new double[lineCount];
        }
        FontMetrics fm = state.getFontMetrics(gc, font);
        double maxTextWidth = this.computeWidths(string, textWidth, fm);
        double[] info = this.getInfoBuffer(state, lineCount);
        this.computeAlignmentInfo(state, gc, info, textWidth, maxTextWidth, string.size(), fm, halign, valign, angle, x, y);
        return info;
    }

    protected void computeAlignmentInfo(State state, Graphics gc, double[] info, double[] widths, double w, int lineCount, FontMetrics fm, int halign, int valign, double angle, double x, double y) {
        info[0] = 0.0;
        info[1] = 0.0;
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        info[6] = descent;
        int lineHeight = fm.getHeight();
        int h = lineHeight * lineCount;
        if (angle == 90.0 || angle == 270.0) {
            switch (valign) {
                case 1: {
                    info[1] = info[1] - w / 2.0;
                    break;
                }
                case 3: {
                    info[1] = info[1] - w;
                    break;
                }
            }
            info[0] = -h;
            info[2] = h;
            info[3] = w;
            info[4] = y + info[1];
        } else {
            switch (valign) {
                case 0: {
                    info[1] = info[1] + (double)ascent;
                    break;
                }
                case 1: {
                    info[1] = info[1] + (double)(ascent - h / 2);
                    break;
                }
                case 3: {
                    info[1] = info[1] - (double)(h - ascent);
                    break;
                }
            }
            info[0] = -w;
            info[2] = w;
            info[3] = h;
            info[4] = y + info[1] - (double)ascent;
        }
        switch (halign) {
            default: {
                info[0] = 0.0;
                for (int i = 32; i < lineCount + 32; ++i) {
                    info[i] = 0.0;
                }
                break;
            }
            case 1: {
                info[0] = info[0] / 2.0;
                for (int i = 32; i < lineCount + 32; ++i) {
                    info[i] = (w - widths[i - 32]) / 2.0;
                }
                break;
            }
            case 2: {
                for (int i = 32; i < lineCount + 32; ++i) {
                    info[i] = w - widths[i - 32];
                }
            }
        }
        info[0] = info[0] + x;
        info[1] = info[1] + y;
        info[5] = lineHeight;
    }

    private void rotatedRender(State state, Graphics bgc, Color textColor, double[] alignment) {
        int h;
        int w;
        Channel ch = state.ch;
        FontMetrics fm = state.getFontMetrics(bgc, this.font);
        int ascent = fm.getAscent();
        int xo = (int)alignment[0];
        int yo = (int)alignment[1];
        int bufferHeight = w = (int)alignment[2];
        int bufferWidth = h = (int)alignment[3];
        Image textBuffer = state.textBuffer;
        int imageSize = 0;
        if (textBuffer != null) {
            imageSize = textBuffer.getWidth(null);
        }
        if (bufferWidth > this.width || bufferHeight > this.height) {
            imageSize = Math.max(bufferWidth, imageSize);
            imageSize = Math.max(bufferHeight, imageSize);
            textBuffer = state.textBuffer = ch.component.createImage(imageSize, imageSize);
            this.width = bufferWidth;
            this.height = bufferHeight;
        }
        if (textBuffer == null) {
            return;
        }
        state.reallocScratchInt(bufferWidth * bufferHeight);
        int[] pixels = state.scratchInt;
        int[] destPixels = state.scratchInt2;
        Graphics gt = textBuffer.getGraphics();
        Color transparentColor = new Color(255 - this.color.getRed(), 255 - this.color.getGreen(), 255 - this.color.getBlue());
        gt.setColor(transparentColor);
        gt.fillRect(0, 0, bufferWidth, bufferHeight);
        PixelGrabber pg = new PixelGrabber(textBuffer, 0, 0, bufferWidth, bufferHeight, pixels, 0, bufferWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean hack = false;
        if (transparentColor.getRGB() != pixels[0]) {
            hack = true;
        }
        if (!hack) {
            if (this.backgroundColor == null && this.backgroundEdgeColor == null) {
                int direction;
                PixelGrabber pgDest = new PixelGrabber(ch.getBackbuffer(), xo, yo, w, h, destPixels, 0, w);
                try {
                    pgDest.grabPixels();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                switch (this.angle) {
                    case 270: {
                        direction = 90;
                        break;
                    }
                    case 90: {
                        direction = 270;
                        break;
                    }
                    default: {
                        direction = this.angle;
                    }
                }
                this.rotatePixels(destPixels, pixels, w, h, direction, false, null, null, null);
                this.image = ch.component.createImage(new MemoryImageSource(bufferWidth, bufferHeight, pixels, 0, bufferWidth));
                gt.drawImage(this.image, 0, 0, null);
            } else {
                if (this.backgroundColor != null) {
                    gt.setColor(this.backgroundColor);
                    gt.fillRect(0, 0, bufferWidth, bufferHeight);
                }
                if (this.backgroundEdgeColor != null) {
                    gt.setColor(this.backgroundEdgeColor);
                    gt.drawRect(0, 0, bufferWidth - 1, bufferHeight - 1);
                }
            }
        }
        gt.setColor(this.color);
        gt.setFont(this.font);
        for (int i = 0; i < this.textLines; ++i) {
            String thisLine = (String)this.stringVector.elementAt(i);
            gt.drawString(thisLine, (int)alignment[32 + i], (int)((double)ascent + (double)i * alignment[5]));
        }
        gt.dispose();
        pg = new PixelGrabber(textBuffer, 0, 0, bufferWidth, bufferHeight, pixels, 0, bufferWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.rotatePixels(pixels, destPixels, bufferWidth, bufferHeight, this.angle, hack, this.color, this.backgroundColor, this.backgroundEdgeColor);
        this.image = ch.component.createImage(new MemoryImageSource(w, h, destPixels, 0, w));
        bgc.drawImage(this.image, xo, yo, null);
    }

    private void regularRender(State state, Graphics bgc, Color textColor, double[] alignment) {
        if (this.backgroundColor != null) {
            bgc.setColor(this.backgroundColor);
            bgc.fillRect((int)alignment[0], (int)alignment[4], (int)alignment[2], (int)alignment[3]);
        }
        if (this.backgroundEdgeColor != null) {
            bgc.setColor(this.backgroundEdgeColor);
            bgc.drawRect((int)alignment[0], (int)alignment[4], (int)alignment[2], (int)alignment[3]);
        }
        bgc.setColor(textColor);
        for (int i = 0; i < this.textLines; ++i) {
            String thisLine = (String)this.stringVector.elementAt(i);
            bgc.drawString(thisLine, (int)(alignment[0] + alignment[32 + i]), (int)alignment[1]);
            alignment[1] = alignment[1] + alignment[5];
        }
    }

    @Override
    protected void softwareRender(State state, Graphics bgc, Color textColor, double[] alignment) {
        int destH;
        int destW;
        int srcH;
        int srcW;
        boolean hack = false;
        Channel ch = state.ch;
        FontMetrics fm = state.getFontMetrics(bgc, this.font);
        int ascent = fm.getAscent();
        int left = (int)alignment[0];
        int top = (int)alignment[4];
        if (this.angle == 0 || this.angle == 180) {
            srcW = (int)alignment[2];
            srcH = (int)alignment[3];
            destW = srcW;
            destH = srcH;
        } else {
            destW = (int)alignment[2];
            destH = (int)alignment[3];
            srcH = destW;
            srcW = destH;
        }
        if (this.shadowEnabled) {
            srcW += this.getShadowAdditionalWidth();
            srcH += this.getShadowAdditionalHeight();
            destW += this.getShadowAdditionalWidth();
            destH += this.getShadowAdditionalHeight();
        }
        Image textBuffer = state.textBuffer;
        int imageSize = 0;
        if (textBuffer != null) {
            imageSize = textBuffer.getWidth(null);
        }
        if (srcW > imageSize || srcH > imageSize) {
            imageSize = Math.max(srcW, imageSize);
            imageSize = Math.max(srcH, imageSize);
            textBuffer = state.textBuffer = ch.component.createImage(imageSize, imageSize);
            this.width = srcW;
            this.height = srcH;
        }
        if (textBuffer == null) {
            return;
        }
        state.reallocScratchInt(srcW * srcH);
        int[] pixels = state.scratchInt;
        int[] destPixels = state.scratchInt2;
        Graphics gt = textBuffer.getGraphics();
        gt.setFont(this.font);
        if (this.backgroundColor != null) {
            gt.setColor(this.backgroundColor);
            gt.fillRect(0, 0, srcW, srcH);
            if (this.shadowEnabled) {
                PixelGrabber pg = new PixelGrabber(textBuffer, 0, 0, srcW, srcH, destPixels, 0, srcW);
                try {
                    pg.grabPixels();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            PixelGrabber pg;
            int vLeft = 0;
            int vTop = 0;
            if (left < 0) {
                vLeft = -left;
            }
            if (top < 0) {
                vTop = -top;
            }
            state.ch.updateMemoryImage(left + vLeft, top + vTop, left + destW, top + destH);
            if (this.angle == 0 || this.angle == 180) {
                gt.drawImage(state.ch.backbuffer[state.ch.currentBuffer], 0 + vLeft, 0 + vTop, destW, destH, left + vLeft, top + vTop, left + destW, top + destH, null);
                if (this.shadowEnabled) {
                    pg = new PixelGrabber(textBuffer, 0, 0, destW, destH, destPixels, 0, destW);
                    try {
                        pg.grabPixels();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                int direction;
                pg = new PixelGrabber(state.ch.backbuffer[state.ch.currentBuffer], left, top, destW, destH, pixels, 0, destW);
                try {
                    pg.grabPixels();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                switch (this.angle) {
                    case 270: {
                        direction = 90;
                        break;
                    }
                    case 90: {
                        direction = 270;
                        break;
                    }
                    default: {
                        direction = this.angle;
                    }
                }
                destPixels = this.rotatePixels(pixels, destPixels, destW, destH, direction, hack, this.color, this.backgroundColor, this.backgroundEdgeColor);
                if (!this.shadowEnabled || this.shadowSoftness == 0.0f) {
                    MemoryImageSource mis = new MemoryImageSource(destH, destW, destPixels, 0, destH);
                    Image i = ch.component.createImage(mis);
                    gt.drawImage(i, 0, 0, destH, destW, null);
                }
            }
        }
        gt.setFont(this.font);
        if (this.shadowEnabled) {
            if (this.shadowSoftness == 0.0f) {
                gt.setColor(this.shadowColor);
                this.drawMultiLineText(gt, ascent, alignment, this.shadowOffsetX, this.shadowOffsetY);
            } else {
                int[] shadowPixels = new int[srcW * srcH];
                Image i2 = ch.component.createImage(srcW, srcH);
                Graphics gt2 = i2.getGraphics();
                gt2.setColor(new Color(255 - this.shadowColor.getRed(), 255 - this.shadowColor.getGreen(), 255 - this.shadowColor.getBlue()));
                gt2.fillRect(0, 0, srcW, srcH);
                gt2.setFont(this.font);
                gt2.setColor(this.shadowColor);
                this.drawMultiLineText(gt2, ascent, alignment, 0, 0);
                this.grabPixels(i2, srcW, srcH, shadowPixels);
                for (int i = 0; i < this.shadowShade.length; ++i) {
                    RasterTextJava1.blend(destPixels, shadowPixels, srcW, this.shadowShade[i], this.shadowOffsetX + this.shadowJitterX[i], this.shadowOffsetY + this.shadowJitterY[i]);
                }
                MemoryImageSource mis = new MemoryImageSource(srcW, srcH, destPixels, 0, srcW);
                Image i = ch.component.createImage(mis);
                gt.drawImage(i, 0, 0, srcW, srcH, null);
            }
        }
        if (this.backgroundEdgeColor != null) {
            gt.setColor(this.backgroundEdgeColor);
            gt.drawRect(0, 0, srcW - 1, srcH - 1);
        }
        gt.setColor(this.color);
        this.drawMultiLineText(gt, ascent, alignment, 0, 0);
        gt.dispose();
        this.grabPixels(textBuffer, srcW, srcH, pixels);
        destPixels = this.rotatePixels(pixels, destPixels, srcW, srcH, this.angle, hack, this.color, this.backgroundColor, this.backgroundEdgeColor);
        this.plantPixels(state, destPixels, left, top, this.screen.z, destW, destH, this.alpha);
    }

    private static void blend(int[] destPixels, int[] shadowPixels, int width, double shade, int jitterX, int jitterY) {
        int transparent = shadowPixels[0];
        int jitterOffset = jitterY * width + jitterX;
        int n = shadowPixels.length;
        for (int i = 0; i < n; ++i) {
            int srgb = shadowPixels[i];
            if (srgb == transparent) continue;
            double Rs = (float)(srgb >> 16 & 0xFF) / 255.0f;
            double Gs = (float)(srgb >> 8 & 0xFF) / 255.0f;
            double Bs = (float)(srgb & 0xFF) / 255.0f;
            double As = (double)0.05f * shade;
            int destIndex = i + jitterOffset;
            if (destIndex >= destPixels.length || destIndex < 0) continue;
            int drgb = destPixels[destIndex];
            double Rd = (float)(drgb >> 16 & 0xFF) / 255.0f;
            double Gd = (float)(drgb >> 8 & 0xFF) / 255.0f;
            double Bd = (float)(drgb & 0xFF) / 255.0f;
            double Ad = 1.0;
            double sourceBlend = As;
            double destBlend = 1.0 - As;
            double resultR = Rs * sourceBlend + Rd * destBlend;
            double resultG = Gs * sourceBlend + Gd * destBlend;
            double resultB = Bs * sourceBlend + Bd * destBlend;
            double resultA = As * sourceBlend + Ad * destBlend;
            if (resultR > 1.0) {
                resultR = 1.0;
            }
            if (resultR < 0.0) {
                resultR = 0.0;
            }
            if (resultG > 1.0) {
                resultG = 1.0;
            }
            if (resultG < 0.0) {
                resultG = 0.0;
            }
            if (resultB > 1.0) {
                resultB = 1.0;
            }
            if (resultB < 0.0) {
                resultB = 0.0;
            }
            if (resultA > 1.0) {
                resultA = 1.0;
            }
            if (resultA < 0.0) {
                resultA = 0.0;
            }
            destPixels[destIndex] = drgb = 0xFF000000 | (int)(resultR * 255.0) << 16 | (int)(resultG * 255.0) << 8 | (int)(resultB * 255.0);
        }
    }

    private void drawMultiLineText(Graphics g, double ascent, double[] alignment, int offsetX, int offsetY) {
        float lineOffset = 0.0f;
        for (int i = 0; i < this.textLines; ++i) {
            String thisLine = (String)this.stringVector.elementAt(i);
            g.drawString(thisLine, (int)alignment[32 + i] + offsetX, (int)(ascent + (double)i * alignment[5]) + offsetY);
        }
    }

    @Override
    public void render(State state, Graphics bgc, Color color, double[] info) {
        if (this.angle == 0 || this.angle == 180) {
            this.regularRender(state, bgc, color, info);
        } else {
            this.rotatedRender(state, bgc, color, info);
        }
    }

    private int[] rotatePixels(int[] srcPixels, int[] destPixels, int w, int h, int anAngle, boolean hack, Color textColor, Color bgColor, Color bgEdgeColor) {
        if (w * h > srcPixels.length || w * h > destPixels.length) {
            return null;
        }
        double tc = Double.NaN;
        double bgc = Double.NaN;
        double bgce = Double.NaN;
        if (textColor != null) {
            tc = textColor.getRGB();
        }
        if (bgColor != null) {
            bgc = bgColor.getRGB();
        }
        if (bgEdgeColor != null) {
            bgce = bgEdgeColor.getRGB();
        }
        switch (anAngle) {
            default: {
                int index = 0;
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        this.setDestPixel(index, destPixels, srcPixels[0], srcPixels[index], tc, bgc, hack);
                        ++index;
                    }
                }
                break;
            }
            case 180: {
                for (int y = 0; y < h; ++y) {
                    int xmin = y * w;
                    int xmax = xmin + w;
                    int index = xmax - 1;
                    for (int x = xmin; x < xmax; ++x) {
                        this.setDestPixel(x, destPixels, srcPixels[0], srcPixels[index], tc, bgc, hack);
                        --index;
                    }
                }
                break;
            }
            case 270: {
                int index = 0;
                for (int x = 0; x < w; ++x) {
                    for (int y = h - 1; y >= 0; --y) {
                        this.setDestPixel(index, destPixels, srcPixels[0], srcPixels[y * w + x], tc, bgc, hack);
                        ++index;
                    }
                }
                break;
            }
            case 90: {
                int index = 0;
                for (int x = w - 1; x >= 0; --x) {
                    for (int y = 0; y < h; ++y) {
                        this.setDestPixel(index, destPixels, srcPixels[0], srcPixels[y * w + x], tc, bgc, hack);
                        ++index;
                    }
                }
            }
        }
        return destPixels;
    }

    private void setDestPixel(int index, int[] destPixels, int srcPixelZero, int rgb, double tc, double bgc, boolean hack) {
        destPixels[index] = !hack ? rgb : (rgb != srcPixelZero ? (!Double.isNaN(tc) ? (int)tc : rgb) : (Double.isNaN(bgc) ? rgb & 0xFFFFFF : (int)bgc));
    }
}

