/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.Point4;
import com.sas.graphics.util.jxd.ScanConvert;
import com.sas.graphics.util.jxd.State;
import com.sas.graphics.util.jxd.VertexSet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

class J3Line
extends VertexSet {
    int[] stipplePattern;
    int lineWidth = 1;
    int capStyle = 0;
    Point4 center = new Point4();

    J3Line() {
    }

    @Override
    public void render(State state, Graphics bgc) {
        if (this.clip) {
            return;
        }
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        bgc.setColor(this.color);
        if (this.vertexCount == 1) {
            bgc.fillOval(this.xpoints[0], this.ypoints[0], this.lineWidth, this.lineWidth);
        } else if (this.stipplePattern != null) {
            state.stippleHistory[1] = 0;
            state.stippleHistory[0] = 0;
            for (int i = 0; i < this.vertexCount - 1; ++i) {
                this.stipple(state, bgc, this.stipplePattern, state.stippleHistory, this.dscr[i].x, this.dscr[i].y, this.dscr[i + 1].x, this.dscr[i + 1].y);
            }
        } else {
            for (int i = 0; i < this.vertexCount - 1; ++i) {
                this.drawSegment(state, bgc, this.dscr[i].x, this.dscr[i].y, this.dscr[i + 1].x, this.dscr[i + 1].y, null);
            }
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    void drawLine(State state, Graphics g, int lineWidth, Point4 dir, double x0, double y0, Color color1, float alpha1, double x1, double y1, Color color2, float alpha2) {
        boolean isSoft = state.isSoftwareRender();
        if (lineWidth <= 1) {
            if (isSoft) {
                ScanConvert.bresenhamLine(state, lineWidth, (int)(x0 + 0.5), (int)(y0 + 0.5), color1, alpha1, (int)(x1 + 0.5), (int)(y1 + 0.5), color2, alpha2);
            } else {
                g.drawLine((int)(x0 + 0.5), (int)(y0 + 0.5), (int)(x1 + 0.5), (int)(y1 + 0.5));
            }
        } else if (isSoft) {
            Color[] wideColor = state.wideLineColor;
            wideColor[0] = color1;
            wideColor[1] = color2;
            wideColor[2] = color2;
            wideColor[3] = color1;
            float[] wideAlpha = state.wideLineAlpha;
            wideAlpha[0] = alpha1;
            wideAlpha[1] = alpha2;
            wideAlpha[2] = alpha2;
            wideAlpha[3] = alpha1;
            state.appearance.color = this.color;
            state.appearance.litColor = this.color;
            state.appearance.colorPerVertex = wideColor;
            state.appearance.litColorPerVertex = wideColor;
            state.appearance.alphaPerVertex = wideAlpha;
            state.appearance.alpha = this.alpha;
            state.appearance.isLightOn = false;
            Point4[] wideDscr = state.ptArray;
            J3Line.makeWideLine(state, lineWidth, state.ptArray, x0, y0, this.dscr[0].z, x1, y1, this.dscr[1].z, dir);
            state.scanConvert.drawConcavePolygon(state, 4, wideDscr, state.appearance);
        } else {
            J3Line.makeWideLine(state, lineWidth, state.wideLineX, state.wideLineY, x0, y0, x1, y1, dir);
            g.fillPolygon(state.wideLineX, state.wideLineY, state.wideLineX.length);
        }
    }

    private void drawEndCap(State state, Graphics gc, double x1, double y1, double x2, double y2, Point4 dir) {
        double halfWidth = (double)this.lineWidth / 2.0 - 0.5;
        if (state.isSoftwareRender()) {
            state.appearance.color = this.color;
            state.appearance.litColor = this.color;
            state.appearance.colorPerVertex = this.colorPerVertex;
            state.appearance.litColorPerVertex = this.colorPerVertex;
            state.appearance.alphaPerVertex = this.alphaPerVertex;
            state.appearance.alpha = this.alpha;
            state.appearance.isLightOn = false;
            ScanConvert.drawCircle(state, x1, y1, 0.0, (double)this.lineWidth / 2.0, 5, state.appearance);
            ScanConvert.drawCircle(state, x2, y2, 0.0, (double)this.lineWidth / 2.0, 5, state.appearance);
        } else {
            gc.fillOval((int)(x1 - halfWidth + 0.5), (int)(y1 - halfWidth + 0.5), this.lineWidth, this.lineWidth);
            gc.fillOval((int)(x2 - halfWidth + 0.5), (int)(y2 - halfWidth + 0.5), this.lineWidth, this.lineWidth);
        }
    }

    public void drawSegment(State state, Graphics gc, double x1, double y1, double x2, double y2, Point4 dir) {
        this.drawLine(state, gc, this.lineWidth, dir, x1, y1, this.color, this.alpha, x2, y2, this.color, this.alpha);
        if (this.lineWidth > 1 && this.capStyle == 1) {
            this.drawEndCap(state, gc, x1, y1, x2, y2, dir);
        }
        if (this.shadowEnabled) {
            double dy;
            double dx = Math.abs(x2 - x1);
            if (dx > (dy = Math.abs(y2 - y1))) {
                x1 += 0.5;
                x2 += 0.5;
                y1 += 0.5 + (double)this.shadowOffsetY;
                y2 += 0.5 + (double)this.shadowOffsetY;
            } else {
                x1 += 0.5 + (double)this.shadowOffsetX;
                x2 += 0.5 + (double)this.shadowOffsetX;
                y1 += 0.5;
                y2 += 0.5;
            }
            this.drawLine(state, gc, this.lineWidth, dir, x1, y1, Color.black, 0.5f, x2, y2, Color.black, 0.5f);
        }
    }

    private void stipple(State state, Graphics gc, int[] pattern, int[] remainder, double beginX, double beginY, double endX, double endY) {
        double drawn;
        double x = beginX;
        double y = beginY;
        double dx = endX - beginX;
        double dy = endY - beginY;
        Point4 dir = state.pt6;
        double length = Math.sqrt(dx * dx + dy * dy);
        dx /= length;
        dy /= length;
        dir.set(endX - beginX, endY - beginY, 0.0, 1.0);
        dir.normalize();
        int index = remainder[0];
        double d = drawn = remainder[1] > 0 ? (double)remainder[1] : (double)Math.abs(pattern[index]);
        while (length > drawn) {
            endX = beginX + dx * drawn;
            endY = beginY + dy * drawn;
            if (pattern[index] > 0) {
                this.drawSegment(state, gc, x, y, endX, endY, dir);
            } else {
                x = beginX + dx * (drawn + 1.0);
                y = beginY + dy * (drawn + 1.0);
            }
            index = (index + 1) % pattern.length;
            drawn += (double)Math.abs(pattern[index]);
        }
        if (pattern[index] > 0) {
            this.drawSegment(state, gc, x, y, beginX + dx * length, beginY + dy * length, dir);
        }
        remainder[0] = index;
        remainder[1] = (int)(drawn - length);
    }

    private static void makeWideLine(State state, int lineWidth, int[] wideX, int[] wideY, double x1, double y1, double x2, double y2, Point4 direction) {
        Point4[] vertex = state.ptArray;
        J3Line.makeWideLine(state, lineWidth, state.ptArray, x1, y1, 0.0, x2, y2, 0.0, direction);
        for (int i = 0; i < 4; ++i) {
            wideX[i] = (int)(vertex[i].x + 0.5);
            wideY[i] = (int)(vertex[i].y + 0.5);
        }
    }

    private static void makeWideLine(State state, int lineWidth, Point4[] vertex, double x1, double y1, double z1, double x2, double y2, double z2, Point4 direction) {
        double slope;
        double halfWidth = (double)lineWidth / 2.0;
        Point4 crossDir = state.pt2;
        Point4 v = state.pt3;
        Point4 dir = state.pt4;
        if (direction == null) {
            dir.set(x2 - x1, y2 - y1, 0.0, 1.0);
        } else {
            v.set(x2 - x1, y2 - y1, 0.0, 1.0);
            dir.set(direction);
            if (v.x != 0.0 || v.y != 0.0) {
                dir.scale(v.length());
            }
        }
        if (dir.x == 0.0 && dir.y == 0.0) {
            dir.set(1.0, 0.0, 0.0, 1.0);
        }
        if ((slope = dir.y / dir.x) > 0.0) {
            crossDir.set(-dir.y, dir.x, 0.0, 1.0);
        } else {
            crossDir.set(dir.y, -dir.x, 0.0, 1.0);
        }
        crossDir.normalize();
        crossDir.scale(halfWidth);
        v.set(x1, y1, 0.0, 1.0);
        v.add(crossDir);
        vertex[0].x = v.x;
        vertex[0].y = v.y;
        vertex[0].z = z1;
        v.add(dir);
        vertex[1].x = v.x;
        vertex[1].y = v.y;
        vertex[1].z = z2;
        crossDir.normalize();
        crossDir.scale(-lineWidth);
        v.add(crossDir);
        vertex[2].x = v.x;
        vertex[2].y = v.y;
        vertex[2].z = z2;
        v.sub(dir);
        vertex[3].x = v.x;
        vertex[3].y = v.y;
        vertex[3].z = z1;
    }

    @Override
    public Point4 getScreenCenter() {
        return this.center;
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        this.stipplePattern = (int[])(ch.state.capabilities[6] ? (int[])ch.state.stipplePattern.clone() : null);
        this.capStyle = ch.state.capStyle;
        this.lineWidth = ch.state.lineWidth;
        if (this.lineWidth > 1) {
            this.bbox.setBounds(this.bbox.x - this.lineWidth / 2, this.bbox.y - this.lineWidth / 2, this.bbox.width + this.lineWidth, this.bbox.height + this.lineWidth);
        }
        this.center.set(0.0, 0.0, 0.0, 1.0);
        for (int i = 0; i < this.vertexCount; ++i) {
            this.center.add(this.dscr[i]);
        }
        this.center.scale(1.0 / (double)this.vertexCount);
        this.center.t = 1.0;
    }

    void split(Channel ch) {
        if (this.vertexCount == 1) {
            J3Line line = new J3Line();
            Point4 p = this.vertex[0];
            line.vertex(ch, p.x, p.y, p.z);
            line.end(ch);
            ch.state.openDisplayList.primitives.addElement(line);
        } else {
            for (int i = 0; i < this.vertexCount - 1; ++i) {
                J3Line line = new J3Line();
                Point4 p = this.vertex[i];
                line.vertex(ch, p.x, p.y, p.z);
                p = this.vertex[i + 1];
                line.vertex(ch, p.x, p.y, p.z);
                line.end(ch);
                ch.state.openDisplayList.primitives.addElement(line);
            }
        }
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.clip) {
            return false;
        }
        if (!aperture.intersects(this.bbox)) {
            return false;
        }
        for (int i = 0; i < this.vertexCount; ++i) {
            if (!aperture.contains(this.xpoints[i], this.ypoints[i])) continue;
            return true;
        }
        if (this.lineWidth == 1) {
            return this.pickSkinnyLine(aperture);
        }
        return this.pickWideLine(aperture, state);
    }

    private boolean pickWideLine(Rectangle aperture, State state) {
        J3Line.makeWideLine(state, this.lineWidth, state.wideLineX, state.wideLineY, (int)this.dscr[0].x, (int)this.dscr[0].y, (int)this.dscr[1].x, (int)this.dscr[1].y, null);
        return J3Line.apertureIntersectsPolygon(state, aperture, state.wideLineX, state.wideLineY, 4, null, 0);
    }

    private boolean pickSkinnyLine(Rectangle aperture) {
        return J3Line.apertureIntersectsEdges(aperture, this.xpoints, this.ypoints, this.vertexCount, null, 0);
    }

    @Override
    public int getVertexCount(State state) {
        if (state.render_mode == 2) {
            return 4;
        }
        return super.getVertexCount(state);
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        if (state.render_mode == 2) {
            Point4[] t = state.ptArray;
            int feedbackLineWidth = this.lineWidth <= 1 ? 2 : this.lineWidth;
            J3Line.makeWideLine(state, feedbackLineWidth, state.wideLineX, state.wideLineY, (int)this.dscr[0].x, (int)this.dscr[0].y, (int)this.dscr[1].x, (int)this.dscr[1].y, null);
            for (int i = 0; i < 4; ++i) {
                t[i].x = state.wideLineX[i];
                t[i].y = state.wideLineY[i];
            }
            return t;
        }
        return super.getScreenCoords(state);
    }
}

