/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.Point4;

public class Bbox {
    private boolean empty;
    public double xmin;
    public double ymin;
    public double zmin;
    public double xmax;
    public double ymax;
    public double zmax;

    public Bbox() {
        this(-0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f);
    }

    public Bbox(Bbox box) {
        this.setBoxMinCorner(box.getBoxMinCorner());
        this.setBoxMaxCorner(box.getBoxMaxCorner());
    }

    public Bbox(float xmin, float ymin, float zmin, float xmax, float ymax, float zmax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.zmin = zmin;
        this.xmax = xmax;
        this.ymax = ymax;
        this.zmax = zmax;
    }

    public String toString() {
        return "[BBox: " + this.xmin + this.ymin + this.zmin + this.xmax + this.ymax + this.zmax + " ]";
    }

    public void setBoxMinCorner(Point4 boxMin) {
        this.xmin = boxMin.x;
        this.ymin = boxMin.y;
        this.zmin = boxMin.z;
    }

    public void setBoxMaxCorner(Point4 boxMax) {
        this.xmax = boxMax.x;
        this.ymax = boxMax.y;
        this.zmax = boxMax.z;
    }

    public Point4 getBoxMinCorner() {
        Point4 p = new Point4(this.xmin, this.ymin, this.zmin, 1.0);
        return p;
    }

    public Point4 getBoxMaxCorner() {
        Point4 p = new Point4(this.xmax, this.ymax, this.zmax, 1.0);
        return p;
    }

    public void getBoxMinCorner(Point4 p) {
        p.set(this.xmin, this.ymin, this.zmin, 1.0);
    }

    public void getBoxMaxCorner(Point4 p) {
        p.set(this.xmax, this.ymax, this.zmax, 1.0);
    }

    public void makeEmpty() {
        this.empty = true;
        this.zmin = 0.0;
        this.ymin = 0.0;
        this.xmin = 0.0;
        this.zmax = 0.0;
        this.ymax = 0.0;
        this.xmax = 0.0;
    }

    public void union(Point4 p) {
        if (this.empty) {
            this.empty = false;
            this.xmin = this.xmax = p.x;
            this.ymin = this.ymax = p.y;
            this.zmin = this.zmax = p.z;
        } else {
            if (p.x < this.xmin) {
                this.xmin = p.x;
            }
            if (p.y < this.ymin) {
                this.ymin = p.y;
            }
            if (p.z < this.zmin) {
                this.zmin = p.z;
            }
            if (p.x > this.xmax) {
                this.xmax = p.x;
            }
            if (p.y > this.ymax) {
                this.ymax = p.y;
            }
            if (p.z > this.zmax) {
                this.zmax = p.z;
            }
        }
    }

    public double getSizeX() {
        return this.xmax - this.xmin;
    }

    public double getSizeY() {
        return this.ymax - this.ymin;
    }

    public double getSizeZ() {
        return this.zmax - this.zmin;
    }
}

