/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk.vtk;

import com.sas.graphics.chart.util.ctk.vtk.DoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.StringTickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleTransformStrategyInterface;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.StringProperty;

public class StringToDoubleStrategyMapper
extends DoubleStrategyMapper {
    public final StringProperty input = new StringProperty(this, true);
    protected IntegerPipeSwitcher categorySwitcher = new IntegerPipeSwitcher(this);
    public final IntegerPipe category = this.categorySwitcher;
    protected StringTickStrategyInterface tickStrategy;
    protected StringToDoubleTransformStrategyInterface transformStrategy;

    @Override
    public void init(AInitAction ia) {
        ia.setCategoryRequest(true);
        super.init(ia);
        if (ia.beenInitialized(this)) {
            return;
        }
        this.categorySwitcher.connectFrom(ia.getCategoryPipe());
        Formatter labelFormatter = this.getFormatter();
        this.valueVector.removeAllValues();
        this.labelVector.removeAllValues();
        if (this.transformStrategy != null && this.tickStrategy != null) {
            String[] values = this.tickStrategy.getValues();
            this.valueVector.setSize(values.length);
            this.labelVector.setSize(values.length);
            for (int ii = 0; ii < values.length; ++ii) {
                String value = labelFormatter != null ? labelFormatter.format(values[ii]) : values[ii];
                this.labelVector.setValueAt(value, ii);
                this.valueVector.setValueAt(this.transformStrategy.getValue(values[ii]), ii);
            }
        }
    }

    public StringTickStrategyInterface setTickStrategy(StringTickStrategyInterface tickStrategy) {
        if (this.tickStrategy != null) {
            this.tickStrategy.removeStateListener(this);
        }
        this.tickStrategy = tickStrategy;
        if (this.tickStrategy != null) {
            tickStrategy.addStateListener(this);
        }
        return this.tickStrategy;
    }

    public StringTickStrategyInterface getTickStrategy() {
        return this.tickStrategy;
    }

    public StringToDoubleTransformStrategyInterface setTransformStrategy(StringToDoubleTransformStrategyInterface transformStrategy) {
        if (this.transformStrategy != null) {
            this.transformStrategy.removeStateListener(this);
        }
        this.transformStrategy = transformStrategy;
        if (this.transformStrategy != null) {
            transformStrategy.addStateListener(this);
        }
        return this.transformStrategy;
    }

    public StringToDoubleTransformStrategyInterface getTransformStrategy() {
        return this.transformStrategy;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        if (this.transformStrategy == null) {
            throw new MissingValueException();
        }
        double value = this.transformStrategy.getValue(this.input.getValue(index));
        if (Double.isNaN(value)) {
            throw new MissingValueException();
        }
        return value;
    }

    @Override
    public double getOutputMin() {
        if (this.transformStrategy == null) {
            return Double.NaN;
        }
        return this.transformStrategy.getOutputMin();
    }

    @Override
    public double getOutputMax() {
        if (this.transformStrategy == null) {
            return Double.NaN;
        }
        return this.transformStrategy.getOutputMax();
    }

    private static class IntegerPipeSwitcher
    implements IntegerPipe {
        private StringToDoubleStrategyMapper container;
        private IntegerPipe ip;

        public IntegerPipeSwitcher(StringToDoubleStrategyMapper mapper) {
            this.container = mapper;
        }

        @Override
        public void init(AInitAction initAction) {
            this.container.init(initAction);
        }

        @Override
        public void reset(AResetAction resetAction) {
            this.container.reset(resetAction);
        }

        @Override
        public Formatter getFormatter() {
            return this.container.getFormatter();
        }

        public void connectFrom(IntegerPipe aPipe) {
            this.ip = aPipe;
        }

        @Override
        public int getValue(int i) throws MissingValueException {
            return this.ip.getValue(i);
        }
    }
}

