/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk.vtk;

import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericVariable;
import java.util.Vector;

public class NumericVariableSearch {
    protected static final int ASCENDING = 0;
    protected static final int DESCENDING = 1;
    NumericVariable variable;
    int[] indexTable;

    public NumericVariableSearch() {
    }

    public NumericVariableSearch(NumericVariable variable) {
        this.variable = variable;
    }

    public void setVariable(NumericVariable variable) {
        this.variable = variable;
    }

    public void setValidIndicies(int[] indexTable) {
        this.indexTable = indexTable;
    }

    public Result top(int count) {
        return this.compare(count, 0);
    }

    public Result bottom(int count) {
        return this.compare(count, 1);
    }

    protected Result compare(int count, int sortOrder) {
        int listSize;
        int valueCount;
        if (this.variable == null) {
            return null;
        }
        int n = valueCount = this.indexTable == null ? this.variable.getValueCount() : this.indexTable.length;
        if (count < 0) {
            count = valueCount;
        }
        Result searchResult = new Result();
        Vector<Integer> indexList = new Vector<Integer>(count);
        for (int ii = 0; ii < valueCount; ++ii) {
            try {
                int index;
                int n2 = index = this.indexTable == null ? ii : this.indexTable[ii];
                if (index < 0) continue;
                double value = this.variable.value.getValue(index);
                boolean found = false;
                int size = Math.min(indexList.size(), count);
                for (int jj = 0; jj < size && !found; ++jj) {
                    try {
                        double listValue = this.variable.value.getValue((Integer)indexList.elementAt(jj));
                        if (!(sortOrder == 0 && value >= listValue) && (sortOrder != 1 || !(value <= listValue))) continue;
                        indexList.insertElementAt(new Integer(index), jj);
                        found = true;
                        continue;
                    }
                    catch (MissingValueException e) {
                        // empty catch block
                    }
                }
                if (found || size >= count) continue;
                indexList.addElement(new Integer(index));
                continue;
            }
            catch (MissingValueException e) {
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int n3 = listSize = indexList != null ? Math.min(indexList.size(), count) : 0;
        if (listSize > 0) {
            searchResult.values = new double[listSize];
            searchResult.matchingObservations = new int[listSize];
            for (int ii = 0; ii < listSize; ++ii) {
                int index;
                searchResult.matchingObservations[ii] = index = ((Integer)indexList.elementAt(ii)).intValue();
                try {
                    searchResult.values[ii] = this.variable.value.getValue(index);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
        return searchResult;
    }

    public static class Result {
        public double[] values;
        public int[] matchingObservations;
    }
}

