/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk.vtk;

import com.sas.graphics.chart.util.ctk.StateAdapter;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleTransformStrategyInterface;

public class ConstantDoubleToDoubleTransformStrategy
extends StateAdapter
implements DoubleToDoubleTransformStrategyInterface {
    protected double inConst;
    protected double outConst;
    protected double inMin;
    protected double inMax;
    protected double outMin;
    protected double outMax;

    @Override
    public double getValue(double in) {
        double normalizedValue = (in - this.inMin) / this.inConst;
        double mappedValue = this.outMin + this.outConst * normalizedValue;
        return mappedValue;
    }

    protected void update() {
        this.outConst = this.outMax - this.outMin;
        this.inConst = this.inMax - this.inMin;
        this.stateChanged();
    }

    @Override
    public double getOutputMin() {
        return this.outMin;
    }

    @Override
    public void setOutputMin(double min) {
        this.outMin = min;
        this.update();
    }

    @Override
    public double getOutputMax() {
        return this.outMax;
    }

    @Override
    public void setOutputMax(double max) {
        this.outMax = max;
        this.update();
    }

    public double getInputMin() {
        return this.inMin;
    }

    @Override
    public void setInputMin(double min) {
        this.inMin = min;
        this.update();
    }

    public double getInputMax() {
        return this.inMax;
    }

    @Override
    public void setInputMax(double max) {
        this.inMax = max;
        this.update();
    }
}

