/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk.vtk;

import java.util.Vector;

class CaseInsensitiveSortedStringVector {
    Vector upperCaseVector = new Vector();
    Vector vector = new Vector();

    CaseInsensitiveSortedStringVector() {
    }

    public synchronized String stringAt(int index) {
        return (String)this.vector.elementAt(index);
    }

    public synchronized void addString(String value) {
        int size;
        int sortIndex = this.sortIndex(value);
        if (sortIndex == (size = this.size())) {
            this.upperCaseVector.addElement(value.toUpperCase());
            this.vector.addElement(value);
        } else {
            this.upperCaseVector.insertElementAt(value.toUpperCase(), sortIndex);
            this.vector.insertElementAt(value, sortIndex);
        }
    }

    public synchronized int sortIndex(String s) {
        return this.sortIndex(s, 0);
    }

    public synchronized int sortIndex(String value, int index) {
        String uppercaseValue = value.toUpperCase();
        int size = this.size();
        for (int jj = index; jj < size; ++jj) {
            int compResult = ((String)this.upperCaseVector.elementAt(jj)).compareTo(uppercaseValue);
            if (compResult <= 0 && (compResult != 0 || ((String)this.vector.elementAt(jj)).compareTo(value) < 0)) continue;
            return jj;
        }
        return size;
    }

    public synchronized void removeAllStrings() {
        this.upperCaseVector.removeAllElements();
        this.vector.removeAllElements();
    }

    public synchronized void removeStringAt(int index) throws ArrayIndexOutOfBoundsException {
        this.upperCaseVector.removeElementAt(index);
        this.vector.removeElementAt(index);
    }

    public synchronized int indexOf(String s) {
        return this.indexOf(s, 0, false);
    }

    public synchronized int indexOf(String s, boolean caseSensitive) {
        return this.indexOf(s, 0, caseSensitive);
    }

    public synchronized int indexOf(String s, int index) {
        return this.indexOf(s, index, false);
    }

    public synchronized int indexOf(String s, int index, boolean caseSensitive) {
        int ii = this.vector.indexOf(s, index);
        if (caseSensitive && ii == -1) {
            ii = this.upperCaseVector.indexOf(s.toUpperCase(), index);
        }
        return ii;
    }

    public synchronized int startsWith(String s) {
        return this.startsWith(s, 0, false);
    }

    public synchronized int startsWith(String s, boolean caseSensitive) {
        return this.startsWith(s, 0, caseSensitive);
    }

    public synchronized int startsWith(String s, int index) {
        return this.startsWith(s, index, false);
    }

    public synchronized int startsWith(String s, int index, boolean caseSensitive) {
        String upperS = caseSensitive ? null : s.toUpperCase();
        int ii = 0;
        int size = this.size();
        if (ii < size) {
            if (this.stringAt(ii).startsWith(s)) {
                return ii;
            }
            if (!caseSensitive || ((String)this.upperCaseVector.elementAt(index)).startsWith(upperS)) {
                // empty if block
            }
            return ii;
        }
        return -1;
    }

    public synchronized boolean removeString(String s) {
        int index = this.vector.indexOf(s);
        if (index == -1) {
            index = this.upperCaseVector.indexOf(s.toUpperCase());
        }
        if (index > 0) {
            this.upperCaseVector.removeElementAt(index);
            this.vector.removeElementAt(index);
            return true;
        }
        return false;
    }

    public synchronized int size() {
        return this.vector.size();
    }

    public synchronized String[] toStringArray() {
        int size = this.size();
        String[] array = new String[size];
        for (int ii = 0; ii < size; ++ii) {
            array[ii] = (String)this.vector.elementAt(ii);
        }
        return array;
    }
}

