/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.PropertyContainer;
import com.sas.graphics.util.vtk.StringProperty;
import java.util.Hashtable;

public class AccumuleAcrossString
extends PropertyContainer
implements NumericPipe {
    public final NumericProperty input = new NumericProperty(this, true);
    public final StringProperty string = new StringProperty(this, true);
    public final NumericPipe value = this;
    private double[] totals;
    private int categoryCount;
    private double startValue = 0.0;
    private int lastIndex = -1;
    private double lastValue;
    private boolean postAccumulate = true;
    private Hashtable stringLookup;

    public void setPostAccumulate(boolean trueOrFalse) {
        this.postAccumulate = trueOrFalse;
    }

    public boolean getPostAccumulate() {
        return this.postAccumulate;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        double r;
        if (this.lastIndex == index) {
            return this.lastValue;
        }
        int stringIndex = (Integer)this.stringLookup.get(this.string.getValue(index));
        if (this.postAccumulate) {
            r = this.totals[stringIndex];
            int n = stringIndex;
            this.totals[n] = this.totals[n] + this.input.getValue(index);
        } else {
            int n = stringIndex;
            this.totals[n] = this.totals[n] + this.input.getValue(index);
            r = this.totals[stringIndex];
        }
        this.lastIndex = index;
        this.lastValue = r;
        return r;
    }

    public void setStartValue(double aStartValue) {
        this.startValue = aStartValue;
        this.reset();
    }

    public double getStartValue() {
        return this.startValue;
    }

    @Override
    public void reset(AResetAction resetAction) {
        this.reset();
    }

    private void reset() {
        for (int ii = 0; ii < this.categoryCount; ++ii) {
            this.totals[ii] = this.startValue;
        }
        this.lastIndex = -1;
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        if (initAction.beenInitialized(this)) {
            this.reset();
            return;
        }
        try {
            if (this.stringLookup == null) {
                this.stringLookup = new Hashtable();
            } else {
                this.stringLookup.clear();
            }
            this.categoryCount = 0;
            int size = initAction.getValueCount();
            for (int ii = 0; ii < size; ++ii) {
                String stringValue = this.string.getValue(ii);
                if (this.stringLookup.contains(stringValue)) continue;
                this.stringLookup.put(stringValue, new Integer(this.categoryCount++));
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        this.totals = new double[this.categoryCount];
        this.reset();
    }
}

