/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.VTKVisualizationGraphicsInterface;
import com.sas.graphics.chart.util.ctk.VisualizationComponent;
import com.sas.graphics.chart.util.ctk.VisualizationComponentInterface;
import com.sas.graphics.chart.util.ctk.VisualizationConstraintInterface;
import com.sas.graphics.chart.util.ctk.VisualizationContainerInterface;
import com.sas.graphics.chart.util.ctk.VisualizationGraphicsInterface;
import com.sas.graphics.chart.util.ctk.VisualizationLayoutManagerInterface;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.ANetworkRoot;
import com.sas.graphics.util.vtk.jxd.NetworkRoot;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class VisualizationContainer
extends VisualizationComponent
implements VisualizationContainerInterface {
    static final VisualizationConstraintInterface NULL_CONSTRAINT = new nullConstraint();
    protected final Object CHILDREN_LOCK = new Object();
    protected Hashtable constraints;
    protected Vector children;
    protected VisualizationLayoutManagerInterface layoutManager;
    protected ANetworkRoot internalNetworkRoot;

    protected VisualizationContainer() {
    }

    public static Object newInstance() {
        VisualizationContainer o = new VisualizationContainer();
        o.init();
        return o;
    }

    public static final VisualizationContainer newVisualizationContainer() {
        return (VisualizationContainer)VisualizationContainer.newInstance();
    }

    @Override
    protected void init() {
        super.init();
        this.constraints = new Hashtable();
        this.children = new Vector();
    }

    @Override
    public VisualizationComponentInterface add(VisualizationComponentInterface child) {
        return this.add(child, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VisualizationComponentInterface add(VisualizationComponentInterface vc, VisualizationConstraintInterface constraint) {
        Object object = this.CHILDREN_LOCK;
        synchronized (object) {
            try {
                VisualizationComponent child = (VisualizationComponent)vc;
                this.attachChild(child);
                this.children.addElement(child);
                this.constraints.put(child, constraint != null ? constraint.copy() : NULL_CONSTRAINT);
                return child;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VisualizationComponentInterface remove(VisualizationComponentInterface vc) {
        Object object = this.CHILDREN_LOCK;
        synchronized (object) {
            try {
                VisualizationComponent child = (VisualizationComponent)vc;
                if (this.children.removeElement(child)) {
                    this.constraints.remove(child);
                    this.detachChild(child);
                    VisualizationComponent visualizationComponent = child;
                    return visualizationComponent;
                }
            }
            catch (Exception exception) {}
            finally {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachChild(VisualizationComponent child) throws Exception {
        VisualizationComponent visualizationComponent = child;
        synchronized (visualizationComponent) {
            child.setVisualizationParent(this);
            child.setVisualizationGraphics(this.visualizationGraphics);
            this.invalidateGraphics();
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachChild(VisualizationComponent child) throws Exception {
        VisualizationComponent visualizationComponent = child;
        synchronized (visualizationComponent) {
            child.setVisualizationParent(null);
            child.setVisualizationGraphics(null);
            this.invalidateGraphics();
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Object object = this.CHILDREN_LOCK;
        synchronized (object) {
            Enumeration childEnum = this.children.elements();
            while (childEnum.hasMoreElements()) {
                try {
                    this.detachChild((VisualizationComponent)childEnum.nextElement());
                }
                catch (Exception exception) {}
            }
            this.children.removeAllElements();
            this.constraints.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration visualizationComponents() {
        Object object = this.CHILDREN_LOCK;
        synchronized (object) {
            return ((Vector)this.children.clone()).elements();
        }
    }

    @Override
    public int countVisualizationComponents() {
        return this.children.size();
    }

    @Override
    public VisualizationComponentInterface visualizationComponentAt(int ii) {
        return (VisualizationComponentInterface)this.children.elementAt(ii);
    }

    @Override
    public VisualizationConstraintInterface getVisualizationConstraint(VisualizationComponentInterface vc) {
        VisualizationConstraintInterface constraint = (VisualizationConstraintInterface)this.constraints.get(vc);
        return constraint == NULL_CONSTRAINT ? null : constraint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void attachVisualizationGraphics(VisualizationGraphicsInterface vg) {
        super.attachVisualizationGraphics(vg);
        Object object = this.CHILDREN_LOCK;
        synchronized (object) {
            Enumeration childEnum = this.children.elements();
            try {
                while (childEnum.hasMoreElements()) {
                    ((VisualizationComponent)childEnum.nextElement()).setVisualizationGraphics(vg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void detachVisualizationGraphics() {
        super.detachVisualizationGraphics();
        Object object = this.CHILDREN_LOCK;
        synchronized (object) {
            Enumeration childEnum = this.children.elements();
            try {
                while (childEnum.hasMoreElements()) {
                    ((VisualizationComponent)childEnum.nextElement()).setVisualizationGraphics(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public VisualizationLayoutManagerInterface getVisualizationLayoutManager() {
        return this.layoutManager;
    }

    @Override
    public VisualizationLayoutManagerInterface setVisualizationLayoutManager(VisualizationLayoutManagerInterface vlm) {
        try {
            if (vlm == null || vlm.setVisualizationContainer(this) == this) {
                if (this.layoutManager != null) {
                    this.layoutManager.setVisualizationContainer(null);
                }
                this.layoutManager = vlm;
                this.invalidate();
            }
        }
        catch (Exception exception) {}
        finally {
            return this.layoutManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        if (this.layoutManager != null) {
            Object object = this.CHILDREN_LOCK;
            synchronized (object) {
                this.layoutManager.layoutContainer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void validate() {
        if (this.layoutManager != null) {
            Object object = this.CHILDREN_LOCK;
            synchronized (object) {
                this.doLayout();
                Enumeration childEnum = this.children.elements();
                while (childEnum.hasMoreElements()) {
                    ((VisualizationComponentInterface)childEnum.nextElement()).validate();
                }
            }
        }
        super.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean generateGraphics() {
        boolean graphicsChange = !this.isValidGraphics();
        Vector<Object> includeIDs = this.isValidGraphics() ? null : new Vector<Object>();
        Object object = this.CHILDREN_LOCK;
        synchronized (object) {
            if (this.internalNetworkRoot != null) {
                this.internalNetworkRoot.build();
                if (includeIDs != null) {
                    includeIDs.addElement(new Long(((NetworkRoot)this.internalNetworkRoot).getRootListName()));
                }
            }
            Enumeration childEnum = this.children.elements();
            while (childEnum.hasMoreElements()) {
                VisualizationComponentInterface child = (VisualizationComponentInterface)childEnum.nextElement();
                graphicsChange |= child.generateGraphics();
                if (includeIDs == null) continue;
                includeIDs.addElement(child.getGraphicsID());
            }
        }
        try {
            if (includeIDs != null) {
                ((VTKVisualizationGraphicsInterface)this.getVisualizationGraphics()).makeHierarchyList(this.getGraphicsID(), includeIDs.elements());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.validateGraphics();
        return graphicsChange;
    }

    @Override
    protected void makeNetwork() {
    }

    @Override
    public void rerender() {
        VisualizationGraphicsInterface vg = this.getVisualizationGraphics();
        if (vg != null) {
            vg.rerender();
        }
    }

    @Override
    public void transferFocus(VisualizationComponentInterface child) {
    }

    @Override
    public Vec3d getMaximumExtent() {
        return this.layoutManager != null ? this.layoutManager.getMaximumExtent() : super.getMaximumExtent();
    }

    @Override
    public Vec3d getPreferredExtent() {
        return this.layoutManager != null ? this.layoutManager.getPreferredExtent() : super.getPreferredExtent();
    }

    @Override
    public Vec3d getMinimumExtent() {
        return this.layoutManager != null ? this.layoutManager.getMinimumExtent() : super.getMinimumExtent();
    }

    @Override
    public Vec3d getMinimumPartialExtent() {
        return this.layoutManager != null ? this.layoutManager.getMinimumPartialExtent() : super.getMinimumPartialExtent();
    }

    static class nullConstraint
    implements VisualizationConstraintInterface {
        nullConstraint() {
        }

        @Override
        public VisualizationConstraintInterface copy() {
            return this;
        }
    }
}

