/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.EventActionInterface;
import com.sas.graphics.chart.util.ctk.JustifiedPipedProbe;
import com.sas.graphics.chart.util.ctk.ProbeInfo;
import com.sas.graphics.chart.util.ctk.ProbeInterface;
import com.sas.graphics.chart.util.ctk.SelectInfo;
import com.sas.graphics.chart.util.ctk.VTKVisualizationGraphicsInterface;
import com.sas.graphics.chart.util.ctk.VisualizationComponentInterface;
import com.sas.graphics.chart.util.ctk.VisualizationContainerInterface;
import com.sas.graphics.chart.util.ctk.VisualizationGraphicsInterface;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AComposite;
import com.sas.graphics.util.vtk.ANetworkRoot;
import com.sas.graphics.util.vtk.jxd.Composite;
import com.sas.graphics.util.vtk.jxd.NetworkRoot;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.PopupMenu;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class VisualizationComponent
implements VisualizationComponentInterface {
    protected VisualizationContainerInterface vParent;
    protected AComposite composite;
    protected Vec3d origin;
    protected Vec3d extent;
    protected boolean visible;
    protected boolean valid;
    protected boolean enabled;
    protected String name;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected FocusListener focusListener;
    protected KeyListener keyListener;
    protected ComponentListener componentListener;
    protected SelectInfo selectInfo;
    protected Vector popupMenus;
    protected Vector eventActions;
    protected Locale locale;
    protected VTKVisualizationGraphicsInterface visualizationGraphics;
    protected ANetworkRoot networkRoot;
    protected final Object LAYOUT_LOCK = new Object();
    protected final Object GRAPHICS_LOCK = new Object();
    protected final Object EVENTACTION_LOCK = new Object();
    protected final Object PARENT_LOCK = new Object();
    protected final Object NETWORK_LOCK = new Object();
    protected ProbeInterface defaultProbe;
    protected ProbeInterface probe;
    private int paintGate;
    private boolean paintPending;
    private boolean validGraphics;

    protected VisualizationComponent() {
    }

    public static Object newInstance() {
        VisualizationComponent o = new VisualizationComponent();
        o.init();
        return o;
    }

    public static final VisualizationComponent newVisualizationComponent() {
        return (VisualizationComponent)VisualizationComponent.newInstance();
    }

    protected void init() {
        this.paintGate = 0;
        this.paintPending = false;
        this.valid = false;
        this.enabled = true;
        this.visible = true;
        this.origin = new Vec3d();
        this.extent = new Vec3d();
        this.composite = new Composite();
        this.composite.setUserData(this);
        this.defaultProbe = new JustifiedPipedProbe();
        this.defaultProbe.setBackgroundColor(new Color(254, 248, 209));
        this.defaultProbe.setTextBuffer(4);
        this.defaultProbe.setInsets(new Insets(3, 3, 3, 3));
        this.probe = this.defaultProbe;
    }

    @Override
    public void setVisible(boolean b) {
        this.visible = b;
        this.invalidate();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() {
        if (!this.valid) {
            this.valid = true;
            Object object = this.NETWORK_LOCK;
            synchronized (object) {
                this.makeNetwork();
            }
        }
    }

    @Override
    public void invalidate() {
        if (this.valid) {
            this.valid = false;
            if (this.vParent != null) {
                this.vParent.invalidate();
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean generateGraphics() {
        if (!this.isValidGraphics()) {
            Object object = this.NETWORK_LOCK;
            synchronized (object) {
                this.networkRoot.build();
                this.validateGraphics();
                return true;
            }
        }
        return false;
    }

    protected void makeNetwork() {
    }

    @Override
    public ANetworkRoot getNetworkRoot() {
        return this.networkRoot;
    }

    @Override
    public VisualizationContainerInterface getVisualizationParent() {
        return this.vParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisualizationParent(VisualizationContainerInterface vt) throws Exception {
        Object object = this.PARENT_LOCK;
        synchronized (object) {
            if (this.vParent != null && vt == null) {
                this.detachVisualizationParent();
            } else if (this.vParent == null && vt != null) {
                this.attachVisualizationParent(vt);
            } else if (this.vParent != vt) {
                throw new Exception("Unable to set VisualizationParent to " + vt);
            }
        }
    }

    private void attachVisualizationParent(VisualizationContainerInterface vt) {
        this.vParent = vt;
        this.invalidate();
    }

    private void detachVisualizationParent() {
        this.vParent = null;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisualizationGraphics(VisualizationGraphicsInterface vg) throws Exception {
        Object object = this.GRAPHICS_LOCK;
        synchronized (object) {
            if (this.visualizationGraphics != null && vg == null) {
                this.detachVisualizationGraphics();
            } else if (this.visualizationGraphics == null && vg != null) {
                this.attachVisualizationGraphics(vg);
            } else if (this.visualizationGraphics != vg) {
                throw new Exception("Unable to set VisualizationGrapics to " + vg);
            }
        }
    }

    protected void attachVisualizationGraphics(VisualizationGraphicsInterface vg) {
        this.visualizationGraphics = (VTKVisualizationGraphicsInterface)vg;
        this.networkRoot = this.visualizationGraphics.newNetworkRoot();
        this.networkRoot.addElement(this.composite);
        if (this.popupMenus != null) {
            Enumeration popupMenuEnum = this.popupMenus.elements();
            while (popupMenuEnum.hasMoreElements()) {
                this.visualizationGraphics.addPopupMenu((PopupMenu)popupMenuEnum.nextElement());
            }
        }
    }

    protected void detachVisualizationGraphics() {
        if (this.visualizationGraphics != null) {
            this.networkRoot.removeAllElements();
            this.networkRoot = null;
            if (this.popupMenus != null) {
                Enumeration popupMenuEnum = this.popupMenus.elements();
                while (popupMenuEnum.hasMoreElements()) {
                    this.visualizationGraphics.removePopupMenu((PopupMenu)popupMenuEnum.nextElement());
                }
            }
            this.visualizationGraphics = null;
        }
    }

    @Override
    public Object getGraphicsID() {
        return this.networkRoot == null ? null : new Long(((NetworkRoot)this.networkRoot).getRootListName());
    }

    @Override
    public void rerender() {
        this.invalidateGraphics();
        VisualizationGraphicsInterface vg = this.getVisualizationGraphics();
        if (vg != null) {
            vg.rerender();
        }
    }

    @Override
    public void render() {
        this.invalidateGraphics();
        VisualizationGraphicsInterface vg = this.getVisualizationGraphics();
        if (vg != null) {
            vg.render();
        }
    }

    @Override
    public void invalidateGraphics() {
        this.validGraphics = false;
    }

    @Override
    public void validateGraphics() {
        this.validGraphics = true;
    }

    @Override
    public boolean isValidGraphics() {
        return this.validGraphics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vec3d setExtent(Vec3d extent) {
        Object object = this.LAYOUT_LOCK;
        synchronized (object) {
            this.invalidateGraphics();
            this.extent.x = extent.x;
            this.extent.y = extent.y;
            this.extent.z = extent.z;
            return extent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vec3d getExtent() {
        Object object = this.LAYOUT_LOCK;
        synchronized (object) {
            return new Vec3d(this.extent.x, this.extent.y, this.extent.z);
        }
    }

    @Override
    public BoundingBox setClipBounds(BoundingBox clipBounds) {
        this.invalidateGraphics();
        this.composite.setClipBounds(clipBounds);
        return clipBounds;
    }

    @Override
    public BoundingBox getClipBounds() {
        return this.composite.getClipBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vec3d setOrigin(Vec3d origin) {
        Object object = this.LAYOUT_LOCK;
        synchronized (object) {
            this.invalidateGraphics();
            this.origin.x = origin.x;
            this.origin.y = origin.y;
            this.origin.z = origin.z;
            return origin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vec3d getOrigin() {
        Object object = this.LAYOUT_LOCK;
        synchronized (object) {
            return new Vec3d(this.origin.x, this.origin.y, this.origin.z);
        }
    }

    @Override
    public Vec3d getMaximumExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getPreferredExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getMinimumExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getMinimumPartialExtent() {
        return new Vec3d();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.visualizationGraphics != null) {
            Object object = this.GRAPHICS_LOCK;
            synchronized (object) {
                return this.visualizationGraphics.getLocale();
            }
        }
        return null;
    }

    @Override
    public void setLocale(Locale l) {
        this.locale = l;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    @Override
    public void requestFocus() {
        if (this.visualizationGraphics != null) {
            this.visualizationGraphics.requestFocus();
        }
    }

    @Override
    public void transferFocus() {
        if (this.vParent != null) {
            this.vParent.transferFocus(this);
        }
    }

    @Override
    public String toString() {
        return "VisualizationComponent : name[" + this.name + "], enabled[" + this.enabled + "], visible[" + this.visible + "], parented[" + (this.vParent != null) + "], origin[" + this.origin + "], extent[" + this.extent + "]";
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VisualizationGraphicsInterface getVisualizationGraphics() {
        return this.visualizationGraphics != null ? this.visualizationGraphics : (this.vParent != null ? this.vParent.getVisualizationGraphics() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventActionInterface addEventAction(EventActionInterface eventAction) {
        if (eventAction != null) {
            Object object = this.EVENTACTION_LOCK;
            synchronized (object) {
                if (this.eventActions == null) {
                    this.eventActions = new Vector();
                }
                if (!this.eventActions.contains(eventAction)) {
                    this.eventActions.addElement(eventAction);
                }
            }
            return eventAction;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventActionInterface removeEventAction(EventActionInterface eventAction) {
        if (this.eventActions != null && eventAction != null) {
            Object object = this.EVENTACTION_LOCK;
            synchronized (object) {
                if (this.eventActions.removeElement(eventAction)) {
                    return eventAction;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration eventActions() {
        if (this.eventActions != null) {
            Object object = this.EVENTACTION_LOCK;
            synchronized (object) {
                return ((Vector)this.eventActions.clone()).elements();
            }
        }
        return null;
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.visualizationGraphics != null) {
            this.visualizationGraphics.setCursor(cursor);
        }
    }

    @Override
    public Cursor getCursor() {
        return this.visualizationGraphics != null ? this.visualizationGraphics.getCursor() : null;
    }

    @Override
    public void setProbe(ProbeInterface probe) {
        this.probe = probe == null ? this.defaultProbe : probe;
    }

    @Override
    public ProbeInfo newProbeInfo(int x, int y) {
        return new ProbeInfo(this.probe, this.getSelectionIndex(), x, y);
    }

    @Override
    public ProbeInfo newProbeInfo(int style, int x, int y) {
        return this.newProbeInfo(x, y);
    }

    @Override
    public ProbeInfo newProbeInfo(ProbeInterface probe, boolean addDataPipes, int style, int x, int y) {
        return this.newProbeInfo(probe, addDataPipes, x, y);
    }

    @Override
    public ProbeInfo newProbeInfo(ProbeInterface probe, boolean addDataPipes, int x, int y) {
        if (addDataPipes) {
            this.configureProbe(probe);
        }
        return new ProbeInfo(probe, this.getSelectionIndex(), x, y);
    }

    protected void configureProbe(ProbeInterface probe) {
    }

    @Override
    public int getSelectionIndex() {
        if (this.selectInfo == null) {
            return -1;
        }
        return this.selectInfo.getValueIndex();
    }

    @Override
    public void addPopupMenu(PopupMenu popupMenu) {
        if (popupMenu != null) {
            if (this.popupMenus == null) {
                this.popupMenus = new Vector();
            }
            this.popupMenus.addElement(popupMenu);
            if (this.visualizationGraphics != null) {
                this.visualizationGraphics.addPopupMenu(popupMenu);
            }
        }
    }

    @Override
    public void removePopupMenu(PopupMenu popupMenu) {
        if (this.popupMenus != null && popupMenu != null && this.popupMenus.contains(popupMenu)) {
            this.popupMenus.removeElement(popupMenu);
            if (this.visualizationGraphics != null) {
                this.visualizationGraphics.removePopupMenu(popupMenu);
            }
        }
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, l);
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, l);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, l);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, l);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, l);
    }

    @Override
    public synchronized void addComponentListener(ComponentListener l) {
        this.componentListener = AWTEventMulticaster.add(this.componentListener, l);
    }

    @Override
    public synchronized void removeComponentListener(ComponentListener l) {
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, l);
    }

    @Override
    public synchronized void dispatchEvent(AWTEvent event, SelectInfo selectInfo) {
        if (this.enabled && event != null) {
            this.selectInfo = selectInfo;
            this.processEvent(event);
        }
    }

    protected void processEvent(AWTEvent event) {
        if (this.eventActions != null) {
            Enumeration eventActionEnum = this.eventActions();
            while (eventActionEnum.hasMoreElements()) {
                ((EventActionInterface)eventActionEnum.nextElement()).processEvent(this, event);
            }
        }
        if (event instanceof MouseEvent) {
            switch (event.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)event);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)event);
                }
            }
        } else if (event instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)event);
        } else if (event instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)event);
        } else if (event instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)event);
        }
    }

    private void processMouseEvent(MouseEvent event) {
        if (this.mouseListener != null) {
            switch (event.getID()) {
                case 501: {
                    this.mouseListener.mousePressed(event);
                    break;
                }
                case 502: {
                    this.mouseListener.mouseReleased(event);
                    break;
                }
                case 500: {
                    this.mouseListener.mouseClicked(event);
                    break;
                }
                case 505: {
                    this.mouseListener.mouseExited(event);
                    break;
                }
                case 504: {
                    this.mouseListener.mouseEntered(event);
                }
            }
        }
    }

    private void processMouseMotionEvent(MouseEvent event) {
        if (this.mouseMotionListener != null) {
            switch (event.getID()) {
                case 503: {
                    this.mouseMotionListener.mouseMoved(event);
                    break;
                }
                case 506: {
                    this.mouseMotionListener.mouseDragged(event);
                }
            }
        }
    }

    private void processKeyEvent(KeyEvent event) {
        if (this.keyListener != null) {
            switch (event.getID()) {
                case 400: {
                    this.keyListener.keyTyped(event);
                    break;
                }
                case 401: {
                    this.keyListener.keyPressed(event);
                    break;
                }
                case 402: {
                    this.keyListener.keyReleased(event);
                }
            }
        }
    }

    private void processComponentEvent(ComponentEvent event) {
        if (this.componentListener != null) {
            switch (event.getID()) {
                case 101: {
                    this.componentListener.componentResized(event);
                    break;
                }
                case 100: {
                    this.componentListener.componentMoved(event);
                    break;
                }
                case 102: {
                    this.componentListener.componentShown(event);
                    break;
                }
                case 103: {
                    this.componentListener.componentHidden(event);
                }
            }
        }
    }

    private void processFocusEvent(FocusEvent event) {
        if (this.focusListener != null) {
            switch (event.getID()) {
                case 1004: {
                    this.focusListener.focusGained(event);
                    break;
                }
                case 1005: {
                    this.focusListener.focusLost(event);
                }
            }
        }
    }
}

