/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.ContinuousDoubleRangeNode;
import com.sas.graphics.chart.util.ctk.DiscreteStringRangeNode;
import com.sas.graphics.chart.util.ctk.DoubleRangeNodeInterface;
import com.sas.graphics.chart.util.ctk.RangeNode;
import com.sas.graphics.chart.util.ctk.RangeNodeInterface;
import com.sas.graphics.chart.util.ctk.StringRangeNodeInterface;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.Variable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class VariableRanger {
    protected static int UNIQUE = 0;
    protected static int UNIFORM = 1;
    protected Vector hierarchialOrder;
    protected boolean modified = false;
    protected Hashtable variables = new Hashtable();
    protected RangeNodeInterface range = null;

    public RangeNodeInterface getRange() {
        if (this.modified) {
            this.updateRange();
        }
        return this.range;
    }

    public Vector setHierarchialOrder(Vector order) {
        this.modified = true;
        this.hierarchialOrder = (Vector)order.clone();
        return order;
    }

    public void setVariable(Object id, Variable v) {
        if (id != null) {
            this.modified = true;
            if (v == null) {
                this.variables.remove(id);
            } else {
                this.variables.put(id, v);
            }
        }
    }

    public void clear() {
        this.hierarchialOrder = null;
        this.modified = false;
        this.range = null;
    }

    protected RangeNodeInterface updateRange() {
        this.range = null;
        if (this.hierarchialOrder != null && this.hierarchialOrder.size() > 0) {
            Vector<IDVAR> activeVars = null;
            Object ids = null;
            int size = this.hierarchialOrder.size();
            for (int ii = 0; ii < size; ++ii) {
                Object id = this.hierarchialOrder.elementAt(ii);
                Variable variable = (Variable)this.variables.get(id);
                if (variable == null) continue;
                if (activeVars == null) {
                    activeVars = new Vector<IDVAR>();
                }
                activeVars.addElement(new IDVAR(id, variable));
            }
            if (activeVars != null) {
                this.range = VariableRanger.makeHierarchialRange(activeVars);
            }
        } else {
            Enumeration keys = this.variables.keys();
            while (keys.hasMoreElements()) {
                Object id = keys.nextElement();
                this.range = VariableRanger.union(this.range, id, (Variable)this.variables.get(id));
            }
        }
        return this.range;
    }

    public static RangeNodeInterface union(RangeNodeInterface range, Object id, Variable variable) {
        if (variable == null || variable.getValueCount() == 0) {
            return range;
        }
        if (range == null) {
            range = new RangeNode(id);
        }
        if (variable instanceof StringVariable) {
            return VariableRanger.union(range, ((StringVariable)variable).uniqueValue, variable.getUniqueValueCount());
        }
        if (variable instanceof NumericVariable) {
            return VariableRanger.union(range, ((NumericVariable)variable).value, variable.getValueCount());
        }
        return null;
    }

    public static RangeNodeInterface union(RangeNodeInterface range, Object id, Pipe pipe, int count) {
        if (pipe == null) {
            return range;
        }
        if (range == null) {
            range = new RangeNode(id);
        }
        return VariableRanger.union(range, pipe, count);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RangeNodeInterface union(RangeNodeInterface range, Pipe pipe, int count) {
        RangeNodeInterface child;
        if (pipe == null) {
            return range;
        }
        if (range == null) {
            range = new RangeNode(new Integer(-1));
        }
        if (pipe instanceof StringPipe) {
            Object aChild;
            Vector childList = range.childrenVector();
            if (childList != null && childList.size() > 0 && !((aChild = childList.elementAt(0)) instanceof StringRangeNodeInterface)) {
                return range;
            }
            int size = count;
            if (size <= 0) return range;
            int ii = 0;
            while (ii < size) {
                String value = "";
                try {
                    value = ((StringPipe)pipe).getValue(ii);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                range.add(new DiscreteStringRangeNode(new Integer(Integer.MIN_VALUE), value));
                ++ii;
            }
            return range;
        }
        if (!(pipe instanceof NumericPipe)) return null;
        MinMax dataRange = VariableRanger.getMinMax((NumericPipe)pipe, count);
        if (dataRange == null) return range;
        if (Double.isNaN(dataRange.min)) return range;
        if (Double.isNaN(dataRange.max)) return range;
        Vector childList = range.childrenVector();
        RangeNodeInterface rangeNodeInterface = child = childList != null && childList.size() > 0 ? (RangeNodeInterface)childList.elementAt(0) : null;
        if (child == null) {
            range.add(new ContinuousDoubleRangeNode(new Integer(Integer.MIN_VALUE), dataRange.min, dataRange.max));
            return range;
        } else {
            if (!(child instanceof DoubleRangeNodeInterface)) return range;
            DoubleRangeNodeInterface drn = (DoubleRangeNodeInterface)child;
            double min = drn.getStart();
            double max = drn.getEnd();
            if (dataRange.min > min) {
                dataRange.min = min;
            }
            if (dataRange.max < max) {
                dataRange.max = max;
            }
            range.remove(child);
            range.add(new ContinuousDoubleRangeNode(new Integer(Integer.MIN_VALUE), dataRange.min, dataRange.max));
        }
        return range;
    }

    public static RangeNodeInterface makeHierarchialRange(Vector vars) {
        return VariableRanger.makeHierarchialRange(vars, UNIFORM);
    }

    public static RangeNodeInterface makeHierarchialRange(Vector idVars, int mode) {
        if (idVars == null) {
            return null;
        }
        RangeNodeInterface returnedRange = null;
        int size = idVars.size();
        for (int ii = 0; ii < size; ++ii) {
            IDVAR idVar = (IDVAR)idVars.elementAt(ii);
            RangeNodeInterface range = VariableRanger.union(null, idVar.id, idVar.variable);
            if (returnedRange == null) {
                returnedRange = range;
                continue;
            }
            Vector childList = returnedRange.childrenVector();
            int childListSize = childList != null ? childList.size() : 0;
            for (int jj = 0; jj < childListSize; ++jj) {
                RangeNodeInterface child = (RangeNodeInterface)childList.elementAt(jj);
                child.setID(idVar.id);
                Vector childList2 = range.childrenVector();
                int childListSize2 = childList2 != null ? childList2.size() : 0;
                for (int kk = 0; kk < childListSize2; ++kk) {
                    RangeNodeInterface child2 = (RangeNodeInterface)childList2.elementAt(kk);
                    child.add(child2);
                }
            }
        }
        return returnedRange;
    }

    public static MinMax getMinMax(NumericPipe pipe, int count) {
        MinMax minMax = null;
        if (pipe != null && count > 0) {
            double min = Double.NaN;
            double max = Double.NaN;
            for (int ii = 0; ii < count; ++ii) {
                try {
                    double value;
                    min = value = pipe.getValue(ii);
                    max = value;
                    break;
                }
                catch (MissingValueException value) {
                    continue;
                }
            }
            for (int jj = ii; jj < count; ++jj) {
                try {
                    double value = pipe.getValue(jj);
                    if (min > value) {
                        min = value;
                    }
                    if (!(max < value)) continue;
                    max = value;
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            if (!Double.isNaN(min) && !Double.isNaN(max)) {
                minMax = new MinMax(min, max);
            }
        }
        return minMax;
    }

    protected static class IDVAR {
        public Variable variable;
        public Object id;

        public IDVAR(Object id, Variable variable) {
            this.id = id;
            this.variable = variable;
        }
    }

    public static class MinMax {
        public double min;
        public double max;

        public MinMax(double v1, double v2) {
            if (v1 < v2) {
                this.min = v1;
                this.max = v2;
            } else {
                this.min = v2;
                this.max = v1;
            }
        }
    }
}

