/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.AxisInterface;
import com.sas.graphics.chart.util.ctk.SingleDataOverlay;
import com.sas.graphics.chart.util.ctk.StateEvent;
import com.sas.graphics.chart.util.ctk.StateListener;
import com.sas.graphics.chart.util.ctk.StateSource;
import com.sas.graphics.chart.util.ctk.vtk.DoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.TransformStrategyInterface;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class TwoAxisOverlay
extends SingleDataOverlay {
    public static final Integer INDEPENDENT_AXIS = new Integer(0);
    public static final Integer DEPENDENT_AXIS = new Integer(1);
    protected TransformStrategyInterface independentAxisTransformStrategy;
    protected TransformStrategyInterface dependentAxisTransformStrategy;
    protected Hashtable dependentAxisMappers;
    protected Hashtable independentAxisMappers;
    private AxisTransformStrategyStateListener axisTransformStrategyStateListener;

    @Override
    protected void init() {
        super.init();
        this.dependentAxisMappers = new Hashtable();
        this.independentAxisMappers = new Hashtable();
        this.axisTransformStrategyStateListener = new AxisTransformStrategyStateListener();
    }

    public boolean setIndependentAxis(AxisInterface axis) {
        return this.setAxis(INDEPENDENT_AXIS, axis) != null;
    }

    public AxisInterface getIndependentAxis() {
        return this.getAxis(INDEPENDENT_AXIS);
    }

    public boolean setDependentAxis(AxisInterface axis) {
        return this.setAxis(DEPENDENT_AXIS, axis) != null;
    }

    public AxisInterface getDependentAxis() {
        return this.getAxis(DEPENDENT_AXIS);
    }

    protected void doNotUseDataSourceValues() {
        this.dependentAxisMappers.clear();
        this.independentAxisMappers.clear();
    }

    @Override
    public TransformStrategyInterface setTransformStrategy(Object id, TransformStrategyInterface xStrategy) {
        super.setTransformStrategy(id, xStrategy);
        if (id == INDEPENDENT_AXIS) {
            if (this.independentAxisTransformStrategy instanceof StateSource) {
                this.independentAxisTransformStrategy.removeStateListener(this.axisTransformStrategyStateListener);
            }
            this.independentAxisTransformStrategy = xStrategy;
            this.updateTransformStrategyOnIndependentAxisMappers();
            if (this.independentAxisTransformStrategy instanceof StateSource) {
                this.independentAxisTransformStrategy.addStateListener(this.axisTransformStrategyStateListener);
            }
        } else if (id == DEPENDENT_AXIS) {
            if (this.dependentAxisTransformStrategy instanceof StateSource) {
                this.dependentAxisTransformStrategy.removeStateListener(this.axisTransformStrategyStateListener);
            }
            this.dependentAxisTransformStrategy = xStrategy;
            this.updateTransformStrategyOnDependentAxisMappers();
            if (this.dependentAxisTransformStrategy instanceof StateSource) {
                this.dependentAxisTransformStrategy.addStateListener(this.axisTransformStrategyStateListener);
            }
        }
        return xStrategy;
    }

    protected void setDependentAxisMapper(Object id, DoubleStrategyMapper mapper) {
        if (id != null && mapper != null) {
            this.dependentAxisMappers.put(id, mapper);
            TwoAxisOverlay.setMapperTransformStrategy(mapper, this.dependentAxisTransformStrategy);
        }
    }

    protected DoubleStrategyMapper getDependentAxisMapper(Object id) {
        return id != null ? (DoubleStrategyMapper)this.dependentAxisMappers.get(id) : null;
    }

    protected void updateTransformStrategyOnDependentAxisMappers() {
        Enumeration keys = this.dependentAxisMappers.keys();
        while (keys.hasMoreElements()) {
            TwoAxisOverlay.setMapperTransformStrategy(this.getDependentAxisMapper(keys.nextElement()), this.dependentAxisTransformStrategy);
        }
    }

    protected void setIndependentAxisMapper(Object id, DoubleStrategyMapper mapper) {
        if (id != null && mapper != null) {
            this.independentAxisMappers.put(id, mapper);
            TwoAxisOverlay.setMapperTransformStrategy(mapper, this.independentAxisTransformStrategy);
        }
    }

    protected DoubleStrategyMapper getIndependentAxisMapper(Object id) {
        return id != null ? (DoubleStrategyMapper)this.independentAxisMappers.get(id) : null;
    }

    protected void updateTransformStrategyOnIndependentAxisMappers() {
        Enumeration keys = this.independentAxisMappers.keys();
        while (keys.hasMoreElements()) {
            TwoAxisOverlay.setMapperTransformStrategy(this.getIndependentAxisMapper(keys.nextElement()), this.independentAxisTransformStrategy);
        }
    }

    private class AxisTransformStrategyStateListener
    implements StateListener {
        private AxisTransformStrategyStateListener() {
        }

        @Override
        public void stateUpdate(StateEvent e) {
            TwoAxisOverlay.this.invalidateGraphics();
        }
    }
}

