/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.graphics.chart.util.ctk.ColorLegend;
import com.sas.graphics.chart.util.ctk.DataSourceInterface;
import com.sas.graphics.chart.util.ctk.MultipleDataComponent;
import com.sas.graphics.chart.util.ctk.OverlayInterface;
import com.sas.graphics.chart.util.ctk.PipedProbeInterface;
import com.sas.graphics.chart.util.ctk.VisualizationGraphicsInterface;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AMap;
import com.sas.graphics.util.vtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.vtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.vtk.DiscreteRangeToColorMapper;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericIndexMap;
import com.sas.graphics.util.vtk.NumericIndirectIndex;
import com.sas.graphics.util.vtk.NumericMissingValueReplacement;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericPipedFormat;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.NumericVector;
import com.sas.graphics.util.vtk.StringPipedFormat;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.Variable;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;

public class MapComponent
extends MultipleDataComponent {
    public static final Object MAP_AREA = new Integer(1);
    public static final Object MAP_AREA_RESPONSE = new Integer(2);
    public static final int CONTINUOUS_CATEGORIZATION = 0;
    public static final int DISCRETE_CATEGORIZATION = 1;
    public static final Color DEFAULT_MAP_AREA_OUTLINE_COLOR = Color.black;
    public static final Color DEFAULT_MISSING_RESPONSE_AREA_COLOR = Color.lightGray;
    public static final Color DEFAULT_POSITIVE_COLOR = Color.green;
    public static final Color DEFAULT_NEGATIVE_COLOR = Color.red;
    protected Vector classifierIDs;
    protected NumericVariable segmentVariable;
    protected NumericVariable xVariable;
    protected NumericVariable yVariable;
    protected Variable colorVariable;
    private ContinuousRangeToNumericMapper xLens;
    private ContinuousRangeToNumericMapper yLens;
    private NumericProperty xIn;
    private NumericProperty yIn;
    private NumericPipe xOut;
    private NumericPipe yOut;
    private AMap mapElement;
    private NumericIndexMap indexMap;
    private NumericIndirectIndex numericIndirectIndex;
    private NumericMissingValueReplacement nmvr;
    private int colorResponseCategorizationType;
    private ContinuousRangeToColorMapper continuousColorMapper;
    private DiscreteRangeToColorMapper discreteColorMapper;
    private NumericPipedFormat numericFormatterForLegendLabels;
    private StringPipedFormat stringFormatterForLegendLabels;
    private ColorLegend colorLegend;
    private Color positiveColor;
    private Color negativeColor;
    private Color mapAreaOutlineColor;
    private boolean mapAreaOutlineEnabled;
    private Color missingResponseAreaColor;
    private double numericColorRange;
    private MapAreaContentsChangedListener mapAreaContentsChangedListener;
    private MapAreaResponseContentsChangedListener mapAreaResponseContentsChangedListener;
    private Color[] defaultColorScheme = new Color[]{Color.red, Color.green, Color.blue, Color.magenta, Color.cyan, Color.orange, Color.pink, Color.yellow, Color.white};

    protected MapComponent() {
    }

    public static Object newInstance() {
        MapComponent o = new MapComponent();
        o.init();
        return o;
    }

    public static final MapComponent newMapComponent() {
        return (MapComponent)MapComponent.newInstance();
    }

    @Override
    protected void init() {
        super.init();
        this.classifierIDs = new Vector();
        this.indexMap = new NumericIndexMap();
        this.numericIndirectIndex = new NumericIndirectIndex();
        this.nmvr = new NumericMissingValueReplacement();
        this.colorResponseCategorizationType = 0;
        this.continuousColorMapper = new ContinuousRangeToColorMapper();
        this.discreteColorMapper = new DiscreteRangeToColorMapper();
        this.numericFormatterForLegendLabels = new NumericPipedFormat();
        this.stringFormatterForLegendLabels = new StringPipedFormat();
        this.xLens = new ContinuousRangeToNumericMapper();
        this.yLens = new ContinuousRangeToNumericMapper();
        this.xIn = this.xLens.input;
        this.yIn = this.yLens.input;
        this.xOut = this.xLens;
        this.yOut = this.yLens;
        this.defaultProbe.setBackgroundColor(Color.lightGray);
        this.defaultProbe.setTextBuffer(0);
        Font pf = this.defaultProbe.getFont();
        this.defaultProbe.setFont(FontManager.getFont((String)pf.getName(), (int)1, (int)10));
        this.positiveColor = DEFAULT_POSITIVE_COLOR;
        this.negativeColor = DEFAULT_NEGATIVE_COLOR;
        this.missingResponseAreaColor = DEFAULT_MISSING_RESPONSE_AREA_COLOR;
        this.mapAreaOutlineColor = DEFAULT_MAP_AREA_OUTLINE_COLOR;
        this.mapAreaOutlineEnabled = true;
        this.colorLegend = ColorLegend.newColorLegend();
        this.addLegend(this.colorLegend);
        this.addLegend(OverlayInterface.VariableRoles.COLOR, this.colorLegend);
        this.mapAreaContentsChangedListener = new MapAreaContentsChangedListener();
        this.mapAreaResponseContentsChangedListener = new MapAreaResponseContentsChangedListener();
    }

    protected void disconnectMapAreaNetwork() {
        this.xIn.disconnect();
        this.yIn.disconnect();
        if (this.mapElement != null) {
            this.mapElement.region.disconnect();
            this.mapElement.segment.disconnect();
            this.mapElement.x.disconnect();
            this.mapElement.y.disconnect();
            this.mapElement.extrudeThickness.disconnect();
            this.mapElement.extrudeOn.disconnect();
            this.mapElement.edgeColor.disconnect();
            this.mapElement.edgeOn.disconnect();
            this.composite.removeElement(this.mapElement);
        }
        this.disconnectMapAreaResponseNetwork();
        if (this.networkRoot != null) {
            this.networkRoot.build();
        }
    }

    protected void connectMapAreaNetwork() {
        this.disconnectMapAreaNetwork();
        if (this.mapElement != null && this.xVariable != null && this.yVariable != null) {
            DataSourceInterface mapAreaData = this.getDataSource(MAP_AREA);
            this.mapElement.region.connectFrom(mapAreaData.getCategoryPipe());
            if (this.segmentVariable == null) {
                this.mapElement.segment.disconnect();
            } else {
                this.mapElement.segment.connectFrom(this.segmentVariable.value);
            }
            this.xIn.connectFrom(this.xVariable.value);
            this.yIn.connectFrom(this.yVariable.value);
            this.mapElement.x.connectFrom(this.xOut);
            this.mapElement.y.connectFrom(this.yOut);
            this.mapElement.edgeColor.setValue(this.mapAreaOutlineColor);
            this.mapElement.edgeOn.setValue(this.mapAreaOutlineEnabled);
            this.composite.addElement(this.mapElement);
        }
    }

    protected void disconnectMapAreaResponseNetwork() {
        this.indexMap.key.disconnect();
        this.indexMap.sourceKey.disconnect();
        this.numericIndirectIndex.index.disconnect();
        this.numericIndirectIndex.input.disconnect();
        this.nmvr.input.disconnect();
        this.continuousColorMapper.input.disconnect();
        this.discreteColorMapper.input.disconnect();
        if (this.mapElement != null) {
            this.mapElement.color.disconnect();
        }
        this.disconnectLegend();
    }

    protected void connectMapAreaResponseNetwork() {
        this.disconnectMapAreaResponseNetwork();
        if (this.mapElement != null) {
            if (this.colorVariable != null) {
                if (this.colorLegend != null) {
                    this.colorVariable.setUniqueValueSort((Integer)this.colorLegend.getSortType());
                    this.colorLegend.setTitle(this.colorVariable.getName());
                }
                DataSourceInterface mapAreaResponseData = this.getDataSource(MAP_AREA_RESPONSE);
                NumericVector mapFaceIDVector = (NumericVector)this.mapElement.getIdVector();
                if (mapFaceIDVector != null) {
                    this.indexMap.key.connectFrom(mapFaceIDVector);
                    this.indexMap.sourceKey.connectFrom(mapAreaResponseData.getCategoryPipe());
                    if (this.colorResponseCategorizationType == 0 && this.colorVariable instanceof NumericVariable) {
                        this.numericIndirectIndex.index.connectFrom(this.indexMap);
                        this.numericIndirectIndex.input.connectFrom(((NumericVariable)this.colorVariable).value);
                        this.nmvr.setReplacementValue(Double.MAX_VALUE);
                        this.nmvr.input.connectFrom(this.numericIndirectIndex);
                        this.continuousColorMapper.input.connectFrom(this.nmvr);
                        this.mapElement.color.connectFrom(this.continuousColorMapper);
                        this.setColorMapperRange(((NumericVariable)this.colorVariable).getMin(), ((NumericVariable)this.colorVariable).getMax());
                        this.colorLegend.setLabels(this.continuousColorMapper.label);
                        this.colorLegend.setValues(this.continuousColorMapper.uniqueValue);
                        this.colorLegend.setContinuous(true);
                    } else if (this.colorVariable instanceof NumericVariable) {
                        NumericVariable numericColorVariable = (NumericVariable)this.colorVariable;
                        this.numericIndirectIndex.index.connectFrom(this.indexMap);
                        this.numericIndirectIndex.input.connectFrom(numericColorVariable.category);
                        this.nmvr.input.connectFrom(this.numericIndirectIndex);
                        this.nmvr.setReplacementValue(Double.MAX_VALUE);
                        this.discreteColorMapper.input.connectFrom(this.nmvr);
                        this.mapElement.color.connectFrom(this.discreteColorMapper);
                        int uvCount = numericColorVariable.getUniqueValueCount();
                        double[] categoryValues = new double[uvCount];
                        Color[] colorValues = new Color[uvCount];
                        for (int ii = 0; ii < uvCount; ++ii) {
                            categoryValues[ii] = ii;
                            colorValues[ii] = this.getDiscreteColor(ii);
                        }
                        this.discreteColorMapper.setRangeValue(categoryValues);
                        this.discreteColorMapper.setColorValue(colorValues);
                        this.discreteColorMapper.setOutOfRangeColor(this.missingResponseAreaColor);
                        this.numericFormatterForLegendLabels.input.connectFrom(numericColorVariable.uniqueValue);
                        this.colorLegend.setLabels(this.numericFormatterForLegendLabels);
                        this.colorLegend.setValues(this.discreteColorMapper.uniqueValue);
                        this.colorLegend.setContinuous(false);
                    } else if (this.colorVariable instanceof StringVariable) {
                        StringVariable stringColorVariable = (StringVariable)this.colorVariable;
                        this.numericIndirectIndex.index.connectFrom(this.indexMap);
                        this.numericIndirectIndex.input.connectFrom(stringColorVariable.category);
                        this.nmvr.input.connectFrom(this.numericIndirectIndex);
                        this.nmvr.setReplacementValue(Double.MAX_VALUE);
                        this.discreteColorMapper.input.connectFrom(this.nmvr);
                        this.mapElement.color.connectFrom(this.discreteColorMapper);
                        int uvCount = stringColorVariable.getUniqueValueCount();
                        double[] categoryValues = new double[uvCount];
                        Color[] colorValues = new Color[uvCount];
                        for (int ii = 0; ii < uvCount; ++ii) {
                            categoryValues[ii] = ii;
                            colorValues[ii] = this.getDiscreteColor(ii);
                        }
                        this.discreteColorMapper.setRangeValue(categoryValues);
                        this.discreteColorMapper.setColorValue(colorValues);
                        this.discreteColorMapper.setOutOfRangeColor(this.missingResponseAreaColor);
                        this.stringFormatterForLegendLabels.input.connectFrom(stringColorVariable.uniqueValue);
                        this.colorLegend.setLabels(this.stringFormatterForLegendLabels);
                        this.colorLegend.setValues(this.discreteColorMapper.uniqueValue);
                        this.colorLegend.setContinuous(false);
                    } else {
                        this.mapElement.color.setValue(this.missingResponseAreaColor);
                        this.disconnectLegend();
                    }
                }
            } else {
                this.mapElement.color.setValue(this.missingResponseAreaColor);
            }
        }
    }

    private Color getDiscreteColor(int index) {
        Color c;
        block4: {
            int colorSchemeStratgy;
            Color[] colorScheme;
            block3: {
                colorScheme = this.colorLegend.getColorScheme();
                if (colorScheme == null) {
                    colorScheme = this.defaultColorScheme;
                }
                colorSchemeStratgy = this.colorLegend.getColorSchemeExceedStrategy();
                c = colorScheme[index % colorScheme.length];
                if (colorSchemeStratgy != 1) break block3;
                for (int ii = 0; ii < index / colorScheme.length; ++ii) {
                    c = c.darker();
                }
                break block4;
            }
            if (colorSchemeStratgy != 2) break block4;
            for (int ii = 0; ii < index / colorScheme.length; ++ii) {
                c = c.brighter();
            }
        }
        return c;
    }

    public boolean isValidData(DataSourceInterface data) {
        return true;
    }

    @Override
    public DataSourceInterface setDataSource(DataSourceInterface data) {
        return this.setDataSource(MAP_AREA, data);
    }

    public void setMapAreaDataSource(DataSourceInterface data) {
        this.setDataSource(MAP_AREA, data);
    }

    public void setMapAreaResponseDataSource(DataSourceInterface data) {
        this.setDataSource(MAP_AREA_RESPONSE, data);
    }

    protected void nullMapAreaVariables() {
        this.classifierIDs.removeAllElements();
        this.segmentVariable = null;
        this.xVariable = null;
        this.yVariable = null;
    }

    protected void acquireMapAreaDataVariables() {
        DataSourceInterface mapAreaData = this.getDataSource(MAP_AREA);
        if (mapAreaData != null) {
            this.nullMapAreaVariables();
            for (int ii = 401; ii < 433; ++ii) {
                Variable variable = mapAreaData.getVtkVariable(new Integer(ii));
                if (!(variable instanceof StringVariable) && !(variable instanceof NumericVariable)) continue;
                this.classifierIDs.addElement(new Integer(ii));
            }
            Variable _segmentVariable = mapAreaData.getVtkVariable(OverlayInterface.VariableRoles.SEGMENT);
            if (_segmentVariable instanceof NumericVariable) {
                this.segmentVariable = (NumericVariable)_segmentVariable;
            }
            Variable _xVariable = mapAreaData.getVtkVariable(OverlayInterface.VariableRoles.X);
            Variable _yVariable = mapAreaData.getVtkVariable(OverlayInterface.VariableRoles.Y);
            if (_xVariable instanceof NumericVariable && _yVariable instanceof NumericVariable) {
                this.xVariable = (NumericVariable)_xVariable;
                this.yVariable = (NumericVariable)_yVariable;
                this.scaleMap();
            }
        }
    }

    protected void nullMapAreaResponseVariables() {
        DataSourceInterface mapAreaResponseData = this.getDataSource(MAP_AREA_RESPONSE);
        if (mapAreaResponseData != null) {
            mapAreaResponseData.linkCategoryValues(null);
        }
        this.colorVariable = null;
        if (this.probe instanceof PipedProbeInterface) {
            ((PipedProbeInterface)this.probe).removeAll();
        }
    }

    protected void acquireMapAreaResponseVariables() {
        DataSourceInterface mapAreaData = this.getDataSource(MAP_AREA);
        DataSourceInterface mapAreaResponseData = this.getDataSource(MAP_AREA_RESPONSE);
        if (mapAreaResponseData != null && mapAreaData != null) {
            this.nullMapAreaResponseVariables();
            boolean validResponseData = true;
            Vector<Integer> responseAreaDataClassifierIDs = new Vector<Integer>();
            for (int ii = 401; ii < 433; ++ii) {
                Variable variable = mapAreaResponseData.getVtkVariable(new Integer(ii));
                if (!(variable instanceof StringVariable) && !(variable instanceof NumericVariable)) continue;
                responseAreaDataClassifierIDs.addElement(new Integer(ii));
            }
            int size = this.classifierIDs.size();
            validResponseData = size == responseAreaDataClassifierIDs.size();
            if (validResponseData) {
                for (int ii = 0; validResponseData && ii < size; ++ii) {
                    int aID;
                    int arID = (Integer)responseAreaDataClassifierIDs.elementAt(ii);
                    validResponseData = arID == (aID = ((Integer)this.classifierIDs.elementAt(ii)).intValue());
                }
            }
            if (validResponseData) {
                Variable _colorVariable = mapAreaResponseData.getVtkVariable(OverlayInterface.VariableRoles.COLOR);
                if (_colorVariable instanceof NumericVariable || _colorVariable instanceof StringVariable) {
                    this.colorVariable = _colorVariable;
                }
                boolean bl = validResponseData = this.colorVariable != null;
            }
            if (validResponseData) {
                mapAreaResponseData.linkCategoryValues(mapAreaData);
                int classifierCount = this.classifierIDs.size();
                for (int ii = 0; ii < classifierCount; ++ii) {
                    Variable variable = mapAreaResponseData.getVtkVariable(this.classifierIDs.elementAt(ii));
                    if (variable instanceof StringVariable) {
                        ((PipedProbeInterface)this.probe).addPipe(variable.getName(), ((StringVariable)variable).value);
                        continue;
                    }
                    if (!(variable instanceof NumericVariable)) continue;
                    ((PipedProbeInterface)this.probe).addPipe(variable.getName(), ((NumericVariable)variable).value);
                }
                if (this.colorVariable instanceof StringVariable) {
                    ((PipedProbeInterface)this.probe).addPipe(this.colorVariable.getName(), ((StringVariable)this.colorVariable).value);
                } else if (this.colorVariable instanceof NumericVariable) {
                    ((PipedProbeInterface)this.probe).addPipe(this.colorVariable.getName(), ((NumericVariable)this.colorVariable).value);
                }
            }
        }
    }

    @Override
    protected boolean attachData(Object key, DataSourceInterface data) {
        boolean b = super.attachData(key, data);
        if (key == MAP_AREA) {
            this.acquireMapAreaDataVariables();
            this.acquireMapAreaResponseVariables();
            this.connectMapAreaNetwork();
            this.connectMapAreaResponseNetwork();
            if (data instanceof ContentsChangedSource) {
                ((ContentsChangedSource)data).addContentsChangedListener((ContentsChangedListener)this.mapAreaContentsChangedListener);
            }
            this.rerender();
        } else if (key == MAP_AREA_RESPONSE) {
            this.acquireMapAreaResponseVariables();
            this.connectMapAreaResponseNetwork();
            if (data instanceof ContentsChangedSource) {
                ((ContentsChangedSource)data).addContentsChangedListener((ContentsChangedListener)this.mapAreaResponseContentsChangedListener);
            }
            this.rerender();
        }
        return b;
    }

    @Override
    public void detachData(Object key) {
        if (key == MAP_AREA) {
            DataSourceInterface data = this.getDataSource(key);
            if (data instanceof ContentsChangedSource) {
                ((ContentsChangedSource)data).removeContentsChangedListener((ContentsChangedListener)this.mapAreaContentsChangedListener);
            }
            this.disconnectMapAreaNetwork();
            this.nullMapAreaVariables();
        } else if (key == MAP_AREA_RESPONSE) {
            DataSourceInterface data = this.getDataSource(key);
            if (data instanceof ContentsChangedSource) {
                ((ContentsChangedSource)data).removeContentsChangedListener((ContentsChangedListener)this.mapAreaResponseContentsChangedListener);
            }
            this.disconnectMapAreaResponseNetwork();
            this.nullMapAreaResponseVariables();
        }
        super.detachData(key);
        if (key == MAP_AREA || key == MAP_AREA_RESPONSE) {
            this.rerender();
        }
    }

    @Override
    protected void detachVisualizationGraphics() {
        super.detachVisualizationGraphics();
        this.disconnectMapAreaNetwork();
    }

    @Override
    protected void attachVisualizationGraphics(VisualizationGraphicsInterface vg) {
        super.attachVisualizationGraphics(vg);
        if (this.visualizationGraphics != null) {
            this.mapElement = this.visualizationGraphics.newMap();
            this.connectMapAreaNetwork();
            this.connectMapAreaResponseNetwork();
            this.rerender();
        }
    }

    @Override
    public String toString() {
        return "MapComponent :" + super.toString();
    }

    @Override
    public Vec3d setExtent(Vec3d _extent) {
        Vec3d p = super.setExtent(_extent);
        this.scaleMap();
        return p;
    }

    protected void scaleMap() {
        if (this.extent != null && this.xVariable != null && this.yVariable != null) {
            double adjustX = this.extent.x < 0.0 ? 1.0 : -1.0;
            double adjustY = this.extent.y < 0.0 ? 1.0 : -1.0;
            double extentX = this.extent.x + adjustX * 2.0;
            double extentY = this.extent.y + adjustY * 2.0;
            double originX = this.origin.x - adjustX;
            double originY = this.origin.y - adjustY;
            double xMin = this.xVariable.getMin();
            double xMax = this.xVariable.getMax();
            double yMin = this.yVariable.getMin();
            double yMax = this.yVariable.getMax();
            double xSpan = Math.abs(xMax - xMin);
            double ySpan = Math.abs(yMax - yMin);
            double factor = Math.min(Math.abs(extentX / xSpan), Math.abs(extentY / ySpan));
            double xFactor = extentX < 0.0 ? -factor : factor;
            double yFactor = extentY < 0.0 ? -factor : factor;
            double xTranslation = (extentX - xFactor * xSpan) / 2.0;
            double yTranslation = (extentY - yFactor * ySpan) / 2.0;
            this.xLens.setInputMin(xMin);
            this.xLens.setInputMax(xMax);
            this.xLens.setOutputMin(originX + xTranslation);
            this.xLens.setOutputMax(xFactor * xSpan + originX + xTranslation);
            this.yLens.setInputMin(yMin);
            this.yLens.setInputMax(yMax);
            this.yLens.setOutputMin(-originY - yTranslation);
            this.yLens.setOutputMax(-yFactor * ySpan - originY - yTranslation);
        }
    }

    public void setColorVariableCategorization(int catType) {
        switch (catType) {
            default: {
                return;
            }
            case 0: 
            case 1: 
        }
        if (this.colorResponseCategorizationType != catType) {
            this.colorResponseCategorizationType = catType;
            this.connectMapAreaResponseNetwork();
            this.rerender();
        }
    }

    public void hackjsh() {
        this.connectMapAreaResponseNetwork();
        this.rerender();
    }

    public void setMapAreaOutlineColor(Color color) {
        if (color == null) {
            color = DEFAULT_MAP_AREA_OUTLINE_COLOR;
        }
        if (!this.mapAreaOutlineColor.equals(color)) {
            this.mapAreaOutlineColor = color;
            if (this.mapElement != null) {
                this.mapElement.edgeColor.setValue(this.mapAreaOutlineColor);
                this.rerender();
            }
        }
    }

    public void setMapAreaOutlineEnabled(boolean b) {
        if (this.mapAreaOutlineEnabled != b) {
            this.mapAreaOutlineEnabled = b;
            if (this.mapElement != null) {
                this.mapElement.edgeOn.setValue(this.mapAreaOutlineEnabled);
                this.rerender();
            }
        }
    }

    private void setColorMapperRange(double min, double max) {
        Color outOfBoundsColor;
        Color firstColor = Color.black;
        Color lastColor = Color.green;
        Color[] colorScheme = this.colorLegend.getColorScheme();
        if (colorScheme != null) {
            firstColor = this.getDiscreteColor(0);
            lastColor = this.getDiscreteColor(1);
        }
        if ((outOfBoundsColor = this.colorLegend.getOutOfBoundsColor()) == null) {
            outOfBoundsColor = Color.gray;
        }
        this.continuousColorMapper.setColorSpectrumValues(new double[]{min, max});
        this.continuousColorMapper.setColorSpectrumColors(new Color[]{firstColor, lastColor});
        this.continuousColorMapper.setOutOfRangeColor(outOfBoundsColor);
    }

    protected void disconnectLegend() {
        this.colorLegend.setLabels(null);
        this.colorLegend.setValues(null);
        this.colorLegend.setContinuous(false);
        this.colorLegend.setTitle(null);
    }

    @Override
    public int getSelectionIndex() {
        if (this.probe instanceof PipedProbeInterface && ((PipedProbeInterface)this.probe).getProbeEntryCount() < 1) {
            return -1;
        }
        if (this.selectInfo == null) {
            return -1;
        }
        try {
            return (int)this.indexMap.getValue(this.selectInfo.getValueIndex());
        }
        catch (MissingValueException e) {
            return -1;
        }
    }

    private class MapAreaContentsChangedListener
    implements ContentsChangedListener {
        private MapAreaContentsChangedListener() {
        }

        public void contentsChanged(ContentsChangedEvent event) {
            MapComponent.this.disconnectMapAreaNetwork();
            MapComponent.this.nullMapAreaVariables();
            MapComponent.this.disconnectMapAreaResponseNetwork();
            MapComponent.this.nullMapAreaResponseVariables();
            MapComponent.this.acquireMapAreaDataVariables();
            MapComponent.this.acquireMapAreaResponseVariables();
            MapComponent.this.connectMapAreaNetwork();
            MapComponent.this.connectMapAreaResponseNetwork();
            MapComponent.this.rerender();
        }
    }

    private class MapAreaResponseContentsChangedListener
    implements ContentsChangedListener {
        private MapAreaResponseContentsChangedListener() {
        }

        public void contentsChanged(ContentsChangedEvent event) {
            MapComponent.this.disconnectMapAreaResponseNetwork();
            MapComponent.this.nullMapAreaResponseVariables();
            MapComponent.this.acquireMapAreaResponseVariables();
            MapComponent.this.connectMapAreaResponseNetwork();
            MapComponent.this.rerender();
        }
    }
}

