/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.PipedProbeInterface;
import com.sas.graphics.chart.util.ctk.vtk.Point2;
import com.sas.graphics.util.vtk.BooleanPipe;
import com.sas.graphics.util.vtk.ColorPipe;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.Probe;
import com.sas.graphics.util.vtk.StringPipe;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class JustifiedPipedProbe
extends Probe
implements PipedProbeInterface {
    protected String connectionString;
    protected String leftPad;
    protected String rightPad;
    protected Insets insets;
    protected Integer textBuffer;
    protected Integer orientation;
    protected Integer displacement;
    protected Integer xDisplacement;
    protected Integer yDisplacement;
    protected static String DEFAULT_CONNECTION_STRING = " = ";
    protected static String DEFAULT_LEFT_PAD = " ";
    protected static String DEFAULT_RIGHT_PAD = " ";
    protected static Insets DEFAULT_INSETS = new Insets(4, 4, 4, 4);
    protected static Integer DEFAULT_TEXT_BUFFER = new Integer(2);
    protected Point2[] highlightPoints;
    protected Color highlightColor;

    @Override
    public void setOrientation(int orientation) {
        this.orientation = null;
        switch (orientation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.orientation = new Integer(orientation);
            }
        }
    }

    @Override
    public int getOrientation() {
        return this.orientation == null ? 0 : this.orientation;
    }

    @Override
    public void setDisplacement(int displacement) {
        this.displacement = displacement >= 0 ? new Integer(displacement) : null;
    }

    @Override
    public int getDisplacement() {
        return this.displacement == null ? 50 : this.displacement;
    }

    @Override
    public void setXDisplacement(int displacement) {
        this.xDisplacement = displacement >= 0 ? new Integer(displacement) : null;
    }

    @Override
    public int getXDisplacement() {
        return this.xDisplacement == null ? this.getDisplacement() : this.xDisplacement.intValue();
    }

    @Override
    public void setYDisplacement(int displacement) {
        this.yDisplacement = displacement >= 0 ? new Integer(displacement) : null;
    }

    @Override
    public int getYDisplacement() {
        return this.yDisplacement == null ? this.getDisplacement() : this.yDisplacement.intValue();
    }

    @Override
    public void setTitle(String t) {
        this.title.setValue(t);
    }

    @Override
    public String getTitle() {
        try {
            return this.title.getValue(0);
        }
        catch (MissingValueException e) {
            return null;
        }
    }

    @Override
    public void setConnectionString(String s) {
        this.connectionString = s == null ? DEFAULT_CONNECTION_STRING : s;
    }

    @Override
    public String getconnectionString() {
        return this.connectionString == null ? DEFAULT_CONNECTION_STRING : this.connectionString;
    }

    @Override
    public void setLeftPad(String s) {
        this.leftPad = s == null ? DEFAULT_LEFT_PAD : s;
    }

    @Override
    public String getLeftPad() {
        return this.leftPad == null ? DEFAULT_LEFT_PAD : this.leftPad;
    }

    @Override
    public void setRightPad(String s) {
        this.rightPad = s == null ? DEFAULT_RIGHT_PAD : s;
    }

    @Override
    public String getRightPad() {
        return this.rightPad == null ? DEFAULT_RIGHT_PAD : this.rightPad;
    }

    @Override
    public void setInsets(Insets i) {
        this.insets = i == null ? DEFAULT_INSETS : i;
    }

    @Override
    public Insets getInsets() {
        return this.insets == null ? DEFAULT_INSETS : this.insets;
    }

    @Override
    public void setTextBuffer(int i) {
        this.textBuffer = i > 0 ? new Integer(i) : DEFAULT_TEXT_BUFFER;
    }

    @Override
    public int getTextBuffer() {
        return this.textBuffer == null ? DEFAULT_TEXT_BUFFER.intValue() : this.textBuffer.intValue();
    }

    @Override
    public String[] getLabels() {
        int size = this.getProbeEntryCount();
        String[] labels = new String[size];
        if (this.leftPad == null) {
            this.leftPad = DEFAULT_LEFT_PAD;
        }
        for (int ii = 0; ii < size; ++ii) {
            labels[ii] = this.leftPad;
            String label = this.getProbeEntry(ii).getName();
            if (label == null) continue;
            int n = ii;
            labels[n] = labels[n] + label;
        }
        return labels;
    }

    @Override
    public String[] getValues(int valueIndex) {
        int size = this.getProbeEntryCount();
        String[] values = new String[size];
        if (this.connectionString == null) {
            this.connectionString = DEFAULT_CONNECTION_STRING;
        }
        if (this.rightPad == null) {
            this.rightPad = DEFAULT_RIGHT_PAD;
        }
        for (int ii = 0; ii < size; ++ii) {
            String s;
            block10: {
                Probe.ProbeEntry probeEntry = this.getProbeEntry(ii);
                s = this.getProbeEntry(ii).getName() == null ? "" : this.connectionString;
                Pipe p = probeEntry.getPipe();
                Formatter format = p.getFormatter();
                try {
                    if (p instanceof StringPipe) {
                        StringPipe sp = (StringPipe)p;
                        s = s + format.format(sp.getValue(valueIndex));
                        break block10;
                    }
                    if (p instanceof NumericPipe) {
                        NumericPipe np = (NumericPipe)p;
                        s = s + format.format(new Double(np.getValue(valueIndex)));
                        break block10;
                    }
                    if (p instanceof ColorPipe) {
                        ColorPipe cp = (ColorPipe)p;
                        Color color = cp.getValue(valueIndex);
                        s = s + color.toString();
                        break block10;
                    }
                    if (p instanceof BooleanPipe) {
                        BooleanPipe bp = (BooleanPipe)p;
                        Boolean b = new Boolean(bp.getValue(valueIndex));
                        s = s + b.toString();
                        break block10;
                    }
                    if (p instanceof IntegerPipe) {
                        IntegerPipe ip = (IntegerPipe)p;
                        int iv = ip.getValue(valueIndex);
                        s = s + Integer.toString(iv);
                        break block10;
                    }
                    throw new RuntimeException("ProbeEntry has a bad pipe: " + p);
                }
                catch (MissingValueException mve) {
                    s = s + "missing";
                }
            }
            values[ii] = s + this.rightPad;
        }
        return values;
    }

    @Override
    public void setHighlightOutline(Point2[] pt) {
        this.highlightPoints = pt;
    }

    @Override
    public Point2[] getHighlightOutline() {
        return this.highlightPoints;
    }

    @Override
    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    @Override
    public Color getHighlightColor() {
        return this.highlightColor == null ? Color.yellow : this.highlightColor;
    }

    @Override
    public void draw(Graphics gc, int x, int y, int valueIndex) {
        int width;
        String[] labels = this.getLabels();
        String[] values = this.getValues(valueIndex);
        int size = Math.min(labels.length, values.length);
        int maxLabelWidth = 0;
        int maxValueWidth = 0;
        if (this.insets == null) {
            this.insets = DEFAULT_INSETS;
        }
        Font font = this.getFont();
        Font boldFont = new Font(font.getName(), 1, font.getSize());
        FontMetrics fontMetrics = font == null ? gc.getFontMetrics() : gc.getFontMetrics(font);
        int textHeight = fontMetrics.getHeight();
        int ascent = fontMetrics.getAscent();
        int textBuff = this.getTextBuffer();
        int pos = y + this.insets.top + (textHeight + textBuff) * size - textBuff + this.insets.bottom;
        for (int ii = 0; ii < size; ++ii) {
            width = fontMetrics.stringWidth(labels[ii]);
            if (width > maxLabelWidth) {
                maxLabelWidth = width;
            }
            if ((width = fontMetrics.stringWidth(values[ii])) <= maxValueWidth) continue;
            maxValueWidth = width;
        }
        int llX = x;
        int llY = y;
        int xAdjust = this.getXDisplacement();
        int yAdjust = this.getYDisplacement();
        width = this.insets.left + maxLabelWidth + maxValueWidth + this.insets.right;
        int height = pos - y;
        Rectangle viewport = this.getBounds();
        int orientation = this.getOrientation();
        int in = 1;
        switch (orientation) {
            case 2: 
            case 4: 
            case 6: {
                llX = x + xAdjust;
                if (viewport == null || viewport.x + viewport.width >= llX + width + in || (llX = x - width - xAdjust) >= viewport.x + in) break;
                llX = viewport.x + in;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                llX = x - width - xAdjust;
                if (viewport == null || llX >= viewport.x + in || viewport.x + viewport.width >= (llX = x + xAdjust) + width + in) break;
                llX = viewport.x + in;
                break;
            }
            case 0: 
            case 1: {
                llX = x - width / 2;
                if (viewport == null) break;
                if (viewport.x + viewport.width < llX + width + in) {
                    llX = viewport.x + viewport.width - width - in;
                }
                if (llX >= viewport.x + in) break;
                llX = viewport.x + in;
            }
        }
        switch (orientation) {
            case 0: 
            case 4: 
            case 5: {
                llY = y - height - yAdjust;
                if (viewport == null || viewport.y + in <= llY || viewport.y + viewport.height - 4 >= (llY = y + yAdjust) + height) break;
                llY = viewport.y + in;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                llY = y + yAdjust;
                if (viewport == null || viewport.y + viewport.height - 4 >= llY + height || viewport.y + in <= (llY = y - height - yAdjust)) break;
                llY = viewport.y + viewport.height - 4 - height;
                break;
            }
            case 2: 
            case 3: {
                llY = y - height / 2;
                if (viewport == null) break;
                if (viewport.y + viewport.height - 4 < llY + height) {
                    llY = viewport.y + viewport.height - 4 - height;
                }
                if (viewport.y + in <= llY) break;
                llY = viewport.y + in;
            }
        }
        if (this.highlightPoints != null && this.highlightPoints.length > 1) {
            gc.setColor(this.getHighlightColor());
            for (int ii = 1; ii < this.highlightPoints.length; ++ii) {
                gc.drawLine((int)this.highlightPoints[ii - 1].x, (int)this.highlightPoints[ii - 1].y, (int)this.highlightPoints[ii].x, (int)this.highlightPoints[ii].y);
            }
        } else {
            gc.setColor(this.getBackgroundColor());
            gc.drawLine(x, y, llX + width / 2, llY + height / 2);
            gc.setColor(this.getForegroundColor());
            gc.drawLine(x + 1, y + 1, llX + width / 2 + 1, llY + height / 2 + 1);
        }
        gc.setColor(this.getBackgroundColor());
        gc.fillRect(llX, llY, width, height);
        gc.setColor(this.getForegroundColor());
        gc.drawRect(llX, llY, width, height);
        pos = llY + ascent + this.insets.top;
        Font oldFont = gc.getFont();
        gc.setFont(font);
        for (int ii = 0; ii < size; ++ii) {
            gc.drawString(labels[ii], llX + this.insets.left, pos);
            gc.drawString(values[ii], llX + this.insets.left + maxLabelWidth, pos);
            pos += textHeight + textBuff;
        }
        gc.setFont(oldFont);
    }

    @Override
    public Rectangle getBounds() {
        return this.getViewport();
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.setViewport(bounds.x, bounds.y, bounds.width, bounds.height);
    }
}

