/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.SelectInfo;
import com.sas.graphics.chart.util.ctk.VTKVisualizationGraphicsInterface;
import com.sas.graphics.chart.util.ctk.VisualizationComponentInterface;
import com.sas.graphics.chart.util.ctk.VisualizationInfoInterface;
import com.sas.graphics.chart.util.ctk.vtk.Point2;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABox;
import com.sas.graphics.util.vtk.ACircle;
import com.sas.graphics.util.vtk.AComposite;
import com.sas.graphics.util.vtk.ACone;
import com.sas.graphics.util.vtk.ACylinder;
import com.sas.graphics.util.vtk.AGanttBox;
import com.sas.graphics.util.vtk.AGrid;
import com.sas.graphics.util.vtk.ALabel;
import com.sas.graphics.util.vtk.ALegend;
import com.sas.graphics.util.vtk.ALineConnector;
import com.sas.graphics.util.vtk.ALineSegment;
import com.sas.graphics.util.vtk.AMap;
import com.sas.graphics.util.vtk.ANetworkRoot;
import com.sas.graphics.util.vtk.ARectangle;
import com.sas.graphics.util.vtk.ASphere;
import com.sas.graphics.util.vtk.ASplineConnector;
import com.sas.graphics.util.vtk.ASwitch;
import com.sas.graphics.util.vtk.ATriangle;
import com.sas.graphics.util.vtk.ATriangleConnector;
import com.sas.graphics.util.vtk.ATukeyBox;
import com.sas.graphics.util.vtk.AWedge;
import com.sas.graphics.util.vtk.AWedge3D;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.SelectEntry;
import com.sas.graphics.util.vtk.jxd.Box;
import com.sas.graphics.util.vtk.jxd.Circle;
import com.sas.graphics.util.vtk.jxd.ComplexGanttBox;
import com.sas.graphics.util.vtk.jxd.Composite;
import com.sas.graphics.util.vtk.jxd.Cone;
import com.sas.graphics.util.vtk.jxd.Cylinder;
import com.sas.graphics.util.vtk.jxd.GanttBox;
import com.sas.graphics.util.vtk.jxd.Grid;
import com.sas.graphics.util.vtk.jxd.Legend;
import com.sas.graphics.util.vtk.jxd.LineConnector;
import com.sas.graphics.util.vtk.jxd.LineSegment;
import com.sas.graphics.util.vtk.jxd.Map;
import com.sas.graphics.util.vtk.jxd.NetworkRoot;
import com.sas.graphics.util.vtk.jxd.PolarAxis;
import com.sas.graphics.util.vtk.jxd.RasterLabel;
import com.sas.graphics.util.vtk.jxd.Rectangle;
import com.sas.graphics.util.vtk.jxd.RectangularAxis;
import com.sas.graphics.util.vtk.jxd.SelectResult;
import com.sas.graphics.util.vtk.jxd.Sphere;
import com.sas.graphics.util.vtk.jxd.SplineConnector;
import com.sas.graphics.util.vtk.jxd.Switch;
import com.sas.graphics.util.vtk.jxd.Triangle;
import com.sas.graphics.util.vtk.jxd.TriangleConnector;
import com.sas.graphics.util.vtk.jxd.TukeyBox;
import com.sas.graphics.util.vtk.jxd.Wedge;
import com.sas.graphics.util.vtk.jxd.Wedge3D;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class JXDVisualizationGraphics
implements VTKVisualizationGraphicsInterface {
    private Component awtComponent;
    protected Channel channel;
    protected Dimension cachedComponentSize;
    protected Vec3d cached3DExtent;
    protected double eyeDistance;
    protected int displayMode;
    protected Vector visualizationInfoSet;
    private boolean validState;
    protected boolean cullFaceEnabled;
    protected boolean lightingEnabled;
    protected boolean depthTestEnabled;
    protected Component javaComponent;
    protected VisualizationComponentInterface visualizationComponent;
    protected ANetworkRoot networkRoot;
    ActionListener displayUpdateActionListeners;
    float rotateX = 0.0f;
    float rotateY = 0.0f;
    float rotateZ = 0.0f;
    float eyeDist = 0.0f;
    float eyeX = 0.0f;
    float eyeY = 0.0f;
    float eyeZ = 0.0f;
    protected boolean mouseDown;
    VisualizationComponentInterface currentTarget;
    SelectInfo currentSelectInfo;

    private JXDVisualizationGraphics() {
    }

    public static Object newInstance(Component component) {
        JXDVisualizationGraphics o = new JXDVisualizationGraphics();
        o.init(component);
        return o;
    }

    public static final JXDVisualizationGraphics newJXDVisualizationGraphics(Component component) {
        return (JXDVisualizationGraphics)JXDVisualizationGraphics.newInstance(component);
    }

    protected void init(Component component) {
        this.validState = true;
        this.awtComponent = component;
        this.awtComponent.addComponentListener(new MyComponentListener());
        this.displayMode = 1;
        this.channel = new Channel(this.awtComponent);
        this.channel.glViewport(0, 0, 1, 1);
        this.channel.glOrtho(0.0, 1.0, 0.0, 1.0, -100.0, 100.0);
        this.channel.gluLookAt(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
        this.setCullFaceEnabled(true);
        this.setLightingEnabled(true);
        this.setDepthTestEnabled(true);
        this.channel.glLight(17, 3, new double[]{0.3, 0.7, 1.0, 0.0});
        this.channel.glLight(17, 0, new Color(1, 1, 1));
        this.channel.glLight(17, 1, new double[]{1.0, 1.0, 1.0, 0.0});
        this.channel.glLight(17, 2, new double[]{0.3, 0.3, 0.3, 0.0});
        this.cachedComponentSize = new Dimension(1, 1);
        this.eyeDistance = 0.0;
    }

    public void setState(boolean b) {
        this.validState = b;
    }

    public boolean setState() {
        return this.validState;
    }

    public void setCullFaceEnabled(boolean b) {
        this.cullFaceEnabled = b;
        this._conveyCullFace();
    }

    public boolean getCullFaceEnabled() {
        return this.cullFaceEnabled;
    }

    public void setLightingEnabled(boolean b) {
        this.lightingEnabled = b;
        this._conveyLighting();
    }

    public boolean getLightingEnabled() {
        return this.lightingEnabled;
    }

    public void setDepthTestEnabled(boolean b) {
        this.depthTestEnabled = b;
        this._conveyDepthTest();
    }

    private void _conveyDepthTest() {
        if (this.channel != null) {
            if (this.depthTestEnabled) {
                this.channel.glEnable(4);
            } else {
                this.channel.glDisable(4);
            }
        }
    }

    private void _conveyLighting() {
        if (this.channel != null) {
            if (this.lightingEnabled) {
                this.channel.glEnable(3);
            } else {
                this.channel.glDisable(3);
            }
        }
    }

    private void _conveyCullFace() {
        if (this.channel != null) {
            if (this.cullFaceEnabled) {
                this.channel.glEnable(1);
            } else {
                this.channel.glDisable(1);
            }
        }
    }

    public boolean getDepthTestEnabled() {
        return this.depthTestEnabled;
    }

    public void setJavaComponent(Component c) {
        this.javaComponent = c;
    }

    public void setvisualizationComponent(VisualizationComponentInterface c) {
        this.visualizationComponent = c;
    }

    public void setNetworkRoot(ANetworkRoot root) {
        this.networkRoot = root;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        Graphics g = this.awtComponent.getGraphics();
        if (g == null) {
            return null;
        }
        FontMetrics fm = g.getFontMetrics(font);
        g.dispose();
        return fm;
    }

    @Override
    public Color setBackgroundColor(Color backgroundColor) {
        this.channel.setBackgroundColor(backgroundColor);
        return backgroundColor;
    }

    @Override
    public Color getBackgroundColor() {
        return this.channel.getBackgroundColor();
    }

    @Override
    public void print(Graphics g) {
        if (this.networkRoot != null) {
            this.print(g, ((NetworkRoot)this.networkRoot).getRootListName());
        }
    }

    private void print(Graphics g, long listName) {
        int size;
        try {
            this.channel.glCallList(g, listName);
        }
        catch (Exception e) {
            return;
        }
        if (this.visualizationInfoSet != null && (size = this.visualizationInfoSet.size()) > 0) {
            for (int ii = 0; ii < size; ++ii) {
                VisualizationInfoInterface vi = (VisualizationInfoInterface)this.visualizationInfoSet.elementAt(ii);
                vi.setBounds(0, 0, this.awtComponent.getSize());
                vi.draw(g);
            }
        }
    }

    @Override
    public void refresh(Graphics g) {
        if (this.channel != null) {
            this.channel.glRefresh(g);
        }
    }

    @Override
    public void redraw() {
        if (this.networkRoot != null) {
            this.clearAndDraw(((NetworkRoot)this.networkRoot).getRootListName());
        }
    }

    private void redraw(Object name) {
        if (name instanceof Long) {
            this.clearAndDraw((Long)name);
        }
    }

    private void draw(Object name) {
        if (name instanceof Long) {
            this.draw((Long)name);
        }
    }

    private void clearAndDraw(long listName) {
        this.clear();
        this.draw(listName);
    }

    @Override
    public void clear() {
        this.channel.clearBGC();
    }

    private void draw(long listName) {
        if (this.validState) {
            this.drawOffScreen(listName);
            if (this.displayUpdateActionListeners != null) {
                this.displayUpdateActionListeners.actionPerformed(new ActionEvent(this, 1001, ""));
            }
        }
    }

    @Override
    public void drawOffScreen() {
        if (this.networkRoot != null) {
            this.drawOffScreen(((NetworkRoot)this.networkRoot).getRootListName());
        }
    }

    private synchronized void drawOffScreen(long listName) {
        int size;
        try {
            this.channel.setBackbuffer(1);
            this.channel.clearBGC();
            this.channel.glCallList(listName);
            this.channel.setBackbuffer(0);
            this.channel.copyBuffer(1);
        }
        catch (Exception e) {
            this.rerender();
            return;
        }
        if (this.visualizationInfoSet != null && (size = this.visualizationInfoSet.size()) > 0) {
            for (int ii = 0; ii < size; ++ii) {
                VisualizationInfoInterface vi = (VisualizationInfoInterface)this.visualizationInfoSet.elementAt(ii);
                vi.setBounds(0, 0, this.awtComponent.getSize());
                vi.draw(this.channel.getBackbufferGC());
            }
        }
    }

    @Override
    public void rerender() {
        if (this.javaComponent != null) {
            this.javaComponent.repaint();
        }
    }

    @Override
    public void render() {
        if (this.javaComponent != null) {
            this.javaComponent.paint(this.javaComponent.getGraphics());
        }
    }

    @Override
    public void addDisplayUpdateActionListener(ActionListener al) {
        this.displayUpdateActionListeners = AWTEventMulticaster.add(this.displayUpdateActionListeners, al);
    }

    @Override
    public void setDisplayMode(int mode) {
        this.displayMode = mode == 0 ? 0 : 1;
    }

    @Override
    public int getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public void validate() {
        if (this.displayMode == 1) {
            this.orthographic_resize();
        } else if (this.displayMode == 0) {
            this.perspective_resize();
        }
    }

    protected void orthographic_resize() {
        if (this.channel != null) {
            this._conveyDepthTest();
            this._conveyLighting();
            this._conveyCullFace();
            Dimension d = this.awtComponent.getSize();
            if (d.width != this.cachedComponentSize.width || d.height != this.cachedComponentSize.height) {
                this.cachedComponentSize = new Dimension(d.width, d.height);
                this.channel.glViewport(0, 0, d.width, d.height);
                this.channel.gluLookAt(0.0, 0.0, 0.0, this.eyeDistance, 0.0, 0.0, 0.0);
                Vec3d extent = this.calc3DExtentCenteredAboutOrigin();
                this.channel.glOrtho(-extent.x, extent.x, -extent.y, extent.y, extent.z, -extent.z);
            }
        }
    }

    protected void perspective_resize() {
        if (this.channel != null) {
            this._conveyDepthTest();
            this._conveyLighting();
            this._conveyCullFace();
            Dimension d = this.awtComponent.getSize();
            if (d.width != this.cachedComponentSize.width || d.height != this.cachedComponentSize.height) {
                double max;
                double min;
                this.cachedComponentSize = d;
                if (d.width < d.height) {
                    min = d.width;
                    max = d.height;
                } else {
                    max = d.width;
                    min = d.height;
                }
                double aspect = max / min;
                this.eyeDist = (float)max;
                this.channel.gluLookAt(this.eyeX, this.eyeY, this.eyeZ, this.eyeDist, this.rotateX, this.rotateY, this.rotateZ);
                Vec3d extent = this.calc3DExtentCenteredAboutOrigin();
                this.channel.glViewport(0, 0, d.width, d.height);
                this.channel.gluPerspective(45.0, aspect, 0.0, max * 2.0);
            }
        }
    }

    public void rotateX(float r) {
        this.rotate(r, 0.0f, 0.0f);
    }

    public void rotateY(float r) {
        this.rotate(0.0f, r, 0.0f);
    }

    public void rotateZ(float r) {
        this.rotate(0.0f, 0.0f, r);
    }

    public void rotate(float x, float y, float z) {
        this.rotateX += x;
        this.rotateY += y;
        this.rotateZ += z;
        this.channel.gluLookAt(this.eyeX, this.eyeY, this.eyeZ, this.eyeDist, this.rotateX, this.rotateY, this.rotateZ);
    }

    public void adjustEye(float x, float y, float z) {
        this.eyeX += x;
        this.eyeY += y;
        this.eyeZ += z;
        this.channel.gluLookAt(this.eyeX, this.eyeY, this.eyeZ, this.eyeDist, this.rotateX, this.rotateY, this.rotateZ);
    }

    public void adjustEyeDist(float d) {
        this.eyeDist += d;
        this.channel.gluLookAt(this.eyeX, this.eyeY, this.eyeZ, this.eyeDist, this.rotateX, this.rotateY, this.rotateZ);
    }

    protected Vec3d calc3DExtentCenteredAboutOrigin() {
        Dimension d = this.cachedComponentSize;
        double x = (double)d.width / 2.0;
        double y = (double)d.height / 2.0;
        double z = (double)(-(d.width > d.height ? d.width : d.height)) / 2.0;
        this.cached3DExtent = new Vec3d(x, y, z);
        return new Vec3d(x, y, z);
    }

    protected Vec3d get3DExtentCenteredAboutOrigin() {
        if (this.cached3DExtent == null) {
            return this.calc3DExtentCenteredAboutOrigin();
        }
        return new Vec3d(this.cached3DExtent.x, this.cached3DExtent.y, this.cached3DExtent.z);
    }

    @Override
    public Vec3d pixel2World(Point2 pixel) {
        return new Vec3d(this.pixel2WorldX(pixel.x), this.pixel2WorldY(pixel.y), 0.0);
    }

    @Override
    public Point2 world2Pixel(Vec3d world) {
        return this.project(world);
    }

    @Override
    public double pixel2WorldX(double pixel) {
        Vec3d myExtent = this.getExtent();
        return (double)Math.abs(this.cachedComponentSize.width) < 1.0E-6 ? 0.0 : pixel * myExtent.x / (double)this.cachedComponentSize.width;
    }

    @Override
    public double world2PixelX(double world) {
        Vec3d myExtent = this.getExtent();
        return Math.abs(myExtent.x) < 1.0E-6 ? 0.0 : world * (double)this.cachedComponentSize.width / myExtent.x;
    }

    @Override
    public double pixel2WorldY(double pixel) {
        Vec3d extent = this.getExtent();
        return (double)Math.abs(this.cachedComponentSize.height) < 1.0E-6 ? 0.0 : pixel * extent.y / (double)this.cachedComponentSize.height;
    }

    @Override
    public double world2PixelY(double world) {
        Vec3d extent = this.getExtent();
        return Math.abs(extent.y) < 1.0E-6 ? 0.0 : world * (double)this.cachedComponentSize.height / extent.y;
    }

    @Override
    public Vec3d unproject(Vec3d pointOnScreen) {
        if (this.channel == null) {
            return null;
        }
        double[] pos = new double[]{pointOnScreen.x, pointOnScreen.y, pointOnScreen.z};
        double[] wrl = new double[3];
        this.channel.gluUnProject(pos, wrl);
        return new Vec3d(wrl[0], wrl[1], wrl[2]);
    }

    public Point2 project(Vec3d world) {
        if (this.channel == null) {
            return null;
        }
        double[] wrl = new double[]{world.x, world.y, world.z};
        double[] pix = new double[3];
        this.channel.gluProject(wrl, pix);
        return new Point2(pix[0], pix[1]);
    }

    @Override
    public void drawVisualizationInfo(VisualizationInfoInterface vi) {
        if (this.channel != null) {
            this.channel.copyBuffer(1);
            if (vi != null) {
                vi.setBounds(0, 0, this.awtComponent.getSize());
                vi.draw(this.channel.getBackbufferGC());
            }
        }
    }

    @Override
    public void addVisualizationInfo(VisualizationInfoInterface vi) {
        if (vi != null) {
            if (this.visualizationInfoSet == null) {
                this.visualizationInfoSet = new Vector();
            }
            this.visualizationInfoSet.addElement(vi);
        }
    }

    @Override
    public void removeVisualizationInfo(VisualizationInfoInterface vi) {
        if (vi != null && this.visualizationInfoSet != null) {
            this.visualizationInfoSet.removeElement(vi);
        }
    }

    @Override
    public void removeAllVisualizationInfo() {
        if (this.visualizationInfoSet != null) {
            this.visualizationInfoSet.removeAllElements();
        }
    }

    @Override
    public Vec3d getExtent() {
        Vec3d extent = this.get3DExtentCenteredAboutOrigin();
        extent.x *= 2.0;
        extent.y *= 2.0;
        return extent;
    }

    @Override
    public Vec3d getOrigin() {
        Vec3d extent = this.get3DExtentCenteredAboutOrigin();
        extent.x *= -1.0;
        extent.y *= -1.0;
        extent.z = 0.0;
        return extent;
    }

    public Color getBackgroundColor(Color backgroundColor) {
        return this.channel.getBackgroundColor();
    }

    @Override
    public double getTextHeight(Font font) {
        FontMetrics fm = this.getFontMetrics(font);
        if (fm == null) {
            return -1.0;
        }
        return this.pixel2WorldY(fm.getHeight());
    }

    @Override
    public double getStringWidth(Font font, String string) {
        FontMetrics fm = this.getFontMetrics(font);
        if (fm == null) {
            return -1.0;
        }
        return this.pixel2WorldX(fm.stringWidth(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeHierarchyList(Object listID, Enumeration subListIDs) {
        long headID = 0L;
        try {
            headID = (Long)listID;
        }
        catch (ClassCastException e) {
            return;
        }
        this.channel.glNewList(headID);
        try {
            while (subListIDs.hasMoreElements()) {
                this.channel.glCallList((Long)subListIDs.nextElement());
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.channel.glEndList();
        }
    }

    @Override
    public ANetworkRoot newNetworkRoot() {
        return new NetworkRoot(this.channel);
    }

    @Override
    public AComposite newComposite() {
        return new Composite();
    }

    @Override
    public ABox newBox() {
        return new Box();
    }

    @Override
    public ACircle newCircle() {
        return new Circle();
    }

    @Override
    public ACone newCone() {
        return new Cone();
    }

    @Override
    public ACylinder newCylinder() {
        return new Cylinder();
    }

    @Override
    public AGanttBox newGanttBox() {
        return new GanttBox();
    }

    @Override
    public ComplexGanttBox newComplexGanttBox() {
        return new ComplexGanttBox();
    }

    @Override
    public AGrid newGrid() {
        return new Grid();
    }

    @Override
    public ALabel newLabel() {
        return new RasterLabel();
    }

    @Override
    public ALabel newLabel(String string) {
        ALabel label = this.newLabel();
        label.string.setValue(string);
        return label;
    }

    @Override
    public ALegend newLegend() {
        return new Legend();
    }

    @Override
    public ALineConnector newLineConnector() {
        return new LineConnector();
    }

    @Override
    public ALineSegment newLineSegment() {
        return new LineSegment();
    }

    @Override
    public PolarAxis newPolarAxis() {
        return new PolarAxis();
    }

    @Override
    public RectangularAxis newRectangularAxis() {
        return new RectangularAxis();
    }

    @Override
    public ARectangle newRectangle() {
        return new Rectangle();
    }

    @Override
    public ASphere newSphere() {
        return new Sphere();
    }

    @Override
    public ASplineConnector newSplineConnector() {
        return new SplineConnector();
    }

    @Override
    public ATriangle newTriangle() {
        return new Triangle();
    }

    @Override
    public ATukeyBox newTukeyBox() {
        return new TukeyBox();
    }

    @Override
    public ATriangleConnector newTriangleConnector() {
        return new TriangleConnector();
    }

    @Override
    public AWedge newWedge() {
        return new Wedge();
    }

    @Override
    public AWedge3D newWedge3D() {
        return new Wedge3D();
    }

    @Override
    public AMap newMap() {
        Map map = new Map();
        return map;
    }

    @Override
    public ASwitch newSwitch() {
        return new Switch();
    }

    private synchronized SelectInfo getSelectInfo(MouseEvent mouseEvent) {
        SelectResult selectResult;
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        if (this.networkRoot != null && (selectResult = ((NetworkRoot)this.networkRoot).selectClosest(x, y, 1, 1, false)) != null) {
            Vector path = selectResult.getPath();
            int size = path.size();
            for (int ii = size - 1; ii >= 0; --ii) {
                Object userData;
                Element element = ((SelectEntry)path.elementAt(ii)).getElement();
                if (element == null || !((userData = element.getUserData()) instanceof VisualizationComponentInterface)) continue;
                return (SelectInfo)SelectInfo.newInstance(selectResult, ii);
            }
        }
        return null;
    }

    @Override
    public synchronized void processEvent(AWTEvent event) {
        if (!this.validState) {
            return;
        }
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            if (this.currentTarget != null && this.mouseDown) {
                if (mouseEvent.getID() == 506) {
                    this.currentTarget.dispatchEvent(event, null);
                } else if (mouseEvent.getID() == 502) {
                    this.mouseDown = false;
                    this.currentTarget.dispatchEvent(event, this.getSelectInfo(mouseEvent));
                }
            } else if (mouseEvent.getID() == 505) {
                if (this.currentTarget != null) {
                    this.currentTarget.dispatchEvent(new MouseEvent(this.javaComponent, 505, 0L, 0, mouseEvent.getX(), mouseEvent.getY(), 0, false), null);
                    this.currentTarget = null;
                }
            } else {
                int x = mouseEvent.getX();
                int y = mouseEvent.getY();
                if (this.networkRoot != null) {
                    SelectInfo selectInfo = this.getSelectInfo(mouseEvent);
                    if (selectInfo != null) {
                        this.dispatchEvent(event, selectInfo);
                    } else if (this.currentTarget != null) {
                        this.currentTarget.dispatchEvent(new MouseEvent(this.javaComponent, 505, 0L, 0, x, y, 0, false), null);
                        this.currentTarget = null;
                    }
                }
            }
        } else if ((event instanceof FocusEvent || event instanceof KeyEvent || event instanceof ComponentEvent) && this.currentTarget != null && this.currentSelectInfo != null) {
            this.currentTarget.dispatchEvent(event, this.currentSelectInfo);
        }
    }

    public final synchronized void dispatchEvent(AWTEvent event, SelectInfo selectInfo) {
        VisualizationComponentInterface target = selectInfo.getTarget();
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            if (target != this.currentTarget && mouseEvent.getID() == 506) {
                target = this.currentTarget;
            }
            if (mouseEvent.getID() == 501) {
                this.mouseDown = true;
            } else if (mouseEvent.getID() == 502) {
                this.mouseDown = false;
            }
        }
        if (target != null) {
            try {
                int x = 0;
                int y = 0;
                if (event instanceof MouseEvent) {
                    x = ((MouseEvent)event).getX();
                    y = ((MouseEvent)event).getY();
                }
                if (this.currentTarget != null && target != this.currentTarget) {
                    this.currentTarget.dispatchEvent(new MouseEvent(this.javaComponent, 505, 0L, 0, x, y, 0, false), null);
                    this.currentTarget = null;
                }
                if (this.currentTarget == null) {
                    this.currentTarget = target;
                    this.currentTarget.dispatchEvent(new MouseEvent(this.javaComponent, 504, 0L, 0, x, y, 0, false), null);
                }
                this.currentSelectInfo = selectInfo;
                target.dispatchEvent(event, selectInfo);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addPopupMenu(PopupMenu popup) {
        if (this.javaComponent != null && popup != null) {
            this.javaComponent.add(popup);
        }
    }

    @Override
    public void showPopupMenu(PopupMenu popupMenu, int x, int y) {
        if (this.javaComponent != null && popupMenu != null) {
            popupMenu.show(this.javaComponent, x, y);
        }
    }

    @Override
    public void removePopupMenu(PopupMenu popup) {
        if (this.javaComponent != null && popup != null) {
            this.javaComponent.remove(popup);
        }
    }

    @Override
    public Locale getLocale() throws IllegalComponentStateException {
        return this.javaComponent != null ? this.javaComponent.getLocale() : null;
    }

    @Override
    public void setLocale(Locale l) {
        if (this.javaComponent != null && l != null) {
            this.javaComponent.setLocale(l);
        }
    }

    @Override
    public void requestFocus() {
        if (this.javaComponent != null) {
            this.javaComponent.requestFocus();
        }
    }

    @Override
    public void transferFocus() {
        if (this.javaComponent != null) {
            this.javaComponent.transferFocus();
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.javaComponent != null && cursor != null) {
            this.javaComponent.setCursor(cursor);
        }
    }

    @Override
    public Cursor getCursor() {
        return this.javaComponent != null ? this.javaComponent.getCursor() : null;
    }

    private class MyComponentListener
    extends ComponentAdapter {
        private MyComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent event) {
            JXDVisualizationGraphics.this.cached3DExtent = null;
        }
    }
}

