/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.AxisInterface;
import com.sas.graphics.chart.util.ctk.DataSourceInterface;
import com.sas.graphics.chart.util.ctk.TickStrategyEvent;
import com.sas.graphics.chart.util.ctk.TickStrategyListener;
import com.sas.graphics.chart.util.ctk.TickStrategySource;
import com.sas.graphics.chart.util.ctk.TwoAxisOverlay;
import com.sas.graphics.chart.util.ctk.vtk.DoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.DoubleTickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleTransformStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.StrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.StringTickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleTransformStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.TickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.TransformStrategyInterface;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AGrid;
import com.sas.graphics.util.vtk.ALabel;
import com.sas.graphics.util.vtk.GridStyle;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;

public class GridOverlay
extends TwoAxisOverlay {
    protected AGrid vtkGrid;
    protected boolean dependentMajorLinesOn;
    protected boolean independentMajorLinesOn;
    protected DoubleStrategyMapper dependentMapper;
    protected DoubleStrategyMapper independentMapper;
    protected String title;
    protected TickStrategyInterface independentAxisTickStrategy;
    protected TickStrategyInterface dependentAxisTickStrategy;
    protected Hashtable tickStrategies;
    protected TickStrategyListener overlayTickStrategyListener;

    protected GridOverlay() {
    }

    public static Object newInstance() {
        GridOverlay o = new GridOverlay();
        o.init();
        return o;
    }

    public static final GridOverlay newGridOverlay() {
        return (GridOverlay)GridOverlay.newInstance();
    }

    @Override
    protected void init() {
        super.init();
        this.setDependentMajorGridLinesEnabled(true);
        this.setIndependentMajorGridLinesEnabled(true);
    }

    @Override
    public boolean isValidData(DataSourceInterface data) {
        return true;
    }

    @Override
    protected void makeNetwork() {
        if (this.networkRoot != null) {
            this.composite.removeAllElements();
            if (this.vtkGrid == null && this.visualizationGraphics != null) {
                this.vtkGrid = this.visualizationGraphics.newGrid();
                GridStyle gridStyle = this.vtkGrid.getStyle();
                gridStyle.setBackgroundOn(true);
                gridStyle.setBorderOn(true);
                gridStyle.setMajorLineColor(Color.gray);
                gridStyle.setBackgroundColor(Color.lightGray);
                this.vtkGrid.setStyle(gridStyle);
            }
            this._setGridBounds();
            this.composite.addElement(this.vtkGrid);
            if (this.title != null && this.title.length() > 0 && this.visualizationGraphics != null) {
                ALabel vtkText = this.visualizationGraphics.newLabel(this.title);
                vtkText.color.setValue(Color.black);
                vtkText.transform.translateX.setValue(this.origin.x + this.extent.x * 0.5 - 15.0);
                vtkText.transform.translateY.setValue(this.origin.y + this.extent.y * 0.8);
                if (vtkText != null) {
                    vtkText.transform.translateZ.setValue(this.origin.z);
                    this.composite.addElement(vtkText);
                }
            }
        }
    }

    private void _setGridBounds() {
        if (this.networkRoot != null) {
            if (this.dependentMapper == null || this.independentMapper == null) {
                this.dependentMapper = GridOverlay.newMapper(this.dependentAxisTransformStrategy, this.dependentAxisTickStrategy);
                this.independentMapper = GridOverlay.newMapper(this.independentAxisTransformStrategy, this.independentAxisTickStrategy);
                if (this.dependentMapper == null || this.independentMapper == null) {
                    return;
                }
                this.setDependentAxisMapper(DEPENDENT_AXIS, this.dependentMapper);
                this.setIndependentAxisMapper(INDEPENDENT_AXIS, this.independentMapper);
            }
            if (this.vtkGrid != null && this.dependentMapper != null && this.independentMapper != null) {
                this.invalidateGraphics();
                AxisInterface dependentAxis = this.getDependentAxis();
                AxisInterface independentAxis = this.getIndependentAxis();
                int dOrientation = dependentAxis.getOrientation();
                int iOrientation = independentAxis.getOrientation();
                this.vtkGrid.horizontalLineOffset.disconnect();
                this.vtkGrid.verticalLineOffset.disconnect();
                if (dOrientation == iOrientation) {
                    return;
                }
                switch (dOrientation) {
                    case 1: {
                        switch (iOrientation) {
                            case 2: {
                                this.vtkGrid.setWidth(this.extent.x);
                                this.vtkGrid.setHeight(this.extent.y);
                                this.vtkGrid.setHorizontalOrigin(this.origin.x);
                                this.vtkGrid.setVerticalOrigin(this.origin.y);
                                this.vtkGrid.setBackgroundHorizontalOrigin(this.origin.x);
                                this.vtkGrid.setBackgroundVerticalOrigin(this.origin.y);
                                this.vtkGrid.setNormal(Vec3d.getZAxis());
                                if (this.dependentMajorLinesOn) {
                                    this.vtkGrid.verticalLineOffset.connectFrom(this.dependentMapper.uniqueValue);
                                }
                                if (!this.independentMajorLinesOn) break;
                                this.vtkGrid.horizontalLineOffset.connectFrom(this.independentMapper.uniqueValue);
                                break;
                            }
                            case 3: {
                                return;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (iOrientation) {
                            case 1: {
                                this.vtkGrid.setWidth(this.extent.x);
                                this.vtkGrid.setHeight(this.extent.y);
                                this.vtkGrid.setHorizontalOrigin(this.origin.x);
                                this.vtkGrid.setVerticalOrigin(this.origin.y);
                                this.vtkGrid.setBackgroundHorizontalOrigin(this.origin.x);
                                this.vtkGrid.setBackgroundVerticalOrigin(this.origin.y);
                                this.vtkGrid.setNormal(Vec3d.getZAxis());
                                if (this.dependentMajorLinesOn) {
                                    this.vtkGrid.horizontalLineOffset.connectFrom(this.dependentMapper.uniqueValue);
                                }
                                if (!this.independentMajorLinesOn) break;
                                this.vtkGrid.verticalLineOffset.connectFrom(this.independentMapper.uniqueValue);
                                break;
                            }
                            case 3: {
                                return;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (iOrientation) {
                            case 1: {
                                return;
                            }
                            case 2: {
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public Vec3d setExtent(Vec3d extent) {
        extent = super.setExtent(extent);
        this._setGridBounds();
        return extent;
    }

    @Override
    public Vec3d setOrigin(Vec3d origin) {
        origin = super.setOrigin(origin);
        this._setGridBounds();
        return origin;
    }

    public void setTitle(String s) {
        this.title = s == null || s.length() == 0 ? null : s;
    }

    public String getTitle() {
        return this.title;
    }

    protected static DoubleStrategyMapper newMapper(TransformStrategyInterface transformStrategy, TickStrategyInterface tickStrategy) {
        DoubleStrategyMapper mapper = null;
        if (transformStrategy != null) {
            if (transformStrategy instanceof DoubleToDoubleTransformStrategyInterface) {
                mapper = new DoubleToDoubleStrategyMapper();
                ((DoubleToDoubleStrategyMapper)mapper).setTransformStrategy((DoubleToDoubleTransformStrategyInterface)transformStrategy);
                if (tickStrategy instanceof DoubleTickStrategyInterface) {
                    ((DoubleToDoubleStrategyMapper)mapper).setTickStrategy((DoubleTickStrategyInterface)tickStrategy);
                }
            } else if (transformStrategy instanceof StringToDoubleTransformStrategyInterface) {
                mapper = new StringToDoubleStrategyMapper();
                ((StringToDoubleStrategyMapper)mapper).setTransformStrategy((StringToDoubleTransformStrategyInterface)transformStrategy);
                if (tickStrategy instanceof StringTickStrategyInterface) {
                    ((StringToDoubleStrategyMapper)mapper).setTickStrategy((StringTickStrategyInterface)tickStrategy);
                }
            }
        }
        return mapper;
    }

    @Override
    protected void detachVisualizationGraphics() {
        this.vtkGrid = null;
        super.detachVisualizationGraphics();
    }

    public void setDependentMajorGridLinesEnabled(boolean b) {
        this.dependentMajorLinesOn = b;
    }

    public boolean getDependentMajorGridLinesEnabled() {
        return this.dependentMajorLinesOn;
    }

    public void setIndependentMajorGridLinesEnabled(boolean b) {
        this.independentMajorLinesOn = b;
    }

    public boolean getIndependentMajorGridLinesEnabled() {
        return this.independentMajorLinesOn;
    }

    @Override
    public Vec3d getMaximumExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getPreferredExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getMinimumExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getMinimumPartialExtent() {
        return new Vec3d();
    }

    @Override
    public String toString() {
        return "GridOverlay :" + super.toString();
    }

    @Override
    protected AxisInterface attachAxis(Object id, AxisInterface axis) {
        if ((axis = super.attachAxis(id, axis)) instanceof TickStrategySource) {
            if (this.overlayTickStrategyListener == null) {
                this.overlayTickStrategyListener = new OverlayTickStrategyListener();
            }
            ((TickStrategySource)((Object)axis)).addTickStrategyListener(this.overlayTickStrategyListener);
        }
        return axis;
    }

    @Override
    protected AxisInterface detachAxis(Object id) {
        AxisInterface axis = super.detachAxis(id);
        if (axis instanceof TickStrategySource && this.overlayTickStrategyListener != null) {
            ((TickStrategySource)((Object)axis)).removeTickStrategyListener(this.overlayTickStrategyListener);
        }
        return axis;
    }

    public TickStrategyInterface setTickStrategy(Object id, TickStrategyInterface xStrategy) {
        this.setTickStrategy2(id, xStrategy);
        if (id == INDEPENDENT_AXIS) {
            this.independentAxisTickStrategy = xStrategy;
            this.updateTickStrategyOnIndependentAxisMappers();
        } else if (id == DEPENDENT_AXIS) {
            this.dependentAxisTickStrategy = xStrategy;
            this.updateTickStrategyOnDependentAxisMappers();
        }
        return xStrategy;
    }

    public TickStrategyInterface setTickStrategy2(Object id, TickStrategyInterface tickStrategy) {
        if (id == null) {
            return null;
        }
        if (tickStrategy == null) {
            if (this.tickStrategies != null) {
                this.tickStrategies.remove(id);
            }
        } else {
            if (this.tickStrategies == null) {
                this.tickStrategies = new Hashtable();
            }
            this.tickStrategies.put(id, tickStrategy);
        }
        return tickStrategy;
    }

    protected static void setMapperTickStrategy(StrategyMapper mapper, TickStrategyInterface strategy) {
        if (mapper != null && strategy != null) {
            if (strategy instanceof DoubleTickStrategyInterface && mapper instanceof DoubleToDoubleStrategyMapper) {
                ((DoubleToDoubleStrategyMapper)mapper).setTickStrategy((DoubleTickStrategyInterface)strategy);
            } else if (strategy instanceof StringTickStrategyInterface && mapper instanceof StringToDoubleStrategyMapper) {
                ((StringToDoubleStrategyMapper)mapper).setTickStrategy((StringTickStrategyInterface)strategy);
            }
        }
    }

    public TickStrategyInterface getTickStrategy(Object id) {
        return this.tickStrategies != null ? (TickStrategyInterface)this.tickStrategies.get(id) : null;
    }

    @Override
    protected void setDependentAxisMapper(Object id, DoubleStrategyMapper mapper) {
        super.setDependentAxisMapper(id, mapper);
        GridOverlay.setMapperTickStrategy(mapper, this.dependentAxisTickStrategy);
    }

    protected void updateTickStrategyOnDependentAxisMappers() {
        Enumeration keys = this.dependentAxisMappers.keys();
        while (keys.hasMoreElements()) {
            GridOverlay.setMapperTickStrategy(this.getDependentAxisMapper(keys.nextElement()), this.dependentAxisTickStrategy);
        }
    }

    @Override
    protected void setIndependentAxisMapper(Object id, DoubleStrategyMapper mapper) {
        super.setIndependentAxisMapper(id, mapper);
        GridOverlay.setMapperTickStrategy(mapper, this.independentAxisTickStrategy);
    }

    protected void updateTickStrategyOnIndependentAxisMappers() {
        Enumeration keys = this.independentAxisMappers.keys();
        while (keys.hasMoreElements()) {
            GridOverlay.setMapperTickStrategy(this.getIndependentAxisMapper(keys.nextElement()), this.independentAxisTickStrategy);
        }
    }

    protected class OverlayTickStrategyListener
    implements TickStrategyListener {
        protected OverlayTickStrategyListener() {
        }

        @Override
        public void tickStrategyUpdate(TickStrategyEvent e) {
            if (e == null) {
                return;
            }
            Object source = e.getSource();
            if (source instanceof AxisInterface && GridOverlay.this.axes != null && GridOverlay.this.axes.contains(source)) {
                boolean hit = false;
                Enumeration keys = GridOverlay.this.axes.keys();
                while (keys.hasMoreElements()) {
                    Object id = keys.nextElement();
                    if (source != GridOverlay.this.axes.get(id)) continue;
                    GridOverlay.this.setTickStrategy(id, e.getTickStrategy());
                    hit = true;
                }
                if (hit) {
                    return;
                }
            }
            GridOverlay.this.setTickStrategy(source, e.getTickStrategy());
        }
    }
}

