/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.VisualizationComponentInterface;
import com.sas.graphics.chart.util.ctk.VisualizationConstraintInterface;
import com.sas.graphics.chart.util.ctk.VisualizationContainerInterface;
import com.sas.graphics.chart.util.ctk.VisualizationLayoutManager;
import com.sas.graphics.util.Vec3d;
import java.util.Enumeration;
import java.util.Vector;

public class GridLayoutManager
extends VisualizationLayoutManager {
    @Override
    public void layoutContainer() {
        this.layout();
    }

    public GridConstraintInterface newDefaultConstraint() {
        return new GridConstraint();
    }

    @Override
    public Vec3d getMaximumExtent() {
        return this.getMinimumExtent();
    }

    @Override
    public Vec3d getPreferredExtent() {
        return this.getMinimumExtent();
    }

    @Override
    public Vec3d getMinimumExtent() {
        VisualizationContainerInterface container = this.getVisualizationContainer();
        if (container == null) {
            return new Vec3d();
        }
        Enumeration components = container.visualizationComponents();
        if (components == null) {
            return new Vec3d();
        }
        if (components.hasMoreElements()) {
            VisualizationComponentInterface vc = (VisualizationComponentInterface)components.nextElement();
            return vc.getMinimumExtent();
        }
        return new Vec3d();
    }

    @Override
    public Vec3d getMinimumPartialExtent() {
        return this.getMinimumExtent();
    }

    protected void layout() {
        Info info = new Info(this.getVisualizationContainer());
        if (info.overlay == null) {
            return;
        }
        if (info.extent.x < 0.0) {
            info.origin.x += info.extent.x;
            info.extent.x = -info.extent.x;
        }
        if (info.extent.y > 0.0) {
            info.origin.y += info.extent.y;
            info.extent.y = -info.extent.y;
        }
        if (info.extent.z > 0.0) {
            info.origin.z += info.extent.z;
            info.extent.z = -info.extent.z;
        }
        info.overlay.setOrigin(info.origin);
        info.overlay.setExtent(info.extent);
    }

    public static class GridConstraint
    implements GridConstraintInterface {
        protected int row;
        protected int column;

        public GridConstraint() {
        }

        public GridConstraint(int r, int c) {
            this.row = r;
            this.column = c;
        }

        @Override
        public VisualizationConstraintInterface copy() {
            GridConstraint copy = new GridConstraint();
            copy.row = this.row;
            copy.column = this.column;
            return copy;
        }

        @Override
        public void setRow(int r) {
            this.row = r;
        }

        @Override
        public int getRow() {
            return this.row;
        }

        @Override
        public void setColumn(int c) {
            this.column = c;
        }

        @Override
        public int getColumn() {
            return this.column;
        }
    }

    protected class Info {
        public VisualizationComponentInterface overlay;
        protected Vector orphans;
        public Vec3d extent;
        public Vec3d origin;

        public Info(VisualizationContainerInterface container) {
            if (container == null) {
                return;
            }
            this.extent = container.getExtent();
            this.origin = container.getOrigin();
            Enumeration components = container.visualizationComponents();
            if (components == null) {
                return;
            }
            while (components.hasMoreElements()) {
                VisualizationConstraintInterface vx;
                VisualizationComponentInterface vc = (VisualizationComponentInterface)components.nextElement();
                if (vc == null || (vx = GridLayoutManager.this.vContainer.getVisualizationConstraint(vc)) == null || !(vx instanceof GridConstraintInterface)) continue;
                this.overlay = vc;
            }
        }

        protected void addOrphan(Object orphan) {
            if (this.orphans == null) {
                this.orphans = new Vector();
            }
            this.orphans.addElement(orphan);
        }
    }

    public static interface GridConstraintInterface
    extends VisualizationConstraintInterface {
        public void setRow(int var1);

        public int getRow();

        public void setColumn(int var1);

        public int getColumn();
    }
}

