/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.graphics.chart.util.ctk.Axis;
import com.sas.graphics.chart.util.ctk.BoxOverlay;
import com.sas.graphics.chart.util.ctk.ColorLegend;
import com.sas.graphics.chart.util.ctk.DataSourceInterface;
import com.sas.graphics.chart.util.ctk.ElementInfoInterface;
import com.sas.graphics.chart.util.ctk.OverlayInterface;
import com.sas.graphics.chart.util.ctk.PipedProbeInterface;
import com.sas.graphics.chart.util.ctk.VTKVisualizationGraphicsInterface;
import com.sas.graphics.chart.util.ctk.VisualizationGraphicsInterface;
import com.sas.graphics.chart.util.ctk.vtk.DoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtkDateFormatJoeHack;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.Calculator;
import com.sas.graphics.util.vtk.ColorVector;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipedFormat;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.StringPipedFormat;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.StringVectorVariable;
import com.sas.graphics.util.vtk.VTKFormat;
import com.sas.graphics.util.vtk.Variable;
import com.sas.graphics.util.vtk.jxd.ComplexGanttBox;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;

public class GanttOverlay
extends BoxOverlay
implements ElementInfoInterface {
    public static String NORMAL_LEGEND_LABEL = "Normal Job";
    public static String SLACK_LEGEND_LABEL = "Slack Time";
    public static String CRITICAL_LEGEND_LABEL = "Critical Job";
    public static String BASELINE_LEGEND_LABEL = "Baseline";
    public static String ACTUAL_LEGEND_LABEL = "Actual";
    public static String RESOURCE_LEGEND_LABEL = "Resource";
    public static String HOLIDAY_LEGEND_LABEL = "BreakDue to Holiday";
    public static String MILESTONE_LEGEND_LABEL = "Milestone";
    public static final Integer EARLYSTART = OverlayInterface.VariableRoles.EARLYSTART;
    public static final Integer EARLYFINISH = OverlayInterface.VariableRoles.EARLYFINISH;
    public static final Integer LATESTART = OverlayInterface.VariableRoles.LATESTART;
    public static final Integer LATEFINISH = OverlayInterface.VariableRoles.LATEFINISH;
    public static final Integer ACTUALSTART = OverlayInterface.VariableRoles.ACTUALSTART;
    public static final Integer ACTUALFINISH = OverlayInterface.VariableRoles.ACTUALFINISH;
    public static final Integer RESOURCESTART = OverlayInterface.VariableRoles.RESOURCESTART;
    public static final Integer RESOURCEFINISH = OverlayInterface.VariableRoles.RESOURCEFINISH;
    public static final Integer BASELINESTART = OverlayInterface.VariableRoles.BASELINESTART;
    public static final Integer BASELINEFINISH = OverlayInterface.VariableRoles.BASELINEFINISH;
    public static final Integer SUMMARY = OverlayInterface.VariableRoles.SUMMARY;
    public static final Integer WBSCODE = OverlayInterface.VariableRoles.WBSCODE;
    public static final Integer PROJECTLEVEL = OverlayInterface.VariableRoles.PROJECTLEVEL;
    public static final int CONTAINED_STYLE_SAS = 0;
    public static final int CONTAINED_STYLE_NONE = 0;
    public static final int CONTAINED_STYLE_ALL = 1;
    public static final int BOX_CONNECTION_STYLE_SAS = 0;
    public static final int BOX_CONNECTION_STYLE_BOX = 0;
    public static final int BOX_CONNECTION_STYLE_INDENT = 1;
    public static final int BOX_CONNECTION_STYLE_LINE = 2;
    public static final int BOX_STYLE_SAS = 4;
    public static final int BOX_STYLE_HALF_BOX = 0;
    public static final int BOX_STYLE_FULL_BOX = 4;
    public static final int BOX_STYLE_SUMMARY = 2;
    public static final int BOX_STYLE_SUMMARY_ALL = 3;
    protected static final int BOX_STYLE_MILESTONE = 1;
    protected static final int BOX_STYLE_FULL_MILESTONE = 5;
    protected ComplexGanttBox ganttElement;
    protected Calculator visibleValueFilter;
    private DataSourceContentsChangedListener dataSourceContentsChangedListener;
    protected int summaryStyle;
    protected int milestoneStyle;
    protected int boxStyle;
    protected int boxConnectionStyle;
    protected int containedStyle;
    protected Calculator summaryCalculator;
    protected VTKFormat vtkFormat;
    protected Hashtable analysisVariableFormatters;
    private ColorLegend legend;

    protected GanttOverlay() {
    }

    public static Object newInstance() {
        GanttOverlay o = new GanttOverlay();
        o.init();
        return o;
    }

    public static final GanttOverlay newGanttOverlay() {
        return (GanttOverlay)GanttOverlay.newInstance();
    }

    @Override
    protected void init() {
        super.init();
        this.vtkFormat = new vtkDateFormatJoeHack("Date9");
        this.analysisVariableFormatters = new Hashtable(10);
        this.legend = ColorLegend.newColorLegend();
        this.addLegend(this.legend);
        this.addLegend(OverlayInterface.VariableRoles.COLOR, this.legend);
        this.legend.setContinuous(false);
        this.dataSourceContentsChangedListener = new DataSourceContentsChangedListener();
        this.summaryCalculator = new Calculator();
        this.setSummaryStyle(4);
        this.setConnectionStyle(0);
        this.setContainedStyle(0);
    }

    public void setSummaryStyle(int summaryStyle) {
        switch (summaryStyle) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                this.summaryStyle = summaryStyle;
                this.milestoneStyle = summaryStyle == 4 ? 5 : 1;
                this.boxStyle = summaryStyle == 4 ? 4 : 0;
                String summaryString = "(inA=0) ? " + this.boxStyle + " : ((inA=1) ?" + summaryStyle + " : " + this.milestoneStyle + " )";
                this.summaryCalculator.setExpression(summaryString);
                this.invalidateGraphics();
                this.rerender();
            }
        }
    }

    public int getSummaryStyle() {
        return this.summaryStyle;
    }

    public void setConnectionStyle(int boxConnectionStyle) {
        switch (boxConnectionStyle) {
            case 0: 
            case 1: 
            case 2: {
                this.boxConnectionStyle = boxConnectionStyle;
                this.invalidateGraphics();
                this.rerender();
            }
        }
    }

    public int getConnectionStyle() {
        return this.boxConnectionStyle;
    }

    public void setContainedStyle(int containedStyle) {
        switch (containedStyle) {
            case 0: 
            case 1: {
                this.containedStyle = containedStyle;
                this.invalidateGraphics();
                this.rerender();
            }
        }
    }

    public int getContainedStyle() {
        return this.containedStyle;
    }

    @Override
    public boolean isValidData(DataSourceInterface data) {
        return true;
    }

    @Override
    protected void makeNetwork() {
        this._connectNetwork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _connectNetwork() {
        this._disconnectNetwork();
        VisualizationGraphicsInterface vg = this.getVisualizationGraphics();
        if (vg instanceof VTKVisualizationGraphicsInterface) {
            Object object = this.NETWORK_LOCK;
            synchronized (object) {
                DoubleStrategyMapper earlyStartMapper = this.getDependentAxisMapper(EARLYSTART);
                DoubleStrategyMapper earlyFinishMapper = this.getDependentAxisMapper(EARLYFINISH);
                DoubleStrategyMapper lateStartMapper = this.getDependentAxisMapper(LATESTART);
                DoubleStrategyMapper lateFinishMapper = this.getDependentAxisMapper(LATEFINISH);
                DoubleStrategyMapper actualStartMapper = this.getDependentAxisMapper(ACTUALSTART);
                DoubleStrategyMapper actualFinishMapper = this.getDependentAxisMapper(ACTUALFINISH);
                DoubleStrategyMapper resourceStartMapper = this.getDependentAxisMapper(RESOURCESTART);
                DoubleStrategyMapper resourceFinishMapper = this.getDependentAxisMapper(RESOURCEFINISH);
                DoubleStrategyMapper baselineStartMapper = this.getDependentAxisMapper(BASELINESTART);
                DoubleStrategyMapper baselineFinishMapper = this.getDependentAxisMapper(BASELINEFINISH);
                if (this.groupCategoryMapper != null && (earlyStartMapper != null && earlyFinishMapper != null || actualStartMapper != null && actualFinishMapper != null || resourceStartMapper != null && resourceFinishMapper != null || baselineStartMapper != null && baselineFinishMapper != null)) {
                    Variable summary;
                    if (this.ganttElement == null) {
                        this.ganttElement = ((VTKVisualizationGraphicsInterface)vg).newComplexGanttBox();
                    }
                    Font font = ((Axis)this.getIndependentAxis()).getValueFont();
                    double axisValueHeight = vg.getTextHeight(font);
                    this.ganttElement.orientation.setValue(0.0);
                    this.ganttElement.boxThickness.setValue(-axisValueHeight);
                    this.visibleValueFilter = ((Axis)this.getIndependentAxis()).newVisibleValueFilter(this.visibleValueFilter, axisValueHeight);
                    this.visibleValueFilter.inA.connectFrom(this.groupCategoryMapper);
                    this.ganttElement.transform.translateY.connectFrom(this.visibleValueFilter);
                    if (earlyStartMapper != null && earlyFinishMapper != null) {
                        this.ganttElement.earlyStart.connectFrom(earlyStartMapper);
                        this.ganttElement.earlyFinish.connectFrom(earlyFinishMapper);
                        if (lateStartMapper != null && lateFinishMapper != null) {
                            this.ganttElement.lateStart.connectFrom(lateStartMapper);
                            this.ganttElement.lateFinish.connectFrom(lateFinishMapper);
                        } else {
                            this.ganttElement.lateStart.connectFrom(earlyStartMapper);
                            this.ganttElement.lateFinish.connectFrom(earlyFinishMapper);
                        }
                    }
                    if (actualStartMapper != null && actualFinishMapper != null) {
                        this.ganttElement.actualStart.connectFrom(actualStartMapper);
                        this.ganttElement.actualFinish.connectFrom(actualFinishMapper);
                    }
                    if (resourceStartMapper != null && resourceFinishMapper != null) {
                        this.ganttElement.resourceStart.connectFrom(resourceStartMapper);
                        this.ganttElement.resourceFinish.connectFrom(resourceFinishMapper);
                    }
                    if (baselineStartMapper != null && baselineFinishMapper != null) {
                        this.ganttElement.baselineStart.connectFrom(baselineStartMapper);
                        this.ganttElement.baselineFinish.connectFrom(baselineFinishMapper);
                    }
                    if ((summary = this.getAnalysisVariable(SUMMARY)) instanceof NumericVariable) {
                        this.summaryCalculator.inA.connectFrom(((NumericVariable)summary).value);
                    } else {
                        this.summaryCalculator.inA.disconnect();
                        this.summaryCalculator.inA.setValue(0.0);
                    }
                    this.ganttElement.boxStyle.connectFrom(this.summaryCalculator);
                    this.ganttElement.contained.setValue(this.containedStyle == 1);
                    this.ganttElement.boxConnectionStyle.setValue(this.boxConnectionStyle);
                    this.composite.addElement(this.ganttElement);
                    if (this.legend != null) {
                        int items = 0;
                        if (earlyStartMapper != null && earlyFinishMapper != null) {
                            ++items;
                        }
                        if (lateStartMapper != null && lateFinishMapper != null) {
                            items += 2;
                        }
                        if (actualStartMapper != null && actualFinishMapper != null) {
                            ++items;
                        }
                        if (resourceStartMapper != null && resourceFinishMapper != null) {
                            ++items;
                        }
                        if (baselineStartMapper != null && baselineFinishMapper != null) {
                            ++items;
                        }
                        if (items == 0) {
                            this.legend.setLabels(null);
                            this.legend.setValues(null);
                        } else {
                            String[] legendValues = new String[items];
                            Color[] legendColors = new Color[items];
                            items = 0;
                            try {
                                if (earlyStartMapper != null && earlyFinishMapper != null) {
                                    legendValues[items] = CRITICAL_LEGEND_LABEL;
                                    legendColors[items++] = this.ganttElement.criticalColor.getValue(0);
                                }
                                if (lateStartMapper != null && lateFinishMapper != null) {
                                    legendValues[items] = NORMAL_LEGEND_LABEL;
                                    legendColors[items++] = this.ganttElement.earlyColor.getValue(0);
                                    legendValues[items] = SLACK_LEGEND_LABEL;
                                    legendColors[items++] = this.ganttElement.lateColor.getValue(0);
                                }
                                if (actualStartMapper != null && actualFinishMapper != null) {
                                    legendValues[items] = ACTUAL_LEGEND_LABEL;
                                    legendColors[items++] = this.ganttElement.actualColor.getValue(0);
                                }
                                if (resourceStartMapper != null && resourceFinishMapper != null) {
                                    legendValues[items] = RESOURCE_LEGEND_LABEL;
                                    legendColors[items++] = this.ganttElement.resourceColor.getValue(0);
                                }
                                if (baselineStartMapper != null && baselineFinishMapper != null) {
                                    legendValues[items] = BASELINE_LEGEND_LABEL;
                                    legendColors[items++] = this.ganttElement.baselineColor.getValue(0);
                                }
                            }
                            catch (MissingValueException missingValueException) {
                                // empty catch block
                            }
                            StringVectorVariable sv = new StringVectorVariable();
                            sv.connectFrom(legendValues);
                            ColorVector cv = new ColorVector();
                            int size = legendColors.length;
                            for (int ii = 0; ii < size; ++ii) {
                                cv.addValue(legendColors[ii]);
                            }
                            this.legend.setLabels(sv.value);
                            this.legend.setValues(cv.value);
                        }
                    }
                }
            }
        }
        this._applyBoundaryConstraints();
    }

    private void _applyBoundaryConstraints() {
        if (this.ganttElement != null) {
            this.ganttElement.transform.translateZ.setValue(this.origin.z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _disconnectNetwork() {
        Object object = this.NETWORK_LOCK;
        synchronized (object) {
            this.composite.removeAllElements();
            if (this.ganttElement != null) {
                this.ganttElement.transform.translateY.disconnect();
                this.ganttElement.earlyStart.disconnect();
                this.ganttElement.earlyFinish.disconnect();
                this.ganttElement.lateStart.disconnect();
                this.ganttElement.lateFinish.disconnect();
                this.ganttElement.actualStart.disconnect();
                this.ganttElement.actualFinish.disconnect();
                this.ganttElement.resourceStart.disconnect();
                this.ganttElement.resourceFinish.disconnect();
                this.ganttElement.baselineStart.disconnect();
                this.ganttElement.baselineFinish.disconnect();
            }
            if (this.legend != null) {
                this.legend.setLabels(null);
                this.legend.setValues(null);
            }
        }
    }

    @Override
    protected void attachVisualizationGraphics(VisualizationGraphicsInterface vg) {
        super.attachVisualizationGraphics(vg);
        this._connectNetwork();
    }

    protected void attachVisualizationGraphics() {
        this._disconnectNetwork();
        this.ganttElement = null;
        super.detachVisualizationGraphics();
    }

    @Override
    public void configureProbe(PipedProbeInterface probe, int style) {
        if (1 == style || 0 == style || 2 == style) {
            this._addProbePipe(probe, this.getClassifierVariable(CATEGORY));
            this._addProbeAnalysisPipe(probe, EARLYSTART);
            this._addProbeAnalysisPipe(probe, EARLYFINISH);
            this._addProbeAnalysisPipe(probe, LATESTART);
            this._addProbeAnalysisPipe(probe, LATEFINISH);
            this._addProbeAnalysisPipe(probe, ACTUALSTART);
            this._addProbeAnalysisPipe(probe, ACTUALFINISH);
            this._addProbeAnalysisPipe(probe, RESOURCESTART);
            this._addProbeAnalysisPipe(probe, RESOURCEFINISH);
            this._addProbeAnalysisPipe(probe, BASELINESTART);
            this._addProbeAnalysisPipe(probe, BASELINEFINISH);
        }
    }

    private void _addProbeAnalysisPipe(PipedProbeInterface probe, Object id) {
        StringVariable sv;
        Variable variable = this.getAnalysisVariable(id);
        if (variable instanceof NumericVariable) {
            NumericPipedFormat pipedFormat = (NumericPipedFormat)this.analysisVariableFormatters.get(id);
            NumericVariable nv = (NumericVariable)variable;
            if (nv != null && pipedFormat != null && probe.getProbeEntry(pipedFormat.value) == null) {
                probe.addPipe(nv.getName(), pipedFormat.value);
            } else if (nv != null && probe.getProbeEntry(nv.value) == null) {
                probe.addPipe(nv.getName(), nv.value);
            }
        } else if (variable instanceof StringVariable && (sv = (StringVariable)variable) != null && probe.getProbeEntry(sv.value) == null) {
            probe.addPipe(sv.getName(), sv.value);
        }
    }

    private void _addProbePipe(PipedProbeInterface probe, Variable variable) {
        StringVariable sv;
        if (variable instanceof NumericVariable) {
            NumericVariable nv = (NumericVariable)variable;
            if (nv != null && probe.getProbeEntry(nv.value) == null) {
                probe.addPipe(nv.getName(), nv.value);
            }
        } else if (variable instanceof StringVariable && (sv = (StringVariable)variable) != null && probe.getProbeEntry(sv.value) == null) {
            probe.addPipe(sv.getName(), sv.value);
        }
    }

    @Override
    public Hashtable getElementInfo(int index) {
        if (index < 0) {
            return null;
        }
        Hashtable<Object, Object> ganttElementInfo = new Hashtable<Object, Object>(12);
        Variable variable = this.getClassifierVariable(CATEGORY);
        if (variable != null) {
            try {
                ganttElementInfo.put(CATEGORY, ((StringVariable)variable).value.getValue(index));
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        Object[] ids = new Object[]{EARLYSTART, EARLYFINISH, LATESTART, LATEFINISH, ACTUALSTART, ACTUALFINISH, RESOURCESTART, RESOURCEFINISH, BASELINESTART, BASELINEFINISH, WBSCODE, PROJECTLEVEL};
        for (int ii = 0; ii < ids.length; ++ii) {
            variable = this.getAnalysisVariable(ids[ii]);
            if (variable == null) continue;
            try {
                if (variable instanceof NumericVariable) {
                    ganttElementInfo.put(ids[ii], new Double(((NumericVariable)variable).value.getValue(index)));
                    continue;
                }
                if (!(variable instanceof StringVariable)) continue;
                ganttElementInfo.put(ids[ii], ((StringVariable)variable).value.getValue(index));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return ganttElementInfo;
    }

    @Override
    public Vec3d setOrigin(Vec3d origin) {
        Vec3d _origin = super.setOrigin(origin);
        this._applyBoundaryConstraints();
        return _origin;
    }

    @Override
    public Vec3d getMaximumExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getPreferredExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getMinimumExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getMinimumPartialExtent() {
        return new Vec3d();
    }

    @Override
    public String toString() {
        return "GanttOverlay :" + super.toString();
    }

    @Override
    protected boolean attachData(DataSourceInterface data) {
        boolean valid = super.attachData(data);
        if (valid && this.dataSource != null) {
            this.acquireVariables();
            this._connectNetwork();
            if (data instanceof ContentsChangedSource) {
                ((ContentsChangedSource)data).addContentsChangedListener((ContentsChangedListener)this.dataSourceContentsChangedListener);
            }
            this.invalidateGraphics();
            this.rerender();
            return true;
        }
        this.doNotUseDataSourceValues();
        return false;
    }

    @Override
    protected void acquireVariables() {
        super.acquireVariables();
        DataSourceInterface dataSource = this.getDataSource();
        if (dataSource != null) {
            Variable projectLevel;
            Variable wbscode;
            this.newResponseAxisVariable(EARLYSTART);
            this.newResponseAxisVariable(EARLYFINISH);
            this.newResponseAxisVariable(LATESTART);
            this.newResponseAxisVariable(LATEFINISH);
            this.newResponseAxisVariable(ACTUALSTART);
            this.newResponseAxisVariable(ACTUALFINISH);
            this.newResponseAxisVariable(RESOURCESTART);
            this.newResponseAxisVariable(RESOURCEFINISH);
            this.newResponseAxisVariable(BASELINESTART);
            this.newResponseAxisVariable(BASELINEFINISH);
            Variable summary = dataSource.getVtkVariable(SUMMARY);
            if (summary instanceof NumericVariable) {
                this.setAnalysisVariable(SUMMARY, summary);
            }
            if ((wbscode = dataSource.getVtkVariable(WBSCODE)) instanceof StringVariable) {
                this.setAnalysisVariable(WBSCODE, wbscode);
            }
            if ((projectLevel = dataSource.getVtkVariable(PROJECTLEVEL)) instanceof NumericVariable) {
                this.setAnalysisVariable(PROJECTLEVEL, projectLevel);
            }
            this._createAnalysisVariableFormatter(EARLYSTART);
            this._createAnalysisVariableFormatter(EARLYFINISH);
            this._createAnalysisVariableFormatter(LATESTART);
            this._createAnalysisVariableFormatter(LATEFINISH);
            this._createAnalysisVariableFormatter(ACTUALSTART);
            this._createAnalysisVariableFormatter(ACTUALFINISH);
            this._createAnalysisVariableFormatter(RESOURCESTART);
            this._createAnalysisVariableFormatter(RESOURCEFINISH);
            this._createAnalysisVariableFormatter(BASELINESTART);
            this._createAnalysisVariableFormatter(BASELINEFINISH);
            this.setRange(DEPENDENT_AXIS, this.dependentAxisRanger.getRange());
        }
    }

    @Override
    protected void detachData() {
        this._disconnectNetwork();
        this.doNotUseDataSourceValues();
        DataSourceInterface data = this.getDataSource();
        if (data instanceof ContentsChangedSource) {
            ((ContentsChangedSource)data).removeContentsChangedListener((ContentsChangedListener)this.dataSourceContentsChangedListener);
        }
        super.detachData();
        this.invalidateGraphics();
        this.rerender();
    }

    @Override
    protected void doNotUseDataSourceValues() {
        super.doNotUseDataSourceValues();
        this.setAnalysisVariable(OverlayInterface.VariableRoles.EARLYSTART, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.EARLYFINISH, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.LATESTART, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.LATEFINISH, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.ACTUALSTART, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.ACTUALFINISH, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.RESOURCESTART, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.RESOURCEFINISH, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.BASELINESTART, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.BASELINEFINISH, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.SUMMARY, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.WBSCODE, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.PROJECTLEVEL, null);
        this.analysisVariableFormatters.clear();
    }

    private void _createAnalysisVariableFormatter(Object id) {
        Variable variable = this.getAnalysisVariable(id);
        if (variable instanceof NumericVariable) {
            NumericPipedFormat variableValueFormatter = new NumericPipedFormat();
            variableValueFormatter.input.connectFrom(((NumericVariable)variable).value);
            variableValueFormatter.setFormat(this.vtkFormat);
            this.analysisVariableFormatters.put(id, variableValueFormatter);
        } else if (variable instanceof StringVariable) {
            StringPipedFormat variableValueFormatter = new StringPipedFormat();
            variableValueFormatter.input.connectFrom(((StringVariable)variable).value);
            this.analysisVariableFormatters.put(id, variableValueFormatter);
        }
    }

    private class DataSourceContentsChangedListener
    implements ContentsChangedListener {
        private DataSourceContentsChangedListener() {
        }

        public void contentsChanged(ContentsChangedEvent event) {
            GanttOverlay.this._disconnectNetwork();
            GanttOverlay.this.doNotUseDataSourceValues();
            GanttOverlay.this.acquireVariables();
            GanttOverlay.this._connectNetwork();
            GanttOverlay.this.invalidateGraphics();
            GanttOverlay.this.rerender();
        }
    }
}

