/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.MissingValues;
import com.sas.graphics.chart.util.ctk.DataSource;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.table.TableException;
import java.applet.Applet;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;

public class FlatFileDataSource
extends DataSource {
    protected StaticRowTemplateTableInterface data;
    protected int indexOffset = 0;
    protected String codeBase;
    protected String documentBase;

    public void zeroBasedIndexing() {
        this.indexOffset = 1;
    }

    public void oneBasedIndexing() {
        this.indexOffset = 1;
    }

    public void setApplet(Applet applet) {
        if (applet != null) {
            this.documentBase = applet.getDocumentBase().toString();
            int index = this.documentBase.lastIndexOf("/");
            if (index != -1) {
                this.documentBase = this.documentBase.substring(0, index + 1);
            }
            this.codeBase = applet.getCodeBase().toString();
            if ((this.codeBase.indexOf(".zip") != -1 || this.codeBase.indexOf(".jar") != -1) && (index = this.codeBase.lastIndexOf("/")) != -1) {
                this.codeBase = this.codeBase.substring(0, index + 1);
            }
        } else {
            this.codeBase = null;
            this.documentBase = null;
        }
    }

    public SimpleDataTable openFlatFile(String urlString) {
        block7: {
            if (this.data != null) {
                return null;
            }
            String myUrlString = urlString;
            try {
                FlatFileReader ffr = new FlatFileReader(myUrlString);
                this.setDataSource(ffr.getDataTable());
            }
            catch (Exception e1) {
                if (this.documentBase == null) break block7;
                myUrlString = this.documentBase + urlString;
                try {
                    FlatFileReader ffr = new FlatFileReader(myUrlString);
                    this.setDataSource(ffr.getDataTable());
                }
                catch (Exception e2) {
                    if (this.codeBase == null) break block7;
                    myUrlString = this.codeBase + urlString;
                    try {
                        FlatFileReader ffr = new FlatFileReader(myUrlString);
                        this.setDataSource(ffr.getDataTable());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return (SimpleDataTable)this.data;
    }

    public SimpleDataTable openFlatFile(String urlString, String delim) {
        block7: {
            System.out.println("");
            System.out.println("openFlatFile::myUrlString,delim");
            if (this.data != null) {
                return null;
            }
            String myUrlString = urlString;
            try {
                System.out.println("              " + myUrlString);
                FlatFileReader ffr = new FlatFileReader(myUrlString, delim);
                this.setDataSource(ffr.getDataTable());
            }
            catch (Exception e1) {
                if (this.documentBase == null) break block7;
                myUrlString = this.documentBase + urlString;
                try {
                    System.out.println("              " + myUrlString);
                    FlatFileReader ffr = new FlatFileReader(myUrlString, delim);
                    this.setDataSource(ffr.getDataTable());
                }
                catch (Exception e2) {
                    if (this.codeBase == null) break block7;
                    myUrlString = this.codeBase + urlString;
                    try {
                        System.out.println("              " + myUrlString);
                        FlatFileReader ffr = new FlatFileReader(myUrlString, delim);
                        this.setDataSource(ffr.getDataTable());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return (SimpleDataTable)this.data;
    }

    public SimpleDataTable openFlatFile(String urlString, String delim, Component component) {
        block7: {
            if (this.data != null) {
                return null;
            }
            String myUrlString = urlString;
            try {
                FlatFileReader ffr = new FlatFileReader(myUrlString, delim, component);
                this.setDataSource(ffr.getDataTable());
            }
            catch (Exception e1) {
                if (this.documentBase == null) break block7;
                myUrlString = this.documentBase + urlString;
                try {
                    FlatFileReader ffr = new FlatFileReader(myUrlString, delim, component);
                    this.setDataSource(ffr.getDataTable());
                }
                catch (Exception e2) {
                    if (this.codeBase == null) break block7;
                    myUrlString = this.codeBase + urlString;
                    try {
                        FlatFileReader ffr = new FlatFileReader(myUrlString, delim, component);
                        this.setDataSource(ffr.getDataTable());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return (SimpleDataTable)this.data;
    }

    @Override
    public synchronized boolean setDataSource(StaticRowTemplateTableInterface newData) {
        this.data = newData;
        return super.setDataSource(newData);
    }

    public static class FlatFileReader {
        public static final String vtkStringType = "STRING";
        public static final String vtkNumericType = "NUMERIC";
        String delimiters;
        BufferedReader reader;
        String[] DataNames;
        Class[] DataTypes;
        String[][] DataTable;

        public FlatFileReader(String urlString) throws IOException {
            this(urlString, null);
        }

        public FlatFileReader(String urlString, String delim) throws IOException {
            this(urlString, delim, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FlatFileReader(String urlString, String delim, Component component) throws IOException {
            this.delimiters = delim;
            try {
                URL url = new URL(urlString);
                URLConnection connection = Authenticator.openConnection(url, component);
                InputStream is = connection.getInputStream();
                this.reader = new BufferedReader(new InputStreamReader(is));
            }
            catch (MalformedURLException e) {
                File file = new File(urlString);
                if (file.exists() && file.isFile() && file.canRead()) {
                    this.reader = new BufferedReader(new FileReader(file));
                }
            }
            finally {
                if (this.reader == null) {
                    throw new IOException();
                }
                this.loadDataTableArrays();
            }
        }

        private String getNextLine() throws IOException {
            return this.reader.readLine();
        }

        private String[] parseString(String s) {
            StringTokenizer tok = this.delimiters != null ? new StringTokenizer(s, this.delimiters) : new StringTokenizer(s);
            int numberOfTokens = tok.countTokens();
            String[] ps = null;
            if (numberOfTokens > 0) {
                ps = new String[numberOfTokens];
            }
            for (int i = 0; i < numberOfTokens; ++i) {
                ps[i] = tok.nextToken().trim();
                if (!ps[i].equals(".")) continue;
                ps[i] = null;
            }
            return ps;
        }

        private void loadDataTableArrays() throws IOException {
            String temp;
            String[] ps = null;
            boolean notDone = true;
            while (notDone) {
                temp = this.getNextLine();
                if (temp == null) continue;
                this.DataNames = this.parseString(temp);
                notDone = false;
            }
            notDone = true;
            while (notDone) {
                temp = this.getNextLine();
                if (temp == null) continue;
                ps = this.parseString(temp);
                this.DataTypes = new Class[ps.length];
                notDone = false;
            }
            for (int i = 0; i < ps.length; ++i) {
                String type = ps[i].toUpperCase();
                this.DataTypes[i] = type.equals(vtkNumericType) ? Double.class : String.class;
            }
            Vector<String[]> rowVector = new Vector<String[]>();
            String row = this.getNextLine();
            while (row != null) {
                ps = this.parseString(row);
                if (ps != null) {
                    rowVector.addElement(ps);
                }
                row = this.getNextLine();
            }
            this.DataTable = new String[rowVector.size()][];
            rowVector.copyInto((Object[])this.DataTable);
        }

        public SimpleDataTable getDataTable() {
            if (this.DataTable == null || this.DataNames == null || this.DataTypes == null) {
                return null;
            }
            SimpleDataTable data = new SimpleDataTable(this.DataTable, this.DataNames, this.DataTypes);
            return data;
        }
    }

    public static class SimpleDataTable
    implements StaticRowTemplateTableInterface,
    StaticColumnLabelInterface {
        protected Object[][] table;
        protected String[] names;
        protected Class[] types;

        public SimpleDataTable(String[][] tableIn, String[] namesIn, Class[] typesIn) {
            int rowCount = tableIn.length;
            int columnCount = rowCount > 0 ? tableIn[0].length : 0;
            this.table = new Object[rowCount][columnCount];
            this.names = new String[columnCount];
            this.types = new Class[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                int j;
                this.names[i] = namesIn[i];
                this.types[i] = typesIn[i];
                if (typesIn[i] == Double.class) {
                    for (j = 0; j < rowCount; ++j) {
                        this.table[j][i] = tableIn[j][i] != null ? new Double(tableIn[j][i]) : MissingValues.N;
                    }
                    continue;
                }
                for (j = 0; j < rowCount; ++j) {
                    this.table[j][i] = tableIn[j][i] != null ? tableIn[j][i] : MissingValues.S;
                }
            }
        }

        protected SimpleDataTable(int rows, int columns) {
            this.names = new String[columns];
            this.types = new Class[columns];
            this.table = new Object[rows][columns];
        }

        protected void setColumnType(int columnIndex, Class columnType) {
            this.types[columnIndex - 1] = columnType;
        }

        public int getColumnCount() {
            return this.names.length;
        }

        public int getRowCount() {
            return this.table.length;
        }

        public boolean isColumnLabelsSupported() throws TableException {
            return true;
        }

        public boolean isColumnsLabelSupported() throws TableException {
            return false;
        }

        public boolean isRowLabelsSupported() {
            return false;
        }

        public Class getLabelType() {
            Class<?> cArray = this.names.getClass();
            Class<?> cComponent = cArray.getComponentType();
            return cComponent;
        }

        public Class getColumnClass(int columnIndex) throws TableException {
            if (columnIndex > 0 && columnIndex <= this.types.length) {
                return this.types[columnIndex - 1];
            }
            return null;
        }

        public Class[] getColumnClasses(int startIndex, int count) throws TableException {
            Class[] result = new Class[count];
            int si = startIndex - 1;
            for (int i = 0; i < count; ++i) {
                result[i] = this.types[si + i];
            }
            return result;
        }

        public Object getColumnLabel(int index) throws TableException {
            if (index > 0 && index <= this.names.length) {
                return this.names[index - 1];
            }
            return null;
        }

        public Object[] getColumnLabels(int startIndex, int count) throws TableException {
            Object[] result = new Object[count];
            int si = startIndex - 1;
            for (int i = 0; i < count; ++i) {
                result[i] = this.names[si + i];
            }
            return result;
        }

        public void setColumnLabel(int columnIndex, Object data) {
            if (columnIndex > 0 && columnIndex <= this.names.length) {
                this.names[columnIndex - 1] = (String)data;
            }
        }

        public Object getRowLabel(int rowIndex) {
            return " ";
        }

        public void setRowLabel(int rowIndex, Object data) {
        }

        public Object getCell(int rowIndex, int columnIndex) throws TableException {
            return this.table[rowIndex - 1][columnIndex - 1];
        }

        public Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
            Object[][] result = new Object[rowCount][columnCount];
            int sri = startRowIndex - 1;
            int sci = startColumnIndex - 1;
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < columnCount; ++c) {
                    result[r][c] = this.table[sri + r][sci + c];
                }
            }
            return result;
        }

        public Object[] getRow(int index) throws TableException {
            return this.table[index - 1];
        }

        public Object[] getColumn(int index) throws TableException {
            Object[] result = new Object[this.table.length];
            for (int i = 0; i < this.table.length; ++i) {
                result[i] = this.table[i][index - 1];
            }
            return result;
        }

        public int countColumns(int maxCount) throws TableException {
            return this.getColumnCount();
        }

        public int countRows(int maxCount) throws TableException {
            return this.getRowCount();
        }

        public Class getCellClass(int rowIndex, int columnIndex) throws TableException {
            return this.types[columnIndex - 1];
        }

        public Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
            Class[][] result = new Class[rowCount][columnCount];
            int sci = startColumnIndex - 1;
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < columnCount; ++c) {
                    result[r][c] = this.types[sci + c];
                }
            }
            return result;
        }

        public void setCell(int rowIndex, int columnIndex, Object data) {
            if (data.getClass() == this.types[columnIndex - 1]) {
                this.table[rowIndex - 1][columnIndex - 1] = data;
            }
        }

        public void deleteColumn(int columnIndex) {
        }

        public void deleteRow(int rowIndex) {
        }

        public void addColumn(int columnIndex, Object label, Class type) {
        }
    }

    public static class Authenticator {
        public static URLConnection openConnection(URL url, Component component) throws IOException {
            URLConnection connection = null;
            String encoding = null;
            connection = url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.connect();
            InputStream stream = connection.getInputStream();
            boolean auth = Authenticator.requiresAuthetication(stream);
            if (auth) {
                // empty if block
            }
            connection = null;
            connection = url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(false);
            if (auth) {
                connection.setRequestProperty("Authorization", "Basic " + encoding);
            }
            connection.connect();
            connection.getInputStream();
            return connection;
        }

        public static boolean requiresAuthetication(InputStream stream) throws IOException {
            boolean result = false;
            byte[] b = new byte[200];
            try {
                if (stream.markSupported()) {
                    stream.mark(201);
                }
                stream.read(b);
                if (stream.markSupported()) {
                    stream.reset();
                }
            }
            catch (IOException e) {
                return true;
            }
            String s = new String(b);
            if (s.indexOf("401 Authorization Required") != -1) {
                result = true;
            }
            return result;
        }
    }
}

