/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.DataParam;
import com.sas.graphics.chart.util.ctk.DataSourceInterface;
import com.sas.graphics.chart.util.ctk.DataSourceProbeInterface;
import com.sas.graphics.chart.util.ctk.vtk.Point2;
import com.sas.graphics.util.FontManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class DataSourceProbe
implements DataSourceProbeInterface {
    private static Insets DEFAULT_INSETS = new Insets(4, 4, 4, 4);
    private Font font = FontManager.getDefaultFont();
    private Color backgroundColor = Color.yellow.darker();
    private Color foregroundColor = Color.black;
    private Rectangle viewport;
    protected Insets insets = DEFAULT_INSETS;
    protected String title;
    protected int textBuffer;
    protected Integer orientation;
    protected Integer displacement;
    protected Integer xDisplacement;
    protected Integer yDisplacement;
    protected Point2[] highlightPoints;
    protected Color highlightColor;
    protected String[] substitutionStrings;
    protected DataSourceInterface dataSource;

    DataSourceProbe() {
    }

    DataSourceProbe(DataSourceInterface ds, String[] subStrs) {
        this.dataSource = ds;
        this.substitutionStrings = subStrs;
    }

    @Override
    public void setDataSource(DataSourceInterface ds) {
        this.dataSource = ds;
    }

    @Override
    public DataSourceInterface getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setSubstitutionStrings(String[] subStrs) {
        this.substitutionStrings = subStrs;
    }

    @Override
    public String[] getSubstitutionStrings() {
        return this.substitutionStrings;
    }

    @Override
    public void setTitle(String t) {
        this.title = t;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setViewport(int x, int y, Dimension dimension) {
        this.setViewport(x, y, dimension.width, dimension.height);
    }

    @Override
    public void setViewport(int x, int y, int width, int height) {
        if (this.viewport == null) {
            this.viewport = new Rectangle();
        }
        this.viewport.x = x;
        this.viewport.y = y;
        this.viewport.width = width;
        this.viewport.height = height;
    }

    @Override
    public Rectangle getViewport() {
        return this.viewport;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.setViewport(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public Rectangle getBounds() {
        return this.getViewport();
    }

    @Override
    public void setFont(Font aFont) {
        this.font = aFont != null ? aFont : FontManager.getDefaultFont();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.backgroundColor = color != null ? color : Color.yellow.darker();
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setForegroundColor(Color color) {
        this.foregroundColor = color != null ? color : Color.black;
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public void setInsets(Insets i) {
        this.insets = i == null ? DEFAULT_INSETS : i;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void setTextBuffer(int number_of_pixels) {
        this.textBuffer = Math.max(0, number_of_pixels);
    }

    @Override
    public int getTextBuffer() {
        return this.textBuffer;
    }

    @Override
    public void setOrientation(int orientation) {
        this.orientation = null;
        switch (orientation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.orientation = new Integer(orientation);
            }
        }
    }

    @Override
    public int getOrientation() {
        return this.orientation == null ? 0 : this.orientation;
    }

    @Override
    public void setDisplacement(int displacement) {
        this.displacement = displacement >= 0 ? new Integer(displacement) : null;
    }

    @Override
    public int getDisplacement() {
        return this.displacement == null ? 50 : this.displacement;
    }

    @Override
    public void setXDisplacement(int displacement) {
        this.xDisplacement = displacement >= 0 ? new Integer(displacement) : null;
    }

    @Override
    public int getXDisplacement() {
        return this.xDisplacement == null ? this.getDisplacement() : this.xDisplacement.intValue();
    }

    @Override
    public void setYDisplacement(int displacement) {
        this.yDisplacement = displacement >= 0 ? new Integer(displacement) : null;
    }

    @Override
    public int getYDisplacement() {
        return this.yDisplacement == null ? this.getDisplacement() : this.yDisplacement.intValue();
    }

    @Override
    public void setHighlightOutline(Point2[] pt) {
        this.highlightPoints = pt;
    }

    @Override
    public Point2[] getHighlightOutline() {
        return this.highlightPoints;
    }

    @Override
    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    @Override
    public Color getHighlightColor() {
        return this.highlightColor == null ? Color.yellow : this.highlightColor;
    }

    @Override
    public void draw(Graphics gc, int x, int y, int valueIndex) {
        int width;
        Font font;
        if (this.substitutionStrings == null || this.dataSource == null) {
            return;
        }
        int size = this.substitutionStrings.length;
        int maxStringWidth = 0;
        if (this.insets == null) {
            this.insets = DEFAULT_INSETS;
        }
        FontMetrics fontMetrics = (font = this.getFont()) == null ? gc.getFontMetrics() : gc.getFontMetrics(font);
        int textHeight = fontMetrics.getHeight();
        int ascent = fontMetrics.getAscent();
        int textBuff = this.getTextBuffer();
        int pos = y + this.insets.top + (textHeight + textBuff) * size - textBuff + this.insets.bottom;
        String[] strings = new String[size];
        for (int ii = 0; ii < size; ++ii) {
            strings[ii] = DataParam.doSubstitution(this.substitutionStrings[ii], valueIndex, this.dataSource);
            width = fontMetrics.stringWidth(strings[ii]);
            if (width <= maxStringWidth) continue;
            maxStringWidth = width;
        }
        int llX = x;
        int llY = y;
        int xAdjust = this.getXDisplacement();
        int yAdjust = this.getYDisplacement();
        width = this.insets.left + maxStringWidth + this.insets.right;
        int height = pos - y;
        Rectangle viewport = this.getBounds();
        int orientation = this.getOrientation();
        int in = 1;
        switch (orientation) {
            case 2: 
            case 4: 
            case 6: {
                llX = x + xAdjust;
                if (viewport == null || viewport.x + viewport.width >= llX + width + in || (llX = x - width - xAdjust) >= viewport.x + in) break;
                llX = viewport.x + in;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                llX = x - width - xAdjust;
                if (viewport == null || llX >= viewport.x + in || viewport.x + viewport.width >= (llX = x + xAdjust) + width + in) break;
                llX = viewport.x + in;
                break;
            }
            case 0: 
            case 1: {
                llX = x - width / 2;
                if (viewport == null) break;
                if (viewport.x + viewport.width < llX + width + in) {
                    llX = viewport.x + viewport.width - width - in;
                }
                if (llX >= viewport.x + in) break;
                llX = viewport.x + in;
            }
        }
        switch (orientation) {
            case 0: 
            case 4: 
            case 5: {
                llY = y - height - yAdjust;
                if (viewport == null || viewport.y + in <= llY || viewport.y + viewport.height - 4 >= (llY = y + yAdjust) + height) break;
                llY = viewport.y + in;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                llY = y + yAdjust;
                if (viewport == null || viewport.y + viewport.height - 4 >= llY + height || viewport.y + in <= (llY = y - height - yAdjust)) break;
                llY = viewport.y + viewport.height - 4 - height;
                break;
            }
            case 2: 
            case 3: {
                llY = y - height / 2;
                if (viewport == null) break;
                if (viewport.y + viewport.height - 4 < llY + height) {
                    llY = viewport.y + viewport.height - 4 - height;
                }
                if (viewport.y + in <= llY) break;
                llY = viewport.y + in;
            }
        }
        if (this.highlightPoints != null && this.highlightPoints.length > 1) {
            gc.setColor(this.getHighlightColor());
            for (int ii = 1; ii < this.highlightPoints.length; ++ii) {
                gc.drawLine((int)this.highlightPoints[ii - 1].x, (int)this.highlightPoints[ii - 1].y, (int)this.highlightPoints[ii].x, (int)this.highlightPoints[ii].y);
            }
        } else {
            gc.setColor(this.getBackgroundColor());
            gc.drawLine(x, y, llX + width / 2, llY + height / 2);
            gc.setColor(this.getForegroundColor());
            gc.drawLine(x + 1, y + 1, llX + width / 2 + 1, llY + height / 2 + 1);
        }
        gc.setColor(this.getBackgroundColor());
        gc.fillRect(llX, llY, width, height);
        gc.setColor(this.getForegroundColor());
        gc.drawRect(llX, llY, width, height);
        pos = llY + ascent + this.insets.top;
        Font oldFont = gc.getFont();
        gc.setFont(font);
        for (int ii = 0; ii < size; ++ii) {
            gc.drawString(strings[ii], llX + this.insets.left, pos);
            pos += textHeight + textBuff;
        }
        gc.setFont(oldFont);
    }
}

