/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.beans.PropertyChangeSource;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.ContentsChangedSource;
import com.sas.graphics.chart.util.ctk.AnalysisVariableDefinition;
import com.sas.graphics.chart.util.ctk.AnalysisVariableDefinitionInterface;
import com.sas.graphics.chart.util.ctk.ClassifierVariableDefinition;
import com.sas.graphics.chart.util.ctk.ClassifierVariableDefinitionInterface;
import com.sas.graphics.chart.util.ctk.DataSourceInterface;
import com.sas.graphics.chart.util.ctk.DateStaticTableVariable;
import com.sas.graphics.chart.util.ctk.VariableDefinition;
import com.sas.graphics.chart.util.ctk.VariableDefinitionInterface;
import com.sas.graphics.chart.util.ctk.vtkDateFormatJoeHack;
import com.sas.graphics.util.vtk.Categorizer;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.NumericStaticTableVariable;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.StringStaticTableVariable;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.VTKFormat;
import com.sas.graphics.util.vtk.VTKRuntimeException;
import com.sas.graphics.util.vtk.Variable;
import com.sas.graphics.util.vtk.VariableException;
import com.sas.graphics.util.vtk.VariableProcessor;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.table.CellChangedEvent;
import com.sas.table.CellVectorChangedEvent;
import com.sas.table.ColumnChangedEvent;
import com.sas.table.ColumnLabelChangedEvent;
import com.sas.table.DataCellChangedEvent;
import com.sas.table.RowChangedEvent;
import com.sas.table.RowLabelChangedEvent;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.table.TableException;
import com.sas.text.SASFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DataSource
implements DataSourceInterface,
ContentsChangedSource {
    protected StaticRowTemplateTableInterface staticTableDataModel;
    protected String[] cachedVariableNames;
    protected VariableProcessor variableProcessor;
    protected Categorizer categorizer;
    protected Hashtable variableDefinitions = new Hashtable();
    protected Hashtable vtkVariables = new Hashtable();
    private boolean statisticsEnabled = true;
    private VariableDefListener variableDefListener;
    private StaticTableListener staticTableListener;
    private boolean cacheStateValid = false;
    private boolean dataCachingEnabled = false;
    private ContentsChangedListenerList contentsChangedListeners;
    private int contentsChagedEventGate = 0;
    private boolean contentsChangedEventPending = false;
    static int dd = 0;

    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.contentsChangedListeners == null) {
            this.contentsChangedListeners = new ContentsChangedListenerList();
        }
        this.contentsChangedListeners.add(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.contentsChangedListeners != null) {
            this.contentsChangedListeners.remove(listener);
        }
    }

    protected void fireContentsChanged() {
        this.fireContentsChanged(null);
    }

    protected void fireContentsChanged(ContentsChangedEvent event) {
        this.contentsChangedEventPending = true;
        if (this.contentsChagedEventGate > 0) {
            return;
        }
        this.contentsChangedEventPending = false;
        if (event == null) {
            event = new ContentsChangedEvent((Object)this);
        }
        if (this.contentsChangedListeners != null) {
            this.contentsChangedListeners.contentsChanged(event);
        }
    }

    protected boolean anyContentsChangedListeners() {
        return this.contentsChagedEventGate == 0 && this.contentsChangedListeners != null && this.contentsChangedListeners.count() > 0;
    }

    @Override
    public void disableEvents() {
        ++this.contentsChagedEventGate;
    }

    @Override
    public synchronized void enableEvents() {
        this._enableEvents(true);
    }

    public synchronized void enableEvents(boolean firePendingEvent) {
        this._enableEvents(firePendingEvent);
    }

    private void _enableEvents(boolean firePendingEvent) {
        if (this.contentsChagedEventGate > 0) {
            --this.contentsChagedEventGate;
            if (this.anyContentsChangedListeners() && this.contentsChangedEventPending) {
                this.contentsChangedEventPending = false;
                if (firePendingEvent) {
                    this.fireContentsChanged();
                }
            }
        }
    }

    public synchronized void enableEvents(ContentsChangedEvent event) {
        if (this.contentsChagedEventGate > 0) {
            --this.contentsChagedEventGate;
            if (event != null && this.anyContentsChangedListeners()) {
                this.contentsChangedEventPending = false;
                this.fireContentsChanged(event);
            }
        }
    }

    public DataSource() {
        this.variableProcessor = new VariableProcessor();
        this.categorizer = new Categorizer();
        this.variableDefListener = new VariableDefListener();
        this.staticTableListener = new StaticTableListener();
    }

    public DataSource(StaticRowTemplateTableInterface data) {
        this();
        this.setDataSource(data);
    }

    @Override
    public final VariableDefinitionInterface setClassifierVariable(Object role, String variableName) {
        ClassifierVariableDefinition varDef = new ClassifierVariableDefinition();
        varDef.setName(variableName);
        return this.setVariable(role, varDef);
    }

    @Override
    public final VariableDefinitionInterface setAnalysisVariable(Object role, String variableName) {
        AnalysisVariableDefinition varDef = new AnalysisVariableDefinition();
        varDef.setName(variableName);
        return this.setVariable(role, varDef);
    }

    @Override
    public final VariableDefinitionInterface setClassifierVariable(Object role, int index) {
        ClassifierVariableDefinition varDef = new ClassifierVariableDefinition();
        varDef.setIndex(new Integer(index));
        return this.setVariable(role, varDef);
    }

    @Override
    public final VariableDefinitionInterface setAnalysisVariable(Object role, int index) {
        AnalysisVariableDefinition varDef = new AnalysisVariableDefinition();
        varDef.setIndex(new Integer(index));
        return this.setVariable(role, varDef);
    }

    @Override
    public synchronized VariableDefinitionInterface getVariable(Object role) {
        return role == null ? null : (VariableDefinitionInterface)this.variableDefinitions.get(role);
    }

    @Override
    public synchronized VariableDefinitionInterface setVariable(Object role, VariableDefinitionInterface varDef) {
        Variable oldVtkVariable = null;
        Variable newVtkVariable = null;
        if (role != null) {
            VariableDefinitionInterface oldVarDef = (VariableDefinitionInterface)this.variableDefinitions.remove(role);
            if (oldVarDef instanceof PropertyChangeSource) {
                oldVarDef.removePropertyChangeListener(this.variableDefListener);
            }
            if (oldVarDef instanceof ClassifierVariableDefinitionInterface) {
                oldVtkVariable = this._destroyVtkVar((ClassifierVariableDefinitionInterface)oldVarDef);
            } else if (oldVarDef instanceof AnalysisVariableDefinitionInterface) {
                oldVtkVariable = this._destroyVtkVar((AnalysisVariableDefinitionInterface)oldVarDef);
            }
            if (varDef != null) {
                this.variableDefinitions.put(role, varDef);
                if (varDef instanceof PropertyChangeSource) {
                    varDef.addPropertyChangeListener(this.variableDefListener);
                }
                if (varDef instanceof ClassifierVariableDefinitionInterface) {
                    newVtkVariable = this._createVtkVar((ClassifierVariableDefinitionInterface)varDef);
                } else if (varDef instanceof AnalysisVariableDefinitionInterface) {
                    newVtkVariable = this._createVtkVar((AnalysisVariableDefinitionInterface)varDef);
                }
            }
        }
        if (oldVtkVariable != null || newVtkVariable != null) {
            this.fireContentsChanged();
        }
        return varDef;
    }

    public synchronized void removeAllVariables() {
        boolean noticableChange = false;
        Vector vRoles = new Vector(5);
        Enumeration eRoles = this.variableDefinitions.keys();
        while (eRoles.hasMoreElements()) {
            vRoles.addElement(eRoles.nextElement());
        }
        int size = vRoles.size();
        for (int ii = 0; ii < size; ++ii) {
            noticableChange = this._removeVariable(vRoles.elementAt(ii)) | noticableChange;
        }
        if (noticableChange) {
            this.fireContentsChanged();
        }
    }

    @Override
    public synchronized void removeVariable(Object role) {
        if (this._removeVariable(role)) {
            this.fireContentsChanged();
        }
    }

    private boolean _removeVariable(Object role) {
        Variable oldVtkVariable = null;
        if (role != null) {
            VariableDefinitionInterface oldVarDef = (VariableDefinitionInterface)this.variableDefinitions.remove(role);
            if (oldVarDef instanceof PropertyChangeSource) {
                oldVarDef.removePropertyChangeListener(this.variableDefListener);
            }
            if (oldVarDef instanceof ClassifierVariableDefinitionInterface) {
                oldVtkVariable = this._destroyVtkVar((ClassifierVariableDefinitionInterface)oldVarDef);
            } else if (oldVarDef instanceof AnalysisVariableDefinitionInterface) {
                oldVtkVariable = this._destroyVtkVar((AnalysisVariableDefinitionInterface)oldVarDef);
            }
        }
        return oldVtkVariable != null;
    }

    @Override
    public Variable getVtkVariable(Object role) {
        VariableDefinitionInterface varDef;
        Variable vtkVariable = null;
        if (role != null && (varDef = (VariableDefinitionInterface)this.variableDefinitions.get(role)) != null && (vtkVariable = (Variable)this.vtkVariables.get(varDef)) != null && this.dataCachingEnabled && !this.cacheStateValid) {
            this._cacheData();
        }
        return vtkVariable;
    }

    @Override
    public String getColumnName(Object role) {
        VariableDefinitionInterface varDef = (VariableDefinitionInterface)this.variableDefinitions.get(role);
        if (varDef == null) {
            return null;
        }
        Variable vtkVariable = this._newVtkVar(varDef);
        return vtkVariable == null ? null : vtkVariable.getName();
    }

    @Override
    public void linkCategoryValues(DataSourceInterface d2) {
        if (d2 == null) {
            this.categorizer.linkTo(null);
        } else {
            this.categorizer.linkTo(d2.getCategorizer());
        }
    }

    @Override
    public Categorizer getCategorizer() {
        return this.categorizer;
    }

    @Override
    public IntegerPipe getCategoryPipe() {
        return this.categorizer.category;
    }

    public void setStatisticsEnabled(boolean aBoolean) {
        if (this.statisticsEnabled != aBoolean) {
            this.statisticsEnabled = aBoolean;
            int classifierCount = this.categorizer.getVariableCount();
            if (classifierCount > 0) {
                if (this.statisticsEnabled) {
                    for (int ii = 0; ii < classifierCount; ++ii) {
                        Variable vtkVariable = this.categorizer.getVariableAt(ii);
                        this.variableProcessor.removeVariable(vtkVariable);
                        this.variableProcessor.addGroupVariable(vtkVariable);
                    }
                } else {
                    for (int ii = 0; ii < classifierCount; ++ii) {
                        Variable vtkVariable = this.categorizer.getVariableAt(ii);
                        this.variableProcessor.removeVariable(vtkVariable);
                        this.variableProcessor.addVariable(vtkVariable);
                    }
                }
                this.fireContentsChanged();
            }
        }
    }

    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    private Variable _destroyVtkVar(ClassifierVariableDefinitionInterface varDef) {
        Variable v = (Variable)this.vtkVariables.remove(varDef);
        if (v != null) {
            this.categorizer.removeVariable(v);
            this.variableProcessor.removeVariable(v);
        }
        return v;
    }

    private Variable _destroyVtkVar(AnalysisVariableDefinitionInterface varDef) {
        Variable v = (Variable)this.vtkVariables.remove(varDef);
        if (v != null) {
            this.variableProcessor.removeVariable(v);
        }
        return v;
    }

    private Variable _createVtkVar(ClassifierVariableDefinitionInterface varDef) {
        this._destroyVtkVar(varDef);
        Variable vtkVariable = this._createVtkVar((VariableDefinitionInterface)varDef);
        if (vtkVariable != null) {
            this.categorizer.addVariable(vtkVariable);
            if (this.statisticsEnabled) {
                this.variableProcessor.addGroupVariable(vtkVariable);
            } else {
                this.variableProcessor.addVariable(vtkVariable);
            }
            this.cacheStateValid = false;
        }
        return vtkVariable;
    }

    private Variable _createVtkVar(AnalysisVariableDefinitionInterface varDef) {
        this._destroyVtkVar(varDef);
        Variable vtkVariable = this._createVtkVar((VariableDefinitionInterface)varDef);
        if (vtkVariable != null) {
            this._applyStatistic(varDef, vtkVariable);
            this.cacheStateValid = false;
        }
        return vtkVariable;
    }

    public boolean columnExists(VariableDefinitionInterface varDef) {
        return this._newVtkVar(varDef) != null;
    }

    private Variable _newVtkVar(VariableDefinitionInterface varDef) {
        if (this.cachedVariableNames == null || this.cachedVariableNames.length == 0) {
            return null;
        }
        Variable vtkVariable = null;
        if (varDef != null && this.staticTableDataModel != null) {
            String label;
            Integer index;
            String informat = varDef.getInformat();
            boolean dateType = "date".equalsIgnoreCase(informat) || "ddMMM".equalsIgnoreCase(informat) || "ddMMMyy".equalsIgnoreCase(informat) || "ddMMMyyyy".equalsIgnoreCase(informat);
            String name = varDef.getName();
            if (name != null && (name = this.getColumnName(name)) != null) {
                int _index = this.indexOf(name);
                if (dateType) {
                    vtkVariable = this.newDateVariable(_index);
                }
                if (vtkVariable == null) {
                    vtkVariable = this.newVariable(_index);
                }
            }
            if (vtkVariable == null && (index = varDef.getIndex()) != null) {
                vtkVariable = dateType ? this.newDateVariable(index) : this.newVariable(index);
            }
            if (vtkVariable != null || (label = varDef.getLabel()) != null) {
                // empty if block
            }
        }
        return vtkVariable;
    }

    private Variable _createVtkVar(VariableDefinitionInterface varDef) {
        Variable vtkVariable = this._newVtkVar(varDef);
        if (vtkVariable != null) {
            if (varDef instanceof VariableDefinition) {
                ((VariableDefinition)varDef).setColumnName(vtkVariable.getName());
            }
            this.vtkVariables.put(varDef, vtkVariable);
            if (varDef.getUserLabel() != null) {
                this._applyUserLabel(varDef, vtkVariable);
            }
            if (varDef.getFormat() != null) {
                this._applyFormat(varDef, vtkVariable);
            }
        }
        return vtkVariable;
    }

    private String _applyUserLabel(VariableDefinitionInterface varDef, Variable vtkVariable) {
        String userLabel = null;
        if (varDef != null && vtkVariable != null) {
            userLabel = varDef.getUserLabel();
            if (userLabel != null) {
                vtkVariable.setName(userLabel);
            } else if (varDef instanceof VariableDefinition) {
                vtkVariable.setName(((VariableDefinition)varDef).getColumnName());
            }
        }
        return userLabel;
    }

    private int _applyStatistic(AnalysisVariableDefinitionInterface varDef, Variable vtkVariable) {
        Integer statisticID = varDef.getStatistic();
        int statValue = statisticID != null ? statisticID : 6;
        this.variableProcessor.addVariable(vtkVariable, statValue);
        return statValue;
    }

    private VTKFormat _applyFormat(VariableDefinitionInterface varDef, Variable vtkVariable) {
        String formatPattern;
        VTKFormat vtkFormat = null;
        if (varDef != null && vtkVariable != null && (formatPattern = varDef.getFormat()) != null && (vtkFormat = "Date9".equalsIgnoreCase(formatPattern) ? new vtkDateFormatJoeHack("Date9") : new VTKFormat("{0}", new Format[]{SASFormat.getInstance((String)formatPattern)})) != null) {
            vtkVariable.setFormat(vtkFormat);
        }
        return vtkFormat;
    }

    public boolean cullVariables(String[] readVars) {
        if (this.staticTableDataModel instanceof DataSetInterface && this.cachedVariableNames != null && this.cachedVariableNames.length != 0) {
            ((DataSetInterface)this.staticTableDataModel).setDisplayedColumns(readVars);
            return true;
        }
        return false;
    }

    public synchronized boolean setDataSource(StaticRowTemplateTableInterface newData) {
        boolean rc = true;
        if (newData != this.staticTableDataModel) {
            if (!(newData == null || newData instanceof StaticRowTemplateTableInterface && newData instanceof StaticColumnLabelInterface)) {
                newData = null;
                rc = false;
            }
            if (this.staticTableDataModel instanceof ContentsChangedSource) {
                ((ContentsChangedSource)this.staticTableDataModel).removeContentsChangedListener((ContentsChangedListener)this.staticTableListener);
            }
            this.staticTableDataModel = newData;
            if (this.staticTableDataModel instanceof ContentsChangedSource) {
                ((ContentsChangedSource)this.staticTableDataModel).addContentsChangedListener((ContentsChangedListener)this.staticTableListener);
            }
            this.reset();
        }
        return rc;
    }

    public StaticRowTemplateTableInterface getDataSource() {
        return this.staticTableDataModel;
    }

    public void reset() {
        this.cachedVariableNames = this.getColumnNames();
        this.setWhereClause(null);
        if (this._reaquireVtkVariables()) {
            this.fireContentsChanged();
        }
    }

    public int size() {
        if (this.cachedVariableNames == null || this.cachedVariableNames.length == 0) {
            return 0;
        }
        try {
            return this.staticTableDataModel.getRowCount();
        }
        catch (TableException e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnName(String name) {
        if (this.cachedVariableNames == null || this.cachedVariableNames.length == 0) {
            return null;
        }
        if (this.staticTableDataModel != null) {
            String[] stringArray = this.cachedVariableNames;
            synchronized (this.cachedVariableNames) {
                int ii;
                for (ii = 0; ii < this.cachedVariableNames.length; ++ii) {
                    if (!this.cachedVariableNames[ii].equals(name)) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.cachedVariableNames[ii];
                }
                for (ii = 0; ii < this.cachedVariableNames.length; ++ii) {
                    if (!this.cachedVariableNames[ii].equalsIgnoreCase(name)) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.cachedVariableNames[ii];
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }
        return null;
    }

    protected Variable newVariable(String name) {
        try {
            StringVariable var = this.newStringVariable(name);
            return var != null ? var : this.newNumericVariable(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Variable newVariable(int index) {
        try {
            StringVariable var = this.newStringVariable(index);
            return var != null ? var : this.newNumericVariable(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringVariable newStringVariable(String name) {
        if (name == null || this.cachedVariableNames == null || this.cachedVariableNames.length == 0) {
            return null;
        }
        String[] stringArray = this.cachedVariableNames;
        synchronized (this.cachedVariableNames) {
            try {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.newStringVariable(this.indexOf(name));
            }
            catch (VariableException e) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringVariable newStringVariable(int index) {
        if (this.cachedVariableNames == null) {
            return null;
        }
        String[] stringArray = this.cachedVariableNames;
        synchronized (this.cachedVariableNames) {
            StringStaticTableVariable stringVariable = new StringStaticTableVariable();
            try {
                stringVariable.connectFrom(this.staticTableDataModel, index);
                stringVariable.setName(this.cachedVariableNames[index - 1]);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return stringVariable;
            }
            catch (VariableException e) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            catch (VTKRuntimeException e) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NumericVariable newNumericVariable(String name) {
        if (name == null || this.cachedVariableNames == null || this.cachedVariableNames.length == 0) {
            return null;
        }
        String[] stringArray = this.cachedVariableNames;
        synchronized (this.cachedVariableNames) {
            try {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.newNumericVariable(this.indexOf(name));
            }
            catch (VariableException e) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NumericVariable newNumericVariable(int index) {
        if (this.cachedVariableNames == null) {
            return null;
        }
        String[] stringArray = this.cachedVariableNames;
        synchronized (this.cachedVariableNames) {
            NumericStaticTableVariable numericVariable = new NumericStaticTableVariable();
            try {
                numericVariable.connectFrom(this.staticTableDataModel, index);
                numericVariable.setName(this.cachedVariableNames[index - 1]);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return numericVariable;
            }
            catch (VariableException variableException) {
            }
            catch (VTKRuntimeException vTKRuntimeException) {
                // empty catch block
            }
            return this.newDateVariable(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NumericVariable newDateVariable(String name) {
        if (name == null || this.cachedVariableNames == null) {
            return null;
        }
        String[] stringArray = this.cachedVariableNames;
        synchronized (this.cachedVariableNames) {
            try {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.newDateVariable(this.indexOf(name));
            }
            catch (VariableException e) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NumericVariable newDateVariable(int index) {
        if (this.cachedVariableNames == null) {
            return null;
        }
        String[] stringArray = this.cachedVariableNames;
        synchronized (this.cachedVariableNames) {
            DateStaticTableVariable dateVariable = new DateStaticTableVariable();
            try {
                dateVariable.connectFrom(this.staticTableDataModel, index);
                dateVariable.setName(this.cachedVariableNames[index - 1]);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return dateVariable;
            }
            catch (VariableException e) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            catch (VTKRuntimeException e) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }
    }

    @Override
    public String getColumnName(int index) {
        try {
            return (String)((StaticColumnLabelInterface)this.staticTableDataModel).getColumnLabel(index + 1);
        }
        catch (TableException tableException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public int getVariableCount() {
        try {
            return this.staticTableDataModel.getColumnCount();
        }
        catch (TableException tableException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getColumnNames() {
        if (this.staticTableDataModel == null) {
            return null;
        }
        StaticRowTemplateTableInterface staticRowTemplateTableInterface = this.staticTableDataModel;
        synchronized (staticRowTemplateTableInterface) {
            String[] names = new String[this.getVariableCount()];
            for (int ii = 0; ii < names.length; ++ii) {
                names[ii] = this.getColumnName(ii);
            }
            return names;
        }
    }

    protected synchronized int indexOf(String name) {
        if (this.cachedVariableNames == null) {
            throw new VariableException();
        }
        for (int ii = 0; ii < this.cachedVariableNames.length; ++ii) {
            if (!this.cachedVariableNames[ii].equals(name)) continue;
            return ii + 1;
        }
        throw new VariableException();
    }

    public synchronized void setWhereClause(String clause) {
        this.variableProcessor.setWhereExpression(clause);
        this.fireContentsChanged(new ContentsChangedEvent((Object)this, "row", null, null));
    }

    public String getWhereClause() {
        return this.variableProcessor.getWhereExpression();
    }

    public synchronized int getIndexWithoutWhereProcessing(int index) {
        return this.variableProcessor.getIndexWithoutWhereProcessing(index);
    }

    public synchronized void setDataCachingEnabled(boolean newValue) {
        if (this.dataCachingEnabled != newValue && (this.dataCachingEnabled = newValue)) {
            this._cacheData();
        }
    }

    private void _cacheData() {
        if (this.dataCachingEnabled && !this.cacheStateValid) {
            this.variableProcessor.cacheData();
            this.cacheStateValid = true;
        }
    }

    private boolean _reaquireVtkVariables() {
        boolean changeOccured = false;
        Enumeration varDefs = this.variableDefinitions.elements();
        while (varDefs.hasMoreElements()) {
            Variable oldVtkVariable = null;
            Variable newVtkVariable = null;
            VariableDefinitionInterface varDef = (VariableDefinitionInterface)varDefs.nextElement();
            if (varDef instanceof ClassifierVariableDefinitionInterface) {
                oldVtkVariable = this._destroyVtkVar((ClassifierVariableDefinitionInterface)varDef);
                newVtkVariable = this._createVtkVar((ClassifierVariableDefinitionInterface)varDef);
            } else if (varDef instanceof AnalysisVariableDefinitionInterface) {
                oldVtkVariable = this._destroyVtkVar((AnalysisVariableDefinitionInterface)varDef);
                newVtkVariable = this._createVtkVar((AnalysisVariableDefinitionInterface)varDef);
            }
            if (oldVtkVariable == null && newVtkVariable == null) continue;
            changeOccured = true;
        }
        this.cacheStateValid = !changeOccured;
        return changeOccured;
    }

    @Override
    public Class getColumnType(Object role) {
        VariableDefinitionInterface varDef = (VariableDefinitionInterface)this.variableDefinitions.get(role);
        if (varDef == null) {
            return null;
        }
        Variable vtkVariable = this._newVtkVar(varDef);
        return vtkVariable.getClass();
    }

    @Override
    public Class getColumnType(int index) {
        return this.getColumnType(this.getColumnName(index));
    }

    @Override
    public Class getColumnType(String name) {
        name = this.getColumnName(name);
        VariableDefinition varDef = new VariableDefinition();
        varDef.setName(name);
        Variable vtkVariable = this._newVtkVar(varDef);
        return vtkVariable == null ? null : vtkVariable.getClass();
    }

    protected class VariableDefListener
    implements PropertyChangeListener {
        protected VariableDefListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String propertyName = pce.getPropertyName();
            VariableDefinition varDef = (VariableDefinition)pce.getSource();
            if (varDef != null) {
                Variable vtkVariable = (Variable)DataSource.this.vtkVariables.get(varDef);
                if (propertyName == null || propertyName == "name" || propertyName == "index" || propertyName == "label" || propertyName == "informat" && vtkVariable != null) {
                    Variable oldVtkVariable = null;
                    Variable newVtkVariable = null;
                    if (varDef instanceof ClassifierVariableDefinitionInterface) {
                        oldVtkVariable = DataSource.this._destroyVtkVar((ClassifierVariableDefinitionInterface)((Object)varDef));
                        newVtkVariable = DataSource.this._createVtkVar((ClassifierVariableDefinitionInterface)((Object)varDef));
                    } else if (varDef instanceof AnalysisVariableDefinitionInterface) {
                        oldVtkVariable = DataSource.this._destroyVtkVar((AnalysisVariableDefinitionInterface)((Object)varDef));
                        newVtkVariable = DataSource.this._createVtkVar((AnalysisVariableDefinitionInterface)((Object)varDef));
                    }
                    if (oldVtkVariable != null || newVtkVariable != null) {
                        DataSource.this.fireContentsChanged();
                    }
                } else if (propertyName == "format") {
                    if (vtkVariable != null) {
                        DataSource.this._applyFormat(varDef, vtkVariable);
                        DataSource.this.fireContentsChanged();
                    }
                } else if (propertyName == "userLabel") {
                    if (vtkVariable != null) {
                        DataSource.this._applyUserLabel(varDef, vtkVariable);
                        DataSource.this.fireContentsChanged();
                    }
                } else if (propertyName == "statistic" && vtkVariable != null && varDef instanceof AnalysisVariableDefinitionInterface) {
                    DataSource.this._applyStatistic((AnalysisVariableDefinitionInterface)((Object)varDef), vtkVariable);
                    DataSource.this.fireContentsChanged();
                }
            }
        }
    }

    private class StaticTableListener
    implements ContentsChangedListener {
        private StaticTableListener() {
        }

        public void contentsChanged(ContentsChangedEvent e) {
            boolean updated = false;
            if (e instanceof CellChangedEvent) {
                if (e instanceof DataCellChangedEvent) {
                    DataSource.this.fireContentsChanged(new ContentsChangedEvent((Object)this, "cell", null, null));
                }
                if (e instanceof ColumnLabelChangedEvent) {
                    // empty if block
                }
                if (e instanceof RowLabelChangedEvent) {
                    // empty if block
                }
            } else if (e instanceof CellVectorChangedEvent) {
                if (e instanceof ColumnChangedEvent) {
                    DataSource.this.fireContentsChanged(new ContentsChangedEvent((Object)this, "column", null, null));
                }
                if (e instanceof RowChangedEvent) {
                    DataSource.this.fireContentsChanged(new ContentsChangedEvent((Object)this, "row", null, null));
                }
            }
        }
    }
}

