/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.AxisInterface;
import com.sas.graphics.chart.util.ctk.VisualizationComponent;
import com.sas.graphics.chart.util.ctk.VisualizationComponentInterface;
import com.sas.graphics.chart.util.ctk.VisualizationContainerInterface;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class AxisTickSpaceAdjuster
implements MouseListener,
MouseMotionListener {
    protected AxisInterface axis;
    protected boolean enabled = true;
    protected boolean active = false;
    protected int pressedX;
    protected int pressedY;
    protected double extraTickSpace;

    public AxisTickSpaceAdjuster() {
    }

    public AxisTickSpaceAdjuster(AxisInterface _axis) {
        this.axis = _axis;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.active && this.adjustAxis(event.getX(), event.getY())) {
            this.redraw();
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.active = this.enabled && this.axis != null && event.isShiftDown();
        if (this.active) {
            this.pressedX = event.getX();
            this.pressedY = event.getY();
            this.extraTickSpace = this.axis.getExtraTickSpace();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.active = false;
    }

    protected boolean adjustAxis(int currentX, int currentY) {
        if (this.axis != null) {
            int y;
            int x;
            double _extraTickSpace;
            int orientation = this.axis.getOrientation();
            if (orientation == 1) {
                double _extraTickSpace2 = this.extraTickSpace + (double)(currentX - this.pressedX);
                if (_extraTickSpace2 != this.axis.getExtraTickSpace()) {
                    this.axis.setExtraTickSpace(Math.max(0.0, _extraTickSpace2));
                    return true;
                }
            } else if (orientation == 2) {
                double _extraTickSpace3 = this.extraTickSpace - (double)(this.pressedY - currentY);
                if (_extraTickSpace3 != this.axis.getExtraTickSpace()) {
                    this.axis.setExtraTickSpace(Math.max(0.0, _extraTickSpace3));
                    return true;
                }
            } else if (orientation == 3 && (_extraTickSpace = this.extraTickSpace + Math.sqrt((x = Math.max(0, currentX - this.pressedX)) * x + (y = Math.max(0, currentY - this.pressedY)) * y)) != this.axis.getExtraTickSpace()) {
                this.axis.setExtraTickSpace(_extraTickSpace);
                return true;
            }
        }
        return false;
    }

    protected void redraw() {
        if (this.axis instanceof VisualizationComponentInterface) {
            VisualizationComponentInterface top = (VisualizationComponentInterface)((Object)this.axis);
            VisualizationContainerInterface parent = top.getVisualizationParent();
            ((VisualizationComponent)((Object)parent)).generateGraphics();
            ((VisualizationComponent)((Object)parent)).getVisualizationGraphics().redraw();
        }
    }
}

