/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.AxisInterface;
import com.sas.graphics.chart.util.ctk.VisualizationComponent;
import com.sas.graphics.chart.util.ctk.VisualizationComponentInterface;
import com.sas.graphics.chart.util.ctk.VisualizationContainerInterface;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class AxisTickAdjuster
implements MouseListener,
MouseMotionListener {
    protected AxisInterface axis;
    protected boolean enabled = true;
    protected boolean active = false;
    protected int pressedX;
    protected int pressedY;
    protected double tickAdjust;

    public AxisTickAdjuster() {
    }

    public AxisTickAdjuster(AxisInterface _axis) {
        this.axis = _axis;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.active && this.adjustAxis(event.getX(), event.getY())) {
            this.redraw();
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.active = this.enabled && this.axis != null && !event.isShiftDown();
        if (this.active) {
            this.pressedX = event.getX();
            this.pressedY = event.getY();
            this.tickAdjust = this.axis.getTickOriginAdjust();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.active = false;
    }

    protected boolean adjustAxis(int currentX, int currentY) {
        if (this.axis != null) {
            int y;
            int x;
            double _tickAdjust;
            int orientation = this.axis.getOrientation();
            if (orientation == 1) {
                double _tickAdjust2 = this.tickAdjust + (double)(currentX - this.pressedX);
                if (_tickAdjust2 != this.axis.getTickOriginAdjust()) {
                    this.axis.setTickOriginAdjust(_tickAdjust2);
                    return true;
                }
            } else if (orientation == 2) {
                double _tickAdjust3 = this.tickAdjust - (double)(this.pressedY - currentY);
                if (_tickAdjust3 != this.axis.getTickOriginAdjust()) {
                    this.axis.setTickOriginAdjust(_tickAdjust3);
                    return true;
                }
            } else if (orientation == 3 && (_tickAdjust = this.tickAdjust + Math.sqrt((x = currentX - this.pressedX) * x + (y = currentY - this.pressedY) * y)) != this.axis.getTickOriginAdjust()) {
                this.axis.setTickOriginAdjust(_tickAdjust);
                return true;
            }
        }
        return false;
    }

    protected void redraw() {
        if (this.axis instanceof VisualizationComponentInterface) {
            VisualizationComponentInterface top = (VisualizationComponentInterface)((Object)this.axis);
            VisualizationContainerInterface parent = top.getVisualizationParent();
            ((VisualizationComponent)((Object)parent)).generateGraphics();
            ((VisualizationComponent)((Object)parent)).getVisualizationGraphics().redraw();
        }
    }
}

