/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.AxisInterface;
import com.sas.graphics.chart.util.ctk.CTKEventMulticaster;
import com.sas.graphics.chart.util.ctk.ChartComponent;
import com.sas.graphics.chart.util.ctk.ContinuousDoubleRangeNode;
import com.sas.graphics.chart.util.ctk.DiscreteStringRangeNode;
import com.sas.graphics.chart.util.ctk.DoubleRangeNodeInterface;
import com.sas.graphics.chart.util.ctk.RangeEvent;
import com.sas.graphics.chart.util.ctk.RangeListener;
import com.sas.graphics.chart.util.ctk.RangeNode;
import com.sas.graphics.chart.util.ctk.RangeNodeInterface;
import com.sas.graphics.chart.util.ctk.RangeSetOwnerInterface;
import com.sas.graphics.chart.util.ctk.RangeSource;
import com.sas.graphics.chart.util.ctk.RangeStrategyInterface;
import com.sas.graphics.chart.util.ctk.StringRangeNodeInterface;
import com.sas.graphics.chart.util.ctk.TickStrategyEvent;
import com.sas.graphics.chart.util.ctk.TickStrategyFactoryInterface;
import com.sas.graphics.chart.util.ctk.TickStrategyListener;
import com.sas.graphics.chart.util.ctk.TickStrategySource;
import com.sas.graphics.chart.util.ctk.TransformInterface;
import com.sas.graphics.chart.util.ctk.TransformStrategyEvent;
import com.sas.graphics.chart.util.ctk.TransformStrategyFactoryInterface;
import com.sas.graphics.chart.util.ctk.TransformStrategyListener;
import com.sas.graphics.chart.util.ctk.TransformStrategySource;
import com.sas.graphics.chart.util.ctk.VisualizationGraphicsInterface;
import com.sas.graphics.chart.util.ctk.vtk.ConstantDoubleTickStrategy;
import com.sas.graphics.chart.util.ctk.vtk.ConstantDoubleToDoubleTransformStrategy;
import com.sas.graphics.chart.util.ctk.vtk.ConstantStringToDoubleTransformStrategy;
import com.sas.graphics.chart.util.ctk.vtk.DoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.DoubleTickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleTransformStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.DoubleTransformStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.StringTickStrategy;
import com.sas.graphics.chart.util.ctk.vtk.StringTickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleTransformStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.TickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtkDateFormatJoeHack;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AxisStyle;
import com.sas.graphics.util.vtk.Calculator;
import com.sas.graphics.util.vtk.VTKFormat;
import com.sas.graphics.util.vtk.jxd.RectangularAxis;
import java.awt.Font;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Axis
extends ChartComponent
implements AxisInterface,
TransformInterface,
TransformStrategySource,
TickStrategySource,
RangeListener,
RangeSetOwnerInterface,
TransformStrategyFactoryInterface,
TickStrategyFactoryInterface {
    protected static final Integer DATA_VALUE = new Integer(Integer.MIN_VALUE);
    public static final int X = 1;
    public static final int Y = 2;
    public static final int Z = 3;
    protected TransformStrategyListener transformStrategyListeners;
    protected TickStrategyListener tickStrategyListeners;
    protected Hashtable ranges;
    protected TransformStrategyFactoryInterface transformStrategyFactory;
    protected TickStrategyFactoryInterface tickStrategyFactory;
    protected RangeStrategyInterface rangeStrategy;
    protected DoubleTransformStrategyInterface transformStrategy;
    protected TickStrategyInterface tickStrategy;
    protected RangeNodeInterface summarizedRangeNode;
    protected double tickExtent;
    protected double visibleTickOrigin;
    protected double visibleTickExtent;
    protected Double baseline;
    protected int orientation;
    protected RectangularAxis axis;
    protected Calculator visibleTickFilter;
    protected Vector visibleValueFilters;
    protected DoubleStrategyMapper valueMapper;
    protected String title;
    protected RangeNodeInterface forcedRange;
    protected VTKFormat format;
    double _necessaryExtraTickSpace = 0.0;
    double extraTickSpace = 0.0;
    double tickOriginAdjust = 0.0;
    AxisStyle axisStyle;

    @Override
    public boolean generateGraphics() {
        return super.generateGraphics();
    }

    protected Axis() {
    }

    public static Object newInstance() {
        Axis o = new Axis();
        o.init();
        return o;
    }

    public static final Axis newAxis() {
        return (Axis)Axis.newInstance();
    }

    @Override
    protected void init() {
        super.init();
        this.setOrientation(1);
        this.setRangeStrategy(new DefaultRangeStrategy());
        this.transformStrategyFactory = this;
        this.tickStrategyFactory = this;
        this.visibleTickFilter = this.newVisibleTickFilter();
    }

    public void setFormat(VTKFormat format) {
        this.invalidateGraphics();
    }

    @Override
    public void addTransformStrategyListener(TransformStrategyListener l) {
        if (l != null) {
            this.transformStrategyListeners = CTKEventMulticaster.addTransformStrategyListener(this.transformStrategyListeners, l);
            if (this.transformStrategy != null) {
                l.transformStrategyUpdate(new TransformStrategyEvent((Object)this, this.transformStrategy));
            }
        }
    }

    @Override
    public void removeTransformStrategyListener(TransformStrategyListener l) {
        if (l != null) {
            this.transformStrategyListeners = CTKEventMulticaster.removeTransformStrategyListener(this.transformStrategyListeners, l);
            if (this.transformStrategy != null) {
                l.transformStrategyUpdate(new TransformStrategyEvent((Object)this, null));
            }
        }
    }

    @Override
    public void addTickStrategyListener(TickStrategyListener l) {
        if (l != null) {
            this.tickStrategyListeners = CTKEventMulticaster.addTickStrategyListener(this.tickStrategyListeners, l);
            if (this.tickStrategy != null) {
                l.tickStrategyUpdate(new TickStrategyEvent((Object)this, this.tickStrategy));
            }
        }
    }

    @Override
    public void removeTickStrategyListener(TickStrategyListener l) {
        if (l != null) {
            this.tickStrategyListeners = CTKEventMulticaster.removeTickStrategyListener(this.tickStrategyListeners, l);
            if (this.tickStrategy != null) {
                l.tickStrategyUpdate(new TickStrategyEvent((Object)this, null));
            }
        }
    }

    public RangeNodeInterface setRange(double min, double max) {
        if (!Double.isNaN(min) && !Double.isNaN(max)) {
            this.forcedRange = new RangeNode(new Integer(-1));
            this.forcedRange.add(new ContinuousDoubleRangeNode(new Integer(Integer.MIN_VALUE), min, max));
        } else {
            this.forcedRange = null;
        }
        this.rangeStrategy.refresh();
        return this.forcedRange;
    }

    @Override
    public void rangeUpdate(RangeEvent e) {
        if (e == null) {
            return;
        }
        Object source = e.getSource();
        RangeNodeInterface rangeNode = e.getRangeNode();
        if (source == this.rangeStrategy) {
            this.setSummarizedRangeNode(rangeNode);
        } else {
            if (source == null && rangeNode == null) {
                return;
            }
            if (source != null && rangeNode != null) {
                if (this.ranges == null) {
                    this.ranges = new Hashtable();
                }
                this.ranges.put(source, rangeNode);
            } else if (source != null && this.ranges != null) {
                this.ranges.remove(source);
            }
            this.rangeStrategy.refresh();
        }
    }

    @Override
    public void setTransformStrategyFactory(TransformStrategyFactoryInterface transformStrategyFactory) {
        if (this.transformStrategyFactory != transformStrategyFactory) {
            TransformStrategyFactoryInterface transformStrategyFactoryInterface = this.transformStrategyFactory = transformStrategyFactory == null ? this : transformStrategyFactory;
            if (this.transformStrategy != null) {
                this.transformStrategy = null;
                this.updateTransformStrategies(this.summarizedRangeNode);
            }
        }
    }

    public void setTickStrategyFactory(TickStrategyFactoryInterface tickStrategyFactory) {
        if (this.tickStrategyFactory != tickStrategyFactory) {
            TickStrategyFactoryInterface tickStrategyFactoryInterface = this.tickStrategyFactory = tickStrategyFactory == null ? this : tickStrategyFactory;
            if (this.tickStrategy != null) {
                this.tickStrategy = null;
                this.updateTransformStrategies(this.summarizedRangeNode);
            }
        }
    }

    public RangeStrategyInterface setRangeStrategy(RangeStrategyInterface newRangeStrategy) {
        if (this.rangeStrategy != null) {
            this.rangeStrategy.removeRangeSetOwner(this);
            if (this.rangeStrategy instanceof RangeSource) {
                ((RangeSource)((Object)this.rangeStrategy)).removeRangeListener(this);
            }
        }
        this.rangeStrategy = newRangeStrategy == null ? new DefaultRangeStrategy() : newRangeStrategy;
        this.rangeStrategy.addRangeSetOwner(this);
        if (this.rangeStrategy instanceof RangeSource) {
            ((RangeSource)((Object)this.rangeStrategy)).addRangeListener(this);
        }
        this.rangeStrategy.refresh();
        return newRangeStrategy;
    }

    public RangeStrategyInterface getRangeStrategy() {
        return this.rangeStrategy;
    }

    public DoubleTransformStrategyInterface setTransformStrategy(DoubleTransformStrategyInterface ts) {
        if (this.transformStrategy != ts) {
            this.transformStrategy = ts;
            if (this.transformStrategyListeners != null) {
                this.transformStrategyListeners.transformStrategyUpdate(new TransformStrategyEvent((Object)this, this.transformStrategy));
            }
        }
        return this.transformStrategy;
    }

    public TickStrategyInterface setTickStrategy(TickStrategyInterface ts) {
        if (this.tickStrategy != ts) {
            this.tickStrategy = ts;
            if (this.tickStrategyListeners != null) {
                this.tickStrategyListeners.tickStrategyUpdate(new TickStrategyEvent((Object)this, this.tickStrategy));
            }
        }
        return this.tickStrategy;
    }

    @Override
    public StringTickStrategyInterface newStringTickStrategy() {
        return new StringTickStrategy();
    }

    @Override
    public DoubleTickStrategyInterface newDoubleTickStrategy() {
        return new ConstantDoubleTickStrategy();
    }

    @Override
    public StringToDoubleTransformStrategyInterface newStringToDoubleTransformStrategy() {
        return new ConstantStringToDoubleTransformStrategy();
    }

    @Override
    public DoubleToDoubleTransformStrategyInterface newDoubleToDoubleTransformStrategy() {
        return new ConstantDoubleToDoubleTransformStrategy();
    }

    protected void setSummarizedRangeNode(RangeNodeInterface rangeNode) {
        this.summarizedRangeNode = rangeNode;
        this.updateTransformStrategies(this.summarizedRangeNode);
        this._connectNetwork();
        this.invalidate();
    }

    public void forceTransformStrategyUpdate() {
        this.transformStrategy = null;
        this.tickStrategy = null;
        this.updateTransformStrategies(this.summarizedRangeNode);
    }

    protected void updateTransformStrategies(RangeNodeInterface rangeNode) {
        if (rangeNode == null) {
            this.setTransformStrategy(null);
            this.setTickStrategy(null);
            return;
        }
        Enumeration children = rangeNode.children();
        if (children == null) {
            this.setTransformStrategy(null);
            this.setTickStrategy(null);
            return;
        }
        DoubleTransformStrategyInterface oldTransformStrategy = this.transformStrategy;
        TickStrategyInterface oldTickStrategy = this.tickStrategy;
        this.transformStrategy = this.newTransformStrategy(this.transformStrategy, rangeNode);
        if (this.transformStrategy != oldTransformStrategy && this.transformStrategyListeners != null) {
            this.transformStrategyListeners.transformStrategyUpdate(new TransformStrategyEvent((Object)this, this.transformStrategy));
        }
        if (this.tickStrategy != oldTickStrategy && this.tickStrategyListeners != null) {
            this.tickStrategyListeners.tickStrategyUpdate(new TickStrategyEvent((Object)this, this.tickStrategy));
        }
    }

    @Override
    public RangeNodeInterface[] getRangeSet() {
        RangeNodeInterface[] rangeNodeArray = null;
        if (this.forcedRange != null) {
            rangeNodeArray = new RangeNode[]{this.forcedRange};
        } else if (this.ranges != null) {
            rangeNodeArray = new RangeNode[this.ranges.size()];
            Enumeration rangeNodes = this.ranges.elements();
            int ii = 0;
            while (rangeNodes.hasMoreElements()) {
                rangeNodeArray[ii] = (RangeNodeInterface)rangeNodes.nextElement();
                ++ii;
            }
        }
        return rangeNodeArray;
    }

    @Override
    public void setExtraTickSpace(double _extraTickSpace) {
        this.extraTickSpace = _extraTickSpace;
        this._transformStrategyUpdate();
        this.invalidateGraphics();
    }

    @Override
    public double getExtraTickSpace() {
        return this.extraTickSpace;
    }

    @Override
    public void setTickOriginAdjust(double _tickOriginAdjust) {
        this.tickOriginAdjust = _tickOriginAdjust;
        this._transformStrategyUpdate();
        this.invalidateGraphics();
    }

    @Override
    public double getTickOriginAdjust() {
        return this.tickOriginAdjust;
    }

    private void _transformStrategyUpdate() {
        if (this.transformStrategy != null) {
            if (this.tickExtent > 0.0) {
                this.extraTickSpace = Math.max(this._necessaryExtraTickSpace, this.extraTickSpace);
                this.tickOriginAdjust = Math.min(Math.max(-(this.tickExtent + this.extraTickSpace - this.visibleTickExtent), this.tickOriginAdjust), 0.0);
                this.transformStrategy.setOutputMin(this.visibleTickOrigin + this.tickOriginAdjust);
                this.transformStrategy.setOutputMax(this.visibleTickOrigin + this.tickExtent + this.extraTickSpace + this.tickOriginAdjust);
            } else {
                this.extraTickSpace = Math.max(this._necessaryExtraTickSpace, this.extraTickSpace);
                this.tickOriginAdjust = Math.min(Math.max(this.tickExtent - this.extraTickSpace - this.visibleTickExtent, this.tickOriginAdjust), 0.0);
                this.transformStrategy.setOutputMin(this.visibleTickOrigin - this.tickOriginAdjust);
                this.transformStrategy.setOutputMax(this.visibleTickOrigin + (this.tickExtent - this.extraTickSpace) - this.tickOriginAdjust);
            }
        }
    }

    private void _calcPreferredValueTickExtent() {
        if (this.tickStrategy instanceof StringTickStrategyInterface) {
            switch (this.orientation) {
                default: {
                    break;
                }
                case 2: {
                    Font font = this.getValueFont();
                    VisualizationGraphicsInterface vg = this.getVisualizationGraphics();
                    double valueHeight = vg.getTextHeight(font);
                    String[] values = ((StringTickStrategyInterface)this.tickStrategy).getValues();
                    double direction = this.visibleTickExtent > 0.0 ? 1.0 : -1.0;
                    this.tickExtent = valueHeight * 1.5 * (double)values.length * direction;
                    break;
                }
                case 3: {
                    this.tickExtent = this.visibleTickExtent;
                    break;
                }
            }
        } else {
            this.tickExtent = this.visibleTickExtent;
        }
    }

    @Override
    protected void makeNetwork() {
        this._connectNetwork();
    }

    private void _connectNetwork() {
        this.invalidateGraphics();
        String name = this.getName();
        this.valueMapper = null;
        if (this.networkRoot != null) {
            this.composite.removeAllElements();
            if (this.transformStrategy == null) {
                return;
            }
            this.axis.title.setValue(this.title == null ? "" : this.title);
            this.axis.setOrientation(this.orientation);
            if (this.orientation == 1) {
                this.axis.transform.translateY.setValue(this.origin.y);
                this.axis.transform.translateZ.setValue(this.origin.z);
            }
            if (this.orientation == 2) {
                this.axis.transform.translateX.setValue(this.origin.x);
                this.axis.transform.translateZ.setValue(this.origin.z);
            }
            if (this.orientation == 3) {
                this.axis.transform.translateX.setValue(this.origin.x);
                this.axis.transform.translateY.setValue(this.origin.y);
            }
            this.axis.setLineOffset(this.visibleTickOrigin);
            this.axis.setLength(this.visibleTickExtent);
            this.setLabelOrientation();
            this.visibleTickFilter.setExpression(this._getVisibleTickFilterExpression());
            this.visibleTickFilter.inB.setValue(this.visibleTickOrigin);
            this.visibleTickFilter.inC.setValue(this.visibleTickOrigin + this.visibleTickExtent);
            if (this.visibleValueFilters != null) {
                String visibleValueFilterExpression = this._getVisibleValueFilterExpression();
                int size = this.visibleValueFilters.size();
                for (int ii = 0; ii < size; ++ii) {
                    Calculator calc = (Calculator)this.visibleValueFilters.elementAt(ii);
                    calc.setExpression(visibleValueFilterExpression);
                    calc.inB.setValue(this.visibleTickOrigin);
                    calc.inC.setValue(this.visibleTickOrigin + this.visibleTickExtent);
                }
            }
            if (this.transformStrategy != null && this.tickStrategy != null) {
                this._calcPreferredValueTickExtent();
                this._transformStrategyUpdate();
                if (this.valueMapper == null) {
                    if (this.tickStrategy instanceof StringTickStrategyInterface && this.transformStrategy instanceof StringToDoubleTransformStrategyInterface) {
                        StringToDoubleTransformStrategyInterface s2dts = (StringToDoubleTransformStrategyInterface)this.transformStrategy;
                        StringToDoubleStrategyMapper S2DMapper = new StringToDoubleStrategyMapper();
                        S2DMapper.setTransformStrategy(s2dts);
                        S2DMapper.setTickStrategy((StringTickStrategyInterface)this.tickStrategy);
                        this.valueMapper = S2DMapper;
                        this.format = null;
                    } else if (this.tickStrategy instanceof DoubleTickStrategyInterface && this.transformStrategy instanceof DoubleToDoubleTransformStrategyInterface) {
                        DoubleToDoubleTransformStrategyInterface d2dts = (DoubleToDoubleTransformStrategyInterface)this.transformStrategy;
                        DoubleToDoubleStrategyMapper D2DMapper = new DoubleToDoubleStrategyMapper();
                        D2DMapper.setTransformStrategy(d2dts);
                        D2DMapper.setTickStrategy((DoubleTickStrategyInterface)this.tickStrategy);
                        this.format = new vtkDateFormatJoeHack("Date7");
                        this.valueMapper = D2DMapper;
                    } else {
                        return;
                    }
                }
                if (this.format != null) {
                    this.valueMapper.setFormat(this.format);
                }
                this.axis.labels.connectFrom(this.valueMapper.label);
                this.visibleTickFilter.inA.connectFrom(this.valueMapper.uniqueValue);
                this.axis.labelOffset.connectFrom(this.visibleTickFilter.value);
                if (this.visible) {
                    this.composite.addElement(this.axis);
                }
            }
        }
    }

    protected DoubleTransformStrategyInterface newTransformStrategy(DoubleTransformStrategyInterface currentTransformStrategy, RangeNodeInterface rangeNode) {
        Vector levelTypes = Axis.getTypeList(rangeNode);
        if (levelTypes == null) {
            return null;
        }
        DoubleTransformStrategyInterface lclTransformStrategy = null;
        TickStrategyInterface lclTickStrategy = null;
        int size = levelTypes.size();
        if (size == 1) {
            if (levelTypes.elementAt(0) == StringRangeNodeInterface.class) {
                if (currentTransformStrategy instanceof StringRangeNodeInterface) {
                    lclTransformStrategy = currentTransformStrategy;
                } else {
                    lclTransformStrategy = this.transformStrategyFactory.newStringToDoubleTransformStrategy();
                    if (lclTransformStrategy == null) {
                        lclTransformStrategy = this.newStringToDoubleTransformStrategy();
                    }
                }
                if (lclTransformStrategy != null && !(lclTickStrategy instanceof StringTickStrategyInterface)) {
                    lclTickStrategy = this.tickStrategyFactory.newStringTickStrategy();
                }
            } else if (levelTypes.elementAt(0) == DoubleRangeNodeInterface.class) {
                if (currentTransformStrategy instanceof DoubleToDoubleTransformStrategyInterface) {
                    lclTransformStrategy = currentTransformStrategy;
                } else {
                    lclTransformStrategy = this.transformStrategyFactory.newDoubleToDoubleTransformStrategy();
                    if (lclTransformStrategy == null) {
                        lclTransformStrategy = this.newDoubleToDoubleTransformStrategy();
                    }
                }
                if (lclTransformStrategy != null && !(lclTickStrategy instanceof DoubleTickStrategyInterface)) {
                    lclTickStrategy = this.tickStrategyFactory.newDoubleTickStrategy();
                }
            }
        } else if (size != 2 || levelTypes.elementAt(0) != StringRangeNodeInterface.class || levelTypes.elementAt(1) == StringRangeNodeInterface.class) {
            // empty if block
        }
        if (lclTransformStrategy != null) {
            DataRangeInfo dataRange = Axis.getChildrenDataRange(rangeNode);
            if (lclTransformStrategy instanceof DoubleToDoubleTransformStrategyInterface) {
                double b;
                if (Double.isNaN(dataRange.min) || Double.isNaN(dataRange.max)) {
                    return null;
                }
                if (this.baseline != null && dataRange.min > (b = this.baseline.doubleValue())) {
                    dataRange.min = b;
                }
                if (dataRange.min != dataRange.max) {
                    DoubleToDoubleTransformStrategyInterface d2dts = (DoubleToDoubleTransformStrategyInterface)lclTransformStrategy;
                    d2dts.setInputMin(dataRange.min);
                    d2dts.setInputMax(dataRange.max);
                    DoubleTickStrategyInterface dts = (DoubleTickStrategyInterface)lclTickStrategy;
                    dts.setMin(dataRange.min);
                    dts.setMax(dataRange.max);
                    dts.setTickCount(-1);
                }
            } else if (lclTransformStrategy instanceof StringToDoubleTransformStrategyInterface && dataRange.strings != null && dataRange.strings.length != 0) {
                ((StringToDoubleTransformStrategyInterface)lclTransformStrategy).setValues(dataRange.strings);
                lclTickStrategy.setValues(dataRange.strings);
            }
        }
        this.tickStrategy = lclTickStrategy;
        return lclTransformStrategy;
    }

    protected static Vector getTypeList(RangeNodeInterface rangeNode) {
        Vector<Class> levelTypes = new Vector<Class>();
        Enumeration children = rangeNode.children();
        RangeNodeInterface childRangeNode = null;
        while (children != null && children.hasMoreElements()) {
            childRangeNode = (RangeNodeInterface)children.nextElement();
            if (childRangeNode instanceof StringRangeNodeInterface) {
                levelTypes.addElement(StringRangeNodeInterface.class);
            } else if (childRangeNode instanceof DoubleRangeNodeInterface) {
                levelTypes.addElement(DoubleRangeNodeInterface.class);
            } else {
                return null;
            }
            children = childRangeNode.children();
        }
        return levelTypes.size() > 0 ? levelTypes : null;
    }

    protected static DataRangeInfo getChildrenDataRange(RangeNodeInterface rangeNode) {
        RangeNodeInterface child;
        Vector<String> list = null;
        Vector<CollationKey> keyList = null;
        Collator collator = null;
        Enumeration children = rangeNode.children();
        RangeNodeInterface rangeNodeInterface = child = children.hasMoreElements() ? (RangeNodeInterface)children.nextElement() : null;
        if (child == null) {
            return null;
        }
        DataRangeInfo dataRangeInfo = new DataRangeInfo();
        if (child instanceof StringRangeNodeInterface) {
            collator = Collator.getInstance();
            list = new Vector<String>();
            keyList = new Vector<CollationKey>();
            do {
                if (child == null) {
                    child = (RangeNodeInterface)children.nextElement();
                }
                CollationKey k = null;
                String s = ((StringRangeNodeInterface)child).getString();
                if (s != null && !list.contains(s)) {
                    k = collator.getCollationKey(s);
                    list.addElement(s);
                    keyList.addElement(k);
                }
                child = null;
            } while (children.hasMoreElements());
            int size = list.size();
            dataRangeInfo.strings = new String[size];
            for (int ii = 0; ii < size; ++ii) {
                dataRangeInfo.strings[ii] = (String)list.elementAt(ii);
            }
        } else if (child instanceof DoubleRangeNodeInterface) {
            double start = ((DoubleRangeNodeInterface)child).getStart();
            double end = ((DoubleRangeNodeInterface)child).getEnd();
            double d = Double.isNaN(dataRangeInfo.min) ? start : (dataRangeInfo.min = start < dataRangeInfo.min ? start : dataRangeInfo.min);
            dataRangeInfo.max = Double.isNaN(dataRangeInfo.max) ? end : (end > dataRangeInfo.max ? end : dataRangeInfo.max);
        } else {
            return null;
        }
        return dataRangeInfo;
    }

    @Override
    protected void attachVisualizationGraphics(VisualizationGraphicsInterface vg) {
        super.attachVisualizationGraphics(vg);
        this.axis = this.visualizationGraphics.newRectangularAxis();
        if (this.axisStyle != null) {
            this.axis.setStyle(this.axisStyle);
        }
    }

    @Override
    public void validate() {
        switch (this.orientation) {
            default: {
                this.visibleTickOrigin = this.origin.x;
                this.visibleTickExtent = this.extent.x;
                break;
            }
            case 2: {
                this.visibleTickOrigin = this.origin.y;
                this.visibleTickExtent = this.extent.y;
                break;
            }
            case 3: {
                this.visibleTickOrigin = this.origin.z;
                this.visibleTickExtent = this.extent.z;
            }
        }
        if (this.baseline != null) {
            this.rangeStrategy.setBaseline(this.baseline);
        }
        super.validate();
    }

    public void setPrimary(boolean b) {
        this.axis.setPrimary(b);
    }

    @Override
    public boolean setOrientation(int orientation) {
        this.orientation = orientation;
        this.invalidate();
        return true;
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    protected void setLabelOrientation() {
        int valueOrientation = 2;
        switch (this.orientation) {
            default: {
                valueOrientation = 2;
                break;
            }
            case 2: {
                valueOrientation = 1;
                break;
            }
            case 3: {
                valueOrientation = 1;
            }
        }
        boolean mirror = false;
        if (this.extent != null) {
            switch (this.orientation) {
                default: {
                    mirror = this.extent.y < 0.0;
                    break;
                }
                case 2: {
                    mirror = this.extent.x < 0.0;
                    break;
                }
                case 3: {
                    mirror = this.extent.z > 0.0;
                }
            }
        }
        this.axis.setLabelOrientation(valueOrientation);
        this.axis.setPrimary(mirror);
    }

    public void setBaseline(double baseline) {
        this.baseline = new Double(baseline);
        this.invalidate();
    }

    public double getBaseline() {
        if (this.baseline == null) {
            return Double.NaN;
        }
        return this.baseline;
    }

    public boolean setTitle(String title) {
        this.title = title;
        this.invalidate();
        return true;
    }

    public void setAxisStyle(AxisStyle as) {
        AxisStyle axisStyle = this.axisStyle = as == null ? new AxisStyle() : as;
        if (this.axis != null) {
            this.axis.setStyle(this.axisStyle);
        }
        this.invalidate();
    }

    public AxisStyle getAxisStyle() {
        if (this.axisStyle == null) {
            this.axisStyle = new AxisStyle();
        }
        return this.axisStyle;
    }

    public Font getValueFont() {
        return this.getAxisStyle().getLabelStyle().getFont();
    }

    @Override
    public Vec3d getMaximumExtent() {
        return this.getMinimumPartialExtent();
    }

    @Override
    public Vec3d getPreferredExtent() {
        return this.getMinimumPartialExtent();
    }

    @Override
    public Vec3d getMinimumExtent() {
        return this.getMinimumPartialExtent();
    }

    @Override
    public Vec3d getMinimumPartialExtent() {
        VisualizationGraphicsInterface vg = this.getVisualizationGraphics();
        if (vg == null) {
            return this.visible ? new Vec3d(25.0, 25.0, 25.0) : new Vec3d();
        }
        switch (this.orientation) {
            case 1: {
                double valueHeight = vg.getTextHeight(this.getValueFont());
                return new Vec3d(25.0, valueHeight * 3.0, 0.0);
            }
            case 2: {
                String[] stringArray;
                Font font = this.getValueFont();
                double valueHeight = vg.getTextHeight(font);
                if (this.tickStrategy instanceof StringTickStrategyInterface) {
                    stringArray = ((StringTickStrategyInterface)this.tickStrategy).getValues();
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "     ";
                }
                String[] values = stringArray;
                valueHeight = valueHeight * 1.5 * (double)values.length;
                if (values == null || values.length == 0) {
                    return new Vec3d(50.0, valueHeight, 0.0);
                }
                double textWidth = 0.0;
                for (int ii = 1; ii < values.length; ++ii) {
                    double thisTextWidth = vg.getStringWidth(font, values[ii]);
                    if (!(thisTextWidth > textWidth)) continue;
                    textWidth = thisTextWidth;
                }
                return new Vec3d(textWidth + 20.0, valueHeight * 4.0, 0.0);
            }
            case 3: {
                return new Vec3d();
            }
        }
        return this.visible ? new Vec3d(25.0, 25.0, 25.0) : new Vec3d();
    }

    private String _getVisibleTickFilterExpression() {
        return this.visibleTickExtent < 0.0 ? "inA > inB | inA < inC ? inF : inA" : "inA < inB | inA > inC ? inF : inA";
    }

    private Calculator newVisibleTickFilter() {
        Calculator calc = new Calculator();
        calc.inF.setValue(Double.NaN);
        return calc;
    }

    private String _getVisibleValueFilterExpression() {
        return this.visibleTickExtent < 0.0 ? "inA > (inB+inD) | inA < (inC-inD) ? inF : inA" : "inA < (inB-inD) | inA > (inC+inD) ? inF : inA";
    }

    @Override
    public Calculator newVisibleValueFilter(Calculator calc, double adjust) {
        if (calc == null) {
            calc = new Calculator();
            if (this.visibleValueFilters == null) {
                this.visibleValueFilters = new Vector();
            }
            this.visibleValueFilters.addElement(calc);
        }
        calc.inF.setValue(Double.NaN);
        calc.inD.setValue(adjust);
        return calc;
    }

    @Override
    public void destroyVisibleValueFilter(Calculator calc) {
        if (calc != null && this.visibleValueFilters != null) {
            this.visibleValueFilters.removeElement(calc);
        }
    }

    @Override
    public Vec3d setOrigin(Vec3d origin) {
        Vec3d r = super.setOrigin(origin);
        this._connectNetwork();
        return r;
    }

    @Override
    public Vec3d setExtent(Vec3d extent) {
        Vec3d r = super.setExtent(extent);
        this._connectNetwork();
        return r;
    }

    public static class DefaultRangeStrategy
    implements RangeStrategyInterface,
    RangeSource {
        protected static final int UNDEFINED = -1;
        protected static final int STRING = 0;
        protected static final int DOUBLE = 1;
        protected RangeListener rangeListeners;
        protected RangeNodeInterface rangeNode;
        protected Vector rangeSetOwners;
        protected Double baseline;

        @Override
        public RangeSetOwnerInterface addRangeSetOwner(RangeSetOwnerInterface x) {
            if (this.rangeSetOwners == null) {
                this.rangeSetOwners = new Vector();
            }
            this.rangeSetOwners.addElement(x);
            return x;
        }

        @Override
        public RangeSetOwnerInterface removeRangeSetOwner(RangeSetOwnerInterface x) {
            return this.rangeSetOwners.removeElement(x) ? x : null;
        }

        @Override
        public void refresh() {
            this.consolidateRangeNodes();
            if (this.rangeListeners != null) {
                this.rangeListeners.rangeUpdate(new RangeEvent((Object)this, this.rangeNode));
            }
        }

        protected void consolidateRangeNodes() {
            double b;
            int rangeSetOwnerCount;
            String[] dataStrings = null;
            int inputDataType = -1;
            this.rangeNode = null;
            int n = rangeSetOwnerCount = this.rangeSetOwners == null ? 0 : this.rangeSetOwners.size();
            if (rangeSetOwnerCount == 0) {
                return;
            }
            Vector<String> list = null;
            Vector<CollationKey> keyList = null;
            Collator collator = null;
            double dataStart = Double.NaN;
            double dataEnd = Double.NaN;
            Object hackID = null;
            for (int rsoIndex = 0; rsoIndex < rangeSetOwnerCount; ++rsoIndex) {
                RangeSetOwnerInterface rangeSetOwner = (RangeSetOwnerInterface)this.rangeSetOwners.elementAt(rsoIndex);
                RangeNodeInterface[] rangeNodeArray = rangeSetOwner.getRangeSet();
                if (rangeNodeArray == null || rangeNodeArray.length == 0) {
                    return;
                }
                for (int ii = 0; ii < rangeNodeArray.length; ++ii) {
                    Enumeration children;
                    RangeNodeInterface rangeNode1 = rangeNodeArray[ii];
                    hackID = rangeNode1.getID();
                    if (rangeNode1 == null || (children = rangeNode1.children()) == null) continue;
                    RangeNodeInterface childRangeNode = rangeNode1;
                    while (children != null && children.hasMoreElements()) {
                        rangeNode1 = childRangeNode;
                        childRangeNode = (RangeNodeInterface)children.nextElement();
                        children = childRangeNode.children();
                    }
                    if (childRangeNode == null) continue;
                    if (childRangeNode instanceof StringRangeNodeInterface && inputDataType != 1) {
                        if (list == null) {
                            collator = Collator.getInstance();
                            list = new Vector<String>();
                            keyList = new Vector<CollationKey>();
                        }
                        children = rangeNode1.children();
                        while (children.hasMoreElements()) {
                            childRangeNode = (RangeNodeInterface)children.nextElement();
                            CollationKey k = null;
                            String s = ((StringRangeNodeInterface)childRangeNode).getString();
                            if (s == null || list.contains(s)) continue;
                            k = collator.getCollationKey(s);
                            list.addElement(s);
                            keyList.addElement(k);
                        }
                        inputDataType = 0;
                        continue;
                    }
                    if (!(childRangeNode instanceof DoubleRangeNodeInterface) || inputDataType == 0) continue;
                    double start = ((DoubleRangeNodeInterface)childRangeNode).getStart();
                    double end = ((DoubleRangeNodeInterface)childRangeNode).getEnd();
                    double d = Double.isNaN(dataStart) ? start : (dataStart = start < dataStart ? start : dataStart);
                    dataEnd = Double.isNaN(dataEnd) ? end : (end > dataEnd ? end : dataEnd);
                    inputDataType = 1;
                }
            }
            if (inputDataType == 0) {
                int size = list.size();
                dataStrings = new String[size];
                for (int ii = 0; ii < size; ++ii) {
                    dataStrings[ii] = (String)list.elementAt(ii);
                }
            } else if (inputDataType == 1 && this.baseline != null && dataStart > (b = this.baseline.doubleValue())) {
                dataStart = b;
            }
            this.rangeNode = new RangeNode(hackID);
            if (inputDataType == 0) {
                for (int ii = 0; ii < dataStrings.length; ++ii) {
                    this.rangeNode.add(new DiscreteStringRangeNode(DATA_VALUE, dataStrings[ii]));
                }
            } else if (inputDataType == 1) {
                this.rangeNode.add(new ContinuousDoubleRangeNode(DATA_VALUE, dataStart, dataEnd));
            }
        }

        @Override
        public void addRangeListener(RangeListener l) {
            if (l != null) {
                this.rangeListeners = CTKEventMulticaster.addRangeListener(this.rangeListeners, l);
                if (this.rangeNode != null) {
                    l.rangeUpdate(new RangeEvent((Object)this, this.rangeNode));
                }
            }
        }

        @Override
        public void removeRangeListener(RangeListener l) {
            if (l != null) {
                this.rangeListeners = CTKEventMulticaster.removeRangeListener(this.rangeListeners, l);
                if (this.rangeNode != null) {
                    l.rangeUpdate(new RangeEvent((Object)this, null));
                }
            }
        }

        @Override
        public void setBaseline(double baseline) {
            this.baseline = new Double(baseline);
        }
    }

    protected static class DataRangeInfo {
        public String[] strings = null;
        public double min = Double.NaN;
        public double max = Double.NaN;

        protected DataRangeInfo() {
        }
    }
}

