/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.bean;

import com.sas.awt.Container;
import com.sas.graphics.chart.bean.RB;
import com.sas.graphics.chart.util.ctk.JXDVisualizationGraphics;
import com.sas.graphics.chart.util.ctk.VTKVisualizationGraphicsInterface;
import com.sas.graphics.chart.util.ctk.VisualizationComponentInterface;
import com.sas.graphics.chart.util.ctk.VisualizationGraphicsInterface;
import com.sas.graphics.chart.util.ctk.vtk.Point2;
import com.sas.graphics.util.Vec3d;
import com.sas.visuals.FullPaintInterface;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RootVisualizationContainer
extends Container
implements FullPaintInterface {
    static final long serialVersionUID = -1619122204863718809L;
    public static final String RB_KEY = "RootVisualizationContainer.";
    protected transient VTKVisualizationGraphicsInterface graphicsSource;
    protected transient VisualizationComponentInterface visualizationComponent;
    private transient int paintGate;
    private transient boolean paintPending;

    private RootVisualizationContainer() {
    }

    public static Object newInstance() {
        RootVisualizationContainer rvc = new RootVisualizationContainer();
        rvc.init();
        return rvc;
    }

    public static final RootVisualizationContainer newRootVisualizationContainer() {
        return (RootVisualizationContainer)RootVisualizationContainer.newInstance();
    }

    public void init() {
        this.graphicsSource = JXDVisualizationGraphics.newJXDVisualizationGraphics(this);
        ((JXDVisualizationGraphics)this.graphicsSource).setJavaComponent(this);
        this.enableEvents(16L);
        this.enableEvents(32L);
    }

    @Override
    protected synchronized void validateTree() {
        super.validateTree();
        if (this.visualizationComponent != null) {
            this.visualizationComponent.validate();
        }
        if (this.graphicsSource != null) {
            this.graphicsSource.setBackgroundColor(this.getBackgroundColor());
            this.graphicsSource.clear();
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        this.paintPending = true;
        if (this.graphicsSource != null && this.visualizationComponent != null && this.isFullPaintEnabled()) {
            this.paintPending = false;
            try {
                if (this.visualizationComponent.generateGraphics()) {
                    ((JXDVisualizationGraphics)this.graphicsSource).setState(true);
                    this.graphicsSource.redraw();
                }
            }
            catch (Exception e) {
                System.out.println(RB.getStringResource(RB_KEY, "renderError.txt"));
                ((JXDVisualizationGraphics)this.graphicsSource).setState(false);
                this.graphicsSource.redraw();
            }
        }
        this.graphicsSource.refresh(g);
    }

    @Override
    public synchronized void print(Graphics g) {
        if (this.graphicsSource != null && this.visualizationComponent != null) {
            try {
                this.visualizationComponent.generateGraphics();
                this.graphicsSource.print(g);
            }
            catch (Exception e) {
                System.out.println(RB.getStringResource(RB_KEY, "renderError.txt"));
            }
        }
    }

    public boolean isFullPaintEnabled() {
        return this.paintGate == 0;
    }

    @Override
    public void disableFullPaint() {
        ++this.paintGate;
    }

    @Override
    public synchronized void enableFullPaint() {
        this._enableFullPaint(true);
    }

    public synchronized void enableFullPaint(boolean updateNow) {
        this._enableFullPaint(updateNow);
    }

    private void _enableFullPaint(boolean updateNow) {
        this.paintGate = Math.max(0, this.paintGate - 1);
        if (this.isFullPaintEnabled() && this.paintPending) {
            this.paintPending = false;
            if (updateNow) {
                this.repaint();
            }
        }
    }

    public VisualizationGraphicsInterface getVisualizationGraphics() {
        return this.graphicsSource;
    }

    @Override
    public synchronized void processEvent(AWTEvent event) {
        if (this.graphicsSource != null) {
            this.graphicsSource.processEvent(event);
        }
        super.processEvent(event);
    }

    public synchronized VisualizationComponentInterface setVisualizationComponent(VisualizationComponentInterface newChild) {
        if (this.visualizationComponent == null && newChild != null) {
            try {
                newChild.setVisualizationGraphics(this.graphicsSource);
                ((JXDVisualizationGraphics)this.graphicsSource).setNetworkRoot(newChild.getNetworkRoot());
                this.visualizationComponent = newChild;
                return this.visualizationComponent;
            }
            catch (Exception exception) {
                this.invalidate();
            }
        } else if (this.visualizationComponent != null && newChild == null) {
            try {
                this.visualizationComponent.setVisualizationGraphics(null);
                ((JXDVisualizationGraphics)this.graphicsSource).setNetworkRoot(null);
                this.visualizationComponent = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.invalidate();
        }
        return null;
    }

    @Override
    public synchronized void doLayout() {
        if (this.graphicsSource != null) {
            this.graphicsSource.validate();
            if (this.visualizationComponent != null) {
                this.visualizationComponent.setOrigin(this.graphicsSource.getOrigin());
                this.visualizationComponent.setExtent(this.graphicsSource.getExtent());
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.graphicsSource != null) {
            this.graphicsSource.setBackgroundColor(color);
        }
    }

    @Override
    public synchronized Dimension getPreferredSize() {
        Vec3d extent;
        if (this.visualizationComponent != null && (extent = this.visualizationComponent.getPreferredExtent()) != null) {
            Point2 size = this.graphicsSource.world2Pixel(extent);
            return new Dimension((int)Math.abs(size.x), (int)Math.abs(size.y));
        }
        return new Dimension(0, 0);
    }

    @Override
    public synchronized Dimension getMinimumSize() {
        if (this.visualizationComponent != null) {
            Vec3d extent = this.visualizationComponent.getMinimumPartialExtent();
            if (extent == null) {
                extent = this.visualizationComponent.getMinimumExtent();
            }
            if (extent != null) {
                Point2 size = this.graphicsSource.world2Pixel(extent);
                return new Dimension((int)Math.abs(size.x), (int)Math.abs(size.y));
            }
        }
        return new Dimension();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private void writeObject(ObjectOutputStream out) {
    }

    private void readObject(ObjectInputStream in) {
    }
}

