/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.bean;

import com.sas.ModelInterface;
import com.sas.RunningObjectTable;
import com.sas.awt.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.PropertyBag;
import com.sas.collection.PropertyBagChangedEvent;
import com.sas.collection.PropertyBagChangedListener;
import com.sas.graphics.chart.bean.ChartContainer;
import com.sas.graphics.chart.bean.ColorLegend;
import com.sas.graphics.chart.bean.ColorLegendStyle;
import com.sas.graphics.chart.bean.ColorScheme;
import com.sas.graphics.chart.bean.ColorSchemeTypes;
import com.sas.graphics.chart.bean.DependentVariable;
import com.sas.graphics.chart.bean.LegendStyle;
import com.sas.graphics.chart.bean.RB;
import com.sas.graphics.chart.bean.RootVisualizationContainer;
import com.sas.graphics.chart.bean.SortTypes;
import com.sas.graphics.chart.bean.TextStyle;
import com.sas.graphics.chart.bean.Variable;
import com.sas.graphics.chart.bean.VariableRoleTypes;
import com.sas.graphics.chart.util.ctk.AnalysisVariableDefinition;
import com.sas.graphics.chart.util.ctk.AnalysisVariableDefinitionInterface;
import com.sas.graphics.chart.util.ctk.ClassifierVariableDefinitionInterface;
import com.sas.graphics.chart.util.ctk.DataSource;
import com.sas.graphics.chart.util.ctk.GridLayoutManager;
import com.sas.graphics.chart.util.ctk.JXDVisualizationGraphics;
import com.sas.graphics.chart.util.ctk.Legend;
import com.sas.graphics.chart.util.ctk.MapComponent;
import com.sas.graphics.chart.util.ctk.OverlayInterface;
import com.sas.graphics.chart.util.ctk.Prober;
import com.sas.graphics.chart.util.ctk.VariableDefinitionInterface;
import com.sas.graphics.chart.util.ctk.VisualizationContainer;
import com.sas.graphics.util.vtk.jxd.LegendScroller;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.util.UserCodeGenClassInterface;
import com.sas.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MapChart
extends ChartContainer
implements UserCodeGenClassInterface {
    public static final String RB_KEY = "MapChart.";
    static final long serialVersionUID = 4590313877111843983L;
    public static final String MAP_AREA_MODEL = "mapAreaModel";
    public static final String MAP_AREA_RESPONSE_MODEL = "mapAreaResponseModel";
    public static final String VARIABLE = "variable";
    private transient VariablePropertyChangeListener variablePropertyChangeListener;
    private transient Hashtable roleToVariable;
    private transient Hashtable variableToRole;
    private transient Hashtable variableToVariableDefinition;
    private transient Hashtable variableRoleTypes2CtkRole;
    private transient StaticRowTemplateTableInterface mapAreaModel;
    private transient StaticRowTemplateTableInterface mapAreaResponseModel;
    private transient MapComponent mapComponent;
    private transient Legend legend;
    private transient DataSource mapAreaDataSource;
    private transient DataSource mapAreaResponseDataSource;
    private transient MapAreaModelListener mapAreaModelListener;
    private transient MapAreaResponseModelListener mapAreaResponseModelListener;
    private transient RootVisualizationContainer mapRoot;
    private transient LegendScroller legendScroller;
    private transient Prober prober;
    private ColorLegend mapAreaResponseLegendBean;
    private MyMapAreaResponseLegendPropertyListener myMapAreaResponseLegendPropertyListener;
    private MyMapAreaResponseLegendStylePropertyListener myMapAreaResponseLegendStylePropertyListener;
    private static final String[] requiredInterfacesString1 = new String[]{"com.sas.table.StaticRowTemplateTableInterface"};
    private static final String[] requiredInterfacesString2 = new String[]{"com.sas.table.StaticColumnLabelInterface"};
    private static final String[][] AUTO_ID_LOOKUP_TABLE = new String[][]{{"Country", "Region"}, {"Country", "Lan"}, {"Country"}, {"Region"}, {"State", "County"}, {"State"}, {"County"}, {"Cont"}, {"Repid"}, {"SSR"}, {"Island"}, {"Province", "CDCode"}, {"Province"}, {"Id1", "Id2", "Id3", "Id4", "Id5"}, {"Id1", "Id2", "Id3", "Id4"}, {"Id1", "Id2", "Id3"}, {"Id1", "Id2"}, {"Id1"}};
    private static final String[] AUTO_COLOR_LOOKUP_TABLE = new String[]{"IDName", "IDName2", "Name", "Name2", "RegName", "LanName", "IsleName", "StateName", "Countynm", "Republic", "SSRName", "ASSR", "Region", "Position", "State", "County", "District", "Zone", "Parish", "Island", "IDCode", "CDCode", "ID", "Province", "ColorResponse", "Color", "Response"};
    private boolean colorVariableChangeOccured;
    private boolean mapAreaContentsChangeOccured;
    private boolean mapAreaResponseContentsChangeOccured;
    protected static final String VERSION_1_DOT_2 = "Version: 1.2";
    private transient Storage storage;

    public String getUserCodeGenClass() {
        String com = "com";
        return com + ".sas.ide.codeGen.UserCodeGenMapChart";
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", MAP_AREA_MODEL}, {"Short description", RB.getStringResource(RB_KEY, "mapAreaModel.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "mapAreaModel.pd.txt")}, {"Property editor class", "com.sas.graphics.chart.bean.MapChartModelInstanceEditor"}}, {{"Name", MAP_AREA_RESPONSE_MODEL}, {"Short description", RB.getStringResource(RB_KEY, "mapAreaResponseModel.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "mapAreaResponseModel.pd.txt")}, {"Property editor class", "com.sas.graphics.chart.bean.MapChartModelInstanceEditor"}}, {{"Name", "colorVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.DependentVariableInstanceEditor"}}, {{"Name", "segmentVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "XVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "YVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "ID1Variable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "ID2Variable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "ID3Variable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.ebi.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.init();
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(2);
        requiredInterfaces.addElement(requiredInterfacesString1);
        requiredInterfaces.addElement(requiredInterfacesString2);
        return requiredInterfaces;
    }

    private void init() {
        this.mapAreaDataSource = new DataSource();
        this.mapAreaDataSource.setStatisticsEnabled(false);
        this.mapAreaDataSource.setDataCachingEnabled(true);
        this.mapAreaResponseDataSource = new DataSource();
        this.mapAreaResponseDataSource.setStatisticsEnabled(true);
        this.mapAreaResponseDataSource.setDataCachingEnabled(true);
        this.mapAreaModelListener = new MapAreaModelListener();
        this.mapAreaResponseModelListener = new MapAreaResponseModelListener();
        this.mapComponent = MapComponent.newMapComponent();
        this._addMapComponent(this.mapComponent);
        this.mapComponent.setMapAreaDataSource(this.mapAreaDataSource);
        this.mapComponent.setMapAreaResponseDataSource(this.mapAreaResponseDataSource);
        this.roleToVariable = new Hashtable();
        this.variableToRole = new Hashtable();
        this.variableToVariableDefinition = new Hashtable();
        this.variablePropertyChangeListener = new VariablePropertyChangeListener();
        this.variableRoleTypes2CtkRole = new Hashtable();
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.X, OverlayInterface.VariableRoles.X);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.Y, OverlayInterface.VariableRoles.Y);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.COLOR, OverlayInterface.VariableRoles.COLOR);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.SEGMENT, OverlayInterface.VariableRoles.SEGMENT);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID1, OverlayInterface.VariableRoles.ID1);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID2, OverlayInterface.VariableRoles.ID2);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID3, OverlayInterface.VariableRoles.ID3);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID4, OverlayInterface.VariableRoles.ID4);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID5, OverlayInterface.VariableRoles.ID5);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID6, OverlayInterface.VariableRoles.ID6);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID7, OverlayInterface.VariableRoles.ID7);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID8, OverlayInterface.VariableRoles.ID8);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID9, OverlayInterface.VariableRoles.ID9);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID10, OverlayInterface.VariableRoles.ID10);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID11, OverlayInterface.VariableRoles.ID11);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID12, OverlayInterface.VariableRoles.ID12);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID13, OverlayInterface.VariableRoles.ID13);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID14, OverlayInterface.VariableRoles.ID14);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID15, OverlayInterface.VariableRoles.ID15);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID16, OverlayInterface.VariableRoles.ID16);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID17, OverlayInterface.VariableRoles.ID17);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID18, OverlayInterface.VariableRoles.ID18);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID19, OverlayInterface.VariableRoles.ID19);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID20, OverlayInterface.VariableRoles.ID20);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID21, OverlayInterface.VariableRoles.ID21);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID22, OverlayInterface.VariableRoles.ID22);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID23, OverlayInterface.VariableRoles.ID23);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID24, OverlayInterface.VariableRoles.ID24);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID25, OverlayInterface.VariableRoles.ID25);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID26, OverlayInterface.VariableRoles.ID26);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID27, OverlayInterface.VariableRoles.ID27);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID28, OverlayInterface.VariableRoles.ID28);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID29, OverlayInterface.VariableRoles.ID29);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID30, OverlayInterface.VariableRoles.ID30);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID31, OverlayInterface.VariableRoles.ID31);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ID32, OverlayInterface.VariableRoles.ID32);
    }

    private void _addMapComponent(MapComponent mapComponent) {
        this.mapRoot = this._createMapAwtContainer(mapComponent);
        if (this.mapRoot != null) {
            this.mapRoot.setBackgroundColor(this.getBackground());
            this.setInChartContainer(this.mapRoot);
            this.legend = mapComponent.getLegend(OverlayInterface.VariableRoles.COLOR);
            this.legendScroller = new LegendScroller();
            this.legend.vtkLegend.getStyle().setBorderOn(true);
            this.legendScroller.setLegend(this.legend.vtkLegend);
            this.legendScroller.setBackground(this.getBackground());
            this.setInLegendContainer(this.legendScroller);
        }
    }

    private RootVisualizationContainer _createMapAwtContainer(MapComponent mapComponent) {
        VisualizationContainer chartArea = VisualizationContainer.newVisualizationContainer();
        GridLayoutManager chartAreaLayoutManager = new GridLayoutManager();
        GridLayoutManager.GridConstraintInterface constraints = chartAreaLayoutManager.newDefaultConstraint();
        chartArea.setVisualizationLayoutManager(chartAreaLayoutManager);
        constraints.setRow(1);
        constraints.setColumn(1);
        chartArea.add(mapComponent, constraints);
        RootVisualizationContainer mapRoot = RootVisualizationContainer.newRootVisualizationContainer();
        mapRoot.setVisualizationComponent(chartArea);
        this.prober = new Prober(mapComponent);
        this.prober.setContinuousUpdateEnabled(true);
        mapComponent.addMouseListener(this.prober);
        mapComponent.addMouseMotionListener(this.prober);
        JXDVisualizationGraphics graphicsSource = (JXDVisualizationGraphics)mapRoot.getVisualizationGraphics();
        graphicsSource.addDisplayUpdateActionListener(this.prober.getDisplayUpdateListener());
        graphicsSource.setCullFaceEnabled(false);
        graphicsSource.setLightingEnabled(false);
        graphicsSource.setDepthTestEnabled(false);
        return mapRoot;
    }

    @Override
    public void disableFullPaint() {
        super.disableFullPaint();
    }

    @Override
    public void enableFullPaint() {
        super.enableFullPaint();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public ColorLegend getMapAreaResponseLegend() {
        if (this.mapAreaResponseLegendBean == null) {
            this.mapAreaResponseLegendBean = new ColorLegend();
            this.mapAreaResponseLegendBean.initialize();
            this.myMapAreaResponseLegendPropertyListener = new MyMapAreaResponseLegendPropertyListener();
            this.mapAreaResponseLegendBean.addPropertyChangeListener(this.myMapAreaResponseLegendPropertyListener);
            this.myMapAreaResponseLegendStylePropertyListener = new MyMapAreaResponseLegendStylePropertyListener();
            this.mapAreaResponseLegendBean.getStyle().addPropertyBagChangedListener(this.myMapAreaResponseLegendStylePropertyListener);
        }
        return this.mapAreaResponseLegendBean;
    }

    private void _conveyMapAreaResponseLegendStyles(ColorLegendStyle colorLegendStyle) {
        if (colorLegendStyle != null) {
            Color[] colorTable;
            com.sas.graphics.chart.util.ctk.ColorLegend legend = (com.sas.graphics.chart.util.ctk.ColorLegend)this.mapComponent.getLegend(OverlayInterface.VariableRoles.COLOR);
            com.sas.graphics.util.vtk.LegendStyle vtkLegendStyle = legend.getLegendStyle();
            int categorizationType = colorLegendStyle.isContinuousSet() && !colorLegendStyle.isContinuous() ? 1 : 0;
            this.mapComponent.setColorVariableCategorization(categorizationType);
            ColorScheme colorScheme = colorLegendStyle.getColorScheme();
            Color outOfBoundsColor = colorScheme.getOutOfBoundsColor();
            if (outOfBoundsColor == null) {
                outOfBoundsColor = Color.lightGray;
            }
            if ((colorTable = colorScheme.getColorScheme()) == null) {
                ColorSchemeTypes colorSchemeType = colorScheme.getColorSchemeType();
                if (colorSchemeType == null) {
                    colorSchemeType = ColorSchemeTypes.JAVACOLOR;
                }
                colorTable = com.sas.graphics.chart.util.ctk.vtk.ColorScheme.getColorTable(colorSchemeType.getValue());
            }
            if (colorTable != null) {
                legend.setColorScheme(colorTable);
                legend.setOutOfBoundsColor(outOfBoundsColor);
                this.mapComponent.hackjsh();
                this.legendScroller.repaint();
            }
            if (colorLegendStyle.isVisible()) {
                this.setInLegendContainer(this.legendScroller);
            } else {
                this.setInLegendContainer(null);
            }
            SortTypes sortType = colorLegendStyle.getSort();
            Integer ctkSortType = OverlayInterface.SortTypes.NONE;
            if (sortType == SortTypes.ASCENDING) {
                ctkSortType = OverlayInterface.SortTypes.ASCENDING;
            } else if (sortType == SortTypes.DESCENDING) {
                ctkSortType = OverlayInterface.SortTypes.DESCENDING;
            }
            legend.setSortType(ctkSortType);
            vtkLegendStyle.setTitleOn(colorLegendStyle.getTitleTextStyle().isVisible());
            TextStyle titleTextStyle = colorLegendStyle.getTitleTextStyle();
            Font titleFont = this.getFont();
            if (titleTextStyle != null) {
                if (titleTextStyle.isColorSet()) {
                    vtkLegendStyle.getTitleStyle().setColor(titleTextStyle.getColor());
                }
                if (titleTextStyle.isFontSet()) {
                    titleFont = titleTextStyle.getFont();
                }
            }
            vtkLegendStyle.getTitleStyle().setFont(titleFont);
            vtkLegendStyle.setLabelsOn(colorLegendStyle.getValueTextStyle().isVisible());
            TextStyle valueTextStyle = colorLegendStyle.getValueTextStyle();
            Font valueFont = this.getFont();
            if (valueTextStyle != null) {
                if (titleTextStyle.isColorSet()) {
                    vtkLegendStyle.getLabelStyle().setColor(valueTextStyle.getColor());
                }
                if (valueTextStyle.isFontSet()) {
                    valueFont = valueTextStyle.getFont();
                }
            }
            vtkLegendStyle.getLabelStyle().setFont(valueFont);
            vtkLegendStyle.setBorderOn(colorLegendStyle.getOutlineLineStyle().isVisible());
            legend.setBorderColor(colorLegendStyle.getOutlineLineStyle().getColor());
        }
    }

    public PropertyBag getStyles() {
        return new PropertyBag();
    }

    public Variable getVariable(VariableRoleTypes role) {
        return this._getVariable(role);
    }

    public void setVariable(VariableRoleTypes role, Variable newVariable) {
        Variable oldVariable = this._setVariable(role, newVariable);
        if (Util.unequal((Object)oldVariable, (Object)newVariable)) {
            this.firePropertyChange(role.toString().toLowerCase() + "Variable", oldVariable, newVariable);
        }
    }

    public void removeVariable(VariableRoleTypes role) {
        this.setVariable(role, null);
    }

    protected Variable _getVariable(VariableRoleTypes role) {
        if (role == null) {
            throw new IllegalArgumentException();
        }
        Variable variable = (Variable)this.roleToVariable.get((Object)role);
        if (variable == null) {
            if (role.getValue() >= VariableRoleTypes.ID1.getValue() && role.getValue() <= VariableRoleTypes.ID32.getValue()) {
                variable = new Variable();
            } else if (role == VariableRoleTypes.COLOR) {
                variable = new DependentVariable();
            } else if (role == VariableRoleTypes.X || role == VariableRoleTypes.Y || role == VariableRoleTypes.SEGMENT) {
                variable = new Variable();
            } else {
                throw new IllegalArgumentException();
            }
            this._setVariable(role, variable);
        }
        return variable;
    }

    protected Variable _setVariable(VariableRoleTypes role, Variable newVariable) {
        Object ctkRole = this.variableRoleTypes2CtkRole.get((Object)role);
        if (role != null && ctkRole != null) {
            Variable oldVariable = (Variable)this.roleToVariable.get((Object)role);
            if (oldVariable != newVariable) {
                this.disableFullPaint();
                if (oldVariable != null) {
                    oldVariable.removePropertyChangeListener((PropertyChangeListener)((Object)this.variablePropertyChangeListener));
                    this.roleToVariable.remove((Object)role);
                    this.variableToRole.remove(oldVariable);
                    this.variableToVariableDefinition.remove(oldVariable);
                    if (!oldVariable.isAutomatic()) {
                        if (role.getValue() >= VariableRoleTypes.ID1.getValue() && role.getValue() <= VariableRoleTypes.ID32.getValue()) {
                            this.mapAreaDataSource.removeVariable(ctkRole);
                            this.mapAreaResponseDataSource.removeVariable(ctkRole);
                        } else if (role == VariableRoleTypes.X || role == VariableRoleTypes.Y || role == VariableRoleTypes.SEGMENT) {
                            this.mapAreaDataSource.removeVariable(ctkRole);
                        } else if (role == VariableRoleTypes.COLOR) {
                            this.mapAreaResponseDataSource.removeVariable(ctkRole);
                        }
                    }
                }
                if (newVariable != null) {
                    boolean attachVars;
                    newVariable.addPropertyChangeListener((PropertyChangeListener)((Object)this.variablePropertyChangeListener));
                    this.roleToVariable.put(role, newVariable);
                    this.variableToRole.put(newVariable, role);
                    boolean bl = attachVars = (newVariable == null || newVariable.isAutomatic()) && oldVariable != null && !oldVariable.isAutomatic();
                    if (role.getValue() >= VariableRoleTypes.ID1.getValue() && role.getValue() <= VariableRoleTypes.ID32.getValue()) {
                        ClassifierVariableDefinitionInterface newVariableDefinition = this._conveyVariableToVariableDefinition(newVariable, (ClassifierVariableDefinitionInterface)null);
                        this.variableToVariableDefinition.put(newVariable, newVariableDefinition);
                        this.mapAreaDataSource.removeAllVariables();
                        this.mapAreaResponseDataSource.removeAllVariables();
                        this.attachMapAreaVariables();
                    } else if (role == VariableRoleTypes.X || role == VariableRoleTypes.Y || role == VariableRoleTypes.SEGMENT) {
                        AnalysisVariableDefinitionInterface newVariableDefinition = this._conveyVariableToVariableDefinition(newVariable, (AnalysisVariableDefinitionInterface)null);
                        this.variableToVariableDefinition.put(newVariable, newVariableDefinition);
                        if (!newVariable.isAutomatic()) {
                            this.mapAreaDataSource.setVariable(ctkRole, newVariableDefinition);
                        } else if (attachVars) {
                            this.attachMapAreaVariables();
                        }
                    } else if (role == VariableRoleTypes.COLOR) {
                        AnalysisVariableDefinitionInterface newVariableDefinition = this._conveyVariableToVariableDefinition(newVariable, (AnalysisVariableDefinitionInterface)null);
                        this.variableToVariableDefinition.put(newVariable, newVariableDefinition);
                        if (!newVariable.isAutomatic()) {
                            this.mapAreaResponseDataSource.setVariable(ctkRole, newVariableDefinition);
                        } else if (attachVars) {
                            this.attachMapAreaResponseVariables();
                        }
                    }
                }
                this.enableFullPaint();
            }
            return oldVariable;
        }
        throw new IllegalArgumentException();
    }

    public final void removeIDVariable(int index) {
        this.setIDVariable(index, null);
    }

    public final void setIDVariable(int index, Variable variable) {
        if (1 > index || index > 32) {
            throw new IllegalArgumentException();
        }
        VariableRoleTypes role = VariableRoleTypes.getEnum(VariableRoleTypes.ID1.getValue() + index - 1);
        if (role == null) {
            throw new IllegalArgumentException();
        }
        this.setVariable(role, variable);
    }

    public final Variable getIDVariable(int index) {
        if (1 > index || index > 32) {
            throw new IllegalArgumentException();
        }
        VariableRoleTypes role = VariableRoleTypes.getEnum(VariableRoleTypes.ID1.getValue() + index - 1);
        if (role == null) {
            throw new IllegalArgumentException();
        }
        return this._getVariable(role);
    }

    public final Variable getID1Variable() {
        return this._getVariable(VariableRoleTypes.ID1);
    }

    public final void setID1Variable(Variable variable) {
        this.setVariable(VariableRoleTypes.ID1, variable);
    }

    public final void removeID1Variable() {
        this.removeVariable(VariableRoleTypes.ID1);
    }

    public final Variable getID2Variable() {
        return this._getVariable(VariableRoleTypes.ID2);
    }

    public final void setID2Variable(Variable variable) {
        this.setVariable(VariableRoleTypes.ID2, variable);
    }

    public final void removeID2Variable() {
        this.removeVariable(VariableRoleTypes.ID2);
    }

    public final Variable getID3Variable() {
        return this._getVariable(VariableRoleTypes.ID3);
    }

    public final void setID3Variable(Variable variable) {
        this.setVariable(VariableRoleTypes.ID3, variable);
    }

    public final void removeID3Variable() {
        this.removeVariable(VariableRoleTypes.ID3);
    }

    public final DependentVariable getColorVariable() {
        return (DependentVariable)this._getVariable(VariableRoleTypes.COLOR);
    }

    public final void setColorVariable(DependentVariable variable) {
        this.setVariable(VariableRoleTypes.COLOR, variable);
    }

    public final void removeColorVariable() {
        this.removeVariable(VariableRoleTypes.COLOR);
    }

    public final Variable getXVariable() {
        return this._getVariable(VariableRoleTypes.X);
    }

    public final void setXVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.X, variable);
    }

    public final void removeXVariable() {
        this.removeVariable(VariableRoleTypes.X);
    }

    public final Variable getYVariable() {
        return this._getVariable(VariableRoleTypes.Y);
    }

    public final void setYVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.Y, variable);
    }

    public final void removeYVariable() {
        this.removeVariable(VariableRoleTypes.Y);
    }

    public final Variable getSegmentVariable() {
        return this._getVariable(VariableRoleTypes.SEGMENT);
    }

    public final void setSegmentVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.SEGMENT, variable);
    }

    public final void removeSegmentVariable() {
        this.removeVariable(VariableRoleTypes.SEGMENT);
    }

    @Override
    public final synchronized void setModelInterface(ModelInterface newValue) {
        super.setModelInterface(newValue);
        this._setMapAreaModel((StaticRowTemplateTableInterface)newValue);
    }

    public synchronized void setMapAreaModel(StaticRowTemplateTableInterface newValue) {
        StaticRowTemplateTableInterface oldValue = this.getMapAreaModel();
        this._setMapAreaModel(newValue);
        newValue = this.getMapAreaModel();
        if (Util.unequal((Object)oldValue, (Object)newValue)) {
            this.firePropertyChange(MAP_AREA_MODEL, oldValue, newValue);
        }
    }

    private void _setMapAreaModel(StaticRowTemplateTableInterface newValue) {
        if (newValue == null || newValue instanceof StaticColumnLabelInterface) {
            if (this.mapAreaModel != null) {
                this.detachMapAreaModel(this.mapAreaModel);
            }
            this.mapAreaModel = newValue;
            if (this.mapAreaModel != null) {
                this.attachMapAreaModel(this.mapAreaModel);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public synchronized StaticRowTemplateTableInterface getMapAreaModel() {
        return this.mapAreaModel;
    }

    public synchronized void setMapAreaResponseModel(StaticRowTemplateTableInterface newValue) {
        StaticRowTemplateTableInterface oldValue = this.getMapAreaResponseModel();
        this._setMapAreaResponseModel(newValue);
        newValue = this.getMapAreaResponseModel();
        if (Util.unequal((Object)oldValue, (Object)newValue)) {
            this.firePropertyChange(MAP_AREA_RESPONSE_MODEL, oldValue, newValue);
        }
    }

    private void _setMapAreaResponseModel(StaticRowTemplateTableInterface newValue) {
        if (newValue == null || newValue instanceof StaticColumnLabelInterface) {
            if (this.mapAreaResponseModel != null) {
                this.detachMapAreaResponseModel(this.mapAreaResponseModel);
            }
            this.mapAreaResponseModel = newValue;
            if (this.mapAreaResponseModel != null) {
                this.attachMapAreaResponseModel(this.mapAreaResponseModel);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public synchronized StaticRowTemplateTableInterface getMapAreaResponseModel() {
        return this.mapAreaResponseModel;
    }

    @Override
    public void refresh(ModelInterface model) {
        super.refresh(model);
    }

    private void attachMapAreaModel(StaticRowTemplateTableInterface model) {
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this.mapAreaModelListener);
        }
        this.disableFullPaint();
        this.mapAreaDataSource.setDataSource(model);
        this.attachMapAreaVariables();
        this.enableFullPaint();
        this.legendScroller.invalidate();
        this.validate();
    }

    private void attachMapAreaResponseModel(StaticRowTemplateTableInterface model) {
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this.mapAreaResponseModelListener);
        }
        this.disableFullPaint();
        this.mapAreaResponseDataSource.setDataSource(model);
        this.attachMapAreaResponseVariables();
        this.enableFullPaint();
        this.legendScroller.invalidate();
        this.validate();
    }

    public void detachMapAreaModel(StaticRowTemplateTableInterface model) {
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this.mapAreaModelListener);
        }
        this.disableFullPaint();
        this.mapAreaDataSource.removeAllVariables();
        this.mapAreaDataSource.setDataSource(null);
        this.enableFullPaint();
    }

    public void detachMapAreaResponseModel(StaticRowTemplateTableInterface model) {
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this.mapAreaResponseModelListener);
        }
        this.disableFullPaint();
        this.mapAreaResponseDataSource.removeAllVariables();
        this.mapAreaResponseDataSource.setDataSource(null);
        this.enableFullPaint();
    }

    private void _autoSelectIDVariables() {
        this._autoSelectMapAreaIDVariables();
        this._autoSelectMapAreaResponseIDVariables();
    }

    private void _autoSelectMapAreaIDVariables() {
        String[] idVarNames = null;
        for (int ii = 0; ii < AUTO_ID_LOOKUP_TABLE.length; ++ii) {
            String[] stringArray;
            boolean fountIDMatch = true;
            idVarNames = AUTO_ID_LOOKUP_TABLE[ii];
            for (int jj = 0; fountIDMatch && jj < idVarNames.length; ++jj) {
                fountIDMatch = this.mapAreaDataSource.getColumnName(idVarNames[jj]) != null;
            }
            if (ii == AUTO_ID_LOOKUP_TABLE.length - 1 && !fountIDMatch) {
                idVarNames = new String[]{};
                fountIDMatch = true;
            }
            if (!fountIDMatch) continue;
            if (this.mapAreaDataSource.getColumnName("Id") != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "Id";
            } else {
                stringArray = new String[]{};
            }
            String[] extra = stringArray;
            int ID1Value = VariableRoleTypes.ID1.getValue();
            for (int jj = 0; jj < idVarNames.length + extra.length; ++jj) {
                VariableRoleTypes id = VariableRoleTypes.getEnum(ID1Value + jj);
                String idVarName = jj < idVarNames.length ? idVarNames[jj] : extra[jj - idVarNames.length];
                Object ctkRole = this.variableRoleTypes2CtkRole.get((Object)id);
                VariableRoleTypes role = VariableRoleTypes.getEnum(ID1Value + jj);
                Variable variable = (Variable)this.roleToVariable.get((Object)role);
                try {
                    variable = variable == null ? new Variable() : (Variable)variable.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                variable.setColumnName(idVarName);
                ClassifierVariableDefinitionInterface varDef = this._conveyVariableToVariableDefinition(variable, (ClassifierVariableDefinitionInterface)null);
                this.mapAreaDataSource.setVariable(ctkRole, varDef);
            }
            break;
        }
    }

    private void _autoSelectMapAreaResponseIDVariables() {
        int ID1Value = VariableRoleTypes.ID1.getValue();
        int ID32Value = VariableRoleTypes.ID32.getValue();
        for (int jj = ID1Value; jj <= ID32Value; ++jj) {
            Object ctkRole = this.variableRoleTypes2CtkRole.get((Object)VariableRoleTypes.getEnum(jj));
            VariableDefinitionInterface varDef = this.mapAreaDataSource.getVariable(ctkRole);
            if (varDef == null) continue;
            varDef = this.mapAreaResponseDataSource.setVariable(ctkRole, varDef);
        }
    }

    protected synchronized void attachMapAreaVariables() {
        Object ctkRole;
        VariableDefinitionInterface varDef;
        Variable variable;
        VariableRoleTypes role;
        this.disableFullPaint();
        this.mapAreaDataSource.disableEvents();
        this.mapAreaResponseDataSource.disableEvents();
        boolean autoSelectIDVariables = true;
        int ID1Value = VariableRoleTypes.ID1.getValue();
        int ID32Value = VariableRoleTypes.ID32.getValue();
        for (int jj = ID1Value; jj <= ID32Value; ++jj) {
            role = VariableRoleTypes.getEnum(jj);
            variable = (Variable)this.roleToVariable.get((Object)role);
            if (variable == null || variable.isAutomatic()) continue;
            autoSelectIDVariables = false;
            varDef = (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
            ctkRole = this.variableRoleTypes2CtkRole.get((Object)role);
            this.mapAreaDataSource.setVariable(ctkRole, varDef);
            this.mapAreaResponseDataSource.setVariable(ctkRole, varDef);
        }
        if (autoSelectIDVariables) {
            this._autoSelectIDVariables();
        }
        role = VariableRoleTypes.SEGMENT;
        ctkRole = this.variableRoleTypes2CtkRole.get((Object)role);
        variable = (Variable)this.roleToVariable.get((Object)role);
        if (variable == null || variable.isAutomatic()) {
            Variable attemptVariable = null;
            try {
                attemptVariable = variable == null ? new Variable() : (Variable)variable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            varDef = variable == null ? null : (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
            attemptVariable.setColumnName("segment");
            varDef = this._conveyVariableToVariableDefinition(attemptVariable, (AnalysisVariableDefinition)varDef);
            if (this.mapAreaDataSource.columnExists(varDef)) {
                this.mapAreaDataSource.setVariable(ctkRole, varDef);
            }
        } else {
            varDef = (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
            this.mapAreaDataSource.setVariable(ctkRole, varDef);
        }
        role = VariableRoleTypes.X;
        ctkRole = this.variableRoleTypes2CtkRole.get((Object)role);
        variable = (Variable)this.roleToVariable.get((Object)role);
        if (variable == null || variable.isAutomatic()) {
            Variable attemptVariable = null;
            try {
                attemptVariable = variable == null ? new Variable() : (Variable)variable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            varDef = variable == null ? null : (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
            attemptVariable.setColumnName("x");
            varDef = this._conveyVariableToVariableDefinition(attemptVariable, (AnalysisVariableDefinition)varDef);
            if (this.mapAreaDataSource.columnExists(varDef)) {
                this.mapAreaDataSource.setVariable(ctkRole, varDef);
            }
        } else {
            varDef = (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
            this.mapAreaDataSource.setVariable(ctkRole, varDef);
        }
        role = VariableRoleTypes.Y;
        ctkRole = this.variableRoleTypes2CtkRole.get((Object)role);
        variable = (Variable)this.roleToVariable.get((Object)role);
        if (variable == null || variable.isAutomatic()) {
            Variable attemptVariable = null;
            try {
                attemptVariable = variable == null ? new Variable() : (Variable)variable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            varDef = variable == null ? null : (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
            attemptVariable.setColumnName("y");
            varDef = this._conveyVariableToVariableDefinition(attemptVariable, (AnalysisVariableDefinition)varDef);
            if (this.mapAreaDataSource.columnExists(varDef)) {
                this.mapAreaDataSource.setVariable(ctkRole, varDef);
            }
        } else {
            varDef = (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
            this.mapAreaDataSource.setVariable(ctkRole, varDef);
        }
        this.mapAreaDataSource.enableEvents();
        this.mapAreaResponseDataSource.enableEvents(false);
        this.enableFullPaint();
    }

    protected synchronized void attachMapAreaResponseVariables() {
        this.mapAreaResponseDataSource.disableEvents();
        this._autoSelectMapAreaResponseIDVariables();
        VariableRoleTypes role = VariableRoleTypes.COLOR;
        Object ctkRole = this.variableRoleTypes2CtkRole.get((Object)role);
        Variable variable = (Variable)this.roleToVariable.get((Object)role);
        if (variable == null || variable.isAutomatic()) {
            VariableDefinitionInterface id1VarDef;
            Variable attemptVariable = null;
            try {
                attemptVariable = variable == null ? new DependentVariable() : (Variable)variable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            boolean found = false;
            VariableDefinitionInterface varDef = variable == null ? null : (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
            for (int ii = 0; !found && ii < AUTO_COLOR_LOOKUP_TABLE.length; ++ii) {
                attemptVariable.setColumnName(AUTO_COLOR_LOOKUP_TABLE[ii]);
                varDef = this._conveyVariableToVariableDefinition(attemptVariable, (AnalysisVariableDefinition)varDef);
                found = this.mapAreaResponseDataSource.columnExists(varDef);
                if (!found) continue;
                this.mapAreaResponseDataSource.setVariable(ctkRole, varDef);
            }
            if (!found && (id1VarDef = this.mapAreaResponseDataSource.getVariable(OverlayInterface.VariableRoles.ID1)) != null) {
                if (id1VarDef.getName() != null) {
                    attemptVariable.setColumnName(id1VarDef.getName());
                } else if (id1VarDef.getLabel() != null) {
                    attemptVariable.setColumnLabel(id1VarDef.getLabel());
                } else if (id1VarDef.getIndex() != null) {
                    attemptVariable.setColumnIndex(id1VarDef.getIndex());
                }
                varDef = this._conveyVariableToVariableDefinition(attemptVariable, (AnalysisVariableDefinition)varDef);
                if (this.mapAreaResponseDataSource.columnExists(varDef)) {
                    this.mapAreaResponseDataSource.setVariable(ctkRole, varDef);
                }
            }
        } else {
            VariableDefinitionInterface varDef = (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
            this.mapAreaResponseDataSource.setVariable(ctkRole, varDef);
        }
        this.mapAreaResponseDataSource.enableEvents();
    }

    @Override
    public void paint(Graphics g) {
        if (this.mapAreaContentsChangeOccured) {
            this._processMapAreaContentsChanged();
        } else if (this.mapAreaResponseContentsChangeOccured) {
            this._processMapAreaResponseContentsChanged();
        } else if (this.colorVariableChangeOccured) {
            this.colorVariableChangeOccured = false;
            this.legendScroller.invalidate();
            this.validate();
        }
        super.paint(g);
    }

    private void _processMapAreaContentsChanged() {
        this.mapAreaContentsChangeOccured = false;
        this.mapAreaResponseContentsChangeOccured = false;
        this.colorVariableChangeOccured = false;
        this.disableFullPaint();
        this.mapAreaDataSource.disableEvents();
        this.mapAreaResponseDataSource.disableEvents();
        this.mapAreaDataSource.removeAllVariables();
        this.mapAreaResponseDataSource.removeAllVariables();
        this.mapAreaDataSource.reset();
        this.mapAreaResponseDataSource.reset();
        this.attachMapAreaVariables();
        this.attachMapAreaResponseVariables();
        this.mapAreaResponseDataSource.enableEvents(false);
        this.mapAreaDataSource.enableEvents();
        this.enableFullPaint(false);
        this.legendScroller.invalidate();
        this.validate();
    }

    private void _processMapAreaResponseContentsChanged() {
        this.mapAreaResponseContentsChangeOccured = false;
        this.colorVariableChangeOccured = false;
        this.disableFullPaint();
        this.mapAreaResponseDataSource.disableEvents();
        this.mapAreaResponseDataSource.removeAllVariables();
        this.mapAreaResponseDataSource.reset();
        this.attachMapAreaResponseVariables();
        this.mapAreaResponseDataSource.enableEvents();
        this.enableFullPaint(false);
        this.legendScroller.invalidate();
        this.validate();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(VERSION_1_DOT_2);
        this._writeVer1Dot2(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            String version = (String)in.readObject();
            this.storage = VERSION_1_DOT_2.equals(version) ? this._readVer1Dot2(in) : null;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void _writeVer1Dot2(ObjectOutputStream out) throws IOException {
        ModelInterface modelInterface = this.getModelInterface();
        if (this.isDesignTime()) {
            if (modelInterface == null && this.mapAreaModel != null && RunningObjectTable.lookupComponentName((Object)this.mapAreaModel) == null) {
                this._setMapAreaModel(null);
            }
            if (this.mapAreaResponseModel != null && RunningObjectTable.lookupComponentName((Object)this.mapAreaResponseModel) == null) {
                this._setMapAreaResponseModel(null);
            }
        }
        out.writeObject(modelInterface == null ? this.mapAreaModel : null);
        out.writeObject(this.mapAreaResponseModel);
        Enumeration roles = this.roleToVariable.keys();
        while (roles.hasMoreElements()) {
            VariableRoleTypes role = (VariableRoleTypes)((Object)roles.nextElement());
            Variable variable = (Variable)this.roleToVariable.get((Object)role);
            out.writeObject(role.toString());
            out.writeObject(variable);
        }
        out.writeObject("EOV");
        out.writeObject(this.mapAreaResponseLegendBean);
    }

    private Storage _readVer1Dot2(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String roleName;
        Storage storage = new Storage();
        storage.mapAreaModel = (StaticRowTemplateTableInterface)in.readObject();
        storage.mapAreaResponseModel = (StaticRowTemplateTableInterface)in.readObject();
        storage.roleToVariable = new Hashtable();
        while (!"EOV".equals(roleName = (String)in.readObject())) {
            VariableRoleTypes role = VariableRoleTypes.get(roleName);
            Variable variable = (Variable)in.readObject();
            storage.roleToVariable.put(role, variable);
        }
        storage.mapAreaResponseLegendBean = (ColorLegend)in.readObject();
        return storage;
    }

    @Override
    protected void restore() {
        this.disableFullPaint();
        super.restore();
        if (this.storage != null) {
            if (this.storage.mapAreaModel != null) {
                this.setMapAreaModel(this.storage.mapAreaModel);
            }
            if (this.storage.mapAreaResponseModel != null) {
                this.setMapAreaResponseModel(this.storage.mapAreaResponseModel);
            }
            Enumeration roles = this.storage.roleToVariable.keys();
            while (roles.hasMoreElements()) {
                VariableRoleTypes role = (VariableRoleTypes)((Object)roles.nextElement());
                Variable variable = (Variable)this.storage.roleToVariable.get((Object)role);
                this._setVariable(role, variable);
            }
            this.mapAreaResponseLegendBean = this.storage.mapAreaResponseLegendBean;
            if (this.mapAreaResponseLegendBean != null) {
                this._conveyMapAreaResponseLegendStyles((ColorLegendStyle)this.mapAreaResponseLegendBean.getEffectiveStyle());
            }
            this.storage = null;
        }
        this.enableFullPaint(true);
    }

    private class MyMapAreaResponseLegendStylePropertyListener
    implements PropertyBagChangedListener,
    Serializable {
        private MyMapAreaResponseLegendStylePropertyListener() {
        }

        public void propertyBagChanged(PropertyBagChangedEvent e) {
            if (MapChart.this.mapAreaResponseLegendBean != null) {
                MapChart.this._conveyMapAreaResponseLegendStyles((ColorLegendStyle)MapChart.this.mapAreaResponseLegendBean.getEffectiveStyle());
            }
        }
    }

    private class MapAreaModelListener
    implements ContentsChangedListener {
        private MapAreaModelListener() {
        }

        public void contentsChanged(ContentsChangedEvent e) {
            MapChart.this.mapAreaContentsChangeOccured = true;
            MapChart.this.repaint();
        }
    }

    private class MapAreaResponseModelListener
    implements ContentsChangedListener {
        private MapAreaResponseModelListener() {
        }

        public void contentsChanged(ContentsChangedEvent e) {
            MapChart.this.mapAreaResponseContentsChangeOccured = true;
            MapChart.this.repaint();
        }
    }

    private class VariablePropertyChangeListener
    extends Component {
        private VariablePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String propertyName = pce.getPropertyName();
            if (propertyName == null) {
                return;
            }
            Variable variable = (Variable)pce.getSource();
            if (variable != null) {
                MapChart.this.disableFullPaint();
                VariableRoleTypes role = (VariableRoleTypes)((Object)MapChart.this.variableToRole.get(variable));
                Object ctkRole = MapChart.this.variableRoleTypes2CtkRole.get((Object)role);
                if (role != null && ctkRole != null) {
                    VariableDefinitionInterface variableDefinition = (VariableDefinitionInterface)MapChart.this.variableToVariableDefinition.get(variable);
                    if (variableDefinition instanceof AnalysisVariableDefinitionInterface) {
                        MapChart.this._conveyVariableToVariableDefinition(variable, (AnalysisVariableDefinitionInterface)variableDefinition);
                    } else if (variableDefinition instanceof ClassifierVariableDefinitionInterface) {
                        MapChart.this._conveyVariableToVariableDefinition(variable, (ClassifierVariableDefinitionInterface)variableDefinition);
                    } else if (variableDefinition instanceof VariableDefinitionInterface) {
                        MapChart.this._conveyVariableToVariableDefinition(variable, variableDefinition);
                    }
                    if ("automatic".equals(propertyName) || "columnName".equals(propertyName) || "columnLabel".equals(propertyName) || "columnIndex".equals(propertyName)) {
                        if (role.getValue() >= VariableRoleTypes.ID1.getValue() && role.getValue() <= VariableRoleTypes.ID32.getValue()) {
                            MapChart.this.mapAreaDataSource.removeAllVariables();
                            MapChart.this.mapAreaResponseDataSource.removeAllVariables();
                            MapChart.this.attachMapAreaVariables();
                            MapChart.this.attachMapAreaResponseVariables();
                        } else if (role == VariableRoleTypes.X || role == VariableRoleTypes.Y || role == VariableRoleTypes.SEGMENT) {
                            MapChart.this.mapAreaDataSource.setVariable(ctkRole, null);
                            MapChart.this.attachMapAreaVariables();
                        } else if (role == VariableRoleTypes.COLOR) {
                            MapChart.this.mapAreaResponseDataSource.setVariable(ctkRole, null);
                            MapChart.this.attachMapAreaResponseVariables();
                        }
                        if (role == VariableRoleTypes.COLOR) {
                            MapChart.this.colorVariableChangeOccured = true;
                            MapChart.this.repaint();
                        }
                    }
                }
                MapChart.this.enableFullPaint();
            }
        }
    }

    private class MyMapAreaResponseLegendPropertyListener
    implements PropertyChangeListener,
    Serializable {
        private MyMapAreaResponseLegendPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (Util.equal((Object)propertyName, (Object)"style")) {
                LegendStyle oldStyle = (LegendStyle)e.getOldValue();
                LegendStyle newStyle = (LegendStyle)e.getNewValue();
                if (oldStyle != null) {
                    oldStyle.removePropertyBagChangedListener(MapChart.this.myMapAreaResponseLegendStylePropertyListener);
                }
                if (newStyle != null) {
                    newStyle.addPropertyBagChangedListener(MapChart.this.myMapAreaResponseLegendStylePropertyListener);
                }
                if (MapChart.this.mapAreaResponseLegendBean != null) {
                    MapChart.this._conveyMapAreaResponseLegendStyles((ColorLegendStyle)MapChart.this.mapAreaResponseLegendBean.getEffectiveStyle());
                }
            }
        }
    }

    private class Storage {
        Hashtable roleToVariable;
        StaticRowTemplateTableInterface mapAreaModel;
        StaticRowTemplateTableInterface mapAreaResponseModel;
        ColorLegend mapAreaResponseLegendBean;

        private Storage() {
        }
    }
}

