/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.bean;

import com.sas.awt.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.bean.LegendStyle;
import com.sas.graphics.chart.bean.LineStyle;
import com.sas.graphics.chart.bean.RB;
import com.sas.graphics.chart.bean.TextStyle;
import com.sas.graphics.util.FontManager;
import com.sas.util.Util;
import java.awt.Color;
import java.io.Serializable;

public class Legend
extends Component
implements Serializable {
    static final long serialVersionUID = -4945452191546512983L;
    public static final String RB_KEY = "Legend.";
    public static final String STYLE = "style";
    public static final String DEFAULT_STYLE = "defaultStyle";
    protected LegendStyle _baseLegendStyle;
    private LegendStyle _defaultLegendStyle;
    private LegendStyle _legendStyle;
    private LegendStyle legendStyle;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", STYLE}, {"Short description", RB.getStringResource(RB_KEY, "style.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "style.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Legend() {
    }

    public Legend(LegendStyle newLegendStyle) {
        this();
        this.legendStyle = newLegendStyle;
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.init();
    }

    private void init() {
        this._baseLegendStyle = this._initBaseStyle();
        this._defaultLegendStyle = this._newLegendStyle();
        this._legendStyle = this._newLegendStyle();
        this._defaultLegendStyle.setPropertyBagDelegate(this._newLegendStyle());
        this._defaultLegendStyle.setPropertyBagAncestor(this._baseLegendStyle);
        this._legendStyle.setPropertyBagAncestor(this._defaultLegendStyle);
        if (this.legendStyle != null) {
            this._legendStyle.setPropertyBagDelegate(this.legendStyle);
        } else {
            this._legendStyle.setPropertyBagDelegate(this._newLegendStyle());
        }
    }

    protected LegendStyle _newLegendStyle() {
        return new LegendStyle();
    }

    private LegendStyle _initBaseStyle() {
        return this._initBaseStyle(this._newLegendStyle());
    }

    protected LegendStyle _initBaseStyle(LegendStyle baseStyle) {
        baseStyle.setVisible(true);
        TextStyle titleTextStyles = new TextStyle();
        titleTextStyles.setFont(FontManager.getFont((String)"SansSerif", (int)0, (int)10));
        titleTextStyles.setVisible(true);
        titleTextStyles.setColor(Color.black);
        TextStyle valueTextStyles = new TextStyle();
        valueTextStyles.setFont(FontManager.getFont((String)"SansSerif", (int)0, (int)10));
        valueTextStyles.setVisible(true);
        valueTextStyles.setColor(Color.black);
        baseStyle.setTitleTextStyle(titleTextStyles);
        baseStyle.setValueTextStyle(valueTextStyles);
        LineStyle outlineStyles = new LineStyle();
        outlineStyles.setColor(Color.black);
        outlineStyles.setVisible(true);
        baseStyle.setOutlineLineStyle(outlineStyles);
        return baseStyle;
    }

    public void setStyle(LegendStyle newStyle) {
        if (this._legendStyle.getPropertyBagDelegate() == newStyle) {
            return;
        }
        LegendStyle oldStyle = this.getStyle();
        this._legendStyle.setPropertyBagDelegate(newStyle == null ? this._newLegendStyle() : newStyle);
        newStyle = this.getStyle();
        if (Util.unequal((Object)oldStyle, (Object)newStyle)) {
            this.firePropertyChange(STYLE, oldStyle, newStyle);
        }
    }

    public LegendStyle getStyle() {
        return (LegendStyle)this._legendStyle.getPropertyBagDeligate();
    }

    public void setDefaultStyle(LegendStyle newStyle) {
        if (this._defaultLegendStyle.getPropertyBagDelegate() == newStyle) {
            return;
        }
        LegendStyle oldStyle = this.getDefaultStyle();
        this._defaultLegendStyle.setPropertyBagDelegate(newStyle == null ? this._newLegendStyle() : newStyle);
        newStyle = this.getDefaultStyle();
        if (Util.unequal((Object)oldStyle, (Object)newStyle)) {
            this.firePropertyChange(DEFAULT_STYLE, oldStyle, newStyle);
        }
    }

    public LegendStyle getDefaultStyle() {
        return (LegendStyle)this._defaultLegendStyle.getPropertyBagDeligate();
    }

    public final LegendStyle getEffectiveStyle() {
        return this._legendStyle;
    }
}

