/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.bean;

import com.sas.ModelInterface;
import com.sas.awt.ActionSource;
import com.sas.awt.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.graphics.chart.bean.ChartActionEvent;
import com.sas.graphics.chart.bean.ChartContainer;
import com.sas.graphics.chart.bean.GanttElementInfo;
import com.sas.graphics.chart.bean.IndependentVariable;
import com.sas.graphics.chart.bean.RB;
import com.sas.graphics.chart.bean.RootVisualizationContainer;
import com.sas.graphics.chart.bean.Variable;
import com.sas.graphics.chart.bean.VariableRoleTypes;
import com.sas.graphics.chart.util.ctk.AnalysisVariableDefinitionInterface;
import com.sas.graphics.chart.util.ctk.CategoryResponseChart;
import com.sas.graphics.chart.util.ctk.ClassifierVariableDefinition;
import com.sas.graphics.chart.util.ctk.ClassifierVariableDefinitionInterface;
import com.sas.graphics.chart.util.ctk.DataSource;
import com.sas.graphics.chart.util.ctk.GanttOverlay;
import com.sas.graphics.chart.util.ctk.GridLayoutManager;
import com.sas.graphics.chart.util.ctk.JXDVisualizationGraphics;
import com.sas.graphics.chart.util.ctk.Legend;
import com.sas.graphics.chart.util.ctk.OverlayInterface;
import com.sas.graphics.chart.util.ctk.Prober;
import com.sas.graphics.chart.util.ctk.StateAdapter;
import com.sas.graphics.chart.util.ctk.TickStrategyFactoryInterface;
import com.sas.graphics.chart.util.ctk.TransformStrategyFactoryInterface;
import com.sas.graphics.chart.util.ctk.VariableDefinitionInterface;
import com.sas.graphics.chart.util.ctk.VisualizationContainer;
import com.sas.graphics.chart.util.ctk.VisualizationGraphicsInterface;
import com.sas.graphics.chart.util.ctk.vtk.ConstantStringToDoubleTransformStrategy;
import com.sas.graphics.chart.util.ctk.vtk.DoubleTickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleTransformStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.StringTickStrategy;
import com.sas.graphics.chart.util.ctk.vtk.StringTickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleTransformStrategyInterface;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.vtk.jxd.LegendScroller;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.util.Util;
import java.awt.AWTEventMulticaster;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GanttChart
extends ChartContainer
implements ActionSource {
    static final long serialVersionUID = 8870222253165493123L;
    public static final String RB_KEY = "GanttChart.";
    protected static final Font DEFAULT_AXIS_VALUE_FONT = FontManager.getFont((String)"SansSerif", (int)0, (int)12);
    protected static final Font DEFAULT_AXIS_TITLE_FONT = FontManager.getFont((String)"SansSerif", (int)0, (int)16);
    protected static final Font DEFAULT_CATEGORY_AXIS_VALUE_FONT = DEFAULT_AXIS_VALUE_FONT;
    protected static final Font DEFAULT_CATEGORY_AXIS_TITLE_FONT = DEFAULT_AXIS_TITLE_FONT;
    protected static final Font DEFAULT_RESPONSE_AXIS_VALUE_FONT = DEFAULT_AXIS_VALUE_FONT;
    protected static final Font DEFAULT_RESPONSE_AXIS_TITLE_FONT = DEFAULT_AXIS_TITLE_FONT;
    protected static final Font DEFAULT_LEGEND_VALUE_FONT = DEFAULT_AXIS_VALUE_FONT;
    protected static final Font DEFAULT_LEGEND_TITLE_FONT = DEFAULT_AXIS_TITLE_FONT;
    protected static final Font DEFAULT_TITLE1_FONT = FontManager.getFont((String)"SansSerif", (int)0, (int)18);
    protected static final Font DEFAULT_TITLE_FONT;
    protected static final Font DEFAULT_FOOTNOTE_FONT;
    private transient GanttOverlay ganttOverlay;
    private transient CategoryResponseChart chart;
    private transient DataSource dataSource;
    private transient Legend legend;
    private transient ModelListener modelListener;
    private transient LegendScroller legendScroller;
    private transient RootVisualizationContainer chartRoot;
    private transient Prober prober;
    private transient ActionEventMouser actionEventMouser;
    private transient ActionListener actionListener;
    private transient DrillingPopupMenuMouser drillingPopupMenuMouser;
    private transient PopupMenu drillingPopupMenu;
    private transient String wbsCodeValue;
    private transient Double projectLevelValue;
    private transient MenuItem drillDownMenuItem;
    private transient MenuItem drillUpMenuItem;
    private transient boolean drillingEnabled;
    private transient Hashtable roleToVariable;
    private transient Hashtable variableToRole;
    private transient Hashtable variableToVariableDefinition;
    private transient VariablePropertyChangeListener variablePropertyChangeListener;
    private transient Hashtable variableRoleTypes2CtkRole;
    private static final String[] requiredInterfacesString1;
    private static final String[] requiredInterfacesString2;
    private boolean contentsChangedOccured;
    protected static final String VERSION_1_DOT_2 = "Version: 1.2";
    private transient Storage storage;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "categoryVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.IndependentVariableInstanceEditor"}}, {{"Name", "earlyStartVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "earlyFinishVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "lateStartVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "lateFinishVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "actualStartVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "actualFinishVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "resourceStartVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "resourceFinishVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "baselineStartVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "baselineFinishVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "summaryVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "WBSCodeVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "projectLevelVariable"}, {"Property editor class", "com.sas.graphics.chart.bean.VariableInstanceEditor"}}, {{"Name", "IndependentAxis"}, {"Property editor class", "com.sas.graphics.chart.bean.AxisInstanceEditor"}}, {{"Name", "DependentAxis"}, {"Property editor class", "com.sas.graphics.chart.bean.AxisInstanceEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.ebi.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    private void init() {
        this.drillingEnabled = true;
        this.dataSource = new DataSource();
        this.dataSource.setStatisticsEnabled(false);
        this.dataSource.setDataCachingEnabled(true);
        this.modelListener = new ModelListener();
        this.ganttOverlay = GanttOverlay.newGanttOverlay();
        this._addGantOverlay(this.ganttOverlay);
        this.ganttOverlay.setDataSource(this.dataSource);
        this.roleToVariable = new Hashtable();
        this.variableToRole = new Hashtable();
        this.variableToVariableDefinition = new Hashtable();
        this.variablePropertyChangeListener = new VariablePropertyChangeListener();
        this.variableRoleTypes2CtkRole = new Hashtable();
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.CATEGORY, OverlayInterface.VariableRoles.CATEGORY);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.EARLYSTART, OverlayInterface.VariableRoles.EARLYSTART);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.EARLYFINISH, OverlayInterface.VariableRoles.EARLYFINISH);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.LATESTART, OverlayInterface.VariableRoles.LATESTART);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.LATEFINISH, OverlayInterface.VariableRoles.LATEFINISH);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ACTUALSTART, OverlayInterface.VariableRoles.ACTUALSTART);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.ACTUALFINISH, OverlayInterface.VariableRoles.ACTUALFINISH);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.RESOURCESTART, OverlayInterface.VariableRoles.RESOURCESTART);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.RESOURCEFINISH, OverlayInterface.VariableRoles.RESOURCEFINISH);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.BASELINESTART, OverlayInterface.VariableRoles.BASELINESTART);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.BASELINEFINISH, OverlayInterface.VariableRoles.BASELINEFINISH);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.SUMMARY, OverlayInterface.VariableRoles.SUMMARY);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.WBSCODE, OverlayInterface.VariableRoles.WBSCODE);
        this.variableRoleTypes2CtkRole.put(VariableRoleTypes.PROJECTLEVEL, OverlayInterface.VariableRoles.PROJECTLEVEL);
    }

    private void _addGantOverlay(GanttOverlay ganttOverlay) {
        this.chartRoot = this._createGanttOverlayAwtContainer(ganttOverlay);
        if (this.chartRoot != null) {
            this.chartRoot.setBackgroundColor(this.getBackground());
            this.setInChartContainer(this.chartRoot);
            this.legend = ganttOverlay.getLegend(OverlayInterface.VariableRoles.COLOR);
            this.legendScroller = new LegendScroller();
            this.legend.vtkLegend.getStyle().setBorderOn(true);
            this.legendScroller.setLegend(this.legend.vtkLegend);
            this.legendScroller.setBackground(this.getBackground());
            this.setInLegendContainer(this.legendScroller);
        }
    }

    private RootVisualizationContainer _createGanttOverlayAwtContainer(GanttOverlay ganttOverlay) {
        this.chart = CategoryResponseChart.newCategoryResponseChart();
        GanttResponseAxisStrategyFactory ganttResponseAxisStrategyFactory = new GanttResponseAxisStrategyFactory();
        this.chart.getResponseAxis().setTickStrategyFactory(ganttResponseAxisStrategyFactory);
        this.chart.getResponseAxis().setTransformStrategyFactory(ganttResponseAxisStrategyFactory);
        this.chart.eastSouthOrientation();
        this.chart.addOverlay(ganttOverlay);
        VisualizationContainer chartArea = VisualizationContainer.newVisualizationContainer();
        GridLayoutManager chartAreaLayoutManager = new GridLayoutManager();
        GridLayoutManager.GridConstraintInterface constraints = chartAreaLayoutManager.newDefaultConstraint();
        chartArea.setVisualizationLayoutManager(chartAreaLayoutManager);
        constraints.setRow(1);
        constraints.setColumn(1);
        chartArea.add(this.chart, constraints);
        RootVisualizationContainer chartRoot = RootVisualizationContainer.newRootVisualizationContainer();
        chartRoot.setVisualizationComponent(chartArea);
        this.prober = new Prober(ganttOverlay);
        this.prober.setContinuousUpdateEnabled(true);
        ganttOverlay.addMouseListener(this.prober);
        ganttOverlay.addMouseMotionListener(this.prober);
        this.actionEventMouser = new ActionEventMouser(ganttOverlay);
        ganttOverlay.addMouseListener(this.actionEventMouser);
        JXDVisualizationGraphics graphicsSource = (JXDVisualizationGraphics)chartRoot.getVisualizationGraphics();
        graphicsSource.addDisplayUpdateActionListener(this.prober.getDisplayUpdateListener());
        graphicsSource.setCullFaceEnabled(false);
        graphicsSource.setLightingEnabled(false);
        graphicsSource.setDepthTestEnabled(false);
        this.drillDownMenuItem = new MenuItem(RB.getStringResource("PopupMenu.", "DrillDownLabel.txt"));
        this.drillUpMenuItem = new MenuItem(RB.getStringResource("PopupMenu.", "DrillUpLabel.txt"));
        this.drillingPopupMenu = new PopupMenu();
        this.drillingPopupMenu.add(this.drillDownMenuItem);
        this.drillingPopupMenu.add(this.drillUpMenuItem);
        this.drillDownMenuItem.addActionListener(new DrillDownActionListener());
        this.drillUpMenuItem.addActionListener(new DrillUpActionListener());
        this.drillingPopupMenuMouser = new DrillingPopupMenuMouser(ganttOverlay, this.drillingPopupMenu);
        ganttOverlay.addMouseListener(this.drillingPopupMenuMouser);
        return chartRoot;
    }

    private static int _determineTickInc(int dayCount) {
        return dayCount < 10 ? 1 : (dayCount < 60 ? 7 : (dayCount < 182 ? 14 : (dayCount < 335 ? 30 : (dayCount < 730 ? 90 : (dayCount < 1825 ? 120 : (dayCount < 3650 ? 365 : (dayCount < 18250 ? 3650 : (dayCount < 36500 ? 9125 : dayCount / 9))))))));
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.init();
    }

    public final IndependentVariable getCategoryVariable() {
        return (IndependentVariable)this._getVariable(VariableRoleTypes.CATEGORY);
    }

    public final void setCategoryVariable(IndependentVariable variable) {
        this.setVariable(VariableRoleTypes.CATEGORY, variable);
    }

    public final void removeCategoryVariable() {
        this.removeVariable(VariableRoleTypes.CATEGORY);
    }

    public final Variable getEarlyStartVariable() {
        return this._getVariable(VariableRoleTypes.EARLYSTART);
    }

    public final void setEarlyStartVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.EARLYSTART, variable);
    }

    public final void removeEarlyStartVariable() {
        this.removeVariable(VariableRoleTypes.EARLYSTART);
    }

    public final Variable getEarlyFinishVariable() {
        return this._getVariable(VariableRoleTypes.EARLYFINISH);
    }

    public final void setEarlyFinishVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.EARLYFINISH, variable);
    }

    public final void removeEarlyFinishVariable() {
        this.removeVariable(VariableRoleTypes.EARLYFINISH);
    }

    public final Variable getLateStartVariable() {
        return this._getVariable(VariableRoleTypes.LATESTART);
    }

    public final void setLateStartVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.LATESTART, variable);
    }

    public final void removeLateStartVariable() {
        this.removeVariable(VariableRoleTypes.LATESTART);
    }

    public final Variable getLateFinishVariable() {
        return this._getVariable(VariableRoleTypes.LATEFINISH);
    }

    public final void setLateFinishVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.LATEFINISH, variable);
    }

    public final void removeLateFinishVariable() {
        this.removeVariable(VariableRoleTypes.LATEFINISH);
    }

    public final Variable getActualStartVariable() {
        return this._getVariable(VariableRoleTypes.ACTUALSTART);
    }

    public final void setActualStartVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.ACTUALSTART, variable);
    }

    public final void removeActualStartVariable() {
        this.removeVariable(VariableRoleTypes.ACTUALSTART);
    }

    public final Variable getActualFinishVariable() {
        return this._getVariable(VariableRoleTypes.ACTUALFINISH);
    }

    public final void setActualFinishVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.ACTUALFINISH, variable);
    }

    public final void removeActualFinishVariable() {
        this.removeVariable(VariableRoleTypes.ACTUALFINISH);
    }

    public final Variable getResourceStartVariable() {
        return this._getVariable(VariableRoleTypes.RESOURCESTART);
    }

    public final void setResourceStartVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.RESOURCESTART, variable);
    }

    public final void removeResourceStartVariable() {
        this.removeVariable(VariableRoleTypes.RESOURCESTART);
    }

    public final Variable getResourceFinishVariable() {
        return this._getVariable(VariableRoleTypes.RESOURCEFINISH);
    }

    public final void setResourceFinishVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.RESOURCEFINISH, variable);
    }

    public final void removeResourceFinishVariable() {
        this.removeVariable(VariableRoleTypes.RESOURCEFINISH);
    }

    public final Variable getBaselineStartVariable() {
        return this._getVariable(VariableRoleTypes.BASELINESTART);
    }

    public final void setBaselineStartVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.BASELINESTART, variable);
    }

    public final void removeBaselineStartVariable() {
        this.removeVariable(VariableRoleTypes.BASELINESTART);
    }

    public final Variable getBaselineFinishVariable() {
        return this._getVariable(VariableRoleTypes.BASELINEFINISH);
    }

    public final void setBaselineFinishVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.BASELINEFINISH, variable);
    }

    public final void removeBaselineFinishVariable() {
        this.removeVariable(VariableRoleTypes.BASELINEFINISH);
    }

    public final Variable getSummaryVariable() {
        return this._getVariable(VariableRoleTypes.SUMMARY);
    }

    public final void setSummaryVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.SUMMARY, variable);
    }

    public final void removeSummaryVariable() {
        this.removeVariable(VariableRoleTypes.SUMMARY);
    }

    public final Variable getWBSCodeVariable() {
        return this._getVariable(VariableRoleTypes.WBSCODE);
    }

    public final void setWBSCodeVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.WBSCODE, variable);
    }

    public final void removeWBSCodeVariable() {
        this.removeVariable(VariableRoleTypes.WBSCODE);
    }

    public final Variable getProjectLevelVariable() {
        return this._getVariable(VariableRoleTypes.PROJECTLEVEL);
    }

    public final void setProjectLevelVariable(Variable variable) {
        this.setVariable(VariableRoleTypes.PROJECTLEVEL, variable);
    }

    public final void removeProjectLevelVariable() {
        this.removeVariable(VariableRoleTypes.PROJECTLEVEL);
    }

    public void setDrillingEnabled(boolean b) {
        this.drillingEnabled = b;
    }

    public boolean isDrillingEnabled() {
        return this.drillingEnabled;
    }

    public Variable getVariable(VariableRoleTypes role) {
        return this._getVariable(role);
    }

    public void setVariable(VariableRoleTypes role, Variable newVariable) {
        Variable oldVariable = this._setVariable(role, newVariable);
        if (Util.unequal((Object)oldVariable, (Object)newVariable)) {
            this.firePropertyChange(role.toString().toLowerCase() + "Variable", oldVariable, newVariable);
        }
    }

    public void removeVariable(VariableRoleTypes role) {
        this.setVariable(role, null);
    }

    protected Variable _getVariable(VariableRoleTypes role) {
        if (role == null) {
            throw new IllegalArgumentException();
        }
        Variable variable = (Variable)this.roleToVariable.get((Object)role);
        if (variable == null) {
            if (role == VariableRoleTypes.EARLYSTART || role == VariableRoleTypes.EARLYFINISH || role == VariableRoleTypes.LATESTART || role == VariableRoleTypes.LATEFINISH || role == VariableRoleTypes.ACTUALSTART || role == VariableRoleTypes.ACTUALFINISH || role == VariableRoleTypes.RESOURCESTART || role == VariableRoleTypes.RESOURCEFINISH || role == VariableRoleTypes.BASELINESTART || role == VariableRoleTypes.BASELINEFINISH || role == VariableRoleTypes.SUMMARY || role == VariableRoleTypes.WBSCODE || role == VariableRoleTypes.PROJECTLEVEL) {
                variable = new Variable();
            } else if (role == VariableRoleTypes.CATEGORY) {
                variable = new IndependentVariable();
            } else {
                throw new IllegalArgumentException();
            }
            this._setVariable(role, variable);
        }
        return variable;
    }

    protected Variable _setVariable(VariableRoleTypes role, Variable newVariable) {
        Object ctkRole = this.variableRoleTypes2CtkRole.get((Object)role);
        if (role != null && ctkRole != null) {
            Variable oldVariable = (Variable)this.roleToVariable.get((Object)role);
            if (oldVariable != newVariable) {
                this.disableFullPaint();
                if (oldVariable != null) {
                    oldVariable.removePropertyChangeListener((PropertyChangeListener)((Object)this.variablePropertyChangeListener));
                    this.roleToVariable.remove((Object)role);
                    this.variableToRole.remove(oldVariable);
                    this.variableToVariableDefinition.remove(oldVariable);
                    if (!oldVariable.isAutomatic()) {
                        this.dataSource.removeVariable(ctkRole);
                    }
                }
                if (newVariable != null) {
                    boolean attachVars;
                    newVariable.addPropertyChangeListener((PropertyChangeListener)((Object)this.variablePropertyChangeListener));
                    this.roleToVariable.put(role, newVariable);
                    this.variableToRole.put(newVariable, role);
                    boolean bl = attachVars = (newVariable == null || newVariable.isAutomatic()) && oldVariable != null && !oldVariable.isAutomatic();
                    if (role == VariableRoleTypes.CATEGORY) {
                        ClassifierVariableDefinitionInterface newVariableDefinition = this._conveyVariableToVariableDefinition(newVariable, (ClassifierVariableDefinitionInterface)null);
                        this.variableToVariableDefinition.put(newVariable, newVariableDefinition);
                        if (!newVariable.isAutomatic()) {
                            this.dataSource.setVariable(ctkRole, newVariableDefinition);
                        } else if (attachVars) {
                            this.attachVariables();
                        }
                    } else {
                        AnalysisVariableDefinitionInterface newVariableDefinition = this._conveyVariableToVariableDefinition(newVariable, (AnalysisVariableDefinitionInterface)null);
                        this.variableToVariableDefinition.put(newVariable, newVariableDefinition);
                        if (!newVariable.isAutomatic()) {
                            this.dataSource.setVariable(ctkRole, newVariableDefinition);
                        } else if (attachVars) {
                            this.attachVariables();
                        }
                    }
                }
                this.enableFullPaint();
            }
            return oldVariable;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    protected void fireActionEvent(ActionEvent event) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(event);
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(2);
        requiredInterfaces.addElement(requiredInterfacesString1);
        requiredInterfaces.addElement(requiredInterfacesString2);
        return requiredInterfaces;
    }

    @Override
    public void refresh(ModelInterface mi) {
    }

    @Override
    public void attachModel(ModelInterface model) {
        super.attachModel(model);
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this.modelListener);
        }
        this.dataSource.setDataSource((StaticRowTemplateTableInterface)model);
        this.attachVariables();
        this.legendScroller.invalidate();
        this.validate();
    }

    @Override
    public void detachModel(ModelInterface model) {
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this.modelListener);
        }
        this.dataSource.removeAllVariables();
        this.dataSource.setDataSource(null);
        super.detachModel(model);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void attachVariables() {
        VariableDefinitionInterface varDef;
        this.dataSource.disableEvents();
        VariableRoleTypes role = VariableRoleTypes.CATEGORY;
        Object ctkRole = this.variableRoleTypes2CtkRole.get((Object)role);
        Variable variable = (Variable)this.roleToVariable.get((Object)role);
        if (variable == null || variable.isAutomatic()) {
            Variable attemptVariable = null;
            try {
                attemptVariable = variable == null ? new IndependentVariable() : (Variable)variable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            boolean found = false;
            String[] list = new String[]{"TASK", "ID", "ACTIVITY", "ACT", "ACTID"};
            varDef = variable == null ? null : (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
            for (int ii = 0; !found && ii < list.length; ++ii) {
                attemptVariable.setColumnName(list[ii]);
                varDef = this._conveyVariableToVariableDefinition(attemptVariable, (ClassifierVariableDefinition)varDef);
                found = this.dataSource.columnExists(varDef);
                if (!found) continue;
                this.dataSource.setVariable(ctkRole, varDef);
            }
            if (found) {
                // empty if block
            }
        } else {
            varDef = (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
            this.dataSource.setVariable(ctkRole, varDef);
        }
        VariableRoleTypes[] analysisRoles = new VariableRoleTypes[]{VariableRoleTypes.EARLYSTART, VariableRoleTypes.EARLYFINISH, VariableRoleTypes.LATESTART, VariableRoleTypes.LATEFINISH, VariableRoleTypes.ACTUALSTART, VariableRoleTypes.ACTUALFINISH, VariableRoleTypes.RESOURCESTART, VariableRoleTypes.RESOURCEFINISH, VariableRoleTypes.BASELINESTART, VariableRoleTypes.BASELINEFINISH, VariableRoleTypes.SUMMARY, VariableRoleTypes.WBSCODE, VariableRoleTypes.PROJECTLEVEL};
        String[] defaultName = new String[]{"E_START", "E_FINISH", "L_START", "L_FINISH", "A_START", "A_FINISH", "S_START", "S_FINISH", "B_START", "B_FINISH", "SUMMARY", "WBS_CODE", "PROJ_LEV"};
        int ii = 0;
        while (true) {
            if (ii >= analysisRoles.length) {
                this._setInitialWhereClause();
                this.dataSource.enableEvents();
                return;
            }
            role = analysisRoles[ii];
            ctkRole = this.variableRoleTypes2CtkRole.get((Object)role);
            variable = (Variable)this.roleToVariable.get((Object)role);
            if (variable == null || variable.isAutomatic()) {
                Variable attemptVariable = null;
                try {
                    attemptVariable = variable == null ? new Variable() : (Variable)variable.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                varDef = variable == null ? null : (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
                attemptVariable.setColumnName(defaultName[ii]);
                varDef = this._conveyVariableToVariableDefinition(attemptVariable, (AnalysisVariableDefinitionInterface)varDef);
                if (this.dataSource.columnExists(varDef)) {
                    this.dataSource.setVariable(ctkRole, varDef);
                }
            } else {
                varDef = (VariableDefinitionInterface)this.variableToVariableDefinition.get(variable);
                this.dataSource.setVariable(ctkRole, varDef);
            }
            ++ii;
        }
    }

    private void _setInitialWhereClause() {
        String whereClause = null;
        Object wbsCodeRole = this.variableRoleTypes2CtkRole.get((Object)VariableRoleTypes.WBSCODE);
        Object projectLevelRole = this.variableRoleTypes2CtkRole.get((Object)VariableRoleTypes.PROJECTLEVEL);
        String wbsCodeVarName = this.dataSource.getColumnName(wbsCodeRole);
        String projectLevelVarName = this.dataSource.getColumnName(projectLevelRole);
        if (wbsCodeVarName != null && projectLevelVarName != null) {
            whereClause = wbsCodeVarName + " like \"0%\" & (" + projectLevelVarName + "=0 | " + projectLevelVarName + "=1)";
        }
        this.dataSource.setWhereClause(whereClause);
    }

    @Override
    public void paint(Graphics g) {
        if (this.contentsChangedOccured) {
            this._processEvents();
        } else {
            super.paint(g);
        }
    }

    private void _processEvents() {
        this.contentsChangedOccured = false;
        this.disableFullPaint();
        this.dataSource.disableEvents();
        this.dataSource.removeAllVariables();
        this.dataSource.reset();
        this.attachVariables();
        this.dataSource.enableEvents();
        this.enableFullPaint(false);
        this.chart.validate();
        this.legendScroller.invalidate();
        this.validate();
        this.repaint();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(VERSION_1_DOT_2);
        this._writeVer1Dot2(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            String version = (String)in.readObject();
            this.storage = VERSION_1_DOT_2.equals(version) ? this._readVer1Dot2(in) : null;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void _writeVer1Dot2(ObjectOutputStream out) throws IOException {
        ModelInterface modelInterface = this.getModelInterface();
        Enumeration roles = this.roleToVariable.keys();
        while (roles.hasMoreElements()) {
            VariableRoleTypes role = (VariableRoleTypes)((Object)roles.nextElement());
            Variable variable = (Variable)this.roleToVariable.get((Object)role);
            out.writeObject(role.toString());
            out.writeObject(variable);
        }
        out.writeObject("EOV");
        out.writeBoolean(this.drillingEnabled);
    }

    private Storage _readVer1Dot2(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String roleName;
        Storage storage = new Storage();
        storage.roleToVariable = new Hashtable();
        while (!"EOV".equals(roleName = (String)in.readObject())) {
            VariableRoleTypes role = VariableRoleTypes.get(roleName);
            Variable variable = (Variable)in.readObject();
            storage.roleToVariable.put(role, variable);
        }
        storage.drillingEnabled = in.readBoolean();
        return storage;
    }

    @Override
    protected void restore() {
        this.disableFullPaint();
        super.restore();
        if (this.storage != null) {
            Enumeration roles = this.storage.roleToVariable.keys();
            while (roles.hasMoreElements()) {
                VariableRoleTypes role = (VariableRoleTypes)((Object)roles.nextElement());
                Variable variable = (Variable)this.storage.roleToVariable.get((Object)role);
                this._setVariable(role, variable);
            }
            this.drillingEnabled = this.storage.drillingEnabled;
            this.storage = null;
        }
        this.enableFullPaint(true);
    }

    static {
        DEFAULT_FOOTNOTE_FONT = DEFAULT_TITLE_FONT = FontManager.getFont((String)"SansSerif", (int)0, (int)12);
        requiredInterfacesString1 = new String[]{"com.sas.table.StaticRowTemplateTableInterface"};
        requiredInterfacesString2 = new String[]{"com.sas.table.StaticColumnLabelInterface"};
    }

    private class ModelListener
    implements ContentsChangedListener {
        private ModelListener() {
        }

        public void contentsChanged(ContentsChangedEvent e) {
            GanttChart.this.contentsChangedOccured = true;
            GanttChart.this.repaint();
        }
    }

    private class VariablePropertyChangeListener
    extends Component {
        private VariablePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String propertyName = pce.getPropertyName();
            if (propertyName == null) {
                return;
            }
            Variable variable = (Variable)pce.getSource();
            if (variable != null) {
                GanttChart.this.disableFullPaint();
                VariableRoleTypes role = (VariableRoleTypes)((Object)GanttChart.this.variableToRole.get(variable));
                Object ctkRole = GanttChart.this.variableRoleTypes2CtkRole.get((Object)role);
                if (role != null && ctkRole != null) {
                    VariableDefinitionInterface variableDefinition = (VariableDefinitionInterface)GanttChart.this.variableToVariableDefinition.get(variable);
                    if (variableDefinition instanceof ClassifierVariableDefinitionInterface) {
                        GanttChart.this._conveyVariableToVariableDefinition(variable, (ClassifierVariableDefinitionInterface)variableDefinition);
                    } else if (variableDefinition instanceof AnalysisVariableDefinitionInterface) {
                        GanttChart.this._conveyVariableToVariableDefinition(variable, (AnalysisVariableDefinitionInterface)variableDefinition);
                    } else if (variableDefinition instanceof VariableDefinitionInterface) {
                        GanttChart.this._conveyVariableToVariableDefinition(variable, variableDefinition);
                    }
                    if ("automatic".equals(propertyName) || "columnName".equals(propertyName) || "columnLabel".equals(propertyName) || "columnIndex".equals(propertyName)) {
                        GanttChart.this.dataSource.removeAllVariables();
                        GanttChart.this.attachVariables();
                    }
                }
                GanttChart.this.enableFullPaint();
            }
        }
    }

    static class GanttResponseAxisStrategyFactory
    implements TickStrategyFactoryInterface,
    TransformStrategyFactoryInterface {
        GanttResponseAxisStrategyFactory() {
        }

        @Override
        public StringTickStrategyInterface newStringTickStrategy() {
            return new StringTickStrategy();
        }

        @Override
        public DoubleTickStrategyInterface newDoubleTickStrategy() {
            return new DateDoubleTickStrategy();
        }

        @Override
        public StringToDoubleTransformStrategyInterface newStringToDoubleTransformStrategy() {
            return new ConstantStringToDoubleTransformStrategy();
        }

        @Override
        public DoubleToDoubleTransformStrategyInterface newDoubleToDoubleTransformStrategy() {
            return new DateDoubleToDoubleTransformStrategy();
        }
    }

    private class ActionEventMouser
    extends MouseAdapter {
        protected GanttOverlay client;
        protected boolean enabled;
        int lastSelectionIndex;

        public ActionEventMouser(GanttOverlay client) {
            this.client = client;
            this.enabled = true;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (!event.isPopupTrigger()) {
                this._fireActionEvent(event);
            }
        }

        public void setEnabled(boolean b) {
            this.enabled = b;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        private void _fireActionEvent(MouseEvent event) {
            int index;
            if (!this.enabled) {
                return;
            }
            if (this.client != null && (index = this.client.getSelectionIndex()) != -1) {
                Hashtable elementInfo = this.client.getElementInfo(index);
                if (elementInfo == null) {
                    return;
                }
                try {
                    String wc = GanttChart.this.dataSource.getWhereClause();
                    int trueIndex = wc == null || wc.length() == 0 ? index + 1 : GanttChart.this.dataSource.getIndexWithoutWhereProcessing(index) + 1;
                    GanttElementInfo gei = new GanttElementInfo(null, GanttChart.this.getModelInterface(), trueIndex, (String)elementInfo.get(OverlayInterface.VariableRoles.CATEGORY), (Double)elementInfo.get(OverlayInterface.VariableRoles.EARLYSTART), (Double)elementInfo.get(OverlayInterface.VariableRoles.EARLYFINISH), (Double)elementInfo.get(OverlayInterface.VariableRoles.LATESTART), (Double)elementInfo.get(OverlayInterface.VariableRoles.LATEFINISH), (Double)elementInfo.get(OverlayInterface.VariableRoles.RESOURCESTART), (Double)elementInfo.get(OverlayInterface.VariableRoles.RESOURCEFINISH), (Double)elementInfo.get(OverlayInterface.VariableRoles.ACTUALSTART), (Double)elementInfo.get(OverlayInterface.VariableRoles.ACTUALFINISH), (Double)elementInfo.get(OverlayInterface.VariableRoles.BASELINESTART), (Double)elementInfo.get(OverlayInterface.VariableRoles.BASELINEFINISH), (String)elementInfo.get(OverlayInterface.VariableRoles.WBSCODE), (Double)elementInfo.get(OverlayInterface.VariableRoles.PROJECTLEVEL));
                    GanttChart.this.fireActionEvent(new ChartActionEvent((Object)GanttChart.this, 1001, null, gei));
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
    }

    private class DrillDownActionListener
    implements ActionListener {
        private DrillDownActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (GanttChart.this.wbsCodeValue == null || GanttChart.this.projectLevelValue == null) {
                return;
            }
            double level = GanttChart.this.projectLevelValue;
            if (Double.isNaN(level)) {
                return;
            }
            Object wbsCodeRole = GanttChart.this.variableRoleTypes2CtkRole.get((Object)VariableRoleTypes.WBSCODE);
            String wbsCodeVarName = GanttChart.this.dataSource.getColumnName(wbsCodeRole);
            if (wbsCodeVarName == null) {
                return;
            }
            Object projectLevelRole = GanttChart.this.variableRoleTypes2CtkRole.get((Object)VariableRoleTypes.PROJECTLEVEL);
            String projectLevelVarName = GanttChart.this.dataSource.getColumnName(projectLevelRole);
            if (projectLevelVarName == null) {
                return;
            }
            String whereClause = wbsCodeVarName + " like \"" + GanttChart.this.wbsCodeValue.trim() + "%\" & (" + projectLevelVarName + "=" + level + " | " + projectLevelVarName + "=" + (level + 1.0) + ")";
            GanttChart.this.dataSource.setWhereClause(whereClause);
            GanttChart.this.chart.validate();
        }
    }

    private class DrillUpActionListener
    implements ActionListener {
        private DrillUpActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (GanttChart.this.wbsCodeValue == null || GanttChart.this.projectLevelValue == null) {
                return;
            }
            double level = GanttChart.this.projectLevelValue;
            if (Double.isNaN(level)) {
                return;
            }
            Object wbsCodeRole = GanttChart.this.variableRoleTypes2CtkRole.get((Object)VariableRoleTypes.WBSCODE);
            String wbsCodeVarName = GanttChart.this.dataSource.getColumnName(wbsCodeRole);
            if (wbsCodeVarName == null) {
                return;
            }
            Object projectLevelRole = GanttChart.this.variableRoleTypes2CtkRole.get((Object)VariableRoleTypes.PROJECTLEVEL);
            String projectLevelVarName = GanttChart.this.dataSource.getColumnName(projectLevelRole);
            if (projectLevelVarName == null) {
                return;
            }
            int lastDot = GanttChart.this.wbsCodeValue.lastIndexOf(46);
            String whereClause = wbsCodeVarName + " like \"" + (lastDot == -1 ? GanttChart.this.wbsCodeValue : GanttChart.this.wbsCodeValue.substring(0, lastDot)) + "%\" & (" + projectLevelVarName + "=" + level + " | " + projectLevelVarName + "=" + (level - 1.0) + ")";
            GanttChart.this.dataSource.setWhereClause(whereClause);
            GanttChart.this.chart.validate();
        }
    }

    private class DrillingPopupMenuMouser
    extends MouseAdapter {
        protected GanttOverlay client;
        protected boolean enabled;
        protected PopupMenu popupMenu;
        protected boolean validState;

        public DrillingPopupMenuMouser(GanttOverlay client, PopupMenu popupMenu) {
            this.client = client;
            this.popupMenu = popupMenu;
            this.enabled = true;
            boolean bl = this.validState = popupMenu != null && client != null;
            if (this.validState) {
                VisualizationGraphicsInterface graphicsSource = client.getVisualizationGraphics();
                if (graphicsSource != null) {
                    graphicsSource.addPopupMenu(popupMenu);
                } else {
                    this.validState = false;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            Hashtable elementInfo;
            int index;
            if (event.isPopupTrigger() && this.enabled && this.validState && (index = this.client.getSelectionIndex()) != -1 && (elementInfo = this.client.getElementInfo(index)) != null) {
                GanttChart.this.wbsCodeValue = (String)elementInfo.get(OverlayInterface.VariableRoles.WBSCODE);
                GanttChart.this.projectLevelValue = (Double)elementInfo.get(OverlayInterface.VariableRoles.PROJECTLEVEL);
                if (GanttChart.this.wbsCodeValue != null && GanttChart.this.projectLevelValue != null) {
                    GanttChart.this.drillDownMenuItem.setEnabled(GanttChart.this.drillingEnabled);
                    GanttChart.this.drillUpMenuItem.setEnabled(GanttChart.this.drillingEnabled);
                    VisualizationGraphicsInterface graphicsSource = this.client.getVisualizationGraphics();
                    if (graphicsSource != null) {
                        graphicsSource.showPopupMenu(this.popupMenu, event.getX(), event.getY());
                    }
                }
            }
        }

        public void setEnabled(boolean b) {
            this.enabled = b;
        }

        public boolean getEnabled() {
            return this.enabled;
        }
    }

    private class Storage {
        Hashtable roleToVariable;
        boolean drillingEnabled;

        private Storage() {
        }
    }

    static class DateDoubleToDoubleTransformStrategy
    extends StateAdapter
    implements DoubleToDoubleTransformStrategyInterface {
        protected double inConst;
        protected double outConst;
        protected double inMinRequest;
        protected double inMaxRequest;
        protected double inMin;
        protected double inMax;
        protected double outMin;
        protected double outMax;

        DateDoubleToDoubleTransformStrategy() {
        }

        @Override
        public double getValue(double in) {
            double normalizedValue = (in - this.inMin) / this.inConst;
            double mappedValue = this.outMin + this.outConst * normalizedValue;
            return mappedValue;
        }

        protected void update() {
            int dayCount = (int)Math.ceil(this.inMaxRequest - this.inMinRequest);
            int tickInc = GanttChart._determineTickInc(dayCount);
            this.inMin = this.inMinRequest;
            this.inMax = this.inMin + (double)(tickInc * (dayCount / tickInc + (dayCount % tickInc > 0 ? 1 : 0)));
            this.outConst = this.outMax - this.outMin;
            this.inConst = this.inMax - this.inMin;
            this.stateChanged();
        }

        @Override
        public double getOutputMin() {
            return this.outMin;
        }

        @Override
        public void setOutputMin(double min) {
            this.outMin = min;
            this.update();
        }

        @Override
        public double getOutputMax() {
            return this.outMax;
        }

        @Override
        public void setOutputMax(double max) {
            this.outMax = max;
            this.update();
        }

        public double getInputMin() {
            return this.inMinRequest;
        }

        @Override
        public void setInputMin(double min) {
            this.inMinRequest = min;
            this.update();
        }

        public double getInputMax() {
            return this.inMaxRequest;
        }

        @Override
        public void setInputMax(double max) {
            this.inMaxRequest = max;
            this.update();
        }
    }

    static class DateDoubleTickStrategy
    extends StateAdapter
    implements DoubleTickStrategyInterface {
        protected double min;
        protected double max;
        protected int numOfRequestedTicks = -1;
        protected int numOfTicks;
        protected double[] values;
        protected Vector specialTicks;

        DateDoubleTickStrategy() {
        }

        @Override
        public double[] getValues() {
            if (this.values == null) {
                this._getValues();
            }
            return this.values == null ? null : (double[])this.values.clone();
        }

        private void _getValues() {
            int dayCount = (int)Math.ceil(this.max - this.min);
            int tickCount = this.numOfRequestedTicks;
            if (tickCount < 0) {
                int tickInc = GanttChart._determineTickInc(dayCount);
                this.values = new double[dayCount / tickInc + (dayCount % tickInc > 0 ? 1 : 0) + 1];
                for (int ii = 0; ii < this.values.length; ++ii) {
                    this.values[ii] = this.min + (double)(tickInc * ii);
                }
            } else {
                int stSize = this.specialTicks == null ? 0 : this.specialTicks.size();
                this.values = new double[tickCount + stSize];
                for (int ii = 0; ii < tickCount; ++ii) {
                    double ratio = (double)ii / ((double)tickCount - 1.0);
                    this.values[ii] = this.min + ratio * (double)dayCount;
                }
                for (int jj = 0; jj < stSize; ++jj) {
                    this.values[tickCount + jj] = (Double)this.specialTicks.elementAt(jj);
                }
            }
        }

        @Override
        public void setMin(double value) {
            if (Double.isNaN(value)) {
                value = 0.0;
            }
            if (this.min != value) {
                this.min = value;
                this.update();
            }
        }

        @Override
        public void setMax(double value) {
            if (Double.isNaN(value)) {
                value = 0.0;
            }
            if (this.max != value) {
                this.max = value;
                this.update();
            }
        }

        @Override
        public void setTickCount(int num) {
            int n = num < 0 ? -1 : (num = num < 2 ? 2 : num);
            if (this.numOfRequestedTicks != num) {
                this.numOfRequestedTicks = num;
                this.update();
            }
        }

        @Override
        public int getSize() {
            if (this.values == null && this.numOfRequestedTicks < 0) {
                this._getValues();
            }
            return this.numOfTicks;
        }

        @Override
        public double getValue(int ii) {
            if (ii < 0) {
                return Double.NaN;
            }
            if (this.values == null) {
                this.getValues();
            }
            if (this.values == null || this.values.length < ii) {
                return Double.NaN;
            }
            return this.values[ii];
        }

        public void update() {
            this.values = null;
            this.stateChanged();
        }

        public void addTick(double tick) {
            if (Double.isNaN(tick)) {
                return;
            }
            if (this.specialTicks == null) {
                this.specialTicks = new Vector();
            }
            this.specialTicks.addElement(new Double(tick));
        }

        public void removeTick(double tick) {
            if (Double.isNaN(tick)) {
                return;
            }
            if (this.specialTicks == null) {
                return;
            }
            Double tick2 = new Double(tick);
            if (this.specialTicks.contains(tick2)) {
                this.specialTicks.removeElement(tick2);
            }
        }
    }
}

