/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.DiscreteColorLegendStyle;
import com.sas.graphics.chart.Group;
import com.sas.graphics.chart.IndependentVariable;
import com.sas.graphics.chart.LegendStyle;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.StyleByTypes;
import com.sas.graphics.chart.TextStyle;
import com.sas.graphics.chart.Variable;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.HorizontalSegmentedBar;
import com.sas.graphics.util.visualize.VerticalSegmentedBar;
import com.sas.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;

public class SegmentedBar
extends Group
implements Serializable {
    static final long serialVersionUID = 1436727960966648454L;
    public static final String RB_KEY = "SegmentedBar.";
    protected com.sas.graphics.util.visualize.SegmentedBar segmentedBar = new VerticalSegmentedBar(RB.getStringResource("SegmentedBar.", "defaultTitle.txt"));
    protected boolean vertical = true;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "segmentVariable"}, {"Short description", RB.getStringResource(RB_KEY, "segmentVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "segmentVariable.pd.txt")}}, {{"Name", "segmentLegendStyle"}, {"Short description", RB.getStringResource(RB_KEY, "segmentLegendStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "segmentLegendStyle.pd.txt")}}, {{"Name", "vertical"}, {"Short description", RB.getStringResource(RB_KEY, "vertical.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "vertical.pd.txt")}}, {{"Name", "styleBy"}, {"Short description", RB.getStringResource(RB_KEY, "styleBy.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "styleBy.pd.txt")}, {"Property editor class", "com.sas.graphics.chart.ModifiedStyleByTypesEditor"}}, {{"Name", "responseColorVariableName"}, {"Hidden", "true"}}, {{"Name", "XVariableName"}, {"Hidden", "true"}}, {{"Name", "ZVariableName"}, {"Hidden", "true"}}, {{"Name", "response2VariableName"}, {"Hidden", "true"}}, {{"Name", "responseHeightVariableName"}, {"Hidden", "true"}}, {{"Name", "spreadSheetData"}, {"Hidden", "true"}}, {{"Name", "segmentValueHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "segmentValueHotspots"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public SegmentedBar() {
        this.bar = this.segmentedBar;
        this.cityscape = this.segmentedBar;
        this.visualization = this.segmentedBar;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Variable variable;
        String propertyName = pce.getPropertyName();
        if (propertyName == null) {
            return;
        }
        Object source = pce.getSource();
        if (source instanceof LegendStyle) {
            LegendStyle legend = (LegendStyle)source;
            if (Util.equal((Object)legend.legendStyle, (Object)this.segmentedBar.getSegmentLegendStyle())) {
                if (this.getStyleBy() != StyleByTypes.SUBGROUP && this.segmentedBar.isNoneVariable(this.segmentedBar.getSegmentVariable())) {
                    this.updateViewer(UPDATE_ALL);
                } else {
                    this.updateViewer(UPDATE_VISUALIZATION);
                }
                this.firePropertyChange("segmentLegendStyle", null, source);
            }
        } else if (source instanceof Variable && Util.equal((Object)(variable = (Variable)source).getVariable(), (Object)this.segmentedBar.getSegmentVariable())) {
            this.setSummaryVariable("Subgroup", variable.getName());
            this.updateViewer(UPDATE_ALL);
            this.firePropertyChange("segmentVariable", null, source);
        }
        super.propertyChange(pce);
    }

    @Override
    public String getDepthVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.segmentedBar.getRowVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setDepthVariableName(String name) {
        String oldValue = this.getDepthVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.segmentedBar.getRowVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.segmentedBar.setRowVariable(v);
        } else {
            v.setName(name);
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("depthVariableName", oldValue, name);
    }

    public IndependentVariable getSegmentVariable() {
        IndependentVariable segmentVariable;
        com.sas.graphics.util.visualize.IndependentVariable v = this.segmentedBar.getSegmentVariable();
        if (v == null) {
            segmentVariable = null;
        } else {
            segmentVariable = new IndependentVariable();
            segmentVariable.setIndependentVariable(v);
            segmentVariable.addPropertyChangeListener(this);
        }
        return segmentVariable;
    }

    public void setSegmentVariable(IndependentVariable segmentVariable) {
        IndependentVariable oldValue;
        com.sas.graphics.util.visualize.IndependentVariable v = this.segmentedBar.getSegmentVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new IndependentVariable();
            oldValue.setIndependentVariable(v);
        }
        if (segmentVariable == null) {
            this.segmentedBar.setSegmentVariable(null);
        } else {
            if (Util.equal((Object)segmentVariable.getVariable(), (Object)this.segmentedBar.getSegmentVariable())) {
                return;
            }
            this.segmentedBar.setSegmentVariable(segmentVariable.getIndependentVariable());
            this.setSummaryVariable("Subgroup", segmentVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("segmentVariable", oldValue, segmentVariable);
    }

    @Override
    public void setForegroundColor(Color newColor) {
        if (newColor == null || newColor == this.getForeground()) {
            return;
        }
        super.setForegroundColor(newColor);
        DiscreteColorLegendStyle tempSegmentLegendStyle = this.getSegmentLegendStyle();
        TextStyle tempLabelStyle = tempSegmentLegendStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        TextStyle tempValueStyle = tempSegmentLegendStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (newFont == null) {
            return;
        }
        boolean isBold = newFont.isBold();
        boolean isItalic = newFont.isItalic();
        String fontFamily = newFont.getFamily();
        int dotPlace = fontFamily.indexOf(".");
        if (dotPlace != -1) {
            fontFamily = fontFamily.substring(0, dotPlace);
        }
        DiscreteColorLegendStyle tempSegmentLegendStyle = this.getSegmentLegendStyle();
        TextStyle tempLabelStyle = tempSegmentLegendStyle.getLabelStyle();
        TextStyle tempValueStyle = tempSegmentLegendStyle.getValueStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
    }

    public DiscreteColorLegendStyle getSegmentLegendStyle() {
        DiscreteColorLegendStyle segmentLegendStyle = new DiscreteColorLegendStyle();
        segmentLegendStyle.legendStyle = this.segmentedBar.getSegmentLegendStyle();
        segmentLegendStyle.addPropertyChangeListener(this);
        return segmentLegendStyle;
    }

    public void setSegmentLegendStyle(DiscreteColorLegendStyle segmentLegendStyle) {
        if (segmentLegendStyle == null || Util.equal((Object)segmentLegendStyle.getLegendStyle(), (Object)this.segmentedBar.getSegmentLegendStyle())) {
            return;
        }
        DiscreteColorLegendStyle oldValue = new DiscreteColorLegendStyle();
        oldValue.legendStyle = this.segmentedBar.getSegmentLegendStyle();
        this.segmentedBar.setSegmentLegendStyle(segmentLegendStyle.getLegendStyle());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("segmentLegendStyle", oldValue, segmentLegendStyle);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        boolean oldValue = this.isVertical();
        if (vertical == oldValue) {
            return;
        }
        this.vertical = vertical;
        this.segmentedBar = vertical ? new VerticalSegmentedBar(this.segmentedBar) : new HorizontalSegmentedBar(this.segmentedBar);
        this.bar = this.segmentedBar;
        this.cityscape = this.segmentedBar;
        this.visualization = this.segmentedBar;
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("vertical", new Boolean(oldValue), new Boolean(vertical));
    }

    public boolean isSpreadSheetData() {
        return this.segmentedBar.isSpreadSheetData();
    }

    public void setSpreadSheetData(boolean spreadSheet) {
        boolean oldValue = this.isSpreadSheetData();
        if (spreadSheet == oldValue) {
            return;
        }
        this.segmentedBar.setSpreadSheetData(spreadSheet);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("spreadSheet", new Boolean(oldValue), new Boolean(spreadSheet));
    }

    public StyleByTypes getStyleBy() {
        return StyleByTypes.getEnum(this.segmentedBar.getStyleBy());
    }

    public void setStyleBy(StyleByTypes byType) {
        if (byType.getValue() == this.segmentedBar.getStyleBy()) {
            return;
        }
        StyleByTypes oldValue = this.getStyleBy();
        this.segmentedBar.setStyleBy(byType.getValue());
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("styleBy", (Object)oldValue, (Object)byType);
    }

    public String getClickedRow(boolean formatted) {
        return this.segmentedBar.getClickedRow(formatted);
    }

    public String getClickedColumn(boolean formatted) {
        return this.segmentedBar.getClickedColumn(formatted);
    }

    public String getClickedHeight(boolean formatted) {
        return this.segmentedBar.getClickedHeight(formatted);
    }

    public String getClickedSegment(boolean formatted) {
        return this.segmentedBar.getClickedSegment(formatted);
    }

    public String getClickedGroup(boolean formatted) {
        return this.segmentedBar.getClickedGroup(formatted);
    }

    @Override
    public String getCategoryVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.segmentedBar.getColumnVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setCategoryVariableName(String name) {
        String oldValue = this.getCategoryVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.segmentedBar.getColumnVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.segmentedBar.setColumnVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Category", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("categoryVariableName", oldValue, name);
    }

    @Override
    public String getSubGroupVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.segmentedBar.getSegmentVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setSubGroupVariableName(String name) {
        String oldValue = this.getSubGroupVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.segmentedBar.getSegmentVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.segmentedBar.setSegmentVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Subgroup", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("subGroupVariableName", oldValue, name);
    }

    @Override
    protected void resetNoneVariables() {
        com.sas.graphics.util.visualize.Variable variable = this.segmentedBar.getRowVariable();
        if (variable != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.segmentedBar.getColumnVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.segmentedBar.getHeightVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.segmentedBar.getSegmentVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.segmentedBar.getGroupVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            SegmentedBar clone = (SegmentedBar)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.initialize();
            clone.setTitle(this.getTitle());
            clone.setTitleStyle(this.getTitleStyle());
            clone.setDepth(this.getDepth());
            clone.setMapColors(this.getMapColors());
            clone.setBackground(this.getBackground());
            clone.setBackgroundImage(this.getBackgroundImage());
            clone.setTransparent(this.isTransparent());
            clone.setOutlineColor(this.getOutlineColor());
            clone.setDataTipStyle(this.getDataTipStyle());
            clone.setResolution(this.getResolution());
            clone.setDatatipDoubleBuffered(this.isDatatipDoubleBuffered());
            clone.setMaxObservations(this.getMaxObservations());
            clone.setDisplayChartType(this.isDisplayChartType());
            clone.setShowStatistic(this.isShowStatistic());
            clone.setHidePopupMenu(this.isHidePopupMenu());
            clone.setPopupColumnInfoUsed(this.getPopupColumnInfoUsed());
            clone.setSwanStyleData(this.isSwanStyleData());
            clone.setBackplaneVisible(this.isBackplaneVisible());
            clone.setBackplaneColor(this.getBackplaneColor());
            clone.setRowVariable(this.getRowVariable());
            clone.setRowAxisStyle(this.getRowAxisStyle());
            clone.setColumnVariable(this.getColumnVariable());
            clone.setColumnAxisStyle(this.getColumnAxisStyle());
            clone.setHeightVariable(this.getHeightVariable());
            clone.setHeightAxisStyle(this.getHeightAxisStyle());
            clone.setGroupVariable(this.getGroupVariable());
            clone.setGroupAxisStyle(this.getGroupAxisStyle());
            clone.setGeometryType(this.getGeometryType());
            clone.setGeometrySize(this.getGeometrySize());
            clone.setAbsoluteSize(this.isAbsoluteSize());
            clone.setAbsoluteGeometrySize(this.getAbsoluteGeometrySize());
            clone.setSegmentVariable(this.getSegmentVariable());
            clone.setSegmentLegendStyle(this.getSegmentLegendStyle());
            clone.setVertical(this.isVertical());
            clone.setSpreadSheetData(this.isSpreadSheetData());
            clone.setStyleBy(this.getStyleBy());
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    public void setSegmentValueHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isSegmentValueHotspotsEnabled();
        this.segmentedBar.setSegmentValueHotspotsEnabled(newValue);
        newValue = this.isSegmentValueHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("SegmentValueHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public boolean isSegmentValueHotspotsEnabled() {
        return this.segmentedBar.isSegmentValueHotspotsEnabled();
    }

    public Blob[] getSegmentValueHotspots() {
        return this.segmentedBar.getSegmentValueHotspots();
    }
}

