/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.AxisStyle;
import com.sas.graphics.chart.Chart;
import com.sas.graphics.chart.DependentVariable;
import com.sas.graphics.chart.GridStyle;
import com.sas.graphics.chart.IndependentVariable;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.TextStyle;
import com.sas.graphics.chart.Variable;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.Cityscape;
import com.sas.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;

public abstract class RowColumn
extends Chart
implements Serializable {
    static final long serialVersionUID = 1037821484194108545L;
    public static final String RB_KEY = "RowColumn.";
    protected Cityscape cityscape;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "backplaneVisible"}, {"Short description", RB.getStringResource(RB_KEY, "backplaneVisible.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "backplaneVisible.pd.txt")}}, {{"Name", "backplaneColor"}, {"Short description", RB.getStringResource(RB_KEY, "backplaneColor.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "backplaneColor.pd.txt")}}, {{"Name", "rowVariable"}, {"Short description", RB.getStringResource(RB_KEY, "rowVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "rowVariable.pd.txt")}}, {{"Name", "rowAxisStyle"}, {"Short description", RB.getStringResource(RB_KEY, "rowAxisStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "rowAxisStyle.pd.txt")}}, {{"Name", "columnVariable"}, {"Short description", RB.getStringResource(RB_KEY, "columnVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "columnVariable.pd.txt")}}, {{"Name", "columnAxisStyle"}, {"Short description", RB.getStringResource(RB_KEY, "columnAxisStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "columnAxisStyle.pd.txt")}}, {{"Name", "heightVariable"}, {"Short description", RB.getStringResource(RB_KEY, "heightVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "heightVariable.pd.txt")}}, {{"Name", "heightAxisStyle"}, {"Short description", RB.getStringResource(RB_KEY, "heightAxisStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "heightAxisStyle.pd.txt")}}, {{"Name", "horizontalReferenceLines"}, {"Hidden", "true"}}, {{"Name", "horizontalReferenceLineLabels"}, {"Hidden", "true"}}, {{"Name", "verticalReferenceLines"}, {"Hidden", "true"}}, {{"Name", "verticalReferenceLineLabels"}, {"Hidden", "true"}}, {{"Name", "subsetDataMode"}, {"Short description", RB.getStringResource(RB_KEY, "subsetDataMode.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "subsetDataMode.pd.txt")}}, {{"Name", "columnValueHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "columnValueHotspots"}, {"Hidden", "true"}}, {{"Name", "rowValueHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "rowValueHotspots"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propertyName = pce.getPropertyName();
        if (propertyName == null) {
            return;
        }
        Object source = pce.getSource();
        if (source instanceof AxisStyle) {
            AxisStyle axis = (AxisStyle)source;
            if (Util.equal((Object)axis.axisStyle, (Object)this.cityscape.getHeightLegendStyle())) {
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("heightAxisStyle", null, source);
            } else if (Util.equal((Object)axis.axisStyle, (Object)this.cityscape.getRowLegendStyle())) {
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("rowAxisStyle", null, source);
            } else if (Util.equal((Object)axis.axisStyle, (Object)this.cityscape.getColumnLegendStyle())) {
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("columnAxisStyle", null, source);
            }
        } else if (source instanceof Variable) {
            Variable variable = (Variable)source;
            if (Util.equal((Object)variable.getVariable(), (Object)this.cityscape.getHeightVariable())) {
                this.setSummaryVariable("Response", variable.getName());
                this.updateViewer(UPDATE_ALL);
                this.firePropertyChange("heightVariable", null, source);
            } else if (Util.equal((Object)variable.getVariable(), (Object)this.cityscape.getRowVariable())) {
                this.updateViewer(UPDATE_ALL);
                this.firePropertyChange("rowVariable", null, source);
            } else if (Util.equal((Object)variable.getVariable(), (Object)this.cityscape.getColumnVariable())) {
                this.setSummaryVariable("Category", variable.getName());
                this.updateViewer(UPDATE_ALL);
                this.firePropertyChange("columnVariable", null, source);
            }
        }
        super.propertyChange(pce);
    }

    public IndependentVariable getRowVariable() {
        IndependentVariable rowVariable;
        com.sas.graphics.util.visualize.IndependentVariable v = this.cityscape.getRowVariable();
        if (v == null) {
            rowVariable = null;
        } else {
            rowVariable = new IndependentVariable();
            rowVariable.setIndependentVariable(v);
            rowVariable.addPropertyChangeListener(this);
        }
        return rowVariable;
    }

    public void setRowVariable(IndependentVariable rowVariable) {
        IndependentVariable oldValue;
        com.sas.graphics.util.visualize.IndependentVariable v = this.cityscape.getRowVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new IndependentVariable();
            oldValue.setIndependentVariable(v);
        }
        if (rowVariable == null) {
            this.cityscape.setRowVariable(null);
        } else {
            if (Util.equal((Object)rowVariable.getVariable(), (Object)this.cityscape.getRowVariable())) {
                return;
            }
            this.cityscape.setRowVariable(rowVariable.getIndependentVariable());
            this.setSummaryVariable("Category", rowVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("rowVariable", oldValue, rowVariable);
    }

    @Override
    public void setForegroundColor(Color newColor) {
        if (newColor == null || newColor == this.getForeground()) {
            return;
        }
        super.setForegroundColor(newColor);
        AxisStyle tempAxisStyle = this.getRowAxisStyle();
        tempAxisStyle.setAxisColor(newColor);
        GridStyle tempGridStyle = tempAxisStyle.getGridStyle();
        tempGridStyle.setColor(newColor);
        TextStyle tempValueStyle = tempAxisStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
        TextStyle tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        tempAxisStyle = this.getColumnAxisStyle();
        tempAxisStyle.setAxisColor(newColor);
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempGridStyle.setColor(newColor);
        tempValueStyle.setColor(newColor);
        tempLabelStyle.setColor(newColor);
        tempAxisStyle = this.getHeightAxisStyle();
        tempAxisStyle.setAxisColor(newColor);
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempGridStyle.setColor(newColor);
        tempValueStyle.setColor(newColor);
        tempLabelStyle.setColor(newColor);
        this.setHorizontalReferenceLineColor(newColor);
        this.setVerticalReferenceLineColor(newColor);
        tempLabelStyle = this.getHorizontalReferenceLineLabelStyle();
        tempLabelStyle.setColor(newColor);
        tempLabelStyle = this.getVerticalReferenceLineLabelStyle();
        tempLabelStyle.setColor(newColor);
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (newFont == null) {
            return;
        }
        boolean isBold = newFont.isBold();
        boolean isItalic = newFont.isItalic();
        String fontFamily = newFont.getFamily();
        int dotPlace = fontFamily.indexOf(".");
        if (dotPlace != -1) {
            fontFamily = fontFamily.substring(0, dotPlace);
        }
        AxisStyle tempAxisStyle = this.getRowAxisStyle();
        GridStyle tempGridStyle = tempAxisStyle.getGridStyle();
        TextStyle tempValueStyle = tempAxisStyle.getValueStyle();
        TextStyle tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        tempAxisStyle = this.getColumnAxisStyle();
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        tempAxisStyle = this.getHeightAxisStyle();
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        tempLabelStyle = this.getHorizontalReferenceLineLabelStyle();
        tempLabelStyle = this.getVerticalReferenceLineLabelStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
    }

    public AxisStyle getRowAxisStyle() {
        AxisStyle rowAxisStyle = new AxisStyle();
        rowAxisStyle.axisStyle = this.cityscape.getRowLegendStyle();
        rowAxisStyle.addPropertyChangeListener(this);
        return rowAxisStyle;
    }

    public void setRowAxisStyle(AxisStyle rowAxisStyle) {
        if (rowAxisStyle == null || Util.equal((Object)rowAxisStyle.axisStyle, (Object)this.cityscape.getRowLegendStyle())) {
            return;
        }
        AxisStyle oldValue = new AxisStyle();
        oldValue.axisStyle = this.cityscape.getRowLegendStyle();
        this.cityscape.setRowLegendStyle(rowAxisStyle.axisStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("rowAxisStyle", oldValue, rowAxisStyle);
    }

    public IndependentVariable getColumnVariable() {
        IndependentVariable columnVariable;
        com.sas.graphics.util.visualize.IndependentVariable v = this.cityscape.getColumnVariable();
        if (v == null) {
            columnVariable = null;
        } else {
            columnVariable = new IndependentVariable();
            columnVariable.setIndependentVariable(v);
            columnVariable.addPropertyChangeListener(this);
        }
        return columnVariable;
    }

    public void setColumnVariable(IndependentVariable columnVariable) {
        IndependentVariable oldValue;
        com.sas.graphics.util.visualize.IndependentVariable v = this.cityscape.getColumnVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new IndependentVariable();
            oldValue.setIndependentVariable(v);
        }
        if (columnVariable == null) {
            this.cityscape.setColumnVariable(null);
        } else {
            if (Util.equal((Object)columnVariable.getVariable(), (Object)this.cityscape.getColumnVariable())) {
                return;
            }
            this.cityscape.setColumnVariable(columnVariable.getIndependentVariable());
            this.setSummaryVariable("Category", columnVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("columnVariable", oldValue, columnVariable);
    }

    public AxisStyle getColumnAxisStyle() {
        AxisStyle columnAxisStyle = new AxisStyle();
        columnAxisStyle.axisStyle = this.cityscape.getColumnLegendStyle();
        columnAxisStyle.addPropertyChangeListener(this);
        return columnAxisStyle;
    }

    public void setColumnAxisStyle(AxisStyle columnAxisStyle) {
        if (columnAxisStyle == null || Util.equal((Object)columnAxisStyle.axisStyle, (Object)this.cityscape.getColumnLegendStyle())) {
            return;
        }
        AxisStyle oldValue = new AxisStyle();
        oldValue.axisStyle = this.cityscape.getColumnLegendStyle();
        this.cityscape.setColumnLegendStyle(columnAxisStyle.axisStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("columnAxisStyle", oldValue, columnAxisStyle);
    }

    public DependentVariable getHeightVariable() {
        DependentVariable heightVariable;
        com.sas.graphics.util.visualize.DependentVariable v = this.cityscape.getHeightVariable();
        if (v == null) {
            heightVariable = null;
        } else {
            heightVariable = new DependentVariable();
            heightVariable.setDependentVariable(v);
            heightVariable.addPropertyChangeListener(this);
        }
        return heightVariable;
    }

    public void setHeightVariable(DependentVariable heightVariable) {
        DependentVariable oldValue;
        com.sas.graphics.util.visualize.DependentVariable v = this.cityscape.getHeightVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new DependentVariable();
            oldValue.setDependentVariable(v);
        }
        if (heightVariable == null) {
            this.cityscape.setHeightVariable(null);
        } else {
            if (Util.equal((Object)heightVariable.getVariable(), (Object)this.cityscape.getHeightVariable())) {
                return;
            }
            this.cityscape.setHeightVariable(heightVariable.getDependentVariable());
            this.setSummaryVariable("Response", heightVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("heightVariable", oldValue, heightVariable);
    }

    public AxisStyle getHeightAxisStyle() {
        AxisStyle heightAxisStyle = new AxisStyle();
        heightAxisStyle.axisStyle = this.cityscape.getHeightLegendStyle();
        heightAxisStyle.addPropertyChangeListener(this);
        return heightAxisStyle;
    }

    public void setHeightAxisStyle(AxisStyle heightAxisStyle) {
        if (heightAxisStyle == null || Util.equal((Object)heightAxisStyle.axisStyle, (Object)this.cityscape.getHeightLegendStyle())) {
            return;
        }
        AxisStyle oldValue = new AxisStyle();
        oldValue.axisStyle = this.cityscape.getHeightLegendStyle();
        this.cityscape.setHeightLegendStyle(heightAxisStyle.axisStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("heightAxisStyle", oldValue, heightAxisStyle);
    }

    public boolean isBackplaneVisible() {
        return this.cityscape.isBackplaneVisible();
    }

    public void setBackplaneVisible(boolean visible) {
        boolean oldValue = this.isBackplaneVisible();
        if (visible == oldValue) {
            return;
        }
        this.cityscape.setBackplaneVisible(visible);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("backplaneVisible", new Boolean(oldValue), new Boolean(visible));
    }

    public boolean isSubsetDataMode() {
        return this.cityscape.isSubsetDataMode();
    }

    public void setSubsetDataMode(boolean mode) {
        boolean oldValue = this.isSubsetDataMode();
        if (mode == oldValue) {
            return;
        }
        this.cityscape.setSubsetDataMode(mode);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("subsetDataMode", new Boolean(oldValue), new Boolean(mode));
    }

    public Color getBackplaneColor() {
        return this.cityscape.getBackplaneColor();
    }

    public void setBackplaneColor(Color backplaneColorIn) {
        Color oldValue = this.getBackplaneColor();
        if (Util.equal((Object)backplaneColorIn, (Object)oldValue)) {
            return;
        }
        this.cityscape.setBackplaneColor(backplaneColorIn);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("backplaneColor", oldValue, backplaneColorIn);
    }

    @Override
    public String getResponseVariableName() {
        com.sas.graphics.util.visualize.DependentVariable v = this.cityscape.getHeightVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setResponseVariableName(String name) {
        String oldValue = this.getResponseVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.DependentVariable v = this.cityscape.getHeightVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.DependentVariable();
            v.setName(name);
            this.cityscape.setHeightVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Response", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("responseVariableName", oldValue, name);
    }

    public void setHorizontalReferenceLineColor(Color colorIn) {
        Color oldValue = this.getHorizontalReferenceLineColor();
        if (Util.equal((Object)colorIn, (Object)oldValue)) {
            return;
        }
        this.cityscape.setHorizontalReferenceLineColor(colorIn);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("horizontalReferenceLineColor", oldValue, colorIn);
    }

    public Color getHorizontalReferenceLineColor() {
        return this.cityscape.getHorizontalReferenceLineColor();
    }

    public void setVerticalReferenceLineColor(Color colorIn) {
        Color oldValue = this.getVerticalReferenceLineColor();
        if (Util.equal((Object)colorIn, (Object)oldValue)) {
            return;
        }
        this.cityscape.setVerticalReferenceLineColor(colorIn);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("verticalReferenceLineColor", oldValue, colorIn);
    }

    public Color getVerticalReferenceLineColor() {
        return this.cityscape.getVerticalReferenceLineColor();
    }

    public void setHorizontalReferenceLines(float[] values) {
        this.cityscape.setHorizontalReferenceLines(values);
    }

    public void setHorizontalReferenceLines(String[] values) {
        this.cityscape.setHorizontalReferenceLines(values);
    }

    public void setVerticalReferenceLines(float[] values) {
        this.cityscape.setVerticalReferenceLines(values);
    }

    public void setVerticalReferenceLines(String[] values) {
        this.cityscape.setVerticalReferenceLines(values);
    }

    public void setVerticalReferenceLineLabels(String[] labels) {
        this.cityscape.setVerticalReferenceLineLabels(labels);
    }

    public void setHorizontalReferenceLineLabels(String[] labels) {
        this.cityscape.setHorizontalReferenceLineLabels(labels);
    }

    public void setHorizontalReferenceLineLabelStyle(TextStyle labelStyle) {
        if (labelStyle == null || Util.equal((Object)labelStyle.textStyle, (Object)this.cityscape.getHorizontalReferenceLineLabelStyle())) {
            return;
        }
        TextStyle oldValue = new TextStyle();
        oldValue.textStyle = this.cityscape.getHorizontalReferenceLineLabelStyle();
        this.cityscape.setHorizontalReferenceLineLabelStyle(labelStyle.textStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("horizontalReferenceLineLabelStyle", oldValue, labelStyle);
    }

    public TextStyle getHorizontalReferenceLineLabelStyle() {
        TextStyle labelStyle = new TextStyle();
        labelStyle.textStyle = this.cityscape.getHorizontalReferenceLineLabelStyle();
        labelStyle.addPropertyChangeListener(this);
        return labelStyle;
    }

    public void setVerticalReferenceLineLabelStyle(TextStyle labelStyle) {
        if (labelStyle == null || Util.equal((Object)labelStyle.textStyle, (Object)this.cityscape.getVerticalReferenceLineLabelStyle())) {
            return;
        }
        TextStyle oldValue = new TextStyle();
        oldValue.textStyle = this.cityscape.getVerticalReferenceLineLabelStyle();
        this.cityscape.setVerticalReferenceLineLabelStyle(labelStyle.textStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("verticalReferenceLineLabelStyle", oldValue, labelStyle);
    }

    public TextStyle getVerticalReferenceLineLabelStyle() {
        TextStyle labelStyle = new TextStyle();
        labelStyle.textStyle = this.cityscape.getVerticalReferenceLineLabelStyle();
        labelStyle.addPropertyChangeListener(this);
        return labelStyle;
    }

    public void setClipReferenceLine(boolean flag) {
        boolean oldValue = this.isClipReferenceLine();
        if (flag == oldValue) {
            return;
        }
        this.cityscape.setClipReferenceLine(flag);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("clipReferenceLine", new Boolean(oldValue), new Boolean(flag));
    }

    public boolean isClipReferenceLine() {
        return this.cityscape.isClipReferenceLine();
    }

    public void setShowReferenceLineLabel(boolean flag) {
        boolean oldValue = this.isShowReferenceLineLabel();
        if (flag == oldValue) {
            return;
        }
        this.cityscape.setShowReferenceLineLabel(flag);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("showReferenceLineLabel", new Boolean(oldValue), new Boolean(flag));
    }

    public boolean isShowReferenceLineLabel() {
        return this.cityscape.isShowReferenceLineLabel();
    }

    public void setColumnValueHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isColumnValueHotspotsEnabled();
        this.cityscape.setColumnValueHotspotsEnabled(newValue);
        newValue = this.isColumnValueHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("columnValueHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public boolean isColumnValueHotspotsEnabled() {
        return this.cityscape.isColumnValueHotspotsEnabled();
    }

    public Blob[] getColumnValueHotspots() {
        return this.cityscape.getColumnValueHotspots();
    }

    public void setRowValueHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isRowValueHotspotsEnabled();
        this.cityscape.setRowValueHotspotsEnabled(newValue);
        newValue = this.isRowValueHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("rowValueHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public boolean isRowValueHotspotsEnabled() {
        return this.cityscape.isRowValueHotspotsEnabled();
    }

    public Blob[] getRowValueHotspots() {
        return this.cityscape.getRowValueHotspots();
    }

    @Override
    public void setVariableHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isVariableHotspotsEnabled();
        this.cityscape.setVariableHotspotsEnabled(newValue);
        newValue = this.isVariableHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("variableHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    @Override
    public boolean isVariableHotspotsEnabled() {
        return this.cityscape.isVariableHotspotsEnabled();
    }

    @Override
    public Blob[] getVariableHotspots() {
        return this.cityscape.getVariableHotspots();
    }
}

