/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.Chart;
import com.sas.graphics.chart.DependentVariable;
import com.sas.graphics.chart.DiscreteColorLegendStyle;
import com.sas.graphics.chart.IndependentVariable;
import com.sas.graphics.chart.LegendStyle;
import com.sas.graphics.chart.PieLabelTypes;
import com.sas.graphics.chart.PieOthersModes;
import com.sas.graphics.chart.PolarLegendStyle;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.TextStyle;
import com.sas.graphics.chart.Variable;
import com.sas.graphics.util.visualize.Blob;
import com.sas.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;

public class Pie
extends Chart
implements Serializable {
    static final long serialVersionUID = -8035364073475881001L;
    public static final String RB_KEY = "Pie.";
    protected com.sas.graphics.util.visualize.Pie pie = new com.sas.graphics.util.visualize.Pie(RB.getStringResource("Pie.", "defaultTitle.txt"));

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "sectorVariable"}, {"Short description", RB.getStringResource(RB_KEY, "sectorVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "sectorVariable.pd.txt")}}, {{"Name", "sectorLegendStyle"}, {"Short description", RB.getStringResource(RB_KEY, "sectorLegendStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "sectorLegendStyle.pd.txt")}}, {{"Name", "weightVariable"}, {"Short description", RB.getStringResource(RB_KEY, "weightVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "weightVariable.pd.txt")}}, {{"Name", "weightLegendStyle"}, {"Short description", RB.getStringResource(RB_KEY, "weightLegendStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "weightLegendStyle.pd.txt")}}, {{"Name", "clockwise"}, {"Short description", RB.getStringResource(RB_KEY, "clockwise.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "clockwise.pd.txt")}}, {{"Name", "maxSlices"}, {"Short description", RB.getStringResource(RB_KEY, "maxSlices.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "maxSlices.pd.txt")}}, {{"Name", "otherMode"}, {"Short description", RB.getStringResource(RB_KEY, "otherMode.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "otherMode.pd.txt")}, {"Property editor class", "com.sas.graphics.chart.ModifiedPieOthersModesEditor"}}, {{"Name", "pieLabelType"}, {"Short description", RB.getStringResource(RB_KEY, "pieLabel.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "pieLabel.pd.txt")}, {"Property editor class", "com.sas.graphics.chart.ModifiedPieLabelTypesEditor"}}, {{"Name", "pieHeight"}, {"Short description", RB.getStringResource(RB_KEY, "pieHeight.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "pieHeight.pd.txt")}}, {{"Name", "otherPercentThreshold"}, {"Short description", RB.getStringResource(RB_KEY, "percentThreshold.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "percentThreshold.pd.txt")}}, {{"Name", "sortByStatistic"}, {"Hidden", "true"}}, {{"Name", "subGroupVariableName"}, {"Hidden", "true"}}, {{"Name", "groupVariableName"}, {"Hidden", "true"}}, {{"Name", "XVariableName"}, {"Hidden", "true"}}, {{"Name", "ZVariableName"}, {"Hidden", "true"}}, {{"Name", "response2VariableName"}, {"Hidden", "true"}}, {{"Name", "responseColorVariableName"}, {"Hidden", "true"}}, {{"Name", "sectorValueHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "sectorValueHotspots"}, {"Hidden", "true"}}, {{"Name", "elementHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "elementHotspots"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Pie() {
        this.visualization = this.pie;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propertyName = pce.getPropertyName();
        if (propertyName == null) {
            return;
        }
        Object source = pce.getSource();
        if (source instanceof LegendStyle) {
            LegendStyle legend = (LegendStyle)source;
            if (Util.equal((Object)legend.legendStyle, (Object)this.pie.getSectorLegendStyle())) {
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("sectorLegendStyle", null, source);
            } else if (Util.equal((Object)legend.legendStyle, (Object)this.pie.getWeightLegendStyle())) {
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("weightLegendStyle", null, source);
            }
        } else if (source instanceof Variable) {
            Variable variable = (Variable)source;
            if (Util.equal((Object)variable.getVariable(), (Object)this.pie.getSectorVariable())) {
                this.setSummaryVariable("Category", variable.getName());
                this.updateViewer(UPDATE_ALL);
                this.firePropertyChange("sectorVariable", null, source);
            } else if (Util.equal((Object)variable.getVariable(), (Object)this.pie.getWeightVariable())) {
                this.setSummaryVariable("Response", variable.getName());
                this.updateViewer(UPDATE_ALL);
                this.firePropertyChange("weightVariable", null, source);
            } else if (Util.equal((Object)variable.getVariable(), (Object)this.pie.getHeightVariable())) {
                this.updateViewer(UPDATE_ALL);
                this.firePropertyChange("heightVariable", null, source);
            }
        }
        super.propertyChange(pce);
    }

    public IndependentVariable getSectorVariable() {
        IndependentVariable sectorVariable;
        com.sas.graphics.util.visualize.IndependentVariable v = this.pie.getSectorVariable();
        if (v == null) {
            sectorVariable = null;
        } else {
            sectorVariable = new IndependentVariable();
            sectorVariable.setIndependentVariable(v);
            sectorVariable.addPropertyChangeListener(this);
        }
        return sectorVariable;
    }

    public void setSectorVariable(IndependentVariable sectorVariable) {
        IndependentVariable oldValue;
        com.sas.graphics.util.visualize.IndependentVariable v = this.pie.getSectorVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new IndependentVariable();
            oldValue.setIndependentVariable(v);
        }
        if (sectorVariable == null) {
            this.pie.setSectorVariable(null);
        } else {
            if (Util.equal((Object)sectorVariable.getVariable(), (Object)this.pie.getSectorVariable())) {
                return;
            }
            this.pie.setSectorVariable(sectorVariable.getIndependentVariable());
            this.setSummaryVariable("Category", sectorVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("sectorVariable", oldValue, sectorVariable);
    }

    public DiscreteColorLegendStyle getSectorLegendStyle() {
        DiscreteColorLegendStyle sectorLegendStyle = new DiscreteColorLegendStyle();
        sectorLegendStyle.setLegendStyle(this.pie.getSectorLegendStyle());
        sectorLegendStyle.addPropertyChangeListener(this);
        return sectorLegendStyle;
    }

    @Override
    public void setForegroundColor(Color newColor) {
        if (newColor == null || newColor == this.getForeground()) {
            return;
        }
        super.setForegroundColor(newColor);
        DiscreteColorLegendStyle tempLegendStyle = this.getSectorLegendStyle();
        TextStyle tempLabelStyle = tempLegendStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        TextStyle tempValueStyle = tempLegendStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
        PolarLegendStyle tempPolarLegendStyle = this.getWeightLegendStyle();
        tempLabelStyle = tempPolarLegendStyle.getLabelStyle();
        tempValueStyle = tempPolarLegendStyle.getValueStyle();
        tempLabelStyle.setColor(newColor);
        tempValueStyle.setColor(newColor);
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (newFont == null) {
            return;
        }
        boolean isBold = newFont.isBold();
        boolean isItalic = newFont.isItalic();
        String fontFamily = newFont.getFamily();
        int dotPlace = fontFamily.indexOf(".");
        if (dotPlace != -1) {
            fontFamily = fontFamily.substring(0, dotPlace);
        }
        DiscreteColorLegendStyle tempLegendStyle = this.getSectorLegendStyle();
        TextStyle tempLabelStyle = tempLegendStyle.getLabelStyle();
        TextStyle tempValueStyle = tempLegendStyle.getValueStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        PolarLegendStyle tempPolarLegendStyle = this.getWeightLegendStyle();
        tempLabelStyle = tempPolarLegendStyle.getLabelStyle();
        tempValueStyle = tempPolarLegendStyle.getValueStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
    }

    public void setSectorLegendStyle(DiscreteColorLegendStyle sectorLegendStyle) {
        if (sectorLegendStyle == null || Util.equal((Object)sectorLegendStyle.getLegendStyle(), (Object)this.pie.getSectorLegendStyle())) {
            return;
        }
        DiscreteColorLegendStyle oldValue = new DiscreteColorLegendStyle();
        oldValue.setLegendStyle(this.pie.getSectorLegendStyle());
        this.pie.setSectorLegendStyle(sectorLegendStyle.getLegendStyle());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("sectorLegendStyle", oldValue, sectorLegendStyle);
    }

    public DependentVariable getHeightVariable() {
        DependentVariable heightVariable;
        com.sas.graphics.util.visualize.DependentVariable v = this.pie.getHeightVariable();
        if (v == null) {
            heightVariable = null;
        } else {
            heightVariable = new DependentVariable();
            heightVariable.setDependentVariable(v);
            heightVariable.addPropertyChangeListener(this);
        }
        return heightVariable;
    }

    public void setHeightVariable(DependentVariable heightVariable) {
        DependentVariable oldValue;
        com.sas.graphics.util.visualize.DependentVariable v = this.pie.getHeightVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new DependentVariable();
            oldValue.setDependentVariable(v);
        }
        if (heightVariable == null) {
            this.pie.setHeightVariable(null);
        } else {
            if (Util.equal((Object)heightVariable.getVariable(), (Object)this.pie.getHeightVariable())) {
                return;
            }
            this.pie.setHeightVariable(heightVariable.getDependentVariable());
            this.setSummaryVariable("Response2", heightVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("heightVariable", oldValue, heightVariable);
    }

    public DependentVariable getWeightVariable() {
        DependentVariable weightVariable;
        com.sas.graphics.util.visualize.DependentVariable v = this.pie.getWeightVariable();
        if (v == null) {
            weightVariable = null;
        } else {
            weightVariable = new DependentVariable();
            weightVariable.setDependentVariable(v);
            weightVariable.addPropertyChangeListener(this);
        }
        return weightVariable;
    }

    public void setWeightVariable(DependentVariable weightVariable) {
        DependentVariable oldValue;
        com.sas.graphics.util.visualize.DependentVariable v = this.pie.getWeightVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new DependentVariable();
            oldValue.setDependentVariable(v);
        }
        if (weightVariable == null) {
            this.pie.setWeightVariable(null);
        } else {
            if (Util.equal((Object)weightVariable.getVariable(), (Object)this.pie.getWeightVariable())) {
                return;
            }
            this.pie.setWeightVariable(weightVariable.getDependentVariable());
            this.setSummaryVariable("Response", weightVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("weightVariable", oldValue, weightVariable);
    }

    public PolarLegendStyle getWeightLegendStyle() {
        PolarLegendStyle weightLegendStyle = new PolarLegendStyle();
        weightLegendStyle.setLegendStyle(this.pie.getWeightLegendStyle());
        weightLegendStyle.addPropertyChangeListener(this);
        return weightLegendStyle;
    }

    public void setWeightLegendStyle(PolarLegendStyle weightLegendStyle) {
        if (weightLegendStyle == null || Util.equal((Object)weightLegendStyle.getLegendStyle(), (Object)this.pie.getWeightLegendStyle())) {
            return;
        }
        PolarLegendStyle oldValue = new PolarLegendStyle();
        oldValue.setLegendStyle(this.pie.getWeightLegendStyle());
        this.pie.setWeightLegendStyle(weightLegendStyle.getLegendStyle());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("weightLegendStyle", oldValue, weightLegendStyle);
    }

    public boolean isClockwise() {
        return this.pie.getClockwise();
    }

    public void setClockwise(boolean clockwise) {
        boolean oldValue = this.isClockwise();
        if (clockwise == oldValue) {
            return;
        }
        this.pie.setClockwise(clockwise);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("clockwise", new Boolean(oldValue), new Boolean(clockwise));
    }

    public int getMaximumSlices() {
        return this.pie.getMaximumSlices();
    }

    public void setMaximumSlices(int maxslice) {
        int oldValue = this.getMaximumSlices();
        if (maxslice == oldValue) {
            return;
        }
        if (maxslice < 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "maxSlices.ex.txt"));
        }
        this.pie.setMaximumSlices(maxslice);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("maximumSlices", new Integer(oldValue), new Integer(maxslice));
    }

    public PieOthersModes getOtherMode() {
        return PieOthersModes.getEnum(this.pie.getOtherMode());
    }

    public void setOtherMode(PieOthersModes mode) {
        if (mode.getValue() == this.pie.getOtherMode()) {
            return;
        }
        PieOthersModes oldValue = this.getOtherMode();
        this.pie.setOtherMode(mode.getValue());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("otherMode", (Object)oldValue, (Object)mode);
    }

    public PieLabelTypes getPieLabelType() {
        return PieLabelTypes.getEnum(this.pie.getWeightLabelType());
    }

    public void setPieLabelType(PieLabelTypes type) {
        if (type.getValue() == this.pie.getWeightLabelType()) {
            return;
        }
        PieLabelTypes oldValue = this.getPieLabelType();
        this.pie.setWeightLabelType(type.getValue());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("pieLabelType", (Object)oldValue, (Object)type);
    }

    public double getOtherPercentThreshold() {
        return this.pie.getOtherPercentThreshold();
    }

    public void setOtherPercentThreshold(double threshold) {
        double oldValue = this.getOtherPercentThreshold();
        if (threshold == oldValue) {
            return;
        }
        if (threshold < 0.0 || threshold > 1.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "percentThreshold.ex.txt"));
        }
        this.pie.setOtherPercentThreshold(threshold);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("otherPercentThreshold", new Double(oldValue), new Double(threshold));
    }

    public int getSortByStatistic() {
        return this.pie.getSortByStatistic();
    }

    public void setSortByStatistic(int sort) {
        int oldValue = this.getSortByStatistic();
        if (sort == oldValue) {
            return;
        }
        this.pie.setSortByStatistic(sort);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("sortByStatistic", new Integer(oldValue), new Integer(sort));
    }

    public double getPieHeight() {
        return this.pie.getPieHeight();
    }

    public void setPieHeight(double height) {
        double oldValue = this.getPieHeight();
        if (height == oldValue) {
            return;
        }
        if (height < 0.0 || height > 1.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "pieHeight.ex.txt"));
        }
        this.pie.setPieHeight(height);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("pieHeight", new Double(oldValue), new Double(height));
    }

    public String getClickedSector(boolean formatted) {
        return this.pie.getClickedSector(formatted);
    }

    public String getClickedWeight(boolean formatted) {
        return this.pie.getClickedWeight(formatted);
    }

    @Override
    public String getCategoryVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.pie.getSectorVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setCategoryVariableName(String name) {
        String oldValue = this.getCategoryVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.pie.getSectorVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.pie.setSectorVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Category", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("categoryVariableName", oldValue, name);
    }

    @Override
    public String getResponseVariableName() {
        com.sas.graphics.util.visualize.DependentVariable v = this.pie.getWeightVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setResponseVariableName(String name) {
        String oldValue = this.getResponseVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.DependentVariable v = this.pie.getWeightVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.DependentVariable();
            v.setName(name);
            this.pie.setWeightVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Response", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("responseVariableName", oldValue, name);
    }

    @Override
    public String getResponseHeightVariableName() {
        com.sas.graphics.util.visualize.DependentVariable v = this.pie.getHeightVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setResponseHeightVariableName(String name) {
        String oldValue = this.getResponseHeightVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.DependentVariable v = this.pie.getHeightVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.DependentVariable();
            v.setName(name);
            this.pie.setHeightVariable(v);
        } else {
            v.setName(name);
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("responseHeightVariableName", oldValue, name);
    }

    @Override
    protected void resetNoneVariables() {
        com.sas.graphics.util.visualize.Variable variable = this.pie.getSectorVariable();
        if (variable != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.pie.getWeightVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Pie clone = (Pie)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.initialize();
            clone.setTitle(this.getTitle());
            clone.setTitleStyle(this.getTitleStyle());
            clone.setDepth(this.getDepth());
            clone.setMapColors(this.getMapColors());
            clone.setBackground(this.getBackground());
            clone.setBackgroundImage(this.getBackgroundImage());
            clone.setTransparent(this.isTransparent());
            clone.setOutlineColor(this.getOutlineColor());
            clone.setDataTipStyle(this.getDataTipStyle());
            clone.setResolution(this.getResolution());
            clone.setDatatipDoubleBuffered(this.isDatatipDoubleBuffered());
            clone.setMaxObservations(this.getMaxObservations());
            clone.setDisplayChartType(this.isDisplayChartType());
            clone.setShowStatistic(this.isShowStatistic());
            clone.setHidePopupMenu(this.isHidePopupMenu());
            clone.setPopupColumnInfoUsed(this.getPopupColumnInfoUsed());
            clone.setSwanStyleData(this.isSwanStyleData());
            clone.setSectorVariable(this.getSectorVariable());
            clone.setSectorLegendStyle(this.getSectorLegendStyle());
            clone.setWeightVariable(this.getWeightVariable());
            clone.setWeightLegendStyle(this.getWeightLegendStyle());
            clone.setHeightVariable(this.getHeightVariable());
            clone.setClockwise(this.isClockwise());
            clone.setMaximumSlices(this.getMaximumSlices());
            clone.setOtherMode(this.getOtherMode());
            clone.setPieHeight(this.getPieHeight());
            clone.setOtherPercentThreshold(this.getOtherPercentThreshold());
            clone.setSortByStatistic(this.getSortByStatistic());
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    public void setSectorValueHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isSectorValueHotspotsEnabled();
        this.pie.setSectorValueHotspotsEnabled(newValue);
        newValue = this.isSectorValueHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("sectorValueHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public boolean isSectorValueHotspotsEnabled() {
        return this.pie.isSectorValueHotspotsEnabled();
    }

    public Blob[] getSectorValueHotspots() {
        return this.pie.getSectorValueHotspots();
    }

    public void setElementHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isElementHotspotsEnabled();
        this.pie.setElementHotspotsEnabled(newValue);
        newValue = this.isElementHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("elementHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public boolean isElementHotspotsEnabled() {
        return this.pie.isElementHotspotsEnabled();
    }

    public Blob[] getElementHotspots() {
        return this.pie.getElementHotspots();
    }

    @Override
    public void setVariableHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isVariableHotspotsEnabled();
        this.pie.setVariableHotspotsEnabled(newValue);
        newValue = this.isVariableHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("variableHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    @Override
    public boolean isVariableHotspotsEnabled() {
        return this.pie.isVariableHotspotsEnabled();
    }

    @Override
    public Blob[] getVariableHotspots() {
        return this.pie.getVariableHotspots();
    }
}

