/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.graphics.chart.RB;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class MouseFrame
extends Frame
implements WindowListener {
    protected int width = 250;
    protected int height = 250;
    protected String title;
    protected String[] text;
    public static final String RB_KEY = "MouseFrame.";

    public MouseFrame(String title) {
        super(title);
        Object r = null;
        this.title = title == null ? "SAS Institute, Inc." : new String(title);
        this.text = new String[3];
        this.text[0] = MouseFrame.getString("Key1");
        this.text[1] = MouseFrame.getString("Key2");
        this.text[2] = MouseFrame.getString("Key3");
        this.addWindowListener(this);
        this.setSize(this.width, this.height);
    }

    private static String getString(String s) {
        return RB.getStringResource(RB_KEY, s + ".txt");
    }

    @Override
    public void paint(Graphics g) {
        int x = 0;
        int curWidth = this.width;
        int curHeight = this.height;
        FontMetrics fm = g.getFontMetrics();
        Color c = null;
        Color bColor = null;
        Color fColor = null;
        int maxDescent = fm.getMaxDescent();
        int maxAscent = fm.getMaxAscent();
        Dimension d = this.getSize();
        Insets is = this.getInsets();
        curWidth = d.width - is.left - is.right;
        curHeight = d.height - is.top - is.bottom;
        bColor = this.getBackground();
        fColor = g.getColor();
        if (bColor != null && bColor.equals(fColor)) {
            c = bColor.equals(Color.black) ? Color.white : (bColor.equals(Color.white) ? Color.black : fColor.brighter().brighter());
            g.setColor(c);
        }
        g.clearRect(0, 0, curWidth, curHeight);
        int y = is.top + maxDescent + maxAscent;
        int strgWidth = fm.stringWidth(this.title);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.title, x, y);
        x = is.left + fm.stringWidth(" ");
        y += 2 * maxDescent + 2 * maxAscent;
        if (this.text != null) {
            for (int i = 0; i < this.text.length; ++i) {
                g.drawString(this.text[i], x, y);
                y += maxDescent + maxAscent;
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }
}

