/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.AxisStyle;
import com.sas.graphics.chart.BarGeometryTypes;
import com.sas.graphics.chart.GridStyle;
import com.sas.graphics.chart.IndependentVariable;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.RowColumn;
import com.sas.graphics.chart.TextStyle;
import com.sas.graphics.chart.Variable;
import com.sas.graphics.util.visualize.Bar;
import com.sas.graphics.util.visualize.Blob;
import com.sas.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;

public abstract class Group
extends RowColumn {
    static final long serialVersionUID = -8121168137510551773L;
    public static final String RB_KEY = "Group.";
    protected Bar bar;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "groupVariable"}, {"Short description", RB.getStringResource(RB_KEY, "groupVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "groupVariable.pd.txt")}}, {{"Name", "groupAxisStyle"}, {"Short description", RB.getStringResource(RB_KEY, "groupAxisStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "groupAxisStyle.pd.txt")}}, {{"Name", "geometryType"}, {"Short description", RB.getStringResource(RB_KEY, "geometryType.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "geometryType.pd.txt")}, {"Property editor class", "com.sas.graphics.chart.ModifiedBarGeometryTypesEditor"}}, {{"Name", "geometrySize"}, {"Short description", RB.getStringResource(RB_KEY, "geometrySize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "geometrySize.pd.txt")}}, {{"Name", "absoluteSize"}, {"Short description", RB.getStringResource(RB_KEY, "absoluteSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "absoluteSize.pd.txt")}}, {{"Name", "absoluteGeometrySize"}, {"Short description", RB.getStringResource(RB_KEY, "absGeometrySize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "absGeometrySize.pd.txt")}}, {{"Name", "groupValueHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "groupValueHotspots"}, {"Hidden", "true"}}, {{"Name", "elementHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "elementHotspots"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Variable variable;
        String propertyName = pce.getPropertyName();
        if (propertyName == null) {
            return;
        }
        Object source = pce.getSource();
        if (source instanceof AxisStyle) {
            AxisStyle axis = (AxisStyle)source;
            if (Util.equal((Object)axis.axisStyle, (Object)this.bar.getGroupLegendStyle())) {
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("groupAxisStyle", null, source);
            }
        } else if (source instanceof Variable && Util.equal((Object)(variable = (Variable)source).getVariable(), (Object)this.bar.getGroupVariable())) {
            this.setSummaryVariable("Group", variable.getName());
            this.updateViewer(UPDATE_ALL);
            this.firePropertyChange("groupVariable", null, source);
        }
        super.propertyChange(pce);
    }

    public IndependentVariable getGroupVariable() {
        IndependentVariable groupVariable;
        com.sas.graphics.util.visualize.IndependentVariable v = this.bar.getGroupVariable();
        if (v == null) {
            groupVariable = null;
        } else {
            groupVariable = new IndependentVariable();
            groupVariable.setIndependentVariable(v);
            groupVariable.addPropertyChangeListener(this);
        }
        return groupVariable;
    }

    public void setGroupVariable(IndependentVariable groupVariable) {
        IndependentVariable oldValue;
        com.sas.graphics.util.visualize.IndependentVariable v = this.bar.getGroupVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new IndependentVariable();
            oldValue.setIndependentVariable(v);
        }
        if (groupVariable == null) {
            this.bar.setGroupVariable(null);
        } else {
            if (Util.equal((Object)groupVariable.getVariable(), (Object)this.bar.getGroupVariable())) {
                return;
            }
            this.bar.setGroupVariable(groupVariable.getIndependentVariable());
            this.setSummaryVariable("Group", groupVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("groupVariable", oldValue, groupVariable);
    }

    @Override
    public void setForegroundColor(Color newColor) {
        if (newColor == null || newColor == this.getForeground()) {
            return;
        }
        super.setForegroundColor(newColor);
        AxisStyle tempAxisStyle = this.getGroupAxisStyle();
        tempAxisStyle.setAxisColor(newColor);
        GridStyle tempGridStyle = tempAxisStyle.getGridStyle();
        tempGridStyle.setColor(newColor);
        TextStyle tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        TextStyle tempValueStyle = tempAxisStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (newFont == null) {
            return;
        }
        boolean isBold = newFont.isBold();
        boolean isItalic = newFont.isItalic();
        String fontFamily = newFont.getFamily();
        int dotPlace = fontFamily.indexOf(".");
        if (dotPlace != -1) {
            fontFamily = fontFamily.substring(0, dotPlace);
        }
        AxisStyle tempAxisStyle = this.getGroupAxisStyle();
        GridStyle tempGridStyle = tempAxisStyle.getGridStyle();
        TextStyle tempLabelStyle = tempAxisStyle.getLabelStyle();
        TextStyle tempValueStyle = tempAxisStyle.getValueStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
    }

    public AxisStyle getGroupAxisStyle() {
        AxisStyle groupAxisStyle = new AxisStyle();
        groupAxisStyle.axisStyle = this.bar.getGroupLegendStyle();
        groupAxisStyle.addPropertyChangeListener(this);
        return groupAxisStyle;
    }

    public void setGroupAxisStyle(AxisStyle groupAxisStyle) {
        if (groupAxisStyle == null || Util.equal((Object)groupAxisStyle.axisStyle, (Object)this.bar.getGroupLegendStyle())) {
            return;
        }
        AxisStyle oldValue = new AxisStyle();
        oldValue.axisStyle = this.bar.getGroupLegendStyle();
        this.bar.setGroupLegendStyle(groupAxisStyle.axisStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("groupAxisStyle", oldValue, groupAxisStyle);
    }

    public BarGeometryTypes getGeometryType() {
        return BarGeometryTypes.getEnum(this.bar.getGeometryType());
    }

    public void setGeometryType(BarGeometryTypes geometryType) {
        if (geometryType.getValue() == this.bar.getGeometryType()) {
            return;
        }
        BarGeometryTypes oldValue = this.getGeometryType();
        this.bar.setGeometryType(geometryType.getValue());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("geometryType", (Object)oldValue, (Object)geometryType);
    }

    public double getGeometrySize() {
        return this.bar.getGeometrySize();
    }

    public void setGeometrySize(double geometrySize) {
        double oldValue = this.getGeometrySize();
        if (geometrySize == oldValue) {
            return;
        }
        if (geometrySize < 0.0 || geometrySize > 1.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "geometrySize.ex.txt"));
        }
        this.bar.setGeometrySize(geometrySize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("geometrySize", new Double(oldValue), new Double(geometrySize));
    }

    public boolean isAbsoluteSize() {
        return this.bar.isAbsoluteSize();
    }

    public void setAbsoluteSize(boolean fixed) {
        boolean oldValue = this.isAbsoluteSize();
        if (fixed == oldValue) {
            return;
        }
        this.bar.setAbsoluteSize(fixed);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteSize", new Boolean(oldValue), new Boolean(fixed));
    }

    public int getAbsoluteGeometrySize() {
        return this.bar.getAbsoluteGeometrySize();
    }

    public void setAbsoluteGeometrySize(int geometrySize) {
        int oldValue = this.getAbsoluteGeometrySize();
        if (geometrySize == oldValue) {
            return;
        }
        if (geometrySize < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "absGeometrySize.ex.txt"));
        }
        this.bar.setAbsoluteGeometrySize(geometrySize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteGeometrySize", new Integer(oldValue), new Integer(geometrySize));
    }

    @Override
    public String getGroupVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.bar.getGroupVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setGroupVariableName(String name) {
        String oldValue = this.getGroupVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.bar.getGroupVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.bar.setGroupVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Group", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("groupVariableName", oldValue, name);
    }

    public void setGroupValueHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isGroupValueHotspotsEnabled();
        this.cityscape.setGroupValueHotspotsEnabled(newValue);
        newValue = this.isGroupValueHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("groupValueHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public boolean isGroupValueHotspotsEnabled() {
        return this.cityscape.isGroupValueHotspotsEnabled();
    }

    public Blob[] getGroupValueHotspots() {
        return this.cityscape.getGroupValueHotspots();
    }

    public void setElementHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isElementHotspotsEnabled();
        this.bar.setElementHotspotsEnabled(newValue);
        newValue = this.isElementHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("ElementHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public boolean isElementHotspotsEnabled() {
        return this.bar.isElementHotspotsEnabled();
    }

    public Blob[] getElementHotspots() {
        return this.bar.getElementHotspots();
    }

    public void setForceGroupLabelsHorizontal(boolean horizontal) {
        this.bar.setForceGroupLabelsHorizontal(horizontal);
    }

    public boolean getForceGroupLabelsHorizontal() {
        return this.bar.getForceGroupLabelsHorizontal();
    }

    public void setForceGroupLabelsVertical(boolean vertical) {
        this.bar.setForceGroupLabelsVertical(vertical);
    }

    public boolean getForceGroupLabelsVertical() {
        return this.bar.getForceGroupLabelsVertical();
    }
}

