/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.AxisStyle;
import com.sas.graphics.chart.AxisTypes;
import com.sas.graphics.chart.Chart;
import com.sas.graphics.chart.ChartPopupMenu2;
import com.sas.graphics.chart.CombinationSampleData;
import com.sas.graphics.chart.DiscreteColorLegendStyle;
import com.sas.graphics.chart.GridStyle;
import com.sas.graphics.chart.IndependentVariable;
import com.sas.graphics.chart.LegendStyle;
import com.sas.graphics.chart.OverlayChartTypes;
import com.sas.graphics.chart.OverlayHeightVariable;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.TextStyle;
import com.sas.graphics.chart.Variable;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.DependentVariable2;
import com.sas.graphics.util.visualize.Overlay2;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.sasserver.summary.SummaryInterface;
import com.sas.table.StaticTableInterface;
import com.sas.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;

public class Combination
extends Chart
implements Serializable {
    static final long serialVersionUID = -487631897728476617L;
    public static final String RB_KEY = "Combination.";
    protected Overlay2 overlay = new Overlay2(RB.getStringResource("Combination.", "defaultTitle.txt"));
    private ChartPopupMenu2 popup;
    private transient boolean popupInitialized;
    static int count = 0;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "backplaneVisible"}, {"Short description", RB.getStringResource(RB_KEY, "backplaneVisible.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "backplaneVisible.pd.txt")}}, {{"Name", "backplaneColor"}, {"Short description", RB.getStringResource(RB_KEY, "backplaneColor.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "backplaneColor.pd.txt")}}, {{"Name", "columnVariable"}, {"Short description", RB.getStringResource(RB_KEY, "columnVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "columnVariable.pd.txt")}}, {{"Name", "columnAxisStyle"}, {"Short description", RB.getStringResource(RB_KEY, "columnAxisStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "columnAxisStyle.pd.txt")}}, {{"Name", "groupVariable"}, {"Short description", RB.getStringResource(RB_KEY, "groupVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "groupVariable.pd.txt")}}, {{"Name", "heightVariables"}, {"Short description", RB.getStringResource(RB_KEY, "overlayVariables.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "overlayVariables.pd.txt")}, {"Hidden", "true"}}, {{"Name", "leftHeightAxisStyle"}, {"Short description", RB.getStringResource(RB_KEY, "leftHeightAxisStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "leftHeightAxisStyle.pd.txt")}}, {{"Name", "rightHeightAxisStyle"}, {"Short description", RB.getStringResource(RB_KEY, "rightHeightAxisStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "rightHeightAxisStyle.pd.txt")}}, {{"Name", "subgroupVariable"}, {"Short description", RB.getStringResource(RB_KEY, "subgroupVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "subgroupVariable.pd.txt")}}, {{"Name", "overlayLegendStyle"}, {"Short description", RB.getStringResource(RB_KEY, "overlayLegendStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "overlayLegendStyle.pd.txt")}}, {{"Name", "markerSize"}, {"Short description", RB.getStringResource(RB_KEY, "markerSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "markerSize.pd.txt")}}, {{"Name", "lineSize"}, {"Short description", RB.getStringResource(RB_KEY, "joinSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "joinSize.pd.txt")}}, {{"Name", "LeftAxisMappedValue"}, {"Short description", RB.getStringResource(RB_KEY, "leftmap.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "leftmap.pd.txt")}}, {{"Name", "RightAxisMappedValue"}, {"Short description", RB.getStringResource(RB_KEY, "rightmap.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "rightmap.pd.txt")}}, {{"Name", "subsetDataMode"}, {"Short description", RB.getStringResource(RB_KEY, "subsetDataMode.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "subsetDataMode.pd.txt")}}, {{"Name", "leftUserHeightLabel"}, {"Hidden", "true"}}, {{"Name", "rightUserHeightLabel"}, {"Hidden", "true"}}, {{"Name", "absoluteMarkerSize"}, {"Short description", RB.getStringResource(RB_KEY, "absMarkerSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "absMarkerSize.pd.txt")}}, {{"Name", "absoluteJoinSize"}, {"Short description", RB.getStringResource(RB_KEY, "absJoinSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "absJoinSize.pd.txt")}}, {{"Name", "absoluteSize"}, {"Short description", RB.getStringResource(RB_KEY, "absoluteSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "absoluteSize.pd.txt")}}, {{"Name", "XVariableName"}, {"Hidden", "true"}}, {{"Name", "ZVariableName"}, {"Hidden", "true"}}, {{"Name", "responseColorVariableName"}, {"Hidden", "true"}}, {{"Name", "responseHeightVariableName"}, {"Hidden", "true"}}, {{"Name", "groupValueHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "groupValueHotspots"}, {"Hidden", "true"}}, {{"Name", "columnValueHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "columnValueHotspots"}, {"Hidden", "true"}}, {{"Name", "subgroupValueHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "subgroupValueHotspots"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Combination() {
        this.visualization = this.overlay;
        AxisStyle axis = this.getColumnAxisStyle();
        if (axis.getAxisType() == AxisTypes.NONE) {
            axis.setAxisType(AxisTypes.LINE);
        }
    }

    @Override
    public void initialize() {
        this.sample = new CombinationSampleData();
        this.resetDefaultTitle();
        this.resetNoneVariables();
        this.visualization.resetVariables(true);
        this.setSize(this.getWidth(), this.getHeight());
        this.updateViewer(UPDATE_ALL);
    }

    @Override
    public MenuItem[] getPopupMenuItems() {
        return this.getPopupMenu(true).getMainMenuItems();
    }

    private ChartPopupMenu2 getPopupMenu(boolean create) {
        ChartPopupMenu2 cpm = this.popup;
        if (cpm == null) {
            if (!create) {
                return null;
            }
            cpm = new ChartPopupMenu2(this);
            cpm.initialize();
            this.popupInitialized = true;
            this.add(cpm);
            this.popup = cpm;
        } else if (!this.popupInitialized) {
            cpm.setChart(this);
            cpm.initialize();
            this.popupInitialized = true;
        }
        return cpm;
    }

    @Override
    protected void updateViewer(int flag) {
        if (this.isDesignTime() && this.ch != null && this.sample != null) {
            this.setSampleColumnLabels();
            this.visualization.setRectangularData((StaticTableInterface)this.sample);
            this.visualization.footnote = RB.getStringResource("Chart.", "designTime.footnote.txt");
        } else {
            this.visualization.footnote = null;
        }
        if (this.ch != null && this.isUpdatable()) {
            try {
                ChartPopupMenu2 cpm = this.getPopupMenu(false);
                if (flag == UPDATE_ALL || this.isDesignTime()) {
                    this.visualization.makeModel(this.ch);
                    if (cpm != null) {
                        cpm.updateVariablesMenu();
                    }
                }
                if (cpm != null) {
                    cpm.updateVisualsMenu();
                }
                this.visualization.makeChart(this.ch);
            }
            catch (OutOfMemoryError e) {
                this.ch.glEndList();
                this.visualization.invalidateVisualization(this.ch);
                throw e;
            }
            catch (VisualizationException e) {
                System.out.println(e.getMessage());
            }
            finally {
                this.repaint();
            }
        }
    }

    public void setMapShapes(int[] shapes) {
        if (shapes == null) {
            return;
        }
        int[] map = new int[shapes.length];
        for (int i = 0; i < shapes.length; ++i) {
            map[i] = shapes[i];
        }
        this.overlay.setMapShapes(map);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("mapShapes", null, shapes);
    }

    public int[] getMapShapes() {
        return this.overlay.getMapShapes();
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
        if (!this.hidePopupMenu && e.isPopupTrigger()) {
            this.getPopupMenu(true).show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        this.visualization.stopScrolling(this.ch, e.getX(), e.getY());
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        block19: {
            Object source;
            String propertyName;
            block22: {
                block17: {
                    AxisStyle axis;
                    block21: {
                        block20: {
                            block18: {
                                propertyName = pce.getPropertyName();
                                if (propertyName == null) {
                                    return;
                                }
                                source = pce.getSource();
                                if (!(source instanceof AxisStyle)) break block17;
                                axis = (AxisStyle)source;
                                if (!Util.equal((Object)axis.axisStyle, (Object)this.overlay.getHeightLegendStyle())) break block18;
                                this.updateViewer(UPDATE_VISUALIZATION);
                                this.firePropertyChange("leftHeightAxisStyle", null, source);
                                break block19;
                            }
                            if (!Util.equal((Object)axis.axisStyle, (Object)this.overlay.getHeightLegendStyle2())) break block20;
                            this.updateViewer(UPDATE_VISUALIZATION);
                            this.firePropertyChange("rightHeightAxisStyle", null, source);
                            break block19;
                        }
                        if (!Util.equal((Object)axis.axisStyle, (Object)this.overlay.getColumnLegendStyle())) break block21;
                        this.updateViewer(UPDATE_VISUALIZATION);
                        this.firePropertyChange("columnAxisStyle", null, source);
                        break block19;
                    }
                    if (!Util.equal((Object)axis.axisStyle, (Object)this.overlay.getGroupLegendStyle())) break block19;
                    this.updateViewer(UPDATE_VISUALIZATION);
                    this.firePropertyChange("groupLegendStyle", null, source);
                    break block19;
                }
                if (!(source instanceof LegendStyle)) break block22;
                LegendStyle legend = (LegendStyle)source;
                if (!Util.equal((Object)legend.legendStyle, (Object)this.overlay.getOverlayLegendStyle())) break block19;
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("overlayLegendStyle", null, source);
                break block19;
            }
            if (propertyName.equals("response2VariableName")) {
                OverlayHeightVariable[] variables = this.getHeightVariables();
                if (variables.length <= 1) {
                    return;
                }
                OverlayHeightVariable hv2 = variables[1];
                if (hv2 == null) {
                    return;
                }
                hv2.setOverlayAxis(2);
            } else if (source instanceof Variable) {
                Variable variable = (Variable)source;
                if (Util.equal((Object)variable.getVariable(), (Object)this.overlay.getColumnVariable())) {
                    this.setSummaryVariable("Category", variable.getName());
                    this.updateViewer(UPDATE_ALL);
                    this.firePropertyChange("columnVariable", null, source);
                } else if (Util.equal((Object)variable.getVariable(), (Object)this.overlay.getGroupVariable())) {
                    this.setSummaryVariable("Group", variable.getName());
                    this.updateViewer(UPDATE_ALL);
                    this.firePropertyChange("groupVariable", null, source);
                } else if (Util.equal((Object)variable.getVariable(), (Object)this.overlay.getSubGroupVariable())) {
                    this.setSummaryVariable("Subgroup", variable.getName());
                    this.updateViewer(UPDATE_ALL);
                    this.firePropertyChange("subgroupVariable", null, source);
                } else if (source instanceof OverlayHeightVariable) {
                    OverlayHeightVariable dv2 = (OverlayHeightVariable)source;
                    DependentVariable2 hv = dv2.getDependentVariable2();
                    DependentVariable2[] heightVariables = this.overlay.getHeightVariables();
                    for (int i = 0; i < heightVariables.length; ++i) {
                        if (!Util.equal((Object)variable.getVariable(), (Object)heightVariables[i])) continue;
                        if (i == 0 && heightVariables[0] != null) {
                            this.setSummaryVariable("Response", heightVariables[0].getName());
                        } else if (i == 1 && heightVariables[1] != null) {
                            this.setSummaryVariable("ResponseColor", heightVariables[1].getName());
                        }
                        this.updateViewer(UPDATE_ALL);
                        this.firePropertyChange("heightVariables", null, source);
                        break;
                    }
                }
            }
        }
        super.propertyChange(pce);
    }

    public IndependentVariable getColumnVariable() {
        IndependentVariable columnVariable;
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            columnVariable = null;
        } else {
            columnVariable = new IndependentVariable();
            columnVariable.setIndependentVariable(v);
            columnVariable.addPropertyChangeListener(this);
        }
        return columnVariable;
    }

    public void setColumnVariable(IndependentVariable columnVariable) {
        IndependentVariable oldValue;
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new IndependentVariable();
            oldValue.setIndependentVariable(v);
        }
        if (columnVariable == null) {
            this.overlay.setColumnVariable(null);
        } else {
            if (Util.equal((Object)columnVariable.getVariable(), (Object)this.overlay.getColumnVariable())) {
                return;
            }
            this.overlay.setColumnVariable(columnVariable.getIndependentVariable());
            this.setSummaryVariable("Category", columnVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("columnVariable", oldValue, columnVariable);
    }

    @Override
    public void setForegroundColor(Color newColor) {
        if (newColor == null || newColor == this.getForeground()) {
            return;
        }
        super.setForegroundColor(newColor);
        AxisStyle tempAxisStyle = this.getColumnAxisStyle();
        GridStyle tempGridStyle = tempAxisStyle.getGridStyle();
        tempGridStyle.setColor(newColor);
        TextStyle tempValueStyle = tempAxisStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
        TextStyle tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        tempAxisStyle = this.getGroupAxisStyle();
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempGridStyle.setColor(newColor);
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        tempAxisStyle = this.getRightHeightAxisStyle();
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempGridStyle.setColor(newColor);
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        tempAxisStyle = this.getLeftHeightAxisStyle();
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempGridStyle.setColor(newColor);
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        DiscreteColorLegendStyle tempOverlayLegendStyle = this.getOverlayLegendStyle();
        tempLabelStyle = tempOverlayLegendStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        tempValueStyle = tempOverlayLegendStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (newFont == null) {
            return;
        }
        boolean isBold = newFont.isBold();
        boolean isItalic = newFont.isItalic();
        String fontFamily = newFont.getFamily();
        int dotPlace = fontFamily.indexOf(".");
        if (dotPlace != -1) {
            fontFamily = fontFamily.substring(0, dotPlace);
        }
        AxisStyle tempAxisStyle = this.getColumnAxisStyle();
        GridStyle tempGridStyle = tempAxisStyle.getGridStyle();
        TextStyle tempValueStyle = tempAxisStyle.getValueStyle();
        TextStyle tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempAxisStyle = this.getGroupAxisStyle();
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempAxisStyle = this.getRightHeightAxisStyle();
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempAxisStyle = this.getLeftHeightAxisStyle();
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        DiscreteColorLegendStyle tempOverlayLegendStyle = this.getOverlayLegendStyle();
        tempLabelStyle = tempOverlayLegendStyle.getLabelStyle();
        tempValueStyle = tempOverlayLegendStyle.getValueStyle();
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
    }

    public AxisStyle getColumnAxisStyle() {
        AxisStyle columnAxisStyle = new AxisStyle();
        columnAxisStyle.axisStyle = this.overlay.getColumnLegendStyle();
        columnAxisStyle.addPropertyChangeListener(this);
        return columnAxisStyle;
    }

    public void setColumnAxisStyle(AxisStyle columnAxisStyle) {
        if (columnAxisStyle == null || Util.equal((Object)columnAxisStyle.axisStyle, (Object)this.overlay.getColumnLegendStyle())) {
            return;
        }
        AxisStyle oldValue = new AxisStyle();
        oldValue.axisStyle = this.overlay.getColumnLegendStyle();
        this.overlay.setColumnLegendStyle(columnAxisStyle.axisStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("columnAxisStyle", oldValue, columnAxisStyle);
    }

    public IndependentVariable getGroupVariable() {
        IndependentVariable aVariable;
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getGroupVariable();
        if (v == null) {
            aVariable = null;
        } else {
            aVariable = new IndependentVariable();
            aVariable.setIndependentVariable(v);
            aVariable.addPropertyChangeListener(this);
        }
        return aVariable;
    }

    public void setGroupVariable(IndependentVariable aVariable) {
        IndependentVariable oldValue;
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getGroupVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new IndependentVariable();
            oldValue.setIndependentVariable(v);
        }
        if (aVariable == null) {
            this.overlay.setGroupVariable(null);
        } else {
            if (Util.equal((Object)aVariable.getVariable(), (Object)this.overlay.getGroupVariable())) {
                return;
            }
            this.overlay.setGroupVariable(aVariable.getIndependentVariable());
            this.setSummaryVariable("Group", aVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("groupVariable", oldValue, aVariable);
    }

    public AxisStyle getGroupAxisStyle() {
        AxisStyle aAxisStyle = new AxisStyle();
        aAxisStyle.axisStyle = this.overlay.getGroupLegendStyle();
        aAxisStyle.addPropertyChangeListener(this);
        return aAxisStyle;
    }

    public void setGroupAxisStyle(AxisStyle aAxisStyle) {
        if (aAxisStyle == null || Util.equal((Object)aAxisStyle.axisStyle, (Object)this.overlay.getGroupLegendStyle())) {
            return;
        }
        AxisStyle oldValue = new AxisStyle();
        oldValue.axisStyle = this.overlay.getGroupLegendStyle();
        this.overlay.setGroupLegendStyle(aAxisStyle.axisStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("groupAxisStyle", oldValue, aAxisStyle);
    }

    public OverlayHeightVariable getHeightVariable(int index) {
        DependentVariable2[] v = this.overlay.getHeightVariables();
        if (v == null || v.length < index) {
            return null;
        }
        int len = v.length;
        OverlayHeightVariable heightVariable = new OverlayHeightVariable();
        heightVariable.setDependentVariable(v[index]);
        heightVariable.addPropertyChangeListener(this);
        return heightVariable;
    }

    protected void removeHeightVariable(int index) {
        int i;
        int len;
        DependentVariable2[] v = this.overlay.getHeightVariables();
        int n = len = v == null ? 0 : v.length;
        if (index < 0 || index > len) {
            return;
        }
        DependentVariable2[] v2 = new DependentVariable2[len - 1];
        for (i = 0; i < index; ++i) {
            v2[i] = v[i];
        }
        for (i = index + 1; i < len; ++i) {
            v2[i - 1] = v[i];
        }
        this.overlay.setHeightVariables(v2);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("heightVariables", null, v2);
    }

    public OverlayHeightVariable[] getHeightVariables() {
        OverlayHeightVariable[] heightVariables;
        DependentVariable2[] v = this.overlay.getHeightVariables();
        if (v == null) {
            heightVariables = null;
        } else {
            int len = v.length;
            heightVariables = new OverlayHeightVariable[len];
            for (int i = 0; i < len; ++i) {
                heightVariables[i] = new OverlayHeightVariable();
                heightVariables[i].setDependentVariable(v[i]);
                heightVariables[i].addPropertyChangeListener(this);
            }
        }
        return heightVariables;
    }

    public void setHeightVariables(OverlayHeightVariable[] heightVariables) {
        ++count;
        if (heightVariables == null) {
            this.overlay.setHeightVariables(null);
        } else {
            int len = heightVariables.length;
            DependentVariable2[] v = new DependentVariable2[len];
            for (int i = 0; i < len; ++i) {
                v[i] = heightVariables[i].getDependentVariable2();
                if (i == 0 && heightVariables[0] != null) {
                    this.setSummaryVariable("Response", heightVariables[0].getName());
                    continue;
                }
                if (i != 1 || heightVariables[1] == null) continue;
                this.setSummaryVariable("ResponseColor", heightVariables[1].getName());
            }
            this.overlay.setHeightVariables(v);
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("heightVariables", null, heightVariables);
    }

    public void addHeightVariable(OverlayHeightVariable heightVariable) {
        if (heightVariable == null) {
            return;
        }
        DependentVariable2[] v = this.overlay.getHeightVariables();
        int len = v != null ? v.length : 0;
        DependentVariable2[] v2 = new DependentVariable2[len + 1];
        for (int i = 0; i < len; ++i) {
            v2[i] = v[i].getDependentVariable2();
        }
        v2[len] = heightVariable.getDependentVariable2();
        if (len == 0) {
            this.setSummaryVariable("Response", heightVariable.getName());
        } else if (len == 1) {
            this.setSummaryVariable("ResponseColor", heightVariable.getName());
        }
        this.overlay.setHeightVariables(v2);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("heightVariables", null, v2);
    }

    public OverlayHeightVariable getHeightVariable(String name) {
        String[] names = this.overlay.getHeightVariablesName(this.isDesignTime());
        int index = -1;
        boolean found = false;
        if (names != null) {
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                if (!name.equals(names[i])) continue;
                index = i;
                found = true;
                break;
            }
        }
        OverlayHeightVariable variable = null;
        if (found) {
            DependentVariable2[] v = this.overlay.getHeightVariables();
            variable = new OverlayHeightVariable();
            variable.setDependentVariable(v[index]);
            variable.addPropertyChangeListener(this);
        }
        return variable;
    }

    public void addHeightVariable(String name) {
        if (name == null) {
            return;
        }
        String[] names = this.overlay.getHeightVariablesName(this.isDesignTime());
        int len = names == null ? 0 : names.length;
        for (int i = 0; i < len; ++i) {
            if (!name.equals(names[i])) continue;
            return;
        }
        DependentVariable2[] v = this.overlay.getHeightVariables();
        DependentVariable2[] v2 = new DependentVariable2[len + 1];
        boolean segment = false;
        int segVal = OverlayChartTypes.SEGMENTEDBAR.getValue();
        for (int i = 0; i < len; ++i) {
            if (v[i].getChartType() == segVal) {
                segment = true;
            }
            v2[i] = v[i];
        }
        v2[len] = new DependentVariable2();
        v2[len].setName(name);
        if (!segment) {
            v2[len].setChartType(segVal);
        }
        if (len == 0) {
            this.setSummaryVariable("Response", name);
        } else if (len == 1) {
            this.setSummaryVariable("ResponseColor", name);
        }
        this.overlay.setHeightVariables(v2);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("heightVariables", null, v2);
    }

    public void removeHeightVariable(String name) {
        DependentVariable2[] v2;
        if (name == null) {
            return;
        }
        String[] names = this.overlay.getHeightVariablesName(this.isDesignTime());
        int len = names == null ? 0 : names.length;
        int index = -1;
        boolean found = false;
        for (int i = 0; i < len; ++i) {
            if (!name.equals(names[i])) continue;
            index = i;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        DependentVariable2[] v = this.overlay.getHeightVariables();
        if (len <= 1) {
            v2 = null;
        } else {
            int i;
            v2 = new DependentVariable2[len - 1];
            for (i = 0; i < index; ++i) {
                v2[i] = v[i];
            }
            for (i = index + 1; i < len; ++i) {
                v2[i - 1] = v[i];
            }
        }
        this.overlay.setHeightVariables(v2);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("heightVariables", null, v2);
    }

    public AxisStyle getLeftHeightAxisStyle() {
        AxisStyle heightAxisStyle = new AxisStyle();
        heightAxisStyle.axisStyle = this.overlay.getHeightLegendStyle();
        heightAxisStyle.addPropertyChangeListener(this);
        return heightAxisStyle;
    }

    public void setLeftHeightAxisStyle(AxisStyle heightAxisStyle) {
        if (heightAxisStyle == null || Util.equal((Object)heightAxisStyle.axisStyle, (Object)this.overlay.getHeightLegendStyle())) {
            return;
        }
        AxisStyle oldValue = new AxisStyle();
        oldValue.axisStyle = this.overlay.getHeightLegendStyle();
        this.overlay.setHeightLegendStyle(heightAxisStyle.axisStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("leftHeightAxisStyle", oldValue, heightAxisStyle);
    }

    public AxisStyle getRightHeightAxisStyle() {
        AxisStyle heightAxisStyle = new AxisStyle();
        heightAxisStyle.axisStyle = this.overlay.getHeightLegendStyle2();
        heightAxisStyle.addPropertyChangeListener(this);
        return heightAxisStyle;
    }

    public void setRightHeightAxisStyle(AxisStyle heightAxisStyle) {
        if (heightAxisStyle == null || Util.equal((Object)heightAxisStyle.axisStyle, (Object)this.overlay.getHeightLegendStyle2())) {
            return;
        }
        AxisStyle oldValue = new AxisStyle();
        oldValue.axisStyle = this.overlay.getHeightLegendStyle2();
        this.overlay.setHeightLegendStyle2(heightAxisStyle.axisStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("rlghtHeightAxisStyle", oldValue, heightAxisStyle);
    }

    public IndependentVariable getSubGroupVariable() {
        IndependentVariable subgroupVariable;
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getSubGroupVariable();
        if (v == null) {
            subgroupVariable = null;
        } else {
            subgroupVariable = new IndependentVariable();
            subgroupVariable.setIndependentVariable(v);
            subgroupVariable.addPropertyChangeListener(this);
        }
        return subgroupVariable;
    }

    public void setSubGroupVariable(IndependentVariable subgroupVariable) {
        IndependentVariable oldValue;
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getSubGroupVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new IndependentVariable();
            oldValue.setIndependentVariable(v);
        }
        if (subgroupVariable == null) {
            this.overlay.setSubGroupVariable(null);
        } else {
            if (Util.equal((Object)subgroupVariable.getVariable(), (Object)this.overlay.getSubGroupVariable())) {
                return;
            }
            this.overlay.setSubGroupVariable(subgroupVariable.getIndependentVariable());
            this.setSummaryVariable("SubGroup", subgroupVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("subgroupVariable", oldValue, subgroupVariable);
    }

    public DiscreteColorLegendStyle getOverlayLegendStyle() {
        DiscreteColorLegendStyle overlayLegendStyle = new DiscreteColorLegendStyle();
        overlayLegendStyle.setLegendStyle(this.overlay.getOverlayLegendStyle());
        overlayLegendStyle.addPropertyChangeListener(this);
        return overlayLegendStyle;
    }

    public void setOverlayLegendStyle(DiscreteColorLegendStyle aLegendStyle) {
        if (aLegendStyle == null || Util.equal((Object)aLegendStyle.getLegendStyle(), (Object)this.overlay.getOverlayLegendStyle())) {
            return;
        }
        DiscreteColorLegendStyle oldValue = new DiscreteColorLegendStyle();
        oldValue.setLegendStyle(this.overlay.getOverlayLegendStyle());
        this.overlay.setOverlayLegendStyle(aLegendStyle.getLegendStyle());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("overlayLegendStyle", oldValue, aLegendStyle);
    }

    public double getMarkerSize() {
        return this.overlay.getMarkerSize();
    }

    public void setMarkerSize(double markerSize) {
        double oldValue = this.getMarkerSize();
        if (markerSize == oldValue) {
            return;
        }
        if (markerSize < 0.0 || markerSize > 1.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "markerSize.ex.txt"));
        }
        this.overlay.setMarkerSize(markerSize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("markerSize", new Double(oldValue), new Double(markerSize));
    }

    public double getLineSize() {
        return this.overlay.getLineSize();
    }

    public void setLineSize(double lineSize) {
        double oldValue = this.getLineSize();
        if (lineSize == oldValue) {
            return;
        }
        if (lineSize < 0.0 || lineSize > 1.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "joinSize.ex.txt"));
        }
        this.overlay.setLineSize(lineSize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("lineSize", new Double(oldValue), new Double(lineSize));
    }

    public String getLeftUserHeightLabel() {
        return this.overlay.getLeftUserHeightLabel();
    }

    public void setLeftUserHeightLabel(String heightLabel) {
        String oldValue = this.getLeftUserHeightLabel();
        if (heightLabel == null && oldValue == null) {
            return;
        }
        if (heightLabel != null && heightLabel.equals(oldValue)) {
            return;
        }
        this.overlay.setLeftUserHeightLabel(heightLabel);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("leftUserHeightLabel", oldValue, heightLabel);
    }

    public String getRightUserHeightLabel() {
        return this.overlay.getRightUserHeightLabel();
    }

    public void setRightUserHeightLabel(String heightLabel) {
        String oldValue = this.getRightUserHeightLabel();
        if (heightLabel == null && oldValue == null) {
            return;
        }
        if (heightLabel != null && heightLabel.equals(oldValue)) {
            return;
        }
        this.overlay.setRightUserHeightLabel(heightLabel);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("rightUserHeightLabel", oldValue, heightLabel);
    }

    public boolean isAbsoluteSize() {
        return this.overlay.isAbsoluteSize();
    }

    public void setAbsoluteSize(boolean absolute) {
        boolean oldValue = this.isAbsoluteSize();
        if (absolute == oldValue) {
            return;
        }
        this.overlay.setAbsoluteSize(absolute);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteSize", new Boolean(oldValue), new Boolean(absolute));
    }

    public int getAbsoluteJoinSize() {
        return this.overlay.getAbsoluteJoinSize();
    }

    public void setAbsoluteJoinSize(int joinSize) {
        int oldValue = this.getAbsoluteJoinSize();
        if (joinSize == oldValue) {
            return;
        }
        if (joinSize <= 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "absJoinSize.ex.txt"));
        }
        this.overlay.setAbsoluteJoinSize(joinSize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteJoinSize", new Integer(oldValue), new Integer(joinSize));
    }

    public int getAbsoluteMarkerSize() {
        return this.overlay.getAbsoluteMarkerSize();
    }

    public void setAbsoluteMarkerSize(int size) {
        int oldValue = this.getAbsoluteMarkerSize();
        if (size == this.overlay.getAbsoluteMarkerSize()) {
            return;
        }
        if (size <= 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "absMarkerSize.ex.txt"));
        }
        this.overlay.setAbsoluteMarkerSize(size);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteMarkerSize", new Integer(oldValue), new Integer(size));
    }

    public boolean isBackplaneVisible() {
        return this.overlay.isBackplaneVisible();
    }

    public void setBackplaneVisible(boolean visible) {
        boolean oldValue = this.isBackplaneVisible();
        if (visible == oldValue) {
            return;
        }
        this.overlay.setBackplaneVisible(visible);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("backplaneVisible", new Boolean(oldValue), new Boolean(visible));
    }

    public boolean isSubsetDataMode() {
        return this.overlay.isSubsetDataMode();
    }

    public void setSubsetDataMode(boolean mode) {
        boolean oldValue = this.isSubsetDataMode();
        if (mode == oldValue) {
            return;
        }
        this.overlay.setSubsetDataMode(mode);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("subsetDataMode", new Boolean(oldValue), new Boolean(mode));
    }

    public Color getBackplaneColor() {
        return this.overlay.getBackplaneColor();
    }

    public void setBackplaneColor(Color backplaneColorIn) {
        Color oldValue = this.getBackplaneColor();
        if (Util.equal((Object)backplaneColorIn, (Object)oldValue)) {
            return;
        }
        this.overlay.setBackplaneColor(backplaneColorIn);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("backplaneColor", oldValue, backplaneColorIn);
    }

    public String getClickedColumn(boolean formatted) {
        return this.overlay.getClickedColumn(formatted);
    }

    public String getClickedHeight(boolean formatted) {
        return this.overlay.getClickedHeight(formatted);
    }

    public String getClickedGroup(boolean formatted) {
        return this.overlay.getClickedGroup(formatted);
    }

    public String getClickedSubGroup(boolean formatted) {
        return this.overlay.getClickedSubGroup(formatted);
    }

    @Override
    public String getCategoryVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setCategoryVariableName(String name) {
        String oldValue = this.getCategoryVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.overlay.setColumnVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Category", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("categoryVariableName", oldValue, name);
    }

    @Override
    public String getXVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setXVariableName(String name) {
        String oldValue = this.getXVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.overlay.setColumnVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Category", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("XVariableName", oldValue, name);
    }

    @Override
    public String getResponseVariableName() {
        DependentVariable2[] v = this.overlay.getHeightVariables();
        if (v == null || v[0] == null) {
            return null;
        }
        return v[0].getName();
    }

    @Override
    public void setResponseVariableName(String name) {
        String oldValue = this.getResponseVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        DependentVariable2[] v = this.overlay.getHeightVariables();
        if (v == null) {
            v = new DependentVariable2[]{new DependentVariable2()};
            v[0].setName(name);
            this.overlay.setHeightVariables(v);
        } else if (v[0] == null) {
            v[0] = new DependentVariable2();
            v[0].setName(name);
        } else {
            v[0].setName(name);
        }
        this.setSummaryVariable("Response", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("responseVariableName", oldValue, name);
    }

    @Override
    public String getResponse2VariableName() {
        DependentVariable2[] v = this.overlay.getHeightVariables();
        if (v == null || v.length < 2 || v[1] == null) {
            return null;
        }
        return v[1].getName();
    }

    @Override
    public void setResponse2VariableName(String name) {
        String oldValue = this.getResponse2VariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        DependentVariable2[] v = this.overlay.getHeightVariables();
        if (v == null) {
            v = new DependentVariable2[2];
            v[1] = new DependentVariable2();
            v[1].setName(name);
            this.overlay.setHeightVariables(v);
        } else if (v.length < 2 || v[1] == null) {
            DependentVariable2[] v2 = new DependentVariable2[]{v[0], new DependentVariable2()};
            v2[1].setName(name);
            this.overlay.setHeightVariables(v2);
        } else {
            v[1].setName(name);
        }
        this.setSummaryVariable("Response2", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("response2VariableName", oldValue, name);
    }

    public String[] getAllResponseVariablesName(boolean all) {
        String[] names = null;
        if (all) {
            names = this.overlay.getHeightVariablesName(this.isDesignTime());
        } else {
            DependentVariable2[] v = this.overlay.getHeightVariables();
            int len = 0;
            if (v != null) {
                len = v.length;
            }
            if (len == 0) {
                names = new String[]{""};
            } else {
                names = new String[len];
                for (int i = 0; i < len; ++i) {
                    names[i] = v[i] == null ? "" : v[i].getName();
                }
            }
        }
        return names;
    }

    public void setAllResponseVariablesName(String[] name) {
        if (Util.equal((Object)name, (Object)this.getAllResponseVariablesName(false))) {
            return;
        }
        int len = name.length;
        DependentVariable2[] v = new DependentVariable2[len];
        for (int i = 0; i < len; ++i) {
            v[i] = new DependentVariable2();
            v[i].setName(name[i]);
        }
        this.overlay.setHeightVariables(v);
        this.setSummaryVariable("AllResponses", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("allResponseVariableName", null, name);
    }

    public void setAllResponseVariablesName(String[] name, int[] scale) {
        if (Util.equal((Object)name, (Object)this.getAllResponseVariablesName(false))) {
            return;
        }
        if (name.length != scale.length) {
            return;
        }
        int len = name.length;
        DependentVariable2[] v = new DependentVariable2[len];
        for (int i = 0; i < len; ++i) {
            v[i] = new DependentVariable2();
            v[i].setName(name[i]);
            v[i].setChartScale(scale[i]);
        }
        this.overlay.setHeightVariables(v);
        this.setSummaryVariable("AllResponses", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("allResponseVariableName", null, name);
    }

    public void setAllResponseVariablesName(String[] name, int[] scale, int[] chartType) {
        if (Util.equal((Object)name, (Object)this.getAllResponseVariablesName(false))) {
            return;
        }
        if (name.length != scale.length) {
            return;
        }
        if (name.length != chartType.length) {
            return;
        }
        int len = name.length;
        DependentVariable2[] v = new DependentVariable2[len];
        for (int i = 0; i < len; ++i) {
            v[i] = new DependentVariable2();
            v[i].setName(name[i]);
            v[i].setChartType(chartType[i]);
            v[i].setChartScale(scale[i]);
        }
        this.overlay.setHeightVariables(v);
        this.setSummaryVariable("AllResponses", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("allResponseVariableName", null, name);
    }

    protected int readjustHeight(int maxHeight) {
        return this.overlay.readjustHeight(maxHeight);
    }

    protected void setSummaryVariable(String role, String[] name) {
        if (!this.isDesignTime()) {
            return;
        }
        ModelInterface model = this.getModelInterface();
        if (model instanceof SummaryInterface) {
            SummaryInterface summary = (SummaryInterface)model;
            int len = name.length;
            summary.setResponseName(name[0]);
            if (len > 1) {
                summary.setResponseColorName(name[1]);
            }
        }
    }

    @Override
    public String getGroupVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getGroupVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setGroupVariableName(String name) {
        String oldValue = this.getGroupVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getGroupVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.overlay.setGroupVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Group", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("groupVariableName", oldValue, name);
    }

    @Override
    public String getSubGroupVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getSubGroupVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setSubGroupVariableName(String name) {
        String oldValue = this.getSubGroupVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getSubGroupVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.overlay.setSubGroupVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("SubGroup", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("subgroupVariableName", oldValue, name);
    }

    @Override
    protected void resetNoneVariables() {
        DependentVariable2[] heightVariables;
        com.sas.graphics.util.visualize.IndependentVariable variable = this.overlay.getColumnVariable();
        if (variable != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.overlay.getSubGroupVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.overlay.getGroupVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((heightVariables = this.overlay.getHeightVariables()) != null) {
            for (int i = 0; i < heightVariables.length; ++i) {
                if (heightVariables[i] == null || heightVariables[i].isAutomatic() || heightVariables[i].getName() != null) continue;
                heightVariables[i].setIndex(-1);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Combination clone = (Combination)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.initialize();
            clone.setTitle(this.getTitle());
            clone.setTitleStyle(this.getTitleStyle());
            clone.setDepth(this.getDepth());
            clone.setMapColors(this.getMapColors());
            clone.setBackground(this.getBackground());
            clone.setBackgroundImage(this.getBackgroundImage());
            clone.setTransparent(this.isTransparent());
            clone.setOutlineColor(this.getOutlineColor());
            clone.setDataTipStyle(this.getDataTipStyle());
            clone.setResolution(this.getResolution());
            clone.setDatatipDoubleBuffered(this.isDatatipDoubleBuffered());
            clone.setMaxObservations(this.getMaxObservations());
            clone.setDisplayChartType(this.isDisplayChartType());
            clone.setShowStatistic(this.isShowStatistic());
            clone.setHidePopupMenu(this.isHidePopupMenu());
            clone.setPopupColumnInfoUsed(this.getPopupColumnInfoUsed());
            clone.setSwanStyleData(this.isSwanStyleData());
            clone.setBackplaneVisible(this.isBackplaneVisible());
            clone.setBackplaneColor(this.getBackplaneColor());
            clone.setFakeHeight(this.isFakeHeight());
            clone.setColumnVariable(this.getColumnVariable());
            clone.setColumnAxisStyle(this.getColumnAxisStyle());
            clone.setHeightVariables(this.getHeightVariables());
            clone.setLeftHeightAxisStyle(this.getLeftHeightAxisStyle());
            clone.setRightHeightAxisStyle(this.getRightHeightAxisStyle());
            clone.setSubGroupVariable(this.getSubGroupVariable());
            clone.setOverlayLegendStyle(this.getOverlayLegendStyle());
            clone.setGroupVariable(this.getGroupVariable());
            clone.setGroupAxisStyle(this.getGroupAxisStyle());
            clone.setMarkerSize(this.getMarkerSize());
            clone.setLineSize(this.getLineSize());
            clone.setLeftAxisMappedValue(this.getLeftAxisMappedValue());
            clone.setRightAxisMappedValue(this.getRightAxisMappedValue());
            clone.setAbsoluteSize(this.isAbsoluteSize());
            clone.setAbsoluteMarkerSize(this.getAbsoluteMarkerSize());
            clone.setAbsoluteJoinSize(this.getAbsoluteJoinSize());
            clone.setLeftUserHeightLabel(this.getLeftUserHeightLabel());
            clone.setRightUserHeightLabel(this.getRightUserHeightLabel());
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    private void setSampleColumnLabels() {
        String name = this.getCategoryVariableName();
        if (name != null && !name.trim().equals("")) {
            this.sample.setColumnLabel(1, name);
        } else {
            this.sample.setColumnLabel(1, RB.getStringResource(RB_KEY, "designTime.categoryLabel.txt"));
        }
        name = this.getSubGroupVariableName();
        if (name != null && !name.trim().equals("")) {
            this.sample.setColumnLabel(3, name);
        } else {
            this.sample.setColumnLabel(3, RB.getStringResource(RB_KEY, "designTime.subgroupLabel.txt"));
        }
        name = this.getGroupVariableName();
        if (name != null && !name.trim().equals("")) {
            this.sample.setColumnLabel(4, name);
        } else {
            this.sample.setColumnLabel(4, RB.getStringResource(RB_KEY, "designTime.groupLabel.txt"));
        }
        OverlayHeightVariable[] hv = this.getHeightVariables();
        int len = 4;
        int[] index = new int[]{2, 5, 6, 7};
        String[] labels = new String[]{RB.getStringResource(RB_KEY, "designTime.overlay1Label.txt"), RB.getStringResource(RB_KEY, "designTime.overlay2Label.txt"), RB.getStringResource(RB_KEY, "designTime.overlay3Label.txt"), RB.getStringResource(RB_KEY, "designTime.overlay4Label.txt")};
        if (hv == null) {
            for (int i = 0; i < len; ++i) {
                this.sample.setColumnLabel(index[i], labels[i]);
            }
        } else {
            len = Math.min(4, hv.length);
            for (int i = 0; i < len; ++i) {
                name = hv[i].getName();
                if (name != null && !name.trim().equals("")) {
                    this.sample.setColumnLabel(index[i], name);
                    continue;
                }
                this.sample.setColumnLabel(index[i], labels[i]);
            }
        }
    }

    public int getLeftAxisMappedValue() {
        return this.overlay.getLeftHeightAxis();
    }

    public void setLeftAxisMappedValue(int axis) {
        int oldValue = this.getLeftAxisMappedValue();
        if (axis == oldValue) {
            return;
        }
        this.overlay.setLeftHeightAxis(axis);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("leftAxisMappedValue", new Integer(oldValue), new Integer(axis));
    }

    public int getRightAxisMappedValue() {
        return this.overlay.getRightHeightAxis();
    }

    public void setRightAxisMappedValue(int axis) {
        int oldValue = this.getRightAxisMappedValue();
        if (axis == oldValue) {
            return;
        }
        this.overlay.setRightHeightAxis(axis);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("rightAxisMappedValue", new Integer(oldValue), new Integer(axis));
    }

    protected boolean isSegmentChart() {
        return this.overlay.isSegmentChart();
    }

    private boolean isFakeHeight() {
        return this.overlay.isFakeHeight();
    }

    private void setFakeHeight(boolean flag) {
        this.overlay.setFakeHeight(flag);
    }

    public void setColumnValueHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isColumnValueHotspotsEnabled();
        this.overlay.setColumnValueHotspotsEnabled(newValue);
        newValue = this.isColumnValueHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("columnValueHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public boolean isColumnValueHotspotsEnabled() {
        return this.overlay.isColumnValueHotspotsEnabled();
    }

    public Blob[] getColumnValueHotspots() {
        return this.overlay.getColumnValueHotspots();
    }

    public void setGroupValueHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isGroupValueHotspotsEnabled();
        this.overlay.setGroupValueHotspotsEnabled(newValue);
        newValue = this.isGroupValueHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("groupValueHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public boolean isGroupValueHotspotsEnabled() {
        return this.overlay.isGroupValueHotspotsEnabled();
    }

    public Blob[] getGroupValueHotspots() {
        return this.overlay.getGroupValueHotspots();
    }

    public void setSubGroupValueHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isSubGroupValueHotspotsEnabled();
        this.overlay.setSubGroupValueHotspotsEnabled(newValue);
        newValue = this.isSubGroupValueHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("subGroupValueHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public boolean isSubGroupValueHotspotsEnabled() {
        return this.overlay.isSubGroupValueHotspotsEnabled();
    }

    public Blob[] getSubGroupValueHotspots() {
        return this.overlay.getSubGroupValueHotspots();
    }

    @Override
    public void setVariableHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isVariableHotspotsEnabled();
        this.overlay.setVariableHotspotsEnabled(newValue);
        newValue = this.isVariableHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("variableHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    @Override
    public boolean isVariableHotspotsEnabled() {
        return this.overlay.isVariableHotspotsEnabled();
    }

    @Override
    public Blob[] getVariableHotspots() {
        return this.overlay.getVariableHotspots();
    }
}

