/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.ContinuousColorLegendStyle;
import com.sas.graphics.chart.DependentVariable;
import com.sas.graphics.chart.DiscreteColorLegendStyle;
import com.sas.graphics.chart.IndependentVariable;
import com.sas.graphics.chart.LegendStyle;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.RowColumn;
import com.sas.graphics.chart.TextStyle;
import com.sas.graphics.chart.Variable;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ColorCityscape;
import com.sas.util.Util;
import java.awt.Font;
import java.beans.PropertyChangeEvent;

public abstract class Color
extends RowColumn {
    static final long serialVersionUID = 6289097028819701960L;
    public static final String RB_KEY = "Color.";
    protected ColorCityscape colorCityscape;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "colorVariable"}, {"Short description", RB.getStringResource(RB_KEY, "colorVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "colorVariable.pd.txt")}}, {{"Name", "colorLegendStyle"}, {"Short description", RB.getStringResource(RB_KEY, "colorLegendStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "colorLegendStyle.pd.txt")}}, {{"Name", "groupVariable"}, {"Hidden", "true"}}, {{"Name", "groupLegendStyle"}, {"Hidden", "true"}}, {{"Name", "groupValueHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "groupValueHotspots"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Variable variable;
        String propertyName = pce.getPropertyName();
        if (propertyName == null) {
            return;
        }
        Object source = pce.getSource();
        if (source instanceof ContinuousColorLegendStyle) {
            LegendStyle legend = (LegendStyle)source;
            if (Util.equal((Object)legend.legendStyle, (Object)this.colorCityscape.getColorLegendStyle())) {
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("colorLegendStyle", null, source);
            }
        } else if (source instanceof DiscreteColorLegendStyle) {
            LegendStyle legend = (LegendStyle)source;
            if (Util.equal((Object)legend.legendStyle, (Object)this.colorCityscape.getGroupLegendStyle())) {
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("groupLegendStyle", null, source);
            }
        } else if (source instanceof DependentVariable) {
            Variable variable2 = (Variable)source;
            if (Util.equal((Object)variable2.getVariable(), (Object)this.colorCityscape.getColorVariable())) {
                this.setSummaryVariable("ResponseColor", variable2.getName());
                this.updateViewer(UPDATE_ALL);
                this.firePropertyChange("colorVariable", null, source);
            }
        } else if (source instanceof IndependentVariable && Util.equal((Object)(variable = (Variable)source).getVariable(), (Object)this.colorCityscape.getGroupVariable())) {
            this.setSummaryVariable("Group", variable.getName());
            this.updateViewer(UPDATE_ALL);
            this.firePropertyChange("groupVariable", null, source);
        }
        super.propertyChange(pce);
    }

    public DependentVariable getColorVariable() {
        DependentVariable colorVariable;
        com.sas.graphics.util.visualize.DependentVariable v = this.colorCityscape.getColorVariable();
        if (v == null) {
            colorVariable = null;
        } else {
            colorVariable = new DependentVariable();
            colorVariable.setDependentVariable(v);
            colorVariable.addPropertyChangeListener(this);
        }
        return colorVariable;
    }

    public void setColorVariable(DependentVariable colorVariable) {
        DependentVariable oldValue;
        com.sas.graphics.util.visualize.DependentVariable v = this.colorCityscape.getColorVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new DependentVariable();
            oldValue.setDependentVariable(v);
        }
        if (colorVariable == null) {
            this.colorCityscape.setColorVariable(null);
        } else {
            if (Util.equal((Object)colorVariable.getVariable(), (Object)this.colorCityscape.getColorVariable())) {
                return;
            }
            this.colorCityscape.setColorVariable(colorVariable.getDependentVariable());
            this.setSummaryVariable("ResponseColor", colorVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("colorVariable", oldValue, colorVariable);
    }

    public ContinuousColorLegendStyle getColorLegendStyle() {
        ContinuousColorLegendStyle colorLegendStyle = new ContinuousColorLegendStyle();
        colorLegendStyle.setLegendStyle(this.colorCityscape.getColorLegendStyle());
        colorLegendStyle.addPropertyChangeListener(this);
        return colorLegendStyle;
    }

    @Override
    public void setForegroundColor(java.awt.Color newColor) {
        if (newColor == null || newColor == this.getForeground()) {
            return;
        }
        super.setForegroundColor(newColor);
        ContinuousColorLegendStyle tempColorLegendStyle = this.getColorLegendStyle();
        TextStyle tempLabelStyle = tempColorLegendStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        TextStyle tempValueStyle = tempColorLegendStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
        DiscreteColorLegendStyle tempGroupLegendStyle = this.getGroupLegendStyle();
        tempLabelStyle = tempGroupLegendStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        tempValueStyle = tempGroupLegendStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (newFont == null) {
            return;
        }
        boolean isBold = newFont.isBold();
        boolean isItalic = newFont.isItalic();
        String fontFamily = newFont.getFamily();
        int dotPlace = fontFamily.indexOf(".");
        if (dotPlace != -1) {
            fontFamily = fontFamily.substring(0, dotPlace);
        }
        ContinuousColorLegendStyle tempColorLegendStyle = this.getColorLegendStyle();
        TextStyle tempLabelStyle = tempColorLegendStyle.getLabelStyle();
        TextStyle tempValueStyle = tempColorLegendStyle.getValueStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        DiscreteColorLegendStyle tempGroupLegendStyle = this.getGroupLegendStyle();
        tempLabelStyle = tempGroupLegendStyle.getLabelStyle();
        tempValueStyle = tempGroupLegendStyle.getValueStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
    }

    public void setColorLegendStyle(ContinuousColorLegendStyle colorLegendStyle) {
        if (colorLegendStyle == null || Util.equal((Object)colorLegendStyle.getLegendStyle(), (Object)this.colorCityscape.getColorLegendStyle())) {
            return;
        }
        ContinuousColorLegendStyle oldValue = new ContinuousColorLegendStyle();
        oldValue.setLegendStyle(this.colorCityscape.getColorLegendStyle());
        this.colorCityscape.setColorLegendStyle(colorLegendStyle.getLegendStyle());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("colorLegendStyle", oldValue, colorLegendStyle);
    }

    public IndependentVariable getGroupVariable() {
        IndependentVariable groupVariable;
        com.sas.graphics.util.visualize.IndependentVariable v = this.colorCityscape.getGroupVariable();
        if (v == null) {
            groupVariable = null;
        } else {
            groupVariable = new IndependentVariable();
            groupVariable.setIndependentVariable(v);
            groupVariable.addPropertyChangeListener(this);
        }
        return groupVariable;
    }

    public void setGroupVariable(IndependentVariable groupVariable) {
        IndependentVariable oldValue;
        com.sas.graphics.util.visualize.IndependentVariable v = this.colorCityscape.getGroupVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new IndependentVariable();
            oldValue.setIndependentVariable(v);
        }
        if (groupVariable == null) {
            this.colorCityscape.setGroupVariable(null);
        } else {
            if (Util.equal((Object)groupVariable.getVariable(), (Object)this.colorCityscape.getGroupVariable())) {
                return;
            }
            this.colorCityscape.setGroupVariable(groupVariable.getIndependentVariable());
            this.setSummaryVariable("Group", groupVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("groupVariable", oldValue, groupVariable);
    }

    public DiscreteColorLegendStyle getGroupLegendStyle() {
        DiscreteColorLegendStyle groupLegendStyle = new DiscreteColorLegendStyle();
        groupLegendStyle.setLegendStyle(this.colorCityscape.getGroupLegendStyle());
        groupLegendStyle.addPropertyChangeListener(this);
        return groupLegendStyle;
    }

    public void setGroupLegendStyle(DiscreteColorLegendStyle groupLegendStyle) {
        if (groupLegendStyle == null || Util.equal((Object)groupLegendStyle.getLegendStyle(), (Object)this.colorCityscape.getGroupLegendStyle())) {
            return;
        }
        DiscreteColorLegendStyle oldValue = new DiscreteColorLegendStyle();
        oldValue.setLegendStyle(this.colorCityscape.getGroupLegendStyle());
        this.colorCityscape.setGroupLegendStyle(groupLegendStyle.getLegendStyle());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("groupLegendStyle", oldValue, groupLegendStyle);
    }

    public String getClickedRow(boolean formatted) {
        return this.colorCityscape.getClickedRow(formatted);
    }

    public String getClickedColumn(boolean formatted) {
        return this.colorCityscape.getClickedColumn(formatted);
    }

    public String getClickedHeight(boolean formatted) {
        return this.colorCityscape.getClickedHeight(formatted);
    }

    public String getClickedColor(boolean formatted) {
        return this.colorCityscape.getClickedColor(formatted);
    }

    public String getClickedGroup(boolean formatted) {
        return this.colorCityscape.getClickedGroup(formatted);
    }

    @Override
    public String getXVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.colorCityscape.getColumnVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setXVariableName(String name) {
        String oldValue = this.getXVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.colorCityscape.getColumnVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.colorCityscape.setColumnVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Category", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("XVariableName", oldValue, name);
    }

    @Override
    public String getZVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.colorCityscape.getRowVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setZVariableName(String name) {
        String oldValue = this.getZVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.colorCityscape.getRowVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.colorCityscape.setRowVariable(v);
        } else {
            v.setName(name);
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("ZVariableName", oldValue, name);
    }

    @Override
    public String getResponseColorVariableName() {
        com.sas.graphics.util.visualize.DependentVariable v = this.colorCityscape.getColorVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setResponseColorVariableName(String name) {
        String oldValue = this.getResponseColorVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.DependentVariable v = this.colorCityscape.getColorVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.DependentVariable();
            v.setName(name);
            this.colorCityscape.setColorVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("ResponseColor", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("responseColorVariableName", oldValue, name);
    }

    @Override
    public String getGroupVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.colorCityscape.getGroupVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setGroupVariableName(String name) {
        String oldValue = this.getGroupVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.colorCityscape.getGroupVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.colorCityscape.setGroupVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Group", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("GroupVariableName", oldValue, name);
    }

    public void setGroupValueHotspotsEnabled(boolean newValue) {
        boolean oldValue = this.isGroupValueHotspotsEnabled();
        this.cityscape.setGroupValueHotspotsEnabled(newValue);
        newValue = this.isGroupValueHotspotsEnabled();
        if (newValue != oldValue) {
            this.firePropertyChange("groupValueHotspotsEnabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public boolean isGroupValueHotspotsEnabled() {
        return this.cityscape.isGroupValueHotspotsEnabled();
    }

    public Blob[] getGroupValueHotspots() {
        return this.cityscape.getGroupValueHotspots();
    }
}

