/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.awt.util.Util;
import com.sas.graphics.chart.AxisStyle;
import com.sas.graphics.chart.AxisTypes;
import com.sas.graphics.chart.Combination;
import com.sas.graphics.chart.DataTipStyles;
import com.sas.graphics.chart.DepthTypes;
import com.sas.graphics.chart.DiscreteColorLegendStyle;
import com.sas.graphics.chart.IndependentVariable;
import com.sas.graphics.chart.MouseFrame;
import com.sas.graphics.chart.OverlayChartTypes;
import com.sas.graphics.chart.OverlayHeightVariable;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.StatisticTypes;
import com.sas.graphics.chart.Variable;
import com.sas.table.StaticColumnInfoInterface;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import com.sas.visuals.ColorDialog;
import com.sas.visuals.MessageBoxEvent;
import com.sas.visuals.MessageBoxListener;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ChartPopupMenu2
extends PopupMenu
implements ActionListener,
ItemListener,
MessageBoxListener {
    static final long serialVersionUID = -7368022237881325916L;
    public static final String RB_KEY = "ChartPopupMenu.";
    private transient Combination chart;
    protected MouseFrame mouseFrame = null;
    private transient Menu visuals;
    private transient Menu variables;
    private transient Menu colors;
    private transient Menu background;
    private transient ColorDialog backgroundColorDialog;
    private transient Menu backdrop;
    private transient ColorDialog backdropColorDialog;
    private transient Menu outline;
    private transient ColorDialog outlineColorDialog;
    private transient Menu legend;
    private transient Menu axis;
    private transient Menu mapping;
    private transient Menu depth;
    private transient Menu datatip;
    private transient Menu dataSubset;
    private transient Menu category;
    private transient Menu responses;
    private transient Menu group;
    private transient Menu subgroup;
    private transient MenuItem mouseHelp;
    private transient Menu add;
    private transient int maxItems;
    private transient int startVar;
    static final int CATEGORY_VARIABLE = 0;
    static final int RESPONSE_VARIABLES = 1;
    static final int HEIGHT_VARIABLES = 1;
    static final int GROUP_VARIABLE = 2;
    static final int SUBGROUP_VARIABLE = 3;
    static final int OVERLAY_LEGEND = 0;
    static final int HEIGHT_AXIS = 1;
    private transient boolean initialized;
    private transient OverlayHeightVariable curVar;

    private static String getString(String s) {
        return RB.getStringResource(RB_KEY, s + ".txt");
    }

    public ChartPopupMenu2(Combination chart) {
        super(ChartPopupMenu2.getString("title"));
        this.chart = chart;
        this.initialized = false;
        this.curVar = null;
        this.maxItems = 20;
    }

    protected void setChart(Combination chart) {
        this.chart = chart;
        this.initialized = false;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.removeAll();
        this.maxItems = 20;
        this.visuals = new Menu(ChartPopupMenu2.getString("visuals"));
        this.makeVisualsMenu(this.visuals);
        this.add(this.visuals);
        this.variables = new Menu(ChartPopupMenu2.getString("variables"));
        this.makeVariablesMenu(this.variables);
        this.add(this.variables);
        this.mouseHelp = new MenuItem(ChartPopupMenu2.getString("mouseHelp"));
        if (this.mouseHelp != null) {
            this.mouseHelp.setActionCommand("hp_Mouse");
            this.mouseHelp.addActionListener(this);
            this.add(this.mouseHelp);
        }
        this.initialized = true;
    }

    MenuItem[] getMainMenuItems() {
        MenuItem[] items = new MenuItem[]{this.visuals, this.variables, this.mouseHelp};
        return items;
    }

    public void update() {
    }

    @Override
    public void messageBoxButtonSelected(MessageBoxEvent e) {
        if (e.getButton() == 64) {
            return;
        }
        if (e.getSource() == this.backgroundColorDialog) {
            this.chart.setBackgroundColor(this.backgroundColorDialog.getSelectedColor());
        } else if (e.getSource() == this.backdropColorDialog) {
            Color dropColor = this.backdropColorDialog.getSelectedColor();
            this.chart.setBackplaneColor(dropColor);
        } else if (e.getSource() == this.outlineColorDialog) {
            this.chart.setOutlineColor(this.outlineColorDialog.getSelectedColor());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        MenuItem mi = (MenuItem)e.getSource();
        if (com.sas.util.Util.equal((Object)command, (Object)ChartPopupMenu2.getString("custom"))) {
            Frame frame = Util.getParentFrame(this.chart);
            if (frame == null) {
                frame = new Frame();
            }
            if (mi.getParent() == this.background) {
                if (this.backgroundColorDialog == null) {
                    this.backgroundColorDialog = new ColorDialog(frame);
                }
                this.backgroundColorDialog.addMessageBoxListener(this);
                this.backgroundColorDialog.pack();
                Util.centerOverWindow(this.backgroundColorDialog, frame);
                this.backgroundColorDialog.setVisible(true);
            } else if (mi.getParent() == this.backdrop) {
                if (this.backdropColorDialog == null) {
                    this.backdropColorDialog = new ColorDialog(frame);
                }
                this.backdropColorDialog.addMessageBoxListener(this);
                this.backdropColorDialog.pack();
                Util.centerOverWindow(this.backdropColorDialog, frame);
                this.backdropColorDialog.setVisible(true);
            } else if (mi.getParent() == this.outline) {
                if (this.outlineColorDialog == null) {
                    this.outlineColorDialog = new ColorDialog(frame);
                }
                this.outlineColorDialog.addMessageBoxListener(this);
                this.outlineColorDialog.pack();
                Util.centerOverWindow(this.outlineColorDialog, frame);
                this.outlineColorDialog.setVisible(true);
            }
        } else if (command.equalsIgnoreCase("hp_Mouse")) {
            String title = ChartPopupMenu2.getString("MouseFrame.Title");
            if (this.mouseFrame == null) {
                this.mouseFrame = new MouseFrame(title);
            }
            this.mouseFrame.show();
            this.mouseFrame.toFront();
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        MenuItem mi = (MenuItem)e.getSource();
        String item = (String)e.getItem();
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("custom"))) {
            Frame frame = Util.getParentFrame(this.chart);
            if (frame == null) {
                frame = new Frame();
            }
            if (mi.getParent() == this.background) {
                if (this.backgroundColorDialog == null) {
                    this.backgroundColorDialog = new ColorDialog(frame);
                }
                this.backgroundColorDialog.addMessageBoxListener(this);
                this.backgroundColorDialog.pack();
                Util.centerOverWindow(this.backgroundColorDialog, frame);
                this.backgroundColorDialog.setVisible(true);
            } else if (mi.getParent() == this.backdrop) {
                if (this.backdropColorDialog == null) {
                    this.backdropColorDialog = new ColorDialog(frame);
                }
                this.backdropColorDialog.addMessageBoxListener(this);
                this.backdropColorDialog.pack();
                Util.centerOverWindow(this.backdropColorDialog, frame);
                this.backdropColorDialog.setVisible(true);
            } else if (mi.getParent() == this.outline) {
                if (this.outlineColorDialog == null) {
                    this.outlineColorDialog = new ColorDialog(frame);
                }
                this.outlineColorDialog.addMessageBoxListener(this);
                this.outlineColorDialog.pack();
                Util.centerOverWindow(this.outlineColorDialog, frame);
                this.outlineColorDialog.setVisible(true);
            }
            this.updateColorsMenu();
            return;
        }
        MenuComponent comp = (MenuComponent)e.getSource();
        MenuContainer source = comp.getParent();
        if (source == this.background) {
            Color bkg = this.getSelectedColor(item);
            this.chart.setBackgroundColor(bkg);
            this.selectColorItem(this.background, bkg);
        } else if (source == this.backdrop) {
            Color drop = this.getSelectedColor(item);
            this.chart.setBackplaneColor(drop);
            this.selectColorItem(this.backdrop, drop);
        } else if (source == this.outline) {
            Color edge = this.getSelectedColor(item);
            this.chart.setOutlineColor(edge);
            this.selectColorItem(this.outline, edge);
        } else if (source == this.legend) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("on"))) {
                this.setLegendVisible(true);
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("off"))) {
                this.setLegendVisible(false);
            }
            this.selectMenuItem(this.legend, item);
        } else if (source == this.axis) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("on"))) {
                this.setAxisVisible(true);
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("off"))) {
                this.setAxisVisible(false);
            }
            this.selectMenuItem(this.axis, item);
        } else if (source == this.depth) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("twoD"))) {
                this.chart.setDepth(DepthTypes.get("TWO_DIMENSION"));
            } else {
                this.chart.setDepth(DepthTypes.get("TWO_AND_HALF_DIMENSION"));
            }
            this.selectMenuItem(this.depth, item);
        } else if (source == this.datatip) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("stationary"))) {
                this.chart.setDataTipStyle(DataTipStyles.get("STATIONARY"));
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("tracking"))) {
                this.chart.setDataTipStyle(DataTipStyles.get("TRACKING"));
            } else {
                this.chart.setDataTipStyle(DataTipStyles.get("NONE"));
            }
            this.selectMenuItem(this.datatip, item);
        } else if (source == this.dataSubset) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("enable"))) {
                this.chart.setSubsetDataMode(true);
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("disable"))) {
                this.chart.setSubsetDataMode(false);
            }
            this.selectMenuItem(this.dataSubset, item);
        } else if (source == this.add || ((Menu)source).getParent() == this.add) {
            if (comp instanceof CheckboxMenuItem) {
                if (((CheckboxMenuItem)comp).getState()) {
                    if (this.chart.getPopupColumnInfoUsed() == 1) {
                        this.chart.addHeightVariable(this.label2Name(item));
                    } else {
                        this.chart.addHeightVariable(item);
                    }
                } else if (this.responses.getItemCount() > 3) {
                    if (this.chart.getPopupColumnInfoUsed() == 1) {
                        this.chart.removeHeightVariable(this.label2Name(item));
                    } else {
                        this.chart.removeHeightVariable(item);
                    }
                } else {
                    ((CheckboxMenuItem)comp).setState(true);
                }
            }
        } else if (com.sas.util.Util.equal((Object)((Menu)source).getLabel(), (Object)ChartPopupMenu2.getString("statistic"))) {
            String name = ((Menu)((Menu)source).getParent()).getLabel();
            if (this.chart.getPopupColumnInfoUsed() == 1) {
                name = this.label2Name(name);
            }
            this.curVar = this.chart.getHeightVariable(name);
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("none"))) {
                this.setStatisticType("NONE");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("sum"))) {
                this.setStatisticType("SUM");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("mean"))) {
                this.setStatisticType("MEAN");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("freq"))) {
                this.setStatisticType("FREQ");
            }
            this.selectMenuItem((Menu)source, item);
        } else if (com.sas.util.Util.equal((Object)((Menu)source).getLabel(), (Object)ChartPopupMenu2.getString("combinationType"))) {
            String name = ((Menu)((Menu)source).getParent()).getLabel();
            if (this.chart.getPopupColumnInfoUsed() == 1) {
                name = this.label2Name(name);
            }
            this.curVar = this.chart.getHeightVariable(name);
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("scatter"))) {
                this.setOverlayType("SCATTER");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("lineScatter"))) {
                this.setOverlayType("LINESCATTER");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("line"))) {
                this.setOverlayType("LINE");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("segmentedBar"))) {
                this.setOverlayType("SEGMENTEDBAR");
            }
            this.selectMenuItem((Menu)source, item);
        } else if (com.sas.util.Util.equal((Object)((Menu)source).getLabel(), (Object)ChartPopupMenu2.getString("overlayHeightAxis"))) {
            String name = ((Menu)((Menu)source).getParent()).getLabel();
            if (this.chart.getPopupColumnInfoUsed() == 1) {
                name = this.label2Name(name);
            }
            this.curVar = this.chart.getHeightVariable(name);
            if (item.equals("1")) {
                this.setOverlayScale(1);
            } else if (item.equals("2")) {
                this.setOverlayScale(2);
            } else if (item.equals("3")) {
                this.setOverlayScale(3);
            } else if (item.equals("4")) {
                this.setOverlayScale(4);
            }
            this.selectMenuItem((Menu)source, item);
        } else if (com.sas.util.Util.equal((Object)((Menu)source).getLabel(), (Object)ChartPopupMenu2.getString("left"))) {
            if (item.equals("1")) {
                this.chart.setLeftAxisMappedValue(1);
            } else if (item.equals("2")) {
                this.chart.setLeftAxisMappedValue(2);
            } else if (item.equals("3")) {
                this.chart.setLeftAxisMappedValue(3);
            } else if (item.equals("4")) {
                this.chart.setLeftAxisMappedValue(4);
            }
            this.selectMenuItem((Menu)source, item);
        } else if (com.sas.util.Util.equal((Object)((Menu)source).getLabel(), (Object)ChartPopupMenu2.getString("right"))) {
            if (item.equals("1")) {
                this.chart.setRightAxisMappedValue(1);
            } else if (item.equals("2")) {
                this.chart.setRightAxisMappedValue(2);
            } else if (item.equals("3")) {
                this.chart.setRightAxisMappedValue(3);
            } else if (item.equals("4")) {
                this.chart.setRightAxisMappedValue(4);
            }
            this.selectMenuItem((Menu)source, item);
        } else if (source == this.category || ((Menu)source).getParent() == this.category) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("autoVar"))) {
                this.chart.getColumnVariable().setAutomatic(true);
            } else if (this.chart.getPopupColumnInfoUsed() == 1) {
                this.chart.getColumnVariable().setLabel(item);
            } else {
                this.chart.getColumnVariable().setName(item);
            }
            this.selectMenuItem(this.category, item);
        } else if (source == this.group || ((Menu)source).getParent() == this.group) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("noneVar"))) {
                this.nullVariable(2);
            } else if (this.chart.getPopupColumnInfoUsed() == 1) {
                this.chart.getGroupVariable().setLabel(item);
            } else {
                this.chart.getGroupVariable().setName(item);
            }
            this.selectMenuItem(this.group, item);
        } else if (source == this.subgroup || ((Menu)source).getParent() == this.subgroup) {
            IndependentVariable iv = this.chart.getSubGroupVariable();
            if (iv == null) {
                iv = new IndependentVariable();
                this.chart.setSubGroupVariable(iv);
            }
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("noneVar"))) {
                iv.setAutomatic(false);
                iv.setIndex(-1);
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("autoVar"))) {
                iv.setAutomatic(true);
            } else if (this.chart.getPopupColumnInfoUsed() == 1) {
                iv.setLabel(item);
            } else {
                iv.setName(item);
            }
            this.selectMenuItem(this.subgroup, item);
        }
    }

    private void selectMenuItem(Menu mu, String item) {
        for (int i = 0; i < mu.getItemCount(); ++i) {
            if (mu.getItem(i) instanceof CheckboxMenuItem) {
                CheckboxMenuItem c = (CheckboxMenuItem)mu.getItem(i);
                if (!com.sas.util.Util.equal((Object)c.getLabel(), (Object)item)) {
                    c.setState(false);
                    continue;
                }
                c.setState(true);
                continue;
            }
            if (!(mu.getItem(i) instanceof Menu)) continue;
            Menu m = (Menu)mu.getItem(i);
            this.selectMenuItem(m, item);
        }
    }

    private void makeVisualsMenu(Menu visuals) {
        if (this.chart == null) {
            return;
        }
        this.colors = new Menu(ChartPopupMenu2.getString("colors"));
        this.makeColorsMenu(this.colors);
        visuals.add(this.colors);
        this.legend = new Menu(ChartPopupMenu2.getString("overlayLegend"));
        this.makeLegendMenu(this.legend);
        visuals.add(this.legend);
        this.axis = new Menu(ChartPopupMenu2.getString("overlayHeightAxis"));
        this.makeLegendMenu(this.axis);
        visuals.add(this.axis);
        this.mapping = new Menu(ChartPopupMenu2.getString("heightAxis"));
        this.makeMappingMenu(this.mapping);
        visuals.add(this.mapping);
        this.depth = new Menu(ChartPopupMenu2.getString("depth"));
        this.makeDepthMenu(this.depth);
        visuals.add(this.depth);
        this.datatip = new Menu(ChartPopupMenu2.getString("datatip"));
        this.makeDatatipMenu(this.datatip);
        visuals.add(this.datatip);
        this.dataSubset = new Menu(ChartPopupMenu2.getString("dataSubset"));
        this.makeDataSubsetMenu(this.dataSubset);
        visuals.add(this.dataSubset);
        this.updateVisualsMenu();
    }

    private void makeDependentVariableMenu(Menu menu) {
        Menu statistic = new Menu(ChartPopupMenu2.getString("statistic"));
        this.makeStatisticMenu(statistic);
        this.selectMenuItem(statistic, ChartPopupMenu2.getString("sum"));
        menu.add(statistic);
        Menu overlayType = new Menu(ChartPopupMenu2.getString("combinationType"));
        this.makeOverlayTypeMenu(overlayType);
        menu.add(overlayType);
        Menu chartScale = new Menu(ChartPopupMenu2.getString("overlayHeightAxis"));
        this.makeChartScaleMenu(chartScale);
        this.selectMenuItem(chartScale, "1");
        menu.add(chartScale);
    }

    private void makeVariablesMenu(Menu variables) {
        if (this.chart == null || !this.chart.visualization.validData()) {
            return;
        }
        String name = null;
        this.category = new Menu(ChartPopupMenu2.getString("category"));
        this.makeListMenu(this.category, false, true, true);
        variables.add(this.category);
        this.responses = new Menu(ChartPopupMenu2.getString("response"));
        this.makeResponseMenu(this.responses);
        variables.add(this.responses);
        this.group = new Menu(ChartPopupMenu2.getString("group"));
        this.makeListMenu(this.group, false, false, false);
        variables.add(this.group);
        this.subgroup = new Menu(ChartPopupMenu2.getString("subgroup"));
        this.makeListMenu(this.subgroup, false, false, true);
        variables.add(this.subgroup);
        int count = this.responses.getItemCount();
        for (int i = 2; i < count; ++i) {
            Menu menu = (Menu)this.responses.getItem(i);
            name = menu.getLabel();
            if (this.chart.getPopupColumnInfoUsed() == 1) {
                name = this.label2Name(name);
            }
            this.curVar = this.chart.getHeightVariable(name);
            if (this.curVar == null) continue;
            Menu menu1 = (Menu)menu.getItem(0);
            this.updateStatisticMenu(menu1);
            menu1 = (Menu)menu.getItem(1);
            this.updateOverlayTypeMenu(menu1);
            menu1 = (Menu)menu.getItem(2);
            this.updateChartScaleMenu(menu1);
        }
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        IndependentVariable col = this.chart.getColumnVariable();
        name = this.getVariableName(col, columnInfoUsed);
        if (col.isAutomatic()) {
            name = ChartPopupMenu2.getString("autoVar");
        }
        this.selectMenuItem(this.category, name);
        name = this.getVariableName(this.chart.getGroupVariable(), columnInfoUsed);
        this.selectMenuItem(this.group, name);
        if (name == null) {
            name = ChartPopupMenu2.getString("noneVar");
        }
        this.selectMenuItem(this.group, name);
        IndependentVariable sub = this.chart.getSubGroupVariable();
        name = this.getVariableName(sub, columnInfoUsed);
        if (sub.isAutomatic()) {
            name = ChartPopupMenu2.getString("autoVar");
        } else if (name == null) {
            name = ChartPopupMenu2.getString("noneVar");
        }
        this.selectMenuItem(this.subgroup, name);
    }

    private void makeResponseMenu(Menu menu) {
        StaticTableInterface rd = this.chart.visualization.getRectangularData();
        if (rd == null) {
            return;
        }
        this.add = new Menu(ChartPopupMenu2.getString("addRemove"));
        menu.add(this.add);
        menu.addSeparator();
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        try {
            int cols = rd.getColumnCount();
            int maxVars = 0;
            for (int i = 0; i < cols; ++i) {
                Class colType = ((StaticRowTemplateTableInterface)rd).getColumnClass(i + 1);
                if (colType == String.class) continue;
                ++maxVars;
            }
            if (maxVars <= this.maxItems) {
                this.startVar = 0;
                this.makeEditMenu(this.add, menu);
            } else {
                int numLists = (int)((double)maxVars / (double)this.maxItems);
                if (maxVars % this.maxItems > 0) {
                    ++numLists;
                }
                String label = ChartPopupMenu2.getString("list");
                this.startVar = 0;
                for (int i = 1; i <= numLists; ++i) {
                    String menuLabel = label + " " + i;
                    Menu list = new Menu(menuLabel);
                    this.makeEditMenu(list, menu);
                    this.add.add(list);
                }
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    private void makeEditMenu(Menu editMenu, Menu responseMenu) {
        StaticTableInterface rd = this.chart.visualization.getRectangularData();
        if (rd == null) {
            return;
        }
        String[] names = null;
        int len = 0;
        if (this.chart != null) {
            names = this.chart.getAllResponseVariablesName(true);
            len = names != null ? names.length : 0;
        }
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        try {
            int i;
            int cols = rd.getColumnCount();
            int items = 0;
            for (i = this.startVar; i < cols && items < this.maxItems; ++i) {
                String name;
                Class colType = ((StaticRowTemplateTableInterface)rd).getColumnClass(i + 1);
                if (colType == String.class) continue;
                if (rd instanceof StaticColumnInfoInterface) {
                    StaticColumnInfoInterface info = (StaticColumnInfoInterface)rd;
                    String[] columnInfoNames = info.getColumnInfoNames();
                    if (columnInfoUsed == 1 && columnInfoNames.length > 1) {
                        name = (String)info.getColumnInfo(i + 1, columnInfoNames[1]);
                        if (name == null || name.trim().equals("")) {
                            name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                        }
                    } else {
                        name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                    }
                } else {
                    name = (String)((StaticColumnLabelInterface)rd).getColumnLabel(i + 1);
                }
                int index = -1;
                String str = columnInfoUsed == 1 ? this.label2Name(name) : name;
                for (int j = 0; j < len; ++j) {
                    if (!str.equals(names[j])) continue;
                    index = j;
                    break;
                }
                CheckboxMenuItem cb = new CheckboxMenuItem(name);
                cb.addItemListener(this);
                editMenu.add(cb);
                ++items;
                if (index == -1) {
                    cb.setState(false);
                    continue;
                }
                cb.setState(true);
                Menu menu1 = new Menu(name);
                this.makeDependentVariableMenu(menu1);
                responseMenu.add(menu1);
            }
            this.startVar = i;
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    private void makeColorsMenu(Menu menu) {
        this.background = new Menu(ChartPopupMenu2.getString("background"));
        this.makeStandardColorMenu(this.background, true, true);
        menu.add(this.background);
        this.backdrop = new Menu(ChartPopupMenu2.getString("backdrop"));
        this.makeStandardColorMenu(this.backdrop, false, true);
        menu.add(this.backdrop);
        this.outline = new Menu(ChartPopupMenu2.getString("outline"));
        this.makeStandardColorMenu(this.outline, false, true);
        menu.add(this.outline);
    }

    private void makeStandardColorMenu(Menu menu, boolean transparent, boolean custom) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu2.getString("black"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("blue"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("cyan"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("darkGray"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("gray"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("green"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("lightGray"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("magenta"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("orange"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("pink"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("red"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("white"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("yellow"));
        cb.addItemListener(this);
        menu.add(cb);
        if (custom) {
            CheckboxMenuItem mi = new CheckboxMenuItem(ChartPopupMenu2.getString("custom"));
            mi.addActionListener(this);
            mi.addItemListener(this);
            menu.add(mi);
        }
    }

    private void makeLegendMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu2.getString("on"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("off"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeMappingMenu(Menu menu) {
        Menu left = new Menu(ChartPopupMenu2.getString("left"));
        this.makeChartScaleMenu(left);
        menu.add(left);
        Menu right = new Menu(ChartPopupMenu2.getString("right"));
        this.makeChartScaleMenu(right);
        menu.add(right);
    }

    private void makeDatatipMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu2.getString("stationary"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("tracking"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("none"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeDepthMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu2.getString("twoD"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("threeD"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeStatisticMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu2.getString("none"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("sum"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("mean"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("freq"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeOverlayTypeMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu2.getString("scatter"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("lineScatter"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("line"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("segmentedBar"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeChartScaleMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem("1");
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem("2");
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem("3");
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem("4");
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeDataSubsetMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu2.getString("enable"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu2.getString("disable"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeVariableMenu(Menu menu, boolean numericalOnly, boolean required, boolean automatic) {
        StaticTableInterface rd = this.chart.visualization.getRectangularData();
        if (rd == null) {
            return;
        }
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        int items = 0;
        try {
            CheckboxMenuItem cb;
            if (!required && this.startVar == 0) {
                cb = new CheckboxMenuItem(ChartPopupMenu2.getString("noneVar"));
                cb.addItemListener(this);
                menu.add(cb);
                ++items;
            }
            if (automatic && this.startVar == 0) {
                cb = new CheckboxMenuItem(ChartPopupMenu2.getString("autoVar"));
                cb.addItemListener(this);
                menu.add(cb);
                ++items;
            }
            int cols = rd.getColumnCount();
            if (numericalOnly) {
                int i;
                for (i = this.startVar; i < cols && items < this.maxItems; ++i) {
                    String name;
                    Class colType = ((StaticRowTemplateTableInterface)rd).getColumnClass(i + 1);
                    if (colType == String.class) continue;
                    if (rd instanceof StaticColumnInfoInterface) {
                        StaticColumnInfoInterface info = (StaticColumnInfoInterface)rd;
                        String[] columnInfoNames = info.getColumnInfoNames();
                        if (columnInfoUsed == 1 && columnInfoNames.length > 1) {
                            name = (String)info.getColumnInfo(i + 1, columnInfoNames[1]);
                            if (name == null || name.trim().equals("")) {
                                name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                            }
                        } else {
                            name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                        }
                    } else {
                        name = (String)((StaticColumnLabelInterface)rd).getColumnLabel(i + 1);
                    }
                    cb = new CheckboxMenuItem(name);
                    cb.addItemListener(this);
                    menu.add(cb);
                    ++items;
                }
                this.startVar = i;
            } else {
                int i;
                for (i = this.startVar; i < cols && items < this.maxItems; ++items, ++i) {
                    String name;
                    if (rd instanceof StaticColumnInfoInterface) {
                        StaticColumnInfoInterface info = (StaticColumnInfoInterface)rd;
                        String[] columnInfoNames = info.getColumnInfoNames();
                        if (columnInfoUsed == 1 && columnInfoNames.length > 1) {
                            name = (String)info.getColumnInfo(i + 1, columnInfoNames[1]);
                            if (name == null || name.trim().equals("")) {
                                name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                            }
                        } else {
                            name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                        }
                    } else {
                        name = (String)((StaticColumnLabelInterface)rd).getColumnLabel(i + 1);
                    }
                    cb = new CheckboxMenuItem(name);
                    cb.addItemListener(this);
                    menu.add(cb);
                }
                this.startVar = i;
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    public void updateVariablesMenu() {
        if (this.variables != null) {
            this.variables.removeAll();
            this.makeVariablesMenu(this.variables);
        }
    }

    public void updateVisualsMenu() {
        this.updateColorsMenu();
        this.updateLegendMenu();
        this.updateAxisMenu();
        this.updateMappingMenu();
        this.updateDepthMenu();
        this.updateDatatipMenu();
        this.updateDataSubsetMenu();
    }

    private void updateColorsMenu() {
        this.selectColorItem(this.background, this.chart.getBackgroundColor());
        this.selectColorItem(this.backdrop, this.chart.getBackplaneColor());
        this.selectColorItem(this.outline, this.chart.getOutlineColor());
    }

    private void selectColorItem(Menu menu, Color color) {
        if (menu == null || color == null) {
            return;
        }
        if (this.equalRGB(color, Color.black)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("black"));
        } else if (this.equalRGB(color, Color.blue)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("blue"));
        } else if (this.equalRGB(color, Color.cyan)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("cyan"));
        } else if (this.equalRGB(color, Color.darkGray)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("darkGray"));
        } else if (this.equalRGB(color, Color.gray)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("gray"));
        } else if (this.equalRGB(color, Color.green)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("green"));
        } else if (this.equalRGB(color, Color.lightGray)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("lightGray"));
        } else if (this.equalRGB(color, Color.magenta)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("magenta"));
        } else if (this.equalRGB(color, Color.orange)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("orange"));
        } else if (this.equalRGB(color, Color.pink)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("pink"));
        } else if (this.equalRGB(color, Color.red)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("red"));
        } else if (this.equalRGB(color, Color.white)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("white"));
        } else if (this.equalRGB(color, Color.yellow)) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("yellow"));
        } else {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("custom"));
        }
    }

    private Color getSelectedColor(String item) {
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("black"))) {
            return Color.black;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("blue"))) {
            return Color.blue;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("cyan"))) {
            return Color.cyan;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("darkGray"))) {
            return Color.darkGray;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("gray"))) {
            return Color.gray;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("green"))) {
            return Color.green;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("lightGray"))) {
            return Color.lightGray;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("magenta"))) {
            return Color.magenta;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("orange"))) {
            return Color.orange;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("pink"))) {
            return Color.pink;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("red"))) {
            return Color.red;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("white"))) {
            return Color.white;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu2.getString("yellow"))) {
            return Color.yellow;
        }
        return null;
    }

    private void updateLegendMenu() {
        if (this.legend == null) {
            return;
        }
        DiscreteColorLegendStyle legendStyle = null;
        legendStyle = this.chart.getOverlayLegendStyle();
        if (legendStyle.isVisible()) {
            this.selectMenuItem(this.legend, ChartPopupMenu2.getString("on"));
        } else {
            this.selectMenuItem(this.legend, ChartPopupMenu2.getString("off"));
        }
    }

    private void updateAxisMenu() {
        if (this.axis == null) {
            return;
        }
        AxisStyle axisStyle = null;
        axisStyle = this.chart.getLeftHeightAxisStyle();
        if (axisStyle.getAxisType() == AxisTypes.NONE) {
            this.selectMenuItem(this.axis, ChartPopupMenu2.getString("off"));
        } else {
            this.selectMenuItem(this.axis, ChartPopupMenu2.getString("on"));
        }
    }

    private void updateMappingMenu() {
        CheckboxMenuItem c;
        int i;
        if (this.mapping == null) {
            return;
        }
        int index = this.chart.getLeftAxisMappedValue();
        Menu menu = (Menu)this.mapping.getItem(0);
        int itemCount = menu.getItemCount();
        for (i = 0; i < itemCount; ++i) {
            c = (CheckboxMenuItem)menu.getItem(i);
            if (i == index - 1) {
                c.setState(true);
                continue;
            }
            c.setState(false);
        }
        index = this.chart.getRightAxisMappedValue();
        menu = (Menu)this.mapping.getItem(1);
        itemCount = menu.getItemCount();
        for (i = 0; i < itemCount; ++i) {
            c = (CheckboxMenuItem)menu.getItem(i);
            if (i == index - 1) {
                c.setState(true);
                continue;
            }
            c.setState(false);
        }
    }

    private void updateDepthMenu() {
        if (this.depth == null) {
            return;
        }
        DepthTypes type = this.chart.getDepth();
        if (type.toString().equals("TWO_DIMENSION")) {
            this.selectMenuItem(this.depth, ChartPopupMenu2.getString("twoD"));
        } else {
            this.selectMenuItem(this.depth, ChartPopupMenu2.getString("threeD"));
        }
    }

    private void updateDatatipMenu() {
        if (this.datatip == null) {
            return;
        }
        DataTipStyles style = this.chart.getDataTipStyle();
        if (style.toString().equals("STATIONARY")) {
            this.selectMenuItem(this.datatip, ChartPopupMenu2.getString("stationary"));
        } else if (style.toString().equals("TRACKING")) {
            this.selectMenuItem(this.datatip, ChartPopupMenu2.getString("tracking"));
        } else {
            this.selectMenuItem(this.datatip, ChartPopupMenu2.getString("none"));
        }
    }

    private void updateStatisticMenu(Menu menu) {
        if (this.curVar == null) {
            return;
        }
        StatisticTypes type = this.curVar.getStatistic();
        String statistic = type.toString();
        if (statistic.equals("NONE")) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("none"));
        } else if (statistic.equals("FREQ")) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("freq"));
        } else if (statistic.equals("MEAN")) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("mean"));
        } else {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("sum"));
        }
    }

    private void updateOverlayTypeMenu(Menu menu) {
        if (this.curVar == null) {
            return;
        }
        boolean segValid = false;
        OverlayChartTypes type = this.curVar.getOverlayType();
        if (type.toString().equals("SEGMENTEDBAR")) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("segmentedBar"));
            segValid = true;
        } else if (type.toString().equals("LINE")) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("line"));
        } else if (type.toString().equals("LINESCATTER")) {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("lineScatter"));
        } else {
            this.selectMenuItem(menu, ChartPopupMenu2.getString("scatter"));
        }
        menu.getItem(3).setEnabled(segValid |= !this.chart.isSegmentChart());
    }

    private void updateChartScaleMenu(Menu menu) {
        if (this.curVar == null) {
            return;
        }
        int type = this.curVar.getOverlayAxis();
        if (String.valueOf(type).equals("1")) {
            this.selectMenuItem(menu, "1");
        } else if (String.valueOf(type).equals("2")) {
            this.selectMenuItem(menu, "2");
        } else if (String.valueOf(type).equals("3")) {
            this.selectMenuItem(menu, "3");
        } else if (String.valueOf(type).equals("4")) {
            this.selectMenuItem(menu, "4");
        }
    }

    private void updateDataSubsetMenu() {
        if (this.dataSubset == null) {
            return;
        }
        if (this.chart.isSubsetDataMode()) {
            this.selectMenuItem(this.dataSubset, ChartPopupMenu2.getString("enable"));
        } else {
            this.selectMenuItem(this.dataSubset, ChartPopupMenu2.getString("disable"));
        }
    }

    private void setLegendVisible(boolean visible) {
        DiscreteColorLegendStyle legendStyle = null;
        legendStyle = this.chart.getOverlayLegendStyle();
        if (legendStyle != null) {
            legendStyle.setVisible(visible);
        }
    }

    private void setAxisVisible(boolean visible) {
        AxisStyle axisStyle = null;
        axisStyle = this.chart.getLeftHeightAxisStyle();
        if (axisStyle != null) {
            AxisTypes types = visible ? AxisTypes.LINE : AxisTypes.NONE;
            axisStyle.setAxisType(types);
        }
    }

    private void setStatisticType(String enumString) {
        if (this.curVar == null) {
            return;
        }
        this.curVar.setStatistic(StatisticTypes.get(enumString));
    }

    private void setOverlayType(String enumString) {
        if (this.curVar == null) {
            return;
        }
        this.curVar.setOverlayType(OverlayChartTypes.get(enumString));
    }

    private void setOverlayScale(int scale) {
        if (this.curVar == null) {
            return;
        }
        this.curVar.setOverlayAxis(scale);
    }

    private void nullVariable(int role) {
        if (role == 2) {
            this.chart.setGroupVariable(null);
        } else if (role == 3) {
            this.chart.setSubGroupVariable(null);
        } else if (role == 1) {
            this.chart.setHeightVariables(null);
        }
    }

    protected String getVariableName(Variable v, int columnInfoUsed) {
        if (v == null) {
            return null;
        }
        if (v.getName() != null) {
            if (columnInfoUsed == 0) {
                return v.getName();
            }
            String label = v.getLabel();
            if (label != null && !label.trim().equals("")) {
                return label;
            }
            return v.getName();
        }
        try {
            StaticTableInterface rd = this.chart.visualization.getRectangularData();
            if (rd == null) {
                return null;
            }
            if (v.getIndex() > 0) {
                if (rd instanceof StaticColumnInfoInterface) {
                    StaticColumnInfoInterface info = (StaticColumnInfoInterface)rd;
                    String[] columnInfoNames = info.getColumnInfoNames();
                    if (columnInfoUsed == 1 && columnInfoNames.length > 1) {
                        String label = (String)info.getColumnInfo(v.getIndex(), columnInfoNames[1]);
                        if (label != null && !label.trim().equals("")) {
                            return label;
                        }
                        return (String)info.getColumnInfo(v.getIndex(), columnInfoNames[0]);
                    }
                    return (String)info.getColumnInfo(v.getIndex(), columnInfoNames[0]);
                }
                return (String)((StaticColumnLabelInterface)rd).getColumnLabel(v.getIndex());
            }
            return null;
        }
        catch (TableException tableException) {
            return null;
        }
    }

    private boolean equalRGB(Color c1, Color c2) {
        return c1.getRed() == c2.getRed() && c1.getGreen() == c2.getGreen() && c1.getBlue() == c2.getBlue();
    }

    private String label2Name(String label) {
        try {
            StaticTableInterface rd = this.chart.visualization.getRectangularData();
            if (rd == null || label == null || label.trim().equals("")) {
                return null;
            }
            if (rd instanceof StaticColumnInfoInterface) {
                StaticColumnInfoInterface info = (StaticColumnInfoInterface)rd;
                String[] columnInfoNames = info.getColumnInfoNames();
                if (columnInfoNames.length == 1) {
                    return label;
                }
                for (int i = 0; i < rd.getColumnCount(); ++i) {
                    String str = (String)info.getColumnInfo(i + 1, columnInfoNames[1]);
                    if (!com.sas.util.Util.equal((Object)str, (Object)label)) continue;
                    return (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                }
                return label;
            }
            return label;
        }
        catch (TableException tableException) {
            return label;
        }
    }

    private void makeListMenu(Menu menu, boolean numericalOnly, boolean required, boolean automatic) {
        StaticTableInterface rd = this.chart.visualization.getRectangularData();
        if (rd == null) {
            return;
        }
        int maxVars = 0;
        try {
            int cols = rd.getColumnCount();
            if (!required) {
                ++maxVars;
            }
            if (automatic) {
                ++maxVars;
            }
            if (numericalOnly) {
                for (int i = 0; i < cols; ++i) {
                    Class colType = ((StaticRowTemplateTableInterface)rd).getColumnClass(i + 1);
                    if (colType == String.class) continue;
                    ++maxVars;
                }
            } else {
                maxVars += cols;
            }
            if (maxVars <= this.maxItems) {
                this.startVar = 0;
                this.makeVariableMenu(menu, numericalOnly, required, automatic);
            } else {
                int numLists = (int)((double)maxVars / (double)this.maxItems);
                if (maxVars % this.maxItems > 0) {
                    ++numLists;
                }
                String label = ChartPopupMenu2.getString("list");
                this.startVar = 0;
                for (int i = 1; i <= numLists; ++i) {
                    String menuLabel = label + " " + i;
                    Menu list = new Menu(menuLabel);
                    this.makeVariableMenu(list, numericalOnly, required, automatic);
                    menu.add(list);
                }
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }
}

