/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.awt.util.Util;
import com.sas.graphics.chart.Bar;
import com.sas.graphics.chart.BarGeometryTypes;
import com.sas.graphics.chart.Chart;
import com.sas.graphics.chart.ColorLegendStyle;
import com.sas.graphics.chart.DataTipStyles;
import com.sas.graphics.chart.DepthTypes;
import com.sas.graphics.chart.DiscreteColorLegendStyle;
import com.sas.graphics.chart.Group;
import com.sas.graphics.chart.IndependentVariable;
import com.sas.graphics.chart.JoinTypes;
import com.sas.graphics.chart.MarkerGeometryTypes;
import com.sas.graphics.chart.MouseFrame;
import com.sas.graphics.chart.Overlay;
import com.sas.graphics.chart.OverlayTypes;
import com.sas.graphics.chart.Pie;
import com.sas.graphics.chart.PieLabelTypes;
import com.sas.graphics.chart.PieOthersModes;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.RowColumn;
import com.sas.graphics.chart.Scatter;
import com.sas.graphics.chart.SegmentedBar;
import com.sas.graphics.chart.Variable;
import com.sas.mdtable.MdTo2dTable;
import com.sas.table.StaticColumnInfoInterface;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import com.sas.visuals.ColorDialog;
import com.sas.visuals.MessageBoxEvent;
import com.sas.visuals.MessageBoxListener;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ChartPopupMenu
extends PopupMenu
implements ActionListener,
ItemListener,
MessageBoxListener {
    static final long serialVersionUID = -8840539627841363239L;
    public static final String RB_KEY = "ChartPopupMenu.";
    private transient Chart chart;
    private transient Menu visuals;
    private transient Menu variables;
    private transient Menu colors;
    private transient Menu background;
    private transient ColorDialog backgroundColorDialog;
    private transient Menu backdrop;
    private transient ColorDialog backdropColorDialog;
    private transient Menu outline;
    private transient ColorDialog outlineColorDialog;
    private transient Menu legend;
    private transient Menu depth;
    private transient Menu datatip;
    private transient Menu orientation;
    private transient Menu shape;
    private transient Menu marker;
    private transient Menu join;
    private transient Menu overlayType;
    private transient Menu others;
    private transient Menu pieLabel;
    private transient Menu dataSubset;
    private transient Menu category;
    private transient Menu response;
    private transient Menu group;
    private transient Menu subgroup;
    private transient Menu category2;
    private transient Menu responseColor;
    private transient Menu responseHeight;
    private transient Menu response2;
    private transient MenuItem mouseHelp;
    private transient int maxItems;
    private transient int startVar;
    protected MouseFrame mouseFrame = null;
    private transient int chartType;
    static final int BAR_CHART = 0;
    static final int SEGMENTED_BAR_CHART = 1;
    static final int PIE_CHART = 2;
    static final int SCATTER_CHART = 3;
    static final int OVERLAY_CHART = 4;
    static final int CATEGORY_VARIABLE = 0;
    static final int RESPONSE_VARIABLE = 1;
    static final int GROUP_VARIABLE = 2;
    static final int SUBGROUP_VARIABLE = 3;
    static final int RESPONSE_COLOR_VARIABLE = 4;
    static final int RESPONSE_2_VARIABLE = 5;
    static final int CATEGORY_2_VARIABLE = 6;
    static final int RESPONSE_HEIGHT_VARIABLE = 7;
    private transient boolean initialized;

    private static String getString(String s) {
        return RB.getStringResource(RB_KEY, s + ".txt");
    }

    public ChartPopupMenu(Chart chart) {
        super(ChartPopupMenu.getString("title"));
        this.chart = chart;
        this.chartType = chart instanceof Bar ? 0 : (chart instanceof SegmentedBar ? 1 : (chart instanceof Pie ? 2 : (chart instanceof Scatter ? 3 : 4)));
        this.initialized = false;
        this.maxItems = 20;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.removeAll();
        this.maxItems = 20;
        this.visuals = new Menu(ChartPopupMenu.getString("visuals"));
        this.makeVisualsMenu(this.visuals);
        this.add(this.visuals);
        this.variables = new Menu(ChartPopupMenu.getString("variables"));
        this.makeVariablesMenu(this.variables);
        this.add(this.variables);
        this.mouseHelp = new MenuItem(ChartPopupMenu.getString("mouseHelp"));
        if (this.mouseHelp != null) {
            this.mouseHelp.setActionCommand("hp_Mouse");
            this.mouseHelp.addActionListener(this);
            this.add(this.mouseHelp);
        }
        this.initialized = true;
    }

    protected void setChart(Chart chart) {
        this.chart = chart;
        this.chartType = chart instanceof Bar ? 0 : (chart instanceof SegmentedBar ? 1 : (chart instanceof Pie ? 2 : (chart instanceof Scatter ? 3 : 4)));
        this.initialized = false;
    }

    MenuItem[] getMainMenuItems() {
        MenuItem[] items = new MenuItem[]{this.visuals, this.variables, this.mouseHelp};
        return items;
    }

    public void update() {
    }

    @Override
    public void messageBoxButtonSelected(MessageBoxEvent e) {
        if (e.getButton() == 64) {
            return;
        }
        if (e.getSource() == this.backgroundColorDialog) {
            this.chart.setBackgroundColor(this.backgroundColorDialog.getSelectedColor());
        } else if (e.getSource() == this.backdropColorDialog) {
            Color dropColor = this.backdropColorDialog.getSelectedColor();
            switch (this.chartType) {
                case 0: 
                case 1: 
                case 3: {
                    RowColumn rowcol = (RowColumn)this.chart;
                    rowcol.setBackplaneColor(dropColor);
                    break;
                }
                case 4: {
                    Overlay overlay = (Overlay)this.chart;
                    overlay.setBackplaneColor(dropColor);
                    break;
                }
            }
        } else if (e.getSource() == this.outlineColorDialog) {
            this.chart.setOutlineColor(this.outlineColorDialog.getSelectedColor());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        MenuItem mi = (MenuItem)e.getSource();
        if (com.sas.util.Util.equal((Object)command, (Object)ChartPopupMenu.getString("custom"))) {
            Frame frame = Util.getParentFrame(this.chart);
            if (frame == null) {
                frame = new Frame();
            }
            if (mi.getParent() == this.background) {
                if (this.backgroundColorDialog == null) {
                    this.backgroundColorDialog = new ColorDialog(frame);
                }
                this.backgroundColorDialog.addMessageBoxListener(this);
                this.backgroundColorDialog.pack();
                Util.centerOverWindow(this.backgroundColorDialog, frame);
                this.backgroundColorDialog.setVisible(true);
            } else if (mi.getParent() == this.backdrop) {
                if (this.backdropColorDialog == null) {
                    this.backdropColorDialog = new ColorDialog(frame);
                }
                this.backdropColorDialog.addMessageBoxListener(this);
                this.backdropColorDialog.pack();
                Util.centerOverWindow(this.backdropColorDialog, frame);
                this.backdropColorDialog.setVisible(true);
            } else if (mi.getParent() == this.outline) {
                if (this.outlineColorDialog == null) {
                    this.outlineColorDialog = new ColorDialog(frame);
                }
                this.outlineColorDialog.addMessageBoxListener(this);
                this.outlineColorDialog.pack();
                Util.centerOverWindow(this.outlineColorDialog, frame);
                this.outlineColorDialog.setVisible(true);
            }
        } else if (command.equalsIgnoreCase("hp_Mouse")) {
            String title = ChartPopupMenu.getString("MouseFrame.Title");
            if (this.mouseFrame == null) {
                this.mouseFrame = new MouseFrame(title);
            }
            this.mouseFrame.show();
            this.mouseFrame.toFront();
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        MenuItem mi = (MenuItem)e.getSource();
        String item = (String)e.getItem();
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("custom"))) {
            Frame frame = Util.getParentFrame(this.chart);
            if (frame == null) {
                frame = new Frame();
            }
            if (mi.getParent() == this.background) {
                if (this.backgroundColorDialog == null) {
                    this.backgroundColorDialog = new ColorDialog(frame);
                }
                this.backgroundColorDialog.addMessageBoxListener(this);
                this.backgroundColorDialog.pack();
                Util.centerOverWindow(this.backgroundColorDialog, frame);
                this.backgroundColorDialog.setVisible(true);
            } else if (mi.getParent() == this.backdrop) {
                if (this.backdropColorDialog == null) {
                    this.backdropColorDialog = new ColorDialog(frame);
                }
                this.backdropColorDialog.addMessageBoxListener(this);
                this.backdropColorDialog.pack();
                Util.centerOverWindow(this.backdropColorDialog, frame);
                this.backdropColorDialog.setVisible(true);
            } else if (mi.getParent() == this.outline) {
                if (this.outlineColorDialog == null) {
                    this.outlineColorDialog = new ColorDialog(frame);
                }
                this.outlineColorDialog.addMessageBoxListener(this);
                this.outlineColorDialog.pack();
                Util.centerOverWindow(this.outlineColorDialog, frame);
                this.outlineColorDialog.setVisible(true);
            }
            this.updateColorsMenu();
            return;
        }
        MenuComponent comp = (MenuComponent)e.getSource();
        MenuContainer source = comp.getParent();
        if (source == this.background) {
            Color bkg = this.getSelectedColor(item);
            this.chart.setBackgroundColor(bkg);
            this.selectColorItem(this.background, bkg);
        } else if (source == this.backdrop) {
            Color drop = this.getSelectedColor(item);
            switch (this.chartType) {
                case 0: 
                case 1: 
                case 3: {
                    RowColumn rowcol = (RowColumn)this.chart;
                    rowcol.setBackplaneColor(drop);
                    break;
                }
                case 4: {
                    Overlay overlay = (Overlay)this.chart;
                    overlay.setBackplaneColor(drop);
                    break;
                }
            }
            this.selectColorItem(this.backdrop, drop);
        } else if (source == this.outline) {
            Color edge = this.getSelectedColor(item);
            this.chart.setOutlineColor(edge);
            this.selectColorItem(this.outline, edge);
        } else if (source == this.legend) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("on"))) {
                this.setLegendVisible(true);
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("off"))) {
                this.setLegendVisible(false);
            }
            this.selectMenuItem(this.legend, item);
        } else if (source == this.depth) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("twoD"))) {
                this.chart.setDepth(DepthTypes.get("TWO_DIMENSION"));
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("threeD"))) {
                this.chart.setDepth(DepthTypes.get("TWO_AND_HALF_DIMENSION"));
            } else {
                this.chart.setDepth(DepthTypes.get("THREE_DIMENSION"));
            }
            this.selectMenuItem(this.depth, item);
        } else if (source == this.datatip) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("stationary"))) {
                this.chart.setDataTipStyle(DataTipStyles.get("STATIONARY"));
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("tracking"))) {
                this.chart.setDataTipStyle(DataTipStyles.get("TRACKING"));
            } else {
                this.chart.setDataTipStyle(DataTipStyles.get("NONE"));
            }
            this.selectMenuItem(this.datatip, item);
        } else if (source == this.orientation) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("vertical"))) {
                this.setVertical(true);
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("horizontal"))) {
                this.setVertical(false);
            }
            this.selectMenuItem(this.orientation, item);
        } else if (source == this.shape) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("box"))) {
                this.setBarShape("BOX");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("prism"))) {
                this.setBarShape("PRISM");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("hexagon"))) {
                this.setBarShape("HEXAGON");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("pentagon"))) {
                this.setBarShape("PENTAGON");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("cylinder"))) {
                this.setBarShape("CYLINDER");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("star"))) {
                this.setBarShape("STAR");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("cone"))) {
                this.setBarShape("CONE");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("octagon"))) {
                this.setBarShape("OCTAGON");
            }
            this.selectMenuItem(this.shape, item);
        } else if (source == this.marker) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("box"))) {
                this.setMarkerType("BOX");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("cross"))) {
                this.setMarkerType("CROSS");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("circle"))) {
                this.setMarkerType("CIRCLE");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("sphere"))) {
                this.setMarkerType("SPHERE");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("pyramid"))) {
                this.setMarkerType("PYRAMID");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("userDefined"))) {
                this.setMarkerType("USER_DEFINED");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("none"))) {
                this.setMarkerType("NONE");
            }
            this.selectMenuItem(this.marker, item);
        } else if (source == this.join) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("line"))) {
                this.setJoinType("LINE");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("needle"))) {
                this.setJoinType("NEEDLE");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("stepLeft"))) {
                this.setJoinType("STEP_LEFT");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("stepRight"))) {
                this.setJoinType("STEP_RIGHT");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("stepCenter"))) {
                this.setJoinType("STEP_CENTER");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("userDefined"))) {
                this.setJoinType("USER_DEFINED");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("none"))) {
                this.setJoinType("NONE");
            }
            this.selectMenuItem(this.join, item);
        } else if (source == this.overlayType) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("line"))) {
                this.setOverlayType("LINES");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("barNline"))) {
                this.setOverlayType("BOX_LINES");
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("scatter"))) {
                this.setOverlayType("SCATTER");
            }
            this.selectMenuItem(this.overlayType, item);
        } else if (source == this.others) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("maximumSlices"))) {
                ((Pie)this.chart).setOtherMode(PieOthersModes.get("SLICES"));
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("percentThreshold"))) {
                ((Pie)this.chart).setOtherMode(PieOthersModes.get("THRESHOLD"));
            } else {
                ((Pie)this.chart).setOtherMode(PieOthersModes.get("NONE"));
            }
            this.selectMenuItem(this.others, item);
        } else if (source == this.pieLabel) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("height"))) {
                ((Pie)this.chart).setPieLabelType(PieLabelTypes.get("HEIGHT"));
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("weight"))) {
                ((Pie)this.chart).setPieLabelType(PieLabelTypes.get("WEIGHT"));
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("sector"))) {
                ((Pie)this.chart).setPieLabelType(PieLabelTypes.get("SECTOR"));
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("sectorWeight"))) {
                ((Pie)this.chart).setPieLabelType(PieLabelTypes.get("SECTOR_WEIGHT"));
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("sectorHeight"))) {
                ((Pie)this.chart).setPieLabelType(PieLabelTypes.get("SECTOR_HEIGHT"));
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("weightHeight"))) {
                ((Pie)this.chart).setPieLabelType(PieLabelTypes.get("WEIGHT_HEIGHT"));
            } else {
                ((Pie)this.chart).setPieLabelType(PieLabelTypes.get("SECTOR_WEIGHT_HEIGHT"));
            }
            this.selectMenuItem(this.pieLabel, item);
        } else if (source == this.dataSubset) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("enable"))) {
                ((RowColumn)this.chart).setSubsetDataMode(true);
            } else if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("disable"))) {
                ((RowColumn)this.chart).setSubsetDataMode(false);
            }
            this.selectMenuItem(this.dataSubset, item);
        } else if (source == this.category || ((Menu)source).getParent() == this.category) {
            this.setCategoryVariableName(item);
            this.selectMenuItem(this.category, item);
        } else if (source == this.category2 || ((Menu)source).getParent() == this.category2) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("noneVar"))) {
                this.nullVariable(6);
            } else {
                this.setCategory2VariableName(item);
            }
            this.selectMenuItem(this.category2, item);
        } else if (source == this.response || ((Menu)source).getParent() == this.response) {
            if (this.chart instanceof Overlay) {
                if (((Overlay)this.chart).getGroupVariable() == null) {
                    ((Overlay)this.chart).setHeightVariables(null);
                    this.selectMenuItem(this.response, ChartPopupMenu.getString("autoVar"));
                    return;
                }
                if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("autoVar"))) {
                    ((Overlay)this.chart).setGroupVariable(null);
                    ((Overlay)this.chart).setHeightVariables(null);
                    this.selectMenuItem(this.response, ChartPopupMenu.getString("autoVar"));
                    return;
                }
            }
            this.setResponseVariableName(item);
            this.selectMenuItem(this.response, item);
        } else if (source == this.group || ((Menu)source).getParent() == this.group) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("noneVar"))) {
                this.nullVariable(2);
            } else {
                this.setGroupVariableName(item);
            }
            this.selectMenuItem(this.group, item);
        } else if (source == this.subgroup || ((Menu)source).getParent() == this.subgroup) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("noneVar"))) {
                this.nullVariable(3);
            } else {
                this.setSubGroupVariableName(item);
            }
            this.selectMenuItem(this.subgroup, item);
        } else if (source == this.responseColor || ((Menu)source).getParent() == this.responseColor) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("noneVar"))) {
                this.nullVariable(4);
            } else {
                this.setResponseColorVariableName(item);
            }
            this.selectMenuItem(this.responseColor, item);
        } else if (source == this.responseHeight || ((Menu)source).getParent() == this.responseHeight) {
            if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("noneVar"))) {
                this.nullVariable(7);
            } else {
                this.setResponseHeightVariableName(item);
            }
            this.selectMenuItem(this.responseHeight, item);
        }
    }

    private void setEnabled(Menu mu, String item) {
        if (item == null) {
            for (int i = 0; i < mu.getItemCount(); ++i) {
                if (!(mu.getItem(i) instanceof CheckboxMenuItem)) continue;
                CheckboxMenuItem c = (CheckboxMenuItem)mu.getItem(i);
                c.setEnabled(true);
            }
        } else {
            for (int i = 0; i < mu.getItemCount(); ++i) {
                if (!(mu.getItem(i) instanceof CheckboxMenuItem)) continue;
                CheckboxMenuItem c = (CheckboxMenuItem)mu.getItem(i);
                String l = c.getLabel();
                if (com.sas.util.Util.equal((Object)l, (Object)item)) {
                    c.setEnabled(true);
                    continue;
                }
                if (com.sas.util.Util.equal((Object)l, (Object)ChartPopupMenu.getString("noneVar"))) {
                    c.setEnabled(true);
                    continue;
                }
                if (com.sas.util.Util.equal((Object)l, (Object)ChartPopupMenu.getString("autoVar"))) {
                    c.setEnabled(true);
                    continue;
                }
                c.setEnabled(false);
            }
        }
    }

    private void selectMenuItem(Menu mu, String item) {
        for (int i = 0; i < mu.getItemCount(); ++i) {
            if (mu.getItem(i) instanceof CheckboxMenuItem) {
                CheckboxMenuItem c = (CheckboxMenuItem)mu.getItem(i);
                if (!com.sas.util.Util.equal((Object)c.getLabel(), (Object)item)) {
                    c.setState(false);
                    continue;
                }
                c.setState(true);
                continue;
            }
            if (!(mu.getItem(i) instanceof Menu)) continue;
            Menu m = (Menu)mu.getItem(i);
            this.selectMenuItem(m, item);
        }
    }

    private void makeVisualsMenu(Menu visuals) {
        if (this.chart == null) {
            return;
        }
        this.colors = new Menu(ChartPopupMenu.getString("colors"));
        this.makeColorsMenu(this.colors);
        visuals.add(this.colors);
        this.legend = new Menu(ChartPopupMenu.getString("legend"));
        this.makeLegendMenu(this.legend);
        visuals.add(this.legend);
        this.depth = new Menu(ChartPopupMenu.getString("depth"));
        this.makeDepthMenu(this.depth);
        visuals.add(this.depth);
        this.datatip = new Menu(ChartPopupMenu.getString("datatip"));
        this.makeDatatipMenu(this.datatip);
        visuals.add(this.datatip);
        switch (this.chartType) {
            case 0: 
            case 1: {
                this.orientation = new Menu(ChartPopupMenu.getString("orientation"));
                this.makeOrientationMenu(this.orientation);
                visuals.add(this.orientation);
                this.shape = new Menu(ChartPopupMenu.getString("shape"));
                this.makeShapeMenu(this.shape);
                visuals.add(this.shape);
                break;
            }
            case 3: {
                this.marker = new Menu(ChartPopupMenu.getString("shape"));
                this.makeMarkerMenu(this.marker);
                visuals.add(this.marker);
                this.join = new Menu(ChartPopupMenu.getString("join"));
                this.makeJoinMenu(this.join);
                visuals.add(this.join);
                break;
            }
            case 2: {
                this.pieLabel = new Menu(ChartPopupMenu.getString("pieLabel"));
                this.makePieLabelMenu(this.pieLabel);
                visuals.add(this.pieLabel);
                this.others = new Menu(ChartPopupMenu.getString("others"));
                this.makeOthersMenu(this.others);
                visuals.add(this.others);
                break;
            }
            default: {
                this.overlayType = new Menu(ChartPopupMenu.getString("overlayType"));
                this.makeOverlayTypeMenu(this.overlayType);
                visuals.add(this.overlayType);
                this.marker = new Menu(ChartPopupMenu.getString("marker"));
                this.makeMarkerMenu(this.marker);
                visuals.add(this.marker);
                this.join = new Menu(ChartPopupMenu.getString("join"));
                this.makeJoinMenu(this.join);
                visuals.add(this.join);
            }
        }
        if (this.chartType != 2 && this.chartType != 4) {
            this.dataSubset = new Menu(ChartPopupMenu.getString("dataSubset"));
            this.makeDataSubsetMenu(this.dataSubset);
            visuals.add(this.dataSubset);
        }
        this.updateVisualsMenu();
    }

    private void makeVariablesMenu(Menu variables) {
        if (this.chart == null || !this.chart.visualization.validData()) {
            return;
        }
        boolean nonNumericalOnly = false;
        StaticTableInterface rd = this.chart.visualization.getRectangularData();
        if (rd instanceof MdTo2dTable) {
            nonNumericalOnly = true;
        }
        String name = null;
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        switch (this.chartType) {
            case 0: {
                this.category = new Menu(ChartPopupMenu.getString("category"));
                this.makeListMenu(this.category, false, true, false, nonNumericalOnly);
                variables.add(this.category);
                this.category2 = new Menu(ChartPopupMenu.getString("series"));
                this.makeListMenu(this.category2, false, false, false, nonNumericalOnly);
                variables.add(this.category2);
                this.response = new Menu(ChartPopupMenu.getString("response"));
                this.makeListMenu(this.response, true, true, false, nonNumericalOnly);
                variables.add(this.response);
                this.group = new Menu(ChartPopupMenu.getString("group"));
                this.makeListMenu(this.group, false, false, false, nonNumericalOnly);
                variables.add(this.group);
                this.responseColor = new Menu(ChartPopupMenu.getString("responseColor"));
                this.makeListMenu(this.responseColor, true, false, false, nonNumericalOnly);
                variables.add(this.responseColor);
                if (this.chart.isSwanStyleData()) {
                    this.category.setEnabled(false);
                    this.category2.setEnabled(false);
                    this.group.setEnabled(false);
                }
                Bar bar = (Bar)this.chart;
                name = this.getVariableName(bar.getColumnVariable(), columnInfoUsed);
                this.selectMenuItem(this.category, name);
                name = this.getVariableName(bar.getRowVariable(), columnInfoUsed);
                if (name == null) {
                    this.selectMenuItem(this.category2, ChartPopupMenu.getString("noneVar"));
                    if (!this.chart.isSwanStyleData()) {
                        this.group.setEnabled(true);
                    }
                } else {
                    this.selectMenuItem(this.category2, name);
                    this.group.setEnabled(false);
                }
                name = this.getVariableName(bar.getHeightVariable(), columnInfoUsed);
                this.selectMenuItem(this.response, name);
                name = this.getVariableName(bar.getGroupVariable(), columnInfoUsed);
                if (name == null) {
                    name = ChartPopupMenu.getString("noneVar");
                }
                this.selectMenuItem(this.group, name);
                name = this.getVariableName(bar.getColorVariable(), columnInfoUsed);
                if (name == null) {
                    name = ChartPopupMenu.getString("noneVar");
                }
                this.selectMenuItem(this.responseColor, name);
                break;
            }
            case 1: {
                SegmentedBar sbar = (SegmentedBar)this.chart;
                this.category = new Menu(ChartPopupMenu.getString("category"));
                this.makeListMenu(this.category, false, true, false, nonNumericalOnly);
                variables.add(this.category);
                this.category2 = new Menu(ChartPopupMenu.getString("series"));
                this.makeListMenu(this.category2, false, false, false, nonNumericalOnly);
                variables.add(this.category2);
                this.response = new Menu(ChartPopupMenu.getString("response"));
                this.makeListMenu(this.response, true, true, false, nonNumericalOnly);
                variables.add(this.response);
                this.group = new Menu(ChartPopupMenu.getString("group"));
                this.makeListMenu(this.group, false, false, false, nonNumericalOnly);
                variables.add(this.group);
                this.subgroup = new Menu(ChartPopupMenu.getString("subgroup"));
                this.makeListMenu(this.subgroup, false, false, false, nonNumericalOnly);
                variables.add(this.subgroup);
                if (this.chart.isSwanStyleData()) {
                    this.category.setEnabled(false);
                    this.category2.setEnabled(false);
                    this.group.setEnabled(false);
                    this.subgroup.setEnabled(false);
                    this.response.setEnabled(false);
                }
                name = this.getVariableName(sbar.getColumnVariable(), columnInfoUsed);
                this.selectMenuItem(this.category, name);
                name = this.getVariableName(sbar.getRowVariable(), columnInfoUsed);
                if (name == null) {
                    this.selectMenuItem(this.category2, ChartPopupMenu.getString("noneVar"));
                    if (!this.chart.isSwanStyleData()) {
                        this.group.setEnabled(true);
                    }
                } else {
                    this.selectMenuItem(this.category2, name);
                    this.group.setEnabled(false);
                }
                name = this.getVariableName(sbar.getHeightVariable(), columnInfoUsed);
                this.selectMenuItem(this.response, name);
                name = this.getVariableName(sbar.getGroupVariable(), columnInfoUsed);
                if (name == null) {
                    name = ChartPopupMenu.getString("noneVar");
                }
                this.selectMenuItem(this.group, name);
                name = this.getVariableName(sbar.getSegmentVariable(), columnInfoUsed);
                if (name == null) {
                    name = ChartPopupMenu.getString("noneVar");
                }
                this.selectMenuItem(this.subgroup, name);
                break;
            }
            case 2: {
                this.category = new Menu(ChartPopupMenu.getString("category"));
                this.makeListMenu(this.category, false, true, false, nonNumericalOnly);
                variables.add(this.category);
                this.response = new Menu(ChartPopupMenu.getString("response"));
                this.makeListMenu(this.response, true, true, false, nonNumericalOnly);
                variables.add(this.response);
                this.responseHeight = new Menu(ChartPopupMenu.getString("responseHeight"));
                this.makeListMenu(this.responseHeight, true, false, false, nonNumericalOnly);
                variables.add(this.responseHeight);
                if (this.chart.isSwanStyleData()) {
                    this.category.setEnabled(false);
                }
                Pie pie = (Pie)this.chart;
                name = this.getVariableName(pie.getSectorVariable(), columnInfoUsed);
                this.selectMenuItem(this.category, name);
                name = this.getVariableName(pie.getWeightVariable(), columnInfoUsed);
                this.selectMenuItem(this.response, name);
                name = this.getVariableName(pie.getHeightVariable(), columnInfoUsed);
                if (name == null) {
                    name = ChartPopupMenu.getString("noneVar");
                }
                this.selectMenuItem(this.responseHeight, name);
                break;
            }
            case 3: {
                this.category = new Menu(ChartPopupMenu.getString("xVar"));
                this.makeListMenu(this.category, false, true, false, nonNumericalOnly);
                variables.add(this.category);
                this.category2 = new Menu(ChartPopupMenu.getString("zVar"));
                this.makeListMenu(this.category2, false, false, false, nonNumericalOnly);
                variables.add(this.category2);
                this.group = new Menu(ChartPopupMenu.getString("group"));
                this.makeListMenu(this.group, false, false, false, nonNumericalOnly);
                variables.add(this.group);
                this.response = new Menu(ChartPopupMenu.getString("yVar"));
                this.makeListMenu(this.response, true, true, false, nonNumericalOnly);
                variables.add(this.response);
                this.responseColor = new Menu(ChartPopupMenu.getString("responseColor"));
                this.makeListMenu(this.responseColor, true, false, false, nonNumericalOnly);
                variables.add(this.responseColor);
                if (this.chart.isSwanStyleData()) {
                    this.category.setEnabled(false);
                    this.category2.setEnabled(false);
                }
                Scatter scatter = (Scatter)this.chart;
                name = this.getVariableName(scatter.getColumnVariable(), columnInfoUsed);
                this.selectMenuItem(this.category, name);
                name = this.getVariableName(scatter.getRowVariable(), columnInfoUsed);
                this.responseColor.setEnabled(true);
                this.group.setEnabled(true);
                if (name == null) {
                    if (!this.chart.isSwanStyleData()) {
                        this.group.setEnabled(true);
                    }
                    name = this.getVariableName(scatter.getGroupVariable(), columnInfoUsed);
                    this.setEnabled(this.group, null);
                    if (name == null) {
                        name = ChartPopupMenu.getString("noneVar");
                    }
                    this.selectMenuItem(this.group, name);
                    name = ChartPopupMenu.getString("noneVar");
                } else {
                    this.setEnabled(this.group, name);
                    String gname = this.getVariableName(scatter.getGroupVariable(), columnInfoUsed);
                    if (gname == null || !name.equals(gname)) {
                        this.selectMenuItem(this.group, ChartPopupMenu.getString("noneVar"));
                    } else {
                        this.selectMenuItem(this.group, name);
                    }
                }
                this.selectMenuItem(this.category2, name);
                name = this.getVariableName(scatter.getHeightVariable(), columnInfoUsed);
                this.selectMenuItem(this.response, name);
                name = this.getVariableName(scatter.getColorVariable(), columnInfoUsed);
                if (name == null) {
                    name = ChartPopupMenu.getString("noneVar");
                } else {
                    this.group.setEnabled(false);
                    IndependentVariable gr = scatter.getGroupVariable();
                    if (gr != null) {
                        gr.removePropertyChangeListener(scatter);
                        gr.setIndex(-1);
                        gr.addPropertyChangeListener(scatter);
                    }
                }
                this.selectMenuItem(this.responseColor, name);
                break;
            }
            default: {
                this.category = new Menu(ChartPopupMenu.getString("category"));
                this.makeListMenu(this.category, false, true, false, nonNumericalOnly);
                variables.add(this.category);
                this.response = new Menu(ChartPopupMenu.getString("response"));
                this.makeListMenu(this.response, true, true, true, nonNumericalOnly);
                variables.add(this.response);
                this.group = new Menu(ChartPopupMenu.getString("group"));
                this.makeListMenu(this.group, false, false, false, nonNumericalOnly);
                variables.add(this.group);
                if (this.chart.isSwanStyleData()) {
                    this.category.setEnabled(false);
                    this.group.setEnabled(false);
                    this.response.setEnabled(false);
                }
                Overlay overlay = (Overlay)this.chart;
                name = this.getVariableName(overlay.getColumnVariable(), columnInfoUsed);
                this.selectMenuItem(this.category, name);
                if (overlay.getGroupVariable() == null) {
                    this.selectMenuItem(this.group, ChartPopupMenu.getString("noneVar"));
                    this.selectMenuItem(this.response, ChartPopupMenu.getString("autoVar"));
                    break;
                }
                name = this.getVariableName(overlay.getGroupVariable(), columnInfoUsed);
                this.selectMenuItem(this.group, name);
                if (overlay.getHeightVariables() == null || overlay.getHeightVariables().length <= 0) break;
                name = this.getVariableName(overlay.getHeightVariables()[0], columnInfoUsed);
                this.selectMenuItem(this.response, name);
            }
        }
    }

    private void makeColorsMenu(Menu menu) {
        this.background = new Menu(ChartPopupMenu.getString("background"));
        this.makeStandardColorMenu(this.background, true, true);
        menu.add(this.background);
        if (this.chartType != 2) {
            this.backdrop = new Menu(ChartPopupMenu.getString("backdrop"));
            this.makeStandardColorMenu(this.backdrop, false, true);
            menu.add(this.backdrop);
        }
        this.outline = new Menu(ChartPopupMenu.getString("outline"));
        this.makeStandardColorMenu(this.outline, false, true);
        menu.add(this.outline);
    }

    private void makeStandardColorMenu(Menu menu, boolean transparent, boolean custom) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("black"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("blue"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("cyan"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("darkGray"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("gray"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("green"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("lightGray"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("magenta"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("orange"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("pink"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("red"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("white"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("yellow"));
        cb.addItemListener(this);
        menu.add(cb);
        if (custom) {
            CheckboxMenuItem mi = new CheckboxMenuItem(ChartPopupMenu.getString("custom"));
            mi.addActionListener(this);
            mi.addItemListener(this);
            menu.add(mi);
        }
    }

    private void makeLegendMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("on"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("off"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeDatatipMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("stationary"));
        cb.addItemListener(this);
        menu.add(cb);
        if (this.chart.is3DScatterPlot() || this.chart.is3DPieChart() || this.chart.isRiserChart()) {
            cb.setEnabled(false);
        }
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("tracking"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("none"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeDepthMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("twoD"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("threeD"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("threeDP"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeOrientationMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("vertical"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("horizontal"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeShapeMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("box"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("prism"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("pentagon"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("hexagon"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("cylinder"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("star"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("octagon"));
        cb.addItemListener(this);
        menu.add(cb);
        if (this.chartType == 0) {
            cb = new CheckboxMenuItem(ChartPopupMenu.getString("cone"));
            cb.addItemListener(this);
            menu.add(cb);
        }
    }

    private void makeMarkerMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("box"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("cross"));
        cb.addItemListener(this);
        menu.add(cb);
        if (this.chart instanceof Scatter) {
            cb = new CheckboxMenuItem(ChartPopupMenu.getString("circle"));
            cb.addItemListener(this);
            menu.add(cb);
            cb = new CheckboxMenuItem(ChartPopupMenu.getString("sphere"));
            cb.addItemListener(this);
            menu.add(cb);
            cb = new CheckboxMenuItem(ChartPopupMenu.getString("pyramid"));
            cb.addItemListener(this);
            menu.add(cb);
            cb = new CheckboxMenuItem(ChartPopupMenu.getString("none"));
            cb.addItemListener(this);
            menu.add(cb);
            cb = new CheckboxMenuItem(ChartPopupMenu.getString("userDefined"));
            cb.addItemListener(this);
            menu.add(cb);
        }
    }

    private void makeJoinMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("line"));
        cb.addItemListener(this);
        menu.add(cb);
        if (this.chart instanceof Scatter) {
            cb = new CheckboxMenuItem(ChartPopupMenu.getString("needle"));
            cb.addItemListener(this);
            menu.add(cb);
            cb = new CheckboxMenuItem(ChartPopupMenu.getString("stepLeft"));
            cb.addItemListener(this);
            menu.add(cb);
            cb = new CheckboxMenuItem(ChartPopupMenu.getString("stepRight"));
            cb.addItemListener(this);
            menu.add(cb);
            cb = new CheckboxMenuItem(ChartPopupMenu.getString("stepCenter"));
            cb.addItemListener(this);
            menu.add(cb);
        }
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("none"));
        cb.addItemListener(this);
        menu.add(cb);
        if (this.chart instanceof Scatter) {
            cb = new CheckboxMenuItem(ChartPopupMenu.getString("userDefined"));
            cb.addItemListener(this);
            menu.add(cb);
        }
    }

    private void makeOverlayTypeMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("line"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("barNline"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("scatter"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makePieLabelMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("weight"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("sector"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("sectorWeight"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("height"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("weightHeight"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("sectorHeight"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("allLabels"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeOthersMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("maximumSlices"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("percentThreshold"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("noneOther"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeDataSubsetMenu(Menu menu) {
        CheckboxMenuItem cb = new CheckboxMenuItem(ChartPopupMenu.getString("enable"));
        cb.addItemListener(this);
        menu.add(cb);
        cb = new CheckboxMenuItem(ChartPopupMenu.getString("disable"));
        cb.addItemListener(this);
        menu.add(cb);
    }

    private void makeVariableMenu(Menu menu, boolean numericalOnly, boolean required, boolean automatic) {
        this.makeVariableMenu(menu, numericalOnly, required, automatic, false);
    }

    private void makeVariableMenu(Menu menu, boolean numericalOnly, boolean required, boolean automatic, boolean nonNumericalOnly) {
        StaticTableInterface rd = this.chart.visualization.getRectangularData();
        if (rd == null) {
            return;
        }
        int items = 0;
        try {
            CheckboxMenuItem cb;
            if (!required && this.startVar == 0) {
                cb = new CheckboxMenuItem(ChartPopupMenu.getString("noneVar"));
                cb.addItemListener(this);
                menu.add(cb);
                ++items;
            }
            if (automatic && this.startVar == 0) {
                cb = new CheckboxMenuItem(ChartPopupMenu.getString("autoVar"));
                cb.addItemListener(this);
                menu.add(cb);
                ++items;
            }
            int cols = rd.getColumnCount();
            int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
            if (numericalOnly) {
                int i;
                for (i = this.startVar; i < cols && items < this.maxItems; ++i) {
                    String name;
                    Class colType = ((StaticRowTemplateTableInterface)rd).getColumnClass(i + 1);
                    if (colType == String.class) continue;
                    if (rd instanceof StaticColumnInfoInterface) {
                        StaticColumnInfoInterface info = (StaticColumnInfoInterface)rd;
                        String[] columnInfoNames = info.getColumnInfoNames();
                        if (columnInfoUsed == 1 && columnInfoNames.length > 1) {
                            name = (String)info.getColumnInfo(i + 1, columnInfoNames[1]);
                            if (name == null || name.trim().equals("")) {
                                name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                            }
                        } else {
                            name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                        }
                    } else {
                        name = (String)((StaticColumnLabelInterface)rd).getColumnLabel(i + 1);
                    }
                    cb = new CheckboxMenuItem(name);
                    cb.addItemListener(this);
                    menu.add(cb);
                    ++items;
                }
                this.startVar = i;
            } else if (nonNumericalOnly) {
                int i;
                for (i = this.startVar; i < cols && items < this.maxItems; ++i) {
                    String name;
                    Class colType = ((StaticRowTemplateTableInterface)rd).getColumnClass(i + 1);
                    if (colType != String.class) continue;
                    if (rd instanceof StaticColumnInfoInterface) {
                        StaticColumnInfoInterface info = (StaticColumnInfoInterface)rd;
                        String[] columnInfoNames = info.getColumnInfoNames();
                        if (columnInfoUsed == 1 && columnInfoNames.length > 1) {
                            name = (String)info.getColumnInfo(i + 1, columnInfoNames[1]);
                            if (name == null || name.trim().equals("")) {
                                name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                            }
                        } else {
                            name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                        }
                    } else {
                        name = (String)((StaticColumnLabelInterface)rd).getColumnLabel(i + 1);
                    }
                    cb = new CheckboxMenuItem(name);
                    cb.addItemListener(this);
                    menu.add(cb);
                    ++items;
                }
                this.startVar = i;
            } else {
                int i;
                for (i = this.startVar; i < cols && items < this.maxItems; ++items, ++i) {
                    String name;
                    if (rd instanceof StaticColumnInfoInterface) {
                        StaticColumnInfoInterface info = (StaticColumnInfoInterface)rd;
                        String[] columnInfoNames = info.getColumnInfoNames();
                        if (columnInfoUsed == 1 && columnInfoNames.length > 1) {
                            name = (String)info.getColumnInfo(i + 1, columnInfoNames[1]);
                            if (name == null || name.trim().equals("")) {
                                name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                            }
                        } else {
                            name = (String)info.getColumnInfo(i + 1, columnInfoNames[0]);
                        }
                    } else {
                        name = (String)((StaticColumnLabelInterface)rd).getColumnLabel(i + 1);
                    }
                    cb = new CheckboxMenuItem(name);
                    cb.addItemListener(this);
                    menu.add(cb);
                }
                this.startVar = i;
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    public void updateVariablesMenu() {
        if (this.variables != null) {
            this.variables.removeAll();
            this.makeVariablesMenu(this.variables);
        }
    }

    public void updateVisualsMenu() {
        this.updateColorsMenu();
        this.updateLegendMenu();
        this.updateDepthMenu();
        this.updateDatatipMenu();
        switch (this.chartType) {
            case 0: 
            case 1: {
                this.updateOrientationMenu();
                this.updateShapeMenu();
                break;
            }
            case 3: {
                this.updateMarkerMenu();
                this.updateJoinMenu();
                break;
            }
            case 2: {
                this.updateOthersMenu();
                this.updatePieLabelMenu();
                break;
            }
            default: {
                this.updateOverlayTypeMenu();
                this.updateMarkerMenu();
                this.updateJoinMenu();
            }
        }
        if (this.chartType != 2 && this.chartType != 4) {
            this.updateDataSubsetMenu();
        }
    }

    private void updateColorsMenu() {
        this.selectColorItem(this.background, this.chart.getBackgroundColor());
        switch (this.chartType) {
            case 0: 
            case 1: 
            case 3: {
                RowColumn rowcol = (RowColumn)this.chart;
                this.selectColorItem(this.backdrop, rowcol.getBackplaneColor());
                break;
            }
            case 4: {
                Overlay overlay = (Overlay)this.chart;
                this.selectColorItem(this.backdrop, overlay.getBackplaneColor());
                break;
            }
        }
        this.selectColorItem(this.outline, this.chart.getOutlineColor());
    }

    private void selectColorItem(Menu menu, Color color) {
        if (menu == null) {
            return;
        }
        if (com.sas.util.Util.equal((Object)color, (Object)Color.black)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("black"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.blue)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("blue"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.cyan)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("cyan"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.darkGray)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("darkGray"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.gray)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("gray"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.green)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("green"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.lightGray)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("lightGray"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.magenta)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("magenta"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.orange)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("orange"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.pink)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("pink"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.red)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("red"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.white)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("white"));
        } else if (com.sas.util.Util.equal((Object)color, (Object)Color.yellow)) {
            this.selectMenuItem(menu, ChartPopupMenu.getString("yellow"));
        } else {
            this.selectMenuItem(menu, ChartPopupMenu.getString("custom"));
        }
    }

    private Color getSelectedColor(String item) {
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("black"))) {
            return Color.black;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("blue"))) {
            return Color.blue;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("cyan"))) {
            return Color.cyan;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("darkGray"))) {
            return Color.darkGray;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("gray"))) {
            return Color.gray;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("green"))) {
            return Color.green;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("lightGray"))) {
            return Color.lightGray;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("magenta"))) {
            return Color.magenta;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("orange"))) {
            return Color.orange;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("pink"))) {
            return Color.pink;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("red"))) {
            return Color.red;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("white"))) {
            return Color.white;
        }
        if (com.sas.util.Util.equal((Object)item, (Object)ChartPopupMenu.getString("yellow"))) {
            return Color.yellow;
        }
        return null;
    }

    private void updateLegendMenu() {
        if (this.legend == null) {
            return;
        }
        ColorLegendStyle legendStyle = null;
        switch (this.chartType) {
            case 0: {
                Bar bar = (Bar)this.chart;
                legendStyle = bar.getColorLegendStyle();
                break;
            }
            case 1: {
                SegmentedBar sBar = (SegmentedBar)this.chart;
                legendStyle = sBar.getSegmentLegendStyle();
                break;
            }
            case 2: {
                Pie pie = (Pie)this.chart;
                legendStyle = pie.getSectorLegendStyle();
                break;
            }
            case 3: {
                Scatter scatter = (Scatter)this.chart;
                legendStyle = scatter.getColorLegendStyle();
                break;
            }
            default: {
                Overlay overlay = (Overlay)this.chart;
                legendStyle = overlay.getGroupLegendStyle();
            }
        }
        if (legendStyle.isVisible()) {
            this.selectMenuItem(this.legend, ChartPopupMenu.getString("on"));
        } else {
            this.selectMenuItem(this.legend, ChartPopupMenu.getString("off"));
        }
    }

    private void updateDepthMenu() {
        if (this.depth == null) {
            return;
        }
        DepthTypes type = this.chart.getDepth();
        if (type.toString().equals("TWO_DIMENSION")) {
            this.selectMenuItem(this.depth, ChartPopupMenu.getString("twoD"));
        } else if (type.toString().equals("TWO_AND_HALF_DIMENSION")) {
            this.selectMenuItem(this.depth, ChartPopupMenu.getString("threeD"));
        } else {
            this.selectMenuItem(this.depth, ChartPopupMenu.getString("threeDP"));
        }
    }

    private void updateDatatipMenu() {
        if (this.datatip == null) {
            return;
        }
        DataTipStyles style = this.chart.getDataTipStyle();
        if (style.toString().equals("STATIONARY")) {
            if (this.chart.isRiserChart() || this.chart.is3DPieChart() || this.chart.is3DScatterPlot()) {
                this.selectMenuItem(this.datatip, ChartPopupMenu.getString("tracking"));
            } else {
                this.selectMenuItem(this.datatip, ChartPopupMenu.getString("stationary"));
            }
        } else if (style.toString().equals("TRACKING")) {
            this.selectMenuItem(this.datatip, ChartPopupMenu.getString("tracking"));
        } else {
            this.selectMenuItem(this.datatip, ChartPopupMenu.getString("none"));
        }
        if (this.chart.isRiserChart() || this.chart.is3DPieChart() || this.chart.is3DScatterPlot()) {
            ((CheckboxMenuItem)this.datatip.getItem(0)).setEnabled(false);
        } else {
            ((CheckboxMenuItem)this.datatip.getItem(0)).setEnabled(true);
        }
    }

    private void updateOrientationMenu() {
        if (this.orientation == null) {
            return;
        }
        if (this.chartType == 0) {
            Bar bar = (Bar)this.chart;
            if (bar.isVertical()) {
                this.selectMenuItem(this.orientation, ChartPopupMenu.getString("vertical"));
            } else {
                this.selectMenuItem(this.orientation, ChartPopupMenu.getString("horizontal"));
            }
        } else if (this.chartType == 1) {
            SegmentedBar bar = (SegmentedBar)this.chart;
            if (bar.isVertical()) {
                this.selectMenuItem(this.orientation, ChartPopupMenu.getString("vertical"));
            } else {
                this.selectMenuItem(this.orientation, ChartPopupMenu.getString("horizontal"));
            }
        }
    }

    private void updateShapeMenu() {
        if (this.shape == null) {
            return;
        }
        if (this.chartType == 0 || this.chartType == 1) {
            Group group = (Group)this.chart;
            BarGeometryTypes type = group.getGeometryType();
            if (type.toString().equals("CYLINDER")) {
                this.selectMenuItem(this.shape, ChartPopupMenu.getString("cylinder"));
            } else if (type.toString().equals("PRISM")) {
                this.selectMenuItem(this.shape, ChartPopupMenu.getString("prism"));
            } else if (type.toString().equals("PENTAGON")) {
                this.selectMenuItem(this.shape, ChartPopupMenu.getString("pentagon"));
            } else if (type.toString().equals("HEXAGON")) {
                this.selectMenuItem(this.shape, ChartPopupMenu.getString("hexagon"));
            } else if (type.toString().equals("STAR")) {
                this.selectMenuItem(this.shape, ChartPopupMenu.getString("star"));
            } else if (type.toString().equals("CONE")) {
                this.selectMenuItem(this.shape, ChartPopupMenu.getString("cone"));
            } else if (type.toString().equals("OCTAGON")) {
                this.selectMenuItem(this.shape, ChartPopupMenu.getString("octagon"));
            } else {
                this.selectMenuItem(this.shape, ChartPopupMenu.getString("box"));
            }
        }
    }

    private void updateMarkerMenu() {
        if (this.marker == null) {
            return;
        }
        if (this.chartType == 3) {
            Scatter scatter = (Scatter)this.chart;
            MarkerGeometryTypes type = scatter.getMarkerType();
            if (type.toString().equals("BOX")) {
                this.selectMenuItem(this.marker, ChartPopupMenu.getString("box"));
            } else if (type.toString().equals("CIRCLE")) {
                this.selectMenuItem(this.marker, ChartPopupMenu.getString("circle"));
            } else if (type.toString().equals("CROSS")) {
                this.selectMenuItem(this.marker, ChartPopupMenu.getString("cross"));
            } else if (type.toString().equals("SPHERE")) {
                this.selectMenuItem(this.marker, ChartPopupMenu.getString("sphere"));
            } else if (type.toString().equals("PYRAMID")) {
                this.selectMenuItem(this.marker, ChartPopupMenu.getString("pyramid"));
            } else if (type.toString().equals("USER_DEFINED")) {
                this.selectMenuItem(this.marker, ChartPopupMenu.getString("userDefined"));
            } else {
                this.selectMenuItem(this.marker, ChartPopupMenu.getString("none"));
            }
            MenuItem m = this.marker.getItem(this.marker.getItemCount() - 1);
            if (scatter.getMapShapes() == null) {
                m.setEnabled(false);
            } else {
                m.setEnabled(true);
            }
        } else if (this.chartType == 4) {
            Overlay overlay = (Overlay)this.chart;
            MarkerGeometryTypes type = overlay.getMarkerType();
            if (type.toString().equals("BOX")) {
                this.selectMenuItem(this.marker, ChartPopupMenu.getString("box"));
            } else if (type.toString().equals("CIRCLE")) {
                this.selectMenuItem(this.marker, ChartPopupMenu.getString("circle"));
            } else if (type.toString().equals("CROSS")) {
                this.selectMenuItem(this.marker, ChartPopupMenu.getString("cross"));
            } else {
                this.selectMenuItem(this.marker, ChartPopupMenu.getString("none"));
            }
        }
    }

    private void updateJoinMenu() {
        if (this.join == null) {
            return;
        }
        if (this.chartType == 3) {
            Scatter scatter = (Scatter)this.chart;
            JoinTypes type = scatter.getJoinType();
            if (type.toString().equals("LINE")) {
                this.selectMenuItem(this.join, ChartPopupMenu.getString("line"));
            } else if (type.toString().equals("NEEDLE")) {
                this.selectMenuItem(this.join, ChartPopupMenu.getString("needle"));
            } else if (type.toString().equals("STEP_LEFT")) {
                this.selectMenuItem(this.join, ChartPopupMenu.getString("stepLeft"));
            } else if (type.toString().equals("STEP_RIGHT")) {
                this.selectMenuItem(this.join, ChartPopupMenu.getString("stepRight"));
            } else if (type.toString().equals("STEP_CENTER")) {
                this.selectMenuItem(this.join, ChartPopupMenu.getString("stepCenter"));
            } else if (type.toString().equals("USER_DEFINED")) {
                this.selectMenuItem(this.join, ChartPopupMenu.getString("userDefined"));
            } else {
                this.selectMenuItem(this.join, ChartPopupMenu.getString("none"));
            }
            MenuItem m = this.join.getItem(this.join.getItemCount() - 1);
            if (scatter.getMapJoins() == null) {
                m.setEnabled(false);
            } else {
                m.setEnabled(true);
            }
        } else if (this.chartType == 4) {
            Overlay overlay = (Overlay)this.chart;
            JoinTypes type = overlay.getJoinType();
            if (type.toString().equals("LINE")) {
                this.selectMenuItem(this.join, ChartPopupMenu.getString("line"));
            } else {
                this.selectMenuItem(this.join, ChartPopupMenu.getString("none"));
            }
        }
    }

    private void updateOverlayTypeMenu() {
        if (this.overlayType == null) {
            return;
        }
        if (this.chartType == 4) {
            Overlay overlay = (Overlay)this.chart;
            OverlayTypes type = overlay.getOverlayType();
            this.marker.setEnabled(false);
            this.join.setEnabled(false);
            if (type.toString().equals("LINES")) {
                this.selectMenuItem(this.overlayType, ChartPopupMenu.getString("line"));
            } else if (type.toString().equals("BOX_LINES")) {
                this.selectMenuItem(this.overlayType, ChartPopupMenu.getString("barNline"));
            } else if (type.toString().equals("SCATTER")) {
                this.selectMenuItem(this.overlayType, ChartPopupMenu.getString("scatter"));
                this.marker.setEnabled(true);
                this.join.setEnabled(true);
            } else {
                this.selectMenuItem(this.overlayType, ChartPopupMenu.getString("none"));
            }
        }
    }

    private void updatePieLabelMenu() {
        if (this.pieLabel == null) {
            return;
        }
        if (this.chartType == 2) {
            Pie pie = (Pie)this.chart;
            if (pie.getPieLabelType().toString().equals("WEIGHT")) {
                this.selectMenuItem(this.pieLabel, ChartPopupMenu.getString("weight"));
            } else if (pie.getPieLabelType().toString().equals("SECTOR")) {
                this.selectMenuItem(this.pieLabel, ChartPopupMenu.getString("sector"));
            } else if (pie.getPieLabelType().toString().equals("SECTOR_WEIGHT")) {
                this.selectMenuItem(this.pieLabel, ChartPopupMenu.getString("sectorWeight"));
            } else if (pie.getPieLabelType().toString().equals("HEIGHT")) {
                this.selectMenuItem(this.pieLabel, ChartPopupMenu.getString("height"));
            } else if (pie.getPieLabelType().toString().equals("SECTOR_HEIGHT")) {
                this.selectMenuItem(this.pieLabel, ChartPopupMenu.getString("sectorHeight"));
            } else if (pie.getPieLabelType().toString().equals("WEIGHT_HEIGHT")) {
                this.selectMenuItem(this.pieLabel, ChartPopupMenu.getString("weightHeight"));
            } else {
                this.selectMenuItem(this.pieLabel, ChartPopupMenu.getString("allLabels"));
            }
        }
    }

    private void updateOthersMenu() {
        if (this.others == null) {
            return;
        }
        if (this.chartType == 2) {
            Pie pie = (Pie)this.chart;
            if (pie.getOtherMode().toString().equals("SLICES")) {
                this.selectMenuItem(this.others, ChartPopupMenu.getString("maximumSlices"));
            } else if (pie.getOtherMode().toString().equals("THRESHOLD")) {
                this.selectMenuItem(this.others, ChartPopupMenu.getString("percentThreshold"));
            } else {
                this.selectMenuItem(this.others, ChartPopupMenu.getString("noneOther"));
            }
        }
    }

    private void updateDataSubsetMenu() {
        if (this.dataSubset == null) {
            return;
        }
        if (((RowColumn)this.chart).isSubsetDataMode()) {
            this.selectMenuItem(this.dataSubset, ChartPopupMenu.getString("enable"));
        } else {
            this.selectMenuItem(this.dataSubset, ChartPopupMenu.getString("disable"));
        }
    }

    private void setVertical(boolean vertical) {
        if (this.chartType == 0) {
            Bar bar = (Bar)this.chart;
            bar.setVertical(vertical);
        } else if (this.chartType == 1) {
            this.category2.setEnabled(vertical);
            SegmentedBar bar = (SegmentedBar)this.chart;
            bar.setVertical(vertical);
        }
    }

    private void setLegendVisible(boolean visible) {
        ColorLegendStyle legendStyle = null;
        switch (this.chartType) {
            case 0: {
                Bar bar = (Bar)this.chart;
                legendStyle = bar.getColorLegendStyle();
                break;
            }
            case 1: {
                SegmentedBar sBar = (SegmentedBar)this.chart;
                legendStyle = sBar.getSegmentLegendStyle();
                break;
            }
            case 2: {
                Pie pie = (Pie)this.chart;
                legendStyle = pie.getSectorLegendStyle();
                break;
            }
            case 3: {
                Scatter scatter = (Scatter)this.chart;
                legendStyle = scatter.getColorLegendStyle();
                DiscreteColorLegendStyle gLegendStyle = scatter.getGroupLegendStyle();
                if (gLegendStyle == null) break;
                gLegendStyle.setVisible(visible);
                break;
            }
            default: {
                Overlay overlay = (Overlay)this.chart;
                legendStyle = overlay.getGroupLegendStyle();
            }
        }
        if (legendStyle != null) {
            legendStyle.setVisible(visible);
        }
    }

    private void setBarShape(String enumString) {
        Group group = (Group)this.chart;
        group.setGeometryType(BarGeometryTypes.get(enumString));
    }

    private void setMarkerType(String enumString) {
        if (this.chartType == 3) {
            Scatter scatter = (Scatter)this.chart;
            scatter.setMarkerType(MarkerGeometryTypes.get(enumString));
        } else if (this.chartType == 4) {
            Overlay overlay = (Overlay)this.chart;
            overlay.setMarkerType(MarkerGeometryTypes.get(enumString));
        }
    }

    private void setJoinType(String enumString) {
        if (this.chartType == 3) {
            Scatter scatter = (Scatter)this.chart;
            scatter.setJoinType(JoinTypes.get(enumString));
        } else if (this.chartType == 4) {
            Overlay overlay = (Overlay)this.chart;
            overlay.setJoinType(JoinTypes.get(enumString));
        }
    }

    private void setOverlayType(String enumString) {
        if (this.chartType == 4) {
            Overlay overlay = (Overlay)this.chart;
            overlay.setOverlayType(OverlayTypes.get(enumString));
        }
    }

    private void nullVariable(int role) {
        switch (this.chartType) {
            case 0: {
                Bar bar = (Bar)this.chart;
                if (role == 2) {
                    bar.setGroupVariable(null);
                    break;
                }
                if (role == 4) {
                    bar.setColorVariable(null);
                    break;
                }
                if (role != 6) break;
                bar.setRowVariable(null);
                break;
            }
            case 1: {
                SegmentedBar sBar = (SegmentedBar)this.chart;
                if (role == 2) {
                    sBar.setGroupVariable(null);
                    break;
                }
                if (role == 3) {
                    sBar.setSegmentVariable(null);
                    break;
                }
                if (role != 6) break;
                sBar.setRowVariable(null);
                break;
            }
            case 2: {
                Pie pie = (Pie)this.chart;
                if (role != 7) break;
                pie.setHeightVariable(null);
                break;
            }
            case 3: {
                Scatter scatter = (Scatter)this.chart;
                if (role == 4) {
                    scatter.setColorVariable(null);
                    break;
                }
                if (role == 6) {
                    scatter.setRowVariable(null);
                    break;
                }
                if (role != 2) break;
                scatter.setGroupVariable(null);
                break;
            }
            default: {
                Overlay overlay = (Overlay)this.chart;
                if (role != 2) break;
                overlay.setGroupVariable(null);
                overlay.setHeightVariables(null);
            }
        }
    }

    protected String getVariableName(Variable v, int columnInfoUsed) {
        if (v == null) {
            return null;
        }
        if (v.getName() != null) {
            if (columnInfoUsed == 0) {
                return v.getName();
            }
            String label = v.getLabel();
            if (label != null && !label.trim().equals("")) {
                return label;
            }
            return v.getName();
        }
        try {
            StaticTableInterface rd = this.chart.visualization.getRectangularData();
            if (rd == null) {
                return null;
            }
            if (v.getIndex() > 0) {
                if (rd instanceof StaticColumnInfoInterface) {
                    StaticColumnInfoInterface info = (StaticColumnInfoInterface)rd;
                    String[] columnInfoNames = info.getColumnInfoNames();
                    if (columnInfoUsed == 1 && columnInfoNames.length > 1) {
                        String label = (String)info.getColumnInfo(v.getIndex(), columnInfoNames[1]);
                        if (label != null && !label.trim().equals("")) {
                            return label;
                        }
                        return (String)info.getColumnInfo(v.getIndex(), columnInfoNames[0]);
                    }
                    return (String)info.getColumnInfo(v.getIndex(), columnInfoNames[0]);
                }
                return (String)((StaticColumnLabelInterface)rd).getColumnLabel(v.getIndex());
            }
            return null;
        }
        catch (TableException tableException) {
            return null;
        }
    }

    private void setCategoryVariableName(String name) {
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        switch (this.chartType) {
            case 0: {
                Bar bar = (Bar)this.chart;
                if (columnInfoUsed == 1) {
                    bar.getColumnVariable().setLabel(name);
                    break;
                }
                bar.getColumnVariable().setName(name);
                break;
            }
            case 1: {
                SegmentedBar sBar = (SegmentedBar)this.chart;
                if (columnInfoUsed == 1) {
                    sBar.getColumnVariable().setLabel(name);
                    break;
                }
                sBar.getColumnVariable().setName(name);
                break;
            }
            case 2: {
                Pie pie = (Pie)this.chart;
                if (columnInfoUsed == 1) {
                    pie.getSectorVariable().setLabel(name);
                    break;
                }
                pie.getSectorVariable().setName(name);
                break;
            }
            case 3: {
                Scatter scatter = (Scatter)this.chart;
                if (columnInfoUsed == 1) {
                    scatter.getColumnVariable().setLabel(name);
                    break;
                }
                scatter.getColumnVariable().setName(name);
                break;
            }
            default: {
                Overlay overlay = (Overlay)this.chart;
                if (columnInfoUsed == 1) {
                    overlay.getColumnVariable().setLabel(name);
                    break;
                }
                overlay.getColumnVariable().setName(name);
            }
        }
    }

    private void setCategory2VariableName(String name) {
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        switch (this.chartType) {
            case 0: {
                Bar bar = (Bar)this.chart;
                if (columnInfoUsed == 1) {
                    bar.getRowVariable().setLabel(name);
                    break;
                }
                bar.getRowVariable().setName(name);
                break;
            }
            case 1: {
                SegmentedBar sBar = (SegmentedBar)this.chart;
                if (columnInfoUsed == 1) {
                    sBar.getRowVariable().setLabel(name);
                    break;
                }
                sBar.getRowVariable().setName(name);
                break;
            }
            case 3: {
                Scatter scatter = (Scatter)this.chart;
                if (columnInfoUsed == 1) {
                    scatter.getRowVariable().setLabel(name);
                    break;
                }
                scatter.getRowVariable().setName(name);
                break;
            }
        }
    }

    private void setResponseVariableName(String name) {
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        switch (this.chartType) {
            case 0: {
                Bar bar = (Bar)this.chart;
                if (columnInfoUsed == 1) {
                    bar.getHeightVariable().setLabel(name);
                    break;
                }
                bar.getHeightVariable().setName(name);
                break;
            }
            case 1: {
                SegmentedBar sBar = (SegmentedBar)this.chart;
                if (columnInfoUsed == 1) {
                    sBar.getHeightVariable().setLabel(name);
                    break;
                }
                sBar.getHeightVariable().setName(name);
                break;
            }
            case 2: {
                Pie pie = (Pie)this.chart;
                if (columnInfoUsed == 1) {
                    pie.getWeightVariable().setLabel(name);
                    break;
                }
                pie.getWeightVariable().setName(name);
                break;
            }
            case 3: {
                Scatter scatter = (Scatter)this.chart;
                if (columnInfoUsed == 1) {
                    scatter.getHeightVariable().setLabel(name);
                    break;
                }
                scatter.getHeightVariable().setName(name);
                break;
            }
            default: {
                Overlay overlay = (Overlay)this.chart;
                if (columnInfoUsed == 1) {
                    overlay.getHeightVariables()[0].setLabel(name);
                    break;
                }
                overlay.getHeightVariables()[0].setName(name);
            }
        }
    }

    private void setGroupVariableName(String name) {
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        switch (this.chartType) {
            case 0: {
                Bar bar = (Bar)this.chart;
                if (columnInfoUsed == 1) {
                    bar.getGroupVariable().setLabel(name);
                    break;
                }
                bar.getGroupVariable().setName(name);
                break;
            }
            case 1: {
                SegmentedBar sBar = (SegmentedBar)this.chart;
                if (columnInfoUsed == 1) {
                    sBar.getGroupVariable().setLabel(name);
                    break;
                }
                sBar.getGroupVariable().setName(name);
                break;
            }
            case 3: {
                Scatter scatter = (Scatter)this.chart;
                if (columnInfoUsed == 1) {
                    scatter.getGroupVariable().setLabel(name);
                    break;
                }
                scatter.getGroupVariable().setName(name);
                break;
            }
        }
    }

    private void setSubGroupVariableName(String name) {
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        switch (this.chartType) {
            case 1: {
                SegmentedBar sBar = (SegmentedBar)this.chart;
                if (columnInfoUsed == 1) {
                    sBar.getSegmentVariable().setLabel(name);
                    break;
                }
                sBar.getSegmentVariable().setName(name);
                break;
            }
        }
    }

    private void setResponseColorVariableName(String name) {
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        switch (this.chartType) {
            case 0: {
                Bar bar = (Bar)this.chart;
                if (columnInfoUsed == 1) {
                    bar.getColorVariable().setLabel(name);
                    break;
                }
                bar.getColorVariable().setName(name);
                break;
            }
            case 3: {
                Scatter scatter = (Scatter)this.chart;
                if (columnInfoUsed == 1) {
                    scatter.getColorVariable().setLabel(name);
                    break;
                }
                scatter.getColorVariable().setName(name);
                break;
            }
        }
    }

    private void setResponseHeightVariableName(String name) {
        int columnInfoUsed = this.chart.getPopupColumnInfoUsed();
        switch (this.chartType) {
            case 2: {
                Pie pie = (Pie)this.chart;
                if (columnInfoUsed == 1) {
                    pie.getHeightVariable().setLabel(name);
                    break;
                }
                pie.getHeightVariable().setName(name);
                break;
            }
        }
    }

    private void makeListMenu(Menu menu, boolean numericalOnly, boolean required, boolean automatic) {
        this.makeListMenu(menu, numericalOnly, required, automatic, false);
    }

    private void makeListMenu(Menu menu, boolean numericalOnly, boolean required, boolean automatic, boolean nonNumericalOnly) {
        StaticTableInterface rd = this.chart.visualization.getRectangularData();
        if (rd == null) {
            return;
        }
        int maxVars = 0;
        try {
            int cols = rd.getColumnCount();
            if (!required) {
                ++maxVars;
            }
            if (automatic) {
                ++maxVars;
            }
            if (numericalOnly) {
                for (int i = 0; i < cols; ++i) {
                    Class colType = ((StaticRowTemplateTableInterface)rd).getColumnClass(i + 1);
                    if (colType == String.class) continue;
                    ++maxVars;
                }
            } else {
                maxVars += cols;
            }
            if (maxVars <= this.maxItems) {
                this.startVar = 0;
                this.makeVariableMenu(menu, numericalOnly, required, automatic, nonNumericalOnly);
            } else {
                int numLists = (int)((double)maxVars / (double)this.maxItems);
                if (maxVars % this.maxItems > 0) {
                    ++numLists;
                }
                String label = ChartPopupMenu.getString("list");
                this.startVar = 0;
                for (int i = 1; i <= numLists; ++i) {
                    String menuLabel = label + " " + i;
                    Menu list = new Menu(menuLabel);
                    this.makeVariableMenu(list, numericalOnly, required, automatic, nonNumericalOnly);
                    menu.add(list);
                }
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }
}

