/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.awt.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.graphics.chart.Bar;
import com.sas.graphics.chart.ChartPopupMenu;
import com.sas.graphics.chart.DataTipStyles;
import com.sas.graphics.chart.DepthTypes;
import com.sas.graphics.chart.Overlay;
import com.sas.graphics.chart.Pie;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.ResolutionTypes;
import com.sas.graphics.chart.SampleData;
import com.sas.graphics.chart.Scatter;
import com.sas.graphics.chart.SegmentedBar;
import com.sas.graphics.chart.TextStyle;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Visualization;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.mdtable.AxisChangedEvent;
import com.sas.mdtable.MdTo2dTable;
import com.sas.models.ColorList;
import com.sas.sasserver.summary.SummaryInterface;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import com.sas.util.Util;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.BorderInterface;
import com.sas.visuals.FullPaintInterface;
import com.sas.visuals.MessageBox;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class Chart
extends Component
implements Serializable,
PublicClonable,
ContentsChangedListener,
FullPaintInterface,
MouseListener,
MouseMotionListener,
PropertyChangeListener {
    static final long serialVersionUID = -5426087254761622208L;
    public static final String RB_KEY = "Chart.";
    private static final String[] requiredInterfacesString = new String[]{"com.sas.table.StaticRowTemplateTableInterface"};
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_LABEL = 1;
    protected Visualization visualization;
    protected Locale defaultLocale = Locale.getDefault();
    protected boolean hidePopupMenu = false;
    protected int popupColumnInfoUsed = 0;
    protected boolean swanStyleData = false;
    protected transient SampleData sample = null;
    protected transient Channel ch = null;
    protected transient ColorList colorList;
    private transient boolean updatable = true;
    private transient boolean holdVariables = false;
    private transient boolean refreshPopup;
    private ChartPopupMenu popup;
    static int defaultWidth = 320;
    static int defaultHeight = 240;
    static int minWidth = 160;
    static int minHeight = 120;
    static int UPDATE_ALL = 0;
    static int UPDATE_VISUALIZATION = 1;
    private transient int prevx;
    private transient int prevy;
    static final transient int NONE_DOWN = 0;
    static final transient int SHIFT_DOWN = 1;
    static final transient int ALT_DOWN = 2;
    static final transient int CONTROL_DOWN = 3;
    private transient int modifier;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "title"}, {"Short description", RB.getStringResource(RB_KEY, "title.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "title.pd.txt")}}, {{"Name", "titleStyle"}, {"Short description", RB.getStringResource(RB_KEY, "titleStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "titleStyle.pd.txt")}}, {{"Name", "font"}, {"Property editor class", "com.sas.beans.editors._NoSizeFontEditor"}}, {{"Name", "depth"}, {"Short description", RB.getStringResource(RB_KEY, "depth.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "depth.pd.txt")}, {"Property editor class", "com.sas.graphics.chart.ModifiedDepthTypesEditor"}}, {{"Name", "mapColors"}, {"Short description", RB.getStringResource(RB_KEY, "mapColors.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "mapColors.pd.txt")}, {"Hidden", "true"}}, {{"Name", "background"}, {"Short description", RB.getStringResource(RB_KEY, "background.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "background.pd.txt")}}, {{"Name", "outlineColor"}, {"Short description", RB.getStringResource(RB_KEY, "outlineColor.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "outlineColor.pd.txt")}}, {{"Name", "dataTipStyle"}, {"Short description", RB.getStringResource(RB_KEY, "dataTipStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "dataTipStyle.pd.txt")}, {"Property editor class", "com.sas.graphics.chart.ModifiedDataTipStylesEditor"}}, {{"Name", "categoryVariableName"}, {"Short description", RB.getStringResource(RB_KEY, "categoryVariableName.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "categoryVariableName.pd.txt")}}, {{"Name", "responseVariableName"}, {"Short description", RB.getStringResource(RB_KEY, "responseVariableName.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "responseVariableName.pd.txt")}}, {{"Name", "response2VariableName"}, {"Short description", RB.getStringResource(RB_KEY, "response2VariableName.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "response2VariableName.pd.txt")}}, {{"Name", "responseColorVariableName"}, {"Short description", RB.getStringResource(RB_KEY, "responseColorVariableName.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "responseColorVariableName.pd.txt")}}, {{"Name", "groupVariableName"}, {"Short description", RB.getStringResource(RB_KEY, "groupVariableName.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "groupVariableName.pd.txt")}}, {{"Name", "subGroupVariableName"}, {"Short description", RB.getStringResource(RB_KEY, "subGroupVariableName.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "subGroupVariableName.pd.txt")}}, {{"Name", "XVariableName"}, {"Short description", RB.getStringResource(RB_KEY, "XVariableName.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "XVariableName.pd.txt")}}, {{"Name", "responseHeightVariableName"}, {"Short description", RB.getStringResource(RB_KEY, "responseHeightVariableName.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "responseHeightVariableName.pd.txt")}}, {{"Name", "resolution"}, {"Short description", RB.getStringResource(RB_KEY, "resolution.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "resolution.pd.txt")}, {"Property editor class", "com.sas.graphics.chart.ModifiedResolutionTypesEditor"}, {"Expert", "true"}}, {{"Name", "datatipDoubleBuffered"}, {"Short description", RB.getStringResource(RB_KEY, "datatipDoubleBuffered.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "datatipDoubleBuffered.pd.txt")}, {"Expert", "true"}}, {{"Name", "backgroundImage"}, {"Hidden", "true"}}, {{"Name", "transparent"}, {"Hidden", "false"}}, {{"Name", "maxObservations"}, {"Short description", RB.getStringResource(RB_KEY, "maxObservations.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "maxObservations.pd.txt")}, {"Expert", "true"}}, {{"Name", "displayChartType"}, {"Short description", RB.getStringResource(RB_KEY, "displayChartType.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "displayChartType.pd.txt")}, {"Expert", "true"}}, {{"Name", "showStatistic"}, {"Short description", RB.getStringResource(RB_KEY, "showStatistic.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "showStatistic.pd.txt")}, {"Expert", "true"}}, {{"Name", "hidePopupMenu"}, {"Short description", RB.getStringResource(RB_KEY, "hidePopupMenu.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "hidePopupMenu.pd.txt")}, {"Expert", "true"}}, {{"Name", "popupMenuItems"}, {"Hidden", "true"}}, {{"Name", "popupColumnInfoUsed"}, {"Hidden", "true"}}, {{"Name", "3DPieChart"}, {"Hidden", "true"}}, {{"Name", "3DScatterPlot"}, {"Hidden", "true"}}, {{"Name", "riserChart"}, {"Hidden", "true"}}, {{"Name", "swanStyleData"}, {"Hidden", "true"}}, {{"Name", "variableHotspotsEnabled"}, {"Hidden", "true"}}, {{"Name", "variableHotspots"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension computePreferredSize() {
        return new Dimension(defaultWidth, defaultHeight);
    }

    @Override
    public void setPreferredSize(Dimension size) {
        if (size == null) {
            return;
        }
        size.width = Math.max(size.width, minWidth);
        size.height = Math.max(size.height, minHeight);
        super.setPreferredSize(size);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        BaseBorder border = new BaseBorder(2);
        border.setBorderWidth(1);
        super.setBorder(border);
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    @Override
    public void attachModel(ModelInterface mi) {
        if (mi == null) {
            return;
        }
        ModelInterface oldModel = this.getModelInterface();
        if (oldModel != null && oldModel instanceof ContentsChangedSource) {
            ((ContentsChangedSource)oldModel).removeContentsChangedListener((ContentsChangedListener)this);
        }
        super.attachModel(mi);
        if (mi instanceof ContentsChangedSource) {
            ((ContentsChangedSource)mi).addContentsChangedListener((ContentsChangedListener)this);
        }
        if (mi instanceof StaticRowTemplateTableInterface && mi instanceof StaticColumnLabelInterface) {
            this.visualization.setRectangularData((StaticTableInterface)mi);
        }
    }

    @Override
    public void detachModel(ModelInterface mi) {
        if (mi == null) {
            return;
        }
        super.detachModel(mi);
        if (mi instanceof StaticRowTemplateTableInterface && mi instanceof StaticColumnLabelInterface && !this.holdVariables) {
            this.visualization.resetVariables(false);
            if (!this.isDesignTime()) {
                this.visualization.invalidateVisualization();
            }
        }
        if (mi instanceof ContentsChangedSource) {
            ((ContentsChangedSource)mi).removeContentsChangedListener((ContentsChangedListener)this);
        }
    }

    @Override
    public void setModelInterface(ModelInterface mi) {
        if (mi == null || !(mi instanceof StaticRowTemplateTableInterface) || !(mi instanceof StaticColumnLabelInterface)) {
            super.setModelInterface(mi);
            return;
        }
        this.visualization.setRectangularData((StaticTableInterface)mi);
        if (this.visualization.validData()) {
            this.holdVariables = true;
            try {
                this.visualization.validVariables(true);
            }
            catch (VisualizationException e) {
                this.holdVariables = false;
            }
        }
        super.setModelInterface(mi);
        this.holdVariables = false;
    }

    @Override
    public void refresh(ModelInterface mi) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.isDesignTime()) {
            return;
        }
        ModelInterface si = this.getModelInterface();
        if (si != null) {
            ModelInterface modelInterface = si;
            synchronized (modelInterface) {
                if (si instanceof StaticRowTemplateTableInterface && si instanceof StaticColumnLabelInterface) {
                    this.visualization.setRectangularData((StaticTableInterface)si);
                    if (this.visualization.validData()) {
                        try {
                            this.visualization.validVariables(true);
                        }
                        catch (VisualizationException e) {
                            MessageBox.showModalMessageBox(e.getMessage());
                        }
                    }
                    this.updateViewer(UPDATE_ALL);
                }
            }
        }
    }

    protected void resetVariables() {
        this.visualization.resetVariables(false);
        this.setSummaryVariable("Category", this.getCategoryVariableName());
        this.setSummaryVariable("Group", this.getGroupVariableName());
        this.setSummaryVariable("Subgroup", this.getSubGroupVariableName());
        this.setSummaryVariable("Response", this.getResponseVariableName());
        this.setSummaryVariable("ResponseColor", this.getResponseColorVariableName());
        this.updateViewer(UPDATE_ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentsChanged(ContentsChangedEvent event) {
        ModelInterface si = this.getModelInterface();
        if (si != null) {
            ModelInterface modelInterface = si;
            synchronized (modelInterface) {
                if (si instanceof StaticRowTemplateTableInterface && si instanceof StaticColumnLabelInterface) {
                    this.visualization.setRectangularData((StaticTableInterface)si);
                    if (!this.visualization.validData()) {
                        this.updateViewer(UPDATE_ALL);
                        return;
                    }
                    try {
                        if (event instanceof AxisChangedEvent) {
                            Variable[] classifiers = this.visualization.getClassifierVariables();
                            ModelInterface model = this.getModelInterface();
                            if (model instanceof MdTo2dTable) {
                                MdTo2dTable mdTo2dTable = (MdTo2dTable)model;
                                if (classifiers != null) {
                                    for (int ii = 0; ii < classifiers.length; ++ii) {
                                        String columnName;
                                        String variableName;
                                        if (classifiers[ii] == null || (variableName = classifiers[ii].getName()) == null || variableName.equalsIgnoreCase(columnName = Chart._getMdTo2dTableColumnName(mdTo2dTable, classifiers[ii].getIndex()))) continue;
                                        Class columnType = this._getMdTo2dTableColumnType(mdTo2dTable, classifiers[ii].getIndex());
                                        if (columnType == String.class) {
                                            classifiers[ii].setName(columnName);
                                            continue;
                                        }
                                        classifiers[ii].setAutomatic(true);
                                    }
                                }
                            }
                        }
                        this.visualization.validVariables(true);
                    }
                    catch (VisualizationException e) {
                        this.visualization.resetVariables(false);
                    }
                    this.updateViewer(UPDATE_ALL);
                }
            }
        }
    }

    private static String _getMdTo2dTableColumnName(MdTo2dTable mdTo2dTable, int index) {
        if (mdTo2dTable != null && index > 0) {
            try {
                return (String)mdTo2dTable.getColumnLabel(index);
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
        return null;
    }

    private Class _getMdTo2dTableColumnType(MdTo2dTable mdTo2dTable, int index) {
        if (mdTo2dTable != null && index > 0) {
            try {
                return mdTo2dTable.getColumnClass(index);
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propertyName = pce.getPropertyName();
        Object source = pce.getSource();
        if (propertyName == null) {
            return;
        }
        if (source instanceof TextStyle) {
            TextStyle style = (TextStyle)source;
            if (Util.equal((Object)style.textStyle, (Object)this.visualization.getTitleStyle())) {
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("titleStyle", null, source);
            }
        } else if (source instanceof BaseBorder) {
            BaseBorder border = (BaseBorder)((Object)source);
            Insets insets = border.getInsets();
            String text = border.getText();
            if (text == null || text.equals("")) {
                this.visualization.setIndents(insets.left, insets.right, insets.top, insets.bottom);
            } else {
                Font font = border.getFont();
                FontMetrics fm1 = Toolkit.getDefaultToolkit().getFontMetrics(border.getFont());
                int textht = fm1.getHeight();
                this.visualization.setIndents(insets.left, insets.right, insets.top + textht, insets.bottom);
            }
            this.updateViewer(UPDATE_VISUALIZATION);
        }
    }

    public Chart() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addPropertyChangeListener(this);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.updatable = true;
        if (this.popup != null) {
            this.refreshPopup = true;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.ch == null) {
            this.initializeChannel();
        }
        this.setSize(this.getWidth(), this.getHeight());
        if (this.updatable || !this.isDesignTime()) {
            this.updateViewer(UPDATE_ALL);
        }
    }

    protected String getDefaultTitle(Locale locale) {
        ResourceBundle RB2 = ResourceBundle.getBundle("com.sas.graphics.chart.Resources", locale);
        String defaultTitle = this instanceof Bar ? RB2.getString("Bar.defaultTitle.txt") : (this instanceof SegmentedBar ? RB2.getString("SegmentedBar.defaultTitle.txt") : (this instanceof Scatter ? RB2.getString("Scatter.defaultTitle.txt") : (this instanceof Pie ? RB2.getString("Pie.defaultTitle.txt") : (this instanceof Overlay ? RB2.getString("Overlay.defaultTitle.txt") : ""))));
        return defaultTitle;
    }

    private void initializeChannel() {
        this.ch = new Channel(this);
        this.ch.addNotify();
        BorderInterface border = this.getBorder();
        Insets insets = border.getInsets();
        if (border instanceof BaseBorder) {
            BaseBorder bborder = (BaseBorder)border;
            String text = bborder.getText();
            if (text == null || text.equals("")) {
                this.visualization.setIndents(insets.left, insets.right, insets.top, insets.bottom);
            } else {
                Font font = bborder.getFont();
                FontMetrics fm1 = Toolkit.getDefaultToolkit().getFontMetrics(bborder.getFont());
                int textht = fm1.getHeight();
                this.visualization.setIndents(insets.left, insets.right, insets.top + textht, insets.bottom);
            }
        } else {
            this.visualization.setIndents(insets.left, insets.right, insets.top, insets.bottom);
        }
    }

    protected void resetDefaultTitle() {
        if (this.defaultLocale != null && !this.defaultLocale.equals(Locale.getDefault())) {
            String oldDefaultTitle = this.getDefaultTitle(this.defaultLocale);
            if (Util.equal((Object)this.getTitle(), (Object)oldDefaultTitle)) {
                this.setTitle(this.getDefaultTitle(Locale.getDefault()));
            }
        }
        this.defaultLocale = Locale.getDefault();
    }

    @Override
    public void initialize() {
        if (this.sample == null) {
            this.sample = new SampleData();
        }
        this.resetDefaultTitle();
        this.resetNoneVariables();
        this.visualization.resetVariables(true);
        if (this.ch == null) {
            this.initializeChannel();
        }
        this.setSize(this.getWidth(), this.getHeight());
        this.updateViewer(UPDATE_ALL);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean changed = true;
        if (x == this.getHorizontalPosition() && y == this.getVerticalPosition() && width == this.getWidth() && height == this.getHeight()) {
            changed = false;
        }
        super.setBounds(x, y, width, height);
        if (this.ch != null) {
            if (width <= 0 || height <= 0) {
                return;
            }
            BorderInterface border = this.getBorder();
            Insets insets = border.getInsets();
            if (border instanceof BaseBorder) {
                BaseBorder bborder = (BaseBorder)border;
                String text = bborder.getText();
                if (text == null || text.equals("")) {
                    this.visualization.setIndents(insets.left, insets.right, insets.top, insets.bottom);
                } else {
                    Font font = bborder.getFont();
                    FontMetrics fm1 = Toolkit.getDefaultToolkit().getFontMetrics(bborder.getFont());
                    int textht = fm1.getHeight();
                    this.visualization.setIndents(insets.left, insets.right, insets.top + textht, insets.bottom);
                }
            } else {
                this.visualization.setIndents(insets.left, insets.right, insets.top, insets.bottom);
            }
            this.ch.glViewport(width, height, insets);
            if (this.isTransparent()) {
                java.awt.Component cmp = this.ch.getComponent();
                if (cmp.getParent() == null) {
                    this.ch.setBackgroundColor(this.getBackground());
                } else {
                    this.ch.setBackgroundColor(cmp.getParent().getBackground());
                }
                this.ch.setBackbuffer(2);
                this.ch.clearBGC();
                this.ch.setBackbuffer(0);
                this.ch.clearBGC();
            }
            if (changed) {
                this.updateViewer(UPDATE_VISUALIZATION);
            }
        }
    }

    @Override
    public void setSize(int width, int height) {
        boolean changed = true;
        if (width == this.getWidth() && height == this.getHeight()) {
            changed = false;
        }
        super.setSize(width, height);
        if (this.ch != null) {
            if (width <= 0 || height <= 0) {
                return;
            }
            BorderInterface border = this.getBorder();
            Insets insets = border.getInsets();
            if (border instanceof BaseBorder) {
                BaseBorder bborder = (BaseBorder)border;
                String text = bborder.getText();
                if (text == null || text.equals("")) {
                    this.visualization.setIndents(insets.left, insets.right, insets.top, insets.bottom);
                } else {
                    Font font = bborder.getFont();
                    FontMetrics fm1 = Toolkit.getDefaultToolkit().getFontMetrics(bborder.getFont());
                    int textht = fm1.getHeight();
                    this.visualization.setIndents(insets.left, insets.right, insets.top + textht, insets.bottom);
                }
            } else {
                this.visualization.setIndents(insets.left, insets.right, insets.top, insets.bottom);
            }
            this.ch.glViewport(width, height, insets);
            if (this.isTransparent()) {
                java.awt.Component cmp = this.ch.getComponent();
                if (cmp.getParent() == null) {
                    this.ch.setBackgroundColor(this.getBackground());
                } else {
                    this.ch.setBackgroundColor(cmp.getParent().getBackground());
                }
                this.ch.setBackbuffer(2);
                this.ch.clearBGC();
                this.ch.setBackbuffer(0);
                this.ch.clearBGC();
            }
            if (changed) {
                this.updateViewer(UPDATE_VISUALIZATION);
            }
        }
    }

    @Override
    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    @Override
    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    @Override
    public void setHorizontalPosition(int hPosition) {
        this.setBounds(hPosition, this.getVerticalPosition(), this.getWidth(), this.getHeight());
    }

    @Override
    public void setVerticalPosition(int vPosition) {
        this.setBounds(this.getHorizontalPosition(), vPosition, this.getWidth(), this.getHeight());
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.ch == null) {
            this.initializeChannel();
            if (!this.isDesignTime()) {
                this.updateViewer(UPDATE_ALL);
            }
        }
        super.paint(g);
        if (this.ch != null) {
            this.visualization.showChart(this.ch, g);
        }
    }

    public synchronized void directPaint(Graphics g) {
        super.paint(g);
        if (this.ch != null) {
            this.visualization.drawChart(this.ch, g);
        }
    }

    public String getTitle() {
        return this.visualization.getTitle();
    }

    public void setTitle(String title) {
        String oldValue = this.getTitle();
        if (Util.equal((Object)title, (Object)oldValue)) {
            return;
        }
        this.visualization.setTitle(title);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("title", oldValue, title);
    }

    public TextStyle getTitleStyle() {
        TextStyle titleStyle = new TextStyle();
        titleStyle.textStyle = this.visualization.getTitleStyle();
        titleStyle.addPropertyChangeListener(this);
        return titleStyle;
    }

    public void setTitleStyle(TextStyle titleStyle) {
        if (titleStyle == null || Util.equal((Object)titleStyle.textStyle, (Object)this.visualization.getTitleStyle())) {
            return;
        }
        TextStyle oldValue = new TextStyle();
        oldValue.textStyle = this.visualization.getTitleStyle();
        this.visualization.setTitleStyle(titleStyle.textStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("titleStyle", oldValue, titleStyle);
    }

    public DepthTypes getDepth() {
        return DepthTypes.getEnum(this.visualization.getDepth());
    }

    public void setDepth(DepthTypes depth) {
        if (depth.getValue() == this.visualization.getDepth()) {
            return;
        }
        DepthTypes oldValue = this.getDepth();
        this.visualization.setDepth(depth.getValue());
        this.visualization.resetView(this.ch);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("depth", (Object)oldValue, (Object)depth);
    }

    public ColorList getMapColors() {
        Vector colors = this.visualization.getMapColors();
        this.colorList = colors == null ? new ColorList() : new ColorList(colors.elements());
        this.colorList.addPropertyChangeListener(this);
        return this.colorList;
    }

    public void setMapColors(ColorList mapColors) {
        this.colorList = mapColors;
        this.updateMapColors();
    }

    protected void updateMapColors() {
        Vector colors = new Vector();
        Enumeration e = this.colorList.getColors();
        while (e.hasMoreElements()) {
            colors.addElement(e.nextElement());
        }
        this.visualization.setMapColors(colors);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("mapColors", null, (Object)this.colorList);
    }

    @Override
    public boolean isTransparent() {
        return this.visualization.isTransparent();
    }

    public ResolutionTypes getResolution() {
        return ResolutionTypes.getEnum(this.visualization.getResolution());
    }

    public void setResolution(ResolutionTypes resolution) {
        if (resolution.getValue() == this.visualization.getResolution()) {
            return;
        }
        ResolutionTypes oldValue = this.getResolution();
        this.visualization.setResolution(resolution.getValue());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("resolution", (Object)oldValue, (Object)resolution);
    }

    @Override
    public Color getBackground() {
        return this.visualization.getBackgroundColor();
    }

    @Override
    public void setForeground(Color newColor) {
        if (newColor == null || newColor == this.getForeground()) {
            return;
        }
        super.setForeground(newColor);
        this.setForegroundColor(newColor);
    }

    @Override
    public void setForegroundColor(Color newColor) {
        if (newColor == null || newColor == this.getForeground()) {
            return;
        }
        super.setForegroundColor(newColor);
        TextStyle temp = this.getTitleStyle();
        temp.setColor(newColor);
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (newFont == null) {
            return;
        }
        TextStyle temp = this.getTitleStyle();
        temp.setBold(newFont.isBold());
        String fontFamily = newFont.getFamily();
        int dotPlace = fontFamily.indexOf(".");
        if (dotPlace != -1) {
            fontFamily = fontFamily.substring(0, dotPlace);
        }
        temp.setFontFamily(fontFamily);
        temp.setItalic(newFont.isItalic());
    }

    @Override
    public void setBorder(BorderInterface borderIn) {
        super.setBorder(borderIn);
        Insets insets = borderIn.getInsets();
        if (this.visualization == null) {
            return;
        }
        if (borderIn instanceof BaseBorder) {
            BaseBorder bborder = (BaseBorder)borderIn;
            String text = bborder.getText();
            if (text == null || text.equals("")) {
                this.visualization.setIndents(insets.left, insets.right, insets.top, insets.bottom);
            } else {
                Font font = bborder.getFont();
                FontMetrics fm1 = Toolkit.getDefaultToolkit().getFontMetrics(bborder.getFont());
                int textht = fm1.getHeight();
                this.visualization.setIndents(insets.left, insets.right, insets.top + textht, insets.bottom);
            }
        } else {
            this.visualization.setIndents(insets.left, insets.right, insets.top, insets.bottom);
        }
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("border", null, borderIn);
    }

    @Override
    public void setTransparent(boolean transparent) {
        if (this.visualization == null) {
            return;
        }
        boolean oldValue = this.visualization.isTransparent();
        if (transparent == oldValue) {
            return;
        }
        this.visualization.setTransparent(transparent);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("transparent", new Boolean(oldValue), new Boolean(transparent));
        super.setTransparent(transparent);
    }

    @Override
    public void setBackground(Color backgroundColorIn) {
        if (this.visualization == null) {
            return;
        }
        Color oldValue = this.visualization.getBackgroundColor();
        if (Util.equal((Object)backgroundColorIn, (Object)oldValue)) {
            return;
        }
        super.setBackground(backgroundColorIn);
        this.visualization.setBackgroundColor(backgroundColorIn);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("background", oldValue, backgroundColorIn);
    }

    public Color getOutlineColor() {
        return this.visualization.getEdgeColor();
    }

    public void setOutlineColor(Color outlineColorIn) {
        Color oldValue = this.getOutlineColor();
        if (Util.equal((Object)outlineColorIn, (Object)oldValue)) {
            return;
        }
        this.visualization.setEdgeColor(outlineColorIn);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("outlineColor", oldValue, outlineColorIn);
    }

    public DataTipStyles getDataTipStyle() {
        return DataTipStyles.getEnum(this.visualization.getPickMode());
    }

    public void setDataTipStyle(DataTipStyles style) {
        if (style.getValue() == this.visualization.getPickMode()) {
            return;
        }
        DataTipStyles oldValue = this.getDataTipStyle();
        this.visualization.setPickMode(style.getValue());
        this.firePropertyChange("dataTipStyle", (Object)oldValue, (Object)style);
    }

    public boolean isDatatipDoubleBuffered() {
        return this.visualization.isPickDoubleBuffered();
    }

    public void setDatatipDoubleBuffered(boolean doubleBuffered) {
        boolean oldValue = this.isDatatipDoubleBuffered();
        if (doubleBuffered == oldValue) {
            return;
        }
        this.visualization.setPickDoubleBuffered(doubleBuffered);
        this.firePropertyChange("datatipDoubleBuffered", new Boolean(oldValue), new Boolean(doubleBuffered));
    }

    public int getMaxObservations() {
        return this.visualization.getMaxObservations();
    }

    public void setMaxObservations(int maxObs) {
        int oldValue = this.getMaxObservations();
        if (maxObs == oldValue) {
            return;
        }
        this.visualization.setMaxObservations(Math.max(0, maxObs));
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("maxObservations", new Integer(oldValue), new Integer(maxObs));
    }

    public boolean isShowStatistic() {
        return this.visualization.isShowStatistic();
    }

    public void setShowStatistic(boolean showStatistic) {
        boolean oldValue = this.isShowStatistic();
        if (showStatistic == oldValue) {
            return;
        }
        this.visualization.setShowStatistic(showStatistic);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("showStatistic", new Boolean(oldValue), new Boolean(showStatistic));
    }

    public boolean isDisplayChartType() {
        return this.visualization.isDisplayChartType();
    }

    public void setDisplayChartType(boolean displayChartType) {
        boolean oldValue = this.isDisplayChartType();
        if (displayChartType == oldValue) {
            return;
        }
        this.visualization.setDisplayChartType(displayChartType);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("displayChartType", new Boolean(oldValue), new Boolean(displayChartType));
    }

    public MenuItem[] getPopupMenuItems() {
        return this.getPopupMenu(true).getMainMenuItems();
    }

    private ChartPopupMenu getPopupMenu(boolean create) {
        ChartPopupMenu cpm = this.popup;
        if (cpm == null) {
            if (!create) {
                return null;
            }
            cpm = new ChartPopupMenu(this);
            cpm.initialize();
            this.add(cpm);
            this.popup = cpm;
        } else if (this.refreshPopup) {
            cpm.setChart(this);
            cpm.initialize();
            this.refreshPopup = false;
        }
        return cpm;
    }

    public boolean isHidePopupMenu() {
        return this.hidePopupMenu;
    }

    public void setHidePopupMenu(boolean hide) {
        this.hidePopupMenu = hide;
    }

    public boolean isSwanStyleData() {
        return this.swanStyleData;
    }

    public void setSwanStyleData(boolean swanStyle) {
        this.swanStyleData = swanStyle;
    }

    public boolean isRiserChart() {
        return this.visualization.isRiserChart();
    }

    public boolean is3DScatterPlot() {
        return this.visualization.is3DScatterPlot();
    }

    public boolean is3DPieChart() {
        return this.visualization.is3DPieChart();
    }

    @Override
    public void disableFullPaint() {
        this.updatable = false;
    }

    @Override
    public void enableFullPaint() {
        if (this.visualization.validData()) {
            try {
                this.visualization.validVariables(true);
            }
            catch (VisualizationException e) {
                MessageBox.showModalMessageBox(e.getMessage());
            }
        }
        this.updatable = true;
        this.updateViewer(UPDATE_ALL);
    }

    private void setSampleColumnLabels() {
        String name;
        if (this instanceof Scatter) {
            name = this.getXVariableName();
            if (name != null && !name.trim().equals("")) {
                this.sample.setColumnLabel(1, name);
            } else {
                this.sample.setColumnLabel(1, RB.getStringResource(RB_KEY, "designTime.XLabel.txt"));
            }
            name = this.getResponseVariableName();
            if (name != null && !name.trim().equals("")) {
                this.sample.setColumnLabel(2, name);
            } else {
                this.sample.setColumnLabel(2, RB.getStringResource(RB_KEY, "designTime.YLabel.txt"));
            }
        } else {
            name = this.getCategoryVariableName();
            if (name != null && !name.trim().equals("")) {
                this.sample.setColumnLabel(1, name);
            } else {
                this.sample.setColumnLabel(1, RB.getStringResource(RB_KEY, "designTime.categoryLabel.txt"));
            }
            name = this.getResponseVariableName();
            if (name != null && !name.trim().equals("")) {
                this.sample.setColumnLabel(2, name);
            } else {
                this.sample.setColumnLabel(2, RB.getStringResource(RB_KEY, "designTime.responseLabel.txt"));
            }
        }
        name = this.getSubGroupVariableName();
        if (name != null && !name.trim().equals("")) {
            this.sample.setColumnLabel(3, name);
        } else {
            this.sample.setColumnLabel(3, RB.getStringResource(RB_KEY, "designTime.subgroupLabel.txt"));
        }
        name = this.getGroupVariableName();
        if (name != null && !name.trim().equals("")) {
            this.sample.setColumnLabel(4, name);
        } else if (this instanceof Scatter) {
            name = this.getZVariableName();
            if (name != null && !name.trim().equals("")) {
                this.sample.setColumnLabel(4, name);
            } else {
                this.sample.setColumnLabel(4, RB.getStringResource(RB_KEY, "designTime.groupLabel.txt"));
            }
        } else if (this instanceof Bar || this instanceof SegmentedBar) {
            name = this.getDepthVariableName();
            if (name != null && !name.trim().equals("")) {
                this.sample.setColumnLabel(4, name);
            } else {
                this.sample.setColumnLabel(4, RB.getStringResource(RB_KEY, "designTime.groupLabel.txt"));
            }
        } else {
            this.sample.setColumnLabel(4, RB.getStringResource(RB_KEY, "designTime.groupLabel.txt"));
        }
        if (this instanceof Overlay) {
            name = this.getResponse2VariableName();
            if (name != null && !name.trim().equals("")) {
                this.sample.setColumnLabel(5, name);
            } else {
                this.sample.setColumnLabel(5, RB.getStringResource(RB_KEY, "designTime.response2Label.txt"));
            }
        } else if (this instanceof Pie) {
            name = this.getResponseHeightVariableName();
            if (name != null && !name.trim().equals("")) {
                this.sample.setColumnLabel(5, name);
            } else {
                this.sample.setColumnLabel(5, RB.getStringResource(RB_KEY, "designTime.responseHeightLabel.txt"));
            }
        } else {
            name = this.getResponseColorVariableName();
            if (name != null && !name.trim().equals("")) {
                this.sample.setColumnLabel(5, name);
            } else {
                this.sample.setColumnLabel(5, RB.getStringResource(RB_KEY, "designTime.responseColorLabel.txt"));
            }
        }
    }

    protected void resetNoneVariables() {
    }

    protected void updateViewer(int flag) {
        if (this.isDesignTime() && this.ch != null && this.sample != null) {
            this.setSampleColumnLabels();
            this.visualization.setRectangularData((StaticTableInterface)this.sample);
            this.visualization.footnote = RB.getStringResource(RB_KEY, "designTime.footnote.txt");
        } else {
            this.visualization.footnote = null;
        }
        if (this.ch != null && this.updatable) {
            try {
                ChartPopupMenu cpm = this.getPopupMenu(false);
                if (flag == UPDATE_ALL || this.isDesignTime()) {
                    this.visualization.makeModel(this.ch);
                    if (cpm != null) {
                        cpm.updateVariablesMenu();
                    }
                }
                if (cpm != null) {
                    cpm.updateVisualsMenu();
                }
                this.visualization.makeChart(this.ch);
            }
            catch (OutOfMemoryError e) {
                this.ch.glEndList();
                this.visualization.invalidateVisualization(this.ch);
                System.out.println(RB.getStringResource(RB_KEY, "outOfMem.txt"));
            }
            catch (VisualizationException e) {
                System.out.println(e.getMessage());
            }
            finally {
                this.repaint();
            }
        }
    }

    public synchronized void resetView() {
        this.visualization.resetView(this.ch);
    }

    @Override
    public synchronized void mouseClicked(MouseEvent e) {
    }

    @Override
    public synchronized void mouseMoved(MouseEvent e) {
        int dataScrollbarLoc = this.visualization.isDataLocation(this.ch, e.getX(), e.getY());
        if (dataScrollbarLoc < 9) {
            switch (dataScrollbarLoc) {
                case 0: 
                case 1: 
                case 2: {
                    this.setCursor(new Cursor(11));
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.setCursor(new Cursor(6));
                    break;
                }
                default: {
                    this.setCursor(Cursor.getDefaultCursor());
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.setCursor(new Cursor(8));
                    break;
                }
            }
        } else if (this.visualization.isScrollableLocation(this.ch, e.getX(), e.getY())) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            this.visualization.probeChart(this.ch, e.getX(), e.getY());
        }
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.prevx = e.getX();
        this.prevy = e.getY();
        this.visualization.beginScrolling(this.ch, e.getX(), e.getY());
        this.modifier = e.isShiftDown() ? 1 : (e.isAltDown() ? 2 : (e.isControlDown() ? 3 : 0));
        this.visualization.beginRotating(this.ch);
        this.visualization.pickChart(this.ch, e.getX(), e.getY());
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
        if (!this.hidePopupMenu && (e.isPopupTrigger() || (e.getModifiers() & 4) != 0)) {
            this.getPopupMenu(true).show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        this.visualization.stopScrolling(this.ch, e.getX(), e.getY());
        this.visualization.stopRotating(this.ch);
        this.visualization.stopDataScrolling(this.ch);
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        int curx = e.getX();
        int cury = e.getY();
        switch (this.modifier) {
            default: {
                this.visualization.doScrolling(this.ch, curx, cury, this.prevx, this.prevy);
                this.visualization.doDataScrolling(this.ch, curx, cury, this.prevx, this.prevy);
                break;
            }
            case 1: {
                this.visualization.doRotating(this.ch, curx, cury, this.prevx, this.prevy);
                break;
            }
            case 2: {
                this.visualization.doZooming(this.ch, curx, cury, this.prevx, this.prevy);
                break;
            }
            case 3: {
                this.visualization.doPanning(this.ch, curx, cury, this.prevx, this.prevy);
            }
        }
        this.prevx = curx;
        this.prevy = cury;
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        if (this.ch == null || this.ch.getBackbufferGC() == null || this.ch.getGraphics() == null) {
            return;
        }
        this.ch.glRefresh((Graphics2D)this.getGraphics());
    }

    public String getCategoryVariableName() {
        return null;
    }

    public void setCategoryVariableName(String name) {
    }

    public String getXVariableName() {
        return null;
    }

    public void setXVariableName(String name) {
    }

    public String getGroupVariableName() {
        return null;
    }

    public String getDepthVariableName() {
        return null;
    }

    public void setDepthVariableName(String name) {
    }

    public String getZVariableName() {
        return null;
    }

    public void setZVariableName(String name) {
    }

    public void setGroupVariableName(String name) {
    }

    public String getSubGroupVariableName() {
        return null;
    }

    public void setSubGroupVariableName(String name) {
    }

    public String getResponseVariableName() {
        return null;
    }

    public void setResponseVariableName(String name) {
    }

    public String getResponse2VariableName() {
        return null;
    }

    public void setResponse2VariableName(String name) {
    }

    public String getResponseColorVariableName() {
        return null;
    }

    public void setResponseColorVariableName(String name) {
    }

    public String getResponseHeightVariableName() {
        return null;
    }

    public void setResponseHeightVariableName(String name) {
    }

    public Image getBackgroundImage() {
        return this.visualization.getBackgroundImage();
    }

    public void setBackgroundImage(Image image) {
        this.visualization.setBackgroundImage(image);
    }

    public void setBackgroundImage(Image image, boolean scale, int x, int y) {
        this.visualization.setBackgroundImage(image, scale, false, x, y);
    }

    protected void setSummaryVariable(String role, String name) {
        if (!this.isDesignTime()) {
            return;
        }
        ModelInterface model = this.getModelInterface();
        if (model instanceof SummaryInterface) {
            SummaryInterface summary = (SummaryInterface)model;
            if (role.equals("Category")) {
                summary.setCategoryName(name);
            } else if (role.equals("Response")) {
                summary.setResponseName(name);
            } else if (role.equals("ResponseColor")) {
                summary.setResponseColorName(name);
            } else if (role.equals("Group")) {
                summary.setGroupName(name);
            } else if (role.equals("Subgroup")) {
                summary.setSubGroupName(name);
            }
        }
    }

    protected boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public synchronized void print(Graphics g) {
        this.paint(g);
    }

    public void removeDataDependency() {
        this.visualization.resetVariables(true);
    }

    public void setPopupColumnInfoUsed(int used) {
        if (used < 0 || used > 1) {
            return;
        }
        int oldValue = this.popupColumnInfoUsed;
        if (oldValue == used) {
            return;
        }
        this.popupColumnInfoUsed = used;
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("popupColumnInfoUsed", new Integer(oldValue), new Integer(used));
    }

    public int getPopupColumnInfoUsed() {
        return this.popupColumnInfoUsed;
    }

    public abstract void setVariableHotspotsEnabled(boolean var1);

    public abstract boolean isVariableHotspotsEnabled();

    public abstract Blob[] getVariableHotspots();
}

