/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.ContinuousColorLegendStyle;
import com.sas.graphics.chart.DependentVariable;
import com.sas.graphics.chart.Group;
import com.sas.graphics.chart.LegendStyle;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.TextStyle;
import com.sas.graphics.chart.Variable;
import com.sas.graphics.util.visualize.ColorBar;
import com.sas.graphics.util.visualize.HorizontalBar;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.VerticalBar;
import com.sas.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;

public class Bar
extends Group
implements Serializable {
    static final long serialVersionUID = 611627388779797257L;
    public static final String RB_KEY = "Bar.";
    protected ColorBar colorBar = new VerticalBar(RB.getStringResource("Bar.", "defaultTitle.txt"));
    protected boolean vertical = true;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "colorVariable"}, {"Short description", RB.getStringResource(RB_KEY, "colorVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "colorVariable.pd.txt")}}, {{"Name", "colorLegendStyle"}, {"Short description", RB.getStringResource(RB_KEY, "colorLegendStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "colorLegendStyle.pd.txt")}}, {{"Name", "vertical"}, {"Short description", RB.getStringResource(RB_KEY, "vertical.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "vertical.pd.txt")}}, {{"Name", "subGroupVariableName"}, {"Hidden", "true"}}, {{"Name", "XVariableName"}, {"Hidden", "true"}}, {{"Name", "ZVariableName"}, {"Hidden", "true"}}, {{"Name", "response2VariableName"}, {"Hidden", "true"}}, {{"Name", "responseHeightVariableName"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Bar() {
        this.bar = this.colorBar;
        this.cityscape = this.colorBar;
        this.visualization = this.colorBar;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Variable variable;
        String propertyName = pce.getPropertyName();
        if (propertyName == null) {
            return;
        }
        Object source = pce.getSource();
        if (source instanceof LegendStyle) {
            LegendStyle legend = (LegendStyle)source;
            if (Util.equal((Object)legend.legendStyle, (Object)this.colorBar.getColorLegendStyle())) {
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("colorLegendStyle", null, source);
            }
        } else if (source instanceof Variable && Util.equal((Object)(variable = (Variable)source).getVariable(), (Object)this.colorBar.getColorVariable())) {
            this.setSummaryVariable("ResponseColor", variable.getName());
            this.updateViewer(UPDATE_ALL);
            this.firePropertyChange("colorVariable", null, source);
        }
        super.propertyChange(pce);
    }

    public DependentVariable getColorVariable() {
        DependentVariable colorVariable;
        com.sas.graphics.util.visualize.DependentVariable v = this.colorBar.getColorVariable();
        if (v == null) {
            colorVariable = null;
        } else {
            colorVariable = new DependentVariable();
            colorVariable.setDependentVariable(v);
            colorVariable.addPropertyChangeListener(this);
        }
        return colorVariable;
    }

    public void setColorVariable(DependentVariable colorVariable) {
        DependentVariable oldValue;
        com.sas.graphics.util.visualize.DependentVariable v = this.colorBar.getColorVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new DependentVariable();
            oldValue.setDependentVariable(v);
        }
        if (colorVariable == null) {
            this.colorBar.setColorVariable(null);
        } else {
            if (Util.equal((Object)colorVariable.getVariable(), (Object)this.colorBar.getColorVariable())) {
                return;
            }
            this.colorBar.setColorVariable(colorVariable.getDependentVariable());
            this.setSummaryVariable("ResponseColor", colorVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("colorVariable", oldValue, colorVariable);
    }

    @Override
    public void setForegroundColor(Color newColor) {
        if (newColor == null || newColor == this.getForeground()) {
            return;
        }
        super.setForegroundColor(newColor);
        ContinuousColorLegendStyle tempColorLegendStyle = this.getColorLegendStyle();
        TextStyle tempLabelStyle = tempColorLegendStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        TextStyle tempValueStyle = tempColorLegendStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (newFont == null) {
            return;
        }
        boolean isBold = newFont.isBold();
        boolean isItalic = newFont.isItalic();
        String fontFamily = newFont.getFamily();
        int dotPlace = fontFamily.indexOf(".");
        if (dotPlace != -1) {
            fontFamily = fontFamily.substring(0, dotPlace);
        }
        ContinuousColorLegendStyle tempColorLegendStyle = this.getColorLegendStyle();
        TextStyle tempLabelStyle = tempColorLegendStyle.getLabelStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        TextStyle tempValueStyle = tempColorLegendStyle.getValueStyle();
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
    }

    public ContinuousColorLegendStyle getColorLegendStyle() {
        ContinuousColorLegendStyle colorLegendStyle = new ContinuousColorLegendStyle();
        colorLegendStyle.setLegendStyle(this.colorBar.getColorLegendStyle());
        colorLegendStyle.addPropertyChangeListener(this);
        return colorLegendStyle;
    }

    public void setColorLegendStyle(ContinuousColorLegendStyle colorLegendStyle) {
        if (colorLegendStyle == null || Util.equal((Object)colorLegendStyle.getLegendStyle(), (Object)this.colorBar.getColorLegendStyle())) {
            return;
        }
        ContinuousColorLegendStyle oldValue = new ContinuousColorLegendStyle();
        oldValue.setLegendStyle(this.colorBar.getColorLegendStyle());
        this.colorBar.setColorLegendStyle(colorLegendStyle.getLegendStyle());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("colorLegendStyle", oldValue, colorLegendStyle);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        boolean oldValue = this.vertical;
        if (vertical == oldValue) {
            return;
        }
        this.vertical = vertical;
        this.colorBar = vertical ? new VerticalBar(this.colorBar) : new HorizontalBar(this.colorBar);
        this.bar = this.colorBar;
        this.cityscape = this.colorBar;
        this.visualization = this.colorBar;
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("vertical", new Boolean(oldValue), new Boolean(vertical));
    }

    public String getClickedRow(boolean formatted) {
        return this.colorBar.getClickedRow(formatted);
    }

    public String getClickedColumn(boolean formatted) {
        return this.colorBar.getClickedColumn(formatted);
    }

    public String getClickedHeight(boolean formatted) {
        return this.colorBar.getClickedHeight(formatted);
    }

    public String getClickedColor(boolean formatted) {
        return this.colorBar.getClickedColor(formatted);
    }

    public String getClickedGroup(boolean formatted) {
        return this.colorBar.getClickedGroup(formatted);
    }

    @Override
    public String getCategoryVariableName() {
        IndependentVariable v = this.colorBar.getColumnVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setCategoryVariableName(String name) {
        String oldValue = this.getCategoryVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        IndependentVariable v = this.colorBar.getColumnVariable();
        if (v == null) {
            v = new IndependentVariable();
            v.setName(name);
            this.colorBar.setColumnVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Category", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("categoryVariableName", oldValue, name);
    }

    @Override
    public String getDepthVariableName() {
        IndependentVariable v = this.colorBar.getRowVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setDepthVariableName(String name) {
        String oldValue = this.getDepthVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        IndependentVariable v = this.colorBar.getRowVariable();
        if (v == null) {
            v = new IndependentVariable();
            v.setName(name);
            this.colorBar.setRowVariable(v);
        } else {
            v.setName(name);
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("depthVariableName", oldValue, name);
    }

    @Override
    public String getResponseColorVariableName() {
        com.sas.graphics.util.visualize.DependentVariable v = this.colorBar.getColorVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setResponseColorVariableName(String name) {
        String oldValue = this.getResponseColorVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.DependentVariable v = this.colorBar.getColorVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.DependentVariable();
            v.setName(name);
            this.colorBar.setColorVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("ResponseColor", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("responseColorVariableName", oldValue, name);
    }

    @Override
    protected void resetNoneVariables() {
        com.sas.graphics.util.visualize.Variable variable = this.colorBar.getRowVariable();
        if (variable != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.colorBar.getColumnVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.colorBar.getHeightVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.colorBar.getColorVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.colorBar.getGroupVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Bar clone = (Bar)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.initialize();
            clone.setTitle(this.getTitle());
            clone.setTitleStyle(this.getTitleStyle());
            clone.setDepth(this.getDepth());
            clone.setMapColors(this.getMapColors());
            clone.setBackground(this.getBackground());
            clone.setBackgroundImage(this.getBackgroundImage());
            clone.setTransparent(this.isTransparent());
            clone.setOutlineColor(this.getOutlineColor());
            clone.setDataTipStyle(this.getDataTipStyle());
            clone.setResolution(this.getResolution());
            clone.setDatatipDoubleBuffered(this.isDatatipDoubleBuffered());
            clone.setMaxObservations(this.getMaxObservations());
            clone.setDisplayChartType(this.isDisplayChartType());
            clone.setShowStatistic(this.isShowStatistic());
            clone.setHidePopupMenu(this.isHidePopupMenu());
            clone.setPopupColumnInfoUsed(this.getPopupColumnInfoUsed());
            clone.setSwanStyleData(this.isSwanStyleData());
            clone.setBackplaneVisible(this.isBackplaneVisible());
            clone.setBackplaneColor(this.getBackplaneColor());
            clone.setRowVariable(this.getRowVariable());
            clone.setRowAxisStyle(this.getRowAxisStyle());
            clone.setColumnVariable(this.getColumnVariable());
            clone.setColumnAxisStyle(this.getColumnAxisStyle());
            clone.setHeightVariable(this.getHeightVariable());
            clone.setHeightAxisStyle(this.getHeightAxisStyle());
            clone.setGroupVariable(this.getGroupVariable());
            clone.setGroupAxisStyle(this.getGroupAxisStyle());
            clone.setGeometryType(this.getGeometryType());
            clone.setGeometrySize(this.getGeometrySize());
            clone.setAbsoluteSize(this.isAbsoluteSize());
            clone.setAbsoluteGeometrySize(this.getAbsoluteGeometrySize());
            clone.setColorVariable(this.getColorVariable());
            clone.setColorLegendStyle(this.getColorLegendStyle());
            clone.setVertical(this.isVertical());
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }
}

