/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics;

import com.sas.visuals.ResizeToFitInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class ElasticHandles {
    public static int handleWidth = 6;
    public static int handleHeight = 6;
    public static int nosizeWidth = 3;
    public static int nosizeHeight = 3;
    static int style = 0;
    public static final int moveHandle = -1;
    public static final int noHit = 0;
    public static final int nwHandle = 1;
    public static final int wHandle = 2;
    public static final int swHandle = 3;
    public static final int neHandle = 4;
    public static final int eHandle = 5;
    public static final int seHandle = 6;
    public static final int nHandle = 7;
    public static final int sHandle = 8;
    public static final int DEFAULT = 0;
    public static final int DROPSITE = 1;
    public static final int SINGLESELECT = 1;
    public static final int MULTISELECT = 2;
    public static final int NOSIZE = 8;

    public static void setStyle(int s) {
        style = s;
    }

    public static int getStyle() {
        return style;
    }

    public static Rectangle getStyleBounds(Component comp) {
        style = 0;
        if (comp instanceof ResizeToFitInterface && ((ResizeToFitInterface)comp).isResizeToFit()) {
            style = 8;
        }
        return ElasticHandles.getBounds(comp);
    }

    public static Rectangle getBounds(Component comp) {
        return ElasticHandles.getBounds(comp.getBounds());
    }

    public static Rectangle getBounds(Rectangle bounds) {
        int hwidth = (style & 8) != 0 ? Math.max(nosizeWidth, nosizeHeight) : Math.max(handleWidth, handleHeight);
        bounds.grow(hwidth, hwidth);
        return bounds;
    }

    public static boolean isInside(Component comp, int dx, int dy) {
        int hHeight;
        int hWidth;
        Rectangle bounds = comp.getBounds();
        if ((style & 8) != 0) {
            hWidth = nosizeWidth;
            hHeight = nosizeHeight;
        } else {
            hWidth = handleWidth;
            hHeight = handleHeight;
        }
        int x = bounds.x - hWidth;
        int y = bounds.y - hHeight;
        int width = bounds.width + 2 * hWidth;
        int height = bounds.height + 2 * hHeight;
        if (dx >= x && dy >= y && dx <= x + width && dy <= y + height) {
            if (dy <= y + hHeight || dy >= y + height - hHeight) {
                return true;
            }
            return dx <= x + hWidth || dx >= x + width - hWidth;
        }
        return false;
    }

    public static int hitHandle(Component comp, int dx, int dy) {
        return ElasticHandles.hitHandle(comp, comp.getBounds(), dx, dy);
    }

    public static int hitHandle(Component comp, Rectangle bounds, int dx, int dy) {
        int hHeight;
        int hWidth;
        style = 0;
        if (comp instanceof ResizeToFitInterface && ((ResizeToFitInterface)comp).isResizeToFit()) {
            style = 8;
        }
        if ((style & 8) != 0) {
            hWidth = nosizeWidth;
            hHeight = nosizeHeight;
        } else {
            hWidth = handleWidth;
            hHeight = handleHeight;
        }
        int x = bounds.x - hWidth;
        int y = bounds.y - hHeight;
        int width = bounds.width + 2 * hWidth;
        int height = bounds.height + 2 * hHeight;
        if (dx < x || dy < y || dx > x + width || dy > y + height) {
            return 0;
        }
        dy -= y;
        int max = Math.max(hWidth, hHeight);
        if ((dx -= x) < max) {
            if ((style & 8) == 0) {
                if (dx < hWidth && dy < hHeight || dx < hHeight && dy < hWidth) {
                    return 1;
                }
                if (dx < hWidth && dy > height - hHeight || dx < hHeight && dy > height - hWidth) {
                    return 3;
                }
                if (dy > (height - hHeight) / 2 && dy < (height + hHeight) / 2) {
                    return 2;
                }
            }
            return -1;
        }
        if (dx >= width - max) {
            if ((style & 8) == 0) {
                if (dx > width - hWidth && dy < hHeight || dx > width - hHeight && dy < hWidth) {
                    return 4;
                }
                if (dx > width - hWidth && dy > height - hHeight || dx > width - hHeight && dy > height - hWidth) {
                    return 6;
                }
                if (dy > (height - hHeight) / 2 && dy < (height + hHeight) / 2) {
                    return 5;
                }
            }
            return -1;
        }
        if ((style & 8) == 0 && dx > (width - hWidth) / 2 && dx < (width + hWidth) / 2) {
            if (dy < hHeight) {
                return 7;
            }
            if (dy >= height - hHeight) {
                return 8;
            }
        }
        return -1;
    }

    public static Cursor handleCursor(Component comp, int dx, int dy) {
        return ElasticHandles.handleCursor(ElasticHandles.hitHandle(comp, dx, dy));
    }

    public static Cursor handleCursor(int hitType) {
        int cursorType = 0;
        switch (hitType) {
            case -1: {
                cursorType = 13;
                break;
            }
            case 1: {
                cursorType = 6;
                break;
            }
            case 2: {
                cursorType = 10;
                break;
            }
            case 3: {
                cursorType = 4;
                break;
            }
            case 4: {
                cursorType = 7;
                break;
            }
            case 5: {
                cursorType = 11;
                break;
            }
            case 6: {
                cursorType = 5;
                break;
            }
            case 7: {
                cursorType = 8;
                break;
            }
            case 8: {
                cursorType = 9;
                break;
            }
            default: {
                cursorType = 0;
            }
        }
        return Cursor.getPredefinedCursor(cursorType);
    }

    public static void paint(Component comp, Graphics g) {
        int hHeight;
        int hWidth;
        if (comp == null || g == null) {
            return;
        }
        int Style2 = style & 0xFFFFFFF7;
        int nosize = style & 8;
        Rectangle bounds = ElasticHandles.getBounds(comp);
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds != null && !bounds.intersects(clipBounds)) {
            return;
        }
        bounds = comp.getBounds();
        if (nosize != 0) {
            hWidth = nosizeWidth;
            hHeight = nosizeHeight;
        } else {
            hWidth = handleWidth;
            hHeight = handleHeight;
        }
        int x = bounds.x - hWidth;
        int y = bounds.y - hHeight;
        int width = bounds.width + 2 * hWidth;
        int height = bounds.height + 2 * hHeight;
        Color fore = comp.getParent().getForeground();
        if (nosize != 0) {
            if (Style2 == 1 || Style2 == 2) {
                if (Style2 == 1) {
                    g.setColor(SystemColor.activeCaption);
                    g.fillRect(x, y, hWidth - 1, height);
                    g.fillRect(x, y, width, hHeight - 1);
                    g.fillRect(x + width - hWidth, y, hWidth - 1, height);
                    g.fillRect(x, y + height - hHeight, width, hHeight - 1);
                }
                g.setColor(fore);
                g.drawRect(x, y, width - 1, height - 1);
            }
        } else if (Style2 == 2) {
            int tmphHeight = hHeight - 1;
            int tmphWidth = hWidth - 1;
            g.setColor(fore);
            g.drawRect(x, y, tmphWidth, tmphHeight);
            g.drawRect(x + width - hWidth, y + height - hHeight, tmphWidth, tmphHeight);
            g.drawRect(x + width - hWidth, y, tmphWidth, tmphHeight);
            g.drawRect(x, y + height - hHeight, tmphWidth, tmphHeight);
            g.drawRect(x + width / 2 - hWidth / 2, y, tmphWidth, tmphHeight);
            g.drawRect(x + width / 2 - hWidth / 2, y + height - hHeight, tmphWidth, tmphHeight);
            g.drawRect(x, y + height / 2 - hHeight / 2, tmphWidth, tmphHeight);
            g.drawRect(x + width - hWidth, y + height / 2 - hHeight / 2, tmphWidth, tmphHeight);
        } else if (Style2 == 1) {
            int tmphHeight = hHeight - 1;
            int tmphWidth = hWidth - 1;
            g.setColor(SystemColor.activeCaption);
            g.fillRect(x, y, tmphWidth, tmphHeight);
            g.fillRect(x + width - hWidth, y + height - hHeight, tmphWidth, tmphHeight);
            g.fillRect(x + width - hWidth, y, tmphWidth, tmphHeight);
            g.fillRect(x, y + height - hHeight, tmphWidth, tmphHeight);
            g.fillRect(x + width / 2 - hWidth / 2, y, tmphWidth, tmphHeight);
            g.fillRect(x + width / 2 - hWidth / 2, y + height - hHeight, tmphWidth, tmphHeight);
            g.fillRect(x, y + height / 2 - hHeight / 2, tmphWidth, tmphHeight);
            g.fillRect(x + width - hWidth, y + height / 2 - hHeight / 2, tmphWidth, tmphHeight);
            g.setColor(fore);
            g.drawRect(x, y, tmphWidth, tmphHeight);
            g.drawRect(x + width - hWidth, y + height - hHeight, tmphWidth, tmphHeight);
            g.drawRect(x + width - hWidth, y, tmphWidth, tmphHeight);
            g.drawRect(x, y + height - hHeight, tmphWidth, tmphHeight);
            g.drawRect(x + width / 2 - hWidth / 2, y, tmphWidth, tmphHeight);
            g.drawRect(x + width / 2 - hWidth / 2, y + height - hHeight, tmphWidth, tmphHeight);
            g.drawRect(x, y + height / 2 - hHeight / 2, tmphWidth, tmphHeight);
            g.drawRect(x + width - hWidth, y + height / 2 - hHeight / 2, tmphWidth, tmphHeight);
        }
        g.drawRect(bounds.x - 1, bounds.y - 1, bounds.width + 1, bounds.height + 1);
        style = 0;
    }

    public static void fillStiple(Graphics g, int x, int y, int w, int h) {
        for (int i = 0; i < h; i += 2) {
            for (int j = 0; j < w; j += 2) {
                g.drawLine(x + j, y + i, x + j, y + i);
                g.drawLine(x + j + 1, y + i + 1, x + j + 1, y + i + 1);
            }
        }
    }
}

